/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.RandomWalkSTBetweenness;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.Vertex;
import java.util.Iterator;

public class RandomWalkBetweenness
extends RandomWalkSTBetweenness {
    public static final String CENTRALITY = "centrality.RandomWalkBetweennessCentrality";

    public RandomWalkBetweenness(UndirectedGraph g) {
        super(g, null, null);
    }

    protected void computeBetweenness() {
        this.setUp();
        int numVertices = this.getGraph().numVertices();
        double normalizingConstant = (double)(numVertices * (numVertices - 1)) / 2.0;
        Iterator iIt = this.getGraph().getVertices().iterator();
        while (iIt.hasNext()) {
            Vertex ithVertex = (Vertex)iIt.next();
            double ithBetweenness = 0.0;
            for (int t = 0; t < numVertices; ++t) {
                for (int s = 0; s < t; ++s) {
                    Vertex sthVertex = (Vertex)this.getIndexer().getVertex(s);
                    Vertex tthVertex = (Vertex)this.getIndexer().getVertex(t);
                    ithBetweenness += this.computeSTBetweenness(ithVertex, sthVertex, tthVertex);
                }
            }
            this.setRankScore(ithVertex, ithBetweenness / normalizingConstant);
        }
    }

    public String getRankScoreKey() {
        return CENTRALITY;
    }

    protected double evaluateIteration() {
        this.computeBetweenness();
        return 0.0;
    }
}

