/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.AbstractSparseVertex;
import edu.uci.ics.jung.graph.predicates.ParallelEdgePredicate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class SimpleSparseVertex
extends AbstractSparseVertex {
    protected Map mPredsToInEdges;
    protected Map mSuccsToOutEdges;
    protected Map mNeighborsToEdges;

    public Set getPredecessors() {
        Collection preds = CollectionUtils.union(this.getPredsToInEdges().keySet(), this.getNeighborsToEdges().keySet());
        return Collections.unmodifiableSet(new HashSet(preds));
    }

    public Set getSuccessors() {
        Collection succs = CollectionUtils.union(this.getSuccsToOutEdges().keySet(), this.getNeighborsToEdges().keySet());
        return Collections.unmodifiableSet(new HashSet(succs));
    }

    public int inDegree() {
        return this.getInEdges().size();
    }

    public int outDegree() {
        return this.getOutEdges().size();
    }

    public int numPredecessors() {
        return this.getPredsToInEdges().size();
    }

    public int numSuccessors() {
        return this.getSuccsToOutEdges().size();
    }

    public boolean isSuccessorOf(Vertex v) {
        return this.getPredsToInEdges().containsKey(v) || this.getNeighborsToEdges().containsKey(v);
    }

    public boolean isPredecessorOf(Vertex v) {
        return this.getSuccsToOutEdges().containsKey(v) || this.getNeighborsToEdges().containsKey(v);
    }

    public boolean isSource(Edge e) {
        if (e instanceof DirectedEdge) {
            if (e.getGraph() == this.getGraph()) {
                return this == ((DirectedEdge)e).getSource();
            }
            return false;
        }
        if (e instanceof UndirectedEdge) {
            return this.isIncident(e);
        }
        throw new IllegalArgumentException("Edge is neither directed nor undirected");
    }

    public boolean isDest(Edge e) {
        if (e instanceof DirectedEdge) {
            if (e.getGraph() == this.getGraph()) {
                return this == ((DirectedEdge)e).getDest();
            }
            return false;
        }
        if (e instanceof UndirectedEdge) {
            return this.isIncident(e);
        }
        throw new IllegalArgumentException("Edge is neither directed nor undirected");
    }

    public Set getInEdges() {
        Collection inEdges = this.getPredsToInEdges().values();
        Collection adjacentEdges = this.getNeighborsToEdges().values();
        HashSet edges = new HashSet();
        if (inEdges != null) {
            edges.addAll(inEdges);
        }
        if (adjacentEdges != null) {
            edges.addAll(adjacentEdges);
        }
        return Collections.unmodifiableSet(edges);
    }

    public Set getOutEdges() {
        Collection outEdges = this.getSuccsToOutEdges().values();
        Collection adjacentEdges = this.getNeighborsToEdges().values();
        HashSet edges = new HashSet();
        if (outEdges != null) {
            edges.addAll(outEdges);
        }
        if (adjacentEdges != null) {
            edges.addAll(adjacentEdges);
        }
        return Collections.unmodifiableSet(edges);
    }

    public Edge findEdge(Vertex v) {
        Edge e = (Edge)this.getSuccsToOutEdges().get(v);
        if (e != null) {
            return e;
        }
        e = (Edge)this.getNeighborsToEdges().get(v);
        return e;
    }

    public Set findEdgeSet(Vertex v) {
        HashSet<Edge> s = new HashSet<Edge>();
        Edge d = (Edge)this.getSuccsToOutEdges().get(v);
        Edge u = (Edge)this.getNeighborsToEdges().get(v);
        if (d != null) {
            s.add(d);
        }
        if (u != null) {
            s.add(u);
        }
        return Collections.unmodifiableSet(s);
    }

    protected Collection getNeighbors_internal() {
        HashSet neighbors = new HashSet();
        neighbors.addAll(this.getPredsToInEdges().keySet());
        neighbors.addAll(this.getSuccsToOutEdges().keySet());
        neighbors.addAll(this.getNeighborsToEdges().keySet());
        return neighbors;
    }

    protected Map getPredsToInEdges() {
        if (this.mPredsToInEdges == null) {
            this.setPredsToInEdges(new HashMap(5));
        }
        return this.mPredsToInEdges;
    }

    protected void setPredsToInEdges(Map predsToInEdges) {
        this.mPredsToInEdges = predsToInEdges;
    }

    protected Map getSuccsToOutEdges() {
        if (this.mSuccsToOutEdges == null) {
            this.setSuccsToOutEdges(new HashMap(5));
        }
        return this.mSuccsToOutEdges;
    }

    protected void setSuccsToOutEdges(Map succsToOutEdges) {
        this.mSuccsToOutEdges = succsToOutEdges;
    }

    protected Map getNeighborsToEdges() {
        if (this.mNeighborsToEdges == null) {
            this.setNeighborsToEdges(new HashMap(5));
        }
        return this.mNeighborsToEdges;
    }

    protected void setNeighborsToEdges(Map neighborsToEdges) {
        this.mNeighborsToEdges = neighborsToEdges;
    }

    protected void initialize() {
        super.initialize();
        this.setPredsToInEdges(null);
        this.setSuccsToOutEdges(null);
        this.setNeighborsToEdges(null);
    }

    protected Collection getEdges_internal() {
        HashSet edges = new HashSet();
        Collection inEdges = this.getPredsToInEdges().values();
        Collection outEdges = this.getSuccsToOutEdges().values();
        Collection adjacentEdges = this.getNeighborsToEdges().values();
        if (inEdges != null) {
            edges.addAll(inEdges);
        }
        if (outEdges != null) {
            edges.addAll(outEdges);
        }
        if (adjacentEdges != null) {
            edges.addAll(adjacentEdges);
        }
        return edges;
    }

    protected void addNeighbor_internal(Edge e, Vertex v) {
        if (ParallelEdgePredicate.getInstance().evaluate(e)) {
            throw new IllegalArgumentException("This vertex implementation does not support parallel edges");
        }
        if (e instanceof DirectedEdge) {
            DirectedEdge de = (DirectedEdge)e;
            boolean added = false;
            if (this == de.getSource()) {
                this.getSuccsToOutEdges().put(v, e);
                added = true;
            }
            if (this == de.getDest()) {
                this.getPredsToInEdges().put(v, e);
                added = true;
            }
            if (!added) {
                throw new IllegalArgumentException("Internal error: this vertex is not incident to " + e);
            }
        } else if (e instanceof UndirectedEdge) {
            this.getNeighborsToEdges().put(v, e);
        } else {
            throw new IllegalArgumentException("Edge is neither directednor undirected");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void removeNeighbor_internal(Edge e, Vertex v) {
        String error = "Internal error: edge " + e + " not incident to vertex ";
        if (e instanceof DirectedEdge) {
            if (this.getSuccsToOutEdges().containsKey(v) && v.isDest(e)) {
                if (this.getSuccsToOutEdges().remove(v) != null) return;
                throw new FatalException(error + v);
            }
            if (!this.getPredsToInEdges().containsKey(v) || !v.isSource(e)) throw new FatalException(error + this);
            if (this.getPredsToInEdges().remove(v) != null) return;
            throw new FatalException(error + v);
        }
        if (!(e instanceof UndirectedEdge)) throw new IllegalArgumentException("Edge is neither directednor undirected");
        Map nte = this.getNeighborsToEdges();
        if (nte.get(v) == e) {
            nte.remove(v);
            return;
        } else {
            if (this == v) return;
            throw new FatalException(error + v);
        }
    }
}

