/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.impl.crooked;

import edu.uci.ics.jung.graph.Edge;
import samples.preview_new_graphdraw.CoordinateUtil;
import samples.preview_new_graphdraw.Coordinates;
import samples.preview_new_graphdraw.VisEdge;
import samples.preview_new_graphdraw.VisVertex;
import samples.preview_new_graphdraw.iterablelayouts.SpringLayout;

public class CrookedSpringLayout
extends SpringLayout {
    protected VisEdge createVisEdge(Edge ve, VisVertex front, VisVertex back) {
        return new CrookedSpringEdge(ve, front, back);
    }

    protected static class CrookedSpringEdge
    extends SpringLayout.SpringEdge {
        public VisEdge copy(VisVertex front, VisVertex back) {
            return new CrookedSpringEdge(this.mEdge, front, back);
        }

        public CrookedSpringEdge(Edge ve, VisVertex front, VisVertex back) {
            super(ve, front, back);
        }

        public Coordinates calcMidpoint() {
            Coordinates m = CoordinateUtil.midpoint(this.getFront(), this.getBack());
            Coordinates c = new Coordinates(this.getFront().getX(), this.getBack().getY());
            return CoordinateUtil.midpoint(m, c);
        }

        public double getSquareDistance(double x, double y) {
            Coordinates crook = this.calcMidpoint();
            double dist1 = CoordinateUtil.squareDistanceLineToPoint(this.getFront(), crook, x, y);
            double dist2 = CoordinateUtil.squareDistanceLineToPoint(this.getBack(), crook, x, y);
            return Math.min(dist1, dist2);
        }
    }
}

