/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTClassDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTResultType;
import net.sourceforge.pmd.ast.ASTType;
import net.sourceforge.pmd.ast.SimpleNode;

public class CouplingBetweenObjectsRule
extends AbstractRule {
    private String className;
    private int couplingCount;
    private Set typesFoundSoFar;

    public Object visit(ASTCompilationUnit cu, Object data) {
        this.typesFoundSoFar = new HashSet();
        this.couplingCount = 0;
        Object returnObj = cu.childrenAccept(this, data);
        if (this.couplingCount > this.getIntProperty("threshold")) {
            RuleContext ctx = (RuleContext)data;
            ctx.getReport().addRuleViolation(this.createRuleViolation(ctx, cu.getBeginLine(), "A value of " + this.couplingCount + " may denote a high amount of coupling within the class"));
        }
        return returnObj;
    }

    public Object visit(ASTClassDeclaration node, Object data) {
        SimpleNode firstStmt = (SimpleNode)node.jjtGetChild(0);
        this.className = firstStmt.getImage();
        return super.visit(node, data);
    }

    public Object visit(ASTResultType node, Object data) {
        int x = 0;
        while (x < node.jjtGetNumChildren()) {
            SimpleNode nameNode;
            SimpleNode tNode = (SimpleNode)node.jjtGetChild(x);
            if (tNode instanceof ASTType && (nameNode = (SimpleNode)tNode.jjtGetChild(0)) instanceof ASTName) {
                this.checkVariableType(nameNode.getImage());
            }
            ++x;
        }
        return super.visit(node, data);
    }

    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        this.handleASTTypeChildren(node);
        return super.visit(node, data);
    }

    public Object visit(ASTFormalParameter node, Object data) {
        this.handleASTTypeChildren(node);
        return super.visit(node, data);
    }

    public Object visit(ASTFieldDeclaration node, Object data) {
        int x = 0;
        while (x < node.jjtGetNumChildren()) {
            SimpleNode firstStmt = (SimpleNode)node.jjtGetChild(x);
            if (firstStmt instanceof ASTType) {
                ASTType tp = (ASTType)firstStmt;
                SimpleNode nd = (SimpleNode)tp.jjtGetChild(0);
                this.checkVariableType(nd.getImage());
            }
            ++x;
        }
        return super.visit(node, data);
    }

    private void handleASTTypeChildren(SimpleNode node) {
        int x = 0;
        while (x < node.jjtGetNumChildren()) {
            SimpleNode sNode = (SimpleNode)node.jjtGetChild(x);
            if (sNode instanceof ASTType) {
                SimpleNode nameNode = (SimpleNode)sNode.jjtGetChild(0);
                this.checkVariableType(nameNode.getImage());
            }
            ++x;
        }
    }

    private void checkVariableType(String variableType) {
        if (!(this.className.equals(variableType) || this.filterTypes(variableType) || this.typesFoundSoFar.contains(variableType))) {
            ++this.couplingCount;
            this.typesFoundSoFar.add(variableType);
        }
    }

    private boolean filterTypes(String variableType) {
        return variableType.startsWith("java.lang.") || variableType.equals("String") || this.filterPrimativesAndWrappers(variableType);
    }

    private boolean filterPrimativesAndWrappers(String variableType) {
        return variableType.equals("int") || variableType.equals("Integer") || variableType.equals("char") || variableType.equals("Character") || variableType.equalsIgnoreCase("double") || variableType.equalsIgnoreCase("long") || variableType.equalsIgnoreCase("short") || variableType.equalsIgnoreCase("float") || variableType.equalsIgnoreCase("byte") || variableType.equalsIgnoreCase("boolean");
    }
}

