/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Vector;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreePath;
import net.sourceforge.pmd.swingui.DirectoryTree;
import net.sourceforge.pmd.swingui.DirectoryTreeNode;

class DirectoryTableModel
extends DefaultTableModel {
    private DateFormat m_dateFormat;
    private DecimalFormat m_decimalFormat;
    private String m_fileExtension;
    protected static final int FILE_NAME_COLUMN = 0;
    protected static final int FILE_SIZE_COLUMN = 1;
    protected static final int FILE_LAST_MODIFIED_COLUMN = 2;
    private final int FILE_COLUMN = 3;

    protected DirectoryTableModel(DirectoryTree directoryTree, String fileExtension) {
        super(DirectoryTableModel.createData(), DirectoryTableModel.createColumnNames());
        this.m_fileExtension = fileExtension.toLowerCase();
        this.m_dateFormat = DateFormat.getDateTimeInstance();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        StringBuffer buffer = new StringBuffer(25);
        buffer.append('#');
        buffer.append(decimalFormatSymbols.getGroupingSeparator());
        buffer.append('#');
        buffer.append('#');
        buffer.append(decimalFormatSymbols.getDigit());
        buffer.append(" lines");
        String pattern = buffer.toString();
        this.m_decimalFormat = new DecimalFormat(pattern, decimalFormatSymbols);
        new DirectoryTreeSelectionListener(directoryTree);
    }

    private static Vector createData() {
        return new Vector();
    }

    private static Vector createColumnNames() {
        Vector<String> row = new Vector<String>(2);
        row.add("File Name");
        row.add("Size");
        row.add("Last Modified");
        return row;
    }

    protected File getFile(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            return (File)this.getValueAt(row, 3);
        }
        return null;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    private class FilesFilter
    implements FileFilter {
        private FilesFilter() {
        }

        public boolean accept(File file) {
            if (file.isFile() && !file.isHidden()) {
                String fileName = file.getName().toLowerCase();
                return fileName.endsWith(DirectoryTableModel.this.m_fileExtension);
            }
            return false;
        }
    }

    private class DirectoryTreeSelectionListener
    implements TreeSelectionListener {
        private DirectoryTreeSelectionListener(DirectoryTree directoryTree) {
            directoryTree.addTreeSelectionListener(this);
        }

        public void valueChanged(TreeSelectionEvent event) {
            File directory;
            File[] files;
            TreePath treePath = event.getPath();
            DirectoryTreeNode treeNode = (DirectoryTreeNode)treePath.getLastPathComponent();
            Object userObject = treeNode.getUserObject();
            Vector<Vector> rows = DirectoryTableModel.this.getDataVector();
            int n = 0;
            while (n < rows.size()) {
                rows.get(n).clear();
                ++n;
            }
            rows.clear();
            if (userObject instanceof File && (files = (directory = (File)userObject).listFiles(new FilesFilter())) != null) {
                int n1 = 0;
                while (n1 < files.length) {
                    Vector<Object> row = new Vector<Object>(3);
                    String fileName = files[n1].getName();
                    int lineCount = this.countLines(files[n1]);
                    String size = DirectoryTableModel.this.m_decimalFormat.format(lineCount);
                    Date date = new Date(files[n1].lastModified());
                    String lastModified = DirectoryTableModel.this.m_dateFormat.format(date);
                    row.add(fileName);
                    row.add(size);
                    row.add(lastModified);
                    row.add(files[n1]);
                    rows.add(row);
                    ++n1;
                }
            }
            DirectoryTableModel.this.fireTableDataChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int countLines(File file) {
            int lineCount = 0;
            InputStreamReader reader = null;
            char[] buffer = new char[10000];
            reader = new InputStreamReader(new FileInputStream(file));
            while (reader.ready()) {
                int numberOfChars = reader.read(buffer);
                int n = 0;
                while (n < numberOfChars) {
                    if (buffer[n] == '\n') {
                        ++lineCount;
                    }
                    ++n;
                }
            }
            Object var8_9 = null;
            if (reader == null) return lineCount;
            try {
                reader.close();
                return lineCount;
            }
            catch (IOException exception2) {}
            return lineCount;
            {
                catch (FileNotFoundException exception) {
                    lineCount = 0;
                    Object var8_10 = null;
                    if (reader == null) return lineCount;
                    try {
                        reader.close();
                        return lineCount;
                    }
                    catch (IOException exception2) {}
                    return lineCount;
                }
                catch (IOException exception) {
                    lineCount = 0;
                    Object var8_11 = null;
                    if (reader == null) return lineCount;
                    try {
                        reader.close();
                        return lineCount;
                    }
                    catch (IOException exception2) {}
                    return lineCount;
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException exception2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

