/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.Stack;
import net.sourceforge.pmd.ast.ASTBlock;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTForStatement;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTSwitchStatement;
import net.sourceforge.pmd.ast.ASTTryStatement;
import net.sourceforge.pmd.ast.ASTUnmodifiedClassDeclaration;
import net.sourceforge.pmd.ast.ASTUnmodifiedInterfaceDeclaration;
import net.sourceforge.pmd.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.GlobalScope;
import net.sourceforge.pmd.symboltable.Scope;
import net.sourceforge.pmd.symboltable.ScopeFactory;

public class ScopeCreator
extends JavaParserVisitorAdapter {
    private ScopeFactory sf = new ScopeFactory();
    private Stack scopes = new Stack();

    public Object visit(ASTCompilationUnit node, Object data) {
        this.openScope(node);
        return data;
    }

    public Object visit(ASTUnmodifiedClassDeclaration node, Object data) {
        this.openScope(node);
        return data;
    }

    public Object visit(ASTUnmodifiedInterfaceDeclaration node, Object data) {
        this.openScope(node);
        return data;
    }

    public Object visit(ASTBlock node, Object data) {
        this.openScope(node);
        return data;
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.openScope(node);
        return data;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        this.openScope(node);
        return data;
    }

    public Object visit(ASTTryStatement node, Object data) {
        this.openScope(node);
        return data;
    }

    public Object visit(ASTForStatement node, Object data) {
        this.openScope(node);
        return data;
    }

    public Object visit(ASTIfStatement node, Object data) {
        this.openScope(node);
        return data;
    }

    public Object visit(ASTSwitchStatement node, Object data) {
        this.openScope(node);
        return data;
    }

    private void push(Scope scope) {
        if (this.scopes.empty()) {
            if (!(scope instanceof GlobalScope)) {
                throw new RuntimeException("First scope should be a GlobalScope");
            }
        } else {
            scope.setParent((Scope)this.scopes.peek());
        }
        this.scopes.add(scope);
    }

    private void openScope(SimpleNode node) {
        Scope scope = this.sf.createScope(node);
        this.push(scope);
        node.setScope((Scope)this.scopes.peek());
        super.visit(node, null);
        this.scopes.pop();
    }
}

