/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.cpd;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.JavaTokenizer;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.MatchAlgorithm;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.Tokens;

public class MatchAlgorithmTest
extends TestCase {
    public static final String LINE_1 = "public class Foo { ";
    public static final String LINE_2 = " public void bar() {";
    public static final String LINE_3 = "  System.out.println(\"hello\");";
    public static final String LINE_4 = " System.out.println(\"hello\");";
    public static final String LINE_5 = " }";
    public static final String LINE_6 = "}";

    public static String getSampleCode() {
        return LINE_1 + CPD.EOL + LINE_2 + CPD.EOL + LINE_3 + CPD.EOL + LINE_4 + CPD.EOL + LINE_5 + CPD.EOL + LINE_6;
    }

    public void testSimple() throws Throwable {
        String code = MatchAlgorithmTest.getSampleCode();
        JavaTokenizer tokenizer = new JavaTokenizer();
        SourceCode sourceCode = new SourceCode("Foo.java");
        Tokens tokens = new Tokens();
        tokenizer.tokenize(sourceCode, tokens, new StringReader(code));
        Assert.assertEquals((int)29, (int)tokens.size());
        HashMap<String, SourceCode> codeMap = new HashMap<String, SourceCode>();
        codeMap.put("Foo.java", sourceCode);
        MatchAlgorithm matchAlgorithm = new MatchAlgorithm(codeMap, tokens);
        matchAlgorithm.findMatches(5);
        Iterator matches = matchAlgorithm.matches();
        Match match = (Match)matches.next();
        Assert.assertFalse((boolean)matches.hasNext());
        Iterator marks = match.iterator();
        Mark mark1 = (Mark)marks.next();
        Mark mark2 = (Mark)marks.next();
        Assert.assertTrue((!marks.hasNext() ? 1 : 0) != 0);
        Assert.assertEquals((int)2, (int)mark2.getBeginLine());
        Assert.assertEquals((int)3, (int)mark1.getBeginLine());
        Assert.assertTrue(("Foo.java" == mark1.getTokenSrcID() && "Foo.java" == mark2.getTokenSrcID() ? 1 : 0) != 0);
        Assert.assertEquals((String)LINE_3, (String)match.getSourceCodeSlice());
    }
}

