/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.rules;

import net.sourceforge.pmd.rules.XPathRule;
import test.net.sourceforge.pmd.rules.AvoidDeeplyNestedIfStmtsRuleTest;
import test.net.sourceforge.pmd.rules.AvoidDuplicateLiteralsRuleTest;
import test.net.sourceforge.pmd.rules.AvoidReassigningParametersRuleTest;
import test.net.sourceforge.pmd.rules.RuleTst;

public class XPathRuleTest
extends RuleTst {
    XPathRule rule;

    public void setUp() {
        this.rule = new XPathRule();
        this.rule.setMessage("XPath Rule Failed");
    }

    public void testDeeplyNestedIfStmtsRule() throws Throwable {
        this.rule.addProperty("xpath", "//IfStatement[count(ancestor::IfStatement[not(Statement[2])]) > {0}]");
        this.rule.addProperty("subst", "1");
        this.runTestFromString(AvoidDeeplyNestedIfStmtsRuleTest.TEST1, 1, this.rule);
        this.runTestFromString(AvoidDeeplyNestedIfStmtsRuleTest.TEST2, 0, this.rule);
    }

    public void testAvoidDuplicateLiteralsRule() throws Throwable {
        this.rule.addProperty("xpath", "//Literal[@Image = preceding::Literal/@Image or @Image = following::Literal/@Image]");
        this.runTestFromString(AvoidDuplicateLiteralsRuleTest.TEST1, 4, this.rule);
        this.runTestFromString(AvoidDuplicateLiteralsRuleTest.TEST2, 0, this.rule);
        this.runTestFromString(AvoidDuplicateLiteralsRuleTest.TEST3, 0, this.rule);
    }

    public void testAvoidReassigningParameters() throws Throwable {
        this.rule.addProperty("xpath", "//PrimaryExpression[following-sibling::AssignmentOperator][PrimaryPrefix/Name/@Image = ancestor::MethodDeclaration/MethodDeclarator/FormalParameters/FormalParameter/VariableDeclaratorId/@Image]");
        this.runTestFromString(AvoidReassigningParametersRuleTest.TEST1, 1, this.rule);
        this.runTestFromString(AvoidReassigningParametersRuleTest.TEST2, 0, this.rule);
        this.runTestFromString(AvoidReassigningParametersRuleTest.TEST3, 1, this.rule);
        this.runTestFromString(AvoidReassigningParametersRuleTest.TEST4, 0, this.rule);
        this.runTestFromString(AvoidReassigningParametersRuleTest.TEST5, 0, this.rule);
        this.runTestFromString(AvoidReassigningParametersRuleTest.TEST6, 0, this.rule);
    }
}

