/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemeGroupBoxDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class GroupDrawData
extends DrawData {
    public int headerWidth;
    public int headerHeight;
    public Rectangle headerArea;

    public GroupDrawData() {
        this.state = new int[1];
    }

    HIThemeGroupBoxDrawInfo getInfo() {
        int state = this.state[0];
        HIThemeGroupBoxDrawInfo info = new HIThemeGroupBoxDrawInfo();
        info.version = 0;
        info.kind = 0;
        if ((this.style & 8) != 0) {
            info.kind = 5;
        }
        info.state = (state & 0x20) != 0 ? ((state & 0x10) != 0 ? 7 : 8) : ((state & 8) != 0 ? 2 : ((state & 0x10) != 0 ? 1 : 0));
        return info;
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        HIThemeGroupBoxDrawInfo info = this.getInfo();
        int headerHeight = this.headerHeight + 1;
        CGRect rect = new CGRect();
        rect.x = bounds.x;
        rect.y = bounds.y + headerHeight;
        rect.width = bounds.width;
        rect.height = bounds.height - headerHeight;
        OS.HIThemeDrawGroupBox(rect, info, gc.handle, 0);
        int[] metric = new int[1];
        if (this.headerArea != null) {
            OS.GetThemeMetric(11, metric);
            int capsWidth = metric[0];
            this.headerArea.x = bounds.x + capsWidth;
            this.headerArea.y = bounds.y;
            this.headerArea.width = bounds.width - capsWidth * 2;
            this.headerArea.height = this.headerHeight;
        }
        if (this.clientArea != null) {
            OS.GetThemeMetric(61, metric);
            int inset = metric[0];
            this.clientArea.x = bounds.x + inset;
            this.clientArea.y = bounds.y + inset + headerHeight;
            this.clientArea.width = bounds.width - 2 * inset;
            this.clientArea.height = bounds.height - 2 * inset - headerHeight;
        }
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        return bounds.contains(position) ? 0 : -1;
    }
}

