/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.fec.io;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import com.onionnetworks.fec.FECCode;
import com.onionnetworks.fec.FECCodeFactory;
import com.onionnetworks.fec.io.BlockAlreadyDecodedException;
import com.onionnetworks.fec.io.BlockDecodedEvent;
import com.onionnetworks.fec.io.DuplicatePacketException;
import com.onionnetworks.fec.io.FECFile;
import com.onionnetworks.fec.io.FECIOEvent;
import com.onionnetworks.fec.io.FECIOListener;
import com.onionnetworks.fec.io.FECParameters;
import com.onionnetworks.fec.io.FileAlreadyDecodedException;
import com.onionnetworks.fec.io.FileDecodedEvent;
import com.onionnetworks.fec.io.PacketNotFoundException;
import com.onionnetworks.fec.io.PacketPlacement;
import com.onionnetworks.fec.io.PacketWrittenEvent;
import com.onionnetworks.io.RAF;
import com.onionnetworks.util.Buffer;
import com.onionnetworks.util.ExceptionEvent;
import com.onionnetworks.util.ExceptionHandler;
import com.onionnetworks.util.FileIntegrity;
import com.onionnetworks.util.ReflectiveEventDispatch;
import com.onionnetworks.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EventListener;
import java.util.EventObject;
import java.util.LinkedList;
import org.apache.log4j.Category;

public class FECFile {
    static Category cat = Category.getInstance((String)(class$Lcom$onionnetworks$fec$io$FECFile != null ? class$Lcom$onionnetworks$fec$io$FECFile : (class$Lcom$onionnetworks$fec$io$FECFile = FECFile.class$("com.onionnetworks.fec.io.FECFile"))).getName());
    private FECParameters params;
    private RAF raf;
    private PacketPlacement pp;
    private FileIntegrity integrity;
    private MessageDigest md;
    private FECCode code;
    private ReflectiveEventDispatch dispatch;
    private int k;
    private int n;
    private int packetSize;
    private int blockSize;
    private int blockCount;
    private ReadWriteLock[] locks;
    private Decoder decoder;
    protected ExceptionHandler exceptionHandler;
    private static /* synthetic */ Class class$Lcom$onionnetworks$fec$io$FECFile;

    public synchronized void setDecodeExceptionHandler(ExceptionHandler eh) {
        this.exceptionHandler = eh;
    }

    protected synchronized ExceptionHandler getDecodeExceptionHandler() {
        return this.exceptionHandler;
    }

    protected static final byte[] createBuffer(int len) {
        return new byte[len];
    }

    protected final byte[] createBuffer() {
        return FECFile.createBuffer(this.blockSize);
    }

    protected final Buffer[] wrapBuffer(byte[] b) {
        if (b.length != this.blockSize) {
            throw new IllegalArgumentException("b.length != " + this.blockSize);
        }
        Buffer[] bufs = new Buffer[this.k];
        int i = 0;
        while (i < bufs.length) {
            bufs[i] = new Buffer(b, i * this.packetSize, this.packetSize);
            ++i;
        }
        return bufs;
    }

    public void renameTo(File destFile) throws IOException {
        this.raf.renameTo(destFile);
    }

    public void read(Buffer[] pkts, int blockNum, int[] stripeNums) throws IOException, PacketNotFoundException {
        if (blockNum < 0 || blockNum >= this.blockCount) {
            throw new IllegalArgumentException("Illegal block# : blockNum=" + blockNum + ",stripeNum=" + stripeNums[0]);
        }
        int ubs = -1;
        byte[] b = null;
        try {
            block10: {
                this.locks[blockNum].readLock().acquire();
                try {
                    if (this.raf.getMode().equals("r") || this.pp.isBlockDecoded(blockNum)) {
                        ubs = this.params.getUnexpandedBlockSize(blockNum);
                        b = this.createBuffer();
                        this.raf.seekAndReadFully((long)(blockNum * this.blockSize), b, 0, ubs);
                        break block10;
                    }
                    int i = 0;
                    while (i < stripeNums.length) {
                        if (this.params.isPaddingPacket(blockNum, stripeNums[i])) {
                            Util.bzero((byte[])pkts[i].b, (int)pkts[i].off, (int)pkts[i].len);
                        } else {
                            int packetIndex = this.pp.getPacketIndex(blockNum, stripeNums[i]);
                            if (packetIndex == -1) {
                                throw new PacketNotFoundException("Packet not on disk: blockNum=" + blockNum + ",stripeNum=" + stripeNums[i], blockNum, stripeNums[i]);
                            }
                            this.raf.seekAndReadFully((long)(packetIndex * this.packetSize), pkts[i].b, pkts[i].off, pkts[i].len);
                        }
                        ++i;
                    }
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    this.locks[blockNum].readLock().release();
                    throw throwable;
                }
                this.locks[blockNum].readLock().release();
                return;
            }
            Object var7_9 = null;
            this.locks[blockNum].readLock().release();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.toString());
        }
        Util.bzero((byte[])b, (int)ubs, (int)(b.length - ubs));
        this.code.encode(this.wrapBuffer(b), pkts, stripeNums);
    }

    public int write(Buffer pkt, int blockNum, int stripeNum) throws IOException, FileAlreadyDecodedException {
        int result = -1;
        try {
            this.locks[blockNum].writeLock().acquire();
            try {
                result = this.write0(pkt, blockNum, stripeNum);
            }
            finally {
                Object var6_5 = null;
                this.locks[blockNum].writeLock().release();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.toString());
        }
        if (result >= this.k) {
            Thread.yield();
        }
        return result;
    }

    private final int write0(Buffer pkt, int blockNum, int stripeNum) throws IOException, DuplicatePacketException, BlockAlreadyDecodedException, FileAlreadyDecodedException {
        if (this.raf.getMode().equals("r")) {
            throw new FileAlreadyDecodedException("Attempted to write packet in read-only mode");
        }
        if (this.params.isPaddingPacket(blockNum, stripeNum)) {
            cat.warn((Object)("You have attempted to write a padding packet which is is already generated by this FECFile and shouldn't be sent across the network.  Talk to Justin for more info. blockNum=" + blockNum + ",stripeNum=" + stripeNum));
            throw new DuplicatePacketException("Attempted padding packet write. blockNum=" + blockNum + ",stripeNum=" + stripeNum, blockNum, stripeNum, -1);
        }
        if (this.pp.isBlockDecoded(blockNum)) {
            throw new BlockAlreadyDecodedException("Block already decoded : blockNum=" + blockNum + ",stripeNum=" + stripeNum, blockNum, stripeNum);
        }
        if (this.pp.getPacketIndex(blockNum, stripeNum) != -1) {
            int i = this.pp.getPacketIndex(blockNum, stripeNum);
            throw new DuplicatePacketException("Duplicate packet: blockNum=" + blockNum + "stripeNum=" + stripeNum + "index=" + i, blockNum, stripeNum, i);
        }
        int packetIndex = -1;
        int packetCount = -1;
        PacketPlacement packetPlacement = this.pp;
        synchronized (packetPlacement) {
            packetIndex = this.pp.addPacketEntry(blockNum, stripeNum);
            packetCount = this.pp.getPacketCount(blockNum);
        }
        this.raf.seekAndWrite((long)(packetIndex * this.packetSize), pkt.b, pkt.off, pkt.len);
        this.fire(new PacketWrittenEvent(this, blockNum, stripeNum, packetCount));
        return packetCount;
    }

    protected boolean tryDecode(int blockNum, int[] stripeNums) throws IOException {
        cat.debug((Object)("trying to decode block : blockNum=" + blockNum));
        byte[] b = this.createBuffer();
        Buffer[] bufs = this.wrapBuffer(b);
        this.read(bufs, blockNum, stripeNums);
        this.code.decode(bufs, stripeNums);
        int ubs = this.params.getUnexpandedBlockSize(blockNum);
        MessageDigest messageDigest = this.md;
        synchronized (messageDigest) {
            this.md.update(b, 0, ubs);
            Buffer hash = this.integrity.getBlockHash(blockNum);
            if (!Util.arraysEqual((byte[])this.md.digest(), (int)0, (byte[])hash.b, (int)hash.off, (int)hash.len)) {
                return false;
            }
        }
        try {
            this.locks[blockNum].writeLock().acquire();
            try {
                this.raf.seekAndWrite((long)(blockNum * this.blockSize), b, 0, b.length);
                this.pp.setBlockDecoded(blockNum);
            }
            finally {
                Object var10_10 = null;
                this.locks[blockNum].writeLock().release();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.toString());
        }
        this.fire(new BlockDecodedEvent(this, blockNum));
        return true;
    }

    public void acquireAllWriteLocks() throws InterruptedException {
        int i = 0;
        while (i < this.locks.length) {
            this.locks[i].writeLock().acquire();
            ++i;
        }
    }

    public void releaseAllWriteLocks() throws InterruptedException {
        int i = 0;
        while (i < this.locks.length) {
            this.locks[i].writeLock().release();
            ++i;
        }
    }

    public void close() throws IOException {
        try {
            this.acquireAllWriteLocks();
            try {
                this.raf.close();
            }
            finally {
                Object var2_1 = null;
                this.releaseAllWriteLocks();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.toString());
        }
        if (this.decoder != null) {
            this.decoder.close();
        }
        if (this.dispatch != null) {
            this.dispatch.close();
        }
    }

    public void addFECIOListener(FECIOListener fil) {
        if (this.dispatch == null) {
            throw new IllegalStateException("No events in read-only mode");
        }
        this.dispatch.addListener((Object)this, (EventListener)fil, FECIOListener.EVENTS);
    }

    public void removeFECIOListener(FECIOListener fil) {
        if (this.dispatch == null) {
            throw new IllegalStateException("No events in read-only mode");
        }
        this.dispatch.removeListener((Object)this, (EventListener)fil, FECIOListener.EVENTS);
    }

    protected void fire(FECIOEvent ev) {
        this.dispatch.fire((EventObject)ev, "notify");
    }

    public int getDecodedBlockCount() {
        return this.pp == null ? this.blockCount : this.pp.getDecodedBlockCount();
    }

    public boolean isBlockDecoded(int blockNum) {
        return this.pp == null ? true : this.pp.isBlockDecoded(blockNum);
    }

    public boolean containsPacket(int blockNum, int stripeNum) {
        if (this.pp == null) {
            return true;
        }
        PacketPlacement packetPlacement = this.pp;
        synchronized (packetPlacement) {
            if (this.pp.isBlockDecoded(blockNum)) {
                return true;
            }
            return this.pp.getPacketIndex(blockNum, stripeNum) != -1;
        }
    }

    public int getWrittenCount() {
        return this.pp == null ? this.params.getUnexpandedPacketCount() : this.pp.getWrittenCount();
    }

    public FECParameters getFECParameters() {
        return this.params;
    }

    public boolean isDecoded() {
        return this.raf.getMode().equals("r");
    }

    public void waitForFileDecoded() throws InterruptedException {
        FECIOListener fil;
        FECIOListener fECIOListener = fil = new FECIOListener(this){
            private final /* synthetic */ FECFile this$0;

            public final void notify(FECIOEvent ev) {
                if (ev instanceof FileDecodedEvent) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        this.notify();
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(FECFile fECFile) {
            }
        };
        synchronized (fECIOListener) {
            this.addFECIOListener(fil);
            if (!this.isDecoded()) {
                fil.wait();
            }
            this.removeFECIOListener(fil);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public FECFile(File f, String mode, FECParameters params) throws IOException {
        this(f, mode, params, null);
    }

    public FECFile(File f, String mode, FECParameters params, FileIntegrity integrity) throws IOException {
        this.params = params;
        this.integrity = integrity;
        this.k = params.getK();
        this.n = params.getN();
        this.packetSize = params.getPacketSize();
        this.blockSize = params.getUnexpandedBlockSize();
        this.blockCount = params.getBlockCount();
        this.code = FECCodeFactory.getDefault().createFECCode(this.k, this.n);
        this.raf = new RAF(f, mode);
        this.locks = new ReadWriteLock[this.blockCount];
        int i = 0;
        while (i < this.locks.length) {
            this.locks[i] = new ReentrantWriterPreferenceReadWriteLock();
            ++i;
        }
        this.setDecodeExceptionHandler(new ExceptionHandler(this){
            private final /* synthetic */ FECFile this$0;

            public final void handleException(ExceptionEvent ev) {
                cat.warn((Object)"Set an ExceptionHandler via FECFile.setDecodeExceptionHandler()", ev.getException());
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(FECFile fECFile) {
            }
        });
        if (mode.equals("rw")) {
            this.dispatch = new ReflectiveEventDispatch();
            if (integrity == null) {
                throw new IllegalArgumentException("Integrity requried in rw");
            }
            try {
                this.md = MessageDigest.getInstance(integrity.getAlgorithm());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            this.pp = new PacketPlacement(params);
            this.decoder = new Decoder();
            this.addFECIOListener(this.decoder);
            new Thread((Runnable)this.decoder, "Decoder Thread").start();
        } else if (integrity != null) {
            throw new IllegalArgumentException("Integrity not used in read-only mode");
        }
    }

    public class Decoder
    implements Runnable,
    FECIOListener {
        LinkedList queue = new LinkedList();
        boolean done = false;

        public void notify(FECIOEvent ev) {
            if (ev instanceof PacketWrittenEvent) {
                LinkedList linkedList = this.queue;
                synchronized (linkedList) {
                    this.queue.add(ev);
                    this.queue.notify();
                }
            }
        }

        public void close() {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                if (this.done) {
                    return;
                }
                FECFile.this.removeFECIOListener(this);
                this.done = true;
                this.queue.clear();
                this.queue.notify();
            }
        }

        private final boolean nextCombo(int[] combo, int n) {
            int i = combo.length - 1;
            while (i >= 0) {
                if (combo[i] != n - combo.length + i) {
                    int n2 = i;
                    combo[n2] = combo[n2] + 1;
                    int j = i + 1;
                    while (j < combo.length) {
                        combo[j] = combo[j - 1] + 1;
                        ++j;
                    }
                    return true;
                }
                --i;
            }
            return false;
        }

        public void run() {
            PacketWrittenEvent ev = null;
            while (true) {
                LinkedList linkedList = this.queue;
                synchronized (linkedList) {
                    if (this.done) {
                        return;
                    }
                    if (this.queue.isEmpty()) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    ev = (PacketWrittenEvent)this.queue.removeFirst();
                }
                int blockNum = ev.getBlockNum();
                int blockPacketCount = ev.getBlockPacketCount();
                int paddingCount = FECFile.this.k - FECFile.this.params.getUnexpandedPacketCount(blockNum);
                if (blockPacketCount < FECFile.this.k - paddingCount || FECFile.this.pp.isBlockDecoded(blockNum)) continue;
                int[] possibleStripes = FECFile.this.pp.getStripeNums(blockNum, blockPacketCount);
                int[] stripeNums = new int[FECFile.this.k];
                stripeNums[((FECFile)FECFile.this).k - paddingCount - 1] = possibleStripes[possibleStripes.length - 1];
                int i = FECFile.this.k - paddingCount;
                while (i < FECFile.this.k) {
                    stripeNums[i] = i;
                    ++i;
                }
                int[] combo = new int[FECFile.this.k - paddingCount - 1];
                int i2 = 0;
                while (i2 < combo.length) {
                    combo[i2] = i2;
                    ++i2;
                }
                do {
                    i2 = 0;
                    while (i2 < combo.length) {
                        stripeNums[i2] = possibleStripes[combo[i2]];
                        ++i2;
                    }
                    StringBuffer sb = new StringBuffer("stripeNums=" + stripeNums[0]);
                    int i3 = 1;
                    while (i3 < stripeNums.length) {
                        sb.append("," + stripeNums[i3]);
                        ++i3;
                    }
                    cat.debug((Object)sb);
                    try {
                        if (!FECFile.this.tryDecode(blockNum, stripeNums)) continue;
                        break;
                    }
                    catch (IOException e) {
                        FECFile.this.getDecodeExceptionHandler().handleException(new ExceptionEvent((Object)FECFile.this, (Throwable)e));
                    }
                } while (this.nextCombo(combo, blockPacketCount - 1));
                try {
                    if (FECFile.this.pp.getDecodedBlockCount() != FECFile.this.params.getBlockCount()) continue;
                    cat.debug((Object)"File Decoded, switching to read-only");
                    FECFile.this.acquireAllWriteLocks();
                    try {
                        FECFile.this.raf.setLength(FECFile.this.params.getFileSize());
                        FECFile.this.raf.setReadOnly();
                    }
                    finally {
                        Object var11_17 = null;
                        FECFile.this.releaseAllWriteLocks();
                    }
                    FECFile.this.fire(new FileDecodedEvent(FECFile.this));
                    this.close();
                    return;
                }
                catch (Exception e) {
                    FECFile.this.getDecodeExceptionHandler().handleException(new ExceptionEvent((Object)FECFile.this, (Throwable)e));
                    continue;
                }
                break;
            }
        }
    }
}

