/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.BinderImpl;
import com.google.inject.BoundProviderFactory;
import com.google.inject.ConstantFactory;
import com.google.inject.ErrorHandler;
import com.google.inject.ErrorMessages;
import com.google.inject.InjectorImpl;
import com.google.inject.InternalContext;
import com.google.inject.InternalFactory;
import com.google.inject.InternalFactoryToProviderAdapter;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.util.Annotations;
import com.google.inject.util.Objects;
import com.google.inject.util.StackTraceElements;
import com.google.inject.util.ToStringBuilder;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BindingBuilderImpl<T>
implements AnnotatedBindingBuilder<T> {
    private static final Logger logger = Logger.getLogger(BindingBuilderImpl.class.getName());
    final Object source;
    Key<T> key;
    InternalFactory<? extends T> factory;
    T instance;
    Scope scope;
    boolean preload = false;
    private BinderImpl binder;
    static ErrorHandler IGNORE_ERRORS = new ErrorHandler(){

        public void handle(Object source, String message) {
        }

        public void handle(Object source, String message, Object ... arguments) {
        }
    };

    BindingBuilderImpl(BinderImpl binder, Key<T> key, Object source) {
        this.binder = binder;
        this.key = Objects.nonNull(key, "key");
        this.source = source;
    }

    Object getSource() {
        return this.source;
    }

    Key<T> getKey() {
        return this.key;
    }

    @Override
    public BindingBuilderImpl<T> annotatedWith(Class<? extends Annotation> annotationType) {
        if (this.key.hasAnnotationType()) {
            this.binder.addError(this.source, "More than one annotation is specified for this binding.");
        } else {
            boolean retainedAtRuntime = Annotations.isRetainedAtRuntime(annotationType);
            boolean bindingAnnotation = Key.isBindingAnnotation(annotationType);
            if (!retainedAtRuntime) {
                this.binder.addError(StackTraceElements.forType(annotationType), "Please annotate with @Retention(RUNTIME). Bound at %s.", this.binder.source());
            }
            if (!bindingAnnotation) {
                this.binder.addError(StackTraceElements.forType(annotationType), "Please annotate with @BindingAnnotation. Bound at %s.", this.binder.source());
            }
            if (retainedAtRuntime && bindingAnnotation) {
                this.key = Key.get(this.key.getTypeLiteral(), annotationType);
            }
        }
        return this;
    }

    @Override
    public BindingBuilderImpl<T> annotatedWith(Annotation annotation) {
        if (this.key.hasAnnotationType()) {
            this.binder.addError(this.source, "More than one annotation is specified for this binding.");
        } else {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            boolean retainedAtRuntime = Annotations.isRetainedAtRuntime(annotationType);
            boolean bindingAnnotation = Key.isBindingAnnotation(annotationType);
            if (!retainedAtRuntime) {
                this.binder.addError(StackTraceElements.forType(annotationType), "Please annotate with @Retention(RUNTIME). Bound at %s.", this.binder.source());
            }
            if (!bindingAnnotation) {
                this.binder.addError(StackTraceElements.forType(annotationType), "Please annotate with @BindingAnnotation. Bound at %s.", this.binder.source());
            }
            if (retainedAtRuntime && bindingAnnotation) {
                this.key = Key.get(this.key.getTypeLiteral(), annotation);
            }
        }
        return this;
    }

    @Override
    public ScopedBindingBuilder to(Class<? extends T> implementation) {
        return this.to(TypeLiteral.get(implementation));
    }

    @Override
    public ScopedBindingBuilder to(TypeLiteral<? extends T> implementation) {
        return this.to(Key.get(implementation));
    }

    @Override
    public ScopedBindingBuilder to(Key<? extends T> targetKey) {
        this.ensureImplementationIsNotSet();
        if (this.key.equals(targetKey)) {
            this.binder.addError(this.source, "Binding points to itself.");
        }
        FactoryProxy<? extends T> factoryProxy = new FactoryProxy<T>(this.key, targetKey, this.source);
        this.factory = factoryProxy;
        this.binder.creationListeners.add(factoryProxy);
        return this;
    }

    @Override
    public void toInstance(T instance) {
        this.ensureImplementationIsNotSet();
        this.instance = Objects.nonNull(instance, "instance");
        this.factory = new ConstantFactory<T>(instance);
        this.registerInstanceForInjection(instance);
        if (this.scope != null) {
            this.binder.addError(this.source, "Setting the scope is not permitted when binding to a single instance.");
        }
    }

    BindingBuilderImpl<T> to(InternalFactory<? extends T> factory) {
        this.ensureImplementationIsNotSet();
        this.factory = factory;
        return this;
    }

    @Override
    public ScopedBindingBuilder toProvider(Provider<? extends T> provider) {
        this.ensureImplementationIsNotSet();
        this.factory = new InternalFactoryToProviderAdapter<T>(provider, this.source);
        this.registerInstanceForInjection(provider);
        return this;
    }

    @Override
    public BindingBuilderImpl<T> toProvider(Class<? extends Provider<? extends T>> providerType) {
        return this.toProvider((Key)Key.get(providerType));
    }

    @Override
    public BindingBuilderImpl<T> toProvider(Key<? extends Provider<? extends T>> providerKey) {
        this.ensureImplementationIsNotSet();
        BoundProviderFactory<? extends T> boundProviderFactory = new BoundProviderFactory<T>(providerKey, this.source);
        this.binder.creationListeners.add(boundProviderFactory);
        this.factory = boundProviderFactory;
        return this;
    }

    private void ensureImplementationIsNotSet() {
        if (this.factory != null) {
            this.binder.addError(this.source, "Implementation is set more than once.");
        }
    }

    @Override
    public void in(Class<? extends Annotation> scopeAnnotation) {
        this.ensureScopeNotSet();
        this.scope = this.binder.scopes.get(Objects.nonNull(scopeAnnotation, "scope annotation"));
        if (this.scope == null) {
            this.binder.addError(this.source, "No scope is bound to %s.", "@" + scopeAnnotation.getSimpleName());
        }
    }

    @Override
    public void in(Scope scope) {
        this.ensureScopeNotSet();
        this.scope = Objects.nonNull(scope, "scope");
    }

    private void ensureScopeNotSet() {
        if (this.instance != null) {
            this.binder.addError(this.source, "Setting the scope is not permitted when binding to a single instance.");
            return;
        }
        if (this.scope != null) {
            this.binder.addError(this.source, "Scope is set more than once.");
        }
    }

    @Override
    public void asEagerSingleton() {
        this.in(Scopes.SINGLETON);
        this.preload = true;
    }

    boolean shouldPreload() {
        return this.preload;
    }

    InternalFactory<? extends T> getInternalFactory(InjectorImpl injector) {
        if (this.factory == null && !this.key.hasAnnotationType()) {
            ImplicitImplementation<T> implicitImplementation = new ImplicitImplementation<T>(this.key, this.scope, this.source);
            this.binder.creationListeners.add(implicitImplementation);
            if (this.scope == null) {
                this.scope = Scopes.getScopeForType(this.key.getTypeLiteral().getRawType(), this.binder.scopes, IGNORE_ERRORS);
            }
            return implicitImplementation;
        }
        return Scopes.scope(this.key, injector, this.factory, this.scope);
    }

    boolean isSingletonScoped() {
        return this.scope == Scopes.SINGLETON;
    }

    void registerInstanceForInjection(final Object o) {
        this.binder.instanceInjectors.add(new BinderImpl.CreationListener(){

            public void notify(InjectorImpl injector) {
                try {
                    injector.injectMembers(o);
                }
                catch (Exception e) {
                    String className = e.getClass().getSimpleName();
                    String message = ErrorMessages.getRootMessage(e);
                    String logMessage = String.format("An error occurred while injecting members of %s. Error message: %s", o, message);
                    logger.log(Level.INFO, logMessage, e);
                    BindingBuilderImpl.this.binder.addError(BindingBuilderImpl.this.source, "An error of type %s occurred while injecting members of %s. See log for details. Error message: %s", className, o, message);
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImplicitImplementation<T>
    implements InternalFactory<T>,
    BinderImpl.CreationListener {
        private final Key<T> key;
        private final Object source;
        private final Scope scope;
        InternalFactory<? extends T> implicitFactory;

        ImplicitImplementation(Key<T> key, Scope scope, Object source) {
            this.key = key;
            this.scope = scope;
            this.source = source;
        }

        @Override
        public void notify(final InjectorImpl injector) {
            injector.withDefaultSource(this.source, new Runnable(){

                public void run() {
                    ImplicitImplementation.this.implicitFactory = injector.getImplicitBinding(null, ImplicitImplementation.this.key.getTypeLiteral().getRawType(), ImplicitImplementation.this.scope);
                }
            });
        }

        @Override
        public T get(InternalContext context) {
            return this.implicitFactory.get(context);
        }

        public String toString() {
            return new ToStringBuilder(FactoryProxy.class).add("key", this.key).add("provider", this.implicitFactory).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FactoryProxy<T>
    implements InternalFactory<T>,
    BinderImpl.CreationListener {
        private final Key<T> key;
        private final Key<? extends T> targetKey;
        private final Object source;
        InternalFactory<? extends T> targetFactory;

        FactoryProxy(Key<T> key, Key<? extends T> targetKey, Object source) {
            this.key = key;
            this.targetKey = targetKey;
            this.source = source;
        }

        @Override
        public void notify(final InjectorImpl injector) {
            injector.withDefaultSource(this.source, new Runnable(){

                public void run() {
                    FactoryProxy.this.targetFactory = injector.getInternalFactory(null, FactoryProxy.this.targetKey);
                }
            });
        }

        @Override
        public T get(InternalContext context) {
            return this.targetFactory.get(context);
        }

        public String toString() {
            return new ToStringBuilder(FactoryProxy.class).add("key", this.key).add("provider", this.targetFactory).toString();
        }
    }
}

