/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.datatype.ByteArraySizeTerminated;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.StringFixedLength;
import org.jaudiotagger.tag.datatype.StringNullTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.jaudiotagger.tag.id3.framebody.ID3v22FrameBody;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;

public class FrameBodyPIC
extends AbstractID3v2FrameBody
implements ID3v22FrameBody {
    public static final String IMAGE_IS_URL = "-->";

    public FrameBodyPIC() {
        this.setObjectValue("TextEncoding", (byte)0);
    }

    public FrameBodyPIC(FrameBodyPIC body) {
        super(body);
    }

    public FrameBodyPIC(byte textEncoding, String imageFormat, byte pictureType, String description, byte[] data) {
        this.setObjectValue("TextEncoding", textEncoding);
        this.setObjectValue("ImageType", imageFormat);
        this.setObjectValue("PictureType", pictureType);
        this.setObjectValue("Description", description);
        this.setObjectValue("PictureData", data);
    }

    public FrameBodyPIC(FrameBodyAPIC body) {
        this.setObjectValue("TextEncoding", body.getTextEncoding());
        this.setObjectValue("ImageType", ImageFormats.getFormatForMimeType((String)body.getObjectValue("MIMEType")));
        this.setObjectValue("PictureType", body.getObjectValue("PictureType"));
        this.setObjectValue("Description", body.getDescription());
        this.setObjectValue("PictureData", body.getObjectValue("PictureData"));
    }

    public FrameBodyPIC(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    public void setDescription(String description) {
        this.setObjectValue("Description", description);
    }

    public String getDescription() {
        return (String)this.getObjectValue("Description");
    }

    public String getIdentifier() {
        return "PIC";
    }

    public void write(ByteArrayOutputStream tagBuffer) {
        if (!((AbstractString)this.getObject("Description")).canBeEncoded()) {
            this.setTextEncoding((byte)1);
        }
        super.write(tagBuffer);
    }

    public String getFormatType() {
        return (String)this.getObjectValue("ImageType");
    }

    public boolean isImageUrl() {
        if (this.getFormatType() == null) {
            return false;
        }
        return this.getFormatType().equals(IMAGE_IS_URL);
    }

    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new StringFixedLength("ImageType", (AbstractTagFrameBody)this, 3));
        this.objectList.add(new NumberHashMap("PictureType", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new StringNullTerminated("Description", this));
        this.objectList.add(new ByteArraySizeTerminated("PictureData", this));
    }
}

