/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import java.util.Arrays;
import org.jaudiotagger.audio.asf.data.AudioStreamChunk;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContentDescription;
import org.jaudiotagger.audio.asf.data.EncodingChunk;
import org.jaudiotagger.audio.asf.data.ExtendedContentDescription;
import org.jaudiotagger.audio.asf.data.FileHeader;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamBitratePropertiesChunk;
import org.jaudiotagger.audio.asf.data.StreamChunk;

public class AsfHeader
extends Chunk {
    private final long chunkCount;
    private ContentDescription contentDescription;
    private EncodingChunk encodingChunk;
    private ExtendedContentDescription extendedContentDescription;
    private FileHeader fileHeader;
    private StreamBitratePropertiesChunk streamBitratePropertiesChunk;
    private StreamChunk[] streamChunks;
    private Chunk[] unspecifiedChunks;

    public AsfHeader(long pos, BigInteger chunkLen, long chunkCnt) {
        super(GUID.GUID_HEADER, pos, chunkLen);
        this.chunkCount = chunkCnt;
        this.streamChunks = new StreamChunk[0];
        this.unspecifiedChunks = new Chunk[0];
    }

    public void addStreamChunk(StreamChunk toAdd) {
        if (toAdd == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        if (!Arrays.asList(this.streamChunks).contains(toAdd)) {
            StreamChunk[] tmp = new StreamChunk[this.streamChunks.length + 1];
            System.arraycopy(this.streamChunks, 0, tmp, 0, this.streamChunks.length);
            tmp[tmp.length - 1] = toAdd;
            this.streamChunks = tmp;
        }
    }

    public void addUnspecifiedChunk(Chunk toAppend) {
        if (toAppend == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        if (!Arrays.asList(this.unspecifiedChunks).contains(toAppend)) {
            Chunk[] tmp = new Chunk[this.unspecifiedChunks.length + 1];
            System.arraycopy(this.unspecifiedChunks, 0, tmp, 0, this.unspecifiedChunks.length);
            tmp[tmp.length - 1] = toAppend;
            this.unspecifiedChunks = tmp;
        }
    }

    public AudioStreamChunk getAudioStreamChunk() {
        AudioStreamChunk result = null;
        int i = 0;
        while (i < this.getStreamChunkCount() && result == null) {
            StreamChunk tmp = this.getStreamChunk(i);
            if (tmp instanceof AudioStreamChunk) {
                result = (AudioStreamChunk)tmp;
            }
            ++i;
        }
        return result;
    }

    public long getChunkCount() {
        return this.chunkCount;
    }

    public ContentDescription getContentDescription() {
        return this.contentDescription;
    }

    public EncodingChunk getEncodingChunk() {
        return this.encodingChunk;
    }

    public ExtendedContentDescription getExtendedContentDescription() {
        return this.extendedContentDescription;
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public StreamBitratePropertiesChunk getStreamBitratePropertiesChunk() {
        return this.streamBitratePropertiesChunk;
    }

    public StreamChunk getStreamChunk(int index) {
        return this.streamChunks[index];
    }

    public int getStreamChunkCount() {
        return this.streamChunks.length;
    }

    public Chunk getUnspecifiedChunk(int index) {
        return this.unspecifiedChunks[index];
    }

    public int getUnspecifiedChunkCount() {
        return this.unspecifiedChunks.length;
    }

    public String prettyPrint() {
        StringBuffer result = new StringBuffer(super.prettyPrint());
        result.insert(0, "\nASF Chunk\n");
        result.append("   Contains: \"" + this.getChunkCount() + "\" chunks\n");
        result.append(this.getFileHeader());
        result.append(this.getExtendedContentDescription());
        result.append(this.getEncodingChunk());
        result.append(this.getContentDescription());
        result.append(this.getStreamBitratePropertiesChunk());
        int i = 0;
        while (i < this.getStreamChunkCount()) {
            result.append(this.getStreamChunk(i));
            ++i;
        }
        return result.toString();
    }

    public void setContentDescription(ContentDescription contentDesc) {
        this.contentDescription = contentDesc;
    }

    public void setEncodingChunk(EncodingChunk encChunk) {
        if (encChunk == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.encodingChunk = encChunk;
    }

    public void setExtendedContentDescription(ExtendedContentDescription th) {
        this.extendedContentDescription = th;
    }

    public void setFileHeader(FileHeader fh) {
        if (fh == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.fileHeader = fh;
    }

    public void setStreamBitratePropertiesChunk(StreamBitratePropertiesChunk streamBitratePropertiesChunk1) {
        this.streamBitratePropertiesChunk = streamBitratePropertiesChunk1;
    }
}

