/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public class ID3v2LyricLine
extends AbstractDataType {
    String text = "";
    long timeStamp = 0L;

    public ID3v2LyricLine(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public ID3v2LyricLine(ID3v2LyricLine copy) {
        super(copy);
        this.text = new String(copy.text);
        this.timeStamp = copy.timeStamp;
    }

    public int getSize() {
        return this.text.length() + 1 + 4;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v2LyricLine)) {
            return false;
        }
        ID3v2LyricLine object = (ID3v2LyricLine)obj;
        if (!this.text.equals(object.text)) {
            return false;
        }
        if (this.timeStamp != object.timeStamp) {
            return false;
        }
        return super.equals(obj);
    }

    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        if (arr == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (offset < 0 || offset >= arr.length) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + offset + ", array.length = " + arr.length);
        }
        this.text = Utils.getString(arr, offset, arr.length - offset - 4, "ISO-8859-1");
        this.timeStamp = 0L;
        int i = arr.length - 4;
        while (i < arr.length) {
            this.timeStamp <<= 8;
            this.timeStamp += (long)arr[i];
            ++i;
        }
    }

    public String toString() {
        return String.valueOf(this.timeStamp) + " " + this.text;
    }

    public byte[] writeByteArray() {
        byte[] arr = new byte[this.getSize()];
        int i = 0;
        while (i < this.text.length()) {
            arr[i] = (byte)this.text.charAt(i);
            ++i;
        }
        arr[i++] = 0;
        arr[i++] = (byte)((this.timeStamp & 0xFFFFFFFFFF000000L) >> 24);
        arr[i++] = (byte)((this.timeStamp & 0xFF0000L) >> 16);
        arr[i++] = (byte)((this.timeStamp & 0xFF00L) >> 8);
        arr[i++] = (byte)(this.timeStamp & 0xFFL);
        return arr;
    }
}

