/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.impl.BipartiteGraph;
import edu.uci.ics.jung.graph.impl.SparseVertex;

public class BipartiteVertex
extends SparseVertex {
    public ArchetypeVertex copy(ArchetypeGraph newGraph) {
        if (!(newGraph instanceof BipartiteGraph) || !(this.getGraph() instanceof BipartiteGraph)) {
            return super.copy(newGraph);
        }
        BipartiteGraph bpg = (BipartiteGraph)newGraph;
        if (newGraph == this.getGraph()) {
            throw new IllegalArgumentException("Source and destination graphs must be different");
        }
        try {
            BipartiteVertex v = (BipartiteVertex)this.clone();
            v.initialize();
            v.importUserData(this);
            BipartiteGraph thisGraph = (BipartiteGraph)this.getGraph();
            bpg.addVertex(v, thisGraph.getPartition(this));
            return v;
        }
        catch (CloneNotSupportedException cne) {
            throw new FatalException("Can't copy vertex ", cne);
        }
    }
}

