/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.graph.Hyperedge;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.Hypervertex;
import edu.uci.ics.jung.graph.impl.AbstractArchetypeGraph;
import edu.uci.ics.jung.graph.impl.AbstractElement;
import edu.uci.ics.jung.utils.GraphUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SetHypergraph
extends AbstractArchetypeGraph
implements Hypergraph {
    protected Set edges;
    protected Set vertices;

    public SetHypergraph() {
        this.initialize();
    }

    public void initialize() {
        this.edges = new HashSet();
        this.vertices = new HashSet();
        super.initialize();
    }

    public Hypervertex addVertex(Hypervertex v) {
        this.checkConstraints(v, this.vertex_requirements);
        if (v instanceof AbstractElement) {
            AbstractElement ae = (AbstractElement)((Object)v);
            ae.checkIDs(this.mVertexIDs);
            ae.addGraph_internal(this);
        }
        this.vertices.add(v);
        this.mGraphListenerHandler.handleAdd(v);
        return v;
    }

    public void removeVertex(Hypervertex v) {
        if (v.getGraph() != this) {
            throw new IllegalArgumentException("This vertex is not in this graph");
        }
        HashSet v_edges = new HashSet(v.getIncidentEdges());
        Iterator iter = v_edges.iterator();
        while (iter.hasNext()) {
            v.disconnectEdge((Hyperedge)iter.next());
        }
        if (v instanceof AbstractElement) {
            AbstractElement ae = (AbstractElement)((Object)v);
            ae.removeGraph_internal();
            this.mVertexIDs.remove(new Integer(ae.getID()));
        }
        this.vertices.remove(v);
        this.mGraphListenerHandler.handleRemove(v);
    }

    public Hyperedge addEdge(Hyperedge e) {
        this.checkConstraints(e, this.edge_requirements);
        if (e instanceof AbstractElement) {
            AbstractElement ae = (AbstractElement)((Object)e);
            ae.checkIDs(this.mEdgeIDs);
            ae.addGraph_internal(this);
        }
        this.edges.add(e);
        this.mGraphListenerHandler.handleAdd(e);
        return e;
    }

    public void removeEdge(Hyperedge e) {
        if (e.getGraph() != this) {
            throw new IllegalArgumentException("This edge is not in this graph");
        }
        HashSet e_vertices = new HashSet(e.getIncidentVertices());
        Iterator iter = e_vertices.iterator();
        while (iter.hasNext()) {
            e.disconnectVertex((Hypervertex)iter.next());
        }
        if (e instanceof AbstractElement) {
            AbstractElement ae = (AbstractElement)((Object)e);
            ae.removeGraph_internal();
            this.mEdgeIDs.remove(new Integer(ae.getID()));
        }
        this.edges.remove(e);
        this.mGraphListenerHandler.handleRemove(e);
    }

    public Set getVertices() {
        return Collections.unmodifiableSet(this.vertices);
    }

    public Set getEdges() {
        return Collections.unmodifiableSet(this.edges);
    }

    public void removeVertices(Set vertices) {
        GraphUtils.removeVertices(this, vertices);
    }

    public void removeEdges(Set edges) {
        GraphUtils.removeEdges(this, edges);
    }
}

