/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.SimpleUndirectedSparseVertex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UndirectedSparseVertex
extends SimpleUndirectedSparseVertex {
    public Edge findEdge(Vertex v) {
        Set outEdges = (Set)this.getNeighborsToEdges().get(v);
        if (outEdges == null) {
            return null;
        }
        return (Edge)outEdges.iterator().next();
    }

    public Set findEdgeSet(Vertex v) {
        HashSet edgeSet = new HashSet();
        Set edges = (Set)this.getNeighborsToEdges().get(v);
        if (edges != null) {
            edgeSet.addAll(edges);
        }
        return Collections.unmodifiableSet(edgeSet);
    }

    protected Collection getEdges_internal() {
        HashSet edges = new HashSet();
        Collection edgeSets = this.getNeighborsToEdges().values();
        Iterator e_iter = edgeSets.iterator();
        while (e_iter.hasNext()) {
            edges.addAll((Set)e_iter.next());
        }
        return edges;
    }

    protected void addNeighbor_internal(Edge e, Vertex v) {
        if (!(e instanceof UndirectedEdge)) {
            throw new IllegalArgumentException("This vertex implementation only accepts undirected edges");
        }
        Map nte = this.getNeighborsToEdges();
        HashSet<Edge> edges = (HashSet<Edge>)nte.get(v);
        if (edges == null) {
            edges = new HashSet<Edge>();
            nte.put(v, edges);
        }
        edges.add(e);
    }

    protected void removeNeighbor_internal(Edge e, Vertex v) {
        Map nte = this.getNeighborsToEdges();
        Set edges = (Set)nte.get(v);
        if (edges != null) {
            boolean removed = edges.remove(e);
            if (edges.isEmpty()) {
                nte.remove(v);
            }
            if (!removed && this != v) {
                throw new FatalException("Internal error in data structurefor vertex " + this);
            }
        } else if (this != v) {
            throw new FatalException("Internal error in data structurefor vertex " + this);
        }
    }
}

