/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSetReader;
import net.sourceforge.pmd.RuleSetWriter;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.PMDDirectoryRequestEvent;
import net.sourceforge.pmd.swingui.event.PMDDirectoryRequestEventListener;
import net.sourceforge.pmd.swingui.event.PMDDirectoryReturnedEvent;
import net.sourceforge.pmd.swingui.event.RuleSetEvent;
import net.sourceforge.pmd.swingui.event.RuleSetEventListener;

public class PMDDirectory {
    private String m_pmdDirectoryPath;
    private String m_ruleSetsDirectoryPath;
    private Properties m_properties;
    private PMDDirectoryRequestEventHandler m_pmdDirectoryRequestEventHandler = new PMDDirectoryRequestEventHandler();
    private RuleSetEventHandler m_ruleSetEventHandler = new RuleSetEventHandler();
    private static PMDDirectory m_pmdDirectoryInstance;
    private final String PROPERTIES_FILE_NAME = "pmd.properties";

    private PMDDirectory(String pathToPMD) throws PMDException {
        ListenerList.addListener(this.m_pmdDirectoryRequestEventHandler);
        ListenerList.addListener(this.m_ruleSetEventHandler);
        this.m_pmdDirectoryPath = pathToPMD + File.separator + "PMD";
        this.m_ruleSetsDirectoryPath = this.m_pmdDirectoryPath + File.separator + "rulesets";
        String key = "java.class.path";
        String classpath = System.getProperty(key);
        classpath = classpath + ";" + this.m_ruleSetsDirectoryPath;
        System.setProperty(key, classpath);
        this.loadPropertiesFile();
    }

    public static final void open(String pathToPMD) throws PMDException {
        m_pmdDirectoryInstance = new PMDDirectory(pathToPMD);
    }

    public static final PMDDirectory getDirectory() {
        return m_pmdDirectoryInstance;
    }

    public RuleSet getIncludedRules(int lowestPriorityForAnalysis) throws PMDException {
        RuleSet includedRules = new RuleSet();
        Iterator ruleSetFiles = this.getRuleSetFiles().iterator();
        while (ruleSetFiles.hasNext()) {
            File ruleSetFile = (File)ruleSetFiles.next();
            RuleSet ruleSet = this.getRuleSet(ruleSetFile, true);
            if (ruleSet == null || !ruleSet.include()) continue;
            Iterator allRules = ruleSet.getRules().iterator();
            while (allRules.hasNext()) {
                Rule rule = (Rule)allRules.next();
                if (!rule.include() || rule.getPriority() > lowestPriorityForAnalysis) continue;
                includedRules.addRule(rule);
            }
        }
        return includedRules;
    }

    public RuleSet getRuleSet(File ruleSetFile) throws PMDException {
        return this.getRuleSet(ruleSetFile, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RuleSet getRuleSet(File ruleSetFile, boolean onlyIfIncluded) throws PMDException {
        if (ruleSetFile == null) {
            String message = "Rule set file parameter is missing.";
            PMDException exception = new PMDException(message);
            exception.fillInStackTrace();
            throw exception;
        }
        FileInputStream inputStream = null;
        RuleSet ruleSet = null;
        try {
            try {
                inputStream = new FileInputStream(ruleSetFile);
                RuleSetReader reader = new RuleSetReader();
                ruleSet = reader.read(inputStream, ruleSetFile.getName(), onlyIfIncluded);
            }
            catch (FileNotFoundException exception) {
                String template = "Rule set \"{0}\" was not found.";
                Object[] args = new String[]{ruleSetFile.getPath()};
                String message = MessageFormat.format(template, args);
                PMDException pmdException = new PMDException(message, exception);
                pmdException.fillInStackTrace();
                throw pmdException;
            }
            Object var11_9 = null;
            if (inputStream == null) return ruleSet;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException exception) {}
        inputStream.close();
        return ruleSet;
    }

    private List getRuleSetFiles() {
        ArrayList<File> ruleSetFiles = new ArrayList<File>();
        File directory = new File(this.m_ruleSetsDirectoryPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File[] files = directory.listFiles(new XMLFileNameFilter());
        int n = 0;
        while (n < files.length) {
            ruleSetFiles.add(files[n]);
            ++n;
        }
        return ruleSetFiles;
    }

    public List getRegisteredRuleSets() {
        ArrayList<RuleSet> ruleSetList = new ArrayList<RuleSet>();
        try {
            Iterator ruleSets = new RuleSetFactory().getRegisteredRuleSets();
            while (ruleSets.hasNext()) {
                RuleSet ruleSet = (RuleSet)ruleSets.next();
                ruleSet.setInclude(true);
                Iterator rules = ruleSet.getRules().iterator();
                while (rules.hasNext()) {
                    ((Rule)rules.next()).setInclude(true);
                }
                ruleSetList.add(ruleSet);
            }
        }
        catch (RuleSetNotFoundException exception) {
            System.out.println(exception.getMessage());
        }
        return ruleSetList;
    }

    public List getRuleSets() throws PMDException {
        ArrayList<RuleSet> ruleSetList;
        List ruleSetFilesList = this.getRuleSetFiles();
        if (ruleSetFilesList.size() == 0) {
            ruleSetList = this.getRegisteredRuleSets();
        } else {
            ruleSetList = new ArrayList<RuleSet>();
            Iterator ruleSetFiles = ruleSetFilesList.iterator();
            while (ruleSetFiles.hasNext()) {
                File ruleSetFile = (File)ruleSetFiles.next();
                RuleSet ruleSet = this.getRuleSet(ruleSetFile);
                ruleSetList.add(ruleSet);
            }
        }
        return ruleSetList;
    }

    public String getPMDDirectoryPath() {
        return this.m_pmdDirectoryPath;
    }

    public String getRuleSetsDirectoryPath() {
        return this.m_ruleSetsDirectoryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveRuleSets(List ruleSetList) {
        Iterator ruleSets = ruleSetList.iterator();
        while (ruleSets.hasNext()) {
            RuleSet ruleSet = (RuleSet)ruleSets.next();
            String ruleSetFileName = ruleSet.getFileName();
            String path = this.m_ruleSetsDirectoryPath + File.separator + ruleSetFileName;
            File file = new File(path);
            FileOutputStream outputStream = null;
            if (file.exists()) {
                file.delete();
            }
            try {
                outputStream = new FileOutputStream(file);
                RuleSetWriter writer = new RuleSetWriter(outputStream);
                writer.write(ruleSet);
            }
            catch (FileNotFoundException exception2) {
                Object exception2 = null;
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException exception3) {
                        Object exception3 = null;
                    }
                }
            }
        }
    }

    private void loadPropertiesFile() throws PMDException {
        String propertiesFileName = this.m_pmdDirectoryPath + File.separator + "pmd.properties";
        this.m_properties = new Properties();
        FileInputStream inputStream = null;
        try {
            File file = new File(propertiesFileName);
            if (!file.exists()) {
                File directory = file.getParentFile();
                directory.mkdirs();
                file.createNewFile();
            }
            inputStream = new FileInputStream(propertiesFileName);
            this.m_properties.load(inputStream);
        }
        catch (FileNotFoundException exception) {
            String template = "Could not find the file \"{0}\".";
            Object[] args = new String[]{propertiesFileName};
            String message = MessageFormat.format(template, args);
            PMDException pmdException = new PMDException(message, exception);
            pmdException.fillInStackTrace();
            throw pmdException;
        }
        catch (IOException exception) {
            String template = "Unable to read the file \"{0}\".";
            Object[] args = new String[]{propertiesFileName};
            String message = MessageFormat.format(template, args);
            PMDException pmdException = new PMDException(message, exception);
            pmdException.fillInStackTrace();
            throw pmdException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException exception2) {
                    Object exception2 = null;
                }
            }
        }
    }

    public void savePropertiesFile() throws PMDException {
        FileOutputStream outputStream = null;
        String propertiesFileName = this.m_pmdDirectoryPath + File.separator + "pmd.properties";
        File file = new File(propertiesFileName);
        if (file.exists()) {
            file.delete();
        }
        try {
            this.m_properties.store(outputStream, null);
        }
        catch (FileNotFoundException exception) {
            String template = "Could not find the file \"{0}\".";
            Object[] args = new String[]{propertiesFileName};
            String message = MessageFormat.format(template, args);
            PMDException pmdException = new PMDException(message, exception);
            pmdException.fillInStackTrace();
            throw pmdException;
        }
        catch (IOException exception) {
            String template = "Unable to read the file \"{0}\".";
            Object[] args = new String[]{propertiesFileName};
            String message = MessageFormat.format(template, args);
            PMDException pmdException = new PMDException(message, exception);
            pmdException.fillInStackTrace();
            throw pmdException;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException exception2) {
                    Object exception2 = null;
                }
            }
        }
    }

    private class XMLFileNameFilter
    implements FilenameFilter {
        private XMLFileNameFilter() {
        }

        public boolean accept(File directory, String fileName) {
            return fileName.toLowerCase().endsWith(".xml");
        }
    }

    private class PMDDirectoryRequestEventHandler
    implements PMDDirectoryRequestEventListener {
        private PMDDirectoryRequestEventHandler() {
        }

        public void requestRuleSetPath(PMDDirectoryRequestEvent event) {
            PMDDirectoryReturnedEvent.notifyReturnedRuleSetPath(this, PMDDirectory.this.getRuleSetsDirectoryPath());
        }

        public void requestAllRuleSets(PMDDirectoryRequestEvent event) throws PMDException {
            PMDDirectoryReturnedEvent.notifyReturnedAllRuleSets(this, PMDDirectory.this.getRuleSets());
        }

        public void requestDefaultRuleSets(PMDDirectoryRequestEvent event) {
            PMDDirectoryReturnedEvent.notifyReturnedDefaultRuleSets(this, PMDDirectory.this.getRegisteredRuleSets());
        }

        public void requestIncludedRules(PMDDirectoryRequestEvent event) throws PMDException {
            int priority = event.getLowestPriorityForAnalysis();
            PMDDirectoryReturnedEvent.notifyReturnedIncludedRules(this, PMDDirectory.this.getIncludedRules(priority));
        }
    }

    private class RuleSetEventHandler
    implements RuleSetEventListener {
        private RuleSetEventHandler() {
        }

        public void saveRuleSets(RuleSetEvent event) {
            List ruleSetList = event.getRuleSetList();
            PMDDirectory.this.saveRuleSets(ruleSetList);
        }
    }
}

