/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapAuthenticator;
import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapResponse;
import de.kapsi.net.daap.DaapResponseFactory;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapSession;
import de.kapsi.net.daap.DaapStreamSource;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.SessionId;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.chunks.Chunk;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;

public class DaapRequestProcessor {
    private static final Log LOG = LogFactory.getLog(DaapRequestProcessor.class);
    private DaapResponseFactory factory;

    public DaapRequestProcessor(DaapResponseFactory factory) {
        this.factory = factory;
    }

    public DaapResponse process(DaapRequest request) throws IOException {
        if (request == null || request.isUnknownRequest()) {
            throw new IOException("Unknown request: " + request);
        }
        request.getConnection().lock();
        if (request.isSongRequest()) {
            return this.processSongRequest(request);
        }
        if (request.isServerInfoRequest()) {
            return this.processServerInfoRequest(request);
        }
        if (request.isLogoutRequest()) {
            return this.processLogoutRequest(request);
        }
        if (!this.isAuthenticated(request)) {
            return this.factory.createAuthResponse(request);
        }
        if (request.isContentCodesRequest()) {
            return this.processContentCodesRequest(request);
        }
        if (request.isLoginRequest()) {
            return this.processLoginRequest(request);
        }
        if (this.validateSessionId(request)) {
            if (request.isUpdateRequest()) {
                return this.processUpdateRequest(request);
            }
            if (request.isDatabasesRequest()) {
                return this.processDatabasesRequest(request);
            }
            if (request.isDatabaseSongsRequest()) {
                return this.processDatabaseSongsRequest(request);
            }
            if (request.isDatabasePlaylistsRequest()) {
                return this.processDatabasePlaylistsRequest(request);
            }
            if (request.isPlaylistSongsRequest()) {
                return this.processPlaylistSongsRequest(request);
            }
            if (request.isResolveRequest()) {
                return this.processResolveRequest(request);
            }
        } else {
            throw new IOException("Invalid session-id: " + request);
        }
        throw new IOException("Unhandled request: " + request);
    }

    private boolean isAuthenticated(DaapRequest request) throws UnsupportedEncodingException {
        if (request.isServerSideRequest()) {
            return true;
        }
        DaapConnection connection = request.getConnection();
        DaapServer server = request.getServer();
        DaapConfig config = server.getConfig();
        DaapAuthenticator authenticator = server.getAuthenticator();
        if (authenticator == null) {
            return true;
        }
        if (config.getAuthenticationMethod().equals(DaapConfig.NO_PASSWORD)) {
            return true;
        }
        Header authHeader = request.getHeader("Authorization");
        if (authHeader == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Authorization header is not set");
            }
            return false;
        }
        String authValue = authHeader.getValue();
        Object scheme = config.getAuthenticationScheme();
        if (scheme.equals(DaapConfig.BASIC_SCHEME)) {
            int q;
            StringTokenizer tok = new StringTokenizer(authHeader.getValue(), " ");
            if (!tok.nextToken().equals("Basic")) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Schemes mismatch");
                }
                return false;
            }
            byte[] logpass = Base64.decodeBase64((byte[])tok.nextToken().getBytes("ISO-8859-1"));
            for (q = 0; q < logpass.length && logpass[q] != 58; ++q) {
            }
            String username = new String(logpass, 0, q, "UTF-8");
            String password = new String(logpass, ++q, logpass.length - q, "UTF-8");
            return authenticator.authenticate(username, password, null, null);
        }
        if (!authValue.startsWith("Digest")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Schemes mismatch");
            }
            return false;
        }
        int beginIndex = "Digest".length() + 1;
        if (beginIndex >= authValue.length()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Illegal Authorization Header");
            }
            return false;
        }
        String[] values = authValue.substring(beginIndex).split(", ");
        String username = null;
        String nonce = null;
        String uri = null;
        String response = null;
        for (int i = 0; i < values.length; ++i) {
            String[] kv = values[i].split("=", 2);
            if (kv.length != 2) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Illegal Authorization Header: " + values[i]));
                }
                return false;
            }
            if (!kv[1].startsWith("\"") || !kv[1].endsWith("\"")) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Illegal Authorization Header: " + values[i]));
                }
                return false;
            }
            String key = kv[0].trim().toLowerCase(Locale.US);
            String value = kv[1].substring(1, kv[1].length() - 1);
            if (key.equals("username")) {
                username = value;
            } else if (key.equals("nonce")) {
                nonce = value;
            } else if (key.equals("uri")) {
                uri = value;
            } else if (key.equals("response")) {
                response = value;
            }
            if (username != null && nonce != null && uri != null && response != null) break;
        }
        if (username == null) {
            LOG.info((Object)"Username is null");
            return false;
        }
        if (nonce == null) {
            LOG.info((Object)"Nonce is null");
            return false;
        }
        if (uri == null) {
            LOG.info((Object)"URI is null");
            return false;
        }
        if (response == null) {
            LOG.info((Object)"Response is null");
            return false;
        }
        String currentNonce = connection.getNonce();
        if (currentNonce == null || !currentNonce.equals(nonce)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Nonce mismatch: " + currentNonce + " vs. " + nonce));
            }
            return false;
        }
        return authenticator.authenticate(username, response, uri, nonce);
    }

    private boolean validateSessionId(DaapRequest request) {
        DaapConnection connection = request.getConnection();
        DaapSession session = connection.getSession(false);
        if (session != null) {
            return session.getSessionId().equals(request.getSessionId());
        }
        return false;
    }

    protected DaapResponse processServerInfoRequest(DaapRequest request) throws IOException {
        Library library = request.getHeadLibrary();
        if (library == null) {
            throw new IOException("Connection is not associated with a Library");
        }
        Chunk chunk = (Chunk)library.select(request);
        if (chunk == null) {
            throw new IOException("library.select(ServerInfoRequest) returned null");
        }
        byte[] data = DaapUtil.serialize(chunk, request.isGZIPSupported());
        return this.factory.createChunkResponse(request, data);
    }

    protected DaapResponse processContentCodesRequest(DaapRequest request) throws IOException {
        Library library = request.getHeadLibrary();
        if (library == null) {
            throw new IOException("Connection is not associated with a Library");
        }
        Chunk chunk = (Chunk)library.select(request);
        if (chunk == null) {
            throw new IOException("library.select(ContentCodesRequest) returned null");
        }
        byte[] data = DaapUtil.serialize(chunk, request.isGZIPSupported());
        return this.factory.createChunkResponse(request, data);
    }

    protected DaapResponse processLoginRequest(DaapRequest request) throws IOException {
        if (!request.getSessionId().equals(SessionId.INVALID)) {
            throw new IOException("Session ID cannot exist: " + request.getSessionId());
        }
        Library library = request.getHeadLibrary();
        if (library == null) {
            throw new IOException("Connection is not associated with a Library");
        }
        DaapConnection connection = request.getConnection();
        DaapSession session = connection.getSession(true);
        request.setSessionId(session.getSessionId());
        Chunk chunk = (Chunk)library.select(request);
        if (chunk == null) {
            throw new IOException("library.select(LoginRequest) returned null");
        }
        byte[] data = DaapUtil.serialize(chunk, request.isGZIPSupported());
        return this.factory.createChunkResponse(request, data);
    }

    protected DaapResponse processLogoutRequest(DaapRequest request) throws IOException {
        DaapConnection connection = request.getConnection();
        DaapSession session = connection.getSession(false);
        if (request.isKeepConnectionAlive() && session != null) {
            return this.factory.createNoContentResponse(request);
        }
        throw new IOException("Logout");
    }

    protected DaapResponse processUpdateRequest(DaapRequest request) throws IOException {
        Library library = request.nextLibrary();
        if (library == null) {
            throw new IOException("Connection is not associated with a Library");
        }
        if (library.getRevision() == request.getDelta()) {
            request.getConnection().unlock();
            DaapSession session = request.getConnection().getSession(false);
            if (session == null) {
                throw new IOException("Connection is not associated with a Session");
            }
            session.setAttribute("CLIENT_REVISION", new Integer(library.getRevision()));
            return null;
        }
        Chunk chunk = (Chunk)library.select(request);
        if (chunk == null) {
            throw new IOException("library.select(UpdateRequest) returned null");
        }
        byte[] data = DaapUtil.serialize(chunk, request.isGZIPSupported());
        return this.factory.createChunkResponse(request, data);
    }

    protected DaapResponse processDatabasesRequest(DaapRequest request) throws IOException {
        Library library = request.getHeadLibrary();
        if (library == null) {
            throw new IOException("Connection is not associated with a Library");
        }
        Chunk serverDatabases = (Chunk)library.select(request);
        if (serverDatabases == null) {
            throw new IOException("library.select(DatabasesRequest) returned null");
        }
        byte[] data = DaapUtil.serialize(serverDatabases, request.isGZIPSupported());
        return this.factory.createChunkResponse(request, data);
    }

    protected DaapResponse processDatabaseSongsRequest(DaapRequest request) throws IOException {
        Library library = request.getHeadLibrary();
        if (library == null) {
            throw new IOException("Connection is not associated with a Library");
        }
        Chunk databaseSongs = (Chunk)library.select(request);
        if (databaseSongs == null) {
            throw new IOException("library.select(DatabaseSongsRequest) returned null");
        }
        byte[] data = DaapUtil.serialize(databaseSongs, request.isGZIPSupported());
        return this.factory.createChunkResponse(request, data);
    }

    protected DaapResponse processDatabasePlaylistsRequest(DaapRequest request) throws IOException {
        Library library = request.getHeadLibrary();
        if (library == null) {
            throw new IOException("Connection is not associated with a Library");
        }
        Chunk databasePlaylists = (Chunk)library.select(request);
        if (databasePlaylists == null) {
            throw new IOException("library.select(DatabasePlaylists) returned null");
        }
        byte[] data = DaapUtil.serialize(databasePlaylists, request.isGZIPSupported());
        return this.factory.createChunkResponse(request, data);
    }

    protected DaapResponse processPlaylistSongsRequest(DaapRequest request) throws IOException {
        Library library = request.getHeadLibrary();
        if (library == null) {
            throw new IOException("Connection is not associated with a Library");
        }
        Chunk playlistSongs = (Chunk)library.select(request);
        if (playlistSongs == null) {
            throw new IOException("library.select(PlaylistSongs) returned null");
        }
        byte[] data = DaapUtil.serialize(playlistSongs, request.isGZIPSupported());
        return this.factory.createChunkResponse(request, data);
    }

    protected DaapResponse processResolveRequest(DaapRequest request) throws IOException {
        throw new IOException("Resolve is not implemented");
    }

    protected DaapResponse processSongRequest(DaapRequest request) throws IOException {
        Library library = request.getLibrary();
        if (library == null) {
            throw new IOException("Connection is not associated with a Library");
        }
        DaapConnection connection = request.getConnection();
        DaapServer server = connection.getServer();
        DaapStreamSource streamSource = server.getStreamSource();
        if (streamSource != null) {
            Object src;
            long[] range = this.getRange(request);
            if (range == null) {
                throw new IOException("getRange returned null");
            }
            long pos = range[0];
            long end = range[1];
            Song song = (Song)library.select(request);
            if (song == null) {
                throw new IOException("Library returned null-Song for request: " + request);
            }
            if (end == -1L) {
                end = song.getSize();
            }
            if ((src = streamSource.getSource(song)) instanceof File) {
                return this.factory.createAudioResponse(request, song, (File)src, pos, end);
            }
            if (src instanceof FileInputStream) {
                return this.factory.createAudioResponse(request, song, (FileInputStream)src, pos, end);
            }
            throw new IOException("Unknown source [" + src + "] for Song: " + song);
        }
        return null;
    }

    private long[] getRange(DaapRequest request) throws IOException {
        Header rangeHeader = request.getHeader("Range");
        if (rangeHeader != null) {
            try {
                int q;
                StringTokenizer tok = new StringTokenizer(rangeHeader.getValue(), "=");
                String key = tok.nextToken().trim();
                if (!key.equals("bytes")) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Unknown range type: " + key));
                    }
                    return null;
                }
                byte[] range = tok.nextToken().getBytes("ISO-8859-1");
                for (q = 0; q < range.length && range[q] != 45; ++q) {
                }
                long pos = -1L;
                long end = -1L;
                pos = Long.parseLong(new String(range, 0, q));
                if (range.length - ++q != 0) {
                    end = Long.parseLong(new String(range, q, range.length - q));
                }
                return new long[]{pos, end};
            }
            catch (NoSuchElementException err) {
                LOG.error((Object)err);
            }
            catch (NumberFormatException err) {
                LOG.error((Object)err);
            }
        }
        return new long[]{0L, -1L};
    }
}

