/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.RuntimeInvisibleAnnotations;
import org.apache.bcel.classfile.RuntimeInvisibleParameterAnnotations;
import org.apache.bcel.classfile.RuntimeVisibleAnnotations;
import org.apache.bcel.classfile.RuntimeVisibleParameterAnnotations;
import org.apache.bcel.generic.AnnotationEntryGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.util.ByteSequence;

public abstract class Utility {
    private static ThreadLocal consumed_chars = new ThreadLocal(){

        protected Object initialValue() {
            return new Integer(0);
        }
    };
    private static boolean wide = false;
    private static final int FREE_CHARS = 48;
    static int[] CHAR_MAP = new int[48];
    static int[] MAP_CHAR = new int[256];
    private static final char ESCAPE_CHAR = '$';

    static {
        int j = 0;
        int i = 65;
        while (i <= 90) {
            Utility.CHAR_MAP[j] = i;
            Utility.MAP_CHAR[i] = j++;
            ++i;
        }
        i = 103;
        while (i <= 122) {
            Utility.CHAR_MAP[j] = i;
            Utility.MAP_CHAR[i] = j++;
            ++i;
        }
        Utility.CHAR_MAP[j] = 36;
        Utility.MAP_CHAR[36] = j++;
        Utility.CHAR_MAP[j] = 95;
        Utility.MAP_CHAR[95] = j;
    }

    private static int unwrap(ThreadLocal tl) {
        return (Integer)tl.get();
    }

    private static void wrap(ThreadLocal tl, int value) {
        tl.set(new Integer(value));
    }

    public static final String accessToString(int access_flags) {
        return Utility.accessToString(access_flags, false);
    }

    public static final String accessToString(int access_flags, boolean for_class) {
        StringBuffer buf = new StringBuffer();
        int p = 0;
        int i = 0;
        while (p < 16384) {
            p = Utility.pow2(i);
            if ((access_flags & p) != 0 && (!for_class || p != 32 && p != 512)) {
                buf.append(Constants.ACCESS_NAMES[i]).append(" ");
            }
            ++i;
        }
        return buf.toString().trim();
    }

    public static final String classOrInterface(int access_flags) {
        return (access_flags & 0x200) != 0 ? "interface" : "class";
    }

    public static final String codeToString(byte[] code, ConstantPool constant_pool, int index, int length, boolean verbose) {
        StringBuffer buf = new StringBuffer(code.length * 20);
        ByteSequence stream = new ByteSequence(code);
        try {
            int i = 0;
            while (i < index) {
                Utility.codeToString(stream, constant_pool, verbose);
                ++i;
            }
            i = 0;
            while (stream.available() > 0) {
                if (length < 0 || i < length) {
                    String indices = Utility.fillup(String.valueOf(stream.getIndex()) + ":", 6, true, ' ');
                    buf.append(indices).append(Utility.codeToString(stream, constant_pool, verbose)).append('\n');
                }
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println(buf.toString());
            e.printStackTrace();
            throw new ClassFormatException("Byte code error: " + e);
        }
        return buf.toString();
    }

    public static final String codeToString(byte[] code, ConstantPool constant_pool, int index, int length) {
        return Utility.codeToString(code, constant_pool, index, length, true);
    }

    public static final String codeToString(ByteSequence bytes, ConstantPool constant_pool, boolean verbose) throws IOException {
        int i;
        short opcode = (short)bytes.readUnsignedByte();
        int default_offset = 0;
        int no_pad_bytes = 0;
        StringBuffer buf = new StringBuffer(Constants.OPCODE_NAMES[opcode]);
        if (opcode == 170 || opcode == 171) {
            int remainder = bytes.getIndex() % 4;
            no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
            i = 0;
            while (i < no_pad_bytes) {
                byte b = bytes.readByte();
                if (b != 0) {
                    System.err.println("Warning: Padding byte != 0 in " + Constants.OPCODE_NAMES[opcode] + ":" + b);
                }
                ++i;
            }
            default_offset = bytes.readInt();
        }
        switch (opcode) {
            case 170: {
                int low = bytes.readInt();
                int high = bytes.readInt();
                int offset = bytes.getIndex() - 12 - no_pad_bytes - 1;
                buf.append("\tdefault = ").append(default_offset += offset).append(", low = ").append(low).append(", high = ").append(high).append("(");
                int[] jump_table = new int[high - low + 1];
                int i2 = 0;
                while (i2 < jump_table.length) {
                    jump_table[i2] = offset + bytes.readInt();
                    buf.append(jump_table[i2]);
                    if (i2 < jump_table.length - 1) {
                        buf.append(", ");
                    }
                    ++i2;
                }
                buf.append(")");
                break;
            }
            case 171: {
                int npairs = bytes.readInt();
                int offset = bytes.getIndex() - 8 - no_pad_bytes - 1;
                int[] match = new int[npairs];
                int[] jump_table = new int[npairs];
                buf.append("\tdefault = ").append(default_offset += offset).append(", npairs = ").append(npairs).append(" (");
                int i2 = 0;
                while (i2 < npairs) {
                    match[i2] = bytes.readInt();
                    jump_table[i2] = offset + bytes.readInt();
                    buf.append("(").append(match[i2]).append(", ").append(jump_table[i2]).append(")");
                    if (i2 < npairs - 1) {
                        buf.append(", ");
                    }
                    ++i2;
                }
                buf.append(")");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                buf.append("\t\t#").append(bytes.getIndex() - 1 + bytes.readShort());
                break;
            }
            case 200: 
            case 201: {
                buf.append("\t\t#").append(bytes.getIndex() - 1 + bytes.readInt());
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int vindex;
                if (wide) {
                    vindex = bytes.readUnsignedShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                }
                buf.append("\t\t%").append(vindex);
                break;
            }
            case 196: {
                wide = true;
                buf.append("\t(wide)");
                break;
            }
            case 188: {
                buf.append("\t\t<").append(Constants.TYPE_NAMES[bytes.readByte()]).append(">");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t").append(constant_pool.constantToString(index, (byte)9)).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 187: 
            case 192: {
                buf.append("\t");
            }
            case 193: {
                int index = bytes.readUnsignedShort();
                buf.append("\t<").append(constant_pool.constantToString(index, (byte)7)).append(">").append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                int index = bytes.readUnsignedShort();
                buf.append("\t").append(constant_pool.constantToString(index, (byte)10)).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 185: {
                int index = bytes.readUnsignedShort();
                int nargs = bytes.readUnsignedByte();
                buf.append("\t").append(constant_pool.constantToString(index, (byte)11)).append(verbose ? " (" + index + ")\t" : "").append(nargs).append("\t").append(bytes.readUnsignedByte());
                break;
            }
            case 19: 
            case 20: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t").append(constant_pool.constantToString(index, constant_pool.getConstant(index).getTag())).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 18: {
                int index = bytes.readUnsignedByte();
                buf.append("\t\t").append(constant_pool.constantToString(index, constant_pool.getConstant(index).getTag())).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 189: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t<").append(Utility.compactClassName(constant_pool.getConstantString(index, (byte)7), false)).append(">").append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 197: {
                int index = bytes.readUnsignedShort();
                int dimensions = bytes.readUnsignedByte();
                buf.append("\t<").append(Utility.compactClassName(constant_pool.getConstantString(index, (byte)7), false)).append(">\t").append(dimensions).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 132: {
                short constant;
                int vindex;
                if (wide) {
                    vindex = bytes.readUnsignedShort();
                    constant = bytes.readShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                    constant = bytes.readByte();
                }
                buf.append("\t\t%").append(vindex).append("\t").append(constant);
                break;
            }
            default: {
                if (Constants.NO_OF_OPERANDS[opcode] <= 0) break;
                i = 0;
                while (i < Constants.TYPE_OF_OPERANDS[opcode].length) {
                    buf.append("\t\t");
                    switch (Constants.TYPE_OF_OPERANDS[opcode][i]) {
                        case 8: {
                            buf.append(bytes.readByte());
                            break;
                        }
                        case 9: {
                            buf.append(bytes.readShort());
                            break;
                        }
                        case 10: {
                            buf.append(bytes.readInt());
                            break;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                    ++i;
                }
                break block0;
            }
        }
        return buf.toString();
    }

    public static final String codeToString(ByteSequence bytes, ConstantPool constant_pool) throws IOException {
        return Utility.codeToString(bytes, constant_pool, true);
    }

    public static final String compactClassName(String str) {
        return Utility.compactClassName(str, true);
    }

    public static final String compactClassName(String str, String prefix, boolean chopit) {
        int len = prefix.length();
        str = str.replace('/', '.');
        if (chopit && str.startsWith(prefix) && str.substring(len).indexOf(46) == -1) {
            str = str.substring(len);
        }
        return str;
    }

    public static final String compactClassName(String str, boolean chopit) {
        return Utility.compactClassName(str, "java.lang.", chopit);
    }

    public static final int setBit(int flag, int i) {
        return flag | Utility.pow2(i);
    }

    public static final int clearBit(int flag, int i) {
        int bit = Utility.pow2(i);
        return (flag & bit) == 0 ? flag : flag ^ bit;
    }

    public static final boolean isSet(int flag, int i) {
        return (flag & Utility.pow2(i)) != 0;
    }

    public static final String methodTypeToSignature(String ret, String[] argv) throws ClassFormatException {
        String str;
        StringBuffer buf = new StringBuffer("(");
        if (argv != null) {
            int i = 0;
            while (i < argv.length) {
                str = Utility.getSignature(argv[i]);
                if (str.endsWith("V")) {
                    throw new ClassFormatException("Invalid type: " + argv[i]);
                }
                buf.append(str);
                ++i;
            }
        }
        str = Utility.getSignature(ret);
        buf.append(")").append(str);
        return buf.toString();
    }

    public static final String[] methodSignatureArgumentTypes(String signature) throws ClassFormatException {
        return Utility.methodSignatureArgumentTypes(signature, true);
    }

    public static final String[] methodSignatureArgumentTypes(String signature, boolean chopit) throws ClassFormatException {
        ArrayList<String> vec = new ArrayList<String>();
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                vec.add(Utility.signatureToString(signature.substring(index), chopit));
                index += Utility.unwrap(consumed_chars);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        return vec.toArray(new String[vec.size()]);
    }

    public static final String methodSignatureReturnType(String signature) throws ClassFormatException {
        return Utility.methodSignatureReturnType(signature, true);
    }

    public static final String methodSignatureReturnType(String signature, boolean chopit) throws ClassFormatException {
        String type;
        try {
            int index = signature.lastIndexOf(41) + 1;
            type = Utility.signatureToString(signature.substring(index), chopit);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        return type;
    }

    public static final String methodSignatureToString(String signature, String name, String access) {
        return Utility.methodSignatureToString(signature, name, access, true);
    }

    public static final String methodSignatureToString(String signature, String name, String access, boolean chopit) {
        return Utility.methodSignatureToString(signature, name, access, chopit, null);
    }

    public static final String methodSignatureToString(String signature, String name, String access, boolean chopit, LocalVariableTable vars) throws ClassFormatException {
        String type;
        StringBuffer buf = new StringBuffer("(");
        int var_index = access.indexOf("static") >= 0 ? 0 : 1;
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                String param_type = Utility.signatureToString(signature.substring(index), chopit);
                buf.append(param_type);
                if (vars != null) {
                    LocalVariable l = vars.getLocalVariable(var_index);
                    if (l != null) {
                        buf.append(" ").append(l.getName());
                    }
                } else {
                    buf.append(" arg").append(var_index);
                }
                var_index = "double".equals(param_type) || "long".equals(param_type) ? (var_index += 2) : ++var_index;
                buf.append(", ");
                index += Utility.unwrap(consumed_chars);
            }
            type = Utility.signatureToString(signature.substring(++index), chopit);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        if (buf.length() > 1) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        return String.valueOf(access) + (access.length() > 0 ? " " : "") + type + " " + name + buf.toString();
    }

    private static final int pow2(int n) {
        return 1 << n;
    }

    public static final String replace(String str, String old, String new_) {
        StringBuffer buf = new StringBuffer();
        try {
            int index = str.indexOf(old);
            if (index != -1) {
                int old_index = 0;
                while ((index = str.indexOf(old, old_index)) != -1) {
                    buf.append(str.substring(old_index, index));
                    buf.append(new_);
                    old_index = index + old.length();
                }
                buf.append(str.substring(old_index));
                str = buf.toString();
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.err.println(e);
        }
        return str;
    }

    public static final String signatureToString(String signature) {
        return Utility.signatureToString(signature, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String signatureToString(String signature, boolean chopit) {
        Utility.wrap(consumed_chars, 1);
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'L': {
                    int index = signature.indexOf(59);
                    if (index < 0) {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    Utility.wrap(consumed_chars, index + 1);
                    return Utility.compactClassName(signature.substring(1, index), chopit);
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuffer brackets = new StringBuffer();
                    int n = 0;
                    while (true) {
                        if (signature.charAt(n) != '[') {
                            int consumed_chars = n;
                            String type = Utility.signatureToString(signature.substring(n), chopit);
                            int _temp = Utility.unwrap(Utility.consumed_chars) + consumed_chars;
                            Utility.wrap(Utility.consumed_chars, _temp);
                            return String.valueOf(type) + brackets.toString();
                        }
                        brackets.append("[]");
                        ++n;
                    }
                }
                case 'V': {
                    return "void";
                }
            }
            throw new ClassFormatException("Invalid signature: `" + signature + "'");
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid signature: " + e + ":" + signature);
        }
    }

    public static String getSignature(String type) {
        StringBuffer buf = new StringBuffer();
        char[] chars = type.toCharArray();
        boolean char_found = false;
        boolean delim = false;
        int index = -1;
        int i = 0;
        block4: while (i < chars.length) {
            switch (chars[i]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!char_found) break;
                    delim = true;
                    break;
                }
                case '[': {
                    if (!char_found) {
                        throw new RuntimeException("Illegal type: " + type);
                    }
                    index = i;
                    break block4;
                }
                default: {
                    char_found = true;
                    if (delim) break;
                    buf.append(chars[i]);
                }
            }
            ++i;
        }
        int brackets = 0;
        if (index > 0) {
            brackets = Utility.countBrackets(type.substring(index));
        }
        type = buf.toString();
        buf.setLength(0);
        int i2 = 0;
        while (i2 < brackets) {
            buf.append('[');
            ++i2;
        }
        boolean found = false;
        int i3 = 4;
        while (i3 <= 12 && !found) {
            if (Constants.TYPE_NAMES[i3].equals(type)) {
                found = true;
                buf.append(Constants.SHORT_TYPE_NAMES[i3]);
            }
            ++i3;
        }
        if (!found) {
            buf.append('L').append(type.replace('.', '/')).append(';');
        }
        return buf.toString();
    }

    private static int countBrackets(String brackets) {
        char[] chars = brackets.toCharArray();
        int count = 0;
        boolean open = false;
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '[': {
                    if (open) {
                        throw new RuntimeException("Illegally nested brackets:" + brackets);
                    }
                    open = true;
                    break;
                }
                case ']': {
                    if (!open) {
                        throw new RuntimeException("Illegally nested brackets:" + brackets);
                    }
                    open = false;
                    ++count;
                }
            }
            ++i;
        }
        if (open) {
            throw new RuntimeException("Illegally nested brackets:" + brackets);
        }
        return count;
    }

    public static final byte typeOfMethodSignature(String signature) throws ClassFormatException {
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = signature.lastIndexOf(41) + 1;
            return Utility.typeOfSignature(signature.substring(index));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
    }

    public static final byte typeOfSignature(String signature) throws ClassFormatException {
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return 8;
                }
                case 'C': {
                    return 5;
                }
                case 'D': {
                    return 7;
                }
                case 'F': {
                    return 6;
                }
                case 'I': {
                    return 10;
                }
                case 'J': {
                    return 11;
                }
                case 'L': {
                    return 14;
                }
                case '[': {
                    return 13;
                }
                case 'V': {
                    return 12;
                }
                case 'Z': {
                    return 4;
                }
                case 'S': {
                    return 9;
                }
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        throw new ClassFormatException("Invalid method signature: " + signature);
    }

    public static short searchOpcode(String name) {
        name = name.toLowerCase(Locale.ENGLISH);
        short i = 0;
        while (i < Constants.OPCODE_NAMES.length) {
            if (Constants.OPCODE_NAMES[i].equals(name)) {
                return i;
            }
            i = (short)(i + 1);
        }
        return -1;
    }

    private static final short byteToShort(byte b) {
        return b < 0 ? (short)(256 + b) : (short)b;
    }

    public static final String toHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            short b = Utility.byteToShort(bytes[i]);
            String hex = Integer.toString(b, 16);
            if (b < 16) {
                buf.append('0');
            }
            buf.append(hex);
            if (i < bytes.length - 1) {
                buf.append(' ');
            }
            ++i;
        }
        return buf.toString();
    }

    public static final String format(int i, int length, boolean left_justify, char fill) {
        return Utility.fillup(Integer.toString(i), length, left_justify, fill);
    }

    public static final String fillup(String str, int length, boolean left_justify, char fill) {
        int len = length - str.length();
        char[] buf = new char[len < 0 ? 0 : len];
        int j = 0;
        while (j < buf.length) {
            buf[j] = fill;
            ++j;
        }
        if (left_justify) {
            return String.valueOf(str) + new String(buf);
        }
        return String.valueOf(new String(buf)) + str;
    }

    static final boolean equals(byte[] a, byte[] b) {
        int size = a.length;
        if (size != b.length) {
            return false;
        }
        int i = 0;
        while (i < size) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final void printArray(PrintStream out, Object[] obj) {
        out.println(Utility.printArray(obj, true));
    }

    public static final void printArray(PrintWriter out, Object[] obj) {
        out.println(Utility.printArray(obj, true));
    }

    public static final String printArray(Object[] obj) {
        return Utility.printArray(obj, true);
    }

    public static final String printArray(Object[] obj, boolean braces) {
        return Utility.printArray(obj, braces, false);
    }

    public static final String printArray(Object[] obj, boolean braces, boolean quote) {
        if (obj == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (braces) {
            buf.append('{');
        }
        int i = 0;
        while (i < obj.length) {
            if (obj[i] != null) {
                buf.append(quote ? "\"" : "").append(obj[i].toString()).append(quote ? "\"" : "");
            } else {
                buf.append("null");
            }
            if (i < obj.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        if (braces) {
            buf.append('}');
        }
        return buf.toString();
    }

    public static boolean isJavaIdentifierPart(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_';
    }

    public static String encode(byte[] bytes, boolean compress) throws IOException {
        if (compress) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            gos.write(bytes, 0, bytes.length);
            gos.close();
            baos.close();
            bytes = baos.toByteArray();
        }
        CharArrayWriter caw = new CharArrayWriter();
        JavaWriter jw = new JavaWriter(caw);
        int i = 0;
        while (i < bytes.length) {
            int in = bytes[i] & 0xFF;
            jw.write(in);
            ++i;
        }
        return caw.toString();
    }

    public static byte[] decode(String s, boolean uncompress) throws IOException {
        int ch;
        char[] chars = s.toCharArray();
        CharArrayReader car = new CharArrayReader(chars);
        JavaReader jr = new JavaReader(car);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((ch = jr.read()) >= 0) {
            bos.write(ch);
        }
        bos.close();
        car.close();
        jr.close();
        byte[] bytes = bos.toByteArray();
        if (uncompress) {
            int b;
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(bytes));
            byte[] tmp = new byte[bytes.length * 3];
            int count = 0;
            while ((b = gis.read()) >= 0) {
                tmp[count++] = (byte)b;
            }
            bytes = new byte[count];
            System.arraycopy(tmp, 0, bytes, 0, count);
        }
        return bytes;
    }

    public static final String convertString(String label) {
        char[] ch = label.toCharArray();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < ch.length) {
            switch (ch[i]) {
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                case '\'': {
                    buf.append("\\'");
                    break;
                }
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                default: {
                    buf.append(ch[i]);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static Attribute[] getAnnotationAttributes(ConstantPoolGen cp, List vec) {
        if (vec.size() == 0) {
            return null;
        }
        try {
            int countVisible = 0;
            int countInvisible = 0;
            int i = 0;
            while (i < vec.size()) {
                AnnotationEntryGen a = (AnnotationEntryGen)vec.get(i);
                if (a.isRuntimeVisible()) {
                    ++countVisible;
                } else {
                    ++countInvisible;
                }
                ++i;
            }
            ByteArrayOutputStream rvaBytes = new ByteArrayOutputStream();
            ByteArrayOutputStream riaBytes = new ByteArrayOutputStream();
            DataOutputStream rvaDos = new DataOutputStream(rvaBytes);
            DataOutputStream riaDos = new DataOutputStream(riaBytes);
            rvaDos.writeShort(countVisible);
            riaDos.writeShort(countInvisible);
            int i2 = 0;
            while (i2 < vec.size()) {
                AnnotationEntryGen a = (AnnotationEntryGen)vec.get(i2);
                if (a.isRuntimeVisible()) {
                    a.dump(rvaDos);
                } else {
                    a.dump(riaDos);
                }
                ++i2;
            }
            rvaDos.close();
            riaDos.close();
            byte[] rvaData = rvaBytes.toByteArray();
            byte[] riaData = riaBytes.toByteArray();
            int rvaIndex = -1;
            int riaIndex = -1;
            if (rvaData.length > 2) {
                rvaIndex = cp.addUtf8("RuntimeVisibleAnnotations");
            }
            if (riaData.length > 2) {
                riaIndex = cp.addUtf8("RuntimeInvisibleAnnotations");
            }
            ArrayList<Annotations> newAttributes = new ArrayList<Annotations>();
            if (rvaData.length > 2) {
                newAttributes.add(new RuntimeVisibleAnnotations(rvaIndex, rvaData.length, new DataInputStream(new ByteArrayInputStream(rvaData)), cp.getConstantPool()));
            }
            if (riaData.length > 2) {
                newAttributes.add(new RuntimeInvisibleAnnotations(riaIndex, riaData.length, new DataInputStream(new ByteArrayInputStream(riaData)), cp.getConstantPool()));
            }
            return newAttributes.toArray(new Attribute[newAttributes.size()]);
        }
        catch (IOException e) {
            System.err.println("IOException whilst processing annotations");
            e.printStackTrace();
            return null;
        }
    }

    public static Attribute[] getParameterAnnotationAttributes(ConstantPoolGen cp, List[] vec) {
        int[] visCount = new int[vec.length];
        int totalVisCount = 0;
        int[] invisCount = new int[vec.length];
        int totalInvisCount = 0;
        try {
            int i = 0;
            while (i < vec.length) {
                List l = vec[i];
                if (l != null) {
                    for (AnnotationEntryGen element : l) {
                        if (element.isRuntimeVisible()) {
                            int n = i;
                            visCount[n] = visCount[n] + 1;
                            ++totalVisCount;
                            continue;
                        }
                        int n = i;
                        invisCount[n] = invisCount[n] + 1;
                        ++totalInvisCount;
                    }
                }
                ++i;
            }
            ByteArrayOutputStream rvaBytes = new ByteArrayOutputStream();
            DataOutputStream rvaDos = new DataOutputStream(rvaBytes);
            rvaDos.writeByte(vec.length);
            int i2 = 0;
            while (i2 < vec.length) {
                rvaDos.writeShort(visCount[i2]);
                if (visCount[i2] > 0) {
                    List l = vec[i2];
                    for (AnnotationEntryGen element : l) {
                        if (!element.isRuntimeVisible()) continue;
                        element.dump(rvaDos);
                    }
                }
                ++i2;
            }
            rvaDos.close();
            ByteArrayOutputStream riaBytes = new ByteArrayOutputStream();
            DataOutputStream riaDos = new DataOutputStream(riaBytes);
            riaDos.writeByte(vec.length);
            int i3 = 0;
            while (i3 < vec.length) {
                riaDos.writeShort(invisCount[i3]);
                if (invisCount[i3] > 0) {
                    List l = vec[i3];
                    for (AnnotationEntryGen element : l) {
                        if (element.isRuntimeVisible()) continue;
                        element.dump(riaDos);
                    }
                }
                ++i3;
            }
            riaDos.close();
            byte[] rvaData = rvaBytes.toByteArray();
            byte[] riaData = riaBytes.toByteArray();
            int rvaIndex = -1;
            int riaIndex = -1;
            if (totalVisCount > 0) {
                rvaIndex = cp.addUtf8("RuntimeVisibleParameterAnnotations");
            }
            if (totalInvisCount > 0) {
                riaIndex = cp.addUtf8("RuntimeInvisibleParameterAnnotations");
            }
            ArrayList<ParameterAnnotations> newAttributes = new ArrayList<ParameterAnnotations>();
            if (totalVisCount > 0) {
                newAttributes.add(new RuntimeVisibleParameterAnnotations(rvaIndex, rvaData.length, new DataInputStream(new ByteArrayInputStream(rvaData)), cp.getConstantPool()));
            }
            if (totalInvisCount > 0) {
                newAttributes.add(new RuntimeInvisibleParameterAnnotations(riaIndex, riaData.length, new DataInputStream(new ByteArrayInputStream(riaData)), cp.getConstantPool()));
            }
            return newAttributes.toArray(new Attribute[newAttributes.size()]);
        }
        catch (IOException e) {
            System.err.println("IOException whilst processing parameter annotations");
            e.printStackTrace();
            return null;
        }
    }

    private static class JavaReader
    extends FilterReader {
        public JavaReader(Reader in) {
            super(in);
        }

        public int read() throws IOException {
            int b = this.in.read();
            if (b != 36) {
                return b;
            }
            int i = this.in.read();
            if (i < 0) {
                return -1;
            }
            if (i >= 48 && i <= 57 || i >= 97 && i <= 102) {
                int j = this.in.read();
                if (j < 0) {
                    return -1;
                }
                char[] tmp = new char[]{(char)i, (char)j};
                int s = Integer.parseInt(new String(tmp), 16);
                return s;
            }
            return MAP_CHAR[i];
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int i = 0;
            while (i < len) {
                cbuf[off + i] = (char)this.read();
                ++i;
            }
            return len;
        }
    }

    private static class JavaWriter
    extends FilterWriter {
        public JavaWriter(Writer out) {
            super(out);
        }

        public void write(int b) throws IOException {
            if (Utility.isJavaIdentifierPart((char)b) && b != 36) {
                this.out.write(b);
            } else {
                this.out.write(36);
                if (b >= 0 && b < 48) {
                    this.out.write(CHAR_MAP[b]);
                } else {
                    char[] tmp = Integer.toHexString(b).toCharArray();
                    if (tmp.length == 1) {
                        this.out.write(48);
                        this.out.write(tmp[0]);
                    } else {
                        this.out.write(tmp[0]);
                        this.out.write(tmp[1]);
                    }
                }
            }
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            int i = 0;
            while (i < len) {
                this.write(cbuf[off + i]);
                ++i;
            }
        }

        public void write(String str, int off, int len) throws IOException {
            this.write(str.toCharArray(), off, len);
        }
    }
}

