/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.filters;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Element;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.filters.Filter;
import edu.uci.ics.jung.graph.filters.GraphAssemblyRecord;
import edu.uci.ics.jung.utils.UserData;
import java.util.Iterator;
import java.util.Set;

public class UnassembledGraph {
    protected String name;
    protected Filter filter;
    protected Set vertexSet;
    protected Set edgeSet;
    protected UnassembledGraph previousGraph;
    protected Graph originalGraph;

    public UnassembledGraph(Filter f, Set vertices, Set edges, Graph original) {
        this.filter = f;
        this.vertexSet = vertices;
        this.edgeSet = edges;
        this.previousGraph = null;
        this.originalGraph = original;
        this.name = this.filter.getName();
        this.checkData();
    }

    public UnassembledGraph(String name, Set vertices, Set edges, Graph original) {
        this.filter = null;
        this.vertexSet = vertices;
        this.edgeSet = edges;
        this.previousGraph = null;
        this.originalGraph = original;
        this.name = name;
        this.checkData();
    }

    public UnassembledGraph(Filter f, Set vertices, Set edges, UnassembledGraph previous) {
        this.filter = f;
        this.vertexSet = vertices;
        this.edgeSet = edges;
        this.previousGraph = previous;
        this.originalGraph = previous.getOriginalGraph();
        this.name = this.filter.getName();
        this.checkData();
    }

    public String getFilterName() {
        String rv = this.name;
        if (this.previousGraph != null) {
            rv = rv + ":" + this.previousGraph.getFilterName();
        }
        return rv;
    }

    private void checkData() {
        Element e;
        Iterator iter = this.vertexSet.iterator();
        while (iter.hasNext()) {
            e = (Vertex)iter.next();
            if (e.getGraph() == this.originalGraph) continue;
            throw new FatalException("Vertex not in original");
        }
        iter = this.edgeSet.iterator();
        while (iter.hasNext()) {
            e = (Edge)iter.next();
            if (e.getGraph() == this.originalGraph) continue;
            throw new FatalException("Edge not in original");
        }
    }

    public Graph getOriginalGraph() {
        return this.originalGraph;
    }

    public Set getUntouchedVertices() {
        return this.vertexSet;
    }

    public Set getUntouchedEdges() {
        return this.edgeSet;
    }

    public String toString() {
        if (this.previousGraph == null) {
            return "UNASSEMBLED<" + this.originalGraph + ">";
        }
        return "UNASSEMBLED<" + this.previousGraph + ">";
    }

    public Graph assemble(boolean shouldPreserveRecord) {
        Graph subgraph = (Graph)this.originalGraph.newInstance();
        if (shouldPreserveRecord) {
            subgraph.addUserDatum(GraphAssemblyRecord.FILTER_GRAPH_KEY, new GraphAssemblyRecord(this), UserData.REMOVE);
        }
        Set localVertices = this.getUntouchedVertices();
        Iterator iter = localVertices.iterator();
        while (iter.hasNext()) {
            ArchetypeVertex newV = (ArchetypeVertex)iter.next();
            newV.copy(subgraph);
        }
        iter = this.getUntouchedEdges().iterator();
        while (iter.hasNext()) {
            ArchetypeEdge newE = (ArchetypeEdge)iter.next();
            if (!localVertices.containsAll(newE.getIncidentVertices())) continue;
            newE.copy(subgraph);
        }
        return subgraph;
    }

    public Graph assemble() {
        return this.assemble(false);
    }
}

