/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.AbstractArchetypeEdge;
import edu.uci.ics.jung.graph.impl.AbstractSparseGraph;
import edu.uci.ics.jung.graph.impl.AbstractSparseVertex;
import edu.uci.ics.jung.utils.Pair;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractSparseEdge
extends AbstractArchetypeEdge
implements Edge {
    protected Vertex mFrom;
    protected Vertex mTo;
    private static int nextGlobalEdgeID = 0;

    public AbstractSparseEdge(Vertex from, Vertex to) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("Vertices passed in can not be null");
        }
        if (from.getGraph() != to.getGraph()) {
            throw new IllegalArgumentException("Vertices must be from same graph");
        }
        if (from.getGraph() == null || to.getGraph() == null) {
            throw new IllegalArgumentException("Orphaned vertices can not be connected by an edge");
        }
        this.mFrom = from;
        this.mTo = to;
        this.id = nextGlobalEdgeID++;
    }

    public String toString() {
        return "E" + String.valueOf(this.id) + "(" + this.mFrom.toString() + "," + this.mTo.toString() + ")";
    }

    void addGraph_internal(AbstractSparseGraph graph) {
        if (graph != this.mFrom.getGraph()) {
            throw new IllegalArgumentException("graph to which edge is being added does not match graph of incident vertices " + this.mFrom + " " + this.mTo);
        }
        super.addGraph_internal(graph);
        if (this.mFrom instanceof AbstractSparseVertex) {
            ((AbstractSparseVertex)this.mFrom).addNeighbor_internal(this, this.mTo);
        }
        if (this.mTo instanceof AbstractSparseVertex) {
            ((AbstractSparseVertex)this.mTo).addNeighbor_internal(this, this.mFrom);
        }
    }

    public Set getIncidentVertices() {
        LinkedHashSet<Vertex> vertices = new LinkedHashSet<Vertex>(2);
        vertices.add(this.mFrom);
        vertices.add(this.mTo);
        return Collections.unmodifiableSet(vertices);
    }

    public Vertex getOpposite(Vertex vertex) {
        if (vertex == this.mFrom) {
            return this.mTo;
        }
        if (vertex == this.mTo) {
            return this.mFrom;
        }
        throw new IllegalArgumentException("Vertex " + vertex + " is not incident to this edge " + this);
    }

    public int numVertices() {
        return 2;
    }

    public boolean isIncident(ArchetypeVertex v) {
        return v == this.mFrom || v == this.mTo;
    }

    public ArchetypeEdge copy(ArchetypeGraph newGraph) {
        AbstractSparseEdge e = (AbstractSparseEdge)super.copy(newGraph);
        e.mFrom = (Vertex)this.mFrom.getEqualVertex(newGraph);
        e.mTo = (Vertex)this.mTo.getEqualVertex(newGraph);
        ((Graph)newGraph).addEdge(e);
        return e;
    }

    public Pair getEndpoints() {
        return new Pair(this.mFrom, this.mTo);
    }
}

