/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import edu.uci.ics.jung.visualization.GraphElementAccessor;
import edu.uci.ics.jung.visualization.RadiusGraphElementAccessor;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class ISOMLayout
extends AbstractLayout {
    private static final Object ISOM_KEY = "edu.uci.ics.jung.ISOM_Visualization_Key";
    private Object key = null;
    private int maxEpoch;
    private int epoch;
    private int radiusConstantTime;
    private int radius;
    private int minRadius;
    private double adaption;
    private double initialAdaption;
    private double minAdaption;
    protected GraphElementAccessor elementAccessor = new RadiusGraphElementAccessor(this);
    private double coolingFactor;
    private Vector queue = new Vector();
    private String status = null;
    ISOMVertexData tempISOM;
    Coordinates tempXYD;

    public Object getIsomKey() {
        if (this.key == null) {
            this.key = new Pair(this, ISOM_KEY);
        }
        return this.key;
    }

    public String getStatus() {
        return this.status;
    }

    public ISOMLayout(Graph g) {
        super(g);
    }

    protected void initialize_local() {
        this.maxEpoch = 2000;
        this.epoch = 1;
        this.radiusConstantTime = 100;
        this.radius = 5;
        this.minRadius = 1;
        this.adaption = this.initialAdaption = 0.9;
        this.minAdaption = 0.0;
        this.coolingFactor = 2.0;
    }

    protected void initialize_local_vertex(Vertex v) {
        ISOMVertexData vd = this.getISOMVertexData(v);
        if (vd == null) {
            vd = new ISOMVertexData();
            v.addUserDatum(this.getIsomKey(), vd, UserData.REMOVE);
        }
        vd.visited = false;
    }

    public void advancePositions() {
        this.status = "epoch: " + this.epoch + "; ";
        if (this.epoch < this.maxEpoch) {
            this.adjust();
            this.updateParameters();
            this.status = this.status + " status: running";
        } else {
            this.status = this.status + "adaption: " + this.adaption + "; ";
            this.status = this.status + "status: done";
        }
    }

    private synchronized void adjust() {
        this.tempISOM = new ISOMVertexData();
        this.tempXYD = new Coordinates();
        this.tempXYD.setX(10.0 + Math.random() * this.getCurrentSize().getWidth());
        this.tempXYD.setY(10.0 + Math.random() * this.getCurrentSize().getHeight());
        Vertex winner = this.elementAccessor.getVertex(this.tempXYD.getX(), this.tempXYD.getY());
        while (true) {
            try {
                Iterator iter = this.getVisibleVertices().iterator();
                while (iter.hasNext()) {
                    Vertex v = (Vertex)iter.next();
                    ISOMVertexData ivd = this.getISOMVertexData(v);
                    ivd.distance = 0;
                    ivd.visited = false;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        this.adjustVertex(winner);
    }

    private synchronized void updateParameters() {
        ++this.epoch;
        double factor = Math.exp(-1.0 * this.coolingFactor * (1.0 * (double)this.epoch / (double)this.maxEpoch));
        this.adaption = Math.max(this.minAdaption, factor * this.initialAdaption);
        if (this.radius > this.minRadius && this.epoch % this.radiusConstantTime == 0) {
            --this.radius;
        }
    }

    private synchronized void adjustVertex(Vertex v) {
        this.queue.removeAllElements();
        ISOMVertexData ivd = this.getISOMVertexData(v);
        ivd.distance = 0;
        ivd.visited = true;
        this.queue.add(v);
        block2: while (!this.queue.isEmpty()) {
            Vertex current = (Vertex)this.queue.remove(0);
            ISOMVertexData currData = this.getISOMVertexData(current);
            Coordinates currXYData = this.getCoordinates(current);
            double dx = this.tempXYD.getX() - currXYData.getX();
            double dy = this.tempXYD.getY() - currXYData.getY();
            double factor = this.adaption / Math.pow(2.0, currData.distance);
            currXYData.addX(factor * dx);
            currXYData.addY(factor * dy);
            if (currData.distance >= this.radius) continue;
            Set s = current.getNeighbors();
            while (true) {
                try {
                    Iterator iter = s.iterator();
                    while (iter.hasNext()) {
                        Vertex child = (Vertex)iter.next();
                        ISOMVertexData childData = this.getISOMVertexData(child);
                        if (childData == null || childData.visited) continue;
                        childData.visited = true;
                        childData.distance = currData.distance + 1;
                        this.queue.addElement(child);
                    }
                    continue block2;
                }
                catch (ConcurrentModificationException cme) {
                    continue;
                }
                break;
            }
        }
    }

    public ISOMVertexData getISOMVertexData(Vertex v) {
        return (ISOMVertexData)v.getUserDatum(this.getIsomKey());
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean incrementsAreDone() {
        return false;
    }

    public static class ISOMVertexData {
        public DoubleMatrix1D disp;
        int distance;
        boolean visited;

        public ISOMVertexData() {
            this.initialize();
        }

        public void initialize() {
            this.disp = new DenseDoubleMatrix1D(2);
            this.distance = 0;
            this.visited = false;
        }

        public double getXDisp() {
            return this.disp.get(0);
        }

        public double getYDisp() {
            return this.disp.get(1);
        }

        public void setDisp(double x, double y) {
            this.disp.set(0, x);
            this.disp.set(1, y);
        }

        public void incrementDisp(double x, double y) {
            this.disp.set(0, this.disp.get(0) + x);
            this.disp.set(1, this.disp.get(1) + y);
        }

        public void decrementDisp(double x, double y) {
            this.disp.set(0, this.disp.get(0) - x);
            this.disp.set(1, this.disp.get(1) - y);
        }
    }
}

