/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.impl.crooked;

import edu.uci.ics.jung.graph.Element;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.utils.UserData;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import samples.preview_new_graphdraw.event.ClickEvent;
import samples.preview_new_graphdraw.event.ClickListener;
import samples.preview_new_graphdraw.impl.GraphLayoutPanel;
import samples.preview_new_graphdraw.impl.GraphLayoutPanelMouseListener;
import samples.preview_new_graphdraw.impl.crooked.CrookedRenderer;
import samples.preview_new_graphdraw.impl.crooked.CrookedSpringLayout;
import samples.preview_new_graphdraw.iter.LocalGraphDraw;
import samples.preview_new_graphdraw.staticlayouts.RandomLayout;

public class CrookedRun
extends Applet {
    static JLabel msgBox;

    public void start() {
        this.begin();
    }

    private Component begin() {
        UndirectedSparseGraph g = new UndirectedSparseGraph();
        SparseVertex v1 = new SparseVertex();
        g.addVertex(v1);
        SparseVertex v2 = new SparseVertex();
        g.addVertex(v2);
        SparseVertex v3 = new SparseVertex();
        g.addVertex(v3);
        g.addEdge(new UndirectedSparseEdge(v1, v2));
        g.addEdge(new UndirectedSparseEdge(v1, v3));
        g.addEdge(new UndirectedSparseEdge(v3, v2));
        GraphLayoutPanelMouseListener.VERTEX_CLICK_THRESHOLD = 1000.0;
        CrookedRenderer vr = new CrookedRenderer();
        Dimension d = new Dimension(400, 400);
        LocalGraphDraw lgd = new LocalGraphDraw(g, new RandomLayout(), new CrookedSpringLayout(), vr, vr, d, true);
        lgd.getPanel().setClickPolicy(GraphLayoutPanel.EDGE_AND_VERTEX_POLICY);
        Selecter selecter = new Selecter();
        lgd.getPanel().addClickListener(selecter);
        lgd.getPanel().addMouseListener(selecter);
        lgd.start();
        msgBox = new JLabel(" ");
        this.setLayout(new BorderLayout());
        this.add((Component)lgd.getPanel(), "Center");
        this.add((Component)msgBox, "South");
        return this;
    }

    public static void main(String[] s) {
        JFrame jf = new JFrame();
        jf.getContentPane().add(new CrookedRun().begin());
        jf.pack();
        jf.setVisible(true);
        jf.setDefaultCloseOperation(3);
    }

    public static class Selecter
    extends MouseAdapter
    implements ClickListener {
        Element selected = null;

        public void edgeClicked(ClickEvent ece) {
            this.select(ece);
        }

        public void vertexClicked(ClickEvent vce) {
            this.select(vce);
        }

        private synchronized void select(ClickEvent vce) {
            if (this.selected != null) {
                this.selected.removeUserDatum("SELECTED");
            }
            this.selected = vce.getGraphObject();
            this.selected.setUserDatum("SELECTED", "SELECTED", UserData.SHARED);
            msgBox.setText("SELECTED: " + vce.getGraphObject());
        }

        public synchronized void mouseClicked(MouseEvent e) {
            if (!e.isConsumed()) {
                if (this.selected != null) {
                    this.selected.removeUserDatum("SELECTED");
                }
                this.selected = null;
                msgBox.setText("---");
            }
        }
    }
}

