/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    boolean isVisible;
    boolean isShowing;
    int blinkRate;
    Image image;
    Font font;

    public Caret(Canvas parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    boolean blinkCaret() {
        if (!this.isVisible) {
            return true;
        }
        if (!this.isShowing) {
            return this.showCaret();
        }
        if (this.blinkRate == 0) {
            return true;
        }
        return this.hideCaret();
    }

    void createWidget() {
        super.createWidget();
        this.blinkRate = this.display.getCaretBlinkTime();
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    boolean drawCaret() {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.isDisposed()) {
            return false;
        }
        int parentHandle = this.parent.handle;
        if (!this.parent.isDrawing(parentHandle)) {
            return false;
        }
        int nWidth = this.width;
        int nHeight = this.height;
        if (nWidth <= 0) {
            nWidth = 1;
        }
        int window = OS.GetControlOwner(parentHandle);
        int port = OS.GetWindowPort(window);
        int[] currentPort = new int[1];
        OS.GetPort(currentPort);
        OS.SetPort(port);
        int oldClip = OS.NewRgn();
        int visibleRgn = this.parent.getVisibleRegion(parentHandle, true);
        OS.GetClip(oldClip);
        OS.SetClip(visibleRgn);
        Rect rect = new Rect();
        OS.GetControlBounds(parentHandle, rect);
        CGPoint pt = new CGPoint();
        int[] contentView = new int[1];
        OS.HIViewFindByID(OS.HIViewGetRoot(window), OS.kHIViewWindowContentID(), contentView);
        OS.HIViewConvertPoint(pt, OS.HIViewGetSuperview(parentHandle), contentView[0]);
        rect.left = (short)(rect.left + (int)pt.x);
        rect.top = (short)(rect.top + (int)pt.y);
        int left = rect.left + this.x;
        int top = rect.top + this.y;
        if (this.image == null) {
            OS.SetRect(rect, (short)left, (short)top, (short)(left + nWidth), (short)(top + nHeight));
            RGBColor color = new RGBColor();
            color.red = (short)-1;
            color.green = (short)-1;
            color.blue = (short)-1;
            OS.RGBBackColor(color);
            OS.InvertRect(rect);
        } else {
            int imageHandle = this.image.handle;
            nWidth = OS.CGImageGetWidth(imageHandle);
            nHeight = OS.CGImageGetHeight(imageHandle);
            int bpl = OS.CGImageGetBytesPerRow(imageHandle);
            Rect bounds = new Rect();
            bounds.right = (short)nWidth;
            bounds.bottom = (short)nHeight;
            Rect portRect = new Rect();
            OS.GetWindowBounds(window, (short)33, portRect);
            OS.SetRect(rect, (short)(left += portRect.left), (short)(top += portRect.top), (short)(left + nWidth), (short)(top + nHeight));
            int[] gWorld = new int[1];
            OS.NewGWorldFromPtr(gWorld, 32, bounds, 0, 0, 0, this.image.data, bpl);
            int[] curPort = new int[1];
            int[] curGWorld = new int[1];
            OS.GetGWorld(curPort, curGWorld);
            OS.SetGWorld(gWorld[0], curGWorld[0]);
            int portBitMap = OS.GetPortBitMapForCopyBits(port);
            int gworldBitMap = OS.GetPortBitMapForCopyBits(gWorld[0]);
            OS.OffsetRgn(visibleRgn, portRect.left, portRect.top);
            OS.CopyBits(gworldBitMap, portBitMap, bounds, rect, (short)6, visibleRgn);
            OS.OffsetRgn(visibleRgn, -portRect.left, -portRect.top);
            OS.SetGWorld(curPort[0], curGWorld[0]);
            OS.DisposeGWorld(gWorld[0]);
        }
        OS.SetClip(oldClip);
        OS.DisposeRgn(visibleRgn);
        OS.DisposeRgn(oldClip);
        OS.SetPort(currentPort[0]);
        return true;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            return new Rectangle(this.x, this.y, rect.width, rect.height);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            return new Point(rect.width, rect.height);
        }
        return new Point(this.width, this.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hideCaret() {
        if (!this.isShowing) {
            return true;
        }
        this.isShowing = false;
        return this.drawCaret();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.isVisible && this.parent.isVisible() && this.parent.hasFocus();
    }

    boolean isFocusCaret() {
        return this == this.display.currentCaret;
    }

    void killFocus() {
        if (this.display.currentCaret != this) {
            return;
        }
        this.display.setCurrentCaret(null);
        if (this.isVisible) {
            this.hideCaret();
        }
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getCaret()) {
            this.parent.setCaret(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentCaret == this) {
            this.hideCaret();
            this.display.setCurrentCaret(null);
        }
        this.parent = null;
        this.image = null;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        if (this.x == x && this.y == y && this.width == width && this.height == height) {
            return;
        }
        boolean isFocus = this.isFocusCaret();
        if (isFocus && this.isVisible) {
            this.hideCaret();
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        if (isFocus && this.isVisible) {
            this.showCaret();
        }
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    void setFocus() {
        if (this.display.currentCaret == this) {
            return;
        }
        this.display.setCurrentCaret(this);
        if (this.isVisible) {
            this.showCaret();
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
    }

    public void setImage(Image image) {
        boolean isFocus;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((isFocus = this.isFocusCaret()) && this.isVisible) {
            this.hideCaret();
        }
        this.image = image;
        if (isFocus && this.isVisible) {
            this.showCaret();
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, this.width, this.height);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setBounds(this.x, this.y, width, height);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setSize(size.x, size.y);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible == this.isVisible) {
            return;
        }
        this.isVisible = visible;
        if (!this.isFocusCaret()) {
            return;
        }
        if (this.isVisible) {
            this.showCaret();
        } else {
            this.hideCaret();
        }
    }

    boolean showCaret() {
        if (this.isShowing) {
            return true;
        }
        this.isShowing = true;
        return this.drawCaret();
    }
}

