/*
 * Decompiled with CFR 0.152.
 */
package com.apple.cocoa.foundation;

import com.apple.cocoa.foundation.NSRuntime;
import java.awt.Point;

public class NSPoint
implements Cloneable {
    public static final NSPoint ZeroPoint;
    float _x = 0.0f;
    float _y = 0.0f;

    public NSPoint() {
    }

    public NSPoint(float f, float f2) {
        if (f != f || f2 != f2) {
            throw new IllegalArgumentException("cannot create NSPoint with NaN x (" + f + ") or y (" + f2 + ")");
        }
        this._x = f;
        this._y = f2;
    }

    public NSPoint(Point point) {
        this(point.x, point.y);
    }

    public NSPoint(NSPoint nSPoint) {
        this(nSPoint.x(), nSPoint.y());
    }

    private static boolean is_float_char(char c) {
        return '0' <= c && c <= '9' || '+' == c || '-' == c || '.' == c;
    }

    public static NSPoint fromString(String string) {
        int n;
        int n2;
        int n3 = string.length();
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        for (n2 = 0; n2 < n3 && !NSPoint.is_float_char(cArray[n2]); ++n2) {
        }
        for (n = n2; n < n3 && NSPoint.is_float_char(cArray[n]); ++n) {
        }
        float f = new Float(string.substring(n2, n)).floatValue();
        for (n2 = n; n2 < n3 && !NSPoint.is_float_char(cArray[n2]); ++n2) {
        }
        for (n = n2; n < n3 && NSPoint.is_float_char(cArray[n]); ++n) {
        }
        float f2 = new Float(string.substring(n2, n)).floatValue();
        return new NSPoint(f, f2);
    }

    public float x() {
        return this._x;
    }

    public float y() {
        return this._y;
    }

    public float distanceToPoint(NSPoint nSPoint) {
        float f = nSPoint.x() - this.x();
        float f2 = nSPoint.y() - this.y();
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public boolean isEqualToPoint(NSPoint nSPoint) {
        return this.x() == nSPoint.x() && this.y() == nSPoint.y();
    }

    public boolean equals(Object object) {
        if (object instanceof NSPoint) {
            return this.isEqualToPoint((NSPoint)object);
        }
        return false;
    }

    public int hashCode() {
        return Math.round(this.x() + this.y());
    }

    public String toString() {
        return "{" + this.x() + ", " + this.y() + "}";
    }

    public Point toAWTPoint() {
        return new Point((int)Math.floor(this.x()), (int)Math.floor(this.y()));
    }

    public Object clone() {
        return new NSPoint(this);
    }

    static {
        NSRuntime.loadLibrary("ObjCJava");
        NSRuntime.loadLibrary("FoundationJava");
        ZeroPoint = new NSPoint();
    }
}

