/*
 * Decompiled with CFR 0.152.
 */
package com.apple.cocoa.foundation._private;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class NSReflect {
    public static byte[] className(Class clazz) {
        return clazz.getName().replace('.', '/').getBytes();
    }

    public static String typeToSignature(Class clazz) {
        String string = clazz.getName();
        if (string.equals("byte")) {
            return "B";
        }
        if (string.equals("boolean")) {
            return "Z";
        }
        if (string.equals("char")) {
            return "C";
        }
        if (string.equals("short")) {
            return "S";
        }
        if (string.equals("int")) {
            return "I";
        }
        if (string.equals("long")) {
            return "J";
        }
        if (string.equals("float")) {
            return "F";
        }
        if (string.equals("double")) {
            return "D";
        }
        if (string.equals("void")) {
            return "V";
        }
        if (string.charAt(0) == '[') {
            return string.replace('.', '/');
        }
        return "L" + string.replace('.', '/') + ";";
    }

    public static String typeToSignature(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(NSReflect.typeToSignature(classArray[i]));
        }
        return stringBuffer.toString();
    }

    public static int isStatic(Member member) {
        if (Modifier.isStatic(member.getModifiers())) {
            return 1;
        }
        return 0;
    }

    public static byte[] name(Member member) {
        return member.getName().getBytes();
    }

    public static byte[][] name(Member[] memberArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        for (int i = 0; i < memberArray.length; ++i) {
            vector.addElement(NSReflect.name(memberArray[i]));
        }
        if (vector.size() > 0) {
            vector.toArray();
        }
        return null;
    }

    public static byte[] signature(Field field) {
        return NSReflect.typeToSignature(field.getType()).getBytes();
    }

    public static byte[][] signature(Field[] fieldArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        for (int i = 0; i < fieldArray.length; ++i) {
            vector.addElement(NSReflect.signature(fieldArray[i]));
        }
        if (vector.size() > 0) {
            vector.toArray();
        }
        return null;
    }

    public static byte[] signature(Method method) {
        return ("(" + NSReflect.typeToSignature(method.getParameterTypes()) + ")" + NSReflect.typeToSignature(method.getReturnType())).getBytes();
    }

    public static byte[][] signature(Method[] methodArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        for (int i = 0; i < methodArray.length; ++i) {
            vector.addElement(NSReflect.signature(methodArray[i]));
        }
        if (vector.size() > 0) {
            vector.toArray();
        }
        return null;
    }

    public static byte[] signature(Constructor constructor) {
        return ("(" + NSReflect.typeToSignature(constructor.getParameterTypes()) + ")V").getBytes();
    }

    public static byte[][] signature(Constructor[] constructorArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        for (int i = 0; i < constructorArray.length; ++i) {
            vector.addElement(NSReflect.signature(constructorArray[i]));
        }
        if (vector.size() > 0) {
            vector.toArray();
        }
        return null;
    }

    public static int hasSignature(Field field, byte[] byArray) {
        if (new String(byArray).equals(NSReflect.typeToSignature(field.getType()))) {
            return 1;
        }
        return 0;
    }

    public static int hasSignature(Method method, byte[] byArray) {
        if (new String(byArray).equals("(" + NSReflect.typeToSignature(method.getParameterTypes()) + ")" + NSReflect.typeToSignature(method.getReturnType()))) {
            return 1;
        }
        return 0;
    }

    public static int hasSignature(Constructor constructor, byte[] byArray) {
        if (new String(byArray).equals("(" + NSReflect.typeToSignature(constructor.getParameterTypes()) + ")V")) {
            return 1;
        }
        return 0;
    }

    public static Field[] fieldLookup(Class clazz, int n) {
        Field[] fieldArray;
        try {
            fieldArray = clazz.getDeclaredFields();
        }
        catch (Throwable throwable) {
            return null;
        }
        Vector<Field> vector = new Vector<Field>();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (NSReflect.isStatic(fieldArray[i]) != n) continue;
            vector.addElement(fieldArray[i]);
        }
        if (vector.size() > 0) {
            return (Field[])vector.toArray();
        }
        return null;
    }

    public static Field fieldLookup(Class clazz, byte[] byArray, int n, int n2) {
        Field field = null;
        String string = new String(byArray);
        if (clazz == null) {
            return null;
        }
        try {
            field = clazz.getDeclaredField(string);
        }
        catch (Throwable throwable) {
            field = null;
        }
        if (field == null) {
            if (n == 1 || n2 == 0) {
                return null;
            }
            return NSReflect.fieldLookup(clazz.getSuperclass(), byArray, 0, 1);
        }
        if (NSReflect.isStatic(field) == n) {
            return field;
        }
        return null;
    }

    public static Method[] methodLookup(Class clazz, int n) {
        Method[] methodArray;
        try {
            methodArray = clazz.getDeclaredMethods();
        }
        catch (Throwable throwable) {
            return null;
        }
        Vector<Method> vector = new Vector<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (NSReflect.isStatic(methodArray[i]) != n) continue;
            vector.addElement(methodArray[i]);
        }
        if (vector.size() > 0) {
            return (Method[])vector.toArray();
        }
        return null;
    }

    public static Method methodLookup(Class clazz, byte[] byArray, int n, int n2, int n3) {
        Method method = null;
        Method[] methodArray = null;
        String string = new String(byArray);
        if (clazz == null) {
            return null;
        }
        try {
            methodArray = clazz.getDeclaredMethods();
        }
        catch (Throwable throwable) {
            methodArray = null;
        }
        if (methodArray != null) {
            for (int i = 0; i < methodArray.length && (!string.equals((method = methodArray[i]).getName()) || n >= 0 && method.getParameterTypes().length != n); ++i) {
                method = null;
            }
        }
        if (method == null) {
            if (n2 == 1 || n3 == 0) {
                return null;
            }
            return NSReflect.methodLookup(clazz.getSuperclass(), byArray, n, 0, 1);
        }
        if (NSReflect.isStatic(method) == n2) {
            return method;
        }
        return null;
    }

    public static Constructor[] constructorLookup(Class clazz) {
        Constructor<?>[] constructorArray;
        try {
            constructorArray = clazz.getDeclaredConstructors();
        }
        catch (Throwable throwable) {
            return null;
        }
        Vector vector = new Vector();
        for (int i = 0; i < constructorArray.length; ++i) {
            vector.addElement(constructorArray[i]);
        }
        if (vector.size() > 0) {
            return (Constructor[])vector.toArray();
        }
        return null;
    }

    public static Constructor constructorLookup(Class clazz, byte[] byArray) {
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = null;
        String string = new String(byArray);
        try {
            constructorArray = clazz.getDeclaredConstructors();
        }
        catch (Throwable throwable) {
            constructorArray = null;
        }
        if (constructorArray != null) {
            for (int i = 0; i < constructorArray.length && !string.equals((constructor = constructorArray[i]).getName()); ++i) {
                constructor = null;
            }
        }
        if (constructor == null) {
            return NSReflect.constructorLookup(clazz.getSuperclass(), byArray);
        }
        return constructor;
    }

    public static byte[] fieldSignature(Class clazz, byte[] byArray, int n, int n2) {
        Field field = NSReflect.fieldLookup(clazz, byArray, n, n2);
        if (field != null) {
            return NSReflect.signature(field);
        }
        return "".getBytes();
    }

    public static byte[] methodSignature(Class clazz, byte[] byArray, int n, int n2) {
        Method method = NSReflect.methodLookup(clazz, byArray, -1, n, n2);
        if (method != null) {
            byte[] byArray2 = NSReflect.signature(method);
            return byArray2;
        }
        return "".getBytes();
    }

    public static byte[] methodSignature(Class clazz, byte[] byArray, int n, int n2, int n3) {
        Method method = NSReflect.methodLookup(clazz, byArray, n, n2, n3);
        if (method != null) {
            byte[] byArray2 = NSReflect.signature(method);
            return byArray2;
        }
        return "".getBytes();
    }

    public static byte[] constructorSignature(Class clazz, byte[] byArray) {
        Constructor constructor = NSReflect.constructorLookup(clazz, byArray);
        if (constructor != null) {
            return NSReflect.signature(constructor);
        }
        return "".getBytes();
    }
}

