/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.sound.spi;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.PCMProcessor;
import org.kc7bfi.jflac.metadata.StreamInfo;
import org.kc7bfi.jflac.sound.spi.RingedAudioInputStream;
import org.kc7bfi.jflac.util.ByteData;

public class Flac2PcmAudioInputStream
extends RingedAudioInputStream
implements PCMProcessor {
    private FLACDecoder decoder;
    private StreamInfo streamInfo;
    private Thread decodeThread = null;

    public Flac2PcmAudioInputStream(InputStream in, AudioFormat format, long length) {
        this(in, format, length, 2048);
    }

    public Flac2PcmAudioInputStream(InputStream in, AudioFormat format, long length, int size) {
        super(in, format, length, size);
    }

    protected void fill() throws IOException {
        if (this.decodeThread == null) {
            this.initDecoder();
        }
    }

    protected void initDecoder() throws IOException {
        this.decoder = new FLACDecoder(this.in);
        this.decoder.addPCMProcessor(this);
        this.decodeThread = new Thread(new Runnable(){

            public void run() {
                try {
                    Flac2PcmAudioInputStream.this.decoder.decode();
                    System.out.println("Frames decoded");
                    Flac2PcmAudioInputStream.this.buffer.setEOF(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.decodeThread.start();
    }

    public void processStreamInfo(StreamInfo streamInfo) {
        this.streamInfo = streamInfo;
    }

    public void processPCM(ByteData pcm) {
        this.buffer.resize(pcm.getLen() * 2);
        this.buffer.put(pcm.getData(), 0, pcm.getLen());
    }
}

