/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTArguments;
import net.sourceforge.pmd.ast.ASTClassDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.ast.ASTInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTNestedClassDeclaration;
import net.sourceforge.pmd.ast.ASTNestedInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTUnmodifiedClassDeclaration;
import net.sourceforge.pmd.ast.AccessNode;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;

public final class ConstructorCallsOverridableMethodRule
extends AbstractRule {
    private static final NullEvalPackage nullEvalPackage = new NullEvalPackage();
    private final List evalPackages = new ArrayList();
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTArguments;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTExplicitConstructorInvocation;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryExpression;

    private EvalPackage getCurrentEvalPackage() {
        return (EvalPackage)this.evalPackages.get(this.evalPackages.size() - 1);
    }

    private void putEvalPackage(EvalPackage ep) {
        this.evalPackages.add(ep);
    }

    private void removeCurrentEvalPackage() {
        this.evalPackages.remove(this.evalPackages.size() - 1);
    }

    private void clearEvalPackages() {
        this.evalPackages.clear();
    }

    private Object visitClassDec(AccessNode node, Object data) {
        String className = ((ASTUnmodifiedClassDeclaration)node.jjtGetChild(0)).getImage();
        if (!node.isFinal() && !node.isStatic()) {
            this.putEvalPackage(new EvalPackage(className));
        } else {
            this.putEvalPackage(nullEvalPackage);
        }
        if (node instanceof ASTClassDeclaration) {
            super.visit((ASTClassDeclaration)node, data);
        } else {
            super.visit((ASTNestedClassDeclaration)node, data);
        }
        if (!(this.getCurrentEvalPackage() instanceof NullEvalPackage)) {
            RuleContext ctx;
            while (this.evaluateDangerOfMethods(this.getCurrentEvalPackage().allMethodsOfClass)) {
            }
            this.evaluateDangerOfConstructors1(this.getCurrentEvalPackage().allPrivateConstructorsOfClass, this.getCurrentEvalPackage().allMethodsOfClass.keySet());
            while (this.evaluateDangerOfConstructors2(this.getCurrentEvalPackage().allPrivateConstructorsOfClass)) {
            }
            Iterator it = this.getCurrentEvalPackage().calledMethods.iterator();
            while (it.hasNext()) {
                MethodInvocation meth = (MethodInvocation)it.next();
                Iterator it2 = this.getCurrentEvalPackage().allMethodsOfClass.keySet().iterator();
                while (it2.hasNext()) {
                    MethodHolder h = (MethodHolder)it2.next();
                    if (!h.isDangerous()) continue;
                    String methName = h.getASTMethodDeclarator().getImage();
                    int count = h.getASTMethodDeclarator().getParameterCount();
                    if (!meth.getName().equals(methName) || meth.getArgumentCount() != count) continue;
                    ctx = (RuleContext)data;
                    ctx.getReport().addRuleViolation(this.createRuleViolation(ctx, meth.getASTPrimaryExpression().getBeginLine()));
                }
            }
            Iterator privConstIter = this.getCurrentEvalPackage().allPrivateConstructorsOfClass.keySet().iterator();
            while (privConstIter.hasNext()) {
                ConstructorHolder ch = (ConstructorHolder)privConstIter.next();
                if (!ch.isDangerous()) continue;
                int paramCount = ch.getASTConstructorDeclaration().getParameterCount();
                Iterator calledConstIter = this.getCurrentEvalPackage().calledConstructors.iterator();
                while (calledConstIter.hasNext()) {
                    ConstructorInvocation ci = (ConstructorInvocation)calledConstIter.next();
                    if (ci.getArgumentCount() != paramCount) continue;
                    ctx = (RuleContext)data;
                    ctx.getReport().addRuleViolation(this.createRuleViolation(ctx, ci.getASTExplicitConstructorInvocation().getBeginLine()));
                }
            }
        }
        this.removeCurrentEvalPackage();
        return data;
    }

    private boolean evaluateDangerOfMethods(Map classMethodMap) {
        boolean found = false;
        Iterator methodsIter = classMethodMap.keySet().iterator();
        while (methodsIter.hasNext()) {
            MethodHolder h = (MethodHolder)methodsIter.next();
            List calledMeths = (List)classMethodMap.get(h);
            Iterator calledMethsIter = calledMeths.iterator();
            block1: while (calledMethsIter.hasNext() && !h.isDangerous()) {
                MethodInvocation meth = (MethodInvocation)calledMethsIter.next();
                Iterator innerMethsIter = classMethodMap.keySet().iterator();
                while (innerMethsIter.hasNext()) {
                    MethodHolder h3 = (MethodHolder)innerMethsIter.next();
                    if (!h3.isDangerous()) continue;
                    String matchMethodName = h3.getASTMethodDeclarator().getImage();
                    int matchMethodParamCount = h3.getASTMethodDeclarator().getParameterCount();
                    if (!matchMethodName.equals(meth.getName()) || matchMethodParamCount != meth.getArgumentCount()) continue;
                    h.setDangerous(true);
                    found = true;
                    continue block1;
                }
            }
        }
        return found;
    }

    private void evaluateDangerOfConstructors1(Map classConstructorMap, Set evaluatedMethods) {
        Iterator constIter = classConstructorMap.keySet().iterator();
        while (constIter.hasNext()) {
            ConstructorHolder ch = (ConstructorHolder)constIter.next();
            if (ch.isDangerous()) continue;
            List calledMeths = (List)classConstructorMap.get(ch);
            Iterator calledMethsIter = calledMeths.iterator();
            block1: while (calledMethsIter.hasNext() && !ch.isDangerous()) {
                MethodInvocation meth = (MethodInvocation)calledMethsIter.next();
                String methName = meth.getName();
                int methArgCount = meth.getArgumentCount();
                Iterator evaldMethsIter = evaluatedMethods.iterator();
                while (evaldMethsIter.hasNext()) {
                    MethodHolder h = (MethodHolder)evaldMethsIter.next();
                    if (!h.isDangerous()) continue;
                    String matchName = h.getASTMethodDeclarator().getImage();
                    int matchParamCount = h.getASTMethodDeclarator().getParameterCount();
                    if (!methName.equals(matchName) || methArgCount != matchParamCount) continue;
                    ch.setDangerous(true);
                    continue block1;
                }
            }
        }
    }

    private boolean evaluateDangerOfConstructors2(Map classConstructorMap) {
        boolean found = false;
        Iterator constIter = classConstructorMap.keySet().iterator();
        while (constIter.hasNext()) {
            ConstructorHolder ch = (ConstructorHolder)constIter.next();
            ConstructorInvocation calledC = ch.getCalledConstructor();
            if (calledC == null || ch.isDangerous()) continue;
            int cCount = calledC.getArgumentCount();
            Iterator innerConstIter = classConstructorMap.keySet().iterator();
            while (innerConstIter.hasNext() && !ch.isDangerous()) {
                int matchConstArgCount;
                ConstructorHolder h2 = (ConstructorHolder)innerConstIter.next();
                if (!h2.isDangerous() || (matchConstArgCount = h2.getASTConstructorDeclaration().getParameterCount()) != cCount) continue;
                ch.setDangerous(true);
                found = true;
            }
        }
        return found;
    }

    public Object visit(ASTCompilationUnit node, Object data) {
        this.clearEvalPackages();
        return super.visit(node, data);
    }

    public Object visit(ASTClassDeclaration node, Object data) {
        return this.visitClassDec(node, data);
    }

    public Object visit(ASTNestedClassDeclaration node, Object data) {
        return this.visitClassDec(node, data);
    }

    public Object visit(ASTInterfaceDeclaration node, Object data) {
        this.putEvalPackage(nullEvalPackage);
        Object o = super.visit(node, data);
        this.removeCurrentEvalPackage();
        return o;
    }

    public Object visit(ASTNestedInterfaceDeclaration node, Object data) {
        this.putEvalPackage(nullEvalPackage);
        Object o = super.visit(node, data);
        this.removeCurrentEvalPackage();
        return o;
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        if (!(this.getCurrentEvalPackage() instanceof NullEvalPackage)) {
            ArrayList calledMethodsOfConstructor = new ArrayList();
            ConstructorHolder ch = new ConstructorHolder(node);
            ConstructorCallsOverridableMethodRule.addCalledMethodsOfNode(node, calledMethodsOfConstructor, this.getCurrentEvalPackage().m_ClassName);
            if (!node.isPrivate()) {
                this.getCurrentEvalPackage().calledMethods.addAll(calledMethodsOfConstructor);
                ASTExplicitConstructorInvocation eci = ch.getASTExplicitConstructorInvocation();
                if (eci != null && eci.isThis()) {
                    this.getCurrentEvalPackage().calledConstructors.add(ch.getCalledConstructor());
                }
            } else {
                this.getCurrentEvalPackage().allPrivateConstructorsOfClass.put(ch, calledMethodsOfConstructor);
            }
        }
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclarator node, Object data) {
        if (!(this.getCurrentEvalPackage() instanceof NullEvalPackage)) {
            AccessNode parent = (AccessNode)node.jjtGetParent();
            MethodHolder h = new MethodHolder(node);
            if (!(parent.isPrivate() || parent.isStatic() || parent.isFinal())) {
                h.setDangerous(true);
            }
            ArrayList l = new ArrayList();
            ConstructorCallsOverridableMethodRule.addCalledMethodsOfNode((SimpleNode)parent, l, this.getCurrentEvalPackage().m_ClassName);
            this.getCurrentEvalPackage().allMethodsOfClass.put(h, l);
        }
        return super.visit(node, data);
    }

    private static void addCalledMethodsOfNode(AccessNode node, List calledMethods, String className) {
        ArrayList expressions = new ArrayList();
        node.findChildrenOfType(class$net$sourceforge$pmd$ast$ASTPrimaryExpression == null ? (class$net$sourceforge$pmd$ast$ASTPrimaryExpression = ConstructorCallsOverridableMethodRule.class$("net.sourceforge.pmd.ast.ASTPrimaryExpression")) : class$net$sourceforge$pmd$ast$ASTPrimaryExpression, expressions, false);
        ConstructorCallsOverridableMethodRule.addCalledMethodsOfNodeImpl(expressions, calledMethods, className);
    }

    private static void addCalledMethodsOfNode(SimpleNode node, List calledMethods, String className) {
        ArrayList expressions = new ArrayList();
        node.findChildrenOfType(class$net$sourceforge$pmd$ast$ASTPrimaryExpression == null ? (class$net$sourceforge$pmd$ast$ASTPrimaryExpression = ConstructorCallsOverridableMethodRule.class$("net.sourceforge.pmd.ast.ASTPrimaryExpression")) : class$net$sourceforge$pmd$ast$ASTPrimaryExpression, expressions);
        ConstructorCallsOverridableMethodRule.addCalledMethodsOfNodeImpl(expressions, calledMethods, className);
    }

    private static void addCalledMethodsOfNodeImpl(List expressions, List calledMethods, String className) {
        Iterator it = expressions.iterator();
        while (it.hasNext()) {
            ASTPrimaryExpression ape = (ASTPrimaryExpression)it.next();
            MethodInvocation meth = ConstructorCallsOverridableMethodRule.findMethod(ape, className);
            if (meth == null) continue;
            calledMethods.add(meth);
        }
    }

    private static MethodInvocation findMethod(ASTPrimaryExpression node, String className) {
        if (node.jjtGetNumChildren() > 0 && node.jjtGetChild(0).jjtGetNumChildren() > 0 && node.jjtGetChild(0).jjtGetChild(0) instanceof ASTLiteral) {
            return null;
        }
        MethodInvocation meth = MethodInvocation.getMethod(node);
        boolean found = false;
        if (meth != null && meth.getReferenceNames().size() == 0 && !meth.isSuper()) {
            List packClass = meth.getQualifierNames();
            if (packClass.size() > 0) {
                Iterator it = packClass.iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    if (!name.equals(className)) continue;
                    found = true;
                    break;
                }
            } else {
                found = true;
            }
        }
        if (found) {
            return meth;
        }
        return null;
    }

    private static String getNameFromPrefix(ASTPrimaryPrefix node) {
        Node nnode;
        String name = null;
        if (node.jjtGetNumChildren() == 1 && (nnode = node.jjtGetChild(0)) instanceof ASTName) {
            name = ((ASTName)nnode).getImage();
        }
        return name;
    }

    private static String getNameFromSuffix(ASTPrimarySuffix node) {
        return node.getImage();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class NullEvalPackage
    extends EvalPackage {
        public NullEvalPackage() {
            this.m_ClassName = "";
            this.calledMethods = Collections.EMPTY_LIST;
            this.allMethodsOfClass = Collections.EMPTY_MAP;
            this.calledConstructors = Collections.EMPTY_LIST;
            this.allPrivateConstructorsOfClass = Collections.EMPTY_MAP;
        }
    }

    private static class EvalPackage {
        public String m_ClassName;
        public List calledMethods;
        public Map allMethodsOfClass;
        public List calledConstructors;
        public Map allPrivateConstructorsOfClass;

        public EvalPackage() {
        }

        public EvalPackage(String className) {
            this.m_ClassName = className;
            this.calledMethods = new ArrayList();
            this.allMethodsOfClass = new HashMap();
            this.calledConstructors = new ArrayList();
            this.allPrivateConstructorsOfClass = new HashMap();
        }
    }

    private final class ConstructorHolder {
        private ASTConstructorDeclaration m_Cd;
        private boolean m_Dangerous = false;
        private ConstructorInvocation m_Ci;
        private boolean m_CiInitialized = false;

        public ConstructorHolder(ASTConstructorDeclaration cd) {
            this.m_Cd = cd;
        }

        public ASTConstructorDeclaration getASTConstructorDeclaration() {
            return this.m_Cd;
        }

        public ConstructorInvocation getCalledConstructor() {
            if (!this.m_CiInitialized) {
                this.initCI();
            }
            return this.m_Ci;
        }

        public ASTExplicitConstructorInvocation getASTExplicitConstructorInvocation() {
            ASTExplicitConstructorInvocation eci = null;
            if (!this.m_CiInitialized) {
                this.initCI();
            }
            if (this.m_Ci != null) {
                eci = this.m_Ci.getASTExplicitConstructorInvocation();
            }
            return eci;
        }

        private void initCI() {
            ArrayList expressions = new ArrayList();
            this.m_Cd.findChildrenOfType(class$net$sourceforge$pmd$ast$ASTExplicitConstructorInvocation == null ? (class$net$sourceforge$pmd$ast$ASTExplicitConstructorInvocation = ConstructorCallsOverridableMethodRule.class$("net.sourceforge.pmd.ast.ASTExplicitConstructorInvocation")) : class$net$sourceforge$pmd$ast$ASTExplicitConstructorInvocation, expressions);
            if (expressions.size() > 0) {
                ASTExplicitConstructorInvocation eci = (ASTExplicitConstructorInvocation)expressions.get(0);
                this.m_Ci = new ConstructorInvocation(eci);
            }
            this.m_CiInitialized = true;
        }

        public boolean isDangerous() {
            return this.m_Dangerous;
        }

        public void setDangerous(boolean dangerous) {
            this.m_Dangerous = dangerous;
        }
    }

    private final class MethodHolder {
        private ASTMethodDeclarator m_Amd;
        private boolean m_Dangerous = false;

        public MethodHolder(ASTMethodDeclarator amd) {
            this.m_Amd = amd;
        }

        public ASTMethodDeclarator getASTMethodDeclarator() {
            return this.m_Amd;
        }

        public boolean isDangerous() {
            return this.m_Dangerous;
        }

        public void setDangerous(boolean dangerous) {
            this.m_Dangerous = dangerous;
        }
    }

    private final class ConstructorInvocation {
        private ASTExplicitConstructorInvocation m_Eci;
        private String name;
        private int count = 0;

        public ConstructorInvocation(ASTExplicitConstructorInvocation eci) {
            this.m_Eci = eci;
            ArrayList l = new ArrayList();
            eci.findChildrenOfType(class$net$sourceforge$pmd$ast$ASTArguments == null ? (class$net$sourceforge$pmd$ast$ASTArguments = ConstructorCallsOverridableMethodRule.class$("net.sourceforge.pmd.ast.ASTArguments")) : class$net$sourceforge$pmd$ast$ASTArguments, l);
            if (l.size() > 0) {
                ASTArguments aa = (ASTArguments)l.get(0);
                this.count = aa.getArgumentCount();
            }
            this.name = eci.getImage();
        }

        public ASTExplicitConstructorInvocation getASTExplicitConstructorInvocation() {
            return this.m_Eci;
        }

        public int getArgumentCount() {
            return this.count;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class MethodInvocation {
        private String m_Name;
        private ASTPrimaryExpression m_Ape;
        private List m_ReferenceNames;
        private List m_QualifierNames;
        private int m_ArgumentSize;
        private boolean m_Super;

        private MethodInvocation(ASTPrimaryExpression ape, List qualifierNames, List referenceNames, String name, int argumentSize, boolean superCall) {
            this.m_Ape = ape;
            this.m_QualifierNames = qualifierNames;
            this.m_ReferenceNames = referenceNames;
            this.m_Name = name;
            this.m_ArgumentSize = argumentSize;
            this.m_Super = superCall;
        }

        public boolean isSuper() {
            return this.m_Super;
        }

        public String getName() {
            return this.m_Name;
        }

        public int getArgumentCount() {
            return this.m_ArgumentSize;
        }

        public List getReferenceNames() {
            return this.m_ReferenceNames;
        }

        public List getQualifierNames() {
            return this.m_QualifierNames;
        }

        public ASTPrimaryExpression getASTPrimaryExpression() {
            return this.m_Ape;
        }

        public static MethodInvocation getMethod(ASTPrimaryExpression node) {
            Node lastNode;
            MethodInvocation meth = null;
            int i = node.jjtGetNumChildren();
            if (i > 1 && (lastNode = node.jjtGetChild(i - 1)).jjtGetNumChildren() == 1 && lastNode.jjtGetChild(0) instanceof ASTArguments) {
                String name;
                StringTokenizer st;
                String toParse;
                Node child;
                ArrayList<String> varNames = new ArrayList<String>();
                ArrayList<String> packagesAndClasses = new ArrayList<String>();
                String methodName = null;
                ASTArguments args = (ASTArguments)lastNode.jjtGetChild(0);
                int numOfArguments = args.getArgumentCount();
                boolean superFirst = false;
                int thisIndex = -1;
                int x = 0;
                while (x < i - 1) {
                    SimpleNode child2;
                    child = node.jjtGetChild(x);
                    if (child instanceof ASTPrimarySuffix) {
                        child2 = (ASTPrimarySuffix)child;
                        if (child2.getImage() == null && child2.jjtGetNumChildren() == 0) {
                            thisIndex = x;
                            break;
                        }
                    } else if (child instanceof ASTPrimaryPrefix && ConstructorCallsOverridableMethodRule.getNameFromPrefix((ASTPrimaryPrefix)(child2 = (ASTPrimaryPrefix)child)) == null) {
                        if (child2.getImage() == null) {
                            thisIndex = x;
                            break;
                        }
                        superFirst = true;
                        thisIndex = x;
                        break;
                    }
                    ++x;
                }
                if (thisIndex != -1) {
                    if (superFirst) {
                        ASTPrimaryPrefix child2 = (ASTPrimaryPrefix)node.jjtGetChild(0);
                        String name2 = child2.getImage();
                        if (i == 2) {
                            methodName = name2;
                        } else {
                            varNames.add(name2);
                        }
                        x = 1;
                        while (x < i - 1) {
                            child = node.jjtGetChild(x);
                            ASTPrimarySuffix ps = (ASTPrimarySuffix)child;
                            if (!ps.isArguments()) {
                                String name3 = ((ASTPrimarySuffix)child).getImage();
                                if (x == i - 2) {
                                    methodName = name3;
                                } else {
                                    varNames.add(name3);
                                }
                            }
                            ++x;
                        }
                    } else {
                        if (thisIndex == 1) {
                            ASTPrimaryPrefix child3 = (ASTPrimaryPrefix)node.jjtGetChild(0);
                            toParse = ConstructorCallsOverridableMethodRule.getNameFromPrefix(child3);
                            st = new StringTokenizer(toParse, ".");
                            while (st.hasMoreTokens()) {
                                packagesAndClasses.add(st.nextToken());
                            }
                        }
                        x = thisIndex + 1;
                        while (x < i - 1) {
                            child = (ASTPrimarySuffix)node.jjtGetChild(x);
                            if (!((ASTPrimarySuffix)child).isArguments()) {
                                name = ConstructorCallsOverridableMethodRule.getNameFromSuffix((ASTPrimarySuffix)child);
                                if (x == i - 2) {
                                    methodName = name;
                                } else {
                                    varNames.add(name);
                                }
                            }
                            ++x;
                        }
                    }
                } else {
                    ASTPrimaryPrefix child4 = (ASTPrimaryPrefix)node.jjtGetChild(0);
                    toParse = ConstructorCallsOverridableMethodRule.getNameFromPrefix(child4);
                    st = new StringTokenizer(toParse, ".");
                    while (st.hasMoreTokens()) {
                        String value = st.nextToken();
                        if (!st.hasMoreTokens()) {
                            if (i == 2) {
                                methodName = value;
                                continue;
                            }
                            varNames.add(value);
                            continue;
                        }
                        varNames.add(value);
                    }
                    x = 1;
                    while (x < i - 1) {
                        child = (ASTPrimarySuffix)node.jjtGetChild(x);
                        if (!((ASTPrimarySuffix)child).isArguments()) {
                            name = ConstructorCallsOverridableMethodRule.getNameFromSuffix((ASTPrimarySuffix)child);
                            if (x == i - 2) {
                                methodName = name;
                            } else {
                                varNames.add(name);
                            }
                        }
                        ++x;
                    }
                }
                meth = new MethodInvocation(node, packagesAndClasses, varNames, methodName, numOfArguments, superFirst);
            }
            return meth;
        }

        public void show() {
            System.out.println("<MethodInvocation>");
            List pkg = this.getQualifierNames();
            System.out.println("  <Qualifiers>");
            Iterator it = pkg.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                System.out.println("    " + name);
            }
            System.out.println("  </Qualifiers>");
            System.out.println("  <Super>" + this.isSuper() + "</Super>");
            List vars = this.getReferenceNames();
            System.out.println("  <References>");
            Iterator it2 = vars.iterator();
            while (it2.hasNext()) {
                String name = (String)it2.next();
                System.out.println("    " + name);
            }
            System.out.println("  </References>");
            System.out.println("  <Name>" + this.getName() + "</Name>");
            System.out.println("</MethodInvocation>");
        }
    }
}

