/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.jaxen.DocumentNavigator;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.XPath;

public class XPathRule
extends AbstractRule {
    private XPath xpath;

    public Object visit(ASTCompilationUnit node, Object data) {
        try {
            this.init();
            Iterator iter = this.xpath.selectNodes((Object)node).iterator();
            while (iter.hasNext()) {
                SimpleNode actualNode = (SimpleNode)iter.next();
                RuleContext ctx = (RuleContext)data;
                ctx.getReport().addRuleViolation(this.createRuleViolation(ctx, actualNode.getBeginLine(), this.getMessage()));
            }
        }
        catch (JaxenException ex) {
            XPathRule.throwJaxenAsRuntime(ex);
        }
        return data;
    }

    private void init() throws JaxenException {
        if (this.xpath == null) {
            String path = this.getStringProperty("xpath");
            String subst = this.getStringProperty("subst");
            if (subst != null && subst.length() > 0) {
                path = MessageFormat.format(path, subst);
            }
            this.xpath = new BaseXPath(path, (Navigator)new DocumentNavigator());
        }
    }

    private static void throwJaxenAsRuntime(final JaxenException ex) {
        throw new RuntimeException(){

            public void printStackTrace() {
                super.printStackTrace();
                ex.printStackTrace();
            }

            public void printStackTrace(PrintWriter writer) {
                super.printStackTrace(writer);
                ex.printStackTrace(writer);
            }

            public void printStackTrace(PrintStream stream) {
                super.printStackTrace(stream);
                ex.printStackTrace(stream);
            }

            public String getMessage() {
                return super.getMessage() + ex.getMessage();
            }
        };
    }
}

