/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.pmd.PMDDirectory;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.swingui.AnalysisViewer;
import net.sourceforge.pmd.swingui.ComponentFactory;
import net.sourceforge.pmd.swingui.LoadRootDirectories;
import net.sourceforge.pmd.swingui.MessageDialog;
import net.sourceforge.pmd.swingui.Preferences;
import net.sourceforge.pmd.swingui.PreferencesEditor;
import net.sourceforge.pmd.swingui.RulesEditor;
import net.sourceforge.pmd.swingui.SearchViewer;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.SetupFilesEvent;
import net.sourceforge.pmd.swingui.event.SetupFilesEventListener;

public class PMDViewer
extends JFrame {
    private int m_disabledCounter;
    private boolean m_firstLayout = true;
    private TabbedPane m_tabbedPane;
    private GlassPaneMouseListener m_glassPaneMouseListener;
    private static PMDViewer m_pmdViewer;

    private PMDViewer() {
        super("PMD Java Source Code Analyzer");
        m_pmdViewer = this;
        Dimension windowSize = ComponentFactory.adjustWindowSize(1200, 1000);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (windowSize.width >= screenSize.width) {
            windowSize.width = screenSize.width - 10;
        }
        if (windowSize.height >= screenSize.height) {
            windowSize.height = screenSize.height - 20;
        }
        int windowLocationX = (screenSize.width - windowSize.width) / 2;
        int windowLocationY = (screenSize.height - windowSize.height) / 2;
        this.setSize(windowSize);
        this.setLocation(windowLocationX, windowLocationY);
        this.setResizable(true);
        this.setDefaultCloseOperation(3);
        try {
            PMDDirectory.open(Preferences.getPreferences().getCurrentPathToPMD());
        }
        catch (PMDException pmdException) {
            String message = pmdException.getMessage();
            Exception exception = pmdException.getReason();
            MessageDialog.show(this, message, exception);
        }
        this.m_tabbedPane = new TabbedPane();
        this.getContentPane().add(this.m_tabbedPane);
        ImageIcon image = (ImageIcon)UIManager.get("pmdLogoImage");
        this.setIconImage(image.getImage());
        this.m_glassPaneMouseListener = new GlassPaneMouseListener();
        ListenerList.addListener(new SetupFilesEventHandler());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.m_firstLayout) {
            this.m_tabbedPane.adjustSplitPaneDividerLocation();
            this.m_firstLayout = false;
        }
    }

    public static final PMDViewer getViewer() {
        return m_pmdViewer;
    }

    public static final void run() {
        try {
            LoadRootDirectories loadRootDirectories = new LoadRootDirectories();
            loadRootDirectories.start();
            UIManager.setLookAndFeel("net.sourceforge.pmd.swingui.PMDLookAndFeel");
            PMDViewer pmdViewer = new PMDViewer();
            pmdViewer.setVisible(true);
            SetupFilesEvent.notifySetFileList(pmdViewer, loadRootDirectories.getDirectories());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Error error) {
            error.printStackTrace();
        }
    }

    protected void setEnableViewer(boolean enable) {
        if (enable) {
            --this.m_disabledCounter;
            if (this.m_disabledCounter == 0) {
                Component glassPane = this.getGlassPane();
                glassPane.setVisible(false);
                glassPane.setCursor(Cursor.getPredefinedCursor(0));
                glassPane.removeMouseListener(this.m_glassPaneMouseListener);
                this.m_tabbedPane.setEnabled(true);
                JMenuBar menuBar = this.getJMenuBar();
                int menuCount = menuBar.getMenuCount();
                int n = 0;
                while (n < menuCount) {
                    menuBar.getMenu(n).setEnabled(true);
                    ++n;
                }
            }
        } else {
            if (this.m_disabledCounter == 0) {
                Component glassPane = this.getGlassPane();
                glassPane.setVisible(true);
                glassPane.setCursor(Cursor.getPredefinedCursor(3));
                glassPane.addMouseListener(this.m_glassPaneMouseListener);
                this.m_tabbedPane.setEnabled(false);
                JMenuBar menuBar = this.getJMenuBar();
                int menuCount = menuBar.getMenuCount();
                int n = 0;
                while (n < menuCount) {
                    menuBar.getMenu(n).setEnabled(false);
                    ++n;
                }
            }
            ++this.m_disabledCounter;
        }
    }

    public static void main(String[] args) {
        PMDViewer.run();
    }

    private class TabbedPane
    extends JTabbedPane
    implements ChangeListener {
        private AnalysisViewer m_analysisViewer;
        private SearchViewer m_searchViewer;
        private RulesEditor m_rulesEditor;
        private PreferencesEditor m_preferencesEditor;
        private Component m_currentTab;

        private TabbedPane() {
            try {
                this.m_analysisViewer = new AnalysisViewer();
                this.m_searchViewer = new SearchViewer();
                this.m_rulesEditor = new RulesEditor();
                this.m_preferencesEditor = new PreferencesEditor();
                this.setFont(UIManager.getFont("tabFont"));
                this.addTab("Analysis Viewer", this.m_analysisViewer);
                this.addTab("Search Viewer", this.m_searchViewer);
                this.addTab("Rules Editor", this.m_rulesEditor);
                this.addTab("Preferences Editor", this.m_preferencesEditor);
                this.addChangeListener(this);
            }
            catch (PMDException pmdException) {
                String message = pmdException.getMessage();
                Exception exception = pmdException.getReason();
                MessageDialog.show(m_pmdViewer, message, exception);
            }
        }

        private void adjustSplitPaneDividerLocation() {
            this.m_analysisViewer.adjustSplitPaneDividerLocation();
            this.m_searchViewer.adjustSplitPaneDividerLocation();
            this.m_rulesEditor.adjustSplitPaneDividerLocation();
            this.m_preferencesEditor.adjustSplitPaneDividerLocation();
        }

        public void stateChanged(ChangeEvent event) {
            if (this.m_currentTab == this.m_rulesEditor) {
                this.m_rulesEditor.saveData();
            }
            this.m_currentTab = this.getSelectedComponent();
            if (this.m_currentTab == this.m_analysisViewer) {
                this.m_analysisViewer.setMenuBar();
                this.m_analysisViewer.analyze();
            } else if (this.m_currentTab == this.m_searchViewer) {
                this.m_searchViewer.setMenuBar();
                this.m_searchViewer.analyze();
            } else if (this.m_currentTab == this.m_rulesEditor) {
                this.m_rulesEditor.setMenuBar();
            } else if (this.m_currentTab == this.m_preferencesEditor) {
                this.m_preferencesEditor.setMenuBar();
            }
        }
    }

    private class SetupFilesEventHandler
    implements SetupFilesEventListener {
        private SetupFilesEventHandler() {
        }

        public void startSetup(SetupFilesEvent event) {
            PMDViewer.this.setEnableViewer(false);
        }

        public void stopSetup(SetupFilesEvent event) {
            PMDViewer.this.setEnableViewer(true);
        }

        public void setFileList(SetupFilesEvent event) {
        }
    }

    private class GlassPaneMouseListener
    extends MouseAdapter {
        private GlassPaneMouseListener() {
        }

        public void mouseClicked(MouseEvent event) {
            event.consume();
        }

        public void mousePressed(MouseEvent event) {
            event.consume();
        }

        public void mouseReleased(MouseEvent event) {
            event.consume();
        }
    }
}

