/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.StatusBarEvent;
import net.sourceforge.pmd.swingui.event.StatusBarEventListener;

class StatusBar
extends JPanel {
    private JLabel m_message;
    private String m_defaultMessage;
    private StatusArea m_statusArea;

    protected StatusBar(String defaultMessage) {
        super(new BorderLayout());
        this.m_defaultMessage = defaultMessage;
        this.m_statusArea = new StatusArea();
        this.add((Component)this.m_statusArea, "West");
        this.m_message = new JLabel();
        this.m_message.setFont(new Font("Dialog", 1, 12));
        this.m_message.setBackground(UIManager.getColor("pmdMessageAreaBackground"));
        this.m_message.setForeground(UIManager.getColor("pmdBlue"));
        this.m_message.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.setDefaultMessage();
        this.add((Component)this.m_message, "Center");
        ListenerList.addListener(new StatusBarEventHandler());
    }

    protected void setDefaultMessage() {
        this.setMessage(this.m_defaultMessage);
    }

    protected void setMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.m_message.setText(message);
    }

    private class Repaint
    implements Runnable {
        private Component m_component;

        private Repaint(Component component) {
            this.m_component = component;
        }

        public void run() {
            this.m_component.repaint();
        }
    }

    private class StatusBarEventHandler
    implements StatusBarEventListener {
        private StatusBarEventHandler() {
        }

        public void startAnimation(StatusBarEvent event) {
            StatusBar.this.m_statusArea.startAction();
            StatusBar.this.m_message.setText("");
            SwingUtilities.invokeLater(new Repaint(StatusBar.this.m_message));
        }

        public void showMessage(StatusBarEvent event) {
            StatusBar.this.m_message.setText(event.getMessage());
            SwingUtilities.invokeLater(new Repaint(StatusBar.this.m_message));
        }

        public void stopAnimation(StatusBarEvent event) {
            StatusBar.this.setDefaultMessage();
            SwingUtilities.invokeLater(new Repaint(StatusBar.this.m_message));
            StatusBar.this.m_statusArea.stopAction();
        }
    }

    private class StatusActionThread
    extends Thread {
        private StatusArea m_statusArea;
        private boolean m_stopAction;
        private int m_doNothing;
        private final long ELAPSED_TIME = 25L;

        private StatusActionThread(StatusArea statusArea) {
            super("Status Action");
            this.m_statusArea = statusArea;
        }

        public void run() {
            while (!this.m_stopAction) {
                this.m_statusArea.repaint();
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException exception) {
                    ++this.m_doNothing;
                }
            }
        }

        private void stopAction() {
            this.m_stopAction = true;
        }
    }

    private class StatusArea
    extends JPanel {
        private StatusActionThread m_actionThread;
        private Color m_inactiveBackground = Color.gray;
        private Color m_activeBackground = UIManager.getColor("pmdStatusAreaBackground");
        private Color m_actionColor = Color.red;
        private int m_direction;
        private int m_indicatorCurrentPosition;
        private final int POSITION_INCREMENT = 5;
        private final int START_MOVING = 0;
        private final int MOVE_FORWARD = 1;
        private final int MOVE_BACKWARD = 2;

        private StatusArea() {
            super(null);
            this.setOpaque(true);
            this.setBackground(this.m_inactiveBackground);
            this.setBorder(new BevelBorder(1));
            Dimension size = new Dimension(160, 12);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            this.setSize(size);
            this.setPreferredSize(size);
        }

        private void startAction() {
            if (this.m_actionThread == null) {
                this.setBackground(this.m_activeBackground);
                this.m_direction = 0;
                this.m_actionThread = new StatusActionThread(this);
                this.m_actionThread.start();
            }
        }

        private void stopAction() {
            if (this.m_actionThread != null) {
                this.m_actionThread.stopAction();
                this.m_actionThread = null;
                this.setBackground(this.m_inactiveBackground);
                this.repaint();
            }
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.getBackground() == this.m_activeBackground) {
                Rectangle totalArea = this.getBounds();
                Insets insets = this.getInsets();
                totalArea.x += insets.left;
                totalArea.y += insets.top;
                totalArea.width -= insets.left + insets.right;
                totalArea.height -= insets.top + insets.bottom;
                int totalAreaRight = totalArea.x + totalArea.width;
                int indicatorWidth = totalArea.width / 3;
                int indicatorHeight = totalArea.height;
                int indicatorY = totalArea.y;
                if (this.m_direction == 1) {
                    this.m_indicatorCurrentPosition += 5;
                    if (this.m_indicatorCurrentPosition >= totalAreaRight) {
                        this.m_indicatorCurrentPosition = totalAreaRight - 5;
                        this.m_direction = 2;
                    }
                } else if (this.m_direction == 2) {
                    this.m_indicatorCurrentPosition -= 5;
                    if (this.m_indicatorCurrentPosition < totalArea.x) {
                        this.m_indicatorCurrentPosition = totalArea.x + 5;
                        this.m_direction = 1;
                    }
                } else {
                    this.m_indicatorCurrentPosition = totalArea.x + 5;
                    this.m_direction = 1;
                }
                int indicatorX = this.m_indicatorCurrentPosition;
                Rectangle oldClip = graphics.getClipBounds();
                Color oldColor = graphics.getColor();
                graphics.setColor(this.m_activeBackground);
                graphics.setClip(totalArea.x, totalArea.y, totalArea.width, totalArea.height);
                graphics.clipRect(totalArea.x, totalArea.y, totalArea.width, totalArea.height);
                graphics.fillRect(totalArea.x, totalArea.y, totalArea.width, totalArea.height);
                if (this.m_direction == 1) {
                    int stopX = indicatorX - indicatorWidth;
                    if (stopX < totalArea.x) {
                        stopX = totalArea.x;
                    }
                    int y1 = indicatorY;
                    int y2 = y1 + indicatorHeight;
                    Color color = this.m_actionColor;
                    int x = indicatorX;
                    while (x > stopX) {
                        graphics.setColor(color);
                        graphics.drawLine(x, y1, x, y2);
                        color = this.brighter(color);
                        --x;
                    }
                } else {
                    int stopX = indicatorX + indicatorWidth;
                    if (stopX > totalAreaRight) {
                        stopX = totalAreaRight;
                    }
                    int y1 = indicatorY;
                    int y2 = indicatorY + indicatorHeight;
                    Color color = this.m_actionColor;
                    int x = indicatorX;
                    while (x < stopX) {
                        graphics.setColor(color);
                        graphics.drawLine(x, y1, x, y2);
                        color = this.brighter(color);
                        ++x;
                    }
                }
                graphics.setColor(oldColor);
                if (oldClip != null) {
                    graphics.clipRect(oldClip.x, oldClip.y, oldClip.width, oldClip.height);
                    graphics.setClip(oldClip.x, oldClip.y, oldClip.width, oldClip.height);
                }
            }
        }

        private Color brighter(Color color) {
            int red = color.getRed() + 5;
            int green = color.getGreen() + 5;
            int blue = color.getBlue() + 5;
            if (red > 255) {
                red = 255;
            }
            if (green > 255) {
                green = 255;
            }
            if (blue > 255) {
                blue = 255;
            }
            return new Color(red, green, blue);
        }
    }
}

