/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;

public class AbstractRuleTest
extends TestCase {
    public AbstractRuleTest(String name) {
        super(name);
    }

    public void testCreateRV() {
        MyRule r = new MyRule();
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("filename");
        RuleViolation rv = r.createRuleViolation(ctx, 5);
        Assert.assertEquals((String)"Line number mismatch!", (int)5, (int)rv.getLine());
        Assert.assertEquals((String)"Filename mismatch!", (String)"filename", (String)rv.getFilename());
        Assert.assertEquals((String)"Rule object mismatch!", (Object)r, (Object)rv.getRule());
        Assert.assertEquals((String)"Rule description mismatch!", (String)"myrule", (String)rv.getDescription());
    }

    public void testCreateRV2() {
        MyRule r = new MyRule();
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("filename");
        RuleViolation rv = r.createRuleViolation(ctx, 5, "specificdescription");
        Assert.assertEquals((String)"Line number mismatch!", (int)5, (int)rv.getLine());
        Assert.assertEquals((String)"Filename mismatch!", (String)"filename", (String)rv.getFilename());
        Assert.assertEquals((String)"Rule object mismatch!", (Object)r, (Object)rv.getRule());
        Assert.assertEquals((String)"Rule description mismatch!", (String)"specificdescription", (String)rv.getDescription());
    }

    private static class MyRule
    extends AbstractRule {
        private MyRule() {
        }

        public String getMessage() {
            return "myrule";
        }
    }
}

