/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.cpd;

import java.io.StringReader;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.cpd.JavaTokenizer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.Tokens;

public class JavaTokensTokenizerTest
extends TestCase {
    private static final String EOL = System.getProperty("line.separator", "\n");

    public void test1() throws Throwable {
        JavaTokenizer tokenizer = new JavaTokenizer();
        SourceCode sourceCode = new SourceCode("1");
        String data = "public class Foo {}";
        Tokens tokens = new Tokens();
        tokenizer.tokenize(sourceCode, tokens, new StringReader(data));
        Assert.assertEquals((int)6, (int)tokens.size());
        Assert.assertEquals((String)"public class Foo {}", (String)sourceCode.getSlice(0, 0));
    }

    public void test2() throws Throwable {
        JavaTokenizer t = new JavaTokenizer();
        SourceCode sourceCode = new SourceCode("1");
        String data = "public class Foo {" + EOL + "public void bar() {}" + EOL + "public void buz() {}" + EOL + "}";
        Tokens tokens = new Tokens();
        t.tokenize(sourceCode, tokens, new StringReader(data));
        Assert.assertEquals((String)("public class Foo {" + EOL + "public void bar() {}"), (String)sourceCode.getSlice(0, 1));
    }

    public void testDiscardSemicolons() throws Throwable {
        JavaTokenizer t = new JavaTokenizer();
        SourceCode sourceCode = new SourceCode("1");
        String data = "public class Foo {private int x;}";
        Tokens tokens = new Tokens();
        t.tokenize(sourceCode, tokens, new StringReader(data));
        Assert.assertEquals((int)9, (int)tokens.size());
    }

    public void testDiscardImports() throws Throwable {
        JavaTokenizer t = new JavaTokenizer();
        SourceCode sourceCode = new SourceCode("1");
        String data = "import java.io.File;" + EOL + "public class Foo {}";
        Tokens tokens = new Tokens();
        t.tokenize(sourceCode, tokens, new StringReader(data));
        Assert.assertEquals((int)6, (int)tokens.size());
    }

    public void testDiscardPkgStmts() throws Throwable {
        JavaTokenizer t = new JavaTokenizer();
        SourceCode sourceCode = new SourceCode("1");
        String data = "package foo.bar.baz;" + EOL + "public class Foo {}";
        Tokens tokens = new Tokens();
        t.tokenize(sourceCode, tokens, new StringReader(data));
        Assert.assertEquals((int)6, (int)tokens.size());
    }
}

