/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.symboltable;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.NameOccurrences;

public class NameOccurrencesTest
extends TestCase {
    public void testNameLinkage() {
        ASTPrimaryExpression primary = new ASTPrimaryExpression(1);
        primary.testingOnly__setBeginLine(10);
        ASTPrimaryPrefix prefix = new ASTPrimaryPrefix(2);
        prefix.setUsesThisModifier();
        prefix.testingOnly__setBeginLine(10);
        primary.jjtAddChild(prefix, 0);
        ASTPrimarySuffix suffix = new ASTPrimarySuffix(3);
        suffix.setImage("x");
        suffix.testingOnly__setBeginLine(10);
        primary.jjtAddChild(suffix, 1);
        NameOccurrences occs = new NameOccurrences(primary);
        NameOccurrence thisOcc = (NameOccurrence)occs.iterator().next();
        NameOccurrence xOcc = (NameOccurrence)occs.getNames().get(1);
        Assert.assertEquals((Object)thisOcc.getNameForWhichThisIsAQualifier(), (Object)xOcc);
    }

    public void testSuper() {
        ASTPrimaryExpression primary = new ASTPrimaryExpression(1);
        primary.testingOnly__setBeginLine(10);
        ASTPrimaryPrefix prefix = new ASTPrimaryPrefix(2);
        prefix.setUsesSuperModifier();
        prefix.testingOnly__setBeginLine(10);
        primary.jjtAddChild(prefix, 0);
        NameOccurrences occs = new NameOccurrences(primary);
        Assert.assertEquals((String)"super", (String)((NameOccurrence)occs.getNames().get(0)).getImage());
    }

    public void testThis() {
        ASTPrimaryExpression primary = new ASTPrimaryExpression(1);
        primary.testingOnly__setBeginLine(10);
        ASTPrimaryPrefix prefix = new ASTPrimaryPrefix(2);
        prefix.setUsesThisModifier();
        prefix.testingOnly__setBeginLine(10);
        primary.jjtAddChild(prefix, 0);
        NameOccurrences occs = new NameOccurrences(primary);
        Assert.assertEquals((String)"this", (String)((NameOccurrence)occs.getNames().get(0)).getImage());
    }

    public void testFieldWithThis() {
        ASTPrimaryExpression primary = new ASTPrimaryExpression(1);
        primary.testingOnly__setBeginLine(10);
        ASTPrimaryPrefix prefix = new ASTPrimaryPrefix(2);
        prefix.setUsesThisModifier();
        prefix.testingOnly__setBeginLine(10);
        primary.jjtAddChild(prefix, 0);
        ASTPrimarySuffix suffix = new ASTPrimarySuffix(3);
        suffix.setImage("x");
        suffix.testingOnly__setBeginLine(10);
        primary.jjtAddChild(suffix, 1);
        NameOccurrences occs = new NameOccurrences(primary);
        Assert.assertEquals((String)"this", (String)((NameOccurrence)occs.getNames().get(0)).getImage());
        Assert.assertEquals((String)"x", (String)((NameOccurrence)occs.getNames().get(1)).getImage());
    }

    public void testField() {
        ASTPrimaryExpression primary = new ASTPrimaryExpression(1);
        primary.testingOnly__setBeginLine(10);
        ASTPrimaryPrefix prefix = new ASTPrimaryPrefix(2);
        prefix.testingOnly__setBeginLine(10);
        primary.jjtAddChild(prefix, 0);
        ASTName name = new ASTName(3);
        name.setImage("x");
        prefix.jjtAddChild(name, 0);
        NameOccurrences occs = new NameOccurrences(primary);
        Assert.assertEquals((String)"x", (String)((NameOccurrence)occs.getNames().get(0)).getImage());
    }
}

