/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.AudioStreamChunk;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamChunk;
import org.jaudiotagger.audio.asf.data.VideoStreamChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public class StreamChunkReader {
    protected StreamChunkReader() {
    }

    public static StreamChunk read(RandomAccessFile raf, Chunk candidate) throws IOException {
        if (raf == null || candidate == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        if (GUID.GUID_STREAM.equals(candidate.getGuid())) {
            raf.seek(candidate.getPosition());
            return new StreamChunkReader().parseData(raf);
        }
        return null;
    }

    private StreamChunk parseData(RandomAccessFile raf) throws IOException {
        StreamChunk result = null;
        long chunkStart = raf.getFilePointer();
        GUID guid = Utils.readGUID(raf);
        if (GUID.GUID_STREAM.equals(guid)) {
            BigInteger chunkLength = Utils.readBig64(raf);
            GUID streamTypeGUID = Utils.readGUID(raf);
            if (GUID.GUID_AUDIOSTREAM.equals(streamTypeGUID) || GUID.GUID_VIDEOSTREAM.equals(streamTypeGUID)) {
                GUID errorConcealment = Utils.readGUID(raf);
                long timeOffset = Utils.readUINT64(raf);
                long typeSpecificDataSize = Utils.readUINT32(raf);
                long streamSpecificDataSize = Utils.readUINT32(raf);
                int mask = Utils.readUINT16(raf);
                int streamNumber = mask & 0x7F;
                boolean contentEncrypted = (mask & 0x8000) != 0;
                raf.skipBytes(4);
                if (GUID.GUID_AUDIOSTREAM.equals(streamTypeGUID)) {
                    AudioStreamChunk audioStreamChunk = new AudioStreamChunk(chunkStart, chunkLength);
                    result = audioStreamChunk;
                    long compressionFormat = Utils.readUINT16(raf);
                    long channelCount = Utils.readUINT16(raf);
                    long samplingRate = Utils.readUINT32(raf);
                    long avgBytesPerSec = Utils.readUINT32(raf);
                    long blockAlignment = Utils.readUINT16(raf);
                    int bitsPerSample = Utils.readUINT16(raf);
                    int codecSpecificDataSize = Utils.readUINT16(raf);
                    byte[] codecSpecificData = new byte[codecSpecificDataSize];
                    raf.readFully(codecSpecificData);
                    audioStreamChunk.setCompressionFormat(compressionFormat);
                    audioStreamChunk.setChannelCount(channelCount);
                    audioStreamChunk.setSamplingRate(samplingRate);
                    audioStreamChunk.setAverageBytesPerSec(avgBytesPerSec);
                    audioStreamChunk.setErrorConcealment(errorConcealment);
                    audioStreamChunk.setBlockAlignment(blockAlignment);
                    audioStreamChunk.setBitsPerSample(bitsPerSample);
                    audioStreamChunk.setCodecData(codecSpecificData);
                } else if (GUID.GUID_VIDEOSTREAM.equals(streamTypeGUID)) {
                    VideoStreamChunk videoStreamChunk = new VideoStreamChunk(chunkStart, chunkLength);
                    result = videoStreamChunk;
                    long pictureWidth = Utils.readUINT32(raf);
                    long pictureHeight = Utils.readUINT32(raf);
                    raf.skipBytes(1);
                    long formatDataSize = Utils.readUINT16(raf);
                    raf.skipBytes(16);
                    byte[] fourCC = new byte[4];
                    raf.read(fourCC);
                    videoStreamChunk.setPictureWidth(pictureWidth);
                    videoStreamChunk.setPictureHeight(pictureHeight);
                    videoStreamChunk.setCodecId(fourCC);
                }
                result.setStreamNumber(streamNumber);
                result.setStreamSpecificDataSize(streamSpecificDataSize);
                result.setTypeSpecificDataSize(typeSpecificDataSize);
                result.setTimeOffset(timeOffset);
                result.setContentEncrypted(contentEncrypted);
            }
        }
        return result;
    }
}

