﻿/*
 * SMF/SMFReader.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.IO;
using System.Collections.Generic;

namespace Boare.Lib.Vsq {
    /// <summary>
    /// SMFファイルを解析し、テキストファイル形式のデータに変換します
    /// </summary>
    public class SMFReader : IDisposable {
        //private StreamReader sr = null;

        private MidiFile m_midi = null;
        //private string _result = "";
        private List<string> m_lines;

        /// <summary>
        /// デフォルトコンストラクタ。コンストラクトと同時に解析を行い、指定されたファイルに結果を格納します。
        /// </summary>
        /// <param name="_path">解析対象のファイルへのパス</param>
        public SMFReader( string _path ) {
            //_result = Path.GetTempFileName();
            m_midi = new MidiFile( _path );//, _result, Mode.Read );
            //sr = new StreamReader( _result );
            m_lines = new List<string>();
            foreach ( string spl in m_midi.ReadToEnd().Split( "\n".ToCharArray() ) ) {
                m_lines.Add( spl );
            }
        }


        /// <summary>
        /// デストラクタ。開いたままのファイルを閉じる。一時ファイルを削除する。
        /// </summary>
        ~SMFReader() {
            /*if ( sw != null )
                sw.Close();*/
            /*if ( sr != null )
                sr.Close();*/
            /*if ( F != null )
                F.Close();*/
            m_midi.Close();
            /*if ( _result != "" ) {
                if ( File.Exists( _result ) ) {
                    File.Delete( _result );
                }
            }*/
        }


        public void Dispose() {
            /*if ( sw != null )
                sw.Close();*/
            /*if ( sr != null )
                sr.Close();*/
            /*if ( F != null )
                F.Close();*/
            m_midi.Close();
            /*if ( _result != "" ) {
                if ( File.Exists( _result ) ) {
                    File.Delete( _result );
                }
            }*/
        }


        public List<string> Lines {
            get {
                return m_lines;
            }
        }


        /*/// <summary>
        /// 解析結果が格納されたバッファ文字列を取得します。
        /// </summary>
        /// <returns>解析結果</returns>
        public string ReadToEnd() {
            return sr.ReadToEnd();
        }*/


        /*/// <summary>
        /// 解析結果を1行ずつ取得します。
        /// </summary>
        /// <returns>解析結果の行データ</returns>
        public string ReadLine() {
            return sr.ReadLine();
        }*/


        /*/// <summary>
        /// 読み取り可能な次の文字を返しますが、その文字は使用されません。
        /// </summary>
        /// <returns></returns>
        public int Peek() {
            return sr.Peek();
        }*/


        /*/// <summary>
        /// 解析結果ファイルのストリームを閉じます
        /// </summary>
        public void Close() {
            if ( sr != null )
                sr.Close();
        }*/

    }
}