/*
 * TextMemoryStream.h
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef __textmemorystream_h__
#define __textmemorystream_h__

#include <string>
#include <sstream>
#include "common.h"

using namespace std;

namespace Boare{ namespace Lib{ namespace Vsq{

    /// <summary>
    /// メモリー上でテキストファイルを扱うためのクラス．
    /// </summary>
    typedef class TextMemoryStream_t {
    public:
        /// <summary>
        /// 
        /// </summary>
        /// <param name="s"></param>
        void Write( string value );

        void Rewind();

        void WriteLine( string s );

        void Close();

        int Peek();

        string ReadLine();

        void Dispose();

        TextMemoryStream_t( string path );

        TextMemoryStream_t();
    private:
        //FileAccess m_access;
        stringstream m_ms;
        //Encoding m_enc;
        char NEW_LINE[2];
    } TextMemoryStream;

} } }
#endif
