/*
 * FormMain.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the GPLv3 License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
//#define MONITOR_FPS
#define AUTHOR_LIST_SAVE_BUTTON_VISIBLE
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Media;
using System.Threading;
using System.Windows.Forms;
using System.Xml.Serialization;
using System.Text;

using bocoree;
using Boare.Lib.AppUtil;
using Boare.Lib.Media;
using Boare.Lib.Vsq;

// （∇・[τ]・∇）
//TODO: アイテムが選択されたときに、イベントを拾ってstripBtnCopy等のEnabledを更新する
namespace Boare.Cadencii {

    public delegate void VoidDelegate();

    partial class FormMain : Form {
        #region Static Readonly Field
        private readonly SolidBrush s_brs_192_192_192 = new SolidBrush( Color.FromArgb( 192, 192, 192 ) );
        private readonly SolidBrush s_brs_a098_000_000_000 = new SolidBrush( Color.FromArgb( 98, 0, 0, 0 ) );
        private readonly SolidBrush s_brs_106_108_108 = new SolidBrush( Color.FromArgb( 106, 108, 108 ) );
        private readonly SolidBrush s_brs_180_180_180 = new SolidBrush( Color.FromArgb( 180, 180, 180 ) );
        private readonly SolidBrush s_brs_212_212_212 = new SolidBrush( Color.FromArgb( 212, 212, 212 ) );
        private readonly SolidBrush s_brs_125_123_124 = new SolidBrush( Color.FromArgb( 125, 123, 124 ) );
        private readonly SolidBrush s_brs_240_240_240 = new SolidBrush( Color.FromArgb( 240, 240, 240 ) );
        private readonly SolidBrush s_brs_011_233_244 = new SolidBrush( Color.FromArgb( 11, 233, 244 ) );
        private readonly SolidBrush s_brs_182_182_182 = new SolidBrush( Color.FromArgb( 182, 182, 182 ) );
        private readonly SolidBrush s_brs_072_077_098 = new SolidBrush( Color.FromArgb( 72, 77, 98 ) );
        private readonly SolidBrush s_brs_153_153_153 = new SolidBrush( Color.FromArgb( 153, 153, 153 ) );
        private readonly SolidBrush s_brs_147_147_147 = new SolidBrush( Color.FromArgb( 147, 147, 147 ) );
        private readonly SolidBrush s_brs_000_255_214 = new SolidBrush( Color.FromArgb( 0, 255, 214 ) );
        private readonly Pen s_pen_112_112_112 = new Pen( Color.FromArgb( 112, 112, 112 ) );
        private readonly Pen s_pen_118_123_138 = new Pen( Color.FromArgb( 118, 123, 138 ) );
        private readonly Pen s_pen_LU = new Pen( Color.FromArgb( 128, 106, 52, 255 ) );
        private readonly Pen s_pen_RD = new Pen( Color.FromArgb( 204, 40, 47, 255 ) );
        private readonly Pen s_pen_161_157_136 = new Pen( Color.FromArgb( 161, 157, 136 ) );
        private readonly Pen s_pen_209_204_172 = new Pen( Color.FromArgb( 209, 204, 172 ) );
        private readonly Pen s_pen_160_160_160 = new Pen( Color.FromArgb( 160, 160, 160 ) );
        private readonly Pen s_pen_105_105_105 = new Pen( Color.FromArgb( 105, 105, 105 ) );
        private readonly Pen s_pen_106_108_108 = new Pen( Color.FromArgb( 106, 108, 108 ) );
        private readonly Pen s_pen_212_212_212 = new Pen( Color.FromArgb( 212, 212, 212 ) );
        private readonly Pen s_pen_051_051_000 = new Pen( Color.FromArgb( 51, 51, 0 ) );
        private readonly Pen s_pen_125_123_124 = new Pen( Color.FromArgb( 125, 123, 124 ) );
        private readonly Pen s_pen_187_187_255 = new Pen( Color.FromArgb( 187, 187, 255 ) );
        private readonly Pen s_pen_007_007_151 = new Pen( Color.FromArgb( 7, 7, 151 ) );
        private readonly Pen s_pen_a136_000_000_000 = new Pen( Color.FromArgb( 136, Color.Black ) );
        private readonly Pen s_pen_dashed_171_171_171 = new Pen( Color.FromArgb( 171, 171, 171 ) );
        private readonly Pen s_pen_dashed_209_204_172 = new Pen( Color.FromArgb( 209, 204, 172 ) );
        private readonly Pen s_pen_065_065_065 = new Pen( Color.FromArgb( 65, 65, 65 ) );
        private readonly Color s_txtbox_backcolor = Color.FromArgb( 128, 128, 128 );
        public readonly Color[] s_HIDDEN = new Color[]{
            Color.FromArgb( 181, 162, 123 ),
            Color.FromArgb( 179, 181, 123 ),
            Color.FromArgb( 157, 181, 123 ),
            Color.FromArgb( 135, 181, 123 ),
            Color.FromArgb( 123, 181, 133 ),
            Color.FromArgb( 123, 181, 154 ),
            Color.FromArgb( 123, 181, 176 ),
            Color.FromArgb( 123, 164, 181 ),
            Color.FromArgb( 123, 142, 181 ),
            Color.FromArgb( 125, 123, 181 ),
            Color.FromArgb( 169, 123, 181 ),
            Color.FromArgb( 181, 123, 171 ),
            Color.FromArgb( 181, 123, 149 ),
            Color.FromArgb( 181, 123, 127 ),
            Color.FromArgb( 181, 140, 123 ),
            Color.FromArgb( 181, 126, 123 ) };
        private readonly AuthorListEntry[] _CREDIT = new AuthorListEntry[]{
            new AuthorListEntry( "is developped by:", FontStyle.Italic ),
            new AuthorListEntry( "kbinani" ),
            new AuthorListEntry(),
            new AuthorListEntry(),
            new AuthorListEntry( "Special Thanks to", FontStyle.Italic| FontStyle.Bold ),
            new AuthorListEntry(),
            new AuthorListEntry( "tool icons designer:", FontStyle.Italic ),
            new AuthorListEntry( "Yusuke Kamiyamane" ),
            new AuthorListEntry(),
            new AuthorListEntry( "developper of UTAU:", FontStyle.Italic ),
            new AuthorListEntry( "飴屋/菖蒲" ),
            new AuthorListEntry(),
            new AuthorListEntry( "promoter:", FontStyle.Italic ),
            new AuthorListEntry( "zhuo" ),
            new AuthorListEntry(),
            new AuthorListEntry( "library tester:", FontStyle.Italic ),
            new AuthorListEntry( "evm" ),
            new AuthorListEntry( "そろそろP" ),
            new AuthorListEntry( "めがね１１０" ),
            new AuthorListEntry( "上総" ),
            new AuthorListEntry( "NOIKE" ),
            new AuthorListEntry( "逃亡者" ),
            new AuthorListEntry(),
            new AuthorListEntry( "translator:", FontStyle.Italic ),
            new AuthorListEntry( "Eji (zh-TW translation)" ),
            new AuthorListEntry( "kankan (zh-TW translation)" ),
            new AuthorListEntry(),
            new AuthorListEntry(),
            new AuthorListEntry( "Thanks to", FontStyle.Italic | FontStyle.Bold ),
            new AuthorListEntry(),
            new AuthorListEntry( "ないしょの人" ),
            new AuthorListEntry( "naquadah" ),
            new AuthorListEntry( "1zo" ),
            new AuthorListEntry( "Amby" ),
            new AuthorListEntry( "ケロッグ" ),
            new AuthorListEntry( "beginner" ),
            new AuthorListEntry( "b2ox" ),
            new AuthorListEntry( "麻太郎" ),
            new AuthorListEntry( "もみじぱん" ),
            new AuthorListEntry( "PEX" ),
            new AuthorListEntry( "やなぎがうら" ),
            new AuthorListEntry( "cocoonP" ),
            new AuthorListEntry( "かつ" ),
            new AuthorListEntry( "ちゃそ" ),
            new AuthorListEntry( "all members of Cadencii bbs", FontStyle.Italic ),
            new AuthorListEntry(),
            new AuthorListEntry( "     ... and you !", FontStyle.Bold | FontStyle.Italic ),
        };
        private readonly Font s_F9PT = new Font( FontFamily.GenericSansSerif, 9f, GraphicsUnit.Point );
        #endregion

        #region Constants and internal enums
        /// <summary>
        /// カーブエディタ画面の編集モード
        /// </summary>
        internal enum CurveEditMode {
            /// <summary>
            /// 何もしていない
            /// </summary>
            None,
            /// <summary>
            /// 鉛筆ツールで編集するモード
            /// </summary>
            Edit,
            /// <summary>
            /// ラインツールで編集するモード
            /// </summary>
            Line,
            /// <summary>
            /// 鉛筆ツールでVELを編集するモード
            /// </summary>
            EditVel,
            /// <summary>
            /// ラインツールでVELを編集するモード
            /// </summary>
            LineVel,
            /// <summary>
            /// 真ん中ボタンでドラッグ中
            /// </summary>
            MiddleDrag,
        }

        internal enum ExtDragXMode {
            Right,
            Left,
            None,
        }

        internal enum ExtDragYMode {
            Up,
            Down,
            None,
        }

        internal enum GameControlMode {
            Disabled,
            Normal,
            Keyboard,
            Cursor,
        }

        /// <summary>
        /// スクロールバーの最小サイズ(ピクセル)
        /// </summary>
        private const int MIN_BAR_ACTUAL_LENGTH = 17;
        /// <summary>
        /// エントリの端を移動する時の、ハンドル許容範囲の幅
        /// </summary>
        private const int _EDIT_HANDLE_WIDTH = 7;
        private const int _TOOL_BAR_HEIGHT = 46;
        /// <summary>
        /// 単音プレビュー時に、wave生成完了を待つ最大の秒数
        /// </summary>
        private const double _WAIT_LIMIT = 5.0;
        public const string _APP_NAME = "Cadencii";
        /// <summary>
        /// 表情線の先頭部分のピクセル幅
        /// </summary>
        private const int _PX_ACCENT_HEADER = 21;
        /// <summary>
        /// パフォーマンスカウンタ用バッファの容量
        /// </summary>
        private const int _NUM_PCOUNTER = 50;
        private const string _VERSION_HISTORY_URL = "http://www.ne.jp/asahi/kbinani/home/cadencii/version_history.xml";
        /// <summary>
        /// コントロールカーブが不可視状態における、splitContainer1.Panel2の最小サイズ
        /// </summary>
        private const int _SPL1_PANEL2_MIN_HEIGHT = 34;
        /// <summary>
        /// splitContainer2.Panel2の最小サイズ
        /// </summary>
        private const int _SPL2_PANEL2_MIN_HEIGHT = 25;
        /// <summary>
        /// splitContainer*で使用するSplitterWidthプロパティの値
        /// </summary>
        private const int _SPL_SPLITTER_WIDTH = 4;
        const int _PICT_POSITION_INDICATOR_HEIGHT = 48;
        const int _SCROLL_WIDTH = 16;
        #endregion

        #region Static Field
        /// <summary>
        /// CTRLキー。MacOSXの場合はMenu
        /// </summary>
        private Keys s_modifier_key = Keys.Control;
        #endregion

        #region Fields
        private VersionInfo m_versioninfo = null;
        private Cursor HAND;
        private TextBoxEx m_input_textbox = null;
        /// <summary>
        /// ボタンがDownされた位置。(座標はpictureBox基準)
        /// </summary>
        private Point m_button_initial;
        /// <summary>
        /// 真ん中ボタンがダウンされたときのvscrollのvalue値
        /// </summary>
        private int m_middle_button_vscroll;
        /// <summary>
        /// 真ん中ボタンがダウンされたときのhscrollのvalue値
        /// </summary>
        private int m_middle_button_hscroll;
        private bool m_edited = false;
        /// <summary>
        /// パフォーマンスカウンタ
        /// </summary>
        private float[] m_performance = new float[_NUM_PCOUNTER];
        /// <summary>
        /// 最後にpictureBox1_Paintが実行された時刻
        /// </summary>
        private DateTime m_last_ignitted;
        /// <summary>
        /// パフォーマンスカウンタから算出される画面の更新速度
        /// </summary>
        private float m_fps = 0f;
        /// <summary>
        /// カーブエディタの編集モード
        /// </summary>
        private CurveEditMode m_edit_curve_mode = CurveEditMode.None;
        /// <summary>
        /// ピアノロールの右クリックが表示される直前のマウスの位置
        /// </summary>
        private Point m_cMenuOpenedPosition;
#if USE_DOBJ
        /// <summary>
        /// 画面に描かれるエントリのリスト．trackBar.Valueの変更やエントリの編集などのたびに更新される
        /// </summary>
        private List<List<DrawObject>> m_draw_objects;
#endif
#if PROPRETY_WINDOW
        private List<Dictionary<int, ContextProperty>> m_property_windows = new List<Dictionary<int,ContextProperty>>();
#endif
        /// <summary>
        /// m_draw_objectsを描く際の，最初に検索されるインデクス．
        /// </summary>
        private int[] m_draw_start_index = new int[16] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
        /// <summary>
        /// トラック名の入力に使用するテキストボックス
        /// </summary>
        private TextBoxEx m_txtbox_track_name;
        /// <summary>
        /// ピアノロールの画面外へのドラッグ時、前回自動スクロール操作を行った時刻
        /// </summary>
        private DateTime m_timer_drag_last_ignitted;
        /// <summary>
        /// ミキサーダイアログ
        /// </summary>
        private FormMixer m_mixer_dlg;
        /// <summary>
        /// 画面外への自動スクロールモード
        /// </summary>
        private ExtDragXMode m_ext_dragx = ExtDragXMode.None;
        private ExtDragYMode m_ext_dragy = ExtDragYMode.None;
        /// <summary>
        /// EditMode=MoveEntryで，移動を開始する直前のマウスの仮想スクリーン上の位置
        /// </summary>
        private Point m_mouse_move_init;
        /// <summary>
        /// EditMode=MoveEntryで，移動を開始する直前のマウスの位置と，音符の先頭との距離(ピクセル)
        /// </summary>
        private int m_mouse_move_offset;
        /// <summary>
        /// マウスが降りた仮想スクリーン上の座標(ピクセル)
        /// </summary>
        private Point m_pointer_mouse_down;
        /// <summary>
        /// マウスが降りていて，かつ範囲選択をしているときに立つフラグ
        /// </summary>
        private bool m_pointer_downed = false;
        /// <summary>
        /// マウスが降りているかどうかを表すフラグ．m_pointer_downedとは別なので注意
        /// </summary>
        private bool m_mouse_downed = false;
        private VsqEvent m_adding;
        private int m_adding_length;
        /// <summary>
        /// テンポ変更の位置を、マウスドラッグで移動させているかどうかを表すフラグ
        /// </summary>
        private bool m_tempo_dragging = false;
        private int m_tempo_dragging_deltaclock = 0;
        /// <summary>
        /// 拍子変更の位置を、マウスドラッグで移動させているかどうかを表すフラグ
        /// </summary>
        private bool m_timesig_dragging = false;
        private int m_timesig_dragging_deltaclock = 0;
        private bool m_mouse_downed_trackselector = false;
        private ExtDragXMode m_ext_dragx_trackselector = ExtDragXMode.None;
        private bool m_mouse_moved = false;
        /// <summary>
        /// マウスホバーを発生させるスレッド
        /// </summary>
        private Thread m_mouse_hover_thread = null;
        private ImeMode m_last_imemode = ImeMode.On;
        private bool m_last_symbol_edit_mode = false;
        /// <summary>
        /// 鉛筆のモード
        /// </summary>
        private PencilMode m_pencil_mode = new PencilMode();
        private bool m_startmark_dragging = false;
        private bool m_endmark_dragging = false;
        /// <summary>
        /// ビブラート範囲を編集中の音符のInternalID
        /// </summary>
        private int m_vibrato_editing_id = -1;
        private TrackSelector trackSelector;
        /// <summary>
        /// このフォームがアクティブ化されているかどうか
        /// </summary>
        private bool m_form_activated = true;
        private GameControlMode m_game_mode = GameControlMode.Disabled;
        /// <summary>
        /// 直接再生モード時の、再生開始した位置の曲頭からの秒数
        /// </summary>
        private float m_direct_play_shift = 0.0f;
        /// <summary>
        /// プレビュー再生の長さ
        /// </summary>
        private double m_preview_ending_time;
        private System.Windows.Forms.Timer m_timer;
        private bool m_last_pov_r = false;
        private bool m_last_pov_l = false;
        private bool m_last_pov_u = false;
        private bool m_last_pov_d = false;
        private bool m_last_btn_x = false;
        private bool m_last_btn_o = false;
        private bool m_last_btn_re = false;
        private bool m_last_btn_tr = false;
        private bool m_last_select = false;
        /// <summary>
        /// 前回ゲームコントローラのイベントを処理した時刻
        /// </summary>
        private DateTime m_last_event_processed;
        /// <summary>
        /// splitContainer2.Panel2を最小化する直前の、splitContainer2.SplitterDistance
        /// </summary>
        private int m_last_splitcontainer2_split_distance = -1;
        private bool m_spacekey_downed = false;
        private MidiInDevice m_midi_in = null;
        private FormMidiImExport m_midi_imexport_dialog = null;
        private Dictionary<EditTool, Cursor> m_cursor = new Dictionary<EditTool, Cursor>();
        private Preference m_preference_dlg;
        private ToolStripButton m_strip_ddbtn_metronome;
#if VER22
        private FormUtauVoiceConfig m_utau_voice_dialog = null;
#endif
        #endregion

        public FormMain() {
#if DEBUG
            bocoree.debug.push_log( "FormMain..ctor()" );
            bocoree.debug.push_log( "    " + Environment.OSVersion.ToString() );
            bocoree.debug.push_log( "    FormID=" + AppManager.ID );
            AppManager.DebugWriteLine( "FormMain..ctor()" );
#endif
            AppManager.BaseFont10Bold = new Font( AppManager.EditorConfig.BaseFontName, 10, FontStyle.Bold );
            AppManager.BaseFont8 = new Font( AppManager.EditorConfig.BaseFontName, 8 );
            AppManager.BaseFont10 = new Font( AppManager.EditorConfig.BaseFontName, 10 );
            AppManager.BaseFont9 = new Font( AppManager.EditorConfig.BaseFontName, 9 );

            s_modifier_key = ((AppManager.EditorConfig.Platform == Platform.Macintosh) ? Keys.Menu : Keys.Control);

            AppManager.SetVsqFile( new VsqFileEx( AppManager.EditorConfig.DefaultSingerName,
                                                  AppManager.EditorConfig.DefaultPreMeasure,
                                                  4,
                                                  4,
                                                  500000 ) );
#if PROPRETY_WINDOW
            InitContextProperty();
#endif

            InitializeComponent();

#if !VER22
            menuSettingUtauVoiceDB.Enabled = false;
            menuSettingUtauVoiceDB.Visible = false;
#endif

            m_strip_ddbtn_metronome = new ToolStripButton( "Metronome", Properties.Resources.alarm_clock );
            m_strip_ddbtn_metronome.Name = "m_strip_ddbtn_metronome";
            m_strip_ddbtn_metronome.CheckOnClick = true;
            m_strip_ddbtn_metronome.Checked = AppManager.EditorConfig.MetronomeEnabled;
            m_strip_ddbtn_metronome.CheckedChanged += new EventHandler( m_strip_ddbtn_metronome_CheckedChanged );
            toolStripBottom.Items.Add( m_strip_ddbtn_metronome );

            trackSelector = new TrackSelector();
            trackSelector.BackColor = Color.FromArgb( 108, 108, 108 );
            trackSelector.CurveVisible = true;
            trackSelector.Location = new Point( 0, 242 );
            trackSelector.Margin = new Padding( 0 );
            trackSelector.Name = "trackSelector";
            trackSelector.SelectedCurve = CurveType.VEL;
            trackSelector.Size = new Size( 446, 250 );
            trackSelector.TabIndex = 0;
            trackSelector.MouseClick += new MouseEventHandler( this.trackSelector_MouseClick );
            trackSelector.SelectedTrackChanged += new BSimpleDelegate<int>( this.trackSelector_SelectedTrackChanged );
            trackSelector.MouseUp += new MouseEventHandler( this.trackSelector_MouseUp );
            trackSelector.MouseDown += new MouseEventHandler( trackSelector_MouseDown );
            trackSelector.SelectedCurveChanged += new BSimpleDelegate<CurveType>( this.trackSelector_SelectedCurveChanged );
            trackSelector.MouseMove += new MouseEventHandler( this.trackSelector_MouseMove );
            trackSelector.RenderRequired += new BSimpleDelegate<int[]>( this.trackSelector_RenderRequired );
            trackSelector.PreviewKeyDown += new PreviewKeyDownEventHandler( this.trackSelector_PreviewKeyDown );
            trackSelector.KeyDown += new KeyEventHandler( commonCaptureSpaceKeyDown );
            trackSelector.KeyUp += new KeyEventHandler( commonCaptureSpaceKeyUp );
            UpdateTrackSelectorVisibleCurve();

            stripBtnScroll.Checked = AppManager.AutoScroll;
            ApplySelectedTool();
            ApplyQuantizeMode();

            // Palette Toolの読み込み
            UpdatePaletteTool();

            // toolStipの位置を，前回終了時の位置に戻す
            List<ToolStrip> top = new List<ToolStrip>();
            List<ToolStrip> bottom = new List<ToolStrip>();
            if ( toolStripTool.Parent != null ) {
                if ( toolStripTool.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripTool );
                    top.Add( toolStripTool );
                } else if ( toolStripTool.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripTool );
                    bottom.Add( toolStripTool );
                }
            }
            if ( toolStripMeasure.Parent != null ) {
                if ( toolStripMeasure.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripMeasure );
                    top.Add( toolStripMeasure );
                } else if ( toolStripMeasure.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripMeasure );
                    bottom.Add( toolStripMeasure );
                }
            }
            if ( toolStripPosition.Parent != null ) {
                if ( toolStripPosition.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripPosition );
                    top.Add( toolStripPosition );
                } else if ( toolStripPosition.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripPosition );
                    bottom.Add( toolStripPosition );
                }
            }
            if ( toolStripFile.Parent != null ) {
                if ( toolStripFile.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripFile );
                    top.Add( toolStripFile );
                } else if ( toolStripFile.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripFile );
                    bottom.Add( toolStripFile );
                }
            }
            if ( toolStripPaletteTools.Parent != null ) {
                if ( toolStripPaletteTools.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripPaletteTools );
                    if ( toolStripPaletteTools.Visible ) {
                        top.Add( toolStripPaletteTools );
                    }
                } else if ( toolStripPaletteTools.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripPaletteTools );
                    if ( toolStripPaletteTools.Visible ) {
                        bottom.Add( toolStripPaletteTools );
                    }
                }
            }

            splitContainer1.Panel1.BorderStyle = BorderStyle.None;
            splitContainer1.Panel2.BorderStyle = BorderStyle.None;
            splitContainer1.BackColor = Color.FromArgb( 212, 212, 212 );
            splitContainer2.Panel1.Controls.Add( panel1 );
            panel1.Dock = DockStyle.Fill;
            splitContainer2.Panel2.Controls.Add( panel2 );
            splitContainer2.Panel2.BorderStyle = BorderStyle.FixedSingle;
            splitContainer2.Panel2.BorderColor = Color.FromArgb( 112, 112, 112 );
            splitContainer1.Panel1.Controls.Add( splitContainer2 );
            panel2.Dock = DockStyle.Fill;
            splitContainer2.Dock = DockStyle.Fill;
            splitContainer1.Panel2.Controls.Add( trackSelector );
            trackSelector.Dock = DockStyle.Fill;
            splitContainer1.Dock = DockStyle.Fill;
            splitContainer1.Panel2MinSize = trackSelector.PreferredMinSize;

            // コントロールの位置・サイズを調節
            splitContainer2.Panel1.SuspendLayout();
            panel1.SuspendLayout();
            pictPianoRoll.SuspendLayout();
            vScroll.SuspendLayout();
            // panel1の中身は
            // picturePositionIndicator
            picturePositionIndicator.Left = 0;
            picturePositionIndicator.Top = 0;
            picturePositionIndicator.Width = panel1.Width;
            // pictPianoRoll
            pictPianoRoll.Left = 0;
            pictPianoRoll.Top = picturePositionIndicator.Height;
            pictPianoRoll.Width = panel1.Width - vScroll.Width;
            pictPianoRoll.Height = panel1.Height - picturePositionIndicator.Height - hScroll.Height;
            // vScroll
            vScroll.Left = pictPianoRoll.Width;
            vScroll.Top = picturePositionIndicator.Height;
            vScroll.Height = pictPianoRoll.Height;
            // pictureBox3
            pictureBox3.Left = 0;
            pictureBox3.Top = panel1.Height - hScroll.Height;
            pictureBox3.Height = hScroll.Height;
            // hScroll
            hScroll.Left = pictureBox3.Width;
            hScroll.Top = panel1.Height - hScroll.Height;
            hScroll.Width = panel1.Width - pictureBox3.Width - trackBar.Width - pictureBox2.Width;
            // trackBar
            trackBar.Left = pictureBox3.Width + hScroll.Width;
            trackBar.Top = panel1.Height - hScroll.Height;
            // pictureBox2
            pictureBox2.Left = panel1.Width - vScroll.Width;
            pictureBox2.Top = panel1.Height - hScroll.Height;
            vScroll.ResumeLayout();
            pictPianoRoll.ResumeLayout();
            panel1.ResumeLayout();
            splitContainer2.Panel1.ResumeLayout();

            pictPianoRoll.MouseWheel += new MouseEventHandler( pictPianoRoll_MouseWheel );
            trackSelector.MouseWheel += new MouseEventHandler( trackSelector_MouseWheel );
            picturePositionIndicator.MouseWheel += new MouseEventHandler( picturePositionIndicator_MouseWheel );

            hScroll.Maximum = AppManager.VsqFile.TotalClocks + 240;
            hScroll.SmallChange = 240;
            hScroll.LargeChange = 240 * 4;

            vScroll.Maximum = AppManager.EditorConfig.PxTrackHeight * 128;
            vScroll.SmallChange = 24;
            vScroll.LargeChange = 24 * 4;

            trackSelector.CurveVisible = true;

            // 左上のやつから順に登録
            toolStripTool.Location = AppManager.EditorConfig.ToolEditTool.Location;
            toolStripMeasure.Location = AppManager.EditorConfig.ToolMeasureLocation.Location;
            toolStripPosition.Location = AppManager.EditorConfig.ToolPositionLocation.Location;
            toolStripFile.Location = AppManager.EditorConfig.ToolFileLocation.Location;
            toolStripPaletteTools.Location = AppManager.EditorConfig.ToolPaletteLocation.Location;

            AddToolStripInPositionOrder( toolStripContainer.TopToolStripPanel, top );
            AddToolStripInPositionOrder( toolStripContainer.BottomToolStripPanel, bottom );

            toolStripTool.ParentChanged += new System.EventHandler( this.toolStripEdit_ParentChanged );
            toolStripTool.Move += new System.EventHandler( this.toolStripEdit_Move );
            toolStripMeasure.ParentChanged += new System.EventHandler( this.toolStripMeasure_ParentChanged );
            toolStripMeasure.Move += new System.EventHandler( this.toolStripMeasure_Move );
            toolStripPosition.ParentChanged += new System.EventHandler( this.toolStripPosition_ParentChanged );
            toolStripPosition.Move += new System.EventHandler( this.toolStripPosition_Move );
            toolStripFile.ParentChanged += new EventHandler( toolStripFile_ParentChanged );
            toolStripFile.Move += new EventHandler( toolStripFile_Move );
            toolStripPaletteTools.ParentChanged += new EventHandler( toolStripPaletteTools_ParentChanged );
            toolStripPaletteTools.Move += new EventHandler( toolStripPaletteTools_Move );
            
            m_input_textbox = new TextBoxEx();
            m_input_textbox.Visible = false;
            m_input_textbox.BorderStyle = BorderStyle.None;
            m_input_textbox.Width = 80;
            m_input_textbox.BackColor = Color.White;
            m_input_textbox.AcceptsReturn = true;
            m_input_textbox.Font = new Font( AppManager.EditorConfig.BaseFontName, 9 );
            m_input_textbox.Enabled = false;
            panel1.Controls.Add( m_input_textbox );
            m_input_textbox.Parent = pictPianoRoll;

            int fps = 1000 / AppManager.EditorConfig.MaximumFrameRate;
            timer.Interval = (fps <= 0) ? 1 : fps;
#if DEBUG
            menuHelpDebug.Visible = true;
#endif
            const string _HAND = "AAACAAEAICAAABAAEADoAgAAFgAAACgAAAAgAAAAQAAAAAEABAAAAAAAgAIAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAgAAAAACAAACAgAAAAACAAIAAgAAAgIAAwMDAAICAgAD/AAAAAP8AAP//AAAAAP8A/wD/AAD//wD///8AAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/wAAAAAAAAAAAAAAAAAAD" +
                "//wAAAAAAAAAAAAAAAAAA//8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAAAA/wAAAAAAAAAAA" +
                "A//AAAAAP/wAAAAAAAAAAAP/wAAAAD/8AAAAAAAAAAAAP8AAAAA/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAA//8AAAAAAAAAAAAAAAAAAP//AAAAAAAAAAAAAAAAAAAP8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD////////////////////////////////////////////+f////" +
                "D////gf///4H////D///8/z//+H4f//B+D//wfg//+H4f//z/P///w////4H///+B////w////+f//////////////////////////" +
                "//////////////////w==";
            using ( MemoryStream ms = new MemoryStream( Convert.FromBase64String( _HAND ) ) ) {
                HAND = new Cursor( ms );
            }

            ApplyShortcut();
        }

        private void m_strip_ddbtn_metronome_CheckedChanged( object sender, EventArgs e ) {
            AppManager.EditorConfig.MetronomeEnabled = m_strip_ddbtn_metronome.Checked;
            if ( AppManager.EditorConfig.MetronomeEnabled && AppManager.EditMode == EditMode.Realtime ) {
                MidiPlayer.RestartMetronome();
            }
        }

        private void commonStripPaletteTool_Clicked( object sender, EventArgs e ) {
            string id = "";  //選択されたツールのID
            if ( sender is ToolStripButton ) {
                ToolStripButton tsb = (ToolStripButton)sender;
                if ( tsb.Tag != null && tsb.Tag is string ) {
                    id = (string)tsb.Tag;
                    AppManager.SelectedPaletteTool = id;
                    AppManager.SelectedTool = EditTool.PaletteTool;
                    tsb.Checked = true;
                }
            } else if ( sender is ToolStripMenuItem ) {
                ToolStripMenuItem tsmi = (ToolStripMenuItem)sender;
                if ( tsmi.Tag != null && tsmi.Tag is string ) {
                    id = (string)tsmi.Tag;
                    AppManager.SelectedPaletteTool = id;
                    AppManager.SelectedTool = EditTool.PaletteTool;
                    tsmi.Checked = true;
                }
            }

            foreach ( ToolStripItem item in toolStripPaletteTools.Items ) {
                if ( item is ToolStripButton ) {
                    ToolStripButton button = (ToolStripButton)item;
                    if ( button.Tag != null && button.Tag is string && ((string)button.Tag == id) ) {
                        button.Checked = true;
                    } else {
                        button.Checked = false;
                    }
                }
            }
            foreach ( ToolStripItem item in cMenuPianoPaletteTool.DropDownItems ) {
                if ( item is ToolStripMenuItem ) {
                    ToolStripMenuItem menu = (ToolStripMenuItem)item;
                    if ( menu.Tag != null && menu.Tag is string && ((string)menu.Tag == id) ) {
                        menu.Checked = true;
                    } else {
                        menu.Checked = false;
                    }
                }
            }
            foreach ( ToolStripItem item in cMenuTrackSelectorPaletteTool.DropDownItems ) {
                if ( item is ToolStripMenuItem ) {
                    ToolStripMenuItem menu = (ToolStripMenuItem)item;
                    if ( menu.Tag != null && menu.Tag is string && ((string)menu.Tag == id) ) {
                        menu.Checked = true;
                    } else {
                        menu.Checked = false;
                    }
                }
            }
        }

        #region m_input_textbox
        private void m_input_textbox_KeyDown( object sender, KeyEventArgs e ) {
#if DEBUG
            AppManager.DebugWriteLine( "m_input_textbox_KeyDown" );
            AppManager.DebugWriteLine( "    e.KeyCode=" + e.KeyCode );
#endif
            if ( e.KeyCode == Keys.Tab || e.KeyCode == Keys.Return ) {
                ExecuteLyricChangeCommand();
                int selected = AppManager.Selected;
                int index = -1;
                VsqTrack track = AppManager.VsqFile.Track[selected];
                track.sortEvent();
                if ( e.KeyCode == Keys.Tab ) {
                    int clock = 0;
                    for ( int i = 0; i < track.getEventCount(); i++ ) {
                        VsqEvent item = track.getEvent( i );
                        if ( item.InternalID == AppManager.SelectedEvent.LastSelectedID ) {
                            index = i;
                            clock = item.Clock;
                            break;
                        }
                    }
                    if ( (e.Modifiers & Keys.Shift) == Keys.Shift ) {
                        // 1個前の音符イベントを検索
                        int tindex = -1;
                        for ( int i = track.getEventCount() - 1; i >= 0; i-- ) {
                            VsqEvent ve = track.getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote && i != index && ve.Clock <= clock ) {
                                tindex = i;
                                break;
                            }
                        }
                        index = tindex;
                    } else {
                        // 1個後の音符イベントを検索
                        int tindex = -1;
                        for ( int i = 0; i < track.getEventCount(); i++ ) {
                            VsqEvent ve = track.getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote && i != index && ve.Clock >= clock ) {
                                tindex = i;
                                break;
                            }
                        }
                        index = tindex;
                    }
                }
                if ( 0 <= index && index < track.getEventCount() ) {
                    AppManager.ClearSelectedEvent();
                    VsqEvent item = track.getEvent( index );
                    AppManager.AddSelectedEvent( item.InternalID );
                    int x = XCoordFromClocks( item.Clock );
                    int y = YCoordFromNote( item.ID.Note );
                    bool phonetic_symbol_edit_mode = ((TagLyricTextBox)m_input_textbox.Tag).PhoneticSymbolEditMode;
                    ShowInputTextBox( item.ID.LyricHandle.L0.Phrase, 
                                            item.ID.LyricHandle.L0.getPhoneticSymbol(),
                                            new Point( x, y ),
                                            phonetic_symbol_edit_mode );
                    int clWidth = (int)(m_input_textbox.Width / AppManager.ScaleX);
#if DEBUG
                    System.Diagnostics.Debug.WriteLine( "    clWidth=" + clWidth );
#endif
                    // 画面上にm_input_textboxが見えるように，移動
                    const int SPACE = 20;
                    if ( x < AppManager._KEY_LENGTH || pictPianoRoll.Width < x + m_input_textbox.Width ) {
                        int clock, clock_x;
                        if ( x < AppManager._KEY_LENGTH ) {
                            clock = item.Clock;
                            clock_x = AppManager._KEY_LENGTH + SPACE;
                        } else {
                            clock = item.Clock + clWidth;
                            clock_x = pictPianoRoll.Width - SPACE;
                        }
                        double draft_d = (73 - clock_x) / AppManager.ScaleX + clock;
                        if ( draft_d < 0.0 ) {
                            draft_d = 0.0;
                        }
                        int draft = (int)draft_d;
                        if ( draft < hScroll.Minimum ) {
                            draft = hScroll.Minimum;
                        } else if ( hScroll.Maximum < draft ) {
                            draft = hScroll.Maximum;
                        }
                        hScroll.Value = draft;
                    } else {
                        RefreshScreen();
                    }
                } else {
                    HideInputTextBox();
                }
            }
        }

        private void m_input_textbox_KeyUp( object sender, KeyEventArgs e ) {
            if ( (e.KeyCode == Keys.Up || e.KeyCode == Keys.Down) && (Control.ModifierKeys == Keys.Alt) ) {
                if ( m_input_textbox.Enabled ) {
                    FlipInputTextBoxMode();
                }
            } else if ( e.KeyCode == Keys.Escape ) {
                HideInputTextBox();
            }
        }
        
        private void m_input_textbox_ImeModeChanged( object sender, EventArgs e ) {
            m_last_imemode = m_input_textbox.ImeMode;
        }
        #endregion

        private void m_toolbar_edit_SelectedToolChanged( EditTool tool ) {
            AppManager.SelectedTool = tool;
        }

        private void m_toolbar_measure_EndMarkerClick( object sender, EventArgs e ) {
            AppManager.EndMarkerEnabled = !AppManager.EndMarkerEnabled;
#if DEBUG
            AppManager.DebugWriteLine( "m_toolbar_measure_EndMarkerClick" );
            AppManager.DebugWriteLine( "    m_config.EndMarkerEnabled=" + AppManager.EndMarkerEnabled );
#endif
            RefreshScreen();
        }

        private void m_toolbar_measure_StartMarkerClick( object sender, EventArgs e ) {
            AppManager.StartMarkerEnabled = !AppManager.StartMarkerEnabled;
#if DEBUG
            AppManager.DebugWriteLine( "m_toolbar_measure_StartMarkerClick" );
            AppManager.DebugWriteLine( "    m_config.StartMarkerEnabled=" + AppManager.StartMarkerEnabled );
#endif
            RefreshScreen();
        }

        private void itm_Click( object sender, EventArgs e ) {
            if ( sender is ToolStripItem ) {
                ToolStripItem item = (ToolStripItem)sender;
                if ( item.Tag is string ) {
                    string filename = (string)item.Tag;
                    OpenVsqCore( filename );
                    RefreshScreen();
                }
            }
        }

        private void itm_MouseEnter( object sender, EventArgs e ) {
            if ( sender is ToolStripItem ) {
                ToolStripItem item = (ToolStripItem)sender;
                statusLabel.Text = item.ToolTipText;
            }
        }

        #region AppManager
        private void AppManager_CurrentClockChanged( object sender, EventArgs e ) {
            stripLblBeat.Text = AppManager.PlayPosition.Numerator + "/" + AppManager.PlayPosition.Denominator;
            stripLblTempo.Text = (60e6 / (float)AppManager.PlayPosition.Tempo).ToString( "#.00" );
            stripLblCursor.Text = AppManager.PlayPosition.BarCount + " : " + AppManager.PlayPosition.Beat + " : " + AppManager.PlayPosition.Clock.ToString( "000" );
        }

        private void AppManager_GridVisibleChanged( object sender, EventArgs e ) {
            menuVisualGridline.Checked = AppManager.GridVisible;
            stripBtnGrid.Checked = AppManager.GridVisible;
            cMenuPianoGrid.Checked = AppManager.GridVisible;
        }

        private void AppManager_PreviewAborted( object sender, EventArgs e ) {
#if DEBUG
            AppManager.DebugWriteLine( "AppManager_PreviewAborted" );
#endif
            if ( AppManager.EditMode == EditMode.Realtime ) {
                AppManager.EditMode = EditMode.None;
            }
            VSTiProxy.AbortRendering();
            AppManager.FirstBufferWritten = false;
            if ( m_midi_in != null ) {
                m_midi_in.Stop();
            }

            PlaySound.Reset();
            for ( int i = 0; i < m_draw_start_index.Length; i++ ) {
                m_draw_start_index[i] = 0;
            }
            MidiPlayer.Stop();
        }

        private void AppManager_PreviewStarted( object sender, EventArgs e ) {
#if DEBUG
            AppManager.DebugWriteLine( "m_config_PreviewStarted" );
#endif
            PlaySound.Reset();
            string renderer = AppManager.VsqFile.Track[AppManager.Selected].getCommon().Version;
            int clock = AppManager.CurrentClock;
            m_direct_play_shift = (float)AppManager.VsqFile.getSecFromClock( clock );
            if ( AppManager.EditMode != EditMode.Realtime ) {
                int selected = AppManager.Selected;
                string tmppath = AppManager.TempWaveDir;

                double amp_master = VocaloSysUtil.getAmplifyCoeffFromFeder( AppManager.VsqFile.Mixer.MasterFeder );
                double pan_left_master = VocaloSysUtil.getAmplifyCoeffFromPanLeft( AppManager.VsqFile.Mixer.MasterPanpot );
                double pan_right_master = VocaloSysUtil.getAmplifyCoeffFromPanRight( AppManager.VsqFile.Mixer.MasterPanpot );

                // 選択されたトラック以外のレンダリングを行う
                List<int> render_all = new List<int>();
                for ( int track = 1; track < AppManager.VsqFile.Track.Count; track++ ) {
                    if ( track == selected || !(AppManager.VsqFile.Track[track].getCommon().PlayMode >= 0) ) {
                        continue;
                    }
                    string file = Path.Combine( tmppath, track + ".wav" );
                    if ( !File.Exists( file ) ) {
                        render_all.Add( track );
                    }
                }
                if ( render_all.Count > 0 ) {
                    Render( render_all.ToArray() );
                }

                List<string> sounds = new List<string>();
                for ( int track = 1; track < AppManager.VsqFile.Track.Count; track++ ) {
                    if ( track == selected || !(AppManager.VsqFile.Track[track].getCommon().PlayMode >= 0) ) {
                        continue;
                    }

                    string file = Path.Combine( tmppath, track + ".wav" );
                    string tmpfile = Path.Combine( tmppath, "temp.wav" );
                    int t_start = AppManager.VsqFile.Track[track].getEditedStart();
                    int t_end = AppManager.VsqFile.Track[track].getEditedEnd();
                    int start = t_start;
                    int end = t_end;

                    sounds.Add( file );
                    // 編集が施された範囲に存在している音符を探し、（音符の末尾と次の音符の先頭の接続を無視した場合の）最長一致範囲を決める
                    int index_start = -1; //startから始まっている音符のインデックス
                    for ( int i = 0; i < AppManager.VsqFile.Track[track].getEventCount(); i++ ) {
                        VsqEvent item = AppManager.VsqFile.Track[track].getEvent( i );
                        if ( item.Clock <= t_start && t_start <= item.Clock + item.ID.Length ) {
                            start = item.Clock;
                            index_start = i;
                            break;
                        }
                    }
                    int index_end = -1;
                    for ( int i = AppManager.VsqFile.Track[track].getEventCount() - 1; i >= 0; i-- ) {
                        VsqEvent item = AppManager.VsqFile.Track[track].getEvent( i );
                        if ( item.Clock <= t_end && t_end <= item.Clock + item.ID.Length ) {
                            end = item.Clock + item.ID.Length;
                            index_end = i;
                            break;
                        }
                    }

                    // 音符の末尾と次の音符の先頭がつながっている場合、レンダリング範囲を広げる
                    if ( index_start >= 0 ) {
                        for ( int i = index_start - 1; i >= 0; i-- ) {
                            VsqEvent ve = AppManager.VsqFile.Track[track].getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote ) {
                                int endpoint = ve.Clock + ve.ID.Length;
                                if ( endpoint == start ) {
                                    start = ve.Clock;
                                    index_start = i;
                                } else if ( endpoint < start ) {
                                    break;
                                }
                            }
                        }
                    }
                    if ( index_end >= 0 ) {
                        for ( int i = index_end + 1; i < AppManager.VsqFile.Track[track].getEventCount(); i++ ) {
                            VsqEvent ve = AppManager.VsqFile.Track[track].getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote ) {
                                int startpoint = ve.Clock;
                                if ( end == ve.Clock ) {
                                    end = ve.Clock + ve.ID.Length;
                                    index_end = i;
                                } else if ( end < startpoint ) {
                                    break;
                                }
                            }
                        }
                    }

                    if ( start < end ) {
#if DEBUG
                        AppManager.DebugWriteLine( "    partial rendering!" );
#endif
                        int temp_premeasure = AppManager.VsqFile.getPresendClockAt( start, AppManager.EditorConfig.PreSendTime ) * 2;
                        bool successed = false;
                        using ( FormSynthesize dlg = new FormSynthesize( AppManager.VsqFile,
                                                                         AppManager.EditorConfig.PreSendTime,
                                                                         track,
                                                                         tmpfile,
                                                                         start,
                                                                         end,
                                                                         temp_premeasure ) ) {
                            if ( dlg.ShowDialog() == DialogResult.OK ) {
                                successed = true;
                            }
                        }
                        if ( successed ) {
                            AppManager.VsqFile.Track[track].resetEditedArea();
                            using ( Wave main = new Wave( file ) )
                            using ( Wave temp = new Wave( tmpfile ) ) {
                                double sec_start = AppManager.VsqFile.getSecFromClock( start );
                                double sec_end = AppManager.VsqFile.getSecFromClock( end );

                                main.Replace( temp,
                                              0,
                                              (uint)(sec_start * main.SampleRate),
                                              (uint)((sec_end - sec_start) * temp.SampleRate) );
                                main.Write( file );
                            }
                        }
                    }
                }

                // リアルタイム再生用のデータを準備
                double amp_track = VocaloSysUtil.getAmplifyCoeffFromFeder( AppManager.VsqFile.Mixer.Slave[selected - 1].Feder );
                double pan_left_track = VocaloSysUtil.getAmplifyCoeffFromPanLeft( AppManager.VsqFile.Mixer.Slave[selected - 1].Panpot );
                double pan_right_track = VocaloSysUtil.getAmplifyCoeffFromPanRight( AppManager.VsqFile.Mixer.Slave[selected - 1].Panpot );
                double amp_left = amp_master * amp_track * pan_left_master * pan_left_track;
                double amp_right = amp_master * amp_track * pan_right_master * pan_right_track;
                m_preview_ending_time = AppManager.VsqFile.getSecFromClock( AppManager.VsqFile.TotalClocks ) + 1.0;

                // clock以降に音符があるかどうかを調べる
                int count = 0;
                for ( Iterator itr = AppManager.VsqFile.Track[AppManager.Selected].getNoteEventIterator(); itr.hasNext(); ) {
                    VsqEvent ve = (VsqEvent)itr.next();
                    if ( ve.Clock >= clock ) {
                        count++;
                        break;
                    }
                }

                if ( AppManager.VsqFile.Track[AppManager.Selected].getCommon().PlayMode >= 0 && count > 0 ) {
                    int ms_presend = AppManager.EditorConfig.PreSendTime;
                    if ( renderer.StartsWith( VSTiProxy.RENDERER_UTU0 ) ) {
                        ms_presend = 0;
                    }
#if DEBUG
                    AppManager.DebugWriteLine( "m_preview_ending_time=" + m_preview_ending_time );
#endif
                    VSTiProxy.Render( AppManager.VsqFile,
                                      selected,
                                      null,
                                      m_direct_play_shift,
                                      m_preview_ending_time,
                                      amp_left,
                                      amp_right,
                                      ms_presend,
                                      true,
                                      sounds.ToArray(),
                                      m_direct_play_shift,
                                      true,
                                      AppManager.TempWaveDir );

                    for ( int i = 0; i < m_draw_start_index.Length; i++ ) {
                        m_draw_start_index[i] = 0;
                    }
                    int clock_now = AppManager.CurrentClock;
                    double sec_now = AppManager.VsqFile.getSecFromClock( clock_now );
                } else {
                    VSTiProxy.Render( new VsqFileEx( "Miku", AppManager.VsqFile.getPreMeasure(), 4, 4, 500000 ),
                                      1,
                                      null,
                                      0,
                                      m_preview_ending_time,
                                      amp_left,
                                      amp_right,
                                      AppManager.EditorConfig.PreSendTime,
                                      true,
                                      sounds.ToArray(),
                                      m_direct_play_shift,
                                      true,
                                      AppManager.TempWaveDir );
                }
            }

            m_last_ignitted = DateTime.Now;
            if ( AppManager.EditMode == EditMode.Realtime ) {
                if ( m_midi_in != null ) {
                    m_midi_in.Start();
                }
                AppManager.RendererAvailable = false;
                MidiPlayer.SetSpeed( AppManager.EditorConfig.RealtimeInputSpeed, m_last_ignitted );
                MidiPlayer.Start( AppManager.VsqFile, clock, m_last_ignitted );
            } else {
                AppManager.RendererAvailable = VSTiProxy.IsRendererAvailable( renderer );
            }
            AppManager.FirstBufferWritten = true;
            AppManager.PreviewStartedTime = m_last_ignitted;
#if DEBUG
            AppManager.DebugWriteLine( "    m_config.VsqFile.TotalClocks=" + AppManager.VsqFile.TotalClocks );
            AppManager.DebugWriteLine( "    total seconds=" + AppManager.VsqFile.getSecFromClock( (int)AppManager.VsqFile.TotalClocks ) );
#endif
            timer.Enabled = true;
        }

        private void AppManager_SelectedToolChanged( object sender, EventArgs e ) {
            ApplySelectedTool();
        }

        private void AppManager_SelectedEventChanged( bool selected_event_is_null ) {
            menuEditCut.Enabled = !selected_event_is_null;
            menuEditPaste.Enabled = !selected_event_is_null;
            menuEditDelete.Enabled = !selected_event_is_null;
            cMenuPianoCut.Enabled = !selected_event_is_null;
            cMenuPianoCopy.Enabled = !selected_event_is_null;
            cMenuPianoDelete.Enabled = !selected_event_is_null;
            cMenuPianoExpressionProperty.Enabled = !selected_event_is_null;
        }
        #endregion

        #region pictPianoRoll
        private void pictPianoRoll_MouseClick( object sender, MouseEventArgs e ) {
#if DEBUG
            AppManager.DebugWriteLine( "pictPianoRoll_MouseClick" );
#endif
            Keys modefier = Control.ModifierKeys;
            if ( e.Button == MouseButtons.Left ) {
                if ( m_mouse_hover_thread != null ) {
                    m_mouse_hover_thread.Abort();
                }

                // クリック位置にIDが無いかどうかを検査
                Rectangle id_rect;
                VsqEvent item = GetItemAtClickedPosition( e.Location, out id_rect );
#if DEBUG
                AppManager.DebugWriteLine( "    (item==null)=" + (item == null) );
#endif
                if ( item != null && 
                        AppManager.EditMode != EditMode.MoveEntryWaitMove && 
                        AppManager.EditMode != EditMode.MoveEntry && 
                        AppManager.EditMode != EditMode.EditLeftEdge && 
                        AppManager.EditMode != EditMode.EditRightEdge ) {
                    if ( (modefier & Keys.Shift) != Keys.Shift && (modefier & s_modifier_key) != s_modifier_key ) {
                        AppManager.ClearSelectedEvent();
                    }
                    AppManager.AddSelectedEvent( item.InternalID );
                    int selected = AppManager.Selected;
                    int internal_id = item.InternalID;
                    HideInputTextBox();
                    if ( AppManager.SelectedTool == EditTool.Eraser ) {
                        CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventDelete( selected, internal_id ) );
                        AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                        Edited = true;
                        AppManager.ClearSelectedEvent();
                        return;
                    } else if ( AppManager.SelectedTool == EditTool.PaletteTool ) {
                        List<int> internal_ids = new List<int>();
                        foreach ( SelectedEventEntry see in AppManager.SelectedEvent.GetEnumerator() ) {
                            internal_ids.Add( see.Original.InternalID );
                        }
                        MouseButtons btn = e.Button;
                        if ( m_spacekey_downed ) {
                            btn = MouseButtons.Middle;
                        }
                        bool result = PaletteToolServer.InvokePaletteTool( AppManager.SelectedPaletteTool,
                                                                           AppManager.Selected,
                                                                           internal_ids.ToArray(),
                                                                           btn );
                        if ( result ) {
                            Edited = true;
                            AppManager.ClearSelectedEvent();
                            return;
                        }
                    }
                } else {
                    if ( AppManager.EditMode != EditMode.MoveEntryWaitMove &&
                            AppManager.EditMode != EditMode.MoveEntry && 
                            AppManager.EditMode != EditMode.EditLeftEdge && 
                            AppManager.EditMode != EditMode.EditRightEdge ) {
                        if ( !m_pointer_downed ) {
                            AppManager.ClearSelectedEvent();
                        }
                        HideInputTextBox();
                    }
                    if ( AppManager.SelectedTool == EditTool.Eraser ) {
                        // マウス位置にビブラートの波波があったら削除する
                        int stdx = AppManager.StartToDrawX;
                        int stdy = StartToDrawY;
#if USE_DOBJ
                        for ( int i = 0; i < m_draw_objects[AppManager.Selected - 1].Count; i++ ) {
                            DrawObject dobj = m_draw_objects[AppManager.Selected - 1][i];
                            if ( dobj.pxRectangle.X + dobj.pxRectangle.Width - stdx < 0 ) {
                                continue;
                            } else if ( pictPianoRoll.Width < dobj.pxRectangle.X - stdx ) {
                                break;
                            }
                            Rectangle rc = new Rectangle( dobj.pxRectangle.X + dobj.pxVibratoDelay - stdx,
                                                          dobj.pxRectangle.Y + AppManager.EditorConfig.PxTrackHeight - stdy,
                                                          dobj.pxRectangle.Width - dobj.pxVibratoDelay,
                                                          AppManager.EditorConfig.PxTrackHeight );
#else
                        VsqTrack vsq_track = AppManager.VsqFile.getTrack( AppManager.Selected );
                        float scalex = AppManager.ScaleX;
                        for( Iterator itr0 = vsq_track.getNoteEventIterator(); itr0.hasNext();){
                            VsqEvent evnt = (VsqEvent)itr0.next();
                            if ( evnt.ID.VibratoHandle == null ){
                                continue;
                            }
                            int event_sx = XCoordFromClocks( evnt.Clock );
                            int event_ex = XCoordFromClocks( evnt.Clock + evnt.ID.Length);
                            int vib_sx = XCoordFromClocks( evnt.Clock + evnt.ID.VibratoDelay);
                            Rectangle rc = new Rectangle( vib_sx,
                                                          YCoordFromNote( evnt.ID.Note, stdy ),
                                                          event_ex - vib_sx,
                                                          AppManager.EditorConfig.PxTrackHeight );
#endif
                            if ( IsInRect( e.Location, rc ) ) {
                                //ビブラートの範囲なのでビブラートを消す
                                VsqID item2 = null;
                                int internal_id = -1;
#if USE_DOBJ
                                internal_id = dobj.InternalID;
                                for ( Iterator itr = AppManager.VsqFile.Track[AppManager.Selected].getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = (VsqEvent)itr.next();
                                    if ( ve.InternalID == dobj.InternalID ) {
                                        item2 = (VsqID)ve.ID.Clone();
                                        break;
                                    }
                                }
#else
                                item2 = evnt.ID;
                                internal_id = evnt.InternalID;
#endif
                                if ( item2 != null ) {
                                    item2.VibratoHandle = null;
                                    CadenciiCommand run = new CadenciiCommand(
                                        VsqCommand.generateCommandEventChangeIDContaints( AppManager.Selected,
                                                                                          internal_id,
                                                                                          item2 ) );
                                    AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                                    Edited = true;
                                }
                                break;
                            }
                        }
                    }
                }
            } else if ( e.Button == MouseButtons.Right ) {
                bool show_context_menu = (e.X > AppManager._KEY_LENGTH);
                if ( m_mouse_hover_thread != null ) {
                    if ( !m_mouse_hover_thread.IsAlive && AppManager.EditorConfig.PlayPreviewWhenRightClick ) {
                        show_context_menu = false;
                    }
                } else {
                    if ( AppManager.EditorConfig.PlayPreviewWhenRightClick ) {
                        show_context_menu = false;
                    }
                }
                show_context_menu = show_context_menu && !m_mouse_moved;
                if ( show_context_menu ) {
                    if ( m_mouse_hover_thread != null ) {
                        m_mouse_hover_thread.Abort();
                    }
                    Rectangle id_rect;
                    VsqEvent item = GetItemAtClickedPosition( e.Location, out id_rect );
                    if ( item != null ) {
                        if ( !AppManager.SelectedEvent.ContainsKey( AppManager.Selected, item.InternalID ) ) {
                            AppManager.ClearSelectedEvent();
                        }
                        AppManager.AddSelectedEvent( item.InternalID );
                    }
                    bool item_is_null = (item == null);
                    cMenuPianoCopy.Enabled = !item_is_null;
                    cMenuPianoCut.Enabled = !item_is_null;
                    cMenuPianoDelete.Enabled = !item_is_null;
                    cMenuPianoImportLyric.Enabled = !item_is_null;
                    cMenuPianoExpressionProperty.Enabled = !item_is_null;

                    int clock = ClockFromXCoord( e.X );
                    cMenuPianoPaste.Enabled = ((AppManager.GetCopiedEvent().Count != 0) && (clock >= AppManager.VsqFile.getPreMeasureClocks()));
                    RefreshScreen();

                    m_cMenuOpenedPosition = e.Location;
                    cMenuPiano.Show( pictPianoRoll, e.Location );
                } else {
                    Rectangle id_rect;
                    VsqEvent item = GetItemAtClickedPosition( m_button_initial, out id_rect );
#if DEBUG
                    AppManager.DebugWriteLine( "pitcPianoRoll_MouseClick; button is right; (item==null)=" + (item == null) );
#endif
                    if ( item != null ) {
                        int itemx = XCoordFromClocks( item.Clock );
                        int itemy = YCoordFromNote( item.ID.Note );
#if PROPRETY_WINDOW
                        lock ( m_property_windows ) {
                            int width = 100;
                            int height = 100;
                            if ( !m_property_windows[AppManager.Selected - 1].ContainsKey( item.InternalID ) ) {
                                int dx = e.X - m_button_initial.X;
                                int dy = e.Y - m_button_initial.Y;
                                ContextProperty cp = new ContextProperty( item.InternalID );
                                cp.FormClosing += new BSimpleDelegate<int>( commonContextProperty_FormClosing );
                                cp.Bounds = new Rectangle( e.X - width / 2, e.Y - cp.TitleHeight / 2, width, height );
                                cp.Shift = new Point( e.X - width / 2 - itemx, e.Y - cp.TitleHeight / 2 - itemy );
                                cp.Title = item.ID.LyricHandle.L0.Phrase + " [" + item.ID.LyricHandle.L0.getPhoneticSymbol() + "]";
                                m_property_windows[AppManager.Selected - 1].Add( item.InternalID, cp );
                            } else {
                                ContextProperty cp = m_property_windows[AppManager.Selected - 1][item.InternalID];
                                cp.Bounds = new Rectangle( e.X - width / 2, e.Y - cp.TitleHeight / 2, width, height );
                                cp.Shift = new Point( e.X - width / 2 - itemx, e.Y - cp.TitleHeight / 2 - itemy );
                            }
                        }
#endif
                    }
                }
            } else if ( e.Button == MouseButtons.Middle ) {
                if ( AppManager.SelectedTool == EditTool.PaletteTool ) {
                    Rectangle id_rect;
                    VsqEvent item = GetItemAtClickedPosition( e.Location, out id_rect );
                    if ( item != null ) {
                        if ( AppManager.SelectedTool == EditTool.PaletteTool ) {
                            AppManager.ClearSelectedEvent();
                            AppManager.AddSelectedEvent( item.InternalID );
                            List<int> internal_ids = new List<int>();
                            foreach ( SelectedEventEntry see in AppManager.SelectedEvent.GetEnumerator() ) {
                                internal_ids.Add( see.Original.InternalID );
                            }
                            bool result = PaletteToolServer.InvokePaletteTool( AppManager.SelectedPaletteTool,
                                                                               AppManager.Selected,
                                                                               internal_ids.ToArray(),
                                                                               e.Button );
                            if ( result ) {
                                Edited = true;
                                AppManager.ClearSelectedEvent();
                                return;
                            }
                        }
                    }
                }
            }
        }

#if PROPRETY_WINDOW
        private void commonContextProperty_FormClosing( int internal_id ) {
            lock ( m_property_windows ) {
                if ( m_property_windows[AppManager.Selected - 1].ContainsKey( internal_id ) ) {
                    m_property_windows[AppManager.Selected - 1].Remove( internal_id );
                }
            }
        }
#endif

        private void pictPianoRoll_MouseDoubleClick( object sender, MouseEventArgs e ) {
#if DEBUG
            AppManager.DebugWriteLine( "pictureBox1_MouseDoubleClick" );
#endif
            Rectangle rect;
            VsqEvent item = GetItemAtClickedPosition( e.Location, out rect );
            if ( item != null ) {
                if ( AppManager.SelectedTool != EditTool.PaletteTool ) {
                    AppManager.ClearSelectedEvent();
                    AppManager.AddSelectedEvent( item.InternalID );
                    m_mouse_hover_thread.Abort();
                    if ( !AppManager.EditorConfig.KeepLyricInputMode ) {
                        m_last_symbol_edit_mode = false;
                    }
                    ShowInputTextBox( item.ID.LyricHandle.L0.Phrase, item.ID.LyricHandle.L0.getPhoneticSymbol(), rect.Location, m_last_symbol_edit_mode );
                    RefreshScreen();
                    return;
                }
            } else {
                AppManager.ClearSelectedEvent();
                HideInputTextBox();
                if ( AppManager.EditorConfig.ShowExpLine && AppManager._KEY_LENGTH <= e.X ) {
                    int stdx = AppManager.StartToDrawX;
                    int stdy = StartToDrawY;
#if USE_DOBJ
                    foreach ( DrawObject dobj in m_draw_objects[AppManager.Selected - 1] ) {
                        // 表情コントロールプロパティを表示するかどうかを決める
                        rect = new Rectangle(
                            dobj.pxRectangle.X - stdx,
                            dobj.pxRectangle.Y - stdy + AppManager.EditorConfig.PxTrackHeight,
                            21,
                            AppManager.EditorConfig.PxTrackHeight );
#else
                    for( Iterator itr = AppManager.VsqFile.getTrack( AppManager.Selected ).getNoteEventIterator(); itr.hasNext(); ){
                        VsqEvent evnt = (VsqEvent)itr.next();
                        int event_ex = XCoordFromClocks( evnt.Clock + evnt.ID.Length );
                        if ( event_ex < 0 ) {
                            continue;
                        }
                        int event_sx = XCoordFromClocks( evnt.Clock );
                        if ( pictPianoRoll.Width < event_sx ) {
                            break;
                        }
                        int vib_sx = XCoordFromClocks( evnt.Clock + evnt.ID.VibratoDelay);
                        int event_sy = YCoordFromNote( evnt.ID.Note, stdy );
                        rect = new Rectangle( event_sx, event_sy, 21, AppManager.EditorConfig.PxTrackHeight );
#endif
                        if ( IsInRect( e.Location, rect ) ) {
                            VsqEvent selected = null;
#if USE_DOBJ
                            for ( Iterator itr = AppManager.VsqFile.Track[AppManager.Selected].getEventIterator(); itr.hasNext(); ) {
                                VsqEvent ev = (VsqEvent)itr.next();
                                if ( ev.InternalID == dobj.InternalID ) {
                                    selected = ev;
                                    break;
                                }
                            }
#else
                            selected = evnt;
#endif
                            if ( selected != null ) {
                                if ( m_mouse_hover_thread != null ) {
                                    m_mouse_hover_thread.Abort();
                                }
                                using ( FormSingerStyleConfig dlg = new FormSingerStyleConfig( _( "Expression control property" ), false ) ) {
                                    dlg.PMBendDepth = selected.ID.PMBendDepth;
                                    dlg.PMBendLength = selected.ID.PMBendLength;
                                    dlg.PMbPortamentoUse = selected.ID.PMbPortamentoUse;
                                    dlg.DEMdecGainRate = selected.ID.DEMdecGainRate;
                                    dlg.DEMaccent = selected.ID.DEMaccent;
                                    dlg.Location = GetFormPreferedLocation( dlg );
                                    if ( dlg.ShowDialog() == DialogResult.OK ) {
                                        VsqID id = (VsqID)selected.ID.Clone();
                                        id.PMBendDepth = dlg.PMBendDepth;
                                        id.PMBendLength = dlg.PMBendLength;
                                        id.PMbPortamentoUse = dlg.PMbPortamentoUse;
                                        id.DEMdecGainRate = dlg.DEMdecGainRate;
                                        id.DEMaccent = dlg.DEMaccent;
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandEventChangeIDContaints( AppManager.Selected, selected.InternalID, id ) );
                                        AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                                        Edited = true;
                                        RefreshScreen();
                                    }
                                }
                                return;
                            }
                            break;
                        }

                        // ビブラートプロパティダイアログを表示するかどうかを決める
#if USE_DOBJ
                        rect = new Rectangle( dobj.pxRectangle.X - stdx + 21,
                                              dobj.pxRectangle.Y - stdy + AppManager.EditorConfig.PxTrackHeight,
                                              dobj.pxRectangle.Width - 21,
                                              AppManager.EditorConfig.PxTrackHeight );
#else
                        if ( evnt.ID.VibratoHandle == null ){
                            continue;
                        }
                        rect = new Rectangle( event_sx + 21, 
                                              event_sy + AppManager.EditorConfig.PxTrackHeight,
                                              event_ex - event_sx - 21,
                                              AppManager.EditorConfig.PxTrackHeight );
#endif
                        if ( IsInRect( e.Location, rect ) ) {
                            VsqEvent selected = null;
#if USE_DOBJ
                            for ( Iterator itr = AppManager.VsqFile.Track[AppManager.Selected].getEventIterator(); itr.hasNext(); ) {
                                VsqEvent ev = (VsqEvent)itr.next();
                                if ( ev.InternalID == dobj.InternalID ) {
                                    selected = ev;
                                    break;
                                }
                            }
#else
                            selected = evnt;
#endif
                            if ( selected != null ) {
                                if ( m_mouse_hover_thread != null ) {
                                    m_mouse_hover_thread.Abort();
                                }
                                using ( FormVibratoConfig dlg = new FormVibratoConfig( selected.ID.VibratoHandle, selected.ID.Length, AppManager.EditorConfig.DefaultVibratoLength ) ) {
                                    dlg.Location = GetFormPreferedLocation( dlg );
                                    if ( dlg.ShowDialog() == DialogResult.OK ) {
                                        VsqID t = (VsqID)selected.ID.Clone();
                                        t.VibratoHandle = dlg.VibratoHandle;
                                        if ( t.VibratoHandle != null ) {
                                            int vibrato_length = t.VibratoHandle.Length;
                                            int note_length = selected.ID.Length;
                                            t.VibratoDelay = note_length - vibrato_length;
                                        }
                                        CadenciiCommand run = new CadenciiCommand( 
                                            VsqCommand.generateCommandEventChangeIDContaints( AppManager.Selected,
                                                                                    selected.InternalID,
                                                                                    t ) );
                                        AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                                        Edited = true;
                                        RefreshScreen();
                                    }
                                }
                                return;
                            }
                            break;
                        }

                    }
                }
            }

            // 必要な操作が何も無ければ，クリック位置にソングポジションを移動
            if ( e.Button == MouseButtons.Left && AppManager._KEY_LENGTH < e.X ) {
                int unit = AppManager.GetPositionQuantizeClock();
                int clock = ClockFromXCoord( e.X );
                int odd = clock % unit;
                clock -= odd;
                if ( odd > unit / 2 ) {
                    clock += unit;
                }
                AppManager.CurrentClock = clock;
            }
        }

        private void pictPianoRoll_MouseDown( object sender, MouseEventArgs e ) {
#if DEBUG
            AppManager.DebugWriteLine( "pictPianoRoll_MouseDown" );
#endif
            if ( AppManager.EditMode == EditMode.Realtime ) {
                return;
            }

#if PROPRETY_WINDOW
            // message passing
            foreach ( ContextProperty cp in m_property_windows[AppManager.Selected - 1].Values ) {
                if ( cp.MouseDown( pictPianoRoll, e ) ) {
                    RefreshScreen();
                    return;
                }
            }
#endif

            m_mouse_moved = false;
            if ( !AppManager.Playing ) {
                int note = NoteFromYCoord( e.Y );
                if ( 0 <= note && note <= 126 && 0 <= e.X && e.X <= AppManager._KEY_LENGTH ) {
                    if ( e.Button == MouseButtons.Left ) {
                        KeySoundPlayer.Play( note );
                    }
                    return;
                }
            }

            AppManager.ClearSelectedTempo();
            AppManager.ClearSelectedTimesig();
            trackSelector.DisableSelectedRegion();
            if ( e.Button == MouseButtons.Left ) {
                AppManager.SelectedRegionEnabled = false;
            }

            m_mouse_downed = true;
            m_button_initial = e.Location;
            Keys modefier = Control.ModifierKeys;
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }

            Rectangle rect;
            VsqEvent item = GetItemAtClickedPosition( e.Location, out rect );

            if ( item == null && (e.Button == MouseButtons.Middle || m_spacekey_downed) ) {
                AppManager.EditMode = EditMode.MiddleDrag;
                m_middle_button_vscroll = vScroll.Value;
                m_middle_button_hscroll = hScroll.Value;
                return;
            }

            EditTool selected_tool = AppManager.SelectedTool;

            // マウス位置にある音符を検索
            if ( item == null ) {
                #region 音符がなかった時
#if DEBUG
                AppManager.DebugWriteLine( "    No Event" );
#endif
                if ( AppManager.SelectedEvent.LastSelected != null ) {
                    ExecuteLyricChangeCommand();
                }
                bool start_mouse_hover_generator = true;
                if ( (modefier & s_modifier_key) == s_modifier_key ) {
                    AppManager.SelectedRegionEnabled = true;
                    int stdx = AppManager.StartToDrawX;
                    int x = e.X + stdx;
                    if ( AppManager.EditorConfig.CurveSelectingQuantized ) {
                        int clock = ClockFromXCoord( e.X );
                        int unit = AppManager.GetPositionQuantizeClock();
                        int odd = clock % unit;
                        int nclock = clock;
                        nclock -= odd;
                        if ( odd > unit / 2 ) {
                            nclock += unit;
                        }
                        x = XCoordFromClocks( nclock ) + stdx;
                    }
                    AppManager.SelectedRegion = new SelectedRegion( x );
                    AppManager.SelectedRegion.SetEnd( x );
                    m_pointer_downed = true;
                } else {
                    bool vibrato_found = false;
                    if ( selected_tool == EditTool.Line || selected_tool == EditTool.Pencil ) {
                        // ビブラート範囲の編集
                        int px_vibrato_length = 0;
                        int stdx = AppManager.StartToDrawX;
                        int stdy = StartToDrawY;
                        m_vibrato_editing_id = -1;
#if USE_DOBJ
                        Rectangle pxFound = new Rectangle();
                        for ( int i = 0; i < m_draw_objects[AppManager.Selected - 1].Count; i++ ) {
                            DrawObject dobj = m_draw_objects[AppManager.Selected - 1][i];
                            if ( dobj.pxRectangle.Width <= dobj.pxVibratoDelay ) {
                                continue;
                            }
                            if ( dobj.pxRectangle.X + dobj.pxRectangle.Width - stdx < 0 ) {
                                continue;
                            } else if ( pictPianoRoll.Width < dobj.pxRectangle.X - stdx ) {
                                break;
                            }
                            Rectangle rc = new Rectangle( dobj.pxRectangle.X + dobj.pxVibratoDelay - stdx - _EDIT_HANDLE_WIDTH / 2,
                                                dobj.pxRectangle.Y + AppManager.EditorConfig.PxTrackHeight - stdy,
                                                _EDIT_HANDLE_WIDTH,
                                                AppManager.EditorConfig.PxTrackHeight );
#else
                        int clock = 0;
                        int note = 0;
                        int length = 0;
                        for ( Iterator itr = AppManager.VsqFile.getTrack( AppManager.Selected ).getNoteEventIterator(); itr.hasNext(); ){
                            VsqEvent evnt = (VsqEvent)itr.next();
                            if ( evnt.ID.VibratoHandle == null ){
                                continue;
                            }
                            int event_ex = XCoordFromClocks( evnt.Clock + evnt.ID.Length );
                            if ( event_ex < 0 ) {
                                continue;
                            }
                            int event_sx = XCoordFromClocks( evnt.Clock );
                            if ( pictPianoRoll.Width < event_sx ) {
                                break;
                            }
                            int vib_sx = XCoordFromClocks( evnt.Clock + evnt.ID.VibratoDelay );
                            Rectangle rc = new Rectangle( event_sx - _EDIT_HANDLE_WIDTH / 2,
                                                          YCoordFromNote( evnt.ID.Note ) + AppManager.EditorConfig.PxTrackHeight,
                                                          _EDIT_HANDLE_WIDTH,
                                                          AppManager.EditorConfig.PxTrackHeight );
#endif
                            if ( IsInRect( e.Location, rc ) ) {
                                vibrato_found = true;
#if USE_DOBJ
                                m_vibrato_editing_id = dobj.InternalID;
                                pxFound = dobj.pxRectangle;
                                px_vibrato_length = dobj.pxRectangle.Width - dobj.pxVibratoDelay;
#else
                                m_vibrato_editing_id = evnt.InternalID;
                                clock = evnt.Clock + evnt.ID.VibratoDelay;
                                note = evnt.ID.Note - 1;
                                length = evnt.ID.Length;
                                px_vibrato_length = event_ex - vib_sx;
#endif
                                break;
                            }
                        }
                        if ( vibrato_found ) {
#if USE_DOBJ
                            int clock = ClockFromXCoord( pxFound.X + pxFound.Width - px_vibrato_length - stdx );
                            int note = NoteFromYCoord( pxFound.Y + AppManager.EditorConfig.PxTrackHeight - stdy );
                            int length = (int)(pxFound.Width / AppManager.ScaleX);
#endif
                            m_adding = new VsqEvent( clock, new VsqID( 0 ) );
                            m_adding.ID.type = VsqIDType.Anote;
                            m_adding.ID.Note = note;
                            m_adding.ID.Length = (int)(px_vibrato_length / AppManager.ScaleX);
                            m_adding_length = length;
                            m_adding.ID.VibratoDelay = length - (int)(px_vibrato_length / AppManager.ScaleX);
                            AppManager.EditMode = EditMode.EditVibratoDelay;
                            start_mouse_hover_generator = false;
                        }
                    }
                    if ( !vibrato_found ) {
                        if ( (selected_tool == EditTool.Pencil || selected_tool == EditTool.Line) &&
                            e.Button == MouseButtons.Left &&
                            e.X >= AppManager._KEY_LENGTH ) {
                            int clock = ClockFromXCoord( e.X );
                            if ( AppManager.VsqFile.getPreMeasureClocks() - AppManager.EditorConfig.PxTolerance / AppManager.ScaleX <= clock ) { //10ピクセルまでは許容範囲
                                if ( AppManager.VsqFile.getPreMeasureClocks() > clock ) { //だけど矯正するよ。
                                    clock = AppManager.VsqFile.getPreMeasureClocks();
                                }
                                int note = NoteFromYCoord( e.Y );
                                AppManager.ClearSelectedEvent();
                                int unit = AppManager.GetPositionQuantizeClock();
                                int odd = clock % unit;
                                int new_clock = clock - odd;
                                if ( odd > unit / 2 ) {
                                    new_clock += unit;
                                }
                                m_adding = new VsqEvent( new_clock, new VsqID( 0 ) );
                                m_adding.ID.PMBendDepth = AppManager.EditorConfig.DefaultPMBendDepth;
                                m_adding.ID.PMBendLength = AppManager.EditorConfig.DefaultPMBendLength;
                                m_adding.ID.PMbPortamentoUse = AppManager.EditorConfig.DefaultPMbPortamentoUse;
                                m_adding.ID.DEMdecGainRate = AppManager.EditorConfig.DefaultDEMdecGainRate;
                                m_adding.ID.DEMaccent = AppManager.EditorConfig.DefaultDEMaccent;
                                if ( m_pencil_mode.Mode == PencilModeEnum.Off ) {
                                    AppManager.EditMode = EditMode.AddEntry;
                                    m_button_initial = e.Location;
                                    m_adding.ID.Length = 0;
                                    m_adding.ID.Note = note;
                                    Cursor = Cursors.Arrow;
#if DEBUG
                                    AppManager.DebugWriteLine( "    EditMode=" + AppManager.EditMode );
#endif
                                } else {
                                    AppManager.EditMode = EditMode.AddFixedLengthEntry;
                                    m_adding.ID.Length = m_pencil_mode.GetUnitLength();
                                    m_adding.ID.Note = note;
                                    Cursor = Cursors.Arrow;
                                }
                            } else {
                                SystemSounds.Asterisk.Play();
                            }
                        } else if ( (selected_tool == EditTool.Arrow || selected_tool == EditTool.PaletteTool) && e.Button == MouseButtons.Left ) {
                            AppManager.SelectedRegionEnabled = false;
                            AppManager.ClearSelectedEvent();
                            m_pointer_mouse_down = new Point( e.X + AppManager.StartToDrawX, e.Y + StartToDrawY );
                            m_pointer_downed = true;
#if DEBUG
                            AppManager.DebugWriteLine( "    EditMode=" + AppManager.EditMode );
#endif
                        }
                    }
                }
                if ( e.Button == MouseButtons.Right && !AppManager.EditorConfig.PlayPreviewWhenRightClick ) {
                    start_mouse_hover_generator = false;
                }
                if ( start_mouse_hover_generator ) {
                    m_mouse_hover_thread = new Thread( new ParameterizedThreadStart( MouseHoverEventGenerator ) );
                    m_mouse_hover_thread.Start( NoteFromYCoord( e.Y ) );
                }
                #endregion
            } else {
                #region 音符があった時
#if DEBUG
                AppManager.DebugWriteLine( "    Event Found" );
#endif
                if ( selected_tool != EditTool.Eraser ) {
                    m_mouse_hover_thread = new Thread( new ParameterizedThreadStart( MouseHoverEventGenerator ) );
                    m_mouse_hover_thread.Start( item.ID.Note );
                }
                // まず、両端の編集モードに移行可能かどうか調べる
                if ( selected_tool != EditTool.Eraser && selected_tool != EditTool.PaletteTool && e.Button == MouseButtons.Left ) {
                    int stdx = AppManager.StartToDrawX;
                    int stdy = StartToDrawY;
#if USE_DOBJ
                    foreach ( DrawObject dobj in m_draw_objects[AppManager.Selected - 1] ) {
                        Rectangle rc = new Rectangle( dobj.pxRectangle.X - stdx, dobj.pxRectangle.Y - stdy, _EDIT_HANDLE_WIDTH, dobj.pxRectangle.Height );
#else
                    for( Iterator itr = AppManager.VsqFile.getTrack( AppManager.Selected ).getNoteEventIterator(); itr.hasNext(); ){
                        VsqEvent evnt = (VsqEvent)itr.next();
                        int event_ex = XCoordFromClocks( evnt.Clock + evnt.ID.Length );
                        if ( event_ex < 0 ) {
                            continue;
                        }
                        int event_sx = XCoordFromClocks( evnt.Clock );
                        if ( pictPianoRoll.Width < event_sx ) {
                            break;
                        }
                        int event_sy = YCoordFromNote( evnt.ID.Note, stdy );

                        // 左端
                        Rectangle rc = new Rectangle( event_sx - _EDIT_HANDLE_WIDTH / 2, 
                                                      event_sy,
                                                      _EDIT_HANDLE_WIDTH,
                                                      AppManager.EditorConfig.PxTrackHeight );
#endif
                        if ( IsInRect( e.Location, rc ) ) {
                            AppManager.EditMode = EditMode.EditLeftEdge;
                            if ( !AppManager.SelectedEvent.ContainsKey( AppManager.Selected, item.InternalID ) ) {
                                AppManager.ClearSelectedEvent();
                            }
                            AppManager.AddSelectedEvent( item.InternalID );
                            this.Cursor = Cursors.VSplit;
                            RefreshScreen();
#if DEBUG
                            AppManager.DebugWriteLine( "    EditMode=" + AppManager.EditMode );
#endif
                            return;
                        }
#if USE_DOBJ
                        rc = new Rectangle( dobj.pxRectangle.X + dobj.pxRectangle.Width - stdx - _EDIT_HANDLE_WIDTH, dobj.pxRectangle.Y - stdy, _EDIT_HANDLE_WIDTH, dobj.pxRectangle.Height );
#else
                        rect = new Rectangle( event_ex - _EDIT_HANDLE_WIDTH / 2,
                                              event_sy,
                                              _EDIT_HANDLE_WIDTH,
                                              AppManager.EditorConfig.PxTrackHeight );
#endif
                        if ( IsInRect( e.Location, rc ) ) {
                            AppManager.EditMode = EditMode.EditRightEdge;
                            if ( !AppManager.SelectedEvent.ContainsKey( AppManager.Selected, item.InternalID ) ) {
                                AppManager.ClearSelectedEvent();
                            }
                            AppManager.AddSelectedEvent( item.InternalID );
                            this.Cursor = Cursors.VSplit;
                            RefreshScreen();
#if DEBUG
                            AppManager.DebugWriteLine( "    EditMode=" + AppManager.EditMode );
#endif
                            return;
                        }
                    }
                }
                if ( e.Button == MouseButtons.Left || e.Button == MouseButtons.Middle ) {
                    if ( selected_tool == EditTool.PaletteTool ) {
                        AppManager.EditMode = EditMode.None;
                        AppManager.ClearSelectedEvent();
                        AppManager.AddSelectedEvent( item.InternalID );
                    } else if ( selected_tool != EditTool.Eraser ) {
                        AppManager.EditMode = EditMode.MoveEntryWaitMove;
                        m_mouse_move_init = new Point( e.X + AppManager.StartToDrawX, e.Y + StartToDrawY );
                        int head_x = XCoordFromClocks( item.Clock );
                        m_mouse_move_offset = e.X - head_x;
                        if ( (modefier & Keys.Shift) == Keys.Shift ) {
                            // 範囲選択
                            int last_id = AppManager.SelectedEvent.LastSelectedID;
                            int last_clock = 0;
                            int this_clock = 0;
                            bool this_found = false, last_found = false;
                            for ( Iterator itr = AppManager.VsqFile.Track[AppManager.Selected].getEventIterator(); itr.hasNext(); ) {
                                VsqEvent ev = (VsqEvent)itr.next();
                                if ( ev.InternalID == last_id ) {
                                    last_clock = ev.Clock;
                                    last_found = true;
                                } else if ( ev.InternalID == item.InternalID ) {
                                    this_clock = ev.Clock;
                                    this_found = true;
                                }
                                if ( last_found && this_found ) {
                                    break;
                                }
                            }
                            int start = Math.Min( last_clock, this_clock );
                            int end = Math.Max( last_clock, this_clock );
                            List<int> add_required = new List<int>();
                            for ( Iterator itr = AppManager.VsqFile.Track[AppManager.Selected].getEventIterator(); itr.hasNext(); ) {
                                VsqEvent ev = (VsqEvent)itr.next();
                                if ( start <= ev.Clock && ev.Clock <= end ) {
                                    if ( !add_required.Contains( ev.InternalID ) ) {
                                        add_required.Add( ev.InternalID );
                                    }
                                }
                            }
                            if ( !add_required.Contains( item.InternalID ) ) {
                                add_required.Add( item.InternalID );
                            }
                            AppManager.AddSelectedEventRange( add_required.ToArray() );
                        } else if ( (modefier & s_modifier_key) == s_modifier_key ) {
                            // CTRLキーを押しながら選択／選択解除
                            if ( AppManager.SelectedEvent.ContainsKey( AppManager.Selected, item.InternalID ) ) {
                                AppManager.RemoveSelectedEvent( item.InternalID );
                            } else {
                                AppManager.AddSelectedEvent( item.InternalID );
                            }
                        } else {
                            if ( !AppManager.SelectedEvent.ContainsKey( AppManager.Selected, item.InternalID ) ) {
                                // MouseDownしたアイテムが、まだ選択されていなかった場合。当該アイテム単独に選択しなおす
                                AppManager.ClearSelectedEvent();
                            }
                            AppManager.AddSelectedEvent( item.InternalID );
                        }
                        this.Cursor = Cursors.Hand;
#if DEBUG
                        AppManager.DebugWriteLine( "    EditMode=" + AppManager.EditMode );
                        AppManager.DebugWriteLine( "    m_config.SelectedEvent.Count=" + AppManager.SelectedEvent.Count );
#endif
                    }
                }
                #endregion
            }
            RefreshScreen();
        }

        private void pictPianoRoll_MouseMove( object sender, MouseEventArgs e ) {
            if ( !m_mouse_moved && AppManager.EditMode == EditMode.MiddleDrag ) {
                this.Cursor = HAND;
            }
            m_mouse_moved = true;
            if ( !(AppManager.EditMode == EditMode.MiddleDrag) && AppManager.Playing ) {
                return;
            }

            if ( AppManager.EditMode == EditMode.MoveEntryWaitMove ) {
                int x = e.X + AppManager.StartToDrawX;
                int y = e.Y + StartToDrawY;
                if ( m_mouse_move_init.X != x || m_mouse_move_init.Y != y ) {
                    AppManager.EditMode = EditMode.MoveEntry;
                }
            }

#if PROPRETY_WINDOW
            // message passing
            foreach ( ContextProperty cp in m_property_windows[AppManager.Selected - 1].Values ) {
                if ( cp.MouseMove( pictPianoRoll, e ) ) {
                    RefreshScreen();
                    return;
                }
            }
#endif

            if ( m_mouse_hover_thread != null ) {
                m_mouse_hover_thread.Abort();
            }

            int clock = ClockFromXCoord( e.X );
            if ( m_mouse_downed ) {
                if ( m_ext_dragx == ExtDragXMode.None ) {
                    if ( AppManager._KEY_LENGTH > e.X ) {
                        m_ext_dragx = ExtDragXMode.Left;
                    } else if ( pictPianoRoll.Width < e.X ) {
                        m_ext_dragx = ExtDragXMode.Right;
                    }
                } else {
                    if ( AppManager._KEY_LENGTH <= e.X && e.X <= pictPianoRoll.Width ) {
                        m_ext_dragx = ExtDragXMode.None;
                    }
                }

                if ( m_ext_dragy == ExtDragYMode.None ) {
                    if ( 0 > e.Y ) {
                        m_ext_dragy = ExtDragYMode.Up;
                    } else if ( pictPianoRoll.Height < e.Y ) {
                        m_ext_dragy = ExtDragYMode.Down;
                    }
                } else {
                    if ( 0 <= e.Y && e.Y <= pictPianoRoll.Height ) {
                        m_ext_dragy = ExtDragYMode.None;
                    }
                }
            } else {
                m_ext_dragx = ExtDragXMode.None;
                m_ext_dragy = ExtDragYMode.None;
            }

            if ( m_ext_dragx == ExtDragXMode.Right || m_ext_dragx == ExtDragXMode.Left ) {
                DateTime now = DateTime.Now;
                double dt = now.Subtract( m_timer_drag_last_ignitted ).TotalSeconds;
                m_timer_drag_last_ignitted = now;
                int px_move = AppManager.EditorConfig.MouseDragIncrement;
                if ( px_move / dt > AppManager.EditorConfig.MouseDragMaximumRate ) {
                    px_move = (int)(dt * AppManager.EditorConfig.MouseDragMaximumRate);
                }
                double d_draft;
                if ( m_ext_dragx == ExtDragXMode.Right ) {
                    int right_clock = ClockFromXCoord( pictPianoRoll.Width );
                    int dclock = (int)(px_move / AppManager.ScaleX);
                    d_draft = (73 - pictPianoRoll.Width) / AppManager.ScaleX + right_clock + dclock;
                } else {
                    px_move *= -1;
                    int left_clock = ClockFromXCoord( AppManager._KEY_LENGTH );
                    int dclock = (int)(px_move / AppManager.ScaleX);
                    d_draft = (73 - AppManager._KEY_LENGTH) / AppManager.ScaleX + left_clock + dclock;
                }
                if ( d_draft < 0.0 ) {
                    d_draft = 0.0;
                }
                int draft = (int)d_draft;
                if ( hScroll.Maximum < draft ) {
                    if ( AppManager.EditMode == EditMode.AddEntry || AppManager.EditMode == EditMode.MoveEntry || AppManager.EditMode == EditMode.AddFixedLengthEntry ) {
                        hScroll.Maximum = draft;
                    } else {
                        draft = hScroll.Maximum;
                    }
                }
                if ( draft < hScroll.Minimum ) {
                    draft = hScroll.Minimum;
                }
                hScroll.Value = draft;
            }
            if ( m_ext_dragy == ExtDragYMode.Up || m_ext_dragy == ExtDragYMode.Down ) {
                DateTime now = DateTime.Now;
                double dt = now.Subtract( m_timer_drag_last_ignitted ).TotalSeconds;
                m_timer_drag_last_ignitted = now;
                int px_move = AppManager.EditorConfig.MouseDragIncrement;
                if ( px_move / dt > AppManager.EditorConfig.MouseDragMaximumRate ) {
                    px_move = (int)(dt * AppManager.EditorConfig.MouseDragMaximumRate);
                }
                if ( m_ext_dragy == ExtDragYMode.Up ) {
                    px_move *= -1;
                }
                int draft_stdy = StartToDrawY + px_move;
                int draft = (int)((draft_stdy * (double)vScroll.Maximum) / (128.0 * AppManager.EditorConfig.PxTrackHeight - vScroll.Height));
                if ( draft < 0 ) {
                    draft = 0;
                }
                int df = (int)draft;
                if ( df < vScroll.Minimum ) {
                    df = vScroll.Minimum;
                } else if ( vScroll.Maximum < df ) {
                    df = vScroll.Maximum;
                }
                vScroll.Value = df;
            }

            // 選択範囲にあるイベントを選択．
            //int stdx = AppManager.StartToDrawX;
            int stdy = StartToDrawY;
            if ( m_pointer_downed ) {
                if ( AppManager.SelectedRegionEnabled ) {
                    int x = e.X + AppManager.StartToDrawX;
                    if ( AppManager.EditorConfig.CurveSelectingQuantized ) {
                        int clock1 = ClockFromXCoord( e.X );
                        int unit = AppManager.GetPositionQuantizeClock();
                        int odd = clock1 % unit;
                        int nclock = clock1;
                        nclock -= odd;
                        if ( odd > unit / 2 ) {
                            nclock += unit;
                        }
                        x = XCoordFromClocks( nclock ) + AppManager.StartToDrawX;
                    }
                    AppManager.SelectedRegion.SetEnd( x );
                } else {
                    Point mouse = new Point( e.X + AppManager.StartToDrawX, e.Y + StartToDrawY );
                    int tx, ty, twidth, theight;
                    int lx = m_pointer_mouse_down.X;
                    if ( lx < mouse.X ) {
                        tx = lx;
                        twidth = mouse.X - lx;
                    } else {
                        tx = mouse.X;
                        twidth = lx - mouse.X;
                    }
                    int ly = m_pointer_mouse_down.Y;
                    if ( ly < mouse.Y ) {
                        ty = ly;
                        theight = mouse.Y - ly;
                    } else {
                        ty = mouse.Y;
                        theight = ly - mouse.Y;
                    }

                    Rectangle rect = new Rectangle( tx, ty, twidth, theight );
                    List<int> add_required = new List<int>();
                    int internal_id = -1;
#if USE_DOBJ
                    foreach ( DrawObject dobj in m_draw_objects[AppManager.Selected - 1] ) {
                        int x0 = dobj.pxRectangle.X;
                        int x1 = dobj.pxRectangle.X + dobj.pxRectangle.Width;
                        int y0 = dobj.pxRectangle.Y;
                        int y1 = dobj.pxRectangle.Y + dobj.pxRectangle.Height;
                        internal_id = dobj.InternalID;
#else
                    //int stdy = StartToDrawY;
                    for ( Iterator itr = AppManager.VsqFile.getTrack( AppManager.Selected ).getNoteEventIterator(); itr.hasNext(); ){
                        VsqEvent evnt = (VsqEvent)itr.next();
                        int x0 = XCoordFromClocks( evnt.Clock );
                        int x1 = XCoordFromClocks( evnt.Clock + evnt.ID.Length );
                        int y0 = YCoordFromNote( evnt.ID.Note, stdy );
                        int y1 = y0 + AppManager.EditorConfig.PxTrackHeight;
                        internal_id = evnt.InternalID;
#endif
                        if ( x1 < tx ) {
                            continue;
                        }
                        if ( tx + twidth < x0 ) {
                            break;
                        }
                        bool found = IsInRect( new Point( x0, y0 ), rect ) | IsInRect( new Point( x0, y1 ), rect ) | IsInRect( new Point( x1, y0 ), rect ) | IsInRect( new Point( x1, y1 ), rect );
                        if ( found ) {
                           // AppManager.AddSelectedEvent( internal_id );
                            add_required.Add( internal_id );
                        } else {
                            if ( x0 <= tx && tx + twidth <= x1 ) {
                                if ( ty < y0 ) {
                                    if ( y0 <= ty + theight ) {
                                        //AppManager.AddSelectedEvent( internal_id );
                                        add_required.Add( internal_id );
                                    }
                                } else if ( y0 <= ty && ty < y1 ) {
                                    //AppManager.AddSelectedEvent( internal_id );
                                    add_required.Add( internal_id );
                                }
                            } else if ( y0 <= ty && ty + theight <= y1 ) {
                                if ( tx < x0 ) {
                                    if ( x0 <= tx + twidth ) {
                                        //AppManager.AddSelectedEvent( internal_id );
                                        add_required.Add( internal_id );
                                    }
                                } else if ( x0 <= tx && tx < x1 ) {
                                    //AppManager.AddSelectedEvent( internal_id );
                                    add_required.Add( internal_id );
                                }
                            }
                        }
                    }
                    List<int> remove_required = new List<int>();
                    foreach ( SelectedEventEntry selected in AppManager.SelectedEvent.GetEnumerator() ) {
                        if ( !add_required.Contains( selected.Original.InternalID ) ) {
                            remove_required.Add( selected.Original.InternalID );
                            //AppManager.RemoveSelectedEventSilent( selected.Original.InternalID );
                            //break;
                        }
                    }
                    if ( remove_required.Count > 0 ) {
                        AppManager.RemoveSelectedEventRange( remove_required.ToArray() );
                    }
                    for ( Iterator itr = new ListIterator<int>( add_required ); itr.hasNext(); ) {
                        int id = (int)itr.next();
                        if ( AppManager.SelectedEvent.ContainsKey( AppManager.Selected, id ) ) {
                            itr.remove();
                        }
                    }
                    AppManager.AddSelectedEventRange( add_required.ToArray() );

                    /*foreach ( int id in add_required ) {
                        if ( !AppManager.SelectedEvent.ContainsKey( AppManager.Selected, id ) ) {
                            AppManager.AddSelectedEvent( id );
                        }
                    }*/
                }
            }

            if ( AppManager.EditMode == EditMode.MiddleDrag ) {
                #region MiddleDrag
                int dx = e.X - m_button_initial.X;
                int dy = e.Y - m_button_initial.Y;
                double new_vscroll_value = (double)m_middle_button_vscroll - dy * (double)vScroll.Maximum / (128.0 * AppManager.EditorConfig.PxTrackHeight - (double)vScroll.Height);
                double new_hscroll_value = (double)m_middle_button_hscroll - (double)dx / AppManager.ScaleX;
                if ( new_vscroll_value < vScroll.Minimum ) {
                    vScroll.Value = vScroll.Minimum;
                } else if ( vScroll.Maximum < new_vscroll_value ) {
                    vScroll.Value = vScroll.Maximum;
                } else {
                    vScroll.Value = (int)new_vscroll_value;
                }
                if ( new_hscroll_value < hScroll.Minimum ) {
                    hScroll.Value = hScroll.Minimum;
                } else if ( hScroll.Maximum < new_hscroll_value ) {
                    hScroll.Value = hScroll.Maximum;
                } else {
                    hScroll.Value = (int)new_hscroll_value;
                }
                if ( AppManager.Playing ) {
                    return;
                }
                #endregion
                return;
            } else if ( AppManager.EditMode == EditMode.AddEntry ) {
                #region AddEntry
                int unit = AppManager.GetLengthQuantizeClock();
                int length = clock - m_adding.Clock;
                int odd = length % unit;
                int new_length = length - odd;

                if ( unit * AppManager.ScaleX > 10 ) { //これをしないと、グリッド2個分増えることがある
                    int next_clock = ClockFromXCoord( e.X + 10 );
                    int next_length = next_clock - m_adding.Clock;
                    int next_new_length = next_length - (next_length % unit);
                    if ( next_new_length == new_length + unit ) {
                        new_length = next_new_length;
                    }
                }

                if ( new_length <= 0 ) {
                    new_length = 0;
                }
                m_adding.ID.Length = new_length;
                #endregion
            } else if ( AppManager.EditMode == EditMode.MoveEntry ) {
                #region MoveEntry
                if ( AppManager.SelectedEvent.Count > 0 ) {
                    VsqEvent original = AppManager.SelectedEvent.LastSelected.Original;
                    int note = NoteFromYCoord( e.Y );                           // 現在のマウス位置でのnote
                    int note_init = original.ID.Note;
                    int dnote = note - note_init;

                    int tclock = ClockFromXCoord( e.X - m_mouse_move_offset );
                    int clock_init = original.Clock;

                    int dclock = tclock - clock_init;

                    if ( AppManager.EditorConfig.PositionQuantize != QuantizeMode.off ) {
                        int unit = AppManager.GetPositionQuantizeClock();
                        int new_clock = original.Clock + dclock;
                        int odd = new_clock % unit;
                        new_clock -= odd;
                        if ( odd > unit / 2 ) {
                            new_clock += unit;
                        }
                        dclock = new_clock - clock_init;
                    }

                    foreach ( SelectedEventEntry item in AppManager.SelectedEvent.GetEnumerator() ) {
                        int new_clock = item.Original.Clock + dclock;
                        /*int odd = new_clock % unit;
                        new_clock -= odd;
                        if ( odd > unit / 2 ) {
                            new_clock += unit;
                        }*/
                        int new_note = item.Original.ID.Note + dnote;
                        item.Editing.Clock = new_clock;
                        item.Editing.ID.Note = new_note;
                    }
                }
                #endregion
            } else if ( AppManager.EditMode == EditMode.EditLeftEdge ) {
                #region EditLeftEdge
                int unit = AppManager.GetLengthQuantizeClock();
                VsqEvent original = AppManager.SelectedEvent.LastSelected.Original;
                int clock_init = original.Clock;
                int dclock = clock - clock_init;
                foreach ( SelectedEventEntry item in AppManager.SelectedEvent.GetEnumerator() ) {
                    int end_clock = item.Original.Clock + item.Original.ID.Length;
                    int new_clock = item.Original.Clock + dclock;
                    int length = end_clock - new_clock;
                    int odd = length % unit;
                    int new_length = length - odd;
                    if ( odd > unit / 2 ) {
                        new_length += unit;
                    }
                    if ( new_length <= 0 ) {
                        new_length = unit;
                    }
                    item.Editing.Clock = end_clock - new_length;
                    item.Editing.ID.Length = new_length;
                }
                #endregion
            } else if ( AppManager.EditMode == EditMode.EditRightEdge ) {
                #region EditRightEdge
                int unit = AppManager.GetLengthQuantizeClock();

                VsqEvent original = AppManager.SelectedEvent.LastSelected.Original;
                int dlength = clock - (original.Clock + original.ID.Length);
                foreach ( SelectedEventEntry item in AppManager.SelectedEvent.GetEnumerator() ) {
                    int length = item.Original.ID.Length + dlength;
                    int odd = length % unit;
                    int new_length = length - odd;
                    if ( odd > unit / 2 ) {
                        new_length += unit;
                    }
                    if ( new_length <= 0 ) {
                        new_length = unit;
                    }
                    item.Editing.ID.Length = new_length;
                }
                #endregion
            } else if ( AppManager.EditMode == EditMode.AddFixedLengthEntry ) {
                #region AddFixedLengthEntry
                int note = NoteFromYCoord( e.Y );
                int unit = AppManager.GetPositionQuantizeClock();
                int new_clock = ClockFromXCoord( e.X );
                int odd = new_clock % unit;
                new_clock -= odd;
                if ( odd > unit / 2 ) {
                    new_clock += unit;
                }
                m_adding.ID.Note = note;
                m_adding.Clock = new_clock;
                #endregion
            } else if ( AppManager.EditMode == EditMode.EditVibratoDelay ) {
                #region EditVibratoDelay
                int new_vibrato_start = clock;
                int old_vibrato_end = m_adding.Clock + m_adding.ID.Length;
                int new_vibrato_length = old_vibrato_end - new_vibrato_start;
                int max_length = (int)(m_adding_length - _PX_ACCENT_HEADER / AppManager.ScaleX);
                if ( max_length < 0 ) {
                    max_length = 0;
                }
                if ( new_vibrato_length > max_length ) {
                    new_vibrato_start = old_vibrato_end - max_length;
                    new_vibrato_length = max_length;
                }
                if ( new_vibrato_length < 0 ) {
                    new_vibrato_start = old_vibrato_end;
                    new_vibrato_length = 0;
                }
                m_adding.Clock = new_vibrato_start;
                m_adding.ID.Length = new_vibrato_length;
                UpdatePositionViewFromMousePosition( clock );
                if ( !timer.Enabled ) {
                    RefreshScreen();
                }
                #endregion
                return;
            }
            UpdatePositionViewFromMousePosition( clock );

            // カーソルの形を決める
            if ( !m_mouse_downed ) {
                bool split_cursor = false;
                bool hand_cursor = false;
                int stdx = AppManager.StartToDrawX;
#if USE_DOBJ
                foreach ( DrawObject dobj in m_draw_objects[AppManager.Selected - 1] ) {
                    // 音符左側の編集領域
#else
                for ( Iterator itr = AppManager.VsqFile.getTrack( AppManager.Selected ).getNoteEventIterator(); itr.hasNext(); ){

#endif
                    Rectangle rc = new Rectangle(
                                        dobj.pxRectangle.X - stdx,
                                        dobj.pxRectangle.Y - stdy,
                                        _EDIT_HANDLE_WIDTH,
                                        AppManager.EditorConfig.PxTrackHeight );
                    if ( IsInRect( e.Location, rc ) ) {
                        split_cursor = true;
                        break;
                    }

                    // 音符右側の編集領域
                    rc = new Rectangle( dobj.pxRectangle.X + dobj.pxRectangle.Width - stdx - _EDIT_HANDLE_WIDTH,
                                        dobj.pxRectangle.Y - stdy,
                                        _EDIT_HANDLE_WIDTH,
                                        AppManager.EditorConfig.PxTrackHeight );
                    if ( IsInRect( e.Location, rc ) ) {
                        split_cursor = true;
                        break;
                    }

                    // 音符本体
                    rc = new Rectangle( dobj.pxRectangle.X - stdx,
                                        dobj.pxRectangle.Y - stdy,
                                        dobj.pxRectangle.Width,
                                        dobj.pxRectangle.Height );
                    if ( AppManager.EditorConfig.ShowExpLine && !dobj.Overwrapped ) {
                        rc.Height *= 2;
                        if ( IsInRect( e.Location, rc ) ) {
                            // ビブラートの開始位置
                            rc = new Rectangle( dobj.pxRectangle.X + dobj.pxVibratoDelay - stdx - _EDIT_HANDLE_WIDTH / 2,
                                                dobj.pxRectangle.Y + AppManager.EditorConfig.PxTrackHeight - stdy,
                                                _EDIT_HANDLE_WIDTH,
                                                AppManager.EditorConfig.PxTrackHeight );
                            if ( IsInRect( e.Location, rc ) ) {
                                split_cursor = true;
                                break;
                            } else {
                                hand_cursor = true;
                                break;
                            }
                        }
                    } else {
                        if ( IsInRect( e.Location, rc ) ) {
                            hand_cursor = true;
                            break;
                        }
                    }
                }

                if ( split_cursor ) {
                    this.Cursor = Cursors.VSplit;
                } else if ( hand_cursor ) {
                    this.Cursor = Cursors.Hand;
                } else {
                    this.Cursor = Cursors.Default;
                }
            }
            if ( !timer.Enabled ) {
                RefreshScreen();
            }
        }

        private void pictPianoRoll_MouseUp( object sender, MouseEventArgs e ) {
#if DEBUG
            AppManager.DebugWriteLine( "pictureBox1_MouseUp" );
            AppManager.DebugWriteLine( "    m_config.EditMode=" + AppManager.EditMode );
#endif
            m_pointer_downed = false;
            m_mouse_downed = false;

#if PROPRETY_WINDOW
            // message passing
            foreach ( ContextProperty cp in m_property_windows[AppManager.Selected - 1].Values ) {
                if ( cp.MouseUp( pictPianoRoll, e ) ) {
                    RefreshScreen();
                    return;
                }
            }
#endif

            Keys modefier = Control.ModifierKeys;
            if ( AppManager.EditMode == EditMode.MiddleDrag ) {
                this.Cursor = Cursors.Default;
            } else if ( AppManager.EditMode == EditMode.AddEntry || AppManager.EditMode == EditMode.AddFixedLengthEntry ) {
                #region AddEntry || AddFixedLengthEntry
                if ( AppManager.Selected >= 0 ) {
                    if ( (AppManager.EditMode == EditMode.AddFixedLengthEntry) ||
                         (AppManager.EditMode == EditMode.AddEntry && (m_button_initial.X != e.X || m_button_initial.Y != e.Y) && m_adding.ID.Length > 0) ) {
                        LyricHandle lyric = new LyricHandle( "a", "a" );
                        VibratoHandle vibrato = null;
                        int vibrato_delay = 0;
                        if ( AppManager.EditorConfig.EnableAutoVibrato ) {
                            int note_length = m_adding.ID.Length;
                            // 音符位置での拍子を調べる
                            int denom, numer;
                            AppManager.VsqFile.getTimesigAt( m_adding.Clock, out numer, out denom );

                            // ビブラートを自動追加するかどうかを決める閾値
                            int threshold = 480 * 4 / denom * (int)AppManager.EditorConfig.AutoVibratoMinimumLength;
                            if ( note_length >= threshold ) {
                                int vibrato_clocks = 0;
                                switch ( AppManager.EditorConfig.DefaultVibratoLength ) {
                                    case DefaultVibratoLength.L100:
                                        vibrato_clocks = note_length;
                                        break;
                                    case DefaultVibratoLength.L50:
                                        vibrato_clocks = note_length / 2;
                                        break;
                                    case DefaultVibratoLength.L66:
                                        vibrato_clocks = note_length * 2 / 3;
                                        break;
                                    case DefaultVibratoLength.L75:
                                        vibrato_clocks = note_length * 3 / 4;
                                        break;
                                }
                                vibrato = VibratoTypeUtil.getDefaultVibratoHandle( AppManager.EditorConfig.AutoVibratoType, vibrato_clocks );
                                vibrato_delay = note_length - vibrato_clocks;
                            }
                        }

                        // 自動ノーマライズのモードで、処理を分岐
                        if ( AppManager.AutoNormalize ) {
                            VsqTrack work = (VsqTrack)AppManager.VsqFile.Track[AppManager.Selected].Clone();
                            m_adding.ID.type = VsqIDType.Anote;
                            m_adding.ID.Dynamics = 64;
                            m_adding.ID.VibratoHandle = vibrato;
                            m_adding.ID.LyricHandle = lyric;
                            m_adding.ID.VibratoDelay = vibrato_delay;
                            //m_adding.InternalID = work.GetNextId( 0 );
                            bool changed = true;
                            while ( changed ) {
                                changed = false;
                                for ( int i = 0; i < work.getEventCount(); i++ ) {
                                    int start_clock = work.getEvent( i ).Clock;
                                    int end_clock = work.getEvent( i ).ID.Length + start_clock;
                                    if ( start_clock < m_adding.Clock && m_adding.Clock < end_clock ) {
                                        work.getEvent( i ).ID.Length = m_adding.Clock - start_clock;
                                        changed = true;
                                    } else if ( start_clock == m_adding.Clock ) {
                                        work.removeEvent( i );
                                        changed = true;
                                        break;
                                    } else if ( m_adding.Clock < start_clock && start_clock < m_adding.Clock + m_adding.ID.Length ) {
                                        m_adding.ID.Length = start_clock - m_adding.Clock;
                                        changed = true;
                                    }
                                }
                            }
                            work.addEvent( (VsqEvent)m_adding.Clone() );
                            CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( AppManager.Selected, 
                                                                                         work,
                                                                                         AppManager.VsqFile.AttachedCurves[AppManager.Selected - 1], 
                                                                                         AppManager.VsqFile.getPitchCurve( AppManager.Selected ) );
                            AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                            Edited = true;
                        } else {
                            VsqEvent[] items = new VsqEvent[1];
                            m_adding.ID.type = VsqIDType.Anote;
                            m_adding.ID.Dynamics = 64;
                            items[0] = new VsqEvent( 0, m_adding.ID );
                            items[0].Clock = m_adding.Clock;
                            items[0].ID.LyricHandle = lyric;
                            items[0].ID.VibratoDelay = vibrato_delay;
                            items[0].ID.VibratoHandle = vibrato;
#if DEBUG
                            AppManager.DebugWriteLine( "        items[0].ID.ToString()=" + items[0].ID.ToString() );
#endif
                            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventAddRange( AppManager.Selected, items ) );
                            AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                            Edited = true;
                        }
                    }
                }
                #endregion
            } else if ( AppManager.EditMode == EditMode.MoveEntry ) {
                #region MoveEntry
#if DEBUG
                AppManager.DebugWriteLine( "    m_config.SelectedEvent.Count=" + AppManager.SelectedEvent.Count );
#endif
                if ( AppManager.SelectedEvent.Count > 0 ) {
                    VsqEvent original = AppManager.SelectedEvent.LastSelected.Original;
                    if ( original.Clock != AppManager.SelectedEvent.LastSelected.Editing.Clock || original.ID.Note != AppManager.SelectedEvent.LastSelected.Editing.ID.Note ) {
                        int count = AppManager.SelectedEvent.Count;
                        int[] ids = new int[count];
                        int[] clocks = new int[count];
                        VsqID[] values = new VsqID[count];
                        int i = -1;
                        bool out_of_range = false;
                        foreach ( SelectedEventEntry ev in AppManager.SelectedEvent.GetEnumerator() ) {
                            i++;
                            ids[i] = ev.Original.InternalID;
                            clocks[i] = ev.Editing.Clock;
                            if ( clocks[i] < AppManager.VsqFile.getPreMeasureClocks() ) {
                                out_of_range = true;
                            }
                            values[i] = ev.Editing.ID;
                            if ( values[i].Note < 0 || 128 < values[i].Note ) {
                                out_of_range = true;
                            }
                        }
                        if ( !out_of_range ) {
                            CadenciiCommand run = new CadenciiCommand(
                                VsqCommand.generateCommandEventChangeClockAndIDContaintsRange( AppManager.Selected,
                                                                                     ids,
                                                                                     clocks,
                                                                                     values ) );
                            AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                            Edited = true;
                        } else {
                            SystemSounds.Asterisk.Play();
                        }
                    } else {
                        /*if ( (modefier & Keys.Shift) == Keys.Shift || (modefier & Keys.Control) == Keys.Control ) {
                            Rectangle rc;
                            VsqEvent select = IdOfClickedPosition( e.Location, out rc );
                            if ( select != null ) {
                                m_config.addSelectedEvent( item.InternalID );
                            }
                        }*/
                    }
                    lock ( m_draw_objects ) {
                        m_draw_objects[AppManager.Selected - 1].Sort();
                    }
                }
                #endregion
            } else if ( AppManager.EditMode == EditMode.EditLeftEdge ) {
                #region EditLeftEdge
                VsqEvent original = AppManager.SelectedEvent.LastSelected.Original;
                if ( original.Clock != AppManager.SelectedEvent.LastSelected.Editing.Clock ||
                    original.ID.Length != original.ID.Length ) {
                    int count = AppManager.SelectedEvent.Count;
                    int[] ids = new int[count];
                    int[] clocks = new int[count];
                    VsqID[] values = new VsqID[count];
                    int i = -1;
                    foreach ( SelectedEventEntry ev in AppManager.SelectedEvent.GetEnumerator() ) {
                        i++;
                        if ( ev.Editing.ID.VibratoHandle == null ) {
                            ids[i] = ev.Original.InternalID;
                            clocks[i] = ev.Editing.Clock;
                            values[i] = ev.Editing.ID;
                        } else {
                            int draft_vibrato_length = ev.Editing.ID.Length - ev.Editing.ID.VibratoDelay;
                            if ( draft_vibrato_length <= 0 ) {
                                // ビブラートを削除
                                ev.Editing.ID.VibratoHandle = null;
                                ev.Editing.ID.VibratoDelay = 0;
                            } else {
                                // ビブラートは温存
                                ev.Editing.ID.VibratoHandle.Length = draft_vibrato_length;
                            }
                            ids[i] = ev.Original.InternalID;
                            clocks[i] = ev.Editing.Clock;
                            values[i] = ev.Editing.ID;
                        }
                    }
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventChangeClockAndIDContaintsRange( AppManager.Selected,
                                                                             ids,
                                                                             clocks,
                                                                             values ) );
                    AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                    Edited = true;
                }
                #endregion
            } else if ( AppManager.EditMode == EditMode.EditRightEdge ) {
                #region EditRightEdge
                VsqEvent original = AppManager.SelectedEvent.LastSelected.Original;
                if ( original.ID.Length != AppManager.SelectedEvent.LastSelected.Editing.ID.Length ) {
                    int count = AppManager.SelectedEvent.Count;
                    int[] ids = new int[count];
                    int[] clocks = new int[count];
                    VsqID[] values = new VsqID[count];
                    int i = -1;
                    foreach ( SelectedEventEntry ev in AppManager.SelectedEvent.GetEnumerator() ) {
                        i++;
                        if ( ev.Editing.ID.VibratoHandle == null ) {
                            ids[i] = ev.Original.InternalID;
                            clocks[i] = ev.Editing.Clock;
                            values[i] = ev.Editing.ID;
                        } else {
                            int draft_vibrato_length = ev.Editing.ID.Length - ev.Editing.ID.VibratoDelay;
                            if ( draft_vibrato_length <= 0 ) {
                                // ビブラートを削除
                                ev.Editing.ID.VibratoHandle = null;
                                ev.Editing.ID.VibratoDelay = 0;
                            } else {
                                // ビブラートは温存
                                ev.Editing.ID.VibratoHandle.Length = draft_vibrato_length;
                            }
                            ids[i] = ev.Original.InternalID;
                            clocks[i] = ev.Editing.Clock;
                            values[i] = ev.Editing.ID;
                        }
                    }
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventChangeClockAndIDContaintsRange( AppManager.Selected,
                                                                             ids,
                                                                             clocks,
                                                                             values ) );
                    AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                    Edited = true;
                }
                #endregion
            } else if ( AppManager.EditMode == EditMode.EditVibratoDelay ) {
                #region EditVibratoDelay
                if ( m_mouse_moved ) {
                    double max_length = m_adding_length - _PX_ACCENT_HEADER / AppManager.ScaleX;
                    double rate = m_adding.ID.Length / max_length;
                    if ( rate > 0.99 ) {
                        rate = 1.0;
                    }
                    int vibrato_length = (int)(m_adding_length * rate);
                    VsqEvent item = null;
                    for ( Iterator itr = AppManager.VsqFile.Track[AppManager.Selected].getNoteEventIterator(); itr.hasNext(); ) {
                        VsqEvent ve = (VsqEvent)itr.next();
                        if ( ve.InternalID == m_vibrato_editing_id ) {
                            item = (VsqEvent)ve.Clone();
                            break;
                        }
                    }
                    if ( item != null ) {
                        if ( vibrato_length <= 0 ) {
                            item.ID.VibratoHandle = null;
                            item.ID.VibratoDelay = item.ID.Length;
                        } else {
                            item.ID.VibratoHandle.Length = vibrato_length;
                            item.ID.VibratoDelay = item.ID.Length - vibrato_length;
                        }
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandEventChangeIDContaints( AppManager.Selected, m_vibrato_editing_id, item.ID ) );
                        AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                        Edited = true;
                    }
                }
                #endregion
            } else if ( AppManager.SelectedRegionEnabled ) {
                int stdx = AppManager.StartToDrawX;
                int start = ClockFromXCoord( AppManager.SelectedRegion.Start - stdx );
                int end = ClockFromXCoord( AppManager.SelectedRegion.End - stdx );
                AppManager.ClearSelectedEvent();
                List<int> add_required = new List<int>();
                for ( Iterator itr = AppManager.VsqFile.Track[AppManager.Selected].getEventIterator(); itr.hasNext(); ) {
                    VsqEvent ve = (VsqEvent)itr.next();
                    if ( start <= ve.Clock && ve.Clock <= end ) {
                        add_required.Add( ve.InternalID );
                    }
                }
                AppManager.AddSelectedEventRange( add_required.ToArray() );
            }
            RefreshScreen();
            if ( AppManager.EditMode != EditMode.Realtime ) {
                AppManager.EditMode = EditMode.None;
            }
        }

        private void pictPianoRoll_MouseWheel( object sender, MouseEventArgs e ) {
            bool horizontal = (Control.ModifierKeys & Keys.Shift) == Keys.Shift;
            if( AppManager.EditorConfig.ScrollHorizontalOnWheel ){
                horizontal = !horizontal;
            }
            if ( horizontal ) {
                hScroll.Value = NewHScrollValueFromWheelDelta( e.Delta );
            } else {
                double new_val = (double)vScroll.Value - e.Delta;
                if ( new_val > vScroll.Maximum ) {
                    vScroll.Value = vScroll.Maximum;
                } else if ( new_val < vScroll.Minimum ) {
                    vScroll.Value = vScroll.Minimum;
                } else {
                    vScroll.Value = (int)new_val;
                }
            }
            RefreshScreen();
        }

        private void pictPianoRoll_Paint( object sender, PaintEventArgs e ) {
            DrawTo( e.Graphics, pictPianoRoll.Size, pictPianoRoll.PointToClient( Control.MousePosition ) );

            // マーカー
            int marker_x = (int)(AppManager.CurrentClock * AppManager.ScaleX + 6 + AppManager._KEY_LENGTH - AppManager.StartToDrawX);
            if ( AppManager._KEY_LENGTH <= marker_x && marker_x <= pictPianoRoll.Width ) {
                e.Graphics.DrawLine( new Pen( Color.White, 2f ),
                                     new Point( marker_x, 0 ),
                                     new Point( marker_x, pictPianoRoll.Height ) );
            }


            DateTime dnow = DateTime.Now;
            for ( int i = 0; i < _NUM_PCOUNTER - 1; i++ ) {
                m_performance[i] = m_performance[i + 1];
            }
            m_performance[_NUM_PCOUNTER - 1] = (float)dnow.Subtract( m_last_ignitted ).TotalSeconds;
            m_last_ignitted = dnow;
            float sum = 0f;
            for ( int i = 0; i < _NUM_PCOUNTER; i++ ) {
                sum += m_performance[i];
            }
            m_fps = _NUM_PCOUNTER / sum;

            if ( AppManager.SelectedRegionEnabled ) {
                int stdx = AppManager.StartToDrawX;
                int start = AppManager.SelectedRegion.Start - stdx;
                int end = AppManager.SelectedRegion.End - stdx;
                e.Graphics.FillRectangle(
                    s_brs_a098_000_000_000,
                    new Rectangle( start, 0, end - start, pictPianoRoll.Height ) );
            } else if ( m_pointer_downed ) {
                Point mouse = pictPianoRoll.PointToClient( Control.MousePosition );
                int tx, ty, twidth, theight;
                int lx = m_pointer_mouse_down.X - AppManager.StartToDrawX;
                if ( lx < mouse.X ) {
                    tx = lx;
                    twidth = mouse.X - lx;
                } else {
                    tx = mouse.X;
                    twidth = lx - mouse.X;
                }
                int ly = m_pointer_mouse_down.Y - StartToDrawY;
                if ( ly < mouse.Y ) {
                    ty = ly;
                    theight = mouse.Y - ly;
                } else {
                    ty = mouse.Y;
                    theight = ly - mouse.Y;
                }
                if ( tx < AppManager._KEY_LENGTH ) {
                    int txold = tx;
                    tx = AppManager._KEY_LENGTH;
                    twidth -= (tx - txold);
                }
                Rectangle rc = new Rectangle( tx, ty, twidth, theight );
                Pen pen = new Pen( Color.FromArgb( 200, Color.Black ) );
                pen.LineJoin = System.Drawing.Drawing2D.LineJoin.Round;
                e.Graphics.FillRectangle( new SolidBrush( Color.FromArgb( 100, Color.Black ) ), rc );
                e.Graphics.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
                e.Graphics.DrawRectangle( pen, rc );
            }
#if MONITOR_FPS
            e.Graphics.DrawString(
                m_fps.ToString( "000.000" ),
                new Font( "Verdana", 40, FontStyle.Bold ),
                Brushes.Red,
                new PointF( 0, 0 ) );
#endif
        }

        private void pictPianoRoll_PreviewKeyDown( object sender, PreviewKeyDownEventArgs e ) {
#if DEBUG
            System.Diagnostics.Debug.WriteLine( "pictureBox1_PreviewKeyDown" );
            System.Diagnostics.Debug.WriteLine( "    e.KeyCode=" + e.KeyCode );
#endif
            if ( e.KeyCode == Keys.Tab && AppManager.SelectedEvent.Count > 0 ) {
                VsqEvent original = AppManager.SelectedEvent.LastSelected.Original;
                if ( original == null ) {
                    return;
                }
                int x = XCoordFromClocks( original.Clock );
                int y = YCoordFromNote( original.ID.Note );
                if ( !AppManager.EditorConfig.KeepLyricInputMode ) {
                    m_last_symbol_edit_mode = false;
                }
                ShowInputTextBox( original.ID.LyricHandle.L0.Phrase, original.ID.LyricHandle.L0.getPhoneticSymbol(), new Point( x, y ), m_last_symbol_edit_mode );
                e.IsInputKey = true;
                RefreshScreen();
            }
            ProcessSpecialShortcutKey( e );
        }
        #endregion

        #region menuVisual*
        private void menuVisualMixer_Click( object sender, EventArgs e ) {
            menuVisualMixer.Checked = !menuVisualMixer.Checked;
            AppManager.EditorConfig.MixerVisible = menuVisualMixer.Checked;
            m_mixer_dlg.Visible = AppManager.EditorConfig.MixerVisible;
            this.Focus();
        }

        private void menuVisualGridline_CheckedChanged( object sender, EventArgs e ) {
            AppManager.GridVisible = menuVisualGridline.Checked;
            RefreshScreen();
        }

        private void menuVisualLyrics_CheckedChanged( object sender, EventArgs e ) {
            AppManager.EditorConfig.ShowLyric = menuVisualLyrics.Checked;
        }

        private void menuVisualNoteProperty_CheckedChanged( object sender, EventArgs e ) {
            AppManager.EditorConfig.ShowExpLine = menuVisualNoteProperty.Checked;
        }

        private void menuVisualPitchLine_CheckedChanged( object sender, EventArgs e ) {
            AppManager.EditorConfig.ViewAtcualPitch = menuVisualPitchLine.Checked;
        }

        private void menuVisualControlTrack_CheckedChanged( object sender, EventArgs e ) {
            trackSelector.CurveVisible = menuVisualControlTrack.Checked;
            if ( menuVisualControlTrack.Checked ) {
                splitContainer1.IsSplitterFixed = false;
                splitContainer1.SplitterDistance = splitContainer1.Height - trackSelector.PreferredMinSize - splitContainer1.SplitterWidth;
                splitContainer1.Panel2MinSize = trackSelector.PreferredMinSize;
            } else {
                splitContainer1.IsSplitterFixed = true;
                splitContainer1.Panel2MinSize = _SPL1_PANEL2_MIN_HEIGHT;
                splitContainer1.SplitterDistance = splitContainer1.Height - _SPL1_PANEL2_MIN_HEIGHT - splitContainer1.SplitterWidth;
            }
            RefreshScreen();
        }

        private void menuHiddenVisualForwardParameter_Click( object sender, EventArgs e ) {
            trackSelector.SelectNextCurve();
        }

        private void menuHiddenVisualBackwardParameter_Click( object sender, EventArgs e ) {
            trackSelector.SelectPreviousCurve();
        }

        private void menuVisualWaveform_CheckedChanged( object sender, EventArgs e ) {
            AppManager.EditorConfig.ViewWaveform = menuVisualWaveform.Checked;
            UpdateSplitContainer2Size();
        }

        private void menuVisualControlTrack_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Show/Hide control curves." );
        }

        private void menuVisualMixer_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Show/Hide mixer window." );
        }

        private void menuVisualWaveform_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Show/Hide waveform." );
        }

        private void menuVisualProperty_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Show/Hide property window." );
        }

        private void menuVisualGridline_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Show/Hide grid line." );
        }

        private void menuVisualStartMarker_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Enable/Disable start marker." );
        }

        private void menuVisualEndMarker_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Enable/Disable end marker." );
        }

        private void menuVisualLyrics_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Show/Hide lyrics." );
        }

        private void menuVisualNoteProperty_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Show/Hide expression lines." );
        }

        private void menuVisualPitchLine_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Show/Hide pitch bend lines." );
        }
        #endregion

        #region m_mixer_dlg
        private void m_mixer_dlg_SoloChanged( int track, bool solo ) {
#if DEBUG
            AppManager.DebugWriteLine( "m_mixer_dlg_SoloChanged" );
            AppManager.DebugWriteLine( "    track=" + track );
            AppManager.DebugWriteLine( "    solo=" + solo );
#endif
            if ( track > 0 ) {
                AppManager.VsqFile.Mixer.Slave[track - 1].Solo = solo ? 1 : 0;
            }
        }

        private void m_mixer_dlg_MuteChanged( int track, bool mute ) {
#if DEBUG
            AppManager.DebugWriteLine( "m_mixer_dlg_MuteChanged" );
            AppManager.DebugWriteLine( "    track=" + track );
            AppManager.DebugWriteLine( "    mute=" + mute );
#endif
            if ( track > 0 ) {
                AppManager.VsqFile.Mixer.Slave[track - 1].Mute = mute ? 1 : 0;
            } else {
                AppManager.VsqFile.Mixer.MasterMute = mute ? 1 : 0;
            }
        }

        private void m_mixer_dlg_PanpotChanged( int track, int panpot ) {
            if ( track > 0 ) {
                // slave
                AppManager.VsqFile.Mixer.Slave[track - 1].Panpot = panpot;
            } else {
                // master
                AppManager.VsqFile.Mixer.MasterPanpot = panpot;
            }
        }

        private void m_mixer_dlg_FederChanged( int track, int feder ) {
            if ( track > 0 ) {
                AppManager.VsqFile.Mixer.Slave[track - 1].Feder = feder;
            } else {
                AppManager.VsqFile.Mixer.MasterFeder = feder;
            }
        }

        private void m_mixer_dlg_TopMostChanged( bool arg ) {
            AppManager.EditorConfig.MixerTopMost = arg;
        }
        #endregion

        #region FormMain
        private void FormMain_FormClosed( object sender, FormClosedEventArgs e ) {
            ClearTempWave();
            string tempdir = AppManager.TempWaveDir;
            string log = Path.Combine( tempdir, "run.log" );
            bocoree.debug.close();
            try {
                if ( File.Exists( log ) ) {
                    File.Delete( log );
                }
                Directory.Delete( tempdir, true );
            } catch ( Exception ex ) {
            }
            VSTiProxy.AbortRendering();
            VSTiProxy.Terminate();
            MidiPlayer.Stop();
        }

        private void FormMain_FormClosing( object sender, FormClosingEventArgs e ) {
            if ( Edited ) {
                string file = AppManager.FileName;
                if ( file == "" ) {
                    file = "Untitled";
                } else {
                    file = Path.GetFileName( file );
                }
                DialogResult ret = MessageBox.Show( _( "Save this sequence?" ),
                                                    _( "Affirmation" ),
                                                    MessageBoxButtons.YesNoCancel,
                                                    MessageBoxIcon.Question );
                switch ( ret ) {
                    case DialogResult.Yes:
                        if ( AppManager.FileName == "" ) {
                            DialogResult dr = DialogResult.Cancel;
                            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Save ) ) {
                                    if ( saveXmlVsqDialog.FileName != "" ) {
                                        fd.FileName = saveXmlVsqDialog.FileName;
                                    }
                                    fd.Filter = saveXmlVsqDialog.Filter;
                                    dr = fd.ShowDialog();
                                    if ( dr == DialogResult.OK ) {
                                        saveXmlVsqDialog.FileName = fd.FileName;
                                    }
                                }
                            } else {
                                dr = saveXmlVsqDialog.ShowDialog();
                            }
                            if ( dr == DialogResult.OK ) {
                                AppManager.SaveTo( saveXmlVsqDialog.FileName );
                            } else {
                                e.Cancel = true;
                                return;
                            }
                        } else {
                            AppManager.SaveTo( AppManager.FileName );
                        }
                        break;
                    case DialogResult.Cancel:
                        e.Cancel = true;
                        return;
                }
            }
            AppManager.EditorConfig.WindowMaximized = (this.WindowState == FormWindowState.Maximized);
#if VER22
            if ( m_utau_voice_dialog != null && !m_utau_voice_dialog.IsDisposed ) {
                AppManager.EditorConfig.FormConfigUtauVoiceConfig = m_utau_voice_dialog.CurrentConfig;
            }
#endif
            AppManager.SaveConfig();
            RenderUtau.ClearCache();
            if ( m_midi_in != null ) {
                m_midi_in.Dispose();
            }
            bgWorkScreen.Dispose();
            e.Cancel = false;
        }

        private void FormMain_Load( object sender, EventArgs e ) {
            ApplyLanguage();
            trackBar.Value = AppManager.EditorConfig.DefaultXScale;
            AppManager.CurrentClock = 0;
            Edited = false;

            AppManager.PreviewStarted += new EventHandler( AppManager_PreviewStarted );
            AppManager.PreviewAborted += new EventHandler( AppManager_PreviewAborted );
            AppManager.GridVisibleChanged += new EventHandler( AppManager_GridVisibleChanged );
            AppManager.SelectedEventChanged += new BSimpleDelegate<bool>( AppManager_SelectedEventChanged );
            AppManager.CurrentClockChanged += new EventHandler( AppManager_CurrentClockChanged );
            AppManager.SelectedToolChanged += new EventHandler( AppManager_SelectedToolChanged );
            EditorConfig.QuantizeModeChanged += new EventHandler( EditorConfig_QuantizeModeChanged );

            UpdateRecentFileMenu();

            // C3が画面中央に来るように調整
            int draft_start_to_draw_y = AppManager._KEY_LENGTH * AppManager.EditorConfig.PxTrackHeight - pictPianoRoll.Height / 2;
            int draft_vscroll_value = (int)((draft_start_to_draw_y * (double)vScroll.Maximum) / (128 * AppManager.EditorConfig.PxTrackHeight - vScroll.Height));
            try {
                vScroll.Value = draft_vscroll_value;
            } catch {
            }

            // x=97がプリメジャークロックになるように調整
            int cp = AppManager.VsqFile.getPreMeasureClocks();
            int draft_hscroll_value = (int)(cp - 24.0 / AppManager.ScaleX);
            try {
                hScroll.Value = draft_hscroll_value;
            } catch {
            }

            s_pen_dashed_171_171_171.DashPattern = new float[] { 3, 3 };
            s_pen_dashed_209_204_172.DashPattern = new float[] { 3, 3 };

            menuVisualNoteProperty.Checked = AppManager.EditorConfig.ShowExpLine;
            menuVisualLyrics.Checked = AppManager.EditorConfig.ShowLyric;
            menuVisualMixer.Checked = AppManager.EditorConfig.MixerVisible;
            menuVisualPitchLine.Checked = AppManager.EditorConfig.ViewAtcualPitch;

            m_mixer_dlg = new FormMixer( this );

            UpdateMenuFonts();

            m_mixer_dlg.FederChanged += new FormMixer.FederChangedEventHandler( m_mixer_dlg_FederChanged );
            m_mixer_dlg.PanpotChanged += new FormMixer.PanpotChangedEventHandler( m_mixer_dlg_PanpotChanged );
            m_mixer_dlg.MuteChanged += new FormMixer.MuteChangedEventHandler( m_mixer_dlg_MuteChanged );
            m_mixer_dlg.SoloChanged += new FormMixer.SoloChangedEventHandler( m_mixer_dlg_SoloChanged );
            m_mixer_dlg.TopMostChanged += new BSimpleDelegate<bool>( m_mixer_dlg_TopMostChanged );
            m_mixer_dlg.ShowTopMost = AppManager.EditorConfig.MixerTopMost;
            m_mixer_dlg.UpdateStatus();
            if ( AppManager.EditorConfig.MixerVisible ) {
                m_mixer_dlg.Show();
            }

            trackSelector.CommandExecuted += new TrackSelector.CommandExecutedEventHandler( trackSelector_CommandExecuted );

            UpdateScriptShortcut();

            ClearTempWave();
            SetHScrollRange( hScroll.Maximum );
            SetVScrollRange( vScroll.Maximum );
            m_pencil_mode.Mode = PencilModeEnum.Off;
            UpdateCMenuPianoFixed();
            GameControlerLoad();
            ReloadMidiIn();
            menuVisualWaveform.Checked = AppManager.EditorConfig.ViewWaveform;
            UpdateSplitContainer2Size();

            UpdateRendererMenu();

            if ( AppManager.EditorConfig.WindowMaximized ) {
                this.WindowState = FormWindowState.Maximized;
            } else {
                this.WindowState = FormWindowState.Normal;
            }
            this.Bounds = AppManager.EditorConfig.WindowRect;
            UpdateLayout();

            // プロパティウィンドウの位置を復元
            Rectangle rcScreen = Screen.GetWorkingArea( this );
            Point p = this.Location;
            Point p0 = AppManager.EditorConfig.PropertyWindowBounds.Location;
            Point a = new Point( p.X + p0.X, p.Y + p0.Y );
            Rectangle rc = new Rectangle( a.X,
                                          a.Y,
                                          AppManager.EditorConfig.PropertyWindowBounds.Width,
                                          AppManager.EditorConfig.PropertyWindowBounds.Height );

            if ( a.Y > rcScreen.Top + rcScreen.Height ) {
                a = new Point( a.X, rcScreen.Top + rcScreen.Height - rc.Height );
            }
            if ( a.Y < rcScreen.Top ) {
                a = new Point( a.X, rcScreen.Top );
            }
            if ( a.X > rcScreen.Left + rcScreen.Width ) {
                a = new Point( rcScreen.Left + rcScreen.Width - rc.Width, a.Y );
            }
            if ( a.X < rcScreen.Left ) {
                a = new Point( rcScreen.Left, a.Y );
            }
#if DEBUG
            AppManager.DebugWriteLine( "FormMain_Load; a=" + a );
#endif
            AppManager.NotePropertyDlg.Bounds = new Rectangle( a.X, a.Y, rc.Width, rc.Height );
            AppManager.NotePropertyDlg.LocationChanged += new EventHandler( m_note_proerty_dlg_LocationOrSizeChanged );
            AppManager.NotePropertyDlg.SizeChanged += new EventHandler( m_note_proerty_dlg_LocationOrSizeChanged );
            AppManager.NotePropertyDlg.FormClosing += new FormClosingEventHandler( m_note_proerty_dlg_FormClosing );
            AppManager.NotePropertyPanel.CommandExecuteRequired += new CommandExecuteRequiredEventHandler( m_note_proerty_dlg_CommandExecuteRequired );
            AppManager.NotePropertyDlg.FormCloseShortcutKey = AppManager.EditorConfig.GetShortcutKeyFor( menuVisualProperty );
            menuVisualProperty.Checked = AppManager.EditorConfig.PropertyWindowVisible;

            this.SizeChanged += new System.EventHandler( this.FormMain_SizeChanged );
            this.LocationChanged += new System.EventHandler( this.FormMain_LocationChanged );
            Refresh();
#if DEBUG
            using ( TextMemoryStream tms = new TextMemoryStream( @"C:\a.txt", Encoding.ASCII ) ) {
                tms.rewind();
                while ( tms.peek() >= 0 ) {
                    Console.WriteLine( tms.readLine() );
                }
            }
#if VER22
            WaveDrawContext wdc = new WaveDrawContext( @"C:\ぴょ.wav" );
            using ( Bitmap b = new Bitmap( 500, 200 ) ) {
                using ( Graphics g = Graphics.FromImage( b ) ) {
                    wdc.Draw( g, Pens.Black, new Rectangle( 0, 0, 500, 200 ), 0.0f, 0.5f );
                }
                b.Save( @"C:\ぴょ.wav.png", System.Drawing.Imaging.ImageFormat.Png );
            }
            try {
                UtauFreq uf = UtauFreq.FromFrq( @"C:\あ_wav.frq" );
                uf.Write( new FileStream( @"C:\regenerated.frq", FileMode.Create, FileAccess.Write ) );
            } catch {
            }
#endif
            menuHidden.Visible = true;
            /*using ( StreamWriter sw = new StreamWriter( Path.Combine( Application.StartupPath, "Keys.txt" ) ) ) {
                foreach ( Keys key in Enum.GetValues( typeof( Keys ) ) ) {
                    sw.WriteLine( (int)key + "\t" + key.ToString() );
                }
            }*/
            /*OpenFileDialog ofd = new OpenFileDialog();
            XmlSerializer xs = new XmlSerializer( typeof( VsqFileEx ) );
            while ( ofd.ShowDialog() == DialogResult.OK ) {
                VsqFileEx vsq = new VsqFileEx( ofd.FileName );
                vsq.Track[1].getEvent( 1 ).UstEvent = new UstEvent();
                using ( FileStream fs = new FileStream( ofd.FileName + "_regen.xml", FileMode.Create ) ) {
                    xs.Serialize( fs, vsq );
                }
            }*/
            /*Cursor c = SynthCursor( Properties.Resources.arrow_135 );
            if ( c != null ) {
                HAND = c;
            }*/
            /*MessageBody mb = new MessageBody( "ja", Path.Combine( Application.StartupPath, "ja.po" ) );
            mb.Write( Path.Combine( Application.StartupPath, "foo.po" ) );*/
            /*OpenFileDialog ofd = new OpenFileDialog();
            Wave.TestEnabled = true;
            while ( ofd.ShowDialog() == DialogResult.OK ) {
                string file = Path.Combine( Path.GetDirectoryName( ofd.FileName ), Path.GetFileNameWithoutExtension( ofd.FileName ) + ".txt" );
                using ( StreamWriter sw = new StreamWriter( file ) )
                using ( Wave w = new Wave( ofd.FileName ) ) {
                    w.TrimSilence();
                    int WID = 2048;
                    double[] wind = new double[WID];
                    for ( int j = 0; j < WID; j++ ) {
                        wind[j] = bocoree.math.window_func( bocoree.math.WindowFunctionType.Hamming, (double)j / (double)WID );
                    }
                    uint i = w.SampleRate;
                    //for ( uint i = 0; i < w.TotalSamples; i+=10 ) {
                        double f0 = w.TEST_GetF0( i, wind );
                        double n = 12.0 * Math.Log( f0 / 440.0, 2.0 ) + 69.0;
                        sw.WriteLine( i / (double)w.SampleRate + "\t" + n + "\t" + f0 );
                    //}
                }
            }*/
            /*bocoree.debug.push_log( "installed singers 1" );
            SingerConfig[] s1 = VocaloSysUtil.getInstalledSingers1();
            foreach ( SingerConfig sc in s1 ) {
                bocoree.debug.push_log( "    " + sc );
            }
            bocoree.debug.push_log( "installed singers 2" );
            SingerConfig[] s2 = VocaloSysUtil.getInstalledSingers2();
            foreach ( SingerConfig sc in s2 ) {
                bocoree.debug.push_log( "    " + sc );
            }
            if ( AppManager.EditorConfig.PathUtauVSTi != "" ) {
                bocoree.debug.push_log( "installed singers utau" );
                UtauSingerConfigSys uscs = new UtauSingerConfigSys( Path.GetDirectoryName( AppManager.EditorConfig.PathUtauVSTi ) );
                s2 = uscs.getInstalledSingers();
                foreach ( SingerConfig sc in s2 ) {
                    bocoree.debug.push_log( "    " + sc );
                }
            }
            Console.WriteLine( VocaloSysUtil.getLanguage2( 0 ) );*/

            /*OpenFileDialog ofd = new OpenFileDialog();
                const string format = "    {0,8} 0x{1:X4} {2,-32} 0x{3:X2} 0x{4:X2}";
                const string format0 = "    {0,8} 0x{1:X4} {2,-32} 0x{3:X2}";
            while ( ofd.ShowDialog() == DialogResult.OK ) {
                VsqFile vf = new VsqFile( ofd.FileName );
                vf.getTrack( 1 ).getCommon().Version = "UTU000";
                VsqNrpn[] nrpns = VsqFile.generateNRPN( vf, 1, 500 );
                string file = Path.Combine( Path.GetDirectoryName( ofd.FileName ), Path.GetFileNameWithoutExtension( ofd.FileName ) + "_regen.txt" );
                using ( StreamWriter sw = new StreamWriter( file ) ) {
                    for ( int i = 0; i < nrpns.Length; i++ ) {
                        VsqNrpn vn = nrpns[i];
                        if ( vn.DataLsbSpecified ) {
                            sw.WriteLine( string.Format( format, vn.Clock, vn.Nrpn, NRPN.getName( vn.Nrpn ), vn.DataMsb, vn.DataLsb ) );
                        } else {
                            sw.WriteLine( string.Format( format0, vn.Clock, vn.Nrpn, NRPN.getName( vn.Nrpn ), vn.DataMsb ) );
                        }
                    }
                }
            }*/
            /*unsafe {
                WavePlay w = new WavePlay( 44100, 44100 );
                w.on_your_mark( new string[] { }, 0 );
                float* left = (float*)System.Runtime.InteropServices.Marshal.AllocHGlobal( sizeof( float ) * 10000 );
                float* right = (float*)System.Runtime.InteropServices.Marshal.AllocHGlobal( sizeof( float ) * 10000 );
                float** buf = (float**)System.Runtime.InteropServices.Marshal.AllocHGlobal( sizeof( float* ) * 2 );
                buf[0] = left;
                buf[1] = right;
                float wv = 0.0f;
                for ( int i = 0; i < 10000; i++ ) {
                    wv += 0.002f;
                    if ( wv > 0.2f ) {
                        wv = -0.2f;
                    }
                    left[i] = wv;
                    right[i] = -wv;
                }
                for ( int i = 0; i < 100; i++ ) {
                    w.append( buf, 10000, 0.2, 0.2 );
                }
                w.flush_and_exit( 0.2, 0.2 );
                while ( w.is_alive() ) {
                }
            }*/
#endif
        }

        private void m_note_proerty_dlg_CommandExecuteRequired( CadenciiCommand command ) {
            AppManager.Register( AppManager.VsqFile.executeCommand( command ) );
            UpdateDrawObjectList();
            RefreshScreen();
        }

        private void m_note_proerty_dlg_FormClosing( object sender, FormClosingEventArgs e ) {
            if ( e.CloseReason == CloseReason.UserClosing ) {
                e.Cancel = true;
                menuVisualProperty.Checked = false;
            }
        }

        private void m_note_proerty_dlg_LocationOrSizeChanged( object sender, EventArgs e ) {
            Point parent = this.Location;
            Point proeprty = AppManager.NotePropertyDlg.Location;
            AppManager.EditorConfig.PropertyWindowBounds = new Rectangle( proeprty.X - parent.X,
                                                                          proeprty.Y - parent.Y,
                                                                          AppManager.NotePropertyDlg.Width,
                                                                          AppManager.NotePropertyDlg.Height );
#if DEBUG
            AppManager.DebugWriteLine( "m_note_property_dlg_LocationChanged; AppManager.EditorConfig.PropertyWindowBounds=" + AppManager.EditorConfig.PropertyWindowBounds );
#endif
        }

        private void FormMain_LocationChanged( object sender, EventArgs e ) {
            if ( this.WindowState == FormWindowState.Normal ) {
                AppManager.EditorConfig.WindowRect = this.Bounds;
            }
        }

        private void FormMain_SizeChanged( object sender, EventArgs e ) {
            if ( this.WindowState == FormWindowState.Normal ) {
                AppManager.EditorConfig.WindowRect = this.Bounds;
                AppManager.NotePropertyDlg.WindowState = FormWindowState.Normal;
                AppManager.NotePropertyDlg.Visible = AppManager.EditorConfig.PropertyWindowVisible;
                UpdateLayout();
            } else if ( this.WindowState == FormWindowState.Minimized ) {
                AppManager.NotePropertyDlg.Visible = false;
            } else if ( this.WindowState == FormWindowState.Maximized ) {
                AppManager.NotePropertyDlg.WindowState = FormWindowState.Normal;
                AppManager.NotePropertyDlg.Visible = AppManager.EditorConfig.PropertyWindowVisible;
            }
        }

        private void FormMain_MouseWheel( object sender, MouseEventArgs e ) {
            if ( (Control.ModifierKeys & Keys.Shift) == Keys.Shift ) {
                hScroll.Value = NewHScrollValueFromWheelDelta( e.Delta );
            } else {
                double new_val = (double)vScroll.Value - e.Delta;
                if ( new_val > vScroll.Maximum ) {
                    vScroll.Value = vScroll.Maximum;
                } else if ( new_val < vScroll.Minimum ) {
                    vScroll.Value = vScroll.Minimum;
                } else {
                    vScroll.Value = (int)new_val;
                }
            }
            RefreshScreen();
        }

        private void FormMain_PreviewKeyDown( object sender, PreviewKeyDownEventArgs e ) {
            ProcessSpecialShortcutKey( e );
        }

        private void FormMain_Deactivate( object sender, EventArgs e ) {
            m_form_activated = false;
        }

        private void FormMain_Activated( object sender, EventArgs e ) {
            m_form_activated = true;
        }
        #endregion

        private void m_timer_Tick( object sender, EventArgs e ) {
            if ( !m_form_activated ) {
                return;
            }
            try {
                DateTime now = DateTime.Now;
                byte[] buttons;
                int pov0;
                winmmhelp.JoyGetStatus( 0, out buttons, out pov0 );
                bool event_processed = false;
                double dt_ms = now.Subtract( m_last_event_processed ).TotalMilliseconds;

                EditorConfig m = AppManager.EditorConfig;
                bool btn_x = (0 <= m.GameControlerCross && m.GameControlerCross < buttons.Length && buttons[m.GameControlerCross] > 0x00);
                bool btn_o = (0 <= m.GameControlerCircle && m.GameControlerCircle < buttons.Length && buttons[m.GameControlerCircle] > 0x00);
                bool btn_tr = (0 <= m.GameControlerTriangle && m.GameControlerTriangle < buttons.Length && buttons[m.GameControlerTriangle] > 0x00);
                bool btn_re = (0 <= m.GameControlerRectangle && m.GameControlerRectangle < buttons.Length && buttons[m.GameControlerRectangle] > 0x00);
                bool pov_r = pov0 == m.GameControlPovRight;
                bool pov_l = pov0 == m.GameControlPovLeft;
                bool pov_u = pov0 == m.GameControlPovUp;
                bool pov_d = pov0 == m.GameControlPovDown;
                bool L1 = (0 <= m.GameControlL1 && m.GameControlL1 < buttons.Length && buttons[m.GameControlL1] > 0x00);
                bool R1 = (0 <= m.GameControlL2 && m.GameControlL2 < buttons.Length && buttons[m.GameControlR1] > 0x00);
                bool L2 = (0 <= m.GameControlR1 && m.GameControlR1 < buttons.Length && buttons[m.GameControlL2] > 0x00);
                bool R2 = (0 <= m.GameControlR2 && m.GameControlR2 < buttons.Length && buttons[m.GameControlR2] > 0x00);
                bool SELECT = (0 <= m.GameControlSelect && m.GameControlSelect <= buttons.Length && buttons[m.GameControlSelect] > 0x00);
                if ( m_game_mode == GameControlMode.Normal ) {
                    m_last_btn_x = btn_x;

                    if ( !event_processed && !btn_o && m_last_btn_o ) {
                        if ( AppManager.Playing ) {
                            timer.Stop();
                        }
                        AppManager.Playing = !AppManager.Playing;
                        m_last_event_processed = now;
                        event_processed = true;
                    }
                    m_last_btn_o = btn_o;

                    if ( !event_processed && pov_r && dt_ms > AppManager.EditorConfig.GameControlerMinimumEventInterval ) {
                        Forward();
                        m_last_event_processed = now;
                        event_processed = true;
                    }
                    m_last_pov_r = pov_r;

                    if ( !event_processed && pov_l && dt_ms > AppManager.EditorConfig.GameControlerMinimumEventInterval ) {
                        Rewind();
                        m_last_event_processed = now;
                        event_processed = true;
                    }
                    m_last_pov_l = pov_l;

                    if ( !event_processed && pov_u && dt_ms > AppManager.EditorConfig.GameControlerMinimumEventInterval ) {
                        int draft_vscroll = vScroll.Value - AppManager.EditorConfig.PxTrackHeight * 3;
                        if ( draft_vscroll < vScroll.Minimum ) {
                            draft_vscroll = vScroll.Minimum;
                        }
                        vScroll.Value = draft_vscroll;
                        RefreshScreen();
                        m_last_event_processed = now;
                        event_processed = true;
                    }

                    if ( !event_processed && pov_d && dt_ms > AppManager.EditorConfig.GameControlerMinimumEventInterval ) {
                        int draft_vscroll = vScroll.Value + AppManager.EditorConfig.PxTrackHeight * 3;
                        if ( draft_vscroll > vScroll.Maximum ) {
                            draft_vscroll = vScroll.Maximum;
                        }
                        vScroll.Value = draft_vscroll;
                        RefreshScreen();
                        m_last_event_processed = now;
                        event_processed = true;
                    }

                    if ( !event_processed && !SELECT && m_last_select ) {
                        event_processed = true;
                        m_game_mode = GameControlMode.Keyboard;
                        stripLblGameCtrlMode.Text = m_game_mode.ToString();
                        stripLblGameCtrlMode.Image = Properties.Resources.piano;
                    }
                    m_last_select = SELECT;
                } else if ( m_game_mode == GameControlMode.Keyboard ) {
                    if ( !event_processed && !SELECT && m_last_select ) {
                        event_processed = true;
                        m_game_mode = GameControlMode.Normal;
                        UpdateGameControlerStatus();
                        m_last_select = SELECT;
                        return;
                    }
                    m_last_select = SELECT;
                    if ( L1 && R1 && L2 && R2 && dt_ms > AppManager.EditorConfig.GameControlerMinimumEventInterval ) {
                        if ( AppManager.Playing ) {
                            AppManager.EditMode = EditMode.None;
                            AppManager.Playing = false;
                            timer.Stop();
                        } else {
                            m_timer.Enabled = false;
                            using ( FormRealtimeConfig frc = new FormRealtimeConfig() ) {
                                if ( frc.ShowDialog() == DialogResult.OK ) {
                                    m_adding = null;
                                    AppManager.EditMode = EditMode.Realtime;
                                    AppManager.EditorConfig.RealtimeInputSpeed = frc.Speed;
                                    AppManager.Playing = true;
                                }
                            }
                            m_timer.Enabled = true;
                        }
                        m_last_btn_o = btn_o;
                        m_last_btn_x = btn_x;
                        m_last_btn_re = btn_re;
                        m_last_btn_tr = btn_tr;
                        m_last_pov_l = pov_l;
                        m_last_pov_d = pov_d;
                        m_last_pov_r = pov_r;
                        m_last_pov_u = pov_u;
                        return;
                    }

                    int note = -1;
                    if ( pov_r && !m_last_pov_r ) {
                        note = 60;
                    } else if ( btn_re && !m_last_btn_re ) {
                        note = 62;
                    } else if ( btn_tr && !m_last_btn_tr ) {
                        note = 64;
                    } else if ( btn_o && !m_last_btn_o ) {
                        note = 65;
                    } else if ( btn_x && !m_last_btn_x ) {
                        note = 67;
                    } else if ( pov_u && !m_last_pov_u ) {
                        note = 59;
                    } else if ( pov_l && !m_last_pov_l ) {
                        note = 57;
                    } else if ( pov_d && !m_last_pov_d ) {
                        note = 55;
                    }
                    if ( note >= 0 ) {
                        if ( L1 ) {
                            note += 12;
                        } else if ( L2 ) {
                            note -= 12;
                        }
                        if ( R1 ) {
                            note += 1;
                        } else if ( R2 ) {
                            note -= 1;
                        }
                    }
                    m_last_btn_o = btn_o;
                    m_last_btn_x = btn_x;
                    m_last_btn_re = btn_re;
                    m_last_btn_tr = btn_tr;
                    m_last_pov_l = pov_l;
                    m_last_pov_d = pov_d;
                    m_last_pov_r = pov_r;
                    m_last_pov_u = pov_u;
                    if ( note >= 0 ) {
#if DEBUG
                        AppManager.DebugWriteLine( "FormMain+m_timer_Tick" );
                        AppManager.DebugWriteLine( "    note=" + note );
#endif
                        if ( AppManager.Playing ) {
                            int clock = AppManager.CurrentClock;
                            if ( m_adding != null ) {
                                m_adding.ID.Length = clock - m_adding.Clock;
                                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventAdd( AppManager.Selected,
                                                                                                        m_adding ) );
                                AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                                if ( !Edited ) {
                                    Edited = true;
                                }
#if USE_DOBJ
                                UpdateDrawObjectList();
#endif
                            }
                            m_adding = new VsqEvent( clock, new VsqID( 0 ) );
                            m_adding.ID.type = VsqIDType.Anote;
                            m_adding.ID.Dynamics = 64;
                            m_adding.ID.VibratoHandle = null;
                            m_adding.ID.LyricHandle = new LyricHandle( "a", "a" );
                            m_adding.ID.Note = note;
                        }
                        if ( AppManager.EditMode == EditMode.Realtime ) {
                            MidiPlayer.PlayImmediate( (byte)note );
                        } else {
                            KeySoundPlayer.Play( note );
                        }
                    } else {
                        if ( AppManager.Playing && m_adding != null ) {
                            m_adding.ID.Length = AppManager.CurrentClock - m_adding.Clock;
                        }
                    }
                }
            } catch ( Exception ex ) {
#if DEBUG
                AppManager.DebugWriteLine( "    ex=" + ex );
#endif
                m_game_mode = GameControlMode.Disabled;
                UpdateGameControlerStatus();
                if ( AppManager.EditMode == EditMode.Realtime ) {
                    AppManager.Playing = false;
                    AppManager.EditMode = EditMode.None;
                    m_adding = null;
                }
                m_timer.Stop();
            }
        }

        private void EditorConfig_QuantizeModeChanged( object sender, EventArgs e ) {
            ApplyQuantizeMode();
        }

        #region menuFile*
        private void menuFileSaveNamed_Click( object sender, EventArgs e ) {
            for ( int track = 1; track < AppManager.VsqFile.Track.Count; track++ ) {
                if ( AppManager.VsqFile.Track[track].getEventCount() == 0 ) {
                    MessageBox.Show(
                        String.Format(
                            _( "Invalid note data.\nTrack {0} : {1}\n\n-> Piano roll : Blank sequence." ), track, AppManager.VsqFile.Track[track].Name
                        ),
                        _APP_NAME,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Exclamation );
                    return;
                }
            }
            DialogResult dr = DialogResult.Cancel;
            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Open ) ) {
                    if ( saveXmlVsqDialog.FileName != "" ) {
                        fd.FileName = saveXmlVsqDialog.FileName;
                    }
                    fd.Filter = saveXmlVsqDialog.Filter;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        saveXmlVsqDialog.FileName = fd.FileName;
                    }
                }
            } else {
                dr = saveXmlVsqDialog.ShowDialog();
            }

            if ( dr == DialogResult.OK ) {
                string file = saveXmlVsqDialog.FileName;
                AppManager.SaveTo( file );
                UpdateRecentFileMenu();
                Edited = false;
            }
        }

        private void commonFileSave_Click( object sender, EventArgs e ) {
            for ( int track = 1; track < AppManager.VsqFile.Track.Count; track++ ) {
                if ( AppManager.VsqFile.Track[track].getEventCount() == 0 ) {
                    MessageBox.Show(
                        String.Format(
                            _( "Invalid note data.\nTrack {0} : {1}\n\n-> Piano roll : Blank sequence." ), track, AppManager.VsqFile.Track[track].Name
                        ),
                        _APP_NAME,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Exclamation );
                    return;
                }
            }
            string file = AppManager.FileName;
            if ( AppManager.FileName == "" ) {
                DialogResult dr = DialogResult.Cancel;
                if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                    using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Open ) ) {
                        if ( saveXmlVsqDialog.FileName != "" ) {
                            fd.FileName = saveXmlVsqDialog.FileName;
                        }
                        fd.Filter = saveXmlVsqDialog.Filter;
                        dr = fd.ShowDialog();
                        if ( dr == DialogResult.OK ) {
                            saveXmlVsqDialog.FileName = fd.FileName;
                        }
                    }
                } else {
                    dr = saveXmlVsqDialog.ShowDialog();
                }

                if ( dr == DialogResult.OK ) {
                    file = saveXmlVsqDialog.FileName;
                }
            }
            if ( file != "" ) {
                AppManager.SaveTo( file );
                UpdateRecentFileMenu();
                Edited = false;
            }
        }

        private void menuFileQuit_Click( object sender, EventArgs e ) {
            this.Close();
        }

        private void menuFileExportWave_Click( object sender, EventArgs e ) {
            DialogResult dr = DialogResult.Cancel;
            string filename = "";
            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Save ) ) {
                    fd.Title = _( "Wave Export" );
                    try {
                        fd.Filter = _( "Wave File(*.wav)|*.wav" ) + "|" + _( "All Files(*.*)|*.*" );
                    } catch {
                        fd.Filter = "Wave File(*.wav)|*.wav|All Files(*.*)|*.*";
                    }
                    dr = fd.ShowDialog();
                    filename = fd.FileName;
                }
            } else {
                using ( SaveFileDialog sfd = new SaveFileDialog() ) {
                    sfd.Title = _( "Wave Export" );
                    try {
                        sfd.Filter = _( "Wave File(*.wav)|*.wav" ) + "|" + _( "All Files(*.*)|*.*" );
                    } catch {
                        sfd.Filter = "Wave File(*.wav)|*.wav|All Files(*.*)|*.*";
                    }
                    dr = sfd.ShowDialog();
                    filename = sfd.FileName;
                }
            }

            if ( dr == DialogResult.OK ) {
                using ( FormSynthesize fs = new FormSynthesize(
                    AppManager.VsqFile,
                    AppManager.EditorConfig.PreSendTime,
                    new int[] { AppManager.Selected },
                    new string[] { filename },
                    AppManager.VsqFile.TotalClocks + 240 ) ) {

                    DateTime started = DateTime.Now;
                    fs.ShowDialog();
#if DEBUG
                    bocoree.debug.push_log( "elapsed time=" + DateTime.Now.Subtract( started ).TotalSeconds + "sec" );
#endif
                }
            }
        }

        private void menuFileExport_DropDownOpening( object sender, EventArgs e ) {
            menuFileExportWave.Enabled = (AppManager.VsqFile.Track[AppManager.Selected].getEventCount() > 0) && VSTiProxy.CurrentUser == "";
        }

        private void menuFileImportMidi_Click( object sender, EventArgs e ) {
            if ( m_midi_imexport_dialog == null ) {
                m_midi_imexport_dialog = new FormMidiImExport();
            }
            m_midi_imexport_dialog.ListTrack.Items.Clear();
            m_midi_imexport_dialog.Mode = FormMidiImExport.FormMidiMode.Import;

            DialogResult dr = DialogResult.Cancel;
            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Open ) ) {
                    if ( openMidiDialog.FileName != "" ) {
                        fd.FileName = openMidiDialog.FileName;
                    }
                    fd.Filter = openMidiDialog.Filter;
                    fd.Location = GetFormPreferedLocation( fd );
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        openMidiDialog.FileName = fd.FileName;
                    }
                }
            } else {
                dr = openMidiDialog.ShowDialog();
            }

            if ( dr != DialogResult.OK ) {
                return;
            }
            m_midi_imexport_dialog.Location = GetFormPreferedLocation( m_midi_imexport_dialog );
            MidiFile mf = new MidiFile( openMidiDialog.FileName );
            int count = mf.getTrackCount();
            Encoding def_enc = Encoding.GetEncoding( 0 );
            for ( int i = 0; i < count; i++ ) {
                string track_name = "";
                int notes = 0;
                List<MidiEvent> events = mf.getMidiEventList( i );

                // トラック名を取得
                for ( int j = 0; j < events.Count; j++ ) {
                    if ( events[j].FirstByte == 0xff && events[j].Data.Length >= 2 && events[j].Data[0] == 0x03 ) {
                        track_name = def_enc.GetString( events[j].Data, 1, events[j].Data.Length - 1 );
                        break;
                    }
                }

                // イベント数を数える
                for ( int j = 0; j < events.Count; j++ ) {
                    if ( (events[j].FirstByte & 0xf0) == 0x90 && events[j].Data.Length > 1 && events[j].Data[1] > 0x00 ) {
                        notes++;
                    }
                }
                m_midi_imexport_dialog.ListTrack.Items.Add( new ListViewItem( new string[] { i.ToString(), track_name, notes.ToString() } ) );
                m_midi_imexport_dialog.ListTrack.Items[i].Checked = true;
            }

            if ( m_midi_imexport_dialog.ShowDialog() != DialogResult.OK ) {
                return;
            }

            // インポートするしないにかかわらずテンポと拍子を取得
            VsqFile tempo = new VsqFile( "Miku", 2, 4, 4, 500000 ); //テンポリスト用のVsqFile。テンポの部分のみ使用
            tempo.executeCommand( VsqCommand.generateCommandChangePreMeasure( 0 ) );
            bool tempo_added = false;
            bool timesig_added = false;
            tempo.TempoTable.Clear();
            tempo.TimesigTable.Clear();
            int mf_getTrackCount = mf.getTrackCount();
            for ( int i = 0; i < mf_getTrackCount; i++ ) {
                List<MidiEvent> events = mf.getMidiEventList( i );
                bool t_tempo_added = false;   //第iトラックからテンポをインポートしたかどうか
                bool t_timesig_added = false; //第iトラックから拍子をインポートしたかどうか
                int events_Count = events.Count;
                for ( int j = 0; j < events_Count; j++ ) {
                    if ( !tempo_added && events[j].FirstByte == 0xff && events[j].Data.Length >= 4 && events[j].Data[0] == 0x51 ) {
                        int vtempo = events[j].Data[1] << 16 | events[j].Data[2] << 8 | events[j].Data[3];
                        tempo.TempoTable.Add( new TempoTableEntry( (int)events[j].Clock, vtempo, 0.0 ) );
                        t_tempo_added = true;
                    }
                    if ( !timesig_added && events[j].FirstByte == 0xff && events[j].Data.Length >= 5 && events[j].Data[0] == 0x58 ) {
                        int num = events[j].Data[1];
                        int den = 1;
                        for ( int k = 0; k < events[j].Data[2]; k++ ) {
                            den = den * 2;
                        }
                        tempo.TimesigTable.Add( new TimeSigTableEntry( (int)events[j].Clock, num, den, 0 ) );
                        t_timesig_added = true;
                    }
                }
                if ( t_tempo_added ) {
                    tempo_added = true;
                }
                if ( t_timesig_added ) {
                    timesig_added = true;
                }
                if ( timesig_added && tempo_added ) {
                    // 両方ともインポート済みならexit。2個以上のトラックから、重複してテンポや拍子をインポートするのはNG（たぶん）
                    break;
                }
            }
            bool contains_zero = false;
            for ( int i = 0; i < tempo.TempoTable.Count; i++ ) {
                if ( tempo.TempoTable[i].Clock == 0 ) {
                    contains_zero = true;
                    break;
                }
            }
            if ( !contains_zero ) {
                tempo.TempoTable.Add( new TempoTableEntry( 0, 500000, 0.0 ) );
            }
            contains_zero = false;
            for ( int i = 0; i < tempo.TimesigTable.Count; i++ ) {
                if ( tempo.TimesigTable[i].Clock == 0 ) {
                    contains_zero = true;
                    break;
                }
            }
            if ( !contains_zero ) {
                tempo.TimesigTable.Add( new TimeSigTableEntry( 0, 4, 4, 0 ) );
            }
            tempo.updateTempoInfo();
            tempo.updateTimesigInfo();

            VsqFileEx work = (VsqFileEx)AppManager.VsqFile.Clone(); //後でReplaceコマンドを発行するための作業用

            // tempoをインポート
            bool import_tempo = m_midi_imexport_dialog.Tempo;
            if ( import_tempo ) {
                // 最初に、workにある全てのイベント・コントロールカーブ・ベジエ曲線をtempoのテンポテーブルに合うように、シフトする
                ShiftClockToMatchWith( work, tempo, work.getSecFromClock( work.getPreMeasureClocks() ) );

                work.TempoTable.Clear();
                List<TempoTableEntry> list = tempo.TempoTable;
                int list_count = list.Count;
                for ( int i = 0; i < list_count; i++ ) {
                    work.TempoTable.Add( new TempoTableEntry( list[i].Clock, list[i].Tempo, list[i].Time ) );
                }
                work.updateTempoInfo();
            }

            // timesig
            if ( m_midi_imexport_dialog.Timesig ) {
                work.TimesigTable.Clear();
                List<TimeSigTableEntry> list = tempo.TimesigTable;
                for ( int i = 0; i < list.Count; i++ ) {
                    work.TimesigTable.Add( new TimeSigTableEntry( list[i].Clock,
                                                                      list[i].Numerator,
                                                                      list[i].Denominator,
                                                                      list[i].BarCount ) );
                }
                work.TimesigTable.Sort();
                work.updateTimesigInfo();
            }

#if DEBUG
            AppManager.DebugWriteLine( "menuFileImportMidi_Click" );
            AppManager.DebugWriteLine( "    work.TempoTable" );
            for ( int i = 0; i < work.TempoTable.Count; i++ ) {
                AppManager.DebugWriteLine( "        clock,tempo=" + work.TempoTable[i].Clock + "," + work.TempoTable[i].Tempo );
            }
            AppManager.DebugWriteLine( "    tempo.TempoTable" );
            for ( int i = 0; i < tempo.TempoTable.Count; i++ ) {
                AppManager.DebugWriteLine( "        clock,tempo=" + tempo.TempoTable[i].Clock + "," + tempo.TempoTable[i].Tempo );
            }
#endif

            for ( int i = 0; i < m_midi_imexport_dialog.ListTrack.Items.Count; i++ ) {
                if ( !m_midi_imexport_dialog.ListTrack.Items[i].Checked ) {
                    continue;
                }
                if ( work.Track.Count + 1 > 16 ) {
                    break;
                }
                VsqTrack work_track = new VsqTrack( m_midi_imexport_dialog.ListTrack.Items[i].SubItems[1].Text, "Miku" );
                List<MidiEvent> events = mf.getMidiEventList( i );

                // note
                if ( m_midi_imexport_dialog.Notes ) {
                    int[] onclock_each_note = new int[128];
                    for ( int j = 0; j < 128; j++ ) {
                        onclock_each_note[j] = -1;
                    }
                    double sec_at_premeasure = work.getSecFromClock( work.getPreMeasureClocks() );
                    for ( int j = 0; j < events.Count; j++ ) {
                        if ( ((events[j].FirstByte & 0xf0) == 0x90 && events[j].Data.Length >= 2 && events[j].Data[1] == 0) ||
                             ((events[j].FirstByte & 0xf0) == 0x80 && events[j].Data.Length >= 2) ) {
                            int clock_off = (int)events[j].Clock;
                            int note = (int)events[j].Data[0];
                            if ( onclock_each_note[note] >= 0 ) {
                                //int add_clock_on = onclock_each_note[note];
                                //int add_clock_off = clock_off;
                                double time_clock_on = tempo.getSecFromClock( onclock_each_note[note] ) + sec_at_premeasure;
                                double time_clock_off = tempo.getSecFromClock( clock_off ) + sec_at_premeasure;
                                int add_clock_on = (int)work.getClockFromSec( time_clock_on );
                                int add_clock_off = (int)work.getClockFromSec( time_clock_off );
                                VsqID vid = new VsqID( 0 );
                                vid.type = VsqIDType.Anote;
                                vid.Length = add_clock_off - add_clock_on;
                                string phrase = "a";
                                if ( m_midi_imexport_dialog.Lyric ) {
                                    for ( int k = 0; k < events.Count; k++ ) {
                                        if ( onclock_each_note[note] <= (int)events[k].Clock && (int)events[k].Clock <= clock_off ) {
                                            if ( events[k].FirstByte == 0xff && events[k].Data.Length >= 2 && events[k].Data[0] == 0x05 ) {
                                                phrase = def_enc.GetString( events[k].Data, 1, events[k].Data.Length - 1 );
                                                break;
                                            }
                                        }
                                    }
                                }
                                vid.LyricHandle = new LyricHandle( phrase, "a" );
                                vid.Note = note;
                                VsqEvent ve = new VsqEvent( add_clock_on, vid );
                                work_track.addEvent( ve );
                            }
                        }
                        if ( (events[j].FirstByte & 0xf0) == 0x90 && events[j].Data.Length >= 2 && events[j].Data[1] > 0 ) {
                            int note = events[j].Data[0];
                            onclock_each_note[note] = (int)events[j].Clock;
                        }
                    }

                    CurveType ct = CurveType.Pitch;
                    CadenciiCommand run_add = VsqFileEx.generateCommandAddTrack( work_track,
                                                                                 new VsqMixerEntry( 0, 0, 0, 0 ),
                                                                                 work.Track.Count,
                                                                                 new BezierCurves(),
                                                                                 new VsqBPList( ct.Default, ct.Minimum, ct.Maximum ) );
                    work.executeCommand( run_add );
#if PROPRETY_WINDOW
                                m_property_windows.Add( new Dictionary<int, ContextProperty>() );
#endif
                }
            }

            CadenciiCommand lastrun = VsqFileEx.generateCommandReplace( work );
            AppManager.Register( AppManager.VsqFile.executeCommand( lastrun ) );
            Edited = true;
            RefreshScreen();
        }

        private void menuFileExportMidi_Click( object sender, EventArgs e ) {
            if ( m_midi_imexport_dialog == null ) {
                m_midi_imexport_dialog = new FormMidiImExport();
            }
            m_midi_imexport_dialog.ListTrack.Items.Clear();
            for ( int i = 0; i < AppManager.VsqFile.Track.Count; i++ ) {
                VsqTrack track = AppManager.VsqFile.Track[i];
                int notes = 0;
                for ( Iterator itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                    object obj = itr.next();
                    notes++;
                }
                m_midi_imexport_dialog.ListTrack.Items.Add( new ListViewItem( new string[] { i.ToString(), track.Name, notes.ToString() } ) );
                m_midi_imexport_dialog.ListTrack.Items[i].Checked = true;// i != 0;
            }
            m_midi_imexport_dialog.Mode = FormMidiImExport.FormMidiMode.Export;
            m_midi_imexport_dialog.Location = GetFormPreferedLocation( m_midi_imexport_dialog );
            if ( m_midi_imexport_dialog.ShowDialog() == DialogResult.OK ) {
                int track_count = 0;
                for ( int i = 0; i < m_midi_imexport_dialog.ListTrack.Items.Count; i++ ) {
                    if ( m_midi_imexport_dialog.ListTrack.Items[i].Checked ) {
                        track_count++;
                    }
                }
                if ( track_count == 0 ) {
                    return;
                }

                DialogResult dr = DialogResult.Cancel;
                if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                    using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Save ) ) {
                        if ( saveMidiDialog.FileName != "" ) {
                            fd.FileName = saveMidiDialog.FileName;
                        }
                        fd.Filter = saveMidiDialog.Filter;
                        dr = fd.ShowDialog();
                        if ( dr == DialogResult.OK ) {
                            saveMidiDialog.FileName = fd.FileName;
                        }
                    }
                } else {
                    dr = saveMidiDialog.ShowDialog();
                }

                if ( dr == DialogResult.OK ) {
                    System.Text.Encoding def_enc = System.Text.Encoding.GetEncoding( 0 ); // システムのデフォルトエンコーディング
                    using ( FileStream fs = new FileStream( saveMidiDialog.FileName, FileMode.Create ) ) {
                        // ヘッダー
                        fs.Write( new byte[] { 0x4d, 0x54, 0x68, 0x64 }, 0, 4 );
                        //データ長
                        fs.WriteByte( 0x00 );
                        fs.WriteByte( 0x00 );
                        fs.WriteByte( 0x00 );
                        fs.WriteByte( 0x06 );
                        //フォーマット
                        fs.WriteByte( 0x00 );
                        fs.WriteByte( 0x01 );
                        //トラック数
                        VsqFile.writeUnsignedShort( fs, (ushort)track_count );
                        //時間単位
                        fs.WriteByte( 0x01 );
                        fs.WriteByte( 0xe0 );
                        int count = -1;
                        for ( int i = 0; i < m_midi_imexport_dialog.ListTrack.Items.Count; i++ ) {
                            if ( !m_midi_imexport_dialog.ListTrack.Items[i].Checked ) {
                                continue;
                            }
                            VsqTrack track = AppManager.VsqFile.Track[i];
                            count++;
                            fs.Write( new byte[] { 0x4d, 0x54, 0x72, 0x6b }, 0, 4 );
                            //データ長。とりあえず0を入れておく
                            fs.Write( new byte[] { 0x00, 0x00, 0x00, 0x00 }, 0, 4 );
                            long first_position = fs.Position;
                            //トラック名
                            VsqFile.writeFlexibleLengthUnsignedLong( fs, 0 );//デルタタイム
                            fs.WriteByte( 0xff );//ステータスタイプ
                            fs.WriteByte( 0x03 );//イベントタイプSequence/Track Name
                            byte[] track_name = def_enc.GetBytes( track.Name );
                            fs.WriteByte( (byte)track_name.Length );
                            fs.Write( track_name, 0, track_name.Length );

                            List<MidiEvent> events = new List<MidiEvent>();

                            // tempo
                            bool print_tempo = m_midi_imexport_dialog.Tempo;
                            if ( print_tempo && count == 0 ) {
                                List<MidiEvent> tempo_events = AppManager.VsqFile.generateTempoChange();
                                for ( int j = 0; j < tempo_events.Count; j++ ) {
                                    events.Add( tempo_events[j] );
                                }
                            }

                            // timesig
                            if ( m_midi_imexport_dialog.Timesig && count == 0 ) {
                                List<MidiEvent> timesig_events = AppManager.VsqFile.generateTimeSig();
                                for ( int j = 0; j < timesig_events.Count; j++ ) {
                                    events.Add( timesig_events[j] );
                                }
                            }

                            // Notes
                            if ( m_midi_imexport_dialog.Notes ) {
                                for ( Iterator itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = (VsqEvent)itr.next();
                                    int clock_on = ve.Clock;
                                    int clock_off = ve.Clock + ve.ID.Length;
                                    if ( !print_tempo ) {
                                        // テンポを出力しない場合、テンポを500000（120）と見なしてクロックを再計算
                                        double time_on = AppManager.VsqFile.getSecFromClock( clock_on );
                                        double time_off = AppManager.VsqFile.getSecFromClock( clock_off );
                                        clock_on = (int)(960.0 * time_on);
                                        clock_off = (int)(960.0 * time_off);
                                    }
                                    MidiEvent noteon = new MidiEvent();
                                    noteon.Clock = clock_on;
                                    noteon.FirstByte = 0x90;
                                    noteon.Data = new byte[2];
                                    noteon.Data[0] = (byte)ve.ID.Note;
                                    noteon.Data[1] = 0x40;
                                    events.Add( noteon );
                                    MidiEvent noteoff = new MidiEvent();
                                    noteoff.Clock = clock_off;
                                    noteoff.FirstByte = 0x80;
                                    noteoff.Data = new byte[2];
                                    noteoff.Data[0] = (byte)ve.ID.Note;
                                    noteoff.Data[1] = 0x7f;
                                    events.Add( noteoff );
                                }
                            }

                            // lyric
                            if ( m_midi_imexport_dialog.Lyric ) {
                                for ( Iterator itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = (VsqEvent)itr.next();
                                    int clock_on = ve.Clock;
                                    if ( !print_tempo ) {
                                        double time_on = AppManager.VsqFile.getSecFromClock( clock_on );
                                        clock_on = (int)(960.0 * time_on);
                                    }
                                    MidiEvent add = new MidiEvent();
                                    add.Clock = clock_on;
                                    add.FirstByte = 0xff;
                                    byte[] lyric = def_enc.GetBytes( ve.ID.LyricHandle.L0.Phrase );
                                    add.Data = new byte[lyric.Length + 1];
                                    add.Data[0] = 0x05;
                                    for ( int j = 0; j < lyric.Length; j++ ) {
                                        add.Data[j + 1] = lyric[j];
                                    }
                                    events.Add( add );
                                }
                            }

                            // vocaloid metatext
                            List<MidiEvent> meta;
                            if ( m_midi_imexport_dialog.VocaloidMetatext && i > 0 ) {
                                meta = AppManager.VsqFile.generateMetaTextEvent( i );
#if DEBUG
                                using ( FileStream fs2 = new FileStream( "metatext_event" + i + ".txt", FileMode.Create, FileAccess.Write ) ) {
                                    for ( int j = 0; j < meta.Count; j++ ) {
                                        meta[j].writeData( fs2 );
                                    }
                                }
#endif
                                //for ( int j = 0; j < meta.Count; j++ ) {
                                    //events.Add( meta[j] );
                                //}
                            } else {
                                meta = new List<MidiEvent>();
                            }

                            // vocaloid nrpn
                            List<MidiEvent> vocaloid_nrpn_midievent;
                            if ( m_midi_imexport_dialog.VocaloidNrpn && i > 0 ) {
                                VsqNrpn[] vsqnrpn = VsqFileEx.generateNRPN( (VsqFile)AppManager.VsqFile, i, AppManager.EditorConfig.PreSendTime );
                                NrpnData[] nrpn = VsqNrpn.convert( vsqnrpn );

                                vocaloid_nrpn_midievent = new List<MidiEvent>();
                                for ( int j = 0; j < nrpn.Length; j++ ) {
                                    MidiEvent me = new MidiEvent();
                                    me.Clock = nrpn[j].getClock();
                                    me.FirstByte = 0xb0;
                                    me.Data = new byte[2];
                                    me.Data[0] = nrpn[j].getParameter();
                                    me.Data[1] = nrpn[j].Value;
                                    vocaloid_nrpn_midievent.Add( me );
                                }
                                /*for ( int j = 0; j < vnrpn.Count; j++ ) {
                                    events.Add( vnrpn[j] );
                                }*/
                            } else {
                                vocaloid_nrpn_midievent = new List<MidiEvent>();
                            }

                            // midi eventを出力
                            events.Sort();
                            long last_clock = 0;
                            for ( int j = 0; j < events.Count; j++ ) {
                                if ( events[j].Clock > 0 && meta.Count > 0 ) {
                                    for ( int k = 0; k < meta.Count; k++ ) {
                                        VsqFile.writeFlexibleLengthUnsignedLong( fs, 0 );
                                        meta[k].writeData( fs );
                                    }
                                    meta.Clear();
                                    last_clock = 0;
                                }
                                long clock = events[j].Clock;
                                while ( vocaloid_nrpn_midievent.Count > 0 && vocaloid_nrpn_midievent[0].Clock < clock ) {
                                    VsqFile.writeFlexibleLengthUnsignedLong( fs, (ulong)(vocaloid_nrpn_midievent[0].Clock - last_clock) );
                                    last_clock = vocaloid_nrpn_midievent[0].Clock;
                                    vocaloid_nrpn_midievent[0].writeData( fs );
                                    vocaloid_nrpn_midievent.RemoveAt( 0 );
                                }
                                VsqFile.writeFlexibleLengthUnsignedLong( fs, (ulong)(events[j].Clock - last_clock) );
                                events[j].writeData( fs );
                                last_clock = events[j].Clock;
                            }

                            // トラックエンドを記入し、
                            VsqFile.writeFlexibleLengthUnsignedLong( fs, (ulong)0 );
                            fs.WriteByte( 0xff );
                            fs.WriteByte( 0x2f );
                            fs.WriteByte( 0x00 );
                            // チャンクの先頭に戻ってチャンクのサイズを記入
                            long pos = fs.Position;
                            fs.Seek( first_position - 4, SeekOrigin.Begin );
                            VsqFile.writeUnsignedInt( fs, (uint)(pos - first_position) );
                            // ファイルを元の位置にseek
                            fs.Seek( pos, SeekOrigin.Begin );
                        }
                    }
                }
            }
        }

        private void menuFileOpenVsq_Click( object sender, EventArgs e ) {
            if ( !DirtyCheck() ) {
                return;
            }

            DialogResult dr = DialogResult.Cancel;
            int filterindex = 1;
            if ( AppManager.EditorConfig.LastUsedExtension == ".vsq" ) {
                filterindex = 2;
            }
            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Open ) ) {
                    if ( openMidiDialog.FileName != "" ) {
                        fd.FileName = openMidiDialog.FileName;
                    }
                    fd.Filter = openMidiDialog.Filter;
                    fd.FilterIndex = filterindex;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        openMidiDialog.FileName = fd.FileName;
                        if ( fd.FilterIndex == 1 ) {
                            AppManager.EditorConfig.LastUsedExtension = ".mid";
                        } else if ( fd.FilterIndex == 2 ) {
                            AppManager.EditorConfig.LastUsedExtension = ".vsq";
                        }
                    }
                }
            } else {
                openMidiDialog.FilterIndex = filterindex;
                dr = openMidiDialog.ShowDialog();
                if ( dr == DialogResult.OK ) {
#if DEBUG
                    AppManager.DebugWriteLine( "openMidiDialog.FilterIndex=" + openMidiDialog.FilterIndex );
#endif
                    if ( openMidiDialog.FilterIndex == 1 ) {
                        AppManager.EditorConfig.LastUsedExtension = ".mid";
                    } else if ( openMidiDialog.FilterIndex == 2 ) {
                        AppManager.EditorConfig.LastUsedExtension = ".vsq";
                    }
                }
            }
            if ( dr != DialogResult.OK ) {
                return;
            }
            AppManager.Selected = 1;
            AppManager.SetVsqFile( new VsqFileEx( openMidiDialog.FileName ) );
            ClearExistingData();
            Edited = false;
            m_mixer_dlg.UpdateStatus();
            ClearTempWave();
#if USE_DOBJ
            UpdateDrawObjectList();
#endif
#if PROPRETY_WINDOW
            InitContextProperty();
#endif
            RefreshScreen();
        }

        private void menuFileOpenUst_Click( object sender, EventArgs e ) {
            if ( !DirtyCheck() ) {
                return;
            }
            DialogResult dr = DialogResult.Cancel;
            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Open ) ) {
                    if ( openUstDialog.FileName != "" ) {
                        fd.FileName = openUstDialog.FileName;
                    }
                    fd.Filter = openUstDialog.Filter;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        openUstDialog.FileName = fd.FileName;
                    }
                }
            } else {
                dr = openUstDialog.ShowDialog();
            }

            if ( dr != DialogResult.OK ) {
                return;
            }

            try {
                UstFile ust = new UstFile( openUstDialog.FileName );
                VsqFileEx vsq = new VsqFileEx( ust );
                ClearExistingData();
                AppManager.SetVsqFile( vsq );
                Edited = false;
                m_mixer_dlg.UpdateStatus();
                ClearTempWave();
#if USE_DOBJ
                UpdateDrawObjectList();
#endif
#if PROPRETY_WINDOW
                    InitContextProperty();
#endif
                RefreshScreen();
            } catch {
            }
        }

        private void menuFileImportVsq_Click( object sender, EventArgs e ) {
            DialogResult dr = DialogResult.Cancel;
            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Open ) ) {
                    if ( openMidiDialog.FileName != "" ) {
                        fd.FileName = openMidiDialog.FileName;
                    }
                    fd.Filter = openMidiDialog.Filter;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        openMidiDialog.FileName = fd.FileName;
                    }
                }
            } else {
                dr = openMidiDialog.ShowDialog();
            }

            if ( dr != DialogResult.OK ) {
                return;
            }
            VsqFileEx vsq = new VsqFileEx( openMidiDialog.FileName );
            if ( m_midi_imexport_dialog == null ) {
                m_midi_imexport_dialog = new FormMidiImExport();
            }
            m_midi_imexport_dialog.ListTrack.Items.Clear();
            for ( int track = 1; track < vsq.Track.Count; track++ ) {
                m_midi_imexport_dialog.ListTrack.Items.Add( new ListViewItem( new string[] { track.ToString(), 
                                                                                             vsq.Track[track].Name,
                                                                                             vsq.Track[track].getEventCount().ToString() } ) );
                m_midi_imexport_dialog.ListTrack.Items[track - 1].Checked = true;
            }
            m_midi_imexport_dialog.Mode = FormMidiImExport.FormMidiMode.ImportVsq;
            m_midi_imexport_dialog.Tempo = false;
            m_midi_imexport_dialog.Timesig = false;
            m_midi_imexport_dialog.Location = GetFormPreferedLocation( m_midi_imexport_dialog );
            if ( m_midi_imexport_dialog.ShowDialog() != DialogResult.OK ) {
                return;
            }

            List<int> add_track = new List<int>();
            for ( int i = 0; i < m_midi_imexport_dialog.ListTrack.Items.Count; i++ ) {
                if ( m_midi_imexport_dialog.ListTrack.Items[i].Checked ) {
                    add_track.Add( i + 1 );
                }
            }
            if ( add_track.Count <= 0 ) {
                return;
            }

            VsqFileEx replace = (VsqFileEx)AppManager.VsqFile.Clone();
            double premeasure_sec_replace = replace.getSecFromClock( replace.getPreMeasureClocks() );
            double premeasure_sec_vsq = vsq.getSecFromClock( vsq.getPreMeasureClocks() );

            if ( m_midi_imexport_dialog.Tempo ) {
                ShiftClockToMatchWith( replace, vsq, vsq.getSecFromClock( vsq.getPreMeasureClocks() ) );
                // テンポテーブルを置き換え
                replace.TempoTable.Clear();
                for ( int i = 0; i < vsq.TempoTable.Count; i++ ) {
                    replace.TempoTable.Add( (TempoTableEntry)vsq.TempoTable[i].Clone() );
                }
                replace.updateTempoInfo();
                replace.updateTotalClocks();
            }

            if ( m_midi_imexport_dialog.Timesig ) {
                // 拍子をリプレースする場合
                replace.TimesigTable.Clear();
                for ( int i = 0; i < vsq.TimesigTable.Count; i++ ) {
                    replace.TimesigTable.Add( (TimeSigTableEntry)vsq.TimesigTable[i].Clone() );
                }
                replace.updateTimesigInfo();
            }

            foreach ( int track in add_track ) {
                if ( replace.Track.Count + 1 >= 16 ) {
                    break;
                }
                if ( !m_midi_imexport_dialog.Tempo ) {
                    // テンポをリプレースしない場合。インポートするトラックのクロックを調節する
                    for ( Iterator itr = vsq.Track[track].getEventIterator(); itr.hasNext(); ) {
                        VsqEvent item = (VsqEvent)itr.next();
                        if ( item.ID.type == VsqIDType.Singer && item.Clock == 0 ) {
                            continue;
                        }
                        int clock = item.Clock;
                        double sec_start = vsq.getSecFromClock( clock ) - premeasure_sec_vsq + premeasure_sec_replace;
                        double sec_end = vsq.getSecFromClock( clock + item.ID.Length ) - premeasure_sec_vsq + premeasure_sec_replace;
                        int clock_start = (int)replace.getClockFromSec( sec_start );
                        int clock_end = (int)replace.getClockFromSec( sec_end );
                        item.Clock = clock_start;
                        item.ID.Length = clock_end - clock_start;
                        if ( item.ID.VibratoHandle != null ) {
                            double sec_vib_start = vsq.getSecFromClock( clock + item.ID.VibratoDelay ) - premeasure_sec_vsq + premeasure_sec_replace;
                            int clock_vib_start = (int)replace.getClockFromSec( sec_vib_start );
                            item.ID.VibratoDelay = clock_vib_start - clock_start;
                            item.ID.VibratoHandle.Length = clock_end - clock_vib_start;
                        }
                    }

                    // コントロールカーブをシフト
                    foreach ( CurveType ct in AppManager.CURVE_USAGE ) {
                        VsqBPList item = vsq.Track[track].getCurve( ct.Name );
                        if ( item == null ) {
                            continue;
                        }
                        VsqBPList repl = new VsqBPList( item.Default, item.Minimum, item.Maximum );
                        for ( int i = 0; i < item.getCount(); i++ ) {
                            int clock = item.getKeyClock( i );
                            int value = item.getElement( i );
                            double sec = vsq.getSecFromClock( clock ) - premeasure_sec_vsq + premeasure_sec_replace;
                            if ( sec >= premeasure_sec_replace ) {
                                int clock_new = (int)replace.getClockFromSec( sec );
                                repl.add( clock_new, value );
                            }
                        }
                        vsq.Track[track].setCurve( ct.Name, repl );
                    }

                    // ベジエカーブをシフト
                    foreach ( CurveType ct in AppManager.CURVE_USAGE ) {
                        List<BezierChain> list = vsq.AttachedCurves[track - 1][ct];
                        if ( list == null ) {
                            continue;
                        }
                        foreach ( BezierChain chain in list ) {
                            foreach ( BezierPoint point in chain.points ) {
                                PointD bse = new PointD( replace.getClockFromSec( vsq.getSecFromClock( point.Base.X ) - premeasure_sec_vsq + premeasure_sec_replace ),
                                                         point.Base.Y );
                                PointD ctrl_r = new PointD( replace.getClockFromSec( vsq.getSecFromClock( point.m_control_left.X ) - premeasure_sec_vsq + premeasure_sec_replace ),
                                                            point.m_control_left.Y );
                                PointD ctrl_l = new PointD( replace.getClockFromSec( vsq.getSecFromClock( point.m_control_right.X ) - premeasure_sec_vsq + premeasure_sec_replace ),
                                                            point.m_control_right.Y );
                                point.Base = bse;
                                point.m_control_left = ctrl_l;
                                point.m_control_right = ctrl_r;
                            }
                        }
                    }
                }
                replace.Track.Add( vsq.Track[track] );
                replace.AttachedCurves.Add( vsq.AttachedCurves[track - 1] );
                replace.m_pitch.Add( vsq.m_pitch[track - 1] );
            }

            // コマンドを発行し、実行
            CadenciiCommand run = VsqFileEx.generateCommandReplace( replace );
            AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
            Edited = true;
        }

        private void commonFileOpen_Click( object sender, EventArgs e ) {
            if ( !DirtyCheck() ) {
                return;
            }
            DialogResult dr = DialogResult.Cancel;
            if ( AppManager.EditorConfig.UseCustomFileDialog ) {
                using ( FileDialog fd = new FileDialog( FileDialog.DialogMode.Open ) ) {
                    if ( openXmlVsqDialog.FileName != "" ) {
                        fd.FileName = openXmlVsqDialog.FileName;
                    }
                    fd.Filter = openXmlVsqDialog.Filter;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        openXmlVsqDialog.FileName = fd.FileName;
                    }
                }
            } else {
                //openXmlVsqDialog
                dr = openXmlVsqDialog.ShowDialog();
            }
            if ( dr == DialogResult.OK ) {
                if ( AppManager.Playing ) {
                    AppManager.Playing = false;
                }
                OpenVsqCore( openXmlVsqDialog.FileName );
                ClearExistingData();
                Edited = false;
                m_mixer_dlg.UpdateStatus();
                ClearTempWave();
#if USE_DOBJ
                UpdateDrawObjectList();
#endif
                RefreshScreen();
            }
        }

        private void commonFileNew_Click( object sender, EventArgs e ) {
            if ( !DirtyCheck() ) {
                return;
            }
            AppManager.Selected = 1;
            AppManager.SetVsqFile( new VsqFileEx( AppManager.EditorConfig.DefaultSingerName, AppManager.EditorConfig.DefaultPreMeasure, 4, 4, 500000 ) );
            ClearExistingData();
            Edited = false;
            m_mixer_dlg.UpdateStatus();
            ClearTempWave();
#if USE_DOBJ
            UpdateDrawObjectList();
#endif
#if PROPRETY_WINDOW
            InitContextProperty();
#endif
            RefreshScreen();
        }

        private void menuFileNew_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Create new project." );
        }

        private void menuFileOpen_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Open Cadencii project." );
        }

        private void menuFileSave_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Save current project." );
        }

        private void menuFileSaveNamed_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Save current project with new name." );
        }

        private void menuFileOpenVsq_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Open VSQ / VOCALOID MIDI and create new project." );
        }

        private void menuFileOpenUst_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Open UTAU project and create new project." );
        }

        private void menuFileImport_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Import." );
        }

        private void menuFileImportVsq_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Import VSQ / VOCALOID MIDI." );
        }

        private void menuFileImportMidi_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Import Standard MIDI." );
        }

        private void menuFileExportWave_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Export to WAVE file." );
        }

        private void menuFileExportMidi_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Export to Standard MIDI." );
        }

        private void menuFileRecent_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Recent projects." );
        }

        private void menuFileQuit_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Close this window." );
        }
        #endregion

        #region menuSetting*
        private void menuSettingDefaultSingerStyle_Click( object sender, EventArgs e ) {
            using ( FormSingerStyleConfig dlg = new FormSingerStyleConfig( _( "Default Singer Style" ), true ) ) {
                dlg.PMBendDepth = AppManager.EditorConfig.DefaultPMBendDepth;
                dlg.PMBendLength = AppManager.EditorConfig.DefaultPMBendLength;
                dlg.PMbPortamentoUse = AppManager.EditorConfig.DefaultPMbPortamentoUse;
                dlg.DEMdecGainRate = AppManager.EditorConfig.DefaultDEMdecGainRate;
                dlg.DEMaccent = AppManager.EditorConfig.DefaultDEMaccent;

                dlg.Location = GetFormPreferedLocation( dlg );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    if ( dlg.ApplyCurrentTrack ) {
                        VsqTrack copy = (VsqTrack)AppManager.VsqFile.Track[AppManager.Selected].Clone();
                        bool changed = false;
                        for ( int i = 0; i < copy.getEventCount(); i++ ) {
                            if ( copy.getEvent( i ).ID.type == VsqIDType.Anote ) {
                                copy.getEvent( i ).ID.PMBendDepth = dlg.PMBendDepth;
                                copy.getEvent( i ).ID.PMBendLength = dlg.PMBendLength;
                                copy.getEvent( i ).ID.PMbPortamentoUse = dlg.PMbPortamentoUse;
                                copy.getEvent( i ).ID.DEMdecGainRate = dlg.DEMdecGainRate;
                                copy.getEvent( i ).ID.DEMaccent = dlg.DEMaccent;
                                changed = true;
                            }
                        }
                        if ( changed ) {
                            CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( AppManager.Selected, 
                                                                                         copy,
                                                                                         AppManager.VsqFile.AttachedCurves[AppManager.Selected - 1],
                                                                                         AppManager.VsqFile.getPitchCurve( AppManager.Selected ) );
                            AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
#if USE_DOBJ
                            UpdateDrawObjectList();
#endif
                            RefreshScreen();
                        }
                    }
                    AppManager.EditorConfig.DefaultPMBendDepth = dlg.PMBendDepth;
                    AppManager.EditorConfig.DefaultPMBendLength = dlg.PMBendLength;
                    AppManager.EditorConfig.DefaultPMbPortamentoUse = dlg.PMbPortamentoUse;
                    AppManager.EditorConfig.DefaultDEMdecGainRate = dlg.DEMdecGainRate;
                    AppManager.EditorConfig.DefaultDEMaccent = dlg.DEMaccent;
                }
            }
        }

        private void menuSettingMidi_Click( object sender, EventArgs e ) {
            using ( FormMidiConfig form = new FormMidiConfig() ) {
                form.Location = GetFormPreferedLocation( form );
                if ( form.ShowDialog() == DialogResult.OK ) {

                }
            }
        }

        private void menuSettingPreference_Click( object sender, EventArgs e ) {
            if ( m_preference_dlg == null ) {
                m_preference_dlg = new Preference();
            }
            m_preference_dlg.BaseFont = new Font( AppManager.EditorConfig.BaseFontName, 9 );
            m_preference_dlg.ScreenFont = new Font( AppManager.EditorConfig.ScreenFontName, 9 );
            m_preference_dlg.CounterFont = new Font( AppManager.EditorConfig.CounterFontName, 9 );
            m_preference_dlg.WheelOrder = AppManager.EditorConfig.WheelOrder;
            m_preference_dlg.CursorFixed = AppManager.EditorConfig.CursorFixed;
            m_preference_dlg.DefaultVibratoLength = AppManager.EditorConfig.DefaultVibratoLength;
            m_preference_dlg.AutoVibratoMinimumLength = AppManager.EditorConfig.AutoVibratoMinimumLength;
            m_preference_dlg.AutoVibratoType = AppManager.EditorConfig.AutoVibratoType;
            m_preference_dlg.EnableAutoVibrato = AppManager.EditorConfig.EnableAutoVibrato;
            m_preference_dlg.PreMeasure = AppManager.VsqFile.getPreMeasure();
            m_preference_dlg.PreSendTime = AppManager.EditorConfig.PreSendTime;
            m_preference_dlg.ControlCurveResolution = AppManager.EditorConfig.ControlCurveResolution;
            m_preference_dlg.DefaultSingerName = AppManager.EditorConfig.DefaultSingerName;
            m_preference_dlg.ScrollHorizontalOnWheel = AppManager.EditorConfig.ScrollHorizontalOnWheel;
            m_preference_dlg.MaximumFrameRate = AppManager.EditorConfig.MaximumFrameRate;
            m_preference_dlg.Platform = AppManager.EditorConfig.Platform;
            m_preference_dlg.KeepLyricInputMode = AppManager.EditorConfig.KeepLyricInputMode;
            m_preference_dlg.PxTrackHeight = AppManager.EditorConfig.PxTrackHeight;
            m_preference_dlg.MouseHoverTime = AppManager.EditorConfig.MouseHoverTime;
            m_preference_dlg.PlayPreviewWhenRightClick = AppManager.EditorConfig.PlayPreviewWhenRightClick;
            m_preference_dlg.CurveSelectingQuantized = AppManager.EditorConfig.CurveSelectingQuantized;
            m_preference_dlg.CurveVisibleAccent = AppManager.EditorConfig.CurveVisibleAccent;
            m_preference_dlg.CurveVisibleBre = AppManager.EditorConfig.CurveVisibleBreathiness;
            m_preference_dlg.CurveVisibleBri = AppManager.EditorConfig.CurveVisibleBrightness;
            m_preference_dlg.CurveVisibleCle = AppManager.EditorConfig.CurveVisibleClearness;
            m_preference_dlg.CurveVisibleDecay = AppManager.EditorConfig.CurveVisibleDecay;
            m_preference_dlg.CurveVisibleDyn = AppManager.EditorConfig.CurveVisibleDynamics;
            m_preference_dlg.CurveVisibleGen = AppManager.EditorConfig.CurveVisibleGendorfactor;
            m_preference_dlg.CurveVisibleOpe = AppManager.EditorConfig.CurveVisibleOpening;
            m_preference_dlg.CurveVisiblePitch = AppManager.EditorConfig.CurveVisiblePitch;
            m_preference_dlg.CurveVisiblePor = AppManager.EditorConfig.CurveVisiblePortamento;
            m_preference_dlg.CurveVisibleVel = AppManager.EditorConfig.CurveVisibleVelocity;
            m_preference_dlg.CurveVisibleVibratoDepth = AppManager.EditorConfig.CurveVisibleVibratoDepth;
            m_preference_dlg.CurveVisibleVibratoRate = AppManager.EditorConfig.CurveVisibleVibratoRate;
            m_preference_dlg.CurveVisibleFx2Depth = AppManager.EditorConfig.CurveVisibleFx2Depth;
            m_preference_dlg.CurveVisibleHarmonics = AppManager.EditorConfig.CurveVisibleHarmonics;
            m_preference_dlg.CurveVisibleReso1 = AppManager.EditorConfig.CurveVisibleReso1;
            m_preference_dlg.CurveVisibleReso2 = AppManager.EditorConfig.CurveVisibleReso2;
            m_preference_dlg.CurveVisibleReso3 = AppManager.EditorConfig.CurveVisibleReso3;
            m_preference_dlg.CurveVisibleReso4 = AppManager.EditorConfig.CurveVisibleReso4;
            m_preference_dlg.MidiInPort = AppManager.EditorConfig.MidiInPort.PortNumber;
            m_preference_dlg.InvokeWithWine = AppManager.EditorConfig.InvokeUtauCoreWithWine;
            m_preference_dlg.PathResampler = AppManager.EditorConfig.PathResampler;
            m_preference_dlg.PathWavtool = AppManager.EditorConfig.PathWavtool;
            m_preference_dlg.UtauSingers = AppManager.EditorConfig.UtauSingers;
            m_preference_dlg.UseCustomFileDialog = AppManager.EditorConfig.UseCustomFileDialog;
            m_preference_dlg.SelfDeRomantization = AppManager.EditorConfig.SelfDeRomanization;

            m_preference_dlg.Location = GetFormPreferedLocation( m_preference_dlg );
            
            if ( m_preference_dlg.ShowDialog() == DialogResult.OK ) {
                AppManager.EditorConfig.BaseFontName = m_preference_dlg.BaseFont.Name;
                AppManager.EditorConfig.BaseFontSize = m_preference_dlg.BaseFont.SizeInPoints;
                UpdateMenuFonts();

                AppManager.EditorConfig.ScreenFontName = m_preference_dlg.ScreenFont.Name;
                AppManager.EditorConfig.CounterFontName = m_preference_dlg.CounterFont.Name;
                AppManager.EditorConfig.WheelOrder = m_preference_dlg.WheelOrder;
                AppManager.EditorConfig.CursorFixed = m_preference_dlg.CursorFixed;

                AppManager.EditorConfig.DefaultVibratoLength = m_preference_dlg.DefaultVibratoLength;
                AppManager.EditorConfig.AutoVibratoMinimumLength = m_preference_dlg.AutoVibratoMinimumLength;
                AppManager.EditorConfig.AutoVibratoType = m_preference_dlg.AutoVibratoType;

                AppManager.EditorConfig.EnableAutoVibrato = m_preference_dlg.EnableAutoVibrato;
                AppManager.EditorConfig.PreSendTime = m_preference_dlg.PreSendTime;
                AppManager.EditorConfig.DefaultPreMeasure = m_preference_dlg.PreMeasure;
                if ( m_preference_dlg.PreMeasure != AppManager.VsqFile.getPreMeasure() ) {
                    CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandChangePreMeasure( m_preference_dlg.PreMeasure ) );
                    AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                    Edited = true;
                }
                AppManager.EditorConfig.Language = m_preference_dlg.Language;
                if ( Messaging.Language != AppManager.EditorConfig.Language ) {
                    Messaging.Language = AppManager.EditorConfig.Language;
                    ApplyLanguage();
                    m_preference_dlg.ApplyLanguage();
                    m_mixer_dlg.ApplyLanguage();
                    if ( m_versioninfo != null && !m_versioninfo.IsDisposed ) {
                        m_versioninfo.ApplyLanguage();
                    }
                    AppManager.NotePropertyDlg.ApplyLanguage();
                    AppManager.NotePropertyPanel.UpdateValue( AppManager.Selected );
                }

                AppManager.EditorConfig.ControlCurveResolution = m_preference_dlg.ControlCurveResolution;
                AppManager.EditorConfig.DefaultSingerName = m_preference_dlg.DefaultSingerName;
                AppManager.EditorConfig.ScrollHorizontalOnWheel = m_preference_dlg.ScrollHorizontalOnWheel;
                AppManager.EditorConfig.MaximumFrameRate = m_preference_dlg.MaximumFrameRate;
                int fps = 1000 / AppManager.EditorConfig.MaximumFrameRate;
                timer.Interval = (fps <= 0) ? 1 : fps;
                AppManager.EditorConfig.Platform = m_preference_dlg.Platform;
                s_modifier_key = ((AppManager.EditorConfig.Platform == Platform.Macintosh) ? Keys.Menu : Keys.Control);
                ApplyShortcut();
                AppManager.EditorConfig.KeepLyricInputMode = m_preference_dlg.KeepLyricInputMode;
                if ( AppManager.EditorConfig.PxTrackHeight != m_preference_dlg.PxTrackHeight ) {
                    AppManager.EditorConfig.PxTrackHeight = m_preference_dlg.PxTrackHeight;
#if USE_DOBJ
                    UpdateDrawObjectList();
#endif
                }
                AppManager.EditorConfig.MouseHoverTime = m_preference_dlg.MouseHoverTime;
                AppManager.EditorConfig.PlayPreviewWhenRightClick = m_preference_dlg.PlayPreviewWhenRightClick;
                AppManager.EditorConfig.CurveSelectingQuantized = m_preference_dlg.CurveSelectingQuantized;

                AppManager.EditorConfig.CurveVisibleAccent = m_preference_dlg.CurveVisibleAccent;
                AppManager.EditorConfig.CurveVisibleBreathiness = m_preference_dlg.CurveVisibleBre;
                AppManager.EditorConfig.CurveVisibleBrightness = m_preference_dlg.CurveVisibleBri;
                AppManager.EditorConfig.CurveVisibleClearness = m_preference_dlg.CurveVisibleCle;
                AppManager.EditorConfig.CurveVisibleDecay = m_preference_dlg.CurveVisibleDecay;
                AppManager.EditorConfig.CurveVisibleDynamics = m_preference_dlg.CurveVisibleDyn;
                AppManager.EditorConfig.CurveVisibleGendorfactor = m_preference_dlg.CurveVisibleGen;
                AppManager.EditorConfig.CurveVisibleOpening = m_preference_dlg.CurveVisibleOpe;
                AppManager.EditorConfig.CurveVisiblePitch = m_preference_dlg.CurveVisiblePitch;
                AppManager.EditorConfig.CurveVisiblePortamento = m_preference_dlg.CurveVisiblePor;
                AppManager.EditorConfig.CurveVisibleVelocity = m_preference_dlg.CurveVisibleVel;
                AppManager.EditorConfig.CurveVisibleVibratoDepth = m_preference_dlg.CurveVisibleVibratoDepth;
                AppManager.EditorConfig.CurveVisibleVibratoRate = m_preference_dlg.CurveVisibleVibratoRate;
                AppManager.EditorConfig.CurveVisibleFx2Depth = m_preference_dlg.CurveVisibleFx2Depth;
                AppManager.EditorConfig.CurveVisibleHarmonics = m_preference_dlg.CurveVisibleHarmonics;
                AppManager.EditorConfig.CurveVisibleReso1 = m_preference_dlg.CurveVisibleReso1;
                AppManager.EditorConfig.CurveVisibleReso2 = m_preference_dlg.CurveVisibleReso2;
                AppManager.EditorConfig.CurveVisibleReso3 = m_preference_dlg.CurveVisibleReso3;
                AppManager.EditorConfig.CurveVisibleReso4 = m_preference_dlg.CurveVisibleReso4;

                AppManager.EditorConfig.MidiInPort.PortNumber = m_preference_dlg.MidiInPort;
                UpdateMidiInStatus();
                ReloadMidiIn();

                AppManager.EditorConfig.InvokeUtauCoreWithWine = m_preference_dlg.InvokeWithWine;
                AppManager.EditorConfig.PathResampler = m_preference_dlg.PathResampler;
                AppManager.EditorConfig.PathWavtool = m_preference_dlg.PathWavtool;
                AppManager.EditorConfig.UtauSingers.Clear();
                foreach ( SingerConfig sc in m_preference_dlg.UtauSingers ) {
                    AppManager.EditorConfig.UtauSingers.Add( (SingerConfig)sc.Clone() );
                }
                AppManager.EditorConfig.UseCustomFileDialog = m_preference_dlg.UseCustomFileDialog;
                AppManager.EditorConfig.SelfDeRomanization = m_preference_dlg.SelfDeRomantization;

                List<CurveType> visible_curves = new List<CurveType>();
                trackSelector.ClearViewingCurve();

                UpdateTrackSelectorVisibleCurve();
                UpdateRendererMenu();

                AppManager.SaveConfig();
                ApplyLanguage();
                UpdateTrackSelectorVisibleCurve();
                UpdateScriptShortcut();
#if USE_DOBJ
                UpdateDrawObjectList();
#endif
                RefreshScreen();
            }
        }

        private void menuSettingShortcut_Click( object sender, EventArgs e ) {
            Dictionary<string, ValuePair<string, Keys[]>> dict = new Dictionary<string, ValuePair<string, Keys[]>>();
            Dictionary<string, Keys[]> configured = AppManager.EditorConfig.GetShortcutKeysDictionary();

            // スクリプトのToolStripMenuITemを蒐集
            List<string> script_shortcut = new List<string>();
            foreach ( ToolStripItem tsi in menuScript.DropDownItems ) {
                if ( tsi is ToolStripMenuItem ) {
                    ToolStripMenuItem tsmi = (ToolStripMenuItem)tsi;
                    if ( tsmi.DropDownItems.Count == 1 && tsmi.DropDownItems[0] is ToolStripMenuItem ) {
                        ToolStripMenuItem item = (ToolStripMenuItem)tsmi.DropDownItems[0];
                        script_shortcut.Add( item.Name );
                        if ( !configured.ContainsKey( item.Name ) ) {
                            configured.Add( item.Name, new Keys[] { } );
                        }
                    }
                }
            }

            foreach ( string name in configured.Keys ) {
                ToolStripMenuItem menu = SearchMenuItemFromName( name );
                if ( menu != null ) {
                    string parent = "";
                    if ( menu.OwnerItem != null && menu.OwnerItem.Name != menuHidden.Name ) {
                        string s = menu.OwnerItem.Text;
                        int i = s.IndexOf( "(&" );
                        if ( i > 0 ) {
                            s = s.Substring( 0, i );
                        }
                        parent = s + " -> ";
                    }
                    string s1 = menu.Text;
                    int i1 = s1.IndexOf( "(&" );
                    if ( i1 > 0 ) {
                        s1 = s1.Substring( 0, i1 );
                    }
                    if ( script_shortcut.Contains( name ) ) {
                        string s2 = menuScript.Text;
                        int i2 = s2.IndexOf( "(&" );
                        if ( i2 > 0 ) {
                            s2 = s2.Substring( 0, i2 );
                        }
                        parent = s2 + " -> " + parent;
                    }
                    dict.Add( parent + s1, new ValuePair<string, Keys[]>( name, configured[name] ) );
                }
            }

            using ( FormShortcutKeys form = new FormShortcutKeys( dict ) ) {
                form.Location = GetFormPreferedLocation( form );
                if ( form.ShowDialog() == DialogResult.OK ) {
                    Dictionary<string, ValuePair<string, Keys[]>> res = form.Result;
                    foreach ( string display in res.Keys ) {
                        string name = res[display].Key;
                        Keys[] keys = res[display].Value;
                        bool found = false;
                        for ( int i = 0; i < AppManager.EditorConfig.ShortcutKeys.Count; i++ ) {
                            if ( AppManager.EditorConfig.ShortcutKeys[i].Key == name ) {
                                AppManager.EditorConfig.ShortcutKeys[i].Value = keys;
                                found = true;
                                break;
                            }
                        }
                        if ( !found ) {
                            AppManager.EditorConfig.ShortcutKeys.Add( new ValuePair<string, Keys[]>( name, keys ) );
                        }
                    }
                    ApplyShortcut();
                    AppManager.NotePropertyDlg.FormCloseShortcutKey = AppManager.EditorConfig.GetShortcutKeyFor( menuVisualProperty );
                }
            }
        }

        private void menuSettingBgmSetSound_Click( object sender, EventArgs e ) {
            if ( AppManager.Playing ) {
                return;
            }
            using ( OpenFileDialog ofd = new OpenFileDialog() ) {
                ofd.Filter = _( "MP3 File(*.mp3)|*.mp3" ) + "|" + _( "Wave File(*.wav)|*.wav" ) + "|" + _( "All Files(*.*)|*.*" );
                if ( ofd.ShowDialog() == DialogResult.OK ) {
                    //AppManager.BgmPlayer.Load( ofd.FileName );
                }
            }
        }

        private void menuSettingGameControlerLoad_Click( object sender, EventArgs e ) {
            GameControlerLoad();
        }

        private void menuSettingGameControlerRemove_Click( object sender, EventArgs e ) {
            GameControlerRemove();
        }

        private void menuSettingGameControlerSetting_Click( object sender, EventArgs e ) {
            using ( FormGameControlerConfig dlg = new FormGameControlerConfig() ) {
                dlg.Location = GetFormPreferedLocation( dlg );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    AppManager.EditorConfig.GameControlerRectangle = dlg.Rectangle;
                    AppManager.EditorConfig.GameControlerTriangle = dlg.Triangle;
                    AppManager.EditorConfig.GameControlerCircle = dlg.Circle;
                    AppManager.EditorConfig.GameControlerCross = dlg.Cross;
                    AppManager.EditorConfig.GameControlL1 = dlg.L1;
                    AppManager.EditorConfig.GameControlL2 = dlg.L2;
                    AppManager.EditorConfig.GameControlR1 = dlg.R1;
                    AppManager.EditorConfig.GameControlR2 = dlg.R2;
                    AppManager.EditorConfig.GameControlSelect = dlg.Select;
                    AppManager.EditorConfig.GameControlStart = dlg.Start;
                    AppManager.EditorConfig.GameControlPovDown = dlg.PovDown;
                    AppManager.EditorConfig.GameControlPovLeft = dlg.PovLeft;
                    AppManager.EditorConfig.GameControlPovUp = dlg.PovUp;
                    AppManager.EditorConfig.GameControlPovRight = dlg.PovRight;
                }
            }
        }
        #endregion

        #region menuEdit*
        private void menuEditDelete_Click( object sender, EventArgs e ) {
            DeleteEvent();
        }

        private void commonEditPaste_Click( object sender, EventArgs e ) {
            PasteEvent();
        }

        private void commonEditCopy_Click( object sender, EventArgs e ) {
#if DEBUG
            AppManager.DebugWriteLine( "commonEditCopy_Click" );
#endif
            CopyEvent();
        }

        private void commonEditCut_Click( object sender, EventArgs e ) {
            CutEvent();
        }

        private void menuEdit_DropDownOpening( object sender, EventArgs e ) {
            UpdateCopyAndPasteButtonStatus();
        }

        private void commonEditUndo_Click( object sender, EventArgs e ) {
#if DEBUG
            AppManager.DebugWriteLine( "menuEditUndo_Click" );
#endif
            Undo();
            RefreshScreen();
        }


        private void commonEditRedo_Click( object sender, EventArgs e ) {
#if DEBUG
            AppManager.DebugWriteLine( "menuEditRedo_Click" );
#endif
            Redo();
            RefreshScreen();
        }

        private void menuEditSelectAllEvents_Click( object sender, EventArgs e ) {
            SelectAllEvent();
        }

        private void menuEditSelectAll_Click( object sender, EventArgs e ) {
            SelectAll();
        }

        private void menuEditAutoNormalizeMode_Click( object sender, EventArgs e ) {
            AppManager.AutoNormalize = !AppManager.AutoNormalize;
            menuEditAutoNormalizeMode.Checked = AppManager.AutoNormalize;
        }

        private void menuEditUndo_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Undo." );
        }

        private void menuEditRedo_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Redo." );
        }

        private void menuEditCut_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Cut selected items." );
        }

        private void menuEditCopy_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Copy selected items." );
        }

        private void menuEditPaste_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Paste copied items to current song position." );
        }

        private void menuEditDelete_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Delete selected items." );
        }

        private void menuEditAutoNormalizeMode_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Avoid automaticaly polyphonic editing." );
        }

        private void menuEditSelectAll_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Select all items and control curves of current track." );
        }

        private void menuEditSelectAllEvents_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Select all items of current track." );
        }
        #endregion

        #region menuLyric*
        private void menuLyric_DropDownOpening( object sender, EventArgs e ) {
            menuLyricExpressionProperty.Enabled = (AppManager.SelectedEvent.LastSelected != null);
        }

        private void menuLyricExpressionProperty_Click( object sender, EventArgs e ) {
            NoteExpressionProperty();
        }

        private void menuLyricDictionary_Click( object sender, EventArgs e ) {
            using ( FormWordDictionary dlg = new FormWordDictionary() ) {
                dlg.Location = GetFormPreferedLocation( dlg );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    List<KeyValuePair<string, bool>> result = dlg.Result;
                    SymbolTable.changeOrder( result.ToArray() );
                }
            }
        }

        private void menuLyricVibratoProperty_Click( object sender, EventArgs e ) {
            NoteVibratoProperty();
        }
        #endregion

        #region menuJob
        private void menuJobRealTime_Click( object sender, EventArgs e ) {
            if ( !AppManager.Playing ) {
                m_adding = null;
                AppManager.EditMode = EditMode.Realtime;
                AppManager.Playing = true;
                menuJobRealTime.Text = _( "Stop Realtime Input" );
            } else {
                timer.Stop();
                AppManager.Playing = false;
                AppManager.EditMode = EditMode.None;
                menuJobRealTime.Text = _( "Start Realtime Input" );
            }
        }

        private void menuJobReloadVsti_Click( object sender, EventArgs e ) {
            //VSTiProxy.ReloadPlugin(); //todo: FormMain+menuJobReloadVsti_Click
        }
        
        private void menuJob_DropDownOpening( object sender, EventArgs e ) {
#if DEBUG
            AppManager.DebugWriteLine( "menuJob_DropDownOpening" );
            AppManager.DebugWriteLine( "    menuJob.Bounds=" + menuJob.Bounds );
#endif
            if ( AppManager.SelectedEvent.Count <= 1 ) {
                menuJobConnect.Enabled = false;
            } else {
                // menuJobConnect(音符の結合)がEnableされるかどうかは、選択されている音符がピアノロール上で連続かどうかで決まる
                int[] list = new int[AppManager.SelectedEvent.Count];
                for ( int i = 0; i < AppManager.VsqFile.Track[AppManager.Selected].getEventCount(); i++ ) {
                    int count = -1;
                    foreach ( SelectedEventEntry item in AppManager.SelectedEvent.GetEnumerator() ) {
                        int key = item.Original.InternalID;
                        count++;
                        if ( key == AppManager.VsqFile.Track[AppManager.Selected].getEvent( i ).InternalID ) {
                            list[count] = i;
                            break;
                        }
                    }
                }
                bool changed = true;
                while ( changed ) {
                    changed = false;
                    for ( int i = 0; i < list.Length - 1; i++ ) {
                        if ( list[i] > list[i + 1] ) {
                            int b = list[i];
                            list[i] = list[i + 1];
                            list[i + 1] = b;
                            changed = true;
                        }
                    }
                }
                bool continued = true;
                for ( int i = 0; i < list.Length - 1; i++ ) {
                    if ( list[i] + 1 != list[i + 1] ) {
                        continued = false;
                        break;
                    }
                }
                menuJobConnect.Enabled = continued;
            }

            menuJobLyric.Enabled = AppManager.SelectedEvent.LastSelected != null;
        }

        private void menuJobLyric_Click( object sender, EventArgs e ) {
            ImportLyric();
        }

        private void menuJobConnect_Click( object sender, EventArgs e ) {
            int count = AppManager.SelectedEvent.Count;
            int[] clocks = new int[count];
            VsqID[] ids = new VsqID[count];
            int[] internalids = new int[count];
            int i = -1;
            foreach ( SelectedEventEntry item in AppManager.SelectedEvent.GetEnumerator() ) {
                i++;
                clocks[i] = item.Original.Clock;
                ids[i] = (VsqID)item.Original.ID.Clone();
                internalids[i] = item.Original.InternalID;
            }
            bool changed = true;
            while ( changed ) {
                changed = false;
                for ( int j = 0; j < clocks.Length - 1; j++ ) {
                    if ( clocks[j] > clocks[j + 1] ) {
                        int b = clocks[j];
                        clocks[j] = clocks[j + 1];
                        clocks[j + 1] = b;
                        VsqID a = ids[j];
                        ids[j] = ids[j + 1];
                        ids[j + 1] = a;
                        changed = true;
                        b = internalids[j];
                        internalids[j] = internalids[j + 1];
                        internalids[j + 1] = b;
                    }
                }
            }

            for ( int j = 0; j < ids.Length - 1; j++ ) {
                ids[j].Length = clocks[j + 1] - clocks[j];
            }
            CadenciiCommand run = new CadenciiCommand( 
                VsqCommand.generateCommandEventChangeIDContaintsRange( AppManager.Selected, internalids, ids ) );
            AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
            Edited = true;
            this.Refresh();
        }

        private void menuJobInsertBar_Click( object sender, EventArgs e ) {
            int total_clock = AppManager.VsqFile.TotalClocks;
            int total_barcount = AppManager.VsqFile.getBarCountFromClock( total_clock ) + 1;
            using ( FormInsertBar dlg = new FormInsertBar( total_barcount ) ) {
                int current_clock = AppManager.CurrentClock;
                int barcount = AppManager.VsqFile.getBarCountFromClock( current_clock );
                int draft = barcount - AppManager.VsqFile.getPreMeasure() + 1;
                if ( draft <= 0 ) {
                    draft = 1;
                }
                dlg.Position = draft;

                dlg.Location = GetFormPreferedLocation( dlg );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    int pos = dlg.Position + AppManager.VsqFile.getPreMeasure() - 1;
                    int length = dlg.Length;

                    int clock_start = AppManager.VsqFile.getClockFromBarCount( pos );
                    int clock_end = AppManager.VsqFile.getClockFromBarCount( pos + length );
                    int dclock = clock_end - clock_start;
                    VsqFileEx temp = (VsqFileEx)AppManager.VsqFile.Clone();

                    for ( int track = 1; track < temp.Track.Count; track++ ) {
                        BezierCurves newbc = new BezierCurves();
                        foreach ( CurveType ct in AppManager.CURVE_USAGE ) {
                            int index = ct.Index;
                            if ( index < 0 ) {
                                continue;
                            }

                            List<BezierChain> list = new List<BezierChain>();
                            foreach ( BezierChain bc in temp.AttachedCurves[track -1][ct] ) {
                            //foreach ( int key in temp.AttachedCurves[track - 1][ct].Keys ) {
                                //BezierChain bc = temp.AttachedCurves[track - 1][ct][key];
                                if ( bc.Count < 2 ) {
                                    continue;
                                }
                                int chain_start = (int)bc.points[0].Base.X;
                                int chain_end = (int)bc.points[bc.points.Count - 1].Base.X;

                                if ( clock_start <= chain_start ) {
                                    for ( int i = 0; i < bc.points.Count; i++ ) {
                                        PointD t = bc.points[i].Base;
                                        bc.points[i].Base = new PointD( t.X + dclock, t.Y );
                                    }
                                    list.Add( bc );
                                } else if ( chain_start < clock_start && clock_start < chain_end ) {
                                    BezierChain adding1 = bc.ExtractPartialBezier( chain_start, clock_start );
                                    BezierChain adding2 = bc.ExtractPartialBezier( clock_start, chain_end );
                                    for ( int i = 0; i < adding2.points.Count; i++ ) {
                                        PointD t = adding2.points[i].Base;
                                        adding2.points[i].Base = new PointD( t.X + dclock, t.Y );
                                    }
                                    //PointD t2 = adding1.points[adding1.points.Count - 1].Base;
                                    adding1.points[adding1.points.Count - 1].ControlRightType = BezierControlType.None;
                                    /*BezierPoint bp = new BezierPoint( t2.X + dclock, t2.Y );
                                    bp.ControlLeftType = BezierControlType.None;
                                    bp.ControlRightType = BezierControlType.None;
                                    adding1.points.Add( bp );*/
                                    adding2.points[0].ControlLeftType = BezierControlType.None;
                                    for ( int i = 0; i < adding2.points.Count; i++ ) {
                                        adding1.points.Add( adding2.points[i] );
                                    }
                                    adding1.ID = bc.ID;
                                    list.Add( adding1 );
                                } else {
                                    list.Add( (BezierChain)bc.Clone() );
                                }
                            }

                            newbc[ct] = list;
                        }
                        temp.AttachedCurves[track - 1] = newbc;
                    }

                    for ( int track = 1; track < AppManager.VsqFile.Track.Count; track++ ) {
                        for ( int i = 0; i < temp.Track[track].getEventCount(); i++ ) {
                            if ( temp.Track[track].getEvent( i ).Clock >= clock_start ) {
                                temp.Track[track].getEvent( i ).Clock += dclock;
                            }
                        }
                        foreach ( CurveType curve in AppManager.CURVE_USAGE ) {
                            if ( curve.IsScalar || curve.IsAttachNote ) {
                                continue;
                            }
                            VsqBPList target;
                            VsqBPList src;
                            if ( curve == CurveType.Pitch ) {
                                target = temp.getPitchCurve( track );
                                src = AppManager.VsqFile.getPitchCurve( track );
                            } else {
                                target = temp.Track[track].getCurve( curve.Name );
                                src = AppManager.VsqFile.Track[track].getCurve( curve.Name );
                            }
                            target.clear();
                            for ( Iterator itr = src.keyClockIterator(); itr.hasNext(); ) {
                                int key = (int)itr.next();
                                if ( key >= clock_start ) {
                                    target.add( key + dclock, src.getValue( key ) );
                                } else {
                                    target.add( key, src.getValue( key ) );
                                }
                            }
                        }
                    }
                    for ( int i = 0; i < temp.TempoTable.Count; i++ ) {
                        if ( temp.TempoTable[i].Clock >= clock_start ) {
                            temp.TempoTable[i].Clock = temp.TempoTable[i].Clock + dclock;
                        }
                    }
                    for ( int i = 0; i < temp.TimesigTable.Count; i++ ) {
                        if ( temp.TimesigTable[i].Clock >= clock_start ) {
                            temp.TimesigTable[i].Clock = temp.TimesigTable[i].Clock + dclock;
                        }
                    }
                    temp.updateTempoInfo();
                    temp.updateTimesigInfo();

                    CadenciiCommand run = VsqFileEx.generateCommandReplace( temp );
                    AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                    Edited = true;
                    this.Refresh();
                }
            }
        }

        private void menuJobDeleteBar_Click( object sender, EventArgs e ) {
            int total_clock = AppManager.VsqFile.TotalClocks;
            int total_barcount = AppManager.VsqFile.getBarCountFromClock( total_clock ) + 1;
            int clock = AppManager.CurrentClock;
            int barcount = AppManager.VsqFile.getBarCountFromClock( clock );
            using ( FormDeleteBar dlg = new FormDeleteBar( total_barcount ) ) {
                int draft = barcount - AppManager.VsqFile.getPreMeasure() + 1;
                if ( draft <= 0 ) {
                    draft = 1;
                }
                dlg.Start = draft;
                dlg.End = draft + 1;

                dlg.Location = GetFormPreferedLocation( dlg );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    VsqFileEx temp = (VsqFileEx)AppManager.VsqFile.Clone();
                    int start = dlg.Start + AppManager.VsqFile.getPreMeasure() - 1;
                    int end = dlg.End + AppManager.VsqFile.getPreMeasure() - 1;
#if DEBUG
                    AppManager.DebugWriteLine( "FormMain+menuJobDeleteBar_Click" );
                    AppManager.DebugWriteLine( "    start,end=" + start + "," + end );
#endif
                    int clock_start = temp.getClockFromBarCount( start );
                    int clock_end = temp.getClockFromBarCount( end );
                    int dclock = clock_end - clock_start;
                    for ( int track = 1; track < temp.Track.Count; track++ ) {
                        BezierCurves newbc = new BezierCurves();
                        foreach ( CurveType ct in AppManager.CURVE_USAGE ) {
                            int index = ct.Index;
                            if ( index < 0 ) {
                                continue;
                            }

                            List<BezierChain> list = new List<BezierChain>();
                            foreach ( BezierChain bc in temp.AttachedCurves[track - 1][ct] ) {
                                if ( bc.Count < 2 ) {
                                    continue;
                                }
                                int chain_start = (int)bc.points[0].Base.X;
                                int chain_end = (int)bc.points[bc.points.Count - 1].Base.X;

                                if ( clock_start < chain_start && chain_start < clock_end && clock_end < chain_end ) {
                                    BezierChain adding = bc.ExtractPartialBezier( clock_end, chain_end );
                                    adding.ID = bc.ID;
                                    for ( int i = 0; i < adding.points.Count; i++ ) {
                                        PointD t = adding.points[i].Base;
                                        adding.points[i].Base = new PointD( t.X - dclock, t.Y );
                                    }
                                    list.Add( adding );
                                } else if ( chain_start < clock_start && clock_end < chain_end ) {
                                    BezierChain adding1 = bc.ExtractPartialBezier( chain_start, clock_start );
                                    adding1.ID = bc.ID;
                                    adding1.points[adding1.points.Count - 1].ControlRightType = BezierControlType.None;
                                    BezierChain adding2 = bc.ExtractPartialBezier( clock_end, chain_end );
                                    adding2.points[0].ControlLeftType = BezierControlType.None;
                                    PointD t = adding2.points[0].Base;
                                    adding2.points[0].Base = new PointD( t.X - dclock, t.Y );
                                    adding1.points.Add( adding2.points[0] );
                                    for ( int i = 1; i < adding2.points.Count; i++ ) {
                                        t = adding2.points[i].Base;
                                        adding2.points[i].Base = new PointD( t.X - dclock, t.Y );
                                        adding1.points.Add( adding2.points[i] );
                                    }
                                    list.Add( adding1 );
                                } else if ( chain_start < clock_start && clock_start < chain_end && chain_end < clock_end ) {
                                    BezierChain adding = bc.ExtractPartialBezier( chain_start, clock_start );
                                    adding.ID = bc.ID;
                                    list.Add( adding );
                                } else if ( clock_end <= chain_start || chain_end <= clock_start ) {
                                    if ( clock_end <= chain_start ) {
                                        for ( int i = 0; i < bc.points.Count; i++ ) {
                                            PointD t = bc.points[i].Base;
                                            bc.points[i].Base = new PointD( t.X - dclock, t.Y );
                                        }
                                    }
                                    list.Add( (BezierChain)bc.Clone() );
                                }
                            }

                            newbc[ct] = list;
                        }
                        temp.AttachedCurves[track - 1] = newbc;
                    }

                    temp.removePart( clock_start, clock_end );
                    CadenciiCommand run = VsqFileEx.generateCommandReplace( temp );
                    AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                    Edited = true;
                    this.Refresh();
                }
            }
        }

        private void menuJobNormalize_Click( object sender, EventArgs e ) {
            VsqFile work = (VsqFile)AppManager.VsqFile.Clone();
            int track = AppManager.Selected;
            bool changed = true;
            bool total_changed = false;

            // 最初、開始時刻が同じになっている奴を削除
            while ( changed ) {
                changed = false;
                for ( int i = 0; i < work.Track[track].getEventCount() - 1; i++ ) {
                    int clock = work.Track[track].getEvent( i ).Clock;
                    int id = work.Track[track].getEvent( i ).InternalID;
                    for ( int j = i + 1; j < work.Track[track].getEventCount(); j++ ) {
                        if ( clock == work.Track[track].getEvent( j ).Clock ) {
                            if ( id < work.Track[track].getEvent( j ).InternalID ) { //内部IDが小さい＝より高年齢（音符追加時刻が古い）
                                work.Track[track].removeEvent( i );
                            } else {
                                work.Track[track].removeEvent( j );
                            }
                            changed = true;
                            total_changed = true;
                            break;
                        }
                    }
                    if ( changed ) {
                        break;
                    }
                }
            }

            changed = true;
            while ( changed ) {
                changed = false;
                for ( int i = 0; i < work.Track[track].getEventCount() - 1; i++ ) {
                    int start_clock = work.Track[track].getEvent( i ).Clock;
                    int end_clock = work.Track[track].getEvent( i ).ID.Length + start_clock;
                    for ( int j = i + 1; j < work.Track[track].getEventCount(); j++ ) {
                        int this_start_clock = work.Track[track].getEvent( j ).Clock;
                        if ( this_start_clock < end_clock ) {
                            work.Track[track].getEvent( i ).ID.Length = this_start_clock - start_clock;
                            changed = true;
                            total_changed = true;
                        }
                    }
                }
            }

            if ( total_changed ) {
                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandReplace( work ) );
                AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                Edited = true;
                RefreshScreen();
            }
        }

        private void menuJobNormalize_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Correct overlapped item." );
        }

        private void menuJobInsertBar_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Insert bar." );
        }

        private void menuJobDeleteBar_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Delete bar." );
        }

        private void menuJobRandomize_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Randomize items." ) + _( "(not implemented)" );
        }

        private void menuJobConnect_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Lengthen note end to neighboring note." );
        }

        private void menuJobLyric_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Import lyric." );
        }

        private void menuJobRewire_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Import tempo from ReWire host." ) + _( "(not implemented)" );
        }

        private void menuJobRealTime_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Start realtime input." );
        }

        private void menuJobReloadVsti_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Reload VSTi dll." ) + _( "(not implemented)" );
        }
        #endregion

        #region menuScript
        private void menuScriptUpdate_Click( object sender, EventArgs e ) {
            UpdateScriptShortcut();
            ApplyShortcut();
        }
        #endregion

        #region vScroll
        private void vScroll_Enter( object sender, EventArgs e ) {
            pictPianoRoll.Select();
        }

        private void vScroll_Resize( object sender, EventArgs e ) {
            SetVScrollRange( vScroll.Maximum );
        }

        private void vScroll_ValueChanged( object sender, EventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
            RefreshScreen();
        }
        #endregion

        #region hScroll
        private void hScroll_Enter( object sender, EventArgs e ) {
            pictPianoRoll.Select();
        }

        private void hScroll_Resize( object sender, EventArgs e ) {
            SetHScrollRange( hScroll.Maximum );
        }

        private void hScroll_ValueChanged( object sender, EventArgs e ) {
#if DEBUG
            //Console.WriteLine( "hScroll_ValueChanged" );
            //Console.WriteLine( "    Value/Maximum=" + hScroll.Value + "/" + hScroll.Maximum );
            //Console.WriteLine( "    LargeChange=" + hScroll.LargeChange );
#endif
            AppManager.StartToDrawX = (int)(hScroll.Value * AppManager.ScaleX);
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
            RefreshScreen();
        }
        #endregion

        #region picturePositionIndicator
        private void picturePositionIndicator_MouseWheel( object sender, MouseEventArgs e ) {
            hScroll.Value = NewHScrollValueFromWheelDelta( e.Delta );
        }

        private void picturePositionIndicator_MouseDoubleClick( object sender, MouseEventArgs e ) {
            if ( e.X < AppManager._KEY_LENGTH || Width - 3 < e.X ) {
                return;
            }
            if ( e.Button == MouseButtons.Left ) {
                if ( 18 < e.Y && e.Y <= 32 ) {
                    #region テンポの変更
                    int index = -1;
                    for ( int i = 0; i < AppManager.VsqFile.TempoTable.Count; i++ ) {
                        int clock = AppManager.VsqFile.TempoTable[i].Clock;
                        int x = XCoordFromClocks( clock );
                        if ( x < 0 ) {
                            continue;
                        } else if ( Width < x ) {
                            break;
                        }
                        string s = (60e6 / (float)AppManager.VsqFile.TempoTable[i].Tempo).ToString( "#.00" );
                        SizeF size = AppManager.MeasureString( s, new Font( AppManager.EditorConfig.ScreenFontName, 8 ) );
                        if ( IsInRect( e.Location, new Rectangle( x, 14, (int)size.Width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index < 0 ) {
                        return;
                    }

                    TempoTableEntry tte = AppManager.VsqFile.TempoTable[index];
                    AppManager.ClearSelectedTempo();
                    AppManager.AddSelectedTempo( tte.Clock );
                    int bar_count = AppManager.VsqFile.getBarCountFromClock( tte.Clock );
                    int bar_top_clock = AppManager.VsqFile.getClockFromBarCount( bar_count );
                    int local_denominator, local_numerator;
                    AppManager.VsqFile.getTimesigAt( tte.Clock, out local_numerator, out local_denominator );
                    int clock_per_beat = 480 * 4 / local_denominator;
                    int clocks_in_bar = tte.Clock - bar_top_clock;
                    int beat_in_bar = clocks_in_bar / clock_per_beat + 1;
                    int clocks_in_beat = clocks_in_bar - (beat_in_bar - 1) * clock_per_beat;
                    using ( FormTempoConfig dlg = new FormTempoConfig( bar_count, beat_in_bar, local_numerator, clocks_in_beat, clock_per_beat, (decimal)(6e7 / tte.Tempo) ) ) {
                        dlg.Location = GetFormPreferedLocation( dlg );
                        if ( dlg.ShowDialog() == DialogResult.OK ) {
                            int new_beat = dlg.BeatCount;
                            int new_clocks_in_beat = dlg.Clock;
                            int new_clock = bar_top_clock + (new_beat - 1) * clock_per_beat + new_clocks_in_beat;
                            CadenciiCommand run = new CadenciiCommand( 
                                VsqCommand.generateCommandUpdateTempo( new_clock, new_clock, (int)(6e7 / (double)dlg.Tempo) ) );
                            AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                            Edited = true;
                            RefreshScreen();
                        }
                    }

                    #endregion
                } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.Height - 1 ) {
                    #region 拍子の変更
                    int index = -1;
                    // クリック位置に拍子が表示されているかどうか検査
                    for ( int i = 0; i < AppManager.VsqFile.TimesigTable.Count; i++ ) {
                        string s = AppManager.VsqFile.TimesigTable[i].Numerator + "/" + AppManager.VsqFile.TimesigTable[i].Denominator;
                        int x = XCoordFromClocks( AppManager.VsqFile.TimesigTable[i].Clock );
                        SizeF size = AppManager.MeasureString( s, new Font( AppManager.EditorConfig.ScreenFontName, 8 ) );
                        if ( IsInRect( e.Location, new Rectangle( x, 28, (int)size.Width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index < 0 ) {
                        return;
                    }

                    int pre_measure = AppManager.VsqFile.getPreMeasure();
                    int clock = ClockFromXCoord( e.X );
                    int bar_count = AppManager.VsqFile.getBarCountFromClock( clock );
                    int numerator, denominator;
                    int total_clock = AppManager.VsqFile.TotalClocks;
                    //int max_barcount = AppManager.VsqFile.getBarCountFromClock( total_clock );
                    //int min_barcount = 1 - pre_measure;
                    AppManager.VsqFile.getTimesigAt( clock, out numerator, out denominator );
                    bool num_enabled = !(bar_count == 0);
                    using ( FormBeatConfig dlg = new FormBeatConfig( bar_count - pre_measure + 1, numerator, denominator, num_enabled ) ) {
                        dlg.Location = GetFormPreferedLocation( dlg );
                        if ( dlg.ShowDialog() == DialogResult.OK ) {
                            if ( dlg.EndSpecified ) {
                                int[] new_barcounts = new int[2];
                                int[] numerators = new int[2];
                                int[] denominators = new int[2];
                                int[] barcounts = new int[2];
                                new_barcounts[0] = dlg.Start + pre_measure - 1;
                                new_barcounts[1] = dlg.End + pre_measure - 1;
                                numerators[0] = dlg.Numerator;
                                denominators[0] = dlg.Denominator;
                                numerators[1] = numerator;
                                denominators[1] = denominator;
                                barcounts[0] = bar_count;
                                barcounts[1] = dlg.End + pre_measure - 1;
                                CadenciiCommand run = new CadenciiCommand( 
                                    VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                                AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                                Edited = true;
                            } else {
                                CadenciiCommand run = new CadenciiCommand(
                                    VsqCommand.generateCommandUpdateTimesig( bar_count, dlg.Start + pre_measure - 1, dlg.Numerator, dlg.Denominator ) );
                                AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                                Edited = true;
                            }
                        }
                    }
                    #endregion
                }
                picturePositionIndicator.Refresh();
                pictPianoRoll.Refresh();
            }
        }

        private void picturePositionIndicator_MouseDown( object sender, MouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }

            if ( e.X < AppManager._KEY_LENGTH || Width - 3 < e.X ) {
                return;
            }

            m_startmark_dragging = false;
            m_endmark_dragging = false;
            Keys modifier = Control.ModifierKeys;
            if ( e.Button == MouseButtons.Left ) {
                if ( 0 <= e.Y && e.Y <= 18 ) {
                    #region スタート/エンドマーク
                    if ( AppManager.StartMarkerEnabled ) {
                        int startx = XCoordFromClocks( AppManager.StartMarker ) - AppManager.EditorConfig.PxTolerance;
                        if ( startx <= e.X && e.X <= startx + AppManager.EditorConfig.PxTolerance * 2 + Properties.Resources.start_marker.Width ) {
                            m_startmark_dragging = true;
                        }
                    }
                    if ( AppManager.EndMarkerEnabled && !m_startmark_dragging ) {
                        int endx = XCoordFromClocks( AppManager.EndMarker ) - Properties.Resources.end_marker.Width - AppManager.EditorConfig.PxTolerance;
                        if ( endx <= e.X && e.X <= endx + AppManager.EditorConfig.PxTolerance * 2 + Properties.Resources.end_marker.Width ) {
                            m_endmark_dragging = true;
                        }
                    }
                    #endregion
                } else if ( 18 < e.Y && e.Y <= 32 ) {
                    #region テンポ
                    int index = -1;
                    for ( int i = 0; i < AppManager.VsqFile.TempoTable.Count; i++ ) {
                        int clock = AppManager.VsqFile.TempoTable[i].Clock;
                        int x = XCoordFromClocks( clock );
                        if ( x < 0 ) {
                            continue;
                        } else if ( Width < x ) {
                            break;
                        }
                        string s = (60e6 / (float)AppManager.VsqFile.TempoTable[i].Tempo).ToString( "#.00" );
                        SizeF size = AppManager.MeasureString( s, new Font( AppManager.EditorConfig.ScreenFontName, 8 ) );
                        if ( IsInRect( e.Location, new Rectangle( x, 14, (int)size.Width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index >= 0 ) {
                        int clock = AppManager.VsqFile.TempoTable[index].Clock;
                        if ( AppManager.SelectedTool != EditTool.Eraser ) {
                            int mouse_clock = ClockFromXCoord( e.X );
                            m_tempo_dragging_deltaclock = mouse_clock - clock;
                            m_tempo_dragging = true;
                        }
                        if ( (modifier & Keys.Shift) == Keys.Shift ) {
                            if ( AppManager.SelectedTempo.Count > 0 ) {
                                int last_clock = AppManager.LastSelectedTempoClock;
                                int start = Math.Min( last_clock, clock );
                                int end = Math.Max( last_clock, clock );
                                for ( int i = 0; i < AppManager.VsqFile.TempoTable.Count; i++ ) {
                                    int tclock = AppManager.VsqFile.TempoTable[i].Clock;
                                    if ( tclock < start ) {
                                        continue;
                                    } else if ( end < tclock ) {
                                        break;
                                    }
                                    if ( start <= tclock && tclock <= end ) {
                                        AppManager.AddSelectedTempo( tclock );
                                    }
                                }
                            } else {
                                AppManager.AddSelectedTempo( clock );
                            }
                        } else if ( (modifier & s_modifier_key) == s_modifier_key ) {
                            if ( AppManager.SelectedTempo.ContainsKey( clock ) ) {
                                AppManager.SelectedTempo.Remove( clock );
                            } else {
                                AppManager.AddSelectedTempo( clock );
                            }
                        } else {
                            if ( !AppManager.SelectedTempo.ContainsKey( clock ) ) {
                                AppManager.ClearSelectedTempo();
                            }
                            AppManager.AddSelectedTempo( clock );
                        }
                    } else {
                        AppManager.ClearSelectedEvent();
                        AppManager.ClearSelectedTempo();
                        AppManager.ClearSelectedTimesig();
                    }
                    #endregion
                } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.Height - 1 ) {
                    #region 拍子
                    // クリック位置に拍子が表示されているかどうか検査
                    int index = -1;
                    for ( int i = 0; i < AppManager.VsqFile.TimesigTable.Count; i++ ) {
                        string s = AppManager.VsqFile.TimesigTable[i].Numerator + "/" + AppManager.VsqFile.TimesigTable[i].Denominator;
                        int x = XCoordFromClocks( AppManager.VsqFile.TimesigTable[i].Clock );
                        SizeF size = AppManager.MeasureString( s, new Font( AppManager.EditorConfig.ScreenFontName, 8 ) );
                        if ( IsInRect( e.Location, new Rectangle( x, 28, (int)size.Width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index >= 0 ) {
                        int barcount = AppManager.VsqFile.TimesigTable[index].BarCount;
                        if ( AppManager.SelectedTool != EditTool.Eraser ) {
                            int barcount_clock = AppManager.VsqFile.getClockFromBarCount( barcount );
                            int mouse_clock = ClockFromXCoord( e.X );
                            m_timesig_dragging_deltaclock = mouse_clock - barcount_clock;
                            m_timesig_dragging = true;
                        }
                        if ( (modifier & Keys.Shift) == Keys.Shift ) {
                            if ( AppManager.SelectedTimesig.Count > 0 ) {
                                int last_barcount = AppManager.LastSelectedTimesigBarcount;
                                int start = Math.Min( last_barcount, barcount );
                                int end = Math.Max( last_barcount, barcount );
                                for ( int i = 0; i < AppManager.VsqFile.TimesigTable.Count; i++ ) {
                                    int tbarcount = AppManager.VsqFile.TimesigTable[i].BarCount;
                                    if ( tbarcount < start ) {
                                        continue;
                                    } else if ( end < tbarcount ) {
                                        break;
                                    }
                                    if ( start <= tbarcount && tbarcount <= end ) {
                                        AppManager.AddSelectedTimesig( AppManager.VsqFile.TimesigTable[i].BarCount );
                                    }
                                }
                            } else {
                                AppManager.AddSelectedTimesig( barcount );
                            }
                        } else if ( (modifier & s_modifier_key) == s_modifier_key ) {
                            if ( AppManager.SelectedTimesig.ContainsKey( barcount ) ) {
                                AppManager.SelectedTimesig.Remove( barcount );
                            } else {
                                AppManager.AddSelectedTimesig( barcount );
                            }
                        } else {
                            if ( !AppManager.SelectedTimesig.ContainsKey( barcount ) ) {
                                AppManager.ClearSelectedTimesig();
                            }
                            AppManager.AddSelectedTimesig( barcount );
                        }
                    } else {
                        AppManager.ClearSelectedEvent();
                        AppManager.ClearSelectedTempo();
                        AppManager.ClearSelectedTimesig();
                    }
                    #endregion
                }
            }
            RefreshScreen();
        }

        private void picturePositionIndicator_MouseClick( object sender, MouseEventArgs e ) {
            if ( e.X < AppManager._KEY_LENGTH || Width - 3 < e.X ) {
                return;
            }

            Keys modifier = Control.ModifierKeys;
#if DEBUG
            AppManager.DebugWriteLine( "picturePositionIndicator_MouseClick" );
#endif
            if ( e.Button == MouseButtons.Left ) {
                if ( 4 <= e.Y && e.Y <= 18 ) {
                    #region マーカー位置の変更
                    if ( !m_startmark_dragging && !m_endmark_dragging ) {

                        int clock = ClockFromXCoord( e.X );
                        if ( AppManager.EditorConfig.PositionQuantize != QuantizeMode.off ) {
                            int unit = AppManager.GetPositionQuantizeClock();
                            int odd = clock % unit;
                            clock -= odd;
                            if ( odd > unit / 2 ) {
                                clock += unit;
                            }
                        }
                        AppManager.CurrentClock = clock;
                        RefreshScreen();
                    } else {
                        m_startmark_dragging = false;
                        m_endmark_dragging = false;
                    }
                    #endregion
                } else if ( 18 < e.Y && e.Y <= 32 ) {
                    if ( m_tempo_dragging ) {
                        int count = AppManager.SelectedTempo.Count;
                        int[] clocks = new int[count];
                        int[] new_clocks = new int[count];
                        int[] tempos = new int[count];
                        int i = -1;
                        bool contains_first_tempo = false;
                        foreach( int clock in AppManager.SelectedTempo.Keys ){
                            i++;
                            clocks[i] = clock;
                            if ( clock == 0 ) {
                                contains_first_tempo = true;
                                break;
                            }
                            new_clocks[i] = AppManager.SelectedTempo[clock].Editing.Clock;
                            tempos[i] = AppManager.SelectedTempo[clock].Editing.Tempo;
                        }
                        if ( contains_first_tempo ) {
                            System.Media.SystemSounds.Asterisk.Play();
                        } else {
                            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTempoRange( clocks, new_clocks, tempos ) );
                            AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                            Edited = true;
                        }
                        m_tempo_dragging = false;
                    } else if( !m_startmark_dragging && !m_endmark_dragging ) {
                        #region テンポの変更
#if DEBUG
                        AppManager.DebugWriteLine( "TempoChange" );
#endif
                        AppManager.ClearSelectedEvent();
                        AppManager.ClearSelectedTimesig();
                        if ( AppManager.SelectedTempo.Count > 0 ) {
                            #region テンポ変更があった場合
                            int index = -1;
                            int clock = AppManager.LastSelectedTempoClock;
                            for ( int i = 0; i < AppManager.VsqFile.TempoTable.Count; i++ ) {
                                if ( clock == AppManager.VsqFile.TempoTable[i].Clock ) {
                                    index = i;
                                    break;
                                }
                            }
                            if ( index >= 0 && AppManager.SelectedTool == EditTool.Eraser ) {
                                #region ツールがEraser
                                if ( AppManager.VsqFile.TempoTable[index].Clock == 0 ) {
                                    MessageBox.Show( _( "Cannot remove first symbol of track!" ), _APP_NAME, MessageBoxButtons.OK, MessageBoxIcon.Information );
                                    return;
                                }
                                CadenciiCommand run = new CadenciiCommand(
                                    VsqCommand.generateCommandUpdateTempo( AppManager.VsqFile.TempoTable[index].Clock,
                                                                 AppManager.VsqFile.TempoTable[index].Clock,
                                                                 -1 ) );
                                AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                                Edited = true;
                                #endregion
                            }
                            #endregion
                        } else {
                            #region テンポ変更がなかった場合
                            AppManager.ClearSelectedEvent();
                            AppManager.ClearSelectedTempo();
                            AppManager.ClearSelectedTimesig();
                            switch ( AppManager.SelectedTool ) {
                                case EditTool.Arrow:
                                case EditTool.Eraser:
                                    break;
                                case EditTool.Pencil:
                                case EditTool.Line:
                                    int changing_clock = ClockFromXCoord( e.X );
                                    int changing_tempo = AppManager.VsqFile.getTempoAt( changing_clock );
                                    int bar_count;
                                    int bar_top_clock;
                                    int local_denominator, local_numerator;
                                    bar_count = AppManager.VsqFile.getBarCountFromClock( changing_clock );
                                    bar_top_clock = AppManager.VsqFile.getClockFromBarCount( bar_count );
                                    int index2 = -1;
                                    for ( int i = 0; i < AppManager.VsqFile.TimesigTable.Count; i++ ) {
                                        if ( AppManager.VsqFile.TimesigTable[i].BarCount > bar_count ) {
                                            index2 = i;
                                            break;
                                        }
                                    }
                                    if ( index2 >= 1 ) {
                                        local_denominator = AppManager.VsqFile.TimesigTable[index2 - 1].Denominator;
                                        local_numerator = AppManager.VsqFile.TimesigTable[index2 - 1].Numerator;
                                    } else {
                                        local_denominator = AppManager.VsqFile.TimesigTable[0].Denominator;
                                        local_numerator = AppManager.VsqFile.TimesigTable[0].Numerator;
                                    }
                                    int clock_per_beat = 480 * 4 / local_denominator;
                                    int clocks_in_bar = changing_clock - bar_top_clock;
                                    int beat_in_bar = clocks_in_bar / clock_per_beat + 1;
                                    int clocks_in_beat = clocks_in_bar - (beat_in_bar - 1) * clock_per_beat;
                                    using ( FormTempoConfig dlg = new FormTempoConfig(
                                        bar_count - AppManager.VsqFile.getPreMeasure() + 1,
                                        beat_in_bar,
                                        local_numerator,
                                        clocks_in_beat,
                                        clock_per_beat,
                                        (decimal)(6e7 / changing_tempo) ) ) {
                                        dlg.Location = GetFormPreferedLocation( dlg );
                                        if ( dlg.ShowDialog() == DialogResult.OK ) {
                                            int new_beat = dlg.BeatCount;
                                            int new_clocks_in_beat = dlg.Clock;
                                            int new_clock = bar_top_clock + (new_beat - 1) * clock_per_beat + new_clocks_in_beat;
#if DEBUG
                                            AppManager.DebugWriteLine( "    new_beat=" + new_beat );
                                            AppManager.DebugWriteLine( "    new_clocks_in_beat=" + new_clocks_in_beat );
                                            AppManager.DebugWriteLine( "    changing_clock=" + changing_clock );
                                            AppManager.DebugWriteLine( "    new_clock=" + new_clock );
#endif
                                            CadenciiCommand run = new CadenciiCommand(
                                                VsqCommand.generateCommandUpdateTempo( new_clock, new_clock, (int)(6e7 / (double)dlg.Tempo) ) );
                                            AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                                            Edited = true;
                                            RefreshScreen();
                                        }
                                    }
                                    break;
                            }
                            #endregion
                        }
                        m_startmark_dragging = false;
                        m_endmark_dragging = false;
                        #endregion
                    }
                } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.Height - 1 ) {
                    if ( m_timesig_dragging ) {
                        int count = AppManager.SelectedTimesig.Count;
                        int[] barcounts = new int[count];
                        int[] new_barcounts = new int[count];
                        int[] numerators = new int[count];
                        int[] denominators = new int[count];
                        int i = -1;
                        bool contains_first_bar = false;
                        foreach( int bar in AppManager.SelectedTimesig.Keys ){
                            i++;
                            barcounts[i] = bar;
                            if ( bar == 0 ) {
                                contains_first_bar = true;
                                break;
                            }
                            new_barcounts[i] = AppManager.SelectedTimesig[bar].Editing.BarCount;
                            numerators[i] = AppManager.SelectedTimesig[bar].Editing.Numerator;
                            denominators[i] = AppManager.SelectedTimesig[bar].Editing.Denominator;
                        }
                        if ( contains_first_bar ) {
                            System.Media.SystemSounds.Asterisk.Play();
                        } else {
                            CadenciiCommand run = new CadenciiCommand(
                                VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                            AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                            Edited = true;
                        }
                        m_timesig_dragging = false;
                    } else if ( !m_startmark_dragging && !m_endmark_dragging ) {
                        #region 拍子の変更
                        AppManager.ClearSelectedEvent();
                        AppManager.ClearSelectedTempo();
                        if ( AppManager.SelectedTimesig.Count > 0 ) {
                            #region 拍子変更があった場合
                            int index = 0;
                            int clock = AppManager.LastSelectedTimesigBarcount;
                            for ( int i = 0; i < AppManager.VsqFile.TimesigTable.Count; i++ ) {
                                if ( AppManager.VsqFile.TimesigTable[i].Clock == clock ) {
                                    index = i;
                                    break;
                                }
                            }
                            if ( AppManager.SelectedTool == EditTool.Eraser ) {
                                #region ツールがEraser
                                if ( AppManager.VsqFile.TimesigTable[index].Clock == 0 ) {
                                    MessageBox.Show( _( "Cannot remove first symbol of track!" ), _APP_NAME, MessageBoxButtons.OK, MessageBoxIcon.Information );
                                    return;
                                }
                                int barcount = AppManager.VsqFile.TimesigTable[index].BarCount;
                                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTimesig( barcount, barcount, -1, -1 ) );
                                AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                                Edited = true;
                                #endregion
                            }
                            #endregion
                        } else {
                            #region 拍子変更がなかった場合
                            AppManager.ClearSelectedEvent();
                            AppManager.ClearSelectedTempo();
                            AppManager.ClearSelectedTimesig();
                            switch ( AppManager.SelectedTool ) {
                                case EditTool.Eraser:
                                case EditTool.Arrow:
                                    break;
                                case EditTool.Pencil:
                                case EditTool.Line:
                                    int pre_measure = AppManager.VsqFile.getPreMeasure();
                                    int clock = ClockFromXCoord( e.X );
                                    int bar_count = AppManager.VsqFile.getBarCountFromClock( clock );
                                    int numerator, denominator;
                                    AppManager.VsqFile.getTimesigAt( clock, out numerator, out denominator );
                                    int total_clock = AppManager.VsqFile.TotalClocks;
                                    //int max_barcount = AppManager.VsqFile.getBarCountFromClock( total_clock ) - pre_measure + 1;
                                    //int min_barcount = 1;
#if DEBUG
                                    AppManager.DebugWriteLine( "FormMain.picturePositionIndicator_MouseClick; bar_count=" + (bar_count - pre_measure + 1) );
#endif
                                    using ( FormBeatConfig dlg = new FormBeatConfig( bar_count - pre_measure + 1, numerator, denominator, true ) ) {
                                        dlg.Location = GetFormPreferedLocation( dlg );
                                        if ( dlg.ShowDialog() == DialogResult.OK ) {
                                            if ( dlg.EndSpecified ) {
                                                int[] new_barcounts = new int[2];
                                                int[] numerators = new int[2];
                                                int[] denominators = new int[2];
                                                int[] barcounts = new int[2];
                                                new_barcounts[0] = dlg.Start + pre_measure - 1;
                                                new_barcounts[1] = dlg.End + pre_measure - 1 + 1;
                                                numerators[0] = dlg.Numerator;
                                                numerators[1] = numerator;
                                                
                                                denominators[0] = dlg.Denominator;
                                                denominators[1] = denominator;
                                                
                                                barcounts[0] = dlg.Start + pre_measure - 1;
                                                barcounts[1] = dlg.End + pre_measure - 1 + 1;
                                                CadenciiCommand run = new CadenciiCommand(
                                                    VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                                                AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                                                Edited = true;
                                            } else {
                                                CadenciiCommand run = new CadenciiCommand( 
                                                    VsqCommand.generateCommandUpdateTimesig( bar_count, 
                                                                                   dlg.Start + pre_measure - 1, 
                                                                                   dlg.Numerator, 
                                                                                   dlg.Denominator ) );
                                                AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                                                Edited = true;
                                            }
                                        }
                                    }
                                    break;
                            }
                            #endregion
                        }
                        m_startmark_dragging = false;
                        m_endmark_dragging = false;
                        #endregion
                    }
                }
            }
            pictPianoRoll.Refresh();
            picturePositionIndicator.Refresh();
        }

        private void picturePositionIndicator_MouseMove( object sender, MouseEventArgs e ) {
            if ( m_tempo_dragging ) {
                int clock = ClockFromXCoord( e.X ) - m_tempo_dragging_deltaclock;
                int step = AppManager.GetPositionQuantizeClock();
                int odd = clock % step;
                clock -= odd;
                if ( odd > step / 2 ) {
                    clock += step;
                }
                int last_clock = AppManager.LastSelectedTempoClock;
                int dclock = clock - last_clock;
                foreach ( int key in AppManager.SelectedTempo.Keys ) {
                    AppManager.SelectedTempo[key].Editing.Clock = AppManager.SelectedTempo[key].Original.Clock + dclock;
                }
                picturePositionIndicator.Refresh();
            } else if ( m_timesig_dragging ) {
                int clock = ClockFromXCoord( e.X ) - m_timesig_dragging_deltaclock;
                int barcount = AppManager.VsqFile.getBarCountFromClock( clock );
                int last_barcount = AppManager.LastSelectedTimesigBarcount;
                int dbarcount = barcount - last_barcount;
                foreach ( int bar in AppManager.SelectedTimesig.Keys ) {
                    AppManager.SelectedTimesig[bar].Editing.BarCount = AppManager.SelectedTimesig[bar].Original.BarCount + dbarcount;
                }
                picturePositionIndicator.Refresh();
            } else if ( m_startmark_dragging ) {
                int clock = ClockFromXCoord( e.X );
                int unit = AppManager.GetPositionQuantizeClock();
                int odd = clock % unit;
                clock -= odd;
                if ( odd > unit / 2 ) {
                    clock += unit;
                }
                int draft_start = Math.Min( clock, AppManager.EndMarker );
                int draft_end = Math.Max( clock, AppManager.EndMarker );
                if ( draft_start != AppManager.StartMarker ) {
                    AppManager.StartMarker = draft_start;
                }
                if ( draft_end != AppManager.EndMarker ) {
                    AppManager.EndMarker = draft_end;
                }
                RefreshScreen();
            } else if ( m_endmark_dragging ) {
                int clock = ClockFromXCoord( e.X );
                int unit = AppManager.GetPositionQuantizeClock();
                int odd = clock % unit;
                clock -= odd;
                if ( odd > unit / 2 ) {
                    clock += unit;
                }
                int draft_start = Math.Min( clock, AppManager.StartMarker );
                int draft_end = Math.Max( clock, AppManager.StartMarker );
                if ( draft_start != AppManager.StartMarker ) {
                    AppManager.StartMarker = draft_start;
                }
                if ( draft_end != AppManager.EndMarker ) {
                    AppManager.EndMarker = draft_end;
                }
                RefreshScreen();
            }
        }

        private void picturePositionIndicator_MouseLeave( object sender, EventArgs e ) {
            m_startmark_dragging = false;
            m_endmark_dragging = false;
            m_tempo_dragging = false;
            m_timesig_dragging = false;
        }

        private void picturePositionIndicator_Paint( object sender, PaintEventArgs e ) {
            picturePositionIndicatorDrawTo( e.Graphics );
        }

        private void picturePositionIndicator_PreviewKeyDown( object sender, PreviewKeyDownEventArgs e ) {
            ProcessSpecialShortcutKey( e );
        }
        #endregion

        #region trackBar
        private void trackBar_Enter( object sender, EventArgs e ) {
            pictPianoRoll.Select();
        }

        private void trackBar_MouseDown( object sender, MouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }

        private void trackBar_ValueChanged( object sender, EventArgs e ) {
            AppManager.ScaleX = trackBar.Value / 480f;
            AppManager.StartToDrawX = (int)(hScroll.Value * AppManager.ScaleX);
#if USE_DOBJ
            UpdateDrawObjectList();
#endif
            this.Refresh();
        }
        #endregion

        #region menuHelp
        private void menuHelpAbout_Click( object sender, EventArgs e ) {
            string version_str = AppManager._VERSION + "\n\n" +
                                 AppManager.GetAssemblyNameAndFileVersion( typeof( Boare.Lib.AppUtil.Misc ) ) + "\n" +
                                 AppManager.GetAssemblyNameAndFileVersion( typeof( Boare.Lib.Media.Wave ) ) + "\n" +
                                 AppManager.GetAssemblyNameAndFileVersion( typeof( Boare.Lib.Vsq.VsqFile ) ) + "\n" +
                                 AppManager.GetAssemblyNameAndFileVersion( typeof( bocoree.math ) /*) + "\n" +
                                 AppManager.GetAssemblyNameAndFileVersion( typeof( Boare.Cadencii.vstidrv )*/ );
            if ( m_versioninfo == null ) {
                m_versioninfo = new Boare.Cadencii.VersionInfo( _APP_NAME, version_str );
                m_versioninfo.Credit = Boare.Cadencii.Properties.Resources.author_list;
                m_versioninfo.AuthorList = _CREDIT;
#if DEBUG
#if AUTHOR_LIST_SAVE_BUTTON_VISIBLE
                m_versioninfo.SaveAuthorListVisible = true;
#else
                m_versioninfo.SaveAuthorListVisible = false;
#endif
#else
                m_versioninfo.SaveAuthorListVisible = false;
#endif
                m_versioninfo.Show();
            } else {
                if ( m_versioninfo.IsDisposed ) {
                    m_versioninfo = new Boare.Cadencii.VersionInfo( _APP_NAME, version_str );
                    m_versioninfo.Credit = Boare.Cadencii.Properties.Resources.author_list;
                    m_versioninfo.AuthorList = _CREDIT;
#if DEBUG
#if AUTHOR_LIST_SAVE_BUTTON_VISIBLE
                    m_versioninfo.SaveAuthorListVisible = true;
#else
                    m_versioninfo.SaveAuthorListVisible = false;
#endif
#else
                    m_versioninfo.SaveAuthorListVisible = false;
#endif
                }
                m_versioninfo.Show();
            }
        }

        private void menuHelpDebug_Click( object sender, EventArgs e ) {
            Console.WriteLine( "menuHelpDebug_Click" );
#if DEBUG
            /*DialogResult dr = DialogResult.OK;
            while ( dr == DialogResult.OK ) {
                FileDialog fd = new FileDialog( FileDialog.DialogMode.Open );
                fd.Filter = "All Files(*.*)|*.*|VSQ Format(*.vsq)|*.vsq";
                dr = fd.ShowDialog();
                AppManager.DebugWriteLine( "fd.FileName=" + fd.FileName );
            }*/
            /*using ( OpenFileDialog ofd = new OpenFileDialog() ) {
                if ( ofd.ShowDialog() == DialogResult.OK ) {
                    using ( SaveFileDialog sfd = new SaveFileDialog() ) {
                        sfd.InitialDirectory = Path.GetDirectoryName( ofd.FileName );
                        sfd.FileName = Path.GetFileNameWithoutExtension( ofd.FileName ) + ".txt";
                        if ( sfd.ShowDialog() == DialogResult.OK ) {
                            using ( Wave w = new Wave( ofd.FileName ) ) {
                                w.PrintToText( sfd.FileName );
                            }
                        }
                    }
                }
            }*/

            /*using ( OpenFileDialog ofd = new OpenFileDialog() ) {
                if ( ofd.ShowDialog() == DialogResult.OK ) {
                    string file = ofd.FileName;
                    using ( Wave wv = new Wave( file ) ) {
                        const double sec_dt = 0.0025;
                        uint samples = wv.TotalSamples;
                        const int _WINDOW_WIDTH = 2048;
                        uint spl_dt = (uint)(sec_dt * wv.SampleRate);
                        double[] window_func = new double[_WINDOW_WIDTH];
                        for ( int i = 0; i < _WINDOW_WIDTH; i++ ) {
                            window_func[i] = bocoree.math.window_func( bocoree.math.WindowFunctionType.Hamming, i / (double)_WINDOW_WIDTH );
                        }
                        Wave.TestEnabled = false;

                        InputBox ib = new InputBox( "input clock count" );
                        if ( ib.ShowDialog() == DialogResult.OK ) {
                            int count = 0;
                            if ( int.TryParse( ib.Result, out count ) ) {
                                Wave.TestEnabled = true;
                                double f0 = wv.GetF0( (uint)count, window_func );
                                MessageBox.Show( "f0=" + f0 + " at sample=" + count );
                                Wave.TestEnabled = false;
                            }
                        }
                        if ( MessageBox.Show( "calculate all formant profile?", "Cadencii", MessageBoxButtons.YesNo ) == DialogResult.Yes ) {
                            using ( StreamWriter sw = new StreamWriter( ofd.FileName + "_formanto.txt" ) ) {
                                FormantoDetectionArguments fda = new FormantoDetectionArguments();
                                fda.PeakDetectionThreshold = 0.05;
                                for ( uint spl_i = 0; spl_i < samples; spl_i += spl_dt ) {
                                    double f0 = wv.GetF0( spl_i, window_func, fda );
                                    double note;
                                    if ( f0 > 0.0 ) {
                                        note = 12.0 * Math.Log( f0 / 440.0, 2.0 ) + 69;
                                    } else {
                                        note = 0.0;
                                    }
                                    sw.WriteLine( spl_i + "\t" + (spl_i / (double)wv.SampleRate) + "\t" + f0 + "\t" + note + "\t" + Math.Round( note, 0, MidpointRounding.AwayFromZero ) );
                                }
                            }
                        }
                        if ( MessageBox.Show( "calculate volume profile?", "Cadencii", MessageBoxButtons.YesNo ) == DialogResult.Yes ) {
                            using ( StreamWriter sw = new StreamWriter( ofd.FileName + "_volume.txt" ) ) {
                                for ( uint spl_i = 0; spl_i < samples; spl_i += spl_dt ) {
                                    double volume = wv.GetVolume( (int)spl_i, window_func );
                                    sw.WriteLine( spl_i + "\t" + (spl_i / (double)wv.SampleRate) + "\t" + volume );
                                }
                            }
                        }
                    }
                }
            }*/
#endif
#if FOO
            using ( OpenFileDialog ofd = new OpenFileDialog() ) {
                if ( ofd.ShowDialog() == DialogResult.OK ) {
                    using ( Wave wv = new Wave( ofd.FileName ) ) {
                        wv.TrimSilence();
                        const int _WIN_LEN = 441;
                        double[] window = new double[_WIN_LEN];
                        for ( int i = 0; i < _WIN_LEN; i++ ) {
                            window[i] = bocoree.math.window_func( bocoree.math.WindowFunctionType.Hamming, (double)i / (double)_WIN_LEN );
                        }
                        using ( StreamWriter sw = new StreamWriter( ofd.FileName + ".txt" ) ) {
                            for ( int i = 0; i < wv.TotalSamples - _WIN_LEN / 10; i += _WIN_LEN / 10 ) {
                                sw.WriteLine( i / (double)wv.SampleRate + "\t" + wv.GetVolume( i, window ) );
                            }
                        }
                        /*using ( StreamWriter sw = new StreamWriter( ofd.FileName + ".txt" ) ) {
                            double to = 7000.0 * 2.0 / (double)wv.SampleRate;
                            int jmax = (int)(to * _WIN_LEN);
                            double resolution = 1e-3;
                            uint di = (uint)(resolution * wv.SampleRate);
                            for ( uint i = 0; i < wv.TotalSamples; i += di ) {
                                double[] formanto = wv.GetFormanto( i, window );
                                for ( int j = 1; j < _WIN_LEN && j < jmax; j++ ) {
                                    //double f = (double)j / (double)_WIN_LEN * (double)wv.SampleRate / 2.0;
                                    sw.Write( "{0:f4}\t", Math.Abs( formanto[j] ) );
                                }
                                sw.WriteLine();
                            }
                        }*/
                    }
                }
            }
#endif
        }
        #endregion

        #region trackSelector
        private void trackSelector_CommandExecuted() {
            Edited = true;
            RefreshScreen();
        }

        private void trackSelector_MouseClick( object sender, MouseEventArgs e ) {
            if ( e.Button == MouseButtons.Right ) {
                if ( AppManager._KEY_LENGTH < e.X && e.X < trackSelector.Width - AppManager._KEY_LENGTH ) {
                    if ( trackSelector.Height - TrackSelector._OFFSET_TRACK_TAB <= e.Y && e.Y <= trackSelector.Height ) {
                        cMenuTrackTab.Show( trackSelector, e.Location );
                    } else {
                        cMenuTrackSelector.Show( trackSelector, e.Location );
                    }
                }
            }
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }

        private void trackSelector_MouseDown( object sender, MouseEventArgs e ) {
            if ( AppManager._KEY_LENGTH < e.X ) {
                m_mouse_downed_trackselector = true;
                if ( e.Button == MouseButtons.Middle || m_spacekey_downed ) {
                    m_edit_curve_mode = CurveEditMode.MiddleDrag;
                    m_button_initial = e.Location;
                    m_middle_button_hscroll = hScroll.Value;
                    this.Cursor = HAND;
                }
            }
        }

        private void trackSelector_MouseMove( object sender, MouseEventArgs e ) {
            if ( e.Button == MouseButtons.None ) {
                int cl = ClockFromXCoord( e.X );
                UpdatePositionViewFromMousePosition( cl );
                return;
            }
            int parent_width = ((TrackSelector)sender).Width;
            if ( m_edit_curve_mode == CurveEditMode.MiddleDrag ) {
                int dx = e.X - m_button_initial.X;
                int dy = e.Y - m_button_initial.Y;
                double new_hscroll_value = (double)m_middle_button_hscroll - (double)dx / AppManager.ScaleX;
                int draft;
                if ( new_hscroll_value < hScroll.Minimum ) {
                    draft = hScroll.Minimum;
                } else if ( hScroll.Maximum < new_hscroll_value ) {
                    draft = hScroll.Maximum;
                } else {
                    draft = (int)new_hscroll_value;
                }
                if ( AppManager.Playing ) {
                    return;
                }
                if ( hScroll.Value != draft ) {
                    hScroll.Value = draft;
                }
            } else {
                if ( m_mouse_downed_trackselector ) {
                    if ( m_ext_dragx_trackselector == ExtDragXMode.None ) {
                        if ( AppManager._KEY_LENGTH > e.X ) {
                            m_ext_dragx_trackselector = ExtDragXMode.Left;
                        } else if ( parent_width < e.X ) {
                            m_ext_dragx_trackselector = ExtDragXMode.Right;
                        }
                    } else {
                        if ( AppManager._KEY_LENGTH <= e.X && e.X <= parent_width ) {
                            m_ext_dragx_trackselector = ExtDragXMode.None;
                        }
                    }
                } else {
                    m_ext_dragx_trackselector = ExtDragXMode.None;
                }

                if ( m_ext_dragx_trackselector != ExtDragXMode.None ) {
                    DateTime now = DateTime.Now;
                    double dt = now.Subtract( m_timer_drag_last_ignitted ).TotalSeconds;
                    m_timer_drag_last_ignitted = now;
                    int px_move = AppManager.EditorConfig.MouseDragIncrement;
                    if ( px_move / dt > AppManager.EditorConfig.MouseDragMaximumRate ) {
                        px_move = (int)(dt * AppManager.EditorConfig.MouseDragMaximumRate);
                    }
                    double d_draft;
                    if ( m_ext_dragx_trackselector == ExtDragXMode.Right ) {
                        int right_clock = ClockFromXCoord( parent_width + 5 );
                        int dclock = (int)(px_move / AppManager.ScaleX);
                        d_draft = (73 - trackSelector.Width) / AppManager.ScaleX + right_clock + dclock;
                    } else {
                        px_move *= -1;
                        int left_clock = ClockFromXCoord( AppManager._KEY_LENGTH );
                        int dclock = (int)(px_move / AppManager.ScaleX);
                        d_draft = (73 - AppManager._KEY_LENGTH) / AppManager.ScaleX + left_clock + dclock;
                    }
                    if ( d_draft < 0.0 ) {
                        d_draft = 0.0;
                    }
                    int draft = (int)d_draft;
                    if ( hScroll.Maximum < draft ) {
                        hScroll.Maximum = draft;
                    }
                    if ( draft < hScroll.Minimum ) {
                        draft = hScroll.Minimum;
                    }
                    hScroll.Value = draft;
                }
            }
            int clock = ClockFromXCoord( e.X );
            UpdatePositionViewFromMousePosition( clock );
            RefreshScreen();
        }

        private void trackSelector_MouseUp( object sender, MouseEventArgs e ) {
            m_mouse_downed_trackselector = false;
            if ( m_edit_curve_mode == CurveEditMode.MiddleDrag ) {
                m_edit_curve_mode = CurveEditMode.None;
                this.Cursor = Cursors.Default;
            }
        }

        private void trackSelector_MouseWheel( object sender, MouseEventArgs e ) {
            if ( (Control.ModifierKeys & Keys.Shift) == Keys.Shift ) {
                double new_val = (double)vScroll.Value - e.Delta;
                if ( new_val > vScroll.Maximum ) {
                    vScroll.Value = vScroll.Maximum;
                } else if ( new_val < vScroll.Minimum ) {
                    vScroll.Value = vScroll.Minimum;
                } else {
                    vScroll.Value = (int)new_val;
                }
            } else {
                hScroll.Value = NewHScrollValueFromWheelDelta( e.Delta );
            }
            RefreshScreen();
        }

        private void trackSelector_PreviewKeyDown( object sender, PreviewKeyDownEventArgs e ) {
            ProcessSpecialShortcutKey( e );
        }

        private void trackSelector_RenderRequired( int[] tracks ) {
            Render( tracks );
            List<int> t = new List<int>( tracks );
            if ( t.Contains( AppManager.Selected ) ) {
                string file = Path.Combine( AppManager.TempWaveDir, AppManager.Selected + ".wav" );
                if ( File.Exists( file ) ) {
                    Thread loadwave_thread = new Thread( new ParameterizedThreadStart( this.LoadWaveThreadProc ) );
                    loadwave_thread.IsBackground = true;
                    loadwave_thread.Start( file );
                }
            }
        }

        private void trackSelector_SelectedCurveChanged( CurveType type ) {
#if DEBUG
            AppManager.DebugWriteLine( "trackSelector_SelectedCurveChanged(VsqCurveType)" );
#endif
            RefreshScreen();
        }        
        
        private void trackSelector_SelectedTrackChanged( int selected ) {
            if ( menuVisualWaveform.Checked ) {
                waveView.Clear();
                string file = Path.Combine( AppManager.TempWaveDir, selected + ".wav" );
                if ( File.Exists( file ) ) {
                    Thread load_wave = new Thread( new ParameterizedThreadStart( this.LoadWaveThreadProc ) );
                    load_wave.IsBackground = true;
                    load_wave.Start( (object)file );
                }
            }
#if USE_DOBJ
            UpdateDrawObjectList();
#endif
            RefreshScreen();
        }
        #endregion

        #region cMenuPiano*
        private void cMenuPianoDelete_Click( object sender, EventArgs e ) {
            DeleteEvent();
        }

        private void cMenuPianoVibratoProperty_Click( object sender, EventArgs e ) {
            NoteVibratoProperty();
        }

        private void cMenuPianoPaste_Click( object sender, EventArgs e ) {
            PasteEvent();
        }

        private void cMenuPianoCopy_Click( object sender, EventArgs e ) {
            CopyEvent();
        }

        private void cMenuPianoCut_Click( object sender, EventArgs e ) {
            CutEvent();
        }
        
        private void cMenuPianoExpression_Click( object sender, EventArgs e ) {
            if ( AppManager.SelectedEvent.Count > 0 ) {
                using ( FormSingerStyleConfig dlg = new FormSingerStyleConfig( _( "Expression control property" ), false ) ) {
                    VsqEvent original = AppManager.SelectedEvent.LastSelected.Original;
                    int id = AppManager.SelectedEvent.LastSelectedID;
                    dlg.PMBendDepth = original.ID.PMBendDepth;
                    dlg.PMBendLength = original.ID.PMBendLength;
                    dlg.PMbPortamentoUse = original.ID.PMbPortamentoUse;
                    dlg.DEMdecGainRate = original.ID.DEMdecGainRate;
                    dlg.DEMaccent = original.ID.DEMaccent;
                    if ( dlg.ShowDialog() == DialogResult.OK ) {
                        VsqID copy = (VsqID)original.ID.Clone();
                        copy.PMBendDepth = dlg.PMBendDepth;
                        copy.PMBendLength = dlg.PMBendLength;
                        copy.PMbPortamentoUse = dlg.PMbPortamentoUse;
                        copy.DEMdecGainRate = dlg.DEMdecGainRate;
                        copy.DEMaccent = dlg.DEMaccent;
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandEventChangeIDContaints( AppManager.Selected, id, copy ) );
                        AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                        Edited = true;
                    }
                }
            }
        }

        private void cMenuPianoPointer_Click( object sender, EventArgs e ) {
            AppManager.SelectedTool = EditTool.Arrow;
        }

        private void cMenuPianoPencil_Click( object sender, EventArgs e ) {
            AppManager.SelectedTool = EditTool.Pencil;
        }

        private void cMenuPianoEraser_Click( object sender, EventArgs e ) {
            AppManager.SelectedTool = EditTool.Eraser;
        }

        private void h_positionQuantize04( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantize = QuantizeMode.p4;
        }

        private void h_positionQuantize08( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantize = QuantizeMode.p8;
        }

        private void h_positionQuantize16( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantize = QuantizeMode.p16;
        }

        private void h_positionQuantize32( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantize = QuantizeMode.p32;
        }

        private void h_positionQuantize64( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantize = QuantizeMode.p64;
        }

        private void h_positionQuantize128( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantize = QuantizeMode.p128;
        }

        private void h_positionQuantizeOff( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantize = QuantizeMode.off;
        }

        private void h_positionQuantizeTriplet( object sender, EventArgs e ) {
            AppManager.EditorConfig.PositionQuantizeTriplet = !AppManager.EditorConfig.PositionQuantizeTriplet;
        }

        private void h_lengthQuantize04( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantize = QuantizeMode.p4;
        }

        private void h_lengthQuantize08( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantize = QuantizeMode.p8;
        }

        private void h_lengthQuantize16( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantize = QuantizeMode.p16;
        }

        private void h_lengthQuantize32( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantize = QuantizeMode.p32;
        }

        private void h_lengthQuantize64( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantize = QuantizeMode.p64;
        }

        private void h_lengthQuantize128( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantize = QuantizeMode.p128;
        }

        private void h_lengthQuantizeOff( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantize = QuantizeMode.off;
        }

        private void h_lengthQuantizeTriplet( object sender, EventArgs e ) {
            AppManager.EditorConfig.LengthQuantizeTriplet = !AppManager.EditorConfig.LengthQuantizeTriplet;
        }

        private void cMenuPianoGrid_Click( object sender, EventArgs e ) {
            cMenuPianoGrid.Checked = !cMenuPianoGrid.Checked;
            AppManager.GridVisible = cMenuPianoGrid.Checked;
        }

        private void cMenuPianoUndo_Click( object sender, EventArgs e ) {
            Undo();
        }

        private void cMenuPianoRedo_Click( object sender, EventArgs e ) {
            Redo();
        }

        private void cMenuPianoSelectAllEvents_Click( object sender, EventArgs e ) {
            SelectAllEvent();
        }       
        
        private void cMenuPianoProperty_Click( object sender, EventArgs e ) {
            NoteExpressionProperty();
        }
        
        private void cMenuPianoImportLyric_Click( object sender, EventArgs e ) {
            ImportLyric();
        }

        private void cMenuPiano_Opening( object sender, CancelEventArgs e ) {
            UpdateCopyAndPasteButtonStatus();
            cMenuPianoImportLyric.Enabled = AppManager.SelectedEvent.LastSelected != null;
        }

        private void cMenuPianoSelectAll_Click( object sender, EventArgs e ) {
            SelectAll();
        }

        private void cMenuPianoFixed01_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L1;
            UpdateCMenuPianoFixed();
        }
        
        private void cMenuPianoFixed02_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L2;
            UpdateCMenuPianoFixed();
        }
        
        private void cMenuPianoFixed04_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L4;
            UpdateCMenuPianoFixed();
        }

        private void cMenuPianoFixed08_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L8;
            UpdateCMenuPianoFixed();
        }
        
        private void cMenuPianoFixed16_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L16;
            UpdateCMenuPianoFixed();
        }
        
        private void cMenuPianoFixed32_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L32;
            UpdateCMenuPianoFixed();
        }

        private void cMenuPianoFixed64_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L64;
            UpdateCMenuPianoFixed();
        }

        private void cMenuPianoFixed128_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.L128;
            UpdateCMenuPianoFixed();
        }

        private void cMenuPianoFixedOff_Click( object sender, EventArgs e ) {
            m_pencil_mode.Mode = PencilModeEnum.Off;
            UpdateCMenuPianoFixed();
        }

        private void cMenuPianoFixedTriplet_Click( object sender, EventArgs e ) {
            m_pencil_mode.Triplet = !m_pencil_mode.Triplet;
            UpdateCMenuPianoFixed();
        }
        
        private void cMenuPianoFixedDotted_Click( object sender, EventArgs e ) {
            m_pencil_mode.Dot = !m_pencil_mode.Dot;
            UpdateCMenuPianoFixed();
        }

        private void cMenuPianoCurve_Click( object sender, EventArgs e ) {
            AppManager.IsCurveMode = !AppManager.IsCurveMode;
            ApplySelectedTool();
        }
        #endregion

        #region menuTrack*
        private void menuTrack_DropDownOpening( object sender, EventArgs e ) {
            UpdateTrackMenuStatus();
        }

        private void menuTrackCopy_Click( object sender, EventArgs e ) {
            CopyTrackCore();
        }

        private void menuTrackChangeName_Click( object sender, EventArgs e ) {
            ChangeTrackNameCore();
        }

        private void menuTrackDelete_Click( object sender, EventArgs e ) {
            DeleteTrackCore();
        }

        private void menuTrackOn_Click( object sender, EventArgs e ) {
            menuTrackOn.Checked = !menuTrackOn.Checked;
            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandTrackChangePlayMode( AppManager.Selected,
                                                                                                      menuTrackOn.Checked ? 1 : -1 ) );
            AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
            Edited = true;
            RefreshScreen();
        }

        private void menuTrackAdd_Click( object sender, EventArgs e ) {
            AddTrackCore();
        }

        private void menuTrackOverlay_Click( object sender, EventArgs e ) {
            AppManager.Overlay = !AppManager.Overlay;
            RefreshScreen();
        }

        private void menuTrackRenderCurrent_Click( object sender, EventArgs e ) {
            Render( new int[] { AppManager.Selected } );
        }

        private void menuTrackRenderer_DropDownOpening( object sender, EventArgs e ) {
            UpdateRendererMenu();
        }

        private void menuTrackOn_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Enable current track." );
        }

        private void menuTrackAdd_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Add new track." );
        }

        private void menuTrackCopy_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Copy current track." ); 
        }

        private void menuTrackChangeName_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Change track name." );
        }

        private void menuTrackDelete_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Delete current track." );
        }

        private void menuTrackRenderCurrent_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Render current track." );
        }

        private void menuTrackRenderAll_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Render all tracks." );
        }

        private void menuTrackOverlay_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Show background items." );
        }

        private void menuTrackRenderer_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Select voice synthesis engine." );
        }

        private void menuTrackRendererVOCALOID1_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "VOCALOID1" );
        }

        private void menuTrackRendererVOCALOID2_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "VOCALOID2" );
        }

        private void menuTrackRendererUtau_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "UTAU" );
        }

        private void menuTrackMasterTuning_MouseEnter( object sender, EventArgs e ) {
            statusLabel.Text = _( "Set global pitch shift." );
        }
        #endregion

        #region menuHidden*
        private void menuHiddenTrackNext_Click( object sender, EventArgs e ) {
            if ( AppManager.Selected == AppManager.VsqFile.Track.Count - 1 ) {
                AppManager.Selected = 1;
            } else {
                AppManager.Selected++;
            }
            RefreshScreen();
        }

        private void menuHiddenTrackBack_Click( object sender, EventArgs e ) {
            if ( AppManager.Selected == 1 ) {
                AppManager.Selected = AppManager.VsqFile.Track.Count - 1;
            } else {
                AppManager.Selected--;
            }
            RefreshScreen();
        }

        private void menuHiddenEditPaste_Click( object sender, EventArgs e ) {
            PasteEvent();
        }

        private void menuHiddenEditFlipToolPointerPencil_Click( object sender, EventArgs e ) {
            if ( AppManager.SelectedTool == EditTool.Arrow ) {
                AppManager.SelectedTool = EditTool.Pencil;
            } else {
                AppManager.SelectedTool = EditTool.Arrow;
            }
            RefreshScreen();
        }

        private void menuHiddenEditFlipToolPointerEraser_Click( object sender, EventArgs e ) {
            if ( AppManager.SelectedTool == EditTool.Arrow ) {
                AppManager.SelectedTool = EditTool.Eraser;
            } else {
                AppManager.SelectedTool = EditTool.Arrow;
            }
            RefreshScreen();
        }
        
        private void menuHiddenEditLyric_Click( object sender, EventArgs e ) {
            if ( !m_input_textbox.Enabled && AppManager.SelectedEvent.Count > 0 ) {
                VsqEvent original = AppManager.SelectedEvent.LastSelected.Original;
                int clock = original.Clock;
                int note = original.ID.Note;
                Point pos = new Point( XCoordFromClocks( clock ), YCoordFromNote( note ) );
                if ( !AppManager.EditorConfig.KeepLyricInputMode ) {
                    m_last_symbol_edit_mode = false;
                }
                ShowInputTextBox( original.ID.LyricHandle.L0.Phrase, original.ID.LyricHandle.L0.getPhoneticSymbol(), pos, m_last_symbol_edit_mode );
            } else if ( m_input_textbox.Enabled ) {
                TagLyricTextBox tltb = (TagLyricTextBox)m_input_textbox.Tag;
                if ( tltb.PhoneticSymbolEditMode ) {
                    FlipInputTextBoxMode();
                }
            }
        }
        #endregion

        #region cMenuTrackTab
        private void cMenuTrackTabCopy_Click( object sender, EventArgs e ) {
            CopyTrackCore();
        }

        private void cMenuTrackTabChangeName_Click( object sender, EventArgs e ) {
            ChangeTrackNameCore();
        }

        private void cMenuTrackTabTrackOn_Click( object sender, EventArgs e ) {
            cMenuTrackTabTrackOn.Checked = !cMenuTrackTabTrackOn.Checked;
            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandTrackChangePlayMode( AppManager.Selected,
                                                                                                      cMenuTrackTabTrackOn.Checked ? 1 : -1 ) );
            AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
            Edited = true;
            RefreshScreen();
        }

        private void cMenuTrackTabDelete_Click( object sender, EventArgs e ) {
            DeleteTrackCore();
        }

        private void cMenuTrackTabAdd_Click( object sender, EventArgs e ) {
            AddTrackCore();
        }

        private void cMenuTrackTab_Opening( object sender, CancelEventArgs e ) {
            UpdateTrackMenuStatus();
        }

        private void UpdateTrackMenuStatus() {
            cMenuTrackTabDelete.Enabled = menuTrackDelete.Enabled = (AppManager.VsqFile.Track.Count >= 3);
            cMenuTrackTabAdd.Enabled = menuTrackAdd.Enabled = (AppManager.VsqFile.Track.Count <= 16);
            cMenuTrackTabCopy.Enabled = menuTrackCopy.Enabled = (AppManager.VsqFile.Track.Count <= 16);
            cMenuTrackTabTrackOn.Checked = menuTrackOn.Checked = AppManager.VsqFile.Track[AppManager.Selected].getCommon().PlayMode >= 0;
            if ( AppManager.VsqFile.Track.Count > 2 ) {
                cMenuTrackTabOverlay.Enabled = menuTrackOverlay.Enabled = true;
                cMenuTrackTabOverlay.Checked = menuTrackOverlay.Checked = AppManager.Overlay;
            } else {
                cMenuTrackTabOverlay.Enabled = menuTrackOverlay.Enabled = false;
                cMenuTrackTabOverlay.Checked = menuTrackOverlay.Checked = false;
            }
            cMenuTrackTabRenderCurrent.Enabled = menuTrackRenderCurrent.Enabled = !AppManager.Playing;
            cMenuTrackTabRenderAll.Enabled = menuTrackRenderAll.Enabled = !AppManager.Playing;
            cMenuTrackTabRendererVOCALOID1.Checked = menuTrackRendererVOCALOID1.Checked = false;
            cMenuTrackTabRendererVOCALOID2.Checked = menuTrackRendererVOCALOID2.Checked = false;
            cMenuTrackTabRendererUtau.Checked = menuTrackRendererUtau.Checked = false;

            string version = AppManager.VsqFile.Track[AppManager.Selected].getCommon().Version;
            if ( version.StartsWith( VSTiProxy.RENDERER_DSB2 ) ) {
                cMenuTrackTabRendererVOCALOID1.Checked = menuTrackRendererVOCALOID1.Checked = true;
            } else if ( version.StartsWith( VSTiProxy.RENDERER_DSB3 ) ) {
                cMenuTrackTabRendererVOCALOID2.Checked = menuTrackRendererVOCALOID2.Checked = true;
            } else if ( version.StartsWith( VSTiProxy.RENDERER_UTU0 ) ) {
                cMenuTrackTabRendererUtau.Checked = menuTrackRendererUtau.Checked = true;
            }
        }

        private void cMenuTrackTabOverlay_Click( object sender, EventArgs e ) {
            AppManager.Overlay = !AppManager.Overlay;
            RefreshScreen();
        }

        private void cMenuTrackTabRenderCurrent_Click( object sender, EventArgs e ) {
            Render( new int[] { AppManager.Selected } );
        }

        private void cMenuTrackTabRenderer_DropDownOpening( object sender, EventArgs e ) {
            UpdateRendererMenu();
        }
        #endregion

        #region m_txtbox_track_name
        private void m_txtbox_track_name_KeyUp( object sender, KeyEventArgs e ) {
            if ( e.KeyCode == Keys.Enter ) {
                CadenciiCommand run = new CadenciiCommand(
                    VsqCommand.generateCommandTrackChangeName( AppManager.Selected, m_txtbox_track_name.Text ) );
                AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                Edited = true;
                m_txtbox_track_name.Dispose();
                m_txtbox_track_name = null;
                RefreshScreen();
            } else if ( e.KeyCode == Keys.Escape ) {
                m_txtbox_track_name.Dispose();
                m_txtbox_track_name = null;
            }
        }
        #endregion

        #region cMenuTrackSelector
        private void cMenuTrackSelector_Opening( object sender, CancelEventArgs e ) {
            UpdateCopyAndPasteButtonStatus();

            // 選択ツールの状態に合わせて表示を更新
            cMenuTrackSelectorPointer.CheckState = CheckState.Unchecked;
            cMenuTrackSelectorPencil.CheckState = CheckState.Unchecked;
            cMenuTrackSelectorLine.CheckState = CheckState.Unchecked;
            cMenuTrackSelectorEraser.CheckState = CheckState.Unchecked;
            switch ( AppManager.SelectedTool ) {
                case EditTool.Arrow:
                    cMenuTrackSelectorPointer.CheckState = CheckState.Indeterminate;
                    break;
                case EditTool.Pencil:
                    cMenuTrackSelectorPencil.CheckState = CheckState.Indeterminate;
                    break;
                case EditTool.Line:
                    cMenuTrackSelectorLine.CheckState = CheckState.Indeterminate;
                    break;
                case EditTool.Eraser:
                    cMenuTrackSelectorEraser.CheckState = CheckState.Indeterminate;
                    break;
            }
            cMenuTrackSelectorCurve.Checked = AppManager.IsCurveMode;
        }

        private void cMenuTrackSelectorPointer_Click( object sender, EventArgs e ) {
            AppManager.SelectedTool = EditTool.Arrow;
            RefreshScreen();
        }

        private void cMenuTrackSelectorPencil_Click( object sender, EventArgs e ) {
            AppManager.SelectedTool = EditTool.Pencil;
            RefreshScreen();
        }

        private void cMenuTrackSelectorLine_Click( object sender, EventArgs e ) {
            AppManager.SelectedTool = EditTool.Line;
        }

        private void cMenuTrackSelectorEraser_Click( object sender, EventArgs e ) {
            AppManager.SelectedTool = EditTool.Eraser;
        }

        private void cMenuTrackSelectorCurve_Click( object sender, EventArgs e ) {
            AppManager.IsCurveMode = !AppManager.IsCurveMode;
        }

        private void cMenuTrackSelectorSelectAll_Click( object sender, EventArgs e ) {
            SelectAllEvent();
        }

        private void cMenuTrackSelectorCut_Click( object sender, EventArgs e ) {
            CutEvent();
        }
        
        private void cMenuTrackSelectorCopy_Click( object sender, EventArgs e ) {
            CopyEvent();
        }

        private void cMenuTrackSelectorDelete_Click( object sender, EventArgs e ) {
            DeleteEvent();
        }

        private void cMenuTrackSelectorDeleteBezier_Click( object sender, EventArgs e ) {
            foreach ( SelectedBezierPoint sbp in AppManager.GetSelectedBezierEnumerator() ) {
                int chain_id = sbp.ChainID;
                int point_id = sbp.PointID;
                BezierChain chain = (BezierChain)AppManager.VsqFile.AttachedCurves[AppManager.Selected - 1].GetBezierChain( trackSelector.SelectedCurve, chain_id ).Clone();
                int index = -1;
                for ( int i = 0; i < chain.points.Count; i++ ) {
                    if ( chain.points[i].ID == point_id ) {
                        index = i;
                        break;
                    }
                }
                if ( index >= 0 ) {
                    chain.points.RemoveAt( index );
                    if ( chain.points.Count == 0 ) {
                        CadenciiCommand run = VsqFileEx.generateCommandDeleteBezierChain( AppManager.Selected,
                                                                                   trackSelector.SelectedCurve,
                                                                                   chain_id,
                                                                                   AppManager.EditorConfig.ControlCurveResolution.Value );
                        AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                    } else {
                        CadenciiCommand run = VsqFileEx.generateCommandReplaceBezierChain( AppManager.Selected,
                                                                                    trackSelector.SelectedCurve,
                                                                                    chain_id,
                                                                                    chain,
                                                                                    AppManager.EditorConfig.ControlCurveResolution.Value );
                        AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                    }
                    Edited = true;
                    RefreshScreen();
                    break;
                }
            }
        }

        private void cMenuTrackSelectorPaste_Click( object sender, EventArgs e ) {
            PasteEvent();
        }
                
        private void cMenuTrackSelectorUndo_Click( object sender, EventArgs e ) {
#if DEBUG
            AppManager.DebugWriteLine( "cMenuTrackSelectorUndo_Click" );
#endif
            Undo();
            RefreshScreen();
        }

        private void cMenuTrackSelectorRedo_Click( object sender, EventArgs e ) {
#if DEBUG
            AppManager.DebugWriteLine( "cMenuTrackSelectorRedo_Click" );
#endif
            Redo();
            RefreshScreen();
        }
        #endregion
        
        private void pictureBox3_MouseDown( object sender, MouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }

        private void pictureBox2_MouseDown( object sender, MouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }
        
        private void menuStrip1_MouseDown( object sender, MouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }

        private void timer_Tick( object sender, EventArgs e ) {
            float play_time = -1.0f;
            if ( AppManager.RendererAvailable ) {
                // レンダリング用VSTiが利用可能な状態でAppManager_PreviewStartedした場合
                if ( !AppManager.FirstBufferWritten ) {
                    return;
                }
                play_time = VSTiProxy.GetPlayTime();
            } else {
                play_time = (float)DateTime.Now.Subtract( AppManager.PreviewStartedTime ).TotalSeconds;
            }
            if ( AppManager.EditMode == EditMode.Realtime ) {
                play_time = play_time * AppManager.EditorConfig.RealtimeInputSpeed;
            }
            float now = (float)(play_time + m_direct_play_shift);
            
            if ( (play_time < 0.0 || m_preview_ending_time < now) && AppManager.EditMode != EditMode.Realtime ) {
                AppManager.Playing = false;
                timer.Stop();
                if ( AppManager.StartMarkerEnabled ) {
                    AppManager.CurrentClock = AppManager.StartMarker;
                }
                EnsureCursorVisible();
                return;
            }
            int clock = (int)AppManager.VsqFile.getClockFromSec( now );
            if ( clock > hScroll.Maximum ) {
                if ( AppManager.EditMode == EditMode.Realtime ) {
                    hScroll.Maximum = clock + (int)((pictPianoRoll.Width - AppManager._KEY_LENGTH) / 2.0f / AppManager.ScaleX);
                } else {
                    if ( !AppManager.IsRepeatMode ) {
                        timer.Stop();
                        AppManager.Playing = false;
                    }
                }
            } else if ( AppManager.EndMarkerEnabled && clock > (int)AppManager.EndMarker && AppManager.EditMode != EditMode.Realtime ) {
                AppManager.CurrentClock = (AppManager.StartMarkerEnabled) ? AppManager.StartMarker : 0;
                EnsureCursorVisible();
                AppManager.Playing = false;
                if ( AppManager.IsRepeatMode ) {
                    AppManager.Playing = true;
                } else {
                    timer.Stop();
                }
            } else {
                AppManager.CurrentClock = (int)clock;
                if ( AppManager.AutoScroll ) {
                    if ( AppManager.EditorConfig.CursorFixed ) {
                        float f_draft = clock - (pictPianoRoll.Width / 2 + 34 - 70) / AppManager.ScaleX;
                        if ( f_draft < 0f ) {
                            f_draft = 0;
                        }
                        int draft = (int)(f_draft);
                        if ( draft < hScroll.Minimum ) {
                            draft = hScroll.Minimum;
                        } else if ( hScroll.Maximum < draft ) {
                            draft = hScroll.Maximum;
                        }
                        if ( hScroll.Value != draft ) {
                            hScroll.Value = draft;
                        }
                    } else {
                        EnsureCursorVisible();
                    }
                }
            }
            RefreshScreen();
        }

        private void bgWorkScreen_DoWork( object sender, DoWorkEventArgs e ) {
            this.Invoke( new VoidDelegate( this.RefreshScreenCore ) );
        }

        private void toolStripEdit_Move( object sender, EventArgs e ) {
            AppManager.EditorConfig.ToolEditTool.Location = toolStripTool.Location;
        }

        private void toolStripEdit_ParentChanged( object sender, EventArgs e ) {
            if ( toolStripTool.Parent != null ) {
                if ( toolStripTool.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.EditorConfig.ToolEditTool.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.EditorConfig.ToolEditTool.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        private void toolStripPosition_Move( object sender, EventArgs e ) {
            AppManager.EditorConfig.ToolPositionLocation.Location = toolStripPosition.Location;
        }

        private void toolStripPosition_ParentChanged( object sender, EventArgs e ) {
            if ( toolStripPosition.Parent != null ) {
                if ( toolStripPosition.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.EditorConfig.ToolPositionLocation.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.EditorConfig.ToolPositionLocation.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        private void toolStripMeasure_Move( object sender, EventArgs e ) {
            AppManager.EditorConfig.ToolMeasureLocation.Location = toolStripMeasure.Location;
        }

        private void toolStripMeasure_ParentChanged( object sender, EventArgs e ) {
            if ( toolStripMeasure.Parent != null ) {
                if ( toolStripMeasure.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.EditorConfig.ToolMeasureLocation.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.EditorConfig.ToolMeasureLocation.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        void toolStripPaletteTools_Move( object sender, EventArgs e ) {
            AppManager.EditorConfig.ToolPaletteLocation.Location = toolStripPaletteTools.Location;
        }

        void toolStripPaletteTools_ParentChanged( object sender, EventArgs e ) {
            if ( toolStripPaletteTools.Parent != null ) {
                if ( toolStripPaletteTools.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.EditorConfig.ToolPaletteLocation.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.EditorConfig.ToolPaletteLocation.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        void toolStripFile_Move( object sender, EventArgs e ) {
            AppManager.EditorConfig.ToolFileLocation.Location = toolStripFile.Location;
        }

        void toolStripFile_ParentChanged( object sender, EventArgs e ) {
            if ( toolStripFile.Parent != null ) {
                if ( toolStripFile.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.EditorConfig.ToolFileLocation.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.EditorConfig.ToolFileLocation.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        #region stripBtn*
        private void stripBtnGrid_CheckedChanged( object sender, EventArgs e ) {
            AppManager.GridVisible = stripBtnGrid.Checked;
        }

        private void stripBtnArrow_Click( object sender, EventArgs e ) {
            AppManager.SelectedTool = EditTool.Arrow;
        }

        private void stripBtnPencil_Click( object sender, EventArgs e ) {
            AppManager.SelectedTool = EditTool.Pencil;
        }

        private void stripBtnLine_Click( object sender, EventArgs e ) {
            AppManager.SelectedTool = EditTool.Line;
        }

        private void stripBtnEraser_Click( object sender, EventArgs e ) {
            AppManager.SelectedTool = EditTool.Eraser;
        }

        private void stripBtnCurve_CheckedChanged( object sender, EventArgs e ) {
            AppManager.IsCurveMode = stripBtnCurve.Checked;
        }

        private void stripBtnPlay_Click( object sender, EventArgs e ) {
            if ( !AppManager.Playing ) {
                AppManager.Playing = true;
            }
            pictPianoRoll.Focus();
        }

        private void stripBtnScroll_Click( object sender, EventArgs e ) {
            stripBtnScroll.Checked = !stripBtnScroll.Checked;
            AppManager.AutoScroll = stripBtnScroll.Checked;
            pictPianoRoll.Focus();
        }

        private void stripBtnLoop_Click( object sender, EventArgs e ) {
            stripBtnLoop.Checked = !stripBtnLoop.Checked;
            AppManager.IsRepeatMode = stripBtnLoop.Checked;
            pictPianoRoll.Focus();
        }

        private void stripBtnStop_Click( object sender, EventArgs e ) {
            AppManager.Playing = false;
            timer.Stop();
            pictPianoRoll.Focus();
        }

        private void stripBtnStartMarker_Click( object sender, EventArgs e ) {
            stripBtnStartMarker.Checked = !stripBtnStartMarker.Checked;
            AppManager.StartMarkerEnabled = stripBtnStartMarker.Checked;
            pictPianoRoll.Focus();
            RefreshScreen();
        }

        private void stripBtnEndMarker_Click( object sender, EventArgs e ) {
            stripBtnEndMarker.Checked = !stripBtnEndMarker.Checked;
            AppManager.EndMarkerEnabled = stripBtnEndMarker.Checked;
            pictPianoRoll.Focus();
            RefreshScreen();
        }

        private void stripBtnMoveEnd_Click( object sender, EventArgs e ) {
            if ( AppManager.Playing ) {
                AppManager.Playing = false;
            }
            AppManager.CurrentClock = AppManager.VsqFile.TotalClocks;
            EnsureCursorVisible();
            RefreshScreen();
        }

        private void stripBtnMoveTop_Click( object sender, EventArgs e ) {
            if ( AppManager.Playing ) {
                AppManager.Playing = false;
            }
            AppManager.CurrentClock = 0;
            EnsureCursorVisible();
            RefreshScreen();
        }

        private void stripBtnRewind_Click( object sender, EventArgs e ) {
            Rewind();
        }

        private void stripBtnForward_Click( object sender, EventArgs e ) {
            Forward();
        }
        #endregion

        private void commonCaptureSpaceKeyDown( object sender, KeyEventArgs e ) {
            if ( (e.KeyCode & Keys.Space) == Keys.Space ) {
                m_spacekey_downed = true;
            }
        }

        private void commonCaptureSpaceKeyUp( object sender, KeyEventArgs e ) {
            if ( (e.KeyCode & Keys.Space) == Keys.Space ) {
                m_spacekey_downed = false;
            }
        }

        private void commonRendererVOCALOID1_Click( object sender, EventArgs e ) {
            string old = AppManager.VsqFile.Track[AppManager.Selected].getCommon().Version;
            if ( !old.StartsWith( VSTiProxy.RENDERER_DSB2 ) ) {
                VsqTrack item = (VsqTrack)AppManager.VsqFile.Track[AppManager.Selected].Clone();
                List<VsqID> singers = new List<VsqID>();
                foreach ( SingerConfig sc in VocaloSysUtil.getSingerConfigs1() ) {
                    singers.Add( VocaloSysUtil.getSingerID1( sc.VOICENAME ) );
                }
                item.changeRenderer( "DSB202", singers );
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( AppManager.Selected, 
                                                                             item,
                                                                             AppManager.VsqFile.AttachedCurves[AppManager.Selected - 1],
                                                                             AppManager.VsqFile.getPitchCurve( AppManager.Selected ) );
                AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                AppManager.VsqFile.Track[AppManager.Selected].setEditedStart( 0 );
                AppManager.VsqFile.Track[AppManager.Selected].setEditedEnd( AppManager.VsqFile.TotalClocks );
                cMenuTrackTabRendererVOCALOID1.Checked = true;
                cMenuTrackTabRendererVOCALOID2.Checked = false;
                cMenuTrackTabRendererUtau.Checked = false;
                menuTrackRendererVOCALOID1.Checked = true;
                menuTrackRendererVOCALOID2.Checked = false;
                menuTrackRendererUtau.Checked = false;
                Edited = true;
                RefreshScreen();
            }
        }

        private void commonRendererVOCALOID2_Click( object sender, EventArgs e ) {
            string old = AppManager.VsqFile.Track[AppManager.Selected].getCommon().Version;
            if ( !old.StartsWith( VSTiProxy.RENDERER_DSB3 ) ) {
                VsqTrack item = (VsqTrack)AppManager.VsqFile.Track[AppManager.Selected].Clone();
                List<VsqID> singers = new List<VsqID>();
                foreach ( SingerConfig sc in VocaloSysUtil.getSingerConfigs2() ) {
                    singers.Add( VocaloSysUtil.getSingerID2( sc.VOICENAME ) );
                }
                item.changeRenderer( "DSB301", singers );
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( AppManager.Selected, 
                                                                             item,
                                                                             AppManager.VsqFile.AttachedCurves[AppManager.Selected - 1],
                                                                             AppManager.VsqFile.getPitchCurve( AppManager.Selected ) );
                AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                AppManager.VsqFile.Track[AppManager.Selected].setEditedStart( 0 );
                AppManager.VsqFile.Track[AppManager.Selected].setEditedEnd( AppManager.VsqFile.TotalClocks );
                cMenuTrackTabRendererVOCALOID1.Checked = false;
                cMenuTrackTabRendererVOCALOID2.Checked = true;
                cMenuTrackTabRendererUtau.Checked = false;
                menuTrackRendererVOCALOID1.Checked = false;
                menuTrackRendererVOCALOID2.Checked = true;
                menuTrackRendererUtau.Checked = false;
                Edited = true;
                RefreshScreen();
            }
        }

        private void commonRendererUtau_Click( object sender, EventArgs e ) {
            string old = AppManager.VsqFile.Track[AppManager.Selected].getCommon().Version;
            if ( !old.StartsWith( VSTiProxy.RENDERER_UTU0 ) ) {
                VsqTrack item = (VsqTrack)AppManager.VsqFile.Track[AppManager.Selected].Clone();
                List<SingerConfig> list = AppManager.EditorConfig.UtauSingers;
                List<VsqID> singers = new List<VsqID>();
                foreach ( SingerConfig sc in list ) {
                    singers.Add( AppManager.getSingerIDUtau( sc.VOICENAME ) );
                }
                item.changeRenderer( "UTU000", singers );
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( AppManager.Selected, 
                                                                             item,
                                                                             AppManager.VsqFile.AttachedCurves[AppManager.Selected - 1],
                                                                             AppManager.VsqFile.getPitchCurve( AppManager.Selected ) );
                AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                AppManager.VsqFile.Track[AppManager.Selected].setEditedStart( 0 );
                AppManager.VsqFile.Track[AppManager.Selected].setEditedEnd( AppManager.VsqFile.TotalClocks );
                cMenuTrackTabRendererVOCALOID1.Checked = false;
                cMenuTrackTabRendererVOCALOID2.Checked = false;
                cMenuTrackTabRendererUtau.Checked = true;
                menuTrackRendererVOCALOID1.Checked = false;
                menuTrackRendererVOCALOID2.Checked = false;
                menuTrackRendererUtau.Checked = true;
                Edited = true;
                RefreshScreen();
            }
        }

        private void commonMasterTuning_Click( object sender, EventArgs e ) {
            using ( FormTrackProperty dlg = new FormTrackProperty( AppManager.VsqFile.AttachedCurves[AppManager.Selected - 1].MasterTuningInCent ) ) {
                dlg.Location = GetFormPreferedLocation( dlg );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    CadenciiCommand run = VsqFileEx.generateCommandTrackChangeMasterTune( AppManager.Selected, dlg.MasterTuningInCent );
                    AppManager.Register( AppManager.VsqFile.executeCommand( run ) );
                    Edited = true;
                }
            }
        }

        private void toolStripContainer_TopToolStripPanel_SizeChanged( object sender, EventArgs e ) {
            if ( this.WindowState == FormWindowState.Minimized ) {
                return;
            }
            Size minsize = GetWindowMinimumSize();
            int wid = this.Width;
            int hei = this.Height;
            bool change_size_required = false;
            if ( minsize.Width > wid ) {
                wid = minsize.Width;
                change_size_required = true;
            }
            if ( minsize.Height > hei ) {
                hei = minsize.Height;
                change_size_required = true;
            }
            this.MinimumSize = GetWindowMinimumSize();
            if ( change_size_required ) {
                this.Size = new Size( wid, hei );
            }
        }

        private void stripDDBtnSpeed_DropDownOpening( object sender, EventArgs e ) {
            if ( AppManager.EditorConfig.RealtimeInputSpeed == 1.0f ) {
                stripDDBtnSpeed100.Checked = true;
                stripDDBtnSpeed050.Checked = false;
                stripDDBtnSpeed033.Checked = false;
                stripDDBtnSpeedTextbox.Text = "100";
            } else if ( AppManager.EditorConfig.RealtimeInputSpeed == 0.5f ) {
                stripDDBtnSpeed100.Checked = false;
                stripDDBtnSpeed050.Checked = true;
                stripDDBtnSpeed033.Checked = false;
                stripDDBtnSpeedTextbox.Text = "50";
            } else if ( AppManager.EditorConfig.RealtimeInputSpeed == 1.0f / 3.0f ) {
                stripDDBtnSpeed100.Checked = false;
                stripDDBtnSpeed050.Checked = false;
                stripDDBtnSpeed033.Checked = true;
                stripDDBtnSpeedTextbox.Text = "33.333";
            } else {
                stripDDBtnSpeed100.Checked = false;
                stripDDBtnSpeed050.Checked = false;
                stripDDBtnSpeed033.Checked = false;
                stripDDBtnSpeedTextbox.Text = (AppManager.EditorConfig.RealtimeInputSpeed * 100.0f).ToString();
            }
        }

        private void stripDDBtnSpeed100_Click( object sender, EventArgs e ) {
            ChangeRealtimeInputSpeed( 1.0f );
            AppManager.EditorConfig.RealtimeInputSpeed = 1.0f;
            UpdateStripDDBtnSpeed();
        }

        private void stripDDBtnSpeed050_Click( object sender, EventArgs e ) {
            ChangeRealtimeInputSpeed( 0.5f );
            AppManager.EditorConfig.RealtimeInputSpeed = 0.5f;
            UpdateStripDDBtnSpeed();
        }

        private void stripDDBtnSpeed033_Click( object sender, EventArgs e ) {
            ChangeRealtimeInputSpeed( 1.0f / 3.0f );
            AppManager.EditorConfig.RealtimeInputSpeed = 1.0f / 3.0f;
            UpdateStripDDBtnSpeed();
        }

        private void stripDDBtnSpeedTextbox_KeyDown( object sender, KeyEventArgs e ) {
            if ( e.KeyCode == Keys.Enter ) {
                float v;
                if ( float.TryParse( stripDDBtnSpeedTextbox.Text, out v ) ) {
                    ChangeRealtimeInputSpeed( v / 100.0f );
                    AppManager.EditorConfig.RealtimeInputSpeed = v / 100.0f;
                    stripDDBtnSpeed.HideDropDown();
                    UpdateStripDDBtnSpeed();
                }
            }
        }

        private void ChangeRealtimeInputSpeed( float newv ) {
            float old = AppManager.EditorConfig.RealtimeInputSpeed;
            DateTime now = DateTime.Now;
            float play_time = (float)now.Subtract( AppManager.PreviewStartedTime ).TotalSeconds * old / newv;
            int sec = (int)(Math.Floor( play_time ) + 0.1);
            int millisec = (int)((play_time - sec) * 1000);
            AppManager.PreviewStartedTime = now.Subtract( new TimeSpan( 0, 0, 0, sec, millisec ) );
            MidiPlayer.SetSpeed( newv, AppManager.PreviewStartedTime );
        }

        /// <summary>
        /// stripDDBtnSpeedの表示状態を更新します
        /// </summary>
        private void UpdateStripDDBtnSpeed() {
            stripDDBtnSpeed.Text = _( "Speed" ) + " " + (AppManager.EditorConfig.RealtimeInputSpeed * 100) + "%";
        }

        private void menuSetting_DropDownOpening( object sender, EventArgs e ) {
            menuSettingMidi.Enabled = AppManager.EditMode != EditMode.Realtime;
        }

        private void menuVisualProperty_CheckedChanged( object sender, EventArgs e ) {
            AppManager.NotePropertyDlg.Visible = menuVisualProperty.Checked;
            AppManager.EditorConfig.PropertyWindowVisible = menuVisualProperty.Checked;
        }

        private void menuSettingUtauVoiceDB_Click( object sender, EventArgs e ) {
#if VER22
            if ( m_utau_voice_dialog == null ) {
                m_utau_voice_dialog = new FormUtauVoiceConfig();
                m_utau_voice_dialog.FormClosing += new FormClosingEventHandler( m_utau_voice_dialog_FormClosing );
                m_utau_voice_dialog.ApplyFont( AppManager.EditorConfig.BaseFont );
                m_utau_voice_dialog.CurrentConfig = AppManager.EditorConfig.FormConfigUtauVoiceConfig;
            }
            if ( !m_utau_voice_dialog.Visible ) {
                m_utau_voice_dialog.Location = GetFormPreferedLocation( m_utau_voice_dialog );
                m_utau_voice_dialog.Show();
            }
#endif
        }

        private void m_utau_voice_dialog_FormClosing( object sender, FormClosingEventArgs e ) {
#if VER22
            if ( e.CloseReason == CloseReason.UserClosing ) {
                e.Cancel = true;
                m_utau_voice_dialog.Visible = false;
            }
#endif
        }

    }

}
