﻿/*
 * FormMain.cs
 * Copyright (C) 2008-2010 kbinani
 *
 * This file is part of org.kbinani.cadencii.
 *
 * org.kbinani.cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the GPLv3 License.
 *
 * org.kbinani.cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#if JAVA
package org.kbinani.cadencii;

//INCLUDE-SECTION IMPORT ../BuildJavaUI/src/org/kbinani/Cadencii/FormMain.java

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import org.kbinani.*;
import org.kbinani.apputil.*;
import org.kbinani.componentmodel.*;
import org.kbinani.media.*;
import org.kbinani.vsq.*;
import org.kbinani.windows.forms.*;
import org.kbinani.xml.*;
#else
using System;
using System.Diagnostics;
using System.Media;
using System.Threading;
using System.Text;
using org.kbinani.apputil;
using org.kbinani.componentmodel;
using org.kbinani.java.awt;
using org.kbinani.java.awt.event_;
using org.kbinani.java.io;
using org.kbinani.java.util;
using org.kbinani.javax.swing;
using org.kbinani.media;
using org.kbinani.vsq;
using org.kbinani.windows.forms;
using org.kbinani.xml;

namespace org.kbinani.cadencii {
    using BCancelEventArgs = System.ComponentModel.CancelEventArgs;
    using BDoWorkEventArgs = System.ComponentModel.DoWorkEventArgs;
    using BFormClosedEventArgs = System.Windows.Forms.FormClosedEventArgs;
    using BFormClosingEventArgs = System.Windows.Forms.FormClosingEventArgs;
    using BKeyEventArgs = System.Windows.Forms.KeyEventArgs;
    using BKeyPressEventArgs = System.Windows.Forms.KeyPressEventArgs;
    using BMouseButtons = System.Windows.Forms.MouseButtons;
    using BMouseEventArgs = System.Windows.Forms.MouseEventArgs;
    using boolean = System.Boolean;
    using BPaintEventArgs = System.Windows.Forms.PaintEventArgs;
    using BPreviewKeyDownEventArgs = System.Windows.Forms.PreviewKeyDownEventArgs;
    using Integer = System.Int32;
    using Long = System.Int64;
#endif

    /// <summary>
    /// エディタのメイン画面クラス
    /// </summary>
#if JAVA
    public class FormMain extends BForm{
#else
    public class FormMain : BForm {
#endif
        /// <summary>
        /// 通常のショートカットを登録できないメニューアイテムと、ショートカットキーとの紐付けを保持するクラスです。
        /// </summary>
        private class SpecialShortcutHolder {
            /// <summary>
            /// ショートカットキーを表すKeyStrokeクラスのインスタンス
            /// </summary>
            public KeyStroke shortcut;
            /// <summary>
            /// ショートカットキーとの紐付けを行う相手先のメニューアイテム
            /// </summary>
            public BMenuItem menu;

            /// <summary>
            /// ショートカットキーとメニューアイテムを指定したコンストラクタ
            /// </summary>
            /// <param name="shortcut">ショートカットキー</param>
            /// <param name="menu">ショートカットキーとの紐付けを行うメニューアイテム</param>
            public SpecialShortcutHolder( KeyStroke shortcut, BMenuItem menu ) {
                this.shortcut = shortcut;
                this.menu = menu;
            }
        }

        #region static readonly field
        private readonly Color s_pen_105_105_105 = new Color( 105, 105, 105 );
        private readonly Color s_pen_187_187_255 = new Color( 187, 187, 255 );
        public readonly Color s_pen_007_007_151 = new Color( 7, 7, 151 );
        public readonly Color s_pen_065_065_065 = new Color( 65, 65, 65 );
        public readonly Color s_txtbox_backcolor = new Color( 128, 128, 128 );
        public readonly Color s_note_fill = new Color( 181, 220, 86 );
        private readonly AuthorListEntry[] _CREDIT = new AuthorListEntry[]{
            new AuthorListEntry( "is developped by:", 2 ),
            new AuthorListEntry( "kbinani", "@kbinani" ),
            new AuthorListEntry( "修羅場P", "@shurabaP" ),
            new AuthorListEntry( "もみじぱん", "@momijipan" ),
            new AuthorListEntry(),
            new AuthorListEntry(),
            new AuthorListEntry( "Special Thanks to", 3 ),
            new AuthorListEntry(),
            new AuthorListEntry( "tool icons designer:", 2 ),
            new AuthorListEntry( "Yusuke KAMIYAMANE", "@ykamiyamane" ),
            new AuthorListEntry(),
            new AuthorListEntry( "developper of STRAIGHT LIBRARY:", 2 ),
            new AuthorListEntry( "Hideki KAWAHARA" ),
            new AuthorListEntry( "Tetsu TAKAHASHI" ),
            new AuthorListEntry( "Hideki BANNO" ),
            new AuthorListEntry( "Masanori MORISE", "@m_morise" ),
            new AuthorListEntry( "(sorry, list is not complete)", 2 ),
            new AuthorListEntry(),
            new AuthorListEntry( "developper of v.Connect:", 2 ),
            new AuthorListEntry( "修羅場P", "@shurabaP" ),
            new AuthorListEntry(),
            new AuthorListEntry( "developper of UTAU:", 2 ),
            new AuthorListEntry( "飴屋/菖蒲", "@ameyaP_" ),
            new AuthorListEntry(),
            new AuthorListEntry( "promoter:", 2 ),
            new AuthorListEntry( "zhuo", "@zhuop" ),
            new AuthorListEntry(),
            new AuthorListEntry( "library tester:", 2 ),
            new AuthorListEntry( "evm" ),
            new AuthorListEntry( "そろそろP" ),
            new AuthorListEntry( "めがね１１０" ),
            new AuthorListEntry( "上総" ),
            new AuthorListEntry( "NOIKE" ),
            new AuthorListEntry( "逃亡者" ),
            new AuthorListEntry(),
            new AuthorListEntry( "translator:", 2 ),
            new AuthorListEntry( "Eji (zh-TW translation)", "@ejiwarp" ),
            new AuthorListEntry( "kankan (zh-TW translation)" ),
            new AuthorListEntry( "yxmline (zh-CN translation)" ),
            new AuthorListEntry(),
            new AuthorListEntry(),
            new AuthorListEntry( "Thanks to", 3 ),
            new AuthorListEntry(),
            new AuthorListEntry( "ないしょの人" ),
            new AuthorListEntry( "naquadah" ),
            new AuthorListEntry( "1zo" ),
            new AuthorListEntry( "Amby" ),
            new AuthorListEntry( "ケロッグ" ),
            new AuthorListEntry( "beginner" ),
            new AuthorListEntry( "b2ox", "@b2ox" ),
            new AuthorListEntry( "麻太郎" ),
            new AuthorListEntry( "PEX", "@pex_zeo" ),
            new AuthorListEntry( "やなぎがうら" ),
            new AuthorListEntry( "cocoonP", "@cocoonP" ),
            new AuthorListEntry( "かつ" ),
            new AuthorListEntry( "ちゃそ" ),
            new AuthorListEntry( "ちょむ" ),
            new AuthorListEntry( "whimsoft" ),
            new AuthorListEntry( "kitiketao", "@okoktaokokta" ),
            new AuthorListEntry( "カプチ２" ),
            new AuthorListEntry( "あにぃ" ),
            new AuthorListEntry( "tomo" ),
            new AuthorListEntry( "ナウ□マP", "@now_romaP" ),
            new AuthorListEntry( "内藤　魅亜", "@mianaito" ),
            new AuthorListEntry( "空茶", "@maizeziam" ),
            new AuthorListEntry( "いぬくま" ),
            new AuthorListEntry( "shu-t", "@shu_sonicwave" ),
            new AuthorListEntry( "さささ", "@sasasa3396" ),
            new AuthorListEntry( "あろも～ら", "@aromora" ),
            new AuthorListEntry( "空耳P", "@soramiku" ),
            new AuthorListEntry( "kotoi" ),
            new AuthorListEntry( "げっぺータロー", "@geppeitaro" ),
            new AuthorListEntry( "みけCAT" ),
            new AuthorListEntry( "all members of Cadencii bbs", 2 ),
            new AuthorListEntry(),
            new AuthorListEntry( "     ... and you !", 3 ),
        };
        public readonly Font s_F9PT = new Font( "SansSerif", java.awt.Font.PLAIN, AppManager.FONT_SIZE9 );
        #endregion

        #region constants and internal enums
        /// <summary>
        /// カーブエディタ画面の編集モード
        /// </summary>
        enum CurveEditMode {
            /// <summary>
            /// 何もしていない
            /// </summary>
            NONE,
            /// <summary>
            /// 鉛筆ツールで編集するモード
            /// </summary>
            EDIT,
            /// <summary>
            /// ラインツールで編集するモード
            /// </summary>
            LINE,
            /// <summary>
            /// 鉛筆ツールでVELを編集するモード
            /// </summary>
            EDIT_VEL,
            /// <summary>
            /// ラインツールでVELを編集するモード
            /// </summary>
            LINE_VEL,
            /// <summary>
            /// 真ん中ボタンでドラッグ中
            /// </summary>
            MIDDLE_DRAG,
        }

        enum ExtDragXMode {
            RIGHT,
            LEFT,
            NONE,
        }

        enum ExtDragYMode {
            UP,
            DOWN,
            NONE,
        }

        enum GameControlMode {
            DISABLED,
            NORMAL,
            KEYBOARD,
            CURSOR,
        }

        enum OverviewMouseDownMode {
            NONE,
            LEFT,
            MIDDLE,
        }

        enum PositionIndicatorMouseDownMode {
            NONE,
            MARK_START,
            MARK_END,
            TEMPO,
            TIMESIG,
        }

        /// <summary>
        /// スクロールバーの最小サイズ(ピクセル)
        /// </summary>
        public const int MIN_BAR_ACTUAL_LENGTH = 17;
        /// <summary>
        /// エントリの端を移動する時の、ハンドル許容範囲の幅
        /// </summary>
        public const int _EDIT_HANDLE_WIDTH = 7;
        public const int _TOOL_BAR_HEIGHT = 46;
        /// <summary>
        /// 単音プレビュー時に、wave生成完了を待つ最大の秒数
        /// </summary>
        public const double _WAIT_LIMIT = 5.0;
        public const String _APP_NAME = "Cadencii";
        /// <summary>
        /// 表情線の先頭部分のピクセル幅
        /// </summary>
        public const int _PX_ACCENT_HEADER = 21;
        /// <summary>
        /// パフォーマンスカウンタ用バッファの容量
        /// </summary>
        public const int _NUM_PCOUNTER = 50;
        public const String _VERSION_HISTORY_URL = "http://www.ne.jp/asahi/kbinani/home/cadencii/version_history.xml";
        /// <summary>
        /// splitContainer2.Panel2の最小サイズ
        /// </summary>
        public const int _SPL2_PANEL2_MIN_HEIGHT = 25;
        /// <summary>
        /// splitContainer*で使用するSplitterWidthプロパティの値
        /// </summary>
        public const int _SPL_SPLITTER_WIDTH = 4;
        const int _PICT_POSITION_INDICATOR_HEIGHT = 48;
        const int _SCROLL_WIDTH = 16;
        /// <summary>
        /// Overviewペインの高さ
        /// </summary>
        const int _OVERVIEW_HEIGHT = 50;
        /// <summary>
        /// splitContainerPropertyの最小幅
        /// </summary>
        const int _PROPERTY_DOCK_MIN_WIDTH = 50;
        /// <summary>
        /// Overviewに描く音符を表す円の直径
        /// </summary>
        const int _OVERVIEW_DOT_DIAM = 2;
        /// <summary>
        /// btnLeft, btnRightを押した時の、スクロール速度(px/sec)。
        /// </summary>
        const float _OVERVIEW_SCROLL_SPEED = 500.0f;
        const int _OVERVIEW_SCALE_COUNT_MAX = 7;
        const int _OVERVIEW_SCALE_COUNT_MIN = 3;
        /// <summary>
        /// WAVE再生時のバッファーサイズの最大値
        /// </summary>
        const int MAX_WAVE_MSEC_RESOLUTION = 1000;
        /// <summary>
        /// WAVE再生時のバッファーサイズの最小値
        /// </summary>
        const int MIN_WAVE_MSEC_RESOLUTION = 100;
        #endregion

        #region static field
        /// <summary>
        /// CTRLキー。MacOSXの場合はMenu
        /// </summary>
        public int s_modifier_key = InputEvent.CTRL_MASK;
        #endregion

        #region fields
        public VersionInfo m_versioninfo = null;
#if !JAVA
        public System.Windows.Forms.Cursor HAND;
#endif
        /// <summary>
        /// ボタンがDownされた位置。(座標はpictureBox基準)
        /// </summary>
        public Point m_button_initial = new Point();
        /// <summary>
        /// 真ん中ボタンがダウンされたときのvscrollのvalue値
        /// </summary>
        public int m_middle_button_vscroll;
        /// <summary>
        /// 真ん中ボタンがダウンされたときのhscrollのvalue値
        /// </summary>
        public int m_middle_button_hscroll;
        public boolean m_edited = false;
        /// <summary>
        /// パフォーマンスカウンタ
        /// </summary>
        public float[] m_performance = new float[_NUM_PCOUNTER];
        /// <summary>
        /// 最後にメイン画面が更新された時刻(秒単位)
        /// </summary>
        public double _last_screen_refreshed_sec;
        /// <summary>
        /// パフォーマンスカウンタから算出される画面の更新速度
        /// </summary>
        public float m_fps = 0f;
        /// <summary>
        /// カーブエディタの編集モード
        /// </summary>
        private CurveEditMode m_edit_curve_mode = CurveEditMode.NONE;
        /// <summary>
        /// ピアノロールの右クリックが表示される直前のマウスの位置
        /// </summary>
        public Point m_cMenuOpenedPosition = new Point();
        /// <summary>
        /// トラック名の入力に使用するテキストボックス
        /// </summary>
        public LyricTextBox m_txtbox_track_name;
        /// <summary>
        /// ピアノロールの画面外へのドラッグ時、前回自動スクロール操作を行った時刻
        /// </summary>
        public double m_timer_drag_last_ignitted;
        /// <summary>
        /// 画面外への自動スクロールモード
        /// </summary>
        private ExtDragXMode m_ext_dragx = ExtDragXMode.NONE;
        private ExtDragYMode m_ext_dragy = ExtDragYMode.NONE;
        /// <summary>
        /// EditMode=MoveEntryで，移動を開始する直前のマウスの仮想スクリーン上の位置
        /// </summary>
        public Point m_mouse_move_init = new Point();
        /// <summary>
        /// EditMode=MoveEntryで，移動を開始する直前のマウスの位置と，音符の先頭との距離(ピクセル)
        /// </summary>
        public int m_mouse_move_offset;
        /// <summary>
        /// マウスが降りているかどうかを表すフラグ．AppManager.isPointerDownedとは別なので注意
        /// </summary>
        public boolean m_mouse_downed = false;
        public int m_tempo_dragging_deltaclock = 0;
        public int m_timesig_dragging_deltaclock = 0;
        public boolean m_mouse_downed_trackselector = false;
        private ExtDragXMode m_ext_dragx_trackselector = ExtDragXMode.NONE;
        public boolean m_mouse_moved = false;
#if ENABLE_MOUSEHOVER
        /// <summary>
        /// マウスホバーを発生させるスレッド
        /// </summary>
        public Thread m_mouse_hover_thread = null;
#endif
        public boolean m_last_is_imemode_on = true;
        public boolean m_last_symbol_edit_mode = false;
        /// <summary>
        /// 鉛筆のモード
        /// </summary>
        public PencilMode m_pencil_mode = new PencilMode();
        /// <summary>
        /// ビブラート範囲を編集中の音符のInternalID
        /// </summary>
        public int m_vibrato_editing_id = -1;
        /// <summary>
        /// このフォームがアクティブ化されているかどうか
        /// </summary>
        public boolean m_form_activated = true;
        private GameControlMode m_game_mode = GameControlMode.DISABLED;
        /// <summary>
        /// 直接再生モード時の、再生開始した位置の曲頭からの秒数
        /// </summary>
        public float m_direct_play_shift = 0.0f;
        /// <summary>
        /// プレビュー再生の長さ
        /// </summary>
        public double m_preview_ending_time;
        public BTimer m_timer;
        public boolean m_last_pov_r = false;
        public boolean m_last_pov_l = false;
        public boolean m_last_pov_u = false;
        public boolean m_last_pov_d = false;
        public boolean m_last_btn_x = false;
        public boolean m_last_btn_o = false;
        public boolean m_last_btn_re = false;
        public boolean m_last_btn_tr = false;
        public boolean m_last_select = false;
        /// <summary>
        /// 前回ゲームコントローラのイベントを処理した時刻
        /// </summary>
        public double m_last_event_processed;
        /// <summary>
        /// splitContainer2.Panel2を最小化する直前の、splitContainer2.SplitterDistance
        /// </summary>
        public int m_last_splitcontainer2_split_distance = -1;
        public boolean m_spacekey_downed = false;
#if ENABLE_MIDI
        public MidiInDevice m_midi_in = null;
#endif
#if ENABLE_MTC
        public MidiInDevice m_midi_in_mtc = null;
#endif
        public FormMidiImExport m_midi_imexport_dialog = null;
        public TreeMap<EditTool, Cursor> m_cursor = new TreeMap<EditTool, Cursor>();
        private Preference m_preference_dlg;
#if ENABLE_MIDI
        public BToolStripButton m_strip_ddbtn_metronome;
#endif
#if ENABLE_PROPERTY
        public PropertyPanelContainer m_property_panel_container;
#endif
#if ENABLE_SCRIPT
        public Vector<BToolStripButton> m_palette_tools = new Vector<BToolStripButton>();
#endif

        public int m_overview_direction = 1;
        public Thread m_overview_update_thread = null;
        public int m_overview_start_to_draw_clock_initial_value;
        /// <summary>
        /// btnLeftまたはbtnRightが下りた時刻
        /// </summary>
        public double m_overview_btn_downed;
        /// <summary>
        /// ミニチュア・ピアノロール画面左端でのクロック
        /// </summary>
        public int m_overview_start_to_draw_clock = 0;
        /// <summary>
        /// ミニチュア・ピアノロール画面の表示倍率
        /// </summary>
        public float m_overview_px_per_clock = 0.01f;
        /// <summary>
        /// ミニチュア・ピアノロール画面に表示されている音符の，平均ノートナンバー．これが，縦方向の中心線に反映される
        /// </summary>
        public float m_overview_average_note = 60.0f;
        /// <summary>
        /// ミニチュア・ピアノロール画面でマウスが降りている状態かどうか
        /// </summary>
        private OverviewMouseDownMode m_overview_mouse_down_mode = OverviewMouseDownMode.NONE;
        /// <summary>
        /// PositionIndicatorのマウスモード
        /// </summary>
        private PositionIndicatorMouseDownMode m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
        /// <summary>
        /// ミニチュア・ピアノロール画面で、マウスが下りた位置のx座標
        /// </summary>
        public int m_overview_mouse_downed_locationx;
        public int m_overview_scale_count = 5;
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入ったかどうか
        /// </summary>
        public boolean m_key_length_splitter_mouse_downed = false;
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入る直前での、マウスのスクリーン座標
        /// </summary>
        public Point m_key_length_splitter_initial_mouse = new Point();
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入る直前での、keyWidthの値
        /// </summary>
        public int m_key_length_init_value = 68;
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入る直前での、trackSelectorのgetRowsPerColumn()の値
        /// </summary>
        public int m_key_length_trackselector_rowspercolumn = 1;
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入る直前での、splitContainer1のSplitterLocationの値
        /// </summary>
        public int m_key_length_splitter_distance = 0;
        public BFileChooser openXmlVsqDialog;
        public BFileChooser saveXmlVsqDialog;
        public BFileChooser openUstDialog;
        public BFileChooser openMidiDialog;
        public BFileChooser saveMidiDialog;
        public BFileChooser openWaveDialog;
        public BTimer timer;
        public BBackgroundWorker bgWorkScreen;
        public WaveView waveView;
        /// <summary>
        /// アイコンパレットのドラッグ＆ドロップ処理中，一度でもpictPianoRoll内にマウスが入ったかどうか
        /// </summary>
        private boolean iconPaletteOnceDragEntered = false;
        private byte mtcFrameLsb;
        private byte mtcFrameMsb;
        private byte mtcSecLsb;
        private byte mtcSecMsb;
        private byte mtcMinLsb;
        private byte mtcMinMsb;
        private byte mtcHourLsb;
        private byte mtcHourMsb;
        /// <summary>
        /// MTCを最後に受信した時刻
        /// </summary>
        private double mtcLastReceived = 0.0;
        /// <summary>
        /// AppManager.inputTextBoxがhideInputTextBoxによって隠された後、何回目のEnterキーの入力を受けたかを表すカウンター。
        /// </summary>
        private int numEnterKeyAfterHideInputTextBox = 0;
        /// <summary>
        /// 特殊な取り扱いが必要なショートカットのキー列と、対応するメニューアイテムを保存しておくリスト。
        /// </summary>
        private Vector<SpecialShortcutHolder> specialShortcutHolders = new Vector<SpecialShortcutHolder>();
        /// <summary>
        /// 歌詞流し込み用のダイアログ
        /// </summary>
        private FormImportLyric formImportLyric = null;
        /// <summary>
        /// ミニチュアピアノロールの左側の第1ボタン上でマウスが下りている状態かどうか
        /// </summary>
        private boolean _overviewButtonLeft1MouseDowned = false;
        /// <summary>
        /// ミニチュアピアノロールの左側の第2ボタン上でマウスが下りている状態かどうか
        /// </summary>
        private boolean _overviewButtonLeft2MouseDowned = false;
        /// <summary>
        /// ミニチュアピアノロールの右側の第1ボタン上でマウスが下りている状態かどうか
        /// </summary>
        private boolean _overviewButtonRight1MouseDowned = false;
        /// <summary>
        /// ミニチュアピアノロールの右側の第2ボタン上でマウスが下りている状態かどうか
        /// </summary>
        private boolean _overviewButtonRight2MouseDowned = false;
        /// <summary>
        /// ミニチュアピアノロールの拡大ボタン上でマウスが下りている状態かどうか
        /// </summary>
        private boolean _overviewButtonZoomMouseDowned = false;
        /// <summary>
        /// ミニチュアピアノロールの縮小ボタン上でマウスが下りている状態かどうか
        /// </summary>
        private boolean _overviewButtonMoozMouseDowned = false;
        /// <summary>
        /// デフォルトのストローク
        /// </summary>
        private BasicStroke _strokeDefault = null;
        /// <summary>
        /// 描画幅2pxのストローク
        /// </summary>
        private BasicStroke _stroke2px = null;
#if MONITOR_FPS
        /// <summary>
        /// パフォーマンスカウンタ
        /// </summary>
        private double[] mFpsDrawTime = new double[128];
        private int mFpsDrawTimeIndex = 0;
        /// <summary>
        /// パフォーマンスカウンタから算出される画面の更新速度
        /// </summary>
        private float mFps = 0f;
        private double[] mFpsDrawTime2 = new double[128];
        private float mFps2 = 0f;
#endif
        #endregion

        #region constructor
        public FormMain( String file ) {
#if JAVA
		    super();
#endif

            try {
                Messaging.loadMessages();
                Messaging.setLanguage( AppManager.editorConfig.Language );
            } catch ( Exception ex ) {
                PortUtil.stderr.println( "FormMain#.ctor; ex=" + ex );
            }

#if ENABLE_PROPERTY
            AppManager.propertyPanel = new PropertyPanel();
            AppManager.propertyWindow = new FormNoteProperty();
            AppManager.propertyWindow.Controls.Add( AppManager.propertyPanel );
            AppManager.propertyPanel.Dock = System.Windows.Forms.DockStyle.Fill;
#endif

#if DEBUG
            AppManager.debugWriteLine( "FormMain..ctor()" );
#endif
            AppManager.baseFont10Bold = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.BOLD, AppManager.FONT_SIZE10 );
            AppManager.baseFont8 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE8 );
            AppManager.baseFont10 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE10 );
            AppManager.baseFont9 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE9 );
            AppManager.baseFont50Bold = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.BOLD, AppManager.FONT_SIZE50 );

            s_modifier_key = ((AppManager.editorConfig.Platform == PlatformEnum.Macintosh) ? InputEvent.META_MASK : InputEvent.CTRL_MASK);

            VsqFileEx tvsq = new VsqFileEx( AppManager.editorConfig.DefaultSingerName,
                                            AppManager.editorConfig.DefaultPreMeasure,
                                            4,
                                            4,
                                            500000 );
            RendererKind kind = AppManager.editorConfig.DefaultSynthesizer;
            String renderer = AppManager.getVersionStringFromRendererKind( kind );
            Vector<VsqID> singers = AppManager.getSingerListFromRendererKind( kind );
            tvsq.Track.get( 1 ).changeRenderer( renderer, singers );
            AppManager.setVsqFile( tvsq );
#if JAVA
		    initialize();
            timer = new BTimer();
            getCMenuPiano();
            getCMenuTrackTab();
            getCMenuTrackSelector();

#else
            InitializeComponent();
            timer = new BTimer( this.components );
#endif
            bgWorkScreen = new BBackgroundWorker();
            waveView = new WaveView();
#if JAVA
#else
            this.panel2.Controls.Add( this.waveView );
            this.waveView.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.waveView.BackColor = System.Drawing.Color.FromArgb( ((int)(((byte)(212)))), ((int)(((byte)(212)))), ((int)(((byte)(212)))) );
            this.waveView.Location = new System.Drawing.Point( 66, 0 );
            this.waveView.Margin = new System.Windows.Forms.Padding( 0 );
            this.waveView.Name = "waveView";
            this.waveView.Size = new System.Drawing.Size( 355, 59 );
            this.waveView.TabIndex = 17;
#endif
            registerEventHandlers();
            setResources();

            openXmlVsqDialog = new BFileChooser( "" );
            openXmlVsqDialog.addFileFilter( "VSQ Format(*.vsq)|*.vsq" );
            openXmlVsqDialog.addFileFilter( "Original Format(*.evsq)|*.evsq" );

            saveXmlVsqDialog = new BFileChooser( "" );
            saveXmlVsqDialog.addFileFilter( "VSQ Format(*.vsq)|*.vsq" );
            saveXmlVsqDialog.addFileFilter( "Original Format(*.evsq)|*.evsq" );
            saveXmlVsqDialog.addFileFilter( "All files(*.*)|*.*" );

            openUstDialog = new BFileChooser( "" );
            openUstDialog.addFileFilter( "UTAU Project File(*.ust)|*.ust" );
            openUstDialog.addFileFilter( "All Files(*.*)|*.*" );

            openMidiDialog = new BFileChooser( "" );
            saveMidiDialog = new BFileChooser( "" );
            openWaveDialog = new BFileChooser( "" );

            m_overview_scale_count = AppManager.editorConfig.OverviewScaleCount;
            m_overview_px_per_clock = getOverviewScaleX( m_overview_scale_count );

            menuVisualOverview.setSelected( AppManager.editorConfig.OverviewEnabled );
#if ENABLE_PROPERTY
            m_property_panel_container = new PropertyPanelContainer();
#endif

#if !ENABLE_SCRIPT
            menuSettingPaletteTool.setVisible( false );
            menuScript.setVisible( false );
#endif

#if ENABLE_MIDI
            m_strip_ddbtn_metronome = new BToolStripButton();
            m_strip_ddbtn_metronome.setText( "Metronome" );
            m_strip_ddbtn_metronome.Name = "m_strip_ddbtn_metronome";
            m_strip_ddbtn_metronome.CheckOnClick = true;
            m_strip_ddbtn_metronome.setSelected( AppManager.editorConfig.MetronomeEnabled );
            m_strip_ddbtn_metronome.CheckedChanged += new EventHandler( m_strip_ddbtn_metronome_CheckedChanged );
            toolStripBottom.Items.Add( m_strip_ddbtn_metronome );
#endif

            trackSelector = new TrackSelector();
            updateTrackSelectorVisibleCurve();
            trackSelector.setBackground( new Color( 108, 108, 108 ) );
            trackSelector.setCurveVisible( true );
            trackSelector.setSelectedCurve( CurveType.VEL );
#if !JAVA
            trackSelector.setLocation( new Point( 0, 242 ) );
            trackSelector.Margin = new System.Windows.Forms.Padding( 0 );
            trackSelector.Name = "trackSelector";
            trackSelector.setSize( 446, 250 );
            trackSelector.TabIndex = 0;
#endif
            trackSelector.mouseClickEvent.add( new BMouseEventHandler( this, "trackSelector_MouseClick" ) );
            trackSelector.mouseUpEvent.add( new BMouseEventHandler( this, "trackSelector_MouseUp" ) );
            trackSelector.mouseDownEvent.add( new BMouseEventHandler( this, "trackSelector_MouseDown" ) );
            trackSelector.mouseMoveEvent.add( new BMouseEventHandler( this, "trackSelector_MouseMove" ) );
            trackSelector.keyDownEvent.add( new BKeyEventHandler( this, "commonCaptureSpaceKeyDown" ) );
            trackSelector.keyUpEvent.add( new BKeyEventHandler( this, "commonCaptureSpaceKeyUp" ) );
            trackSelector.previewKeyDownEvent.add( new BPreviewKeyDownEventHandler( this, "trackSelector_PreviewKeyDown" ) );
            trackSelector.selectedTrackChangedEvent.add( new SelectedTrackChangedEventHandler( this, "trackSelector_SelectedTrackChanged" ) );
            trackSelector.selectedCurveChangedEvent.add( new SelectedCurveChangedEventHandler( this, "trackSelector_SelectedCurveChanged" ) );
            trackSelector.renderRequiredEvent.add( new RenderRequiredEventHandler( this, "trackSelector_RenderRequired" ) );
            trackSelector.preferredMinHeightChangedEvent.add( new BEventHandler( this, "trackSelector_PreferredMinHeightChanged" ) );
            trackSelector.mouseDoubleClickEvent.add( new BMouseEventHandler( this, "trackSelector_MouseDoubleClick" ) );

#if !JAVA
            splitContainer1.Panel2MinSize = trackSelector.getPreferredMinSize();
            this.setMinimumSize( getWindowMinimumSize() );
#endif
            stripBtnScroll.setSelected( AppManager.autoScroll );

            applySelectedTool();
            applyQuantizeMode();

            // Palette Toolの読み込み
#if ENABLE_SCRIPT
            updatePaletteTool();
#endif


#if !JAVA
            // toolStipの位置を，前回終了時の位置に戻す
            Vector<BToolBar> top = new Vector<BToolBar>();
            Vector<BToolBar> bottom = new Vector<BToolBar>();
            if ( toolStripTool.getParent() != null ) {
                if ( toolStripTool.getParent() == toolStripContainer.TopToolStripPanel ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripTool );
                    top.add( toolStripTool );
                } else if ( toolStripTool.getParent() == toolStripContainer.BottomToolStripPanel ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripTool );
                    bottom.add( toolStripTool );
                }
            }
            if ( toolStripMeasure.getParent() != null ) {
                if ( toolStripMeasure.getParent() == toolStripContainer.TopToolStripPanel ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripMeasure );
                    top.add( toolStripMeasure );
                } else if ( toolStripMeasure.getParent() == toolStripContainer.BottomToolStripPanel ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripMeasure );
                    bottom.add( toolStripMeasure );
                }
            }
            if ( toolStripPosition.getParent() != null ) {
                if ( toolStripPosition.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripPosition );
                    top.add( toolStripPosition );
                } else if ( toolStripPosition.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripPosition );
                    bottom.add( toolStripPosition );
                }
            }
            if ( toolStripFile.getParent() != null ) {
                if ( toolStripFile.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripFile );
                    top.add( toolStripFile );
                } else if ( toolStripFile.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripFile );
                    bottom.add( toolStripFile );
                }
            }
#endif

#if !JAVA
            splitContainer1.Panel1.BorderStyle = System.Windows.Forms.BorderStyle.None;
            splitContainer1.Panel2.BorderStyle = System.Windows.Forms.BorderStyle.None;
            splitContainer1.BackColor = System.Drawing.Color.FromArgb( 212, 212, 212 );
            splitContainer2.Panel1.Controls.Add( panel1 );
            panel1.Dock = System.Windows.Forms.DockStyle.Fill;
            splitContainer2.Panel2.Controls.Add( panel2 );
            splitContainer2.Panel2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            splitContainer2.Panel2.BorderColor = System.Drawing.Color.FromArgb( 112, 112, 112 );
            splitContainer1.Panel1.Controls.Add( splitContainer2 );
            panel2.Dock = System.Windows.Forms.DockStyle.Fill;
            splitContainer2.Dock = System.Windows.Forms.DockStyle.Fill;
            splitContainer1.Panel2.Controls.Add( trackSelector );
            trackSelector.Dock = System.Windows.Forms.DockStyle.Fill;
            splitContainer1.Dock = System.Windows.Forms.DockStyle.Fill;
            splitContainer1.Panel2MinSize = trackSelector.getPreferredMinSize();
            splitContainerProperty.FixedPanel = System.Windows.Forms.FixedPanel.Panel1;
#endif

#if ENABLE_PROPERTY
            splitContainerProperty.Panel1.Controls.Add( m_property_panel_container );
            m_property_panel_container.Dock = System.Windows.Forms.DockStyle.Fill;
#else
            splitContainerProperty.setDividerLocation( 0 );
            splitContainerProperty.setEnabled( false );
            menuVisualProperty.setVisible( false );
#endif

#if !JAVA
            splitContainerProperty.Panel2.Controls.Add( splitContainer1 );
            splitContainerProperty.Dock = System.Windows.Forms.DockStyle.Fill;

            // コントロールの位置・サイズを調節
            splitContainer2.Panel1.SuspendLayout();
            panel1.SuspendLayout();
            pictPianoRoll.SuspendLayout();
            vScroll.SuspendLayout();
            // panel1の中身は
            // picturePositionIndicator
            picturePositionIndicator.Left = 0;
            picturePositionIndicator.Top = 0;
            picturePositionIndicator.Width = panel1.Width;
            // pictPianoRoll
            pictPianoRoll.setBounds( 0, picturePositionIndicator.Height, panel1.Width - vScroll.getWidth(), panel1.Height - picturePositionIndicator.Height - hScroll.getHeight() );
            // vScroll
            vScroll.Left = pictPianoRoll.getWidth();
            vScroll.Top = picturePositionIndicator.Height;
            vScroll.Height = pictPianoRoll.getHeight();
            // pictureBox3
            pictureBox3.Left = 0;
            pictureBox3.Top = panel1.Height - hScroll.getHeight();
            pictureBox3.Height = hScroll.getHeight();
            // hScroll
            hScroll.Left = pictureBox3.Width;
            hScroll.Top = panel1.Height - hScroll.Height;
            hScroll.Width = panel1.Width - pictureBox3.Width - trackBar.getWidth() - pictureBox2.Width;
            // trackBar
            trackBar.Left = pictureBox3.Width + hScroll.Width;
            trackBar.Top = panel1.Height - hScroll.Height;
            // pictureBox2
            pictureBox2.Left = panel1.Width - vScroll.Width;
            pictureBox2.Top = panel1.Height - hScroll.Height;

            vScroll.ResumeLayout();
            pictPianoRoll.ResumeLayout();
            panel1.ResumeLayout();
            splitContainer2.Panel1.ResumeLayout();
#endif

#if JAVA
            // TODO: FormMain#.ctor
#else
            pictPianoRoll.MouseWheel += new System.Windows.Forms.MouseEventHandler( pictPianoRoll_MouseWheel );
            trackSelector.MouseWheel += new System.Windows.Forms.MouseEventHandler( trackSelector_MouseWheel );
            picturePositionIndicator.MouseWheel += new System.Windows.Forms.MouseEventHandler( picturePositionIndicator_MouseWheel );
            menuVisualOverview.CheckedChanged += new EventHandler( menuVisualOverview_CheckedChanged );
#endif

            hScroll.setMaximum( AppManager.getVsqFile().TotalClocks + 240 );
            hScroll.setVisibleAmount( 240 * 4 );

            vScroll.setMaximum( AppManager.editorConfig.PxTrackHeight * 128 );
            vScroll.setVisibleAmount( 24 * 4 );
#if !JAVA
            hScroll.SmallChange = 240;
            vScroll.SmallChange = 24;
#endif

            trackSelector.setCurveVisible( true );

#if !JAVA
            // 左上のやつから順に登録
            XmlPoint p = AppManager.editorConfig.ToolEditTool.Location;
            toolStripTool.Location = new System.Drawing.Point( p.x, p.y );
            p = AppManager.editorConfig.ToolMeasureLocation.Location;
            toolStripMeasure.Location = new System.Drawing.Point( p.x, p.y );
            p = AppManager.editorConfig.ToolPositionLocation.Location;
            toolStripPosition.Location = new System.Drawing.Point( p.x, p.y );
            p = AppManager.editorConfig.ToolFileLocation.Location;
            toolStripFile.Location = new System.Drawing.Point( p.x, p.y );
            addToolStripInPositionOrder( toolStripContainer.TopToolStripPanel, top );
            addToolStripInPositionOrder( toolStripContainer.BottomToolStripPanel, bottom );

            toolStripTool.ParentChanged += new System.EventHandler( this.toolStripEdit_ParentChanged );
            toolStripTool.Move += new System.EventHandler( this.toolStripEdit_Move );
            toolStripMeasure.ParentChanged += new System.EventHandler( this.toolStripMeasure_ParentChanged );
            toolStripMeasure.Move += new System.EventHandler( this.toolStripMeasure_Move );
            toolStripPosition.ParentChanged += new System.EventHandler( this.toolStripPosition_ParentChanged );
            toolStripPosition.Move += new System.EventHandler( this.toolStripPosition_Move );
            toolStripFile.ParentChanged += new EventHandler( toolStripFile_ParentChanged );
            toolStripFile.Move += new EventHandler( toolStripFile_Move );
#endif

            // inputTextBoxの初期化
#if JAVA
            AppManager.inputTextBox = new LyricTextBox( this );
            AppManager.inputTextBox.setVisible( false );
            AppManager.inputTextBox.setSize( 80, 22 );
            AppManager.inputTextBox.setBackground( Color.white );
            AppManager.inputTextBox.setFont( new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, 9 ) );
            AppManager.inputTextBox.setEnabled( false );
            AppManager.inputTextBox.keyPressEvent.add( new BKeyPressEventHandler( this, "m_input_textbox_KeyPress" ) );
#else
            AppManager.inputTextBox = new LyricTextBox();
            AppManager.inputTextBox.setVisible( false );
            AppManager.inputTextBox.BorderStyle = System.Windows.Forms.BorderStyle.None;
            AppManager.inputTextBox.Width = 80;
            AppManager.inputTextBox.AcceptsReturn = true;
            AppManager.inputTextBox.setBackground( Color.white );
            AppManager.inputTextBox.setFont( new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE9 ) );
            AppManager.inputTextBox.setEnabled( false );
            AppManager.inputTextBox.KeyPress += m_input_textbox_KeyPress;
            AppManager.inputTextBox.Parent = pictPianoRoll;
            panel1.Controls.Add( AppManager.inputTextBox );
#endif

            int fps = 1000 / AppManager.editorConfig.MaximumFrameRate;
            timer.setDelay( (fps <= 0) ? 1 : fps );
            menuTrackManager.setVisible( false );
#if DEBUG
            menuHelpDebug.setVisible( true );
#endif

#if !JAVA
            String _HAND = "AAACAAEAICAAABAAEADoAgAAFgAAACgAAAAgAAAAQAAAAAEABAAAAAAAgAIAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAgAAAAACAAACAgAAAAACAAIAAgAAAgIAAwMDAAICAgAD/AAAAAP8AAP//AAAAAP8A/wD/AAD//wD///8AAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/wAAAAAAAAAAAAAAAAAAD" +
                "//wAAAAAAAAAAAAAAAAAA//8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAAAA/wAAAAAAAAAAA" +
                "A//AAAAAP/wAAAAAAAAAAAP/wAAAAD/8AAAAAAAAAAAAP8AAAAA/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAA//8AAAAAAAAAAAAAAAAAAP//AAAAAAAAAAAAAAAAAAAP8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD////////////////////////////////////////////+f////" +
                "D////gf///4H////D///8/z//+H4f//B+D//wfg//+H4f//z/P///w////4H///+B////w////+f//////////////////////////" +
                "//////////////////w==";
            using ( System.IO.MemoryStream ms = new System.IO.MemoryStream( Base64.decode( _HAND ) ) ) {
                HAND = new System.Windows.Forms.Cursor( ms );
            }
#endif

#if !ENABLE_MIDI
            menuSettingMidi.setVisible( false );
#endif
            initResource();
            applyShortcut();

            // ファイルを開く
            if ( !file.Equals( "" ) ) {
                if ( PortUtil.isFileExists( file ) ) {
                    String low_file = file.ToLower();
                    if ( low_file.EndsWith( ".xvsq" ) ) {
                        AppManager.readVsq( file );
                    } else if ( low_file.EndsWith( ".vsq" ) ) {
                        VsqFileEx vsq = null;
                        try {
                            vsq = new VsqFileEx( file, "Shift_JIS" );
                            AppManager.setVsqFile( vsq );
                            updateBgmMenuState();
                        } catch ( Exception ex ) {
                            PortUtil.stderr.println( "FormMain#.ctor; ex=" + ex );
                        }
                    }
                }
            }

#if !JAVA
#if DEBUG
            System.Collections.Generic.List<ValuePair<string, string>> list = new System.Collections.Generic.List<ValuePair<string, string>>();
            foreach ( System.Reflection.FieldInfo fi in typeof( EditorConfig ).GetFields() ) {
                if ( fi.IsPublic && !fi.IsStatic ) {
                    list.Add( new ValuePair<string, string>( fi.Name, fi.FieldType.ToString() ) );
                }
            }

            foreach ( System.Reflection.PropertyInfo pi in typeof( EditorConfig ).GetProperties() ) {
                if ( !pi.CanRead || !pi.CanWrite ) {
                    continue;
                }
                System.Reflection.MethodInfo getmethod = pi.GetGetMethod();
                System.Reflection.MethodInfo setmethod = pi.GetSetMethod();
                if ( !setmethod.IsPublic || setmethod.IsStatic ) {
                    continue;
                }
                if ( !getmethod.IsPublic || getmethod.IsStatic ) {
                    continue;
                }
                list.Add( new ValuePair<string, string>( pi.Name, pi.PropertyType.ToString() ) );
            }

            list.Sort();

            using ( System.IO.StreamWriter sw = new System.IO.StreamWriter( "EditorConfig.txt" ) ) {
                foreach ( ValuePair<string, string> s in list ) {
                    sw.WriteLine( s.Key );
                }
                sw.WriteLine( "--------------------------------------------" );
                foreach ( ValuePair<string, string> s in list ) {
                    sw.WriteLine( s.Value + "\t" + s.Key + ";" );
                }
            }
#endif
#endif
        }
        #endregion

        #region helper methods
        /// <summary>
        /// デフォルトのストロークを取得します
        /// </summary>
        /// <returns></returns>
        private BasicStroke getStrokeDefault() {
            if ( _strokeDefault == null ) {
                _strokeDefault = new BasicStroke();
            }
            return _strokeDefault;
        }

        /// <summary>
        /// 描画幅が2pxのストロークを取得します
        /// </summary>
        /// <returns></returns>
        private BasicStroke getStroke2px() {
            if ( _stroke2px == null ) {
                _stroke2px = new BasicStroke( 2.0f );
            }
            return _stroke2px;
        }

        /// <summary>
        /// 選択された音符の長さを、指定したゲートタイム分長くします。
        /// </summary>
        /// <param name="delta_length"></param>
        private void lengthenSelectedEvent( int delta_length ) {
            if ( delta_length == 0 ) {
                return;
            }

            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }

            int selected = AppManager.getSelected();

            Vector<VsqEvent> items = new Vector<VsqEvent>();
            for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                SelectedEventEntry item = itr.next();
                if ( item.editing.ID.type != VsqIDType.Anote && 
                     item.editing.ID.type != VsqIDType.Aicon ) {
                    continue;
                }

                // クレッシェンド、デクレッシェンドでないものを省く
                if ( item.editing.ID.type == VsqIDType.Aicon ) {
                    if ( item.editing.ID.IconDynamicsHandle == null ) {
                        continue;
                    }
                    if ( !item.editing.ID.IconDynamicsHandle.isCrescendType() &&
                         !item.editing.ID.IconDynamicsHandle.isDecrescendType() ) {
                        continue;
                    }
                }

                // 長さを変える。0未満になると0に直す
                int length = item.editing.ID.getLength();
                int draft = length + delta_length;
                if ( draft < 0 ) {
                    draft = 0;
                }
                if ( length == draft ) {
                    continue;
                }

                // ビブラートの長さを変更
                VsqEvent add = (VsqEvent)item.editing.clone();
                Utility.editLengthOfVsqEvent( add, draft, AppManager.vibratoLengthEditingRule );
                items.add( add );
            }

            if ( items.size() <= 0 ) {
                return;
            }

            // コマンドを発行
            CadenciiCommand run = new CadenciiCommand(
                VsqCommand.generateCommandEventReplaceRange(
                    selected, items.toArray( new VsqEvent[] { } ) ) );
            AppManager.register( vsq.executeCommand( run ) );

            // 編集されたものを再選択する
            for ( Iterator<VsqEvent> itr = items.iterator(); itr.hasNext(); ) {
                VsqEvent item = itr.next();
                AppManager.addSelectedEvent( item.InternalID );
            }

            // 編集が施された。
            setEdited( true );
            updateDrawObjectList();

            refreshScreen();
        }

        /// <summary>
        /// 選択された音符の音程とゲートタイムを、指定されたノートナンバーおよびゲートタイム分上下させます。
        /// </summary>
        /// <param name="delta_note"></param>
        /// <param name="delta_clock"></param>
        private void moveUpDownLeftRight( int delta_note, int delta_clock ) {
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }

            Vector<VsqEvent> items = new Vector<VsqEvent>();
            int selected = AppManager.getSelected();
            int note_max = -1;
            int note_min = 129;
            int clock_max = int.MinValue;
            int clock_min = int.MaxValue;
            for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                SelectedEventEntry item = itr.next();
                if ( item.editing.ID.type != VsqIDType.Anote ) {
                    continue;
                }
                VsqEvent add = null;

                // 音程
                int note = item.editing.ID.Note;
                if ( delta_note != 0 && 0 <= note + delta_note && note + delta_note <= 127 ) {
                    add = (VsqEvent)item.editing.clone();
                    add.ID.Note += delta_note;
                    note_max = Math.Max( note_max, add.ID.Note );
                    note_min = Math.Min( note_min, add.ID.Note );
                }

                // ゲートタイム
                int clockstart = item.editing.Clock;
                int clockend = clockstart + item.editing.ID.getLength();
                if ( delta_clock != 0 ) {
                    if ( add == null ) {
                        add = (VsqEvent)item.editing.clone();
                    }
                    add.Clock += delta_clock;
                    clock_max = Math.Max( clock_max, clockend + delta_clock );
                    clock_min = Math.Min( clock_min, clockstart );
                }

                if ( add != null ) {
                    items.add( add );
                }
            }
            if ( items.size() <= 0 ) {
                return;
            }

            // コマンドを発行
            CadenciiCommand run = new CadenciiCommand(
                VsqCommand.generateCommandEventReplaceRange(
                    selected, items.toArray( new VsqEvent[] { } ) ) );
            AppManager.register( vsq.executeCommand( run ) );

            // 編集されたものを再選択する
            for ( Iterator<VsqEvent> itr = items.iterator(); itr.hasNext(); ) {
                VsqEvent item = itr.next();
                AppManager.addSelectedEvent( item.InternalID );
            }

            // 編集が施された。
            setEdited( true );
            updateDrawObjectList();

            // 音符が見えるようにする。音程方向
            if ( delta_note > 0 ) {
                note_max++;
                if ( 127 < note_max ) {
                    note_max = 127;
                }
                ensureVisibleY( note_max );
            } else if ( delta_note < 0 ) {
                note_min -= 2;
                if ( note_min < 0 ) {
                    note_min = 0;
                }
                ensureVisibleY( note_min );
            }

            // 音符が見えるようにする。時間方向
            if ( delta_clock > 0 ) {
                ensureVisible( clock_max );
            } else if ( delta_clock < 0 ) {
                ensureVisible( clock_min );
            }
            refreshScreen();
        }

        /// <summary>
        /// pがrcの中にあるかどうかを判定します
        /// </summary>
        /// <param name="p"></param>
        /// <param name="rc"></param>
        /// <returns></returns>
        static boolean isInRect( Point p, Rectangle rc ) {
            if ( rc.x <= p.x ) {
                if ( p.x <= rc.x + rc.width ) {
                    if ( rc.y <= p.y ) {
                        if ( p.y <= rc.y + rc.height ) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private VsqEvent getItemAtClickedPosition( Point mouse_position, ByRef<Rectangle> rect ) {
            rect.value = new Rectangle();
            if ( mouse_position.x < AppManager.keyWidth || pictPianoRoll.getWidth() < mouse_position.x ) {
                return null;
            }
            if ( mouse_position.y < 0 || pictPianoRoll.getHeight() < mouse_position.y ) {
                return null;
            }
            int selected = AppManager.getSelected();
            if ( selected < 1 ) {
                return null;
            }
            lock ( AppManager.drawObjects ) {
                Vector<DrawObject> dobj_list = AppManager.drawObjects.get( selected - 1 );
                int count = dobj_list.size();
                int start_to_draw_x = AppManager.getStartToDrawX();
                int start_to_draw_y = AppManager.getStartToDrawY();
                int key_width = AppManager.keyWidth;
                int pianoroll_width = pictPianoRoll.getWidth();
                for ( int i = 0; i < count; i++ ) {
                    DrawObject dobj = dobj_list.get( i );
                    int x = dobj.pxRectangle.x + key_width - start_to_draw_x;
                    int y = dobj.pxRectangle.y - start_to_draw_y;
                    if ( mouse_position.x < x ) {
                        continue;
                    }
                    if ( x + dobj.pxRectangle.width < mouse_position.x ) {
                        continue;
                    }
                    if ( pianoroll_width < x ) {
                        break;
                    }
                    if ( mouse_position.y < y ) {
                        continue;
                    }
                    if ( y + dobj.pxRectangle.height < mouse_position.y ) {
                        continue;
                    }
                    int internal_id = dobj.internalID;
                    VsqTrack vsq_track = AppManager.getVsqFile().Track.get( selected );
                    for ( Iterator<VsqEvent> itr = vsq_track.getEventIterator(); itr.hasNext(); ) {
                        VsqEvent item = itr.next();
                        if ( item.InternalID == internal_id ) {
                            rect.value = new Rectangle( x, y, dobj.pxRectangle.width, dobj.pxRectangle.height );
                            return item;
                        }
                    }
                }
            }
            return null;
        }

        /// <summary>
        /// マウス位置におけるIDを返します。該当するIDが無ければnullを返します
        /// rectには、該当するIDがあればその画面上での形状を、該当するIDがなければ、
        /// 画面上で最も近かったIDの画面上での形状を返します
        /// </summary>
        /// <param name="mouse_position"></param>
        /// <returns></returns>
        VsqEvent getItemAtClickedPosition_old( Point mouse_position, ByRef<Rectangle> rect ) {
            rect.value = new Rectangle();
            if ( AppManager.keyWidth <= mouse_position.x && mouse_position.x <= pictPianoRoll.getWidth() ) {
                if ( 0 <= mouse_position.y && mouse_position.y <= pictPianoRoll.getHeight() ) {
                    int selected = AppManager.getSelected();
                    if ( selected >= 1 ) {
                        VsqFileEx vsq = AppManager.getVsqFile();
                        VsqTrack vsq_track = vsq.Track.get( selected );
                        int track_height = AppManager.editorConfig.PxTrackHeight;
                        int count = vsq_track.getEventCount();
                        for ( int j = 0; j < count; j++ ) {
                            VsqEvent itemj = vsq_track.getEvent( j );
                            int clock = itemj.Clock;
                            int internal_id = itemj.InternalID;
                            // イベントで指定されたIDがLyricであった場合
                            if ( itemj.ID.type == VsqIDType.Anote ) {
                                if ( itemj.ID.LyricHandle == null ) {
                                    continue;
                                }
                                // 発音長を取得
                                int length = itemj.ID.getLength();
                                int note = itemj.ID.Note;
                                int x = AppManager.xCoordFromClocks( clock );
                                int y = AppManager.yCoordFromNote( note );
                                int lyric_width = (int)(length * AppManager.getScaleX());
                                if ( x + lyric_width < 0 ) {
                                    continue;
                                } else if ( pictPianoRoll.getWidth() < x ) {
                                    break;
                                }
                                if ( x <= mouse_position.x && mouse_position.x <= x + lyric_width ) {
                                    if ( y + 1 <= mouse_position.y && mouse_position.y <= y + track_height ) {
                                        rect.value = new Rectangle( x, y + 1, lyric_width, track_height );
                                        return itemj;
                                    }
                                }
                            } else if ( itemj.ID.type == VsqIDType.Aicon ) {
                                if ( itemj.ID.IconDynamicsHandle == null ) {
                                    continue;
                                }
                                int length = itemj.ID.getLength();
                                int note = itemj.ID.Note;
                                int x = AppManager.xCoordFromClocks( clock );
                                int y = AppManager.yCoordFromNote( note );
                                //int lyric_width = 
                            }
                        }
                    }
                }
            }
            return null;
        }
        #endregion

        #region public methods
        /// <summary>
        /// 現在選択されている音符よりも1個前方の音符を選択しなおします。
        /// </summary>
        public void selectBackward() {
            int count = AppManager.getSelectedEventCount();
            if ( count <= 0 ) {
                return;
            }
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );

            // 選択されている音符のうち、最も前方にあるものがどれかを調べる
            int min_clock = int.MaxValue;
            int internal_id = -1;
            VsqIDType type = VsqIDType.Unknown;
            for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                SelectedEventEntry item = itr.next();
                if ( item.editing.Clock <= min_clock ) {
                    min_clock = item.editing.Clock;
                    internal_id = item.original.InternalID;
                    type = item.original.ID.type;
                }
            }
            if ( internal_id == -1 || type == VsqIDType.Unknown ) {
                return;
            }

            // 1個前のアイテムのIDを検索
            int last_id = -1;
            int clock = AppManager.getCurrentClock();
            for ( Iterator<VsqEvent> itr = vsq_track.getEventIterator(); itr.hasNext(); ) {
                VsqEvent item = itr.next();
                if ( item.ID.type != type ) {
                    continue;
                }
                if ( item.InternalID == internal_id ) {
                    break;
                }
                last_id = item.InternalID;
                clock = item.Clock;
            }
            if ( last_id == -1 ) {
                return;
            }

            // 選択しなおす
            AppManager.clearSelectedEvent();
            AppManager.addSelectedEvent( last_id );
            ensureVisible( clock );
        }

        /// <summary>
        /// 現在選択されている音符よりも1個後方の音符を選択しなおします。
        /// </summary>
        public void selectForward() {
            int count = AppManager.getSelectedEventCount();
            if ( count <= 0 ) {
                return;
            }
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );

            // 選択されている音符のうち、最も後方にあるものがどれかを調べる
            int max_clock = int.MinValue;
            int internal_id = -1;
            VsqIDType type = VsqIDType.Unknown;
            for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                SelectedEventEntry item = itr.next();
                if ( max_clock <= item.editing.Clock ) {
                    max_clock = item.editing.Clock;
                    internal_id = item.original.InternalID;
                    type = item.original.ID.type;
                }
            }
            if ( internal_id == -1 || type == VsqIDType.Unknown ) {
                return;
            }

            // 1個後ろのアイテムのIDを検索
            int last_id = -1;
            int clock = AppManager.getCurrentClock();
            boolean break_next = false;
            for ( Iterator<VsqEvent> itr = vsq_track.getEventIterator(); itr.hasNext(); ) {
                VsqEvent item = itr.next();
                if ( item.ID.type != type ) {
                    continue;
                }
                if ( item.InternalID == internal_id ) {
                    break_next = true;
                    last_id = item.InternalID;
                    clock = item.Clock;
                    continue;
                }
                last_id = item.InternalID;
                clock = item.Clock;
                if ( break_next ) {
                    break;
                }
            }
            if ( last_id == -1 ) {
                return;
            }

            // 選択しなおす
            AppManager.clearSelectedEvent();
            AppManager.addSelectedEvent( last_id );
            ensureVisible( clock );
        }

        /// <summary>
        /// 画像等のリソースを設定します。
        /// </summary>
        public void initResource() {
#if ENABLE_MIDI
            m_strip_ddbtn_metronome.setIcon( new ImageIcon( Resources.get_alarm_clock() ) );
#endif
        }

        /// <summary>
        /// リアルタイム入力の再生速度を変更します
        /// </summary>
        /// <param name="newv">再生速度の倍率。1が等倍を表す</param>
        public void changeRealtimeInputSpeed( float newv ) {
            float old = AppManager.editorConfig.getRealtimeInputSpeed();
            double now = PortUtil.getCurrentTime();
            float play_time = (float)(now - AppManager.previewStartedTime) * old / newv;
            int sec = (int)(Math.Floor( play_time ) + 0.1);
            int millisec = (int)((play_time - sec) * 1000);
            AppManager.previewStartedTime = now - (sec + millisec / 1000.0);
#if ENABLE_MIDI
            MidiPlayer.SetSpeed( newv, AppManager.previewStartedTime );
#endif
        }

#if ENABLE_STRIP_DROPDOWN
        /// <summary>
        /// stripDDBtnSpeedの表示状態を更新します
        /// </summary>
        public void updateStripDDBtnSpeed() {
            stripDDBtnSpeed.setText( _( "Speed" ) + " " + (AppManager.editorConfig.getRealtimeInputSpeed() * 100) + "%" );
        }
#endif

        /// <summary>
        /// ミニチュア・ピアノロール上のマウスの位置から、ピアノロールに設定するべきStartToDrawXの値を計算します。
        /// </summary>
        /// <param name="mouse_x"></param>
        /// <returns></returns>
        public int getOverviewStartToDrawX( int mouse_x ) {
            float clock = mouse_x / m_overview_px_per_clock + m_overview_start_to_draw_clock;
            int clock_at_left = (int)(clock - (pictPianoRoll.getWidth() - AppManager.keyWidth) * AppManager.getScaleXInv() / 2);
            return (int)(clock_at_left * AppManager.getScaleX());
        }

        public int getOverviewXCoordFromClock( int clock ) {
            return (int)((clock - m_overview_start_to_draw_clock) * m_overview_px_per_clock);
        }

        public int getOverviewClockFromXCoord( int x, int start_to_draw_clock ) {
            return (int)(x / m_overview_px_per_clock) + start_to_draw_clock;
        }

        public int getOverviewClockFromXCoord( int x ) {
            return getOverviewClockFromXCoord( x, m_overview_start_to_draw_clock );
        }

#if JAVA
        public class UpdateOverviewProc extends Thread{
        public void run(){
#else
        public void updateOverview() {
#endif
            boolean д = true;
#if DEBUG
            int count = 0;
#endif
            for ( ; д; ) {
#if DEBUG
                count++;
                PortUtil.println( "FormMain#updateOverview; count=" + count );
#endif
#if JAVA
                try{
                    Thread.sleep( 100 );
                }catch( InterruptedException ex ){
                    break;
                }
#else
                Thread.Sleep( 100 );
#endif
                int key_width = AppManager.keyWidth;
                double dt = PortUtil.getCurrentTime() - m_overview_btn_downed;
                int draft = (int)(m_overview_start_to_draw_clock_initial_value + m_overview_direction * dt * _OVERVIEW_SCROLL_SPEED / m_overview_px_per_clock);
                int clock = getOverviewClockFromXCoord( panelOverview.getWidth() - key_width, draft );
                if ( AppManager.getVsqFile().TotalClocks < clock ) {
                    draft = AppManager.getVsqFile().TotalClocks - (int)((panelOverview.getWidth() - key_width) / m_overview_px_per_clock);
                }
                if ( draft < 0 ) {
                    draft = 0;
                }
                m_overview_start_to_draw_clock = draft;
#if JAVA
                if ( this == null ) {
#else
                if ( this == null || (this != null && this.IsDisposed) ) {
#endif
                    break;
                }
#if JAVA
                repaint();
#else
                panelOverview.invalidate();// this.Invoke( new BEventHandler( invalidatePictOverview ) );
#endif
            }
#if JAVA
        }
#endif
        }

        public void invalidatePictOverview( Object sender, EventArgs e ) {
            panelOverview.invalidate();
        }

        public float getOverviewScaleX( int scale_count ) {
            return (float)Math.Pow( 10.0, 0.2 * scale_count - 3.0 );
        }

        public void updateBgmMenuState() {
            menuTrackBgm.removeAll();
            int count = AppManager.getBgmCount();
            if ( count > 0 ) {
                for ( int i = 0; i < count; i++ ) {
                    BgmFile item = AppManager.getBgm( i );
                    BMenu menu = new BMenu();
                    menu.setText( PortUtil.getFileName( item.file ) );
                    menu.setToolTipText( item.file );

                    BMenuItem menu_remove = new BMenuItem();
                    menu_remove.setText( _( "Remove" ) );
                    menu_remove.setToolTipText( item.file );
                    menu_remove.setTag( (int)i );
#if JAVA
                    menu_remove.clickEvent.add( new BEventHandler( this, "handleBgmRemove_Click" ) );
#else
                    menu_remove.Click += new EventHandler( handleBgmRemove_Click );
#endif
                    menu.add( menu_remove );

                    BMenuItem menu_start_after_premeasure = new BMenuItem();
                    menu_start_after_premeasure.setText( _( "Start After Premeasure" ) );
                    menu_start_after_premeasure.setName( "menu_start_after_premeasure" + i );
                    menu_start_after_premeasure.setTag( (int)i );
                    menu_start_after_premeasure.setCheckOnClick( true );
                    menu_start_after_premeasure.setSelected( item.startAfterPremeasure );
#if JAVA
                    menu_start_after_premeasure.checkedChangedEvent.add( new BEventHandler( this, "handleBgmStartAfterPremeasure_CheckedChanged" ) );
#else
                    menu_start_after_premeasure.CheckedChanged += new EventHandler( handleBgmStartAfterPremeasure_CheckedChanged );
#endif
                    menu.add( menu_start_after_premeasure );

                    BMenuItem menu_offset_second = new BMenuItem();
                    menu_offset_second.setText( _( "Set Offset Seconds" ) );
                    menu_offset_second.setTag( (int)i );
                    menu_offset_second.setToolTipText( item.readOffsetSeconds + " " + _( "seconds" ) );
#if JAVA
                    menu_offset_second.clickEvent.add( new BEventHandler( this, "handleBgmOffsetSeconds_Click" ) );
#else
                    menu_offset_second.Click += new EventHandler( handleBgmOffsetSeconds_Click );
#endif
                    menu.add( menu_offset_second );

                    menuTrackBgm.add( menu );
                }
                menuTrackBgm.addSeparator();
            }
            BMenuItem menu_add = new BMenuItem();
            menu_add.setText( _( "Add" ) );
#if JAVA
            menu_add.clickEvent.add( new BEventHandler( this, "handleBgmAdd_Click" ) );
#else
            menu_add.Click += new EventHandler( handleBgmAdd_Click );
#endif
            menuTrackBgm.add( menu_add );
        }


#if ENABLE_PROPERTY
        public void updatePropertyPanelState( PanelState state ) {
            if ( state == PanelState.Docked ) {
                m_property_panel_container.Add( AppManager.propertyPanel );
                AppManager.propertyWindow.setVisible( false );
                menuVisualProperty.setSelected( true );
                AppManager.editorConfig.PropertyWindowStatus.State = PanelState.Docked;
                splitContainerProperty.setSplitterFixed( false );
                splitContainerProperty.setDividerSize( _SPL_SPLITTER_WIDTH );
                splitContainerProperty.Panel1MinSize = _PROPERTY_DOCK_MIN_WIDTH;
                splitContainerProperty.setDividerLocation( AppManager.editorConfig.PropertyWindowStatus.DockWidth );
                AppManager.editorConfig.PropertyWindowStatus.WindowState = BFormWindowState.Minimized;
                AppManager.propertyWindow.setExtendedState( BForm.ICONIFIED );
            } else if ( state == PanelState.Hidden ) {
                AppManager.propertyWindow.setVisible( false );
                menuVisualProperty.setSelected( false );
                if ( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Docked ) {
                    AppManager.editorConfig.PropertyWindowStatus.DockWidth = splitContainerProperty.getDividerLocation();
                }
                AppManager.editorConfig.PropertyWindowStatus.State = PanelState.Hidden;
                splitContainerProperty.Panel1MinSize = 0;
                splitContainerProperty.setDividerLocation( 0 );
                splitContainerProperty.setDividerSize( 0 );
                splitContainerProperty.setSplitterFixed( true );
            } else if ( state == PanelState.Window ) {
                AppManager.propertyWindow.setVisible( true );
                if ( AppManager.propertyWindow.getExtendedState() != BForm.NORMAL ) {
                    AppManager.propertyWindow.setExtendedState( BForm.NORMAL );
                }
                AppManager.propertyWindow.Controls.Add( AppManager.propertyPanel );
                Point parent = this.getLocation();
                XmlRectangle rc = AppManager.editorConfig.PropertyWindowStatus.Bounds;
                Point property = new Point( rc.x, rc.y );
                AppManager.propertyWindow.setBounds( new Rectangle( parent.x + property.x, parent.y + property.y, rc.Width, rc.Height ) );
                normalizeFormLocation( AppManager.propertyWindow );
                menuVisualProperty.setSelected( true );
                if ( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Docked ) {
                    AppManager.editorConfig.PropertyWindowStatus.DockWidth = splitContainerProperty.getDividerLocation();
                }
                AppManager.editorConfig.PropertyWindowStatus.State = PanelState.Window;
                splitContainerProperty.Panel1MinSize = 0;
                splitContainerProperty.setDividerLocation( 0 );
                splitContainerProperty.setDividerSize( 0 );
                splitContainerProperty.setSplitterFixed( true );
                AppManager.editorConfig.PropertyWindowStatus.WindowState = BFormWindowState.Normal;
            }
        }
#endif


        /// <summary>
        /// メインメニュー項目の中から，Nameプロパティがnameであるものを検索します．見つからなければnullを返す．
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        public Object searchMenuItemFromName( String name ) {
            int count = menuStripMain.getMenuCount();
            for ( int i = 0; i < count; i++ ) {
                Object tsi = menuStripMain.getMenu( i );
                Object ret = searchMenuItemRecurse( name, tsi );
                if ( ret != null ) {
                    return ret;
                }
            }
            return null;
        }

        /// <summary>
        /// 指定されたメニューアイテムから，Nameプロパティがnameであるものを再帰的に検索します．見つからなければnullを返す
        /// </summary>
        /// <param name="name"></param>
        /// <param name="tree"></param>
        /// <returns></returns>
        public Object searchMenuItemRecurse( String name, Object tree ) {
            String tree_name = "";
#if JAVA
            JMenuItem menu = null;
            if( tree instanceof JMenuItem ){
                menu = (JMenuItem)tree;
                tree_name = menu.getName();
                if( tree_name == null ){
                    tree_name = "";
                }
            }else{
                return null;
            }
#else
            System.Windows.Forms.ToolStripMenuItem menu = null;
            if ( tree is System.Windows.Forms.ToolStripItem ) {
                if ( tree is System.Windows.Forms.ToolStripMenuItem ) {
                    menu = (System.Windows.Forms.ToolStripMenuItem)tree;
                }
                tree_name = ((System.Windows.Forms.ToolStripItem)tree).Name;
            } else {
                return null;
            }
#endif
            if ( tree_name.Equals( name ) ) {
                return tree;
            } else {
                if ( menu == null ) {
                    return null;
                }
#if JAVA
                int count = menu.getComponentCount();
#else
                int count = menu.DropDownItems.Count;
#endif
                for ( int i = 0; i < count; i++ ) {
#if JAVA
                    Component tsi = menu.getComponent( i );
#else
                    System.Windows.Forms.ToolStripItem tsi = menu.DropDownItems[i];
#endif
                    String tsi_name = "";
#if JAVA
                    if( tsi instanceof Component ){
                        tsi_name = ((Component)tsi).getName();
                        if( tsi_name == null ){
                            tsi_name = "";
                        }
                    }else{
                        continue;
                    }
#else
                    if ( tsi is System.Windows.Forms.ToolStripItem ) {
                        tsi_name = ((System.Windows.Forms.ToolStripItem)tsi).Name;
                    } else {
                        continue;
                    }
#endif
                    if ( tsi_name.Equals( name ) ) {
                        return tsi;
                    }
                    Object ret = searchMenuItemRecurse( name, tsi );
                    if ( ret != null ) {
                        return ret;
                    }
                }
                return null;
            }
        }

        /// <summary>
        /// フォームをマウス位置に出す場合に推奨されるフォーム位置を計算します
        /// </summary>
        /// <param name="dlg"></param>
        /// <returns></returns>
        public Point getFormPreferedLocation( BDialog dlg ) {
            Point mouse = PortUtil.getMousePosition();
            Rectangle rcScreen = PortUtil.getWorkingArea( this );
            int top = mouse.y - dlg.getHeight() / 2;
            if ( top + dlg.getHeight() > rcScreen.y + rcScreen.height ) {
                // ダイアログの下端が隠れる場合、位置をずらす
                top = rcScreen.y + rcScreen.height - dlg.getHeight();
            }
            if ( top < rcScreen.y ) {
                // ダイアログの上端が隠れる場合、位置をずらす
                top = rcScreen.y;
            }
            int left = mouse.x - dlg.getWidth() / 2;
            if ( left + dlg.getWidth() > rcScreen.x + rcScreen.width ) {
                left = rcScreen.x + rcScreen.width - dlg.getWidth();
            }
            return new Point( left, top );
        }

        public void updateLayout() {
#if JAVA
            int keywidth = AppManager.keyWidth;
            Dimension d2 = new Dimension( keywidth, pictureBox3.getHeight() );
            pictureBox3.setPreferredSize( d2 );
            pictureBox3.setSize( d2 );
#else
            int width = panel1.Width;
            int height = panel1.Height;

            if ( AppManager.editorConfig.OverviewEnabled ) {
                panelOverview.Height = _OVERVIEW_HEIGHT;
            } else {
                panelOverview.Height = 0;
            }
            panelOverview.Width = width;
            int key_width = AppManager.keyWidth;

            /*btnMooz.setBounds( 3, 12, 23, 23 );
            btnZoom.setBounds( 26, 12, 23, 23 );*/

            picturePositionIndicator.Width = width;
            picturePositionIndicator.Height = _PICT_POSITION_INDICATOR_HEIGHT;

            hScroll.Top = 0;
            hScroll.Left = key_width;
            hScroll.Width = width - key_width - _SCROLL_WIDTH - trackBar.Width;
            hScroll.Height = _SCROLL_WIDTH;

            vScroll.Width = _SCROLL_WIDTH;
            vScroll.Height = height - _PICT_POSITION_INDICATOR_HEIGHT - _SCROLL_WIDTH - panelOverview.Height;

            pictPianoRoll.Width = width - _SCROLL_WIDTH;
            pictPianoRoll.Height = height - _PICT_POSITION_INDICATOR_HEIGHT - _SCROLL_WIDTH - panelOverview.Height;

            pictureBox3.Width = key_width - _SCROLL_WIDTH;
            pictKeyLengthSplitter.Width = _SCROLL_WIDTH;
            pictureBox3.Height = _SCROLL_WIDTH;
            pictureBox2.Height = _SCROLL_WIDTH;
            trackBar.Height = _SCROLL_WIDTH;

            panelOverview.Top = 0;
            panelOverview.Left = 0;

            picturePositionIndicator.Top = panelOverview.Height;
            picturePositionIndicator.Left = 0;

            pictPianoRoll.Top = _PICT_POSITION_INDICATOR_HEIGHT + panelOverview.Height;
            pictPianoRoll.Left = 0;

            vScroll.Top = _PICT_POSITION_INDICATOR_HEIGHT + panelOverview.Height;
            vScroll.Left = width - _SCROLL_WIDTH;

            pictureBox3.Top = height - _SCROLL_WIDTH;
            pictureBox3.Left = 0;
            pictKeyLengthSplitter.Top = height - _SCROLL_WIDTH;
            pictKeyLengthSplitter.Left = pictureBox3.Width;

            hScroll.Top = height - _SCROLL_WIDTH;
            hScroll.Left = pictureBox3.Width + pictKeyLengthSplitter.Width;

            trackBar.Top = height - _SCROLL_WIDTH;
            trackBar.Left = width - _SCROLL_WIDTH - trackBar.Width;

            pictureBox2.Top = height - _SCROLL_WIDTH;
            pictureBox2.Left = width - _SCROLL_WIDTH;

            waveView.Top = 0;
            waveView.Left = key_width;
            waveView.Width = width - key_width;
#endif
        }

        public void updateRendererMenu() {
            if ( !VSTiProxy.isRendererAvailable( RendererKind.VOCALOID1_100 ) ) {
                cMenuTrackTabRendererVOCALOID100.setIcon( new ImageIcon( Resources.get_slash() ) );
                menuTrackRendererVOCALOID100.setIcon( new ImageIcon( Resources.get_slash() ) );
            } else {
                cMenuTrackTabRendererVOCALOID100.setIcon( null );
                menuTrackRendererVOCALOID100.setIcon( null );
            }

            if ( !VSTiProxy.isRendererAvailable( RendererKind.VOCALOID1_101 ) ) {
                cMenuTrackTabRendererVOCALOID101.setIcon( new ImageIcon( Resources.get_slash() ) );
                menuTrackRendererVOCALOID101.setIcon( new ImageIcon( Resources.get_slash() ) );
            } else {
                cMenuTrackTabRendererVOCALOID101.setIcon( null );
                menuTrackRendererVOCALOID101.setIcon( null );
            }

            if ( !VSTiProxy.isRendererAvailable( RendererKind.VOCALOID2 ) ) {
                cMenuTrackTabRendererVOCALOID2.setIcon( new ImageIcon( Resources.get_slash() ) );
                menuTrackRendererVOCALOID2.setIcon( new ImageIcon( Resources.get_slash() ) );
            } else {
                cMenuTrackTabRendererVOCALOID2.setIcon( null );
                menuTrackRendererVOCALOID2.setIcon( null );
            }

            if ( !VSTiProxy.isRendererAvailable( RendererKind.UTAU ) ) {
                cMenuTrackTabRendererUtau.setIcon( new ImageIcon( Resources.get_slash() ) );
                menuTrackRendererUtau.setIcon( new ImageIcon( Resources.get_slash() ) );
            } else {
                cMenuTrackTabRendererUtau.setIcon( null );
                menuTrackRendererUtau.setIcon( null );
            }

            if ( !VSTiProxy.isRendererAvailable( RendererKind.STRAIGHT_UTAU ) ) {
                cMenuTrackTabRendererStraight.setIcon( new ImageIcon( Resources.get_slash() ) );
                menuTrackRendererStraight.setIcon( new ImageIcon( Resources.get_slash() ) );
            } else {
                cMenuTrackTabRendererStraight.setIcon( null );
                menuTrackRendererStraight.setIcon( null );
            }

            if ( !VSTiProxy.isRendererAvailable( RendererKind.AQUES_TONE ) ) {
                cMenuTrackTabRendererAquesTone.setIcon( new ImageIcon( Resources.get_slash() ) );
                menuTrackRendererAquesTone.setIcon( new ImageIcon( Resources.get_slash() ) );
            } else {
                cMenuTrackTabRendererAquesTone.setIcon( null );
                menuTrackRendererAquesTone.setIcon( null );
            }
        }

        public void drawUtauVibrato( Graphics2D g, UstVibrato vibrato, int note, int clock_start, int clock_width ) {
            //SmoothingMode old = g.SmoothingMode;
            //g.SmoothingMode = SmoothingMode.AntiAlias;
            // 魚雷を描いてみる
            int y0 = AppManager.yCoordFromNote( note - 0.5f );
            int x0 = AppManager.xCoordFromClocks( clock_start );
            int px_width = AppManager.xCoordFromClocks( clock_start + clock_width ) - x0;
            int boxheight = (int)(vibrato.Depth * 2 / 100.0f * AppManager.editorConfig.PxTrackHeight);
            int px_shift = (int)(vibrato.Shift / 100.0 * vibrato.Depth / 100.0 * AppManager.editorConfig.PxTrackHeight);

            // vibrato in
            int cl_vibin_end = clock_start + (int)(clock_width * vibrato.In / 100.0);
            int x_vibin_end = AppManager.xCoordFromClocks( cl_vibin_end );
            Point ul = new Point( x_vibin_end, y0 - boxheight / 2 - px_shift );
            Point dl = new Point( x_vibin_end, y0 + boxheight / 2 - px_shift );
            g.setColor( Color.black );
            g.drawPolyline( new int[] { x0, ul.x, dl.x },
                            new int[] { y0, ul.y, dl.y },
                            3 );

            // vibrato out
            int cl_vibout_start = clock_start + clock_width - (int)(clock_width * vibrato.Out / 100.0);
            int x_vibout_start = AppManager.xCoordFromClocks( cl_vibout_start );
            Point ur = new Point( x_vibout_start, y0 - boxheight / 2 - px_shift );
            Point dr = new Point( x_vibout_start, y0 + boxheight / 2 - px_shift );
            g.drawPolyline( new int[] { x0 + px_width, ur.x, dr.x },
                           new int[] { y0, ur.y, dr.y },
                           3 );

            // box
            int boxwidth = x_vibout_start - x_vibin_end;
            if ( boxwidth > 0 ) {
                g.drawPolyline( new int[] { ul.x, dl.x, dr.x, ur.x },
                               new int[] { ul.y, dl.y, dr.y, ur.y },
                               4 );
            }

            // buf1に、vibrato in/outによる増幅率を代入
            float[] buf1 = new float[clock_width + 1];
            for ( int clock = clock_start; clock <= clock_start + clock_width; clock++ ) {
                buf1[clock - clock_start] = 1.0f;
            }
            // vibin
            if ( cl_vibin_end - clock_start > 0 ) {
                for ( int clock = clock_start; clock <= cl_vibin_end; clock++ ) {
                    int i = clock - clock_start;
                    buf1[i] *= i / (float)(cl_vibin_end - clock_start);
                }
            }
            if ( clock_start + clock_width - cl_vibout_start > 0 ) {
                for ( int clock = clock_start + clock_width; clock >= cl_vibout_start; clock-- ) {
                    int i = clock - clock_start;
                    float v = (clock_start + clock_width - clock) / (float)(clock_start + clock_width - cl_vibout_start);
                    buf1[i] = buf1[i] * v;
                }
            }

            // buf2に、shiftによるy座標のシフト量を代入
            float[] buf2 = new float[clock_width + 1];
            for ( int i = 0; i < clock_width; i++ ) {
                buf2[i] = px_shift * buf1[i];
            }
            try {
                double phase = 2.0 * Math.PI * vibrato.Phase / 100.0;
                double omega = 2.0 * Math.PI / vibrato.Period;   //角速度(rad/msec)
                double msec = AppManager.getVsqFile().getSecFromClock( clock_start - 1 ) * 1000.0;
                float px_track_height = AppManager.editorConfig.PxTrackHeight;
                phase -= (AppManager.getVsqFile().getSecFromClock( clock_start ) * 1000.0 - msec) * omega;
                for ( int clock = clock_start; clock <= clock_start + clock_width; clock++ ) {
                    int i = clock - clock_start;
                    double t_msec = AppManager.getVsqFile().getSecFromClock( clock ) * 1000.0;
                    phase += (t_msec - msec) * omega;
                    msec = t_msec;
                    buf2[i] += (float)(vibrato.Depth * 0.01f * px_track_height * buf1[i] * Math.Sin( phase ));
                }
                int[] listx = new int[clock_width + 1];
                int[] listy = new int[clock_width + 1];
                for ( int clock = clock_start; clock <= clock_start + clock_width; clock++ ) {
                    int i = clock - clock_start;
                    listx[i] = AppManager.xCoordFromClocks( clock );
                    listy[i] = (int)(y0 + buf2[i]);
                }
                if ( listx.Length >= 2 ) {
                    g.setColor( Color.red );
                    g.drawPolyline( listx, listy, listx.Length );
                }
                //g.SmoothingMode = old;
            } catch ( Exception oex ) {
#if DEBUG
                AppManager.debugWriteLine( "DrawUtauVibrato; oex=" + oex );
#endif
            }
        }

#if !JAVA
        /// <summary>
        /// listに登録されているToolStripを，座標の若い順にcontainerに追加します
        /// </summary>
        /// <param name="panel"></param>
        /// <param name="list"></param>
        public void addToolStripInPositionOrder( System.Windows.Forms.ToolStripPanel panel, Vector<BToolBar> list ) {
            boolean[] reg = new boolean[list.size()];
            for ( int i = 0; i < reg.Length; i++ ) {
                reg[i] = false;
            }
            for ( int i = 0; i < list.size(); i++ ) {
                Point p = new Point( int.MaxValue, int.MaxValue );
                int index = -1;

                // x座標の小さいやつを探す
                for ( int j = 0; j < list.size(); j++ ) {
                    if ( !reg[j] ) {
                        BToolBar ts = list.get( j );
                        if ( p.y > ts.Location.Y ) {
                            index = j;
                            p = new Point( ts.Location.X, ts.Location.Y );
                        }
                        if ( p.y >= ts.Location.Y && p.x > ts.Location.X ) {
                            index = j;
                            p = new Point( ts.Location.X, ts.Location.Y );
                        }
                    }
                }

                // コントロールを登録
                panel.Join( list.get( index ), list.get( index ).Location );
                reg[index] = true;
            }
        }
#endif

#if ENABLE_SCRIPT
        /// <summary>
        /// Palette Toolの表示を更新します
        /// </summary>
        public void updatePaletteTool() {
            int count = 0;
            int num_has_dialog = 0;
            for ( Iterator<BToolStripButton> itr = m_palette_tools.iterator(); itr.hasNext(); ) {
                BToolStripButton item = itr.next();
                toolStripTool.add( item );
            }
            String lang = Messaging.getLanguage();
            boolean first = true;
            for ( Iterator<String> itr = PaletteToolServer.loadedTools.keySet().iterator(); itr.hasNext(); ) {
                String id = itr.next();
                count++;
                IPaletteTool ipt = (IPaletteTool)PaletteToolServer.loadedTools.get( id );
#if !JAVA
                System.Drawing.Bitmap icon = ipt.getIcon();
#endif
                String name = ipt.getName( lang );
                String desc = ipt.getDescription( lang );

                // toolStripPaletteTools
                BToolStripButton tsb = new BToolStripButton();
#if !JAVA
                if ( icon != null ) {
                    tsb.setIcon( new ImageIcon( icon ) );
                }
#endif
                tsb.setText( name );
                tsb.setToolTipText( desc );
                tsb.setTag( id );
                tsb.setCheckOnClick( false );
#if JAVA
                tsb.clickEvent.add( new BEventHandler( this, "commonStripPaletteTool_Clicked" ) );
#else
                tsb.Click += new EventHandler( commonStripPaletteTool_Clicked );
                tsb.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.ImageAndText;
#endif
                if ( first ) {
                    toolStripTool.addSeparator();
                    first = false;
                }
                m_palette_tools.add( tsb );
                toolStripTool.add( tsb );

                // cMenuTrackSelector
                BMenuItem tsmi = new BMenuItem();
                tsmi.setText( name );
                tsmi.setToolTipText( desc );
                tsmi.setTag( id );
#if JAVA
                tsmi.clickEvent.add( new BEventHandler( this, "commonStripPaletteTool_Clicked" ) );
#else
                tsmi.Click += new EventHandler( commonStripPaletteTool_Clicked );
#endif
                cMenuTrackSelectorPaletteTool.add( tsmi );

                // cMenuPiano
                BMenuItem tsmi2 = new BMenuItem();
                tsmi2.setText( name );
                tsmi2.setToolTipText( desc );
                tsmi2.setTag( id );
#if JAVA
                tsmi2.clickEvent.add( new BEventHandler( this, "commonStripPaletteTool_Clicked" ) );
#else
                tsmi2.Click += new EventHandler( commonStripPaletteTool_Clicked );
#endif
                cMenuPianoPaletteTool.add( tsmi2 );

                // menuSettingPaletteTool
                if ( ipt.hasDialog() ) {
                    BMenuItem tsmi3 = new BMenuItem();
                    tsmi3.setText( name );
                    tsmi3.setTag( id );
#if JAVA
                    tsmi3.clickEvent.add( new BEventHandler( this, "commonSettingPaletteTool" ) );
#else
                    tsmi3.Click += new EventHandler( commonSettingPaletteTool );
#endif
                    menuSettingPaletteTool.add( tsmi3 );
                    num_has_dialog++;
                }
            }
            if ( count == 0 ) {
                cMenuTrackSelectorPaletteTool.setVisible( false );
                cMenuPianoPaletteTool.setVisible( false );
            }
            if ( num_has_dialog == 0 ) {
                menuSettingPaletteTool.setVisible( false );
            }
        }
#endif

        public void updateCopyAndPasteButtonStatus() {
            // copy cut deleteの表示状態更新
            boolean selected_is_null = (AppManager.getSelectedEventCount() == 0) &&
                                       (AppManager.getSelectedTempoCount() == 0) &&
                                       (AppManager.getSelectedTimesigCount() == 0) &&
                                       (AppManager.getSelectedPointIDCount() == 0);

            int selected_point_id_count = AppManager.getSelectedPointIDCount();
            cMenuTrackSelectorCopy.setEnabled( selected_point_id_count > 0 );
            cMenuTrackSelectorCut.setEnabled( selected_point_id_count > 0 );
            cMenuTrackSelectorDeleteBezier.setEnabled( (AppManager.isCurveMode() && AppManager.getLastSelectedBezier() != null) );
            if ( selected_point_id_count > 0 ) {
                cMenuTrackSelectorDelete.setEnabled( true );
            } else {
                SelectedEventEntry last = AppManager.getLastSelectedEvent();
                if ( last == null ) {
                    cMenuTrackSelectorDelete.setEnabled( false );
                } else {
                    cMenuTrackSelectorDelete.setEnabled( last.original.ID.type == VsqIDType.Singer );
                }
            }

            cMenuPianoCopy.setEnabled( !selected_is_null );
            cMenuPianoCut.setEnabled( !selected_is_null );
            cMenuPianoDelete.setEnabled( !selected_is_null );

            menuEditCopy.setEnabled( !selected_is_null );
            menuEditCut.setEnabled( !selected_is_null );
            menuEditDelete.setEnabled( !selected_is_null );

            ClipboardEntry ce = AppManager.getCopiedItems();
            int copy_started_clock = ce.copyStartedClock;
            TreeMap<CurveType, VsqBPList> copied_curve = ce.points;
            TreeMap<CurveType, Vector<BezierChain>> copied_bezier = ce.beziers;
            boolean copied_is_null = (ce.events.size() == 0) &&
                                  (ce.tempo.size() == 0) &&
                                  (ce.timesig.size() == 0) &&
                                  (copied_curve.size() == 0) &&
                                  (copied_bezier.size() == 0);
            boolean enabled = !copied_is_null;
            if ( copied_curve.size() == 1 ) {
                // 1種類のカーブがコピーされている場合→コピーされているカーブの種類と、現在選択されているカーブの種類とで、最大値と最小値が一致している場合のみ、ペースト可能
                CurveType ct = CurveType.Empty;
                for ( Iterator<CurveType> itr = copied_curve.keySet().iterator(); itr.hasNext(); ) {
                    CurveType c = itr.next();
                    ct = c;
                }
                CurveType selected = trackSelector.getSelectedCurve();
                if ( ct.getMaximum() == selected.getMaximum() &&
                     ct.getMinimum() == selected.getMinimum() &&
                     !selected.isScalar() && !selected.isAttachNote() ) {
                    enabled = true;
                } else {
                    enabled = false;
                }
            } else if ( copied_curve.size() >= 2 ) {
                // 複数種類のカーブがコピーされている場合→そのままペーストすればOK
                enabled = true;
            }
            cMenuTrackSelectorPaste.setEnabled( enabled );
            cMenuPianoPaste.setEnabled( enabled );
            menuEditPaste.setEnabled( enabled );

            /*int copy_started_clock;
            boolean copied_is_null = (AppManager.GetCopiedEvent().Count == 0) &&
                                  (AppManager.GetCopiedTempo( out copy_started_clock ).Count == 0) &&
                                  (AppManager.GetCopiedTimesig( out copy_started_clock ).Count == 0) &&
                                  (AppManager.GetCopiedCurve( out copy_started_clock ).Count == 0) &&
                                  (AppManager.GetCopiedBezier( out copy_started_clock ).Count == 0);
            menuEditCut.isEnabled() = !selected_is_null;
            menuEditCopy.isEnabled() = !selected_is_null;
            menuEditDelete.isEnabled() = !selected_is_null;
            //stripBtnCopy.isEnabled() = !selected_is_null;
            //stripBtnCut.isEnabled() = !selected_is_null;

            if ( AppManager.GetCopiedEvent().Count != 0 ) {
                menuEditPaste.isEnabled() = (AppManager.CurrentClock >= AppManager.VsqFile.getPreMeasureClocks());
                //stripBtnPaste.isEnabled() = (AppManager.CurrentClock >= AppManager.VsqFile.getPreMeasureClocks());
            } else {
                menuEditPaste.isEnabled() = !copied_is_null;
                //stripBtnPaste.isEnabled() = !copied_is_null;
            }*/
        }

        /// <summary>
        /// 現在の編集データを全て破棄する。DirtyCheckは行われない。
        /// </summary>
        public void clearExistingData() {
            AppManager.clearCommandBuffer();
            AppManager.clearSelectedBezier();
            AppManager.clearSelectedEvent();
            AppManager.clearSelectedTempo();
            AppManager.clearSelectedTimesig();
            if ( AppManager.isPlaying() ) {
                AppManager.setPlaying( false );
            }
            waveView.unloadAll();
        }

        /// <summary>
        /// 保存されていない編集内容があるかどうかチェックし、必要なら確認ダイアログを出す。
        /// </summary>
        /// <returns>保存されていない保存内容などない場合、または、保存する必要がある場合で（保存しなくてよいと指定された場合または保存が行われた場合）にtrueを返す</returns>
        public boolean dirtyCheck() {
            if ( m_edited ) {
                String file = AppManager.getFileName();
                if ( file.Equals( "" ) ) {
                    file = "Untitled";
                } else {
                    file = PortUtil.getFileName( file );
                }
                BDialogResult dr = AppManager.showMessageBox( _( "Save this sequence?" ),
                                                              _( "Affirmation" ),
                                                              org.kbinani.windows.forms.Utility.MSGBOX_YES_NO_CANCEL_OPTION,
                                                              org.kbinani.windows.forms.Utility.MSGBOX_QUESTION_MESSAGE );
                if ( dr == BDialogResult.YES ) {
                    if ( AppManager.getFileName().Equals( "" ) ) {
                        int dr2 = saveXmlVsqDialog.showSaveDialog( this );
                        if ( dr2 == BFileChooser.APPROVE_OPTION ) {
                            AppManager.saveTo( saveXmlVsqDialog.getSelectedFile() );
                            return true;
                        } else {
                            return false;
                        }
                    } else {
                        AppManager.saveTo( AppManager.getFileName() );
                        return true;
                    }
                } else if ( dr == BDialogResult.NO ) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return true;
            }
        }

#if JAVA
        /// <summary>
        /// waveView用のwaveファイルを読込むスレッドで使用する
        /// </summary>
        /// <param name="arg"></param>
        public class LoadWaveProc extends Thread {
            public String file = "";
            public int track;

            public LoadWaveProc( int track, String file ){
                this.file = file;
                this.track = track;
            }

            public void run(){
                waveView.load( track, file );
            }
        }
#endif

        public void loadWave( Object arg ) {
            Object[] argArr = (Object[])arg;
            String file = (String)argArr[0];
            int track = (Integer)argArr[1];
            waveView.load( track, file );
        }

        /// <summary>
        /// menuVisualWaveform.isSelected()の値をもとに、splitterContainer2の表示状態を更新します
        /// </summary>
        public void updateSplitContainer2Size() {
            if ( menuVisualWaveform.isSelected() ) {
                splitContainer2.setPanel2MinSize( _SPL2_PANEL2_MIN_HEIGHT );
                splitContainer2.setSplitterFixed( false );
                splitContainer2.setDividerSize( _SPL_SPLITTER_WIDTH );
                if ( m_last_splitcontainer2_split_distance <= 0 || m_last_splitcontainer2_split_distance > splitContainer2.getHeight() ) {
                    splitContainer2.setDividerLocation( (int)(splitContainer2.getHeight() * 0.9) );
                } else {
                    splitContainer2.setDividerLocation( m_last_splitcontainer2_split_distance );
                }
            } else {
                m_last_splitcontainer2_split_distance = splitContainer2.getDividerLocation();
                splitContainer2.setPanel2MinSize( 0 );
                splitContainer2.setDividerSize( 0 );
                splitContainer2.setDividerLocation( splitContainer2.getHeight() );
                splitContainer2.setSplitterFixed( true );
            }
        }

        /// <summary>
        /// trackSelectorに表示するコントロールのカーブの種類を、AppManager.EditorConfigの設定に応じて更新します
        /// </summary>
        public void updateTrackSelectorVisibleCurve() {
#if DEBUG
            PortUtil.println( "FormMain#updateTrackSelectorVisibleCurve; before; AppManager.getViewingCurveCount()" + AppManager.getViewingCurveCount() );
#endif
            if ( AppManager.editorConfig.CurveVisibleVelocity ) {
                AppManager.addViewingCurve( CurveType.VEL );
            }
            if ( AppManager.editorConfig.CurveVisibleAccent ) {
                AppManager.addViewingCurve( CurveType.Accent );
            }
            if ( AppManager.editorConfig.CurveVisibleDecay ) {
                AppManager.addViewingCurve( CurveType.Decay );
            }
            if ( AppManager.editorConfig.CurveVisibleVibratoRate ) {
                AppManager.addViewingCurve( CurveType.VibratoRate );
            }
            if ( AppManager.editorConfig.CurveVisibleVibratoDepth ) {
                AppManager.addViewingCurve( CurveType.VibratoDepth );
            }
            if ( AppManager.editorConfig.CurveVisibleDynamics ) {
                AppManager.addViewingCurve( CurveType.DYN );
            }
            if ( AppManager.editorConfig.CurveVisibleBreathiness ) {
                AppManager.addViewingCurve( CurveType.BRE );
            }
            if ( AppManager.editorConfig.CurveVisibleBrightness ) {
                AppManager.addViewingCurve( CurveType.BRI );
            }
            if ( AppManager.editorConfig.CurveVisibleClearness ) {
                AppManager.addViewingCurve( CurveType.CLE );
            }
            if ( AppManager.editorConfig.CurveVisibleOpening ) {
                AppManager.addViewingCurve( CurveType.OPE );
            }
            if ( AppManager.editorConfig.CurveVisibleGendorfactor ) {
                AppManager.addViewingCurve( CurveType.GEN );
            }
            if ( AppManager.editorConfig.CurveVisiblePortamento ) {
                AppManager.addViewingCurve( CurveType.POR );
            }
            if ( AppManager.editorConfig.CurveVisiblePit ) {
                AppManager.addViewingCurve( CurveType.PIT );
            }
            if ( AppManager.editorConfig.CurveVisiblePbs ) {
                AppManager.addViewingCurve( CurveType.PBS );
            }
            if ( AppManager.editorConfig.CurveVisibleHarmonics ) {
                AppManager.addViewingCurve( CurveType.harmonics );
            }
            if ( AppManager.editorConfig.CurveVisibleFx2Depth ) {
                AppManager.addViewingCurve( CurveType.fx2depth );
            }
            if ( AppManager.editorConfig.CurveVisibleReso1 ) {
                AppManager.addViewingCurve( CurveType.reso1freq );
                AppManager.addViewingCurve( CurveType.reso1bw );
                AppManager.addViewingCurve( CurveType.reso1amp );
            }
            if ( AppManager.editorConfig.CurveVisibleReso2 ) {
                AppManager.addViewingCurve( CurveType.reso2freq );
                AppManager.addViewingCurve( CurveType.reso2bw );
                AppManager.addViewingCurve( CurveType.reso2amp );
            }
            if ( AppManager.editorConfig.CurveVisibleReso3 ) {
                AppManager.addViewingCurve( CurveType.reso3freq );
                AppManager.addViewingCurve( CurveType.reso3bw );
                AppManager.addViewingCurve( CurveType.reso3amp );
            }
            if ( AppManager.editorConfig.CurveVisibleReso4 ) {
                AppManager.addViewingCurve( CurveType.reso4freq );
                AppManager.addViewingCurve( CurveType.reso4bw );
                AppManager.addViewingCurve( CurveType.reso4amp );
            }
            if ( AppManager.editorConfig.CurveVisibleEnvelope ) {
                AppManager.addViewingCurve( CurveType.Env );
            }
#if DEBUG
            PortUtil.println( "FormMain#updateTrackSelectorVisibleCurve; after; AppManager.getViewingCurveCount()=" + AppManager.getViewingCurveCount() );
#endif
        }

        /// <summary>
        /// ウィンドウの表示内容に応じて、ウィンドウサイズの最小値を計算します
        /// </summary>
        /// <returns></returns>
        public Dimension getWindowMinimumSize() {
            Dimension current_minsize = new Dimension( getMinimumSize().width, getMinimumSize().height );
#if JAVA
            Dimension client = getContentPane().getSize();
            Dimension current = getSize();
            return new Dimension( current_minsize.width,
                                  splitContainer1.getPanel2MinSize() +
                                  _SCROLL_WIDTH + _PICT_POSITION_INDICATOR_HEIGHT + pictPianoRoll.getMinimumSize().height +
                                  menuStripMain.getHeight() +
                                  (current.height - client.height) +
                                  20 );
#else
            Dimension client = new Dimension( this.ClientSize.Width, this.ClientSize.Height );
            Dimension current = new Dimension( this.Size.Width, this.Size.Height );
            return new Dimension( current_minsize.width,
                                  splitContainer1.getPanel2MinSize() +
                                  _SCROLL_WIDTH + _PICT_POSITION_INDICATOR_HEIGHT + pictPianoRoll.getMinimumSize().height +
                                  toolStripContainer.TopToolStripPanel.Height +
                                  menuStripMain.getHeight() + statusStrip1.Height +
                                  (current.height - client.height) +
                                  20 );
#endif
        }

        /// <summary>
        /// 現在のAppManager.inputTextBoxの状態を元に、歌詞の変更を反映させるコマンドを実行します
        /// </summary>
        public void executeLyricChangeCommand() {
#if JAVA
            if ( !AppManager.inputTextBox.isVisible() ) {
#else
            if ( !AppManager.inputTextBox.Enabled ) {
#endif
                return;
            }
#if !JAVA
            if ( AppManager.inputTextBox.IsDisposed ) {
                return;
            }
#endif
            SelectedEventEntry last_selected_event = AppManager.getLastSelectedEvent();
            boolean phonetic_symbol_edit_mode = AppManager.inputTextBox.isPhoneticSymbolEditMode();

            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            VsqTrack vsq_track = vsq.Track.get( selected );

            // 後続に、連続している音符が何個あるか検査
            int maxcount = SymbolTable.getMaxDivisions(); // 音節の分割によって，高々maxcount個までにしか分割されない
            boolean check_started = false;
            int endclock = 0;  // 直前の音符の終了クロック
            int count = 0;     // 後続音符の連続個数
            int start_index = -1;
            int indx = -1;
            for ( Iterator<Integer> itr = vsq_track.indexIterator( IndexIteratorKind.NOTE ); itr.hasNext(); ) {
                indx = itr.next();
                VsqEvent itemi = vsq_track.getEvent( indx );
                if ( itemi.InternalID == last_selected_event.original.InternalID ) {
                    check_started = true;
                    endclock = itemi.Clock + itemi.ID.getLength();
                    count = 1;
                    start_index = indx;
                    continue;
                }
                if ( check_started ) {
                    if ( count + 1 > maxcount ) {
                        break;
                    }
                    if ( itemi.Clock <= endclock ) {
                        count++;
                        endclock = itemi.Clock + itemi.ID.getLength();
                    } else {
                        break;
                    }
                }
            }

            // 後続の音符をリストアップ
            VsqEvent[] items = new VsqEvent[count];
            String[] original_symbol = new String[count];
            String[] original_phrase = new String[count];
            boolean[] symbol_protected = new boolean[count];
            indx = -1;
            for ( Iterator<Integer> itr = vsq_track.indexIterator( IndexIteratorKind.NOTE ); itr.hasNext(); ) {
                int index = itr.next();
                if ( index < start_index ) {
                    continue;
                }
                indx++;
                if ( count <= indx ) {
                    break;
                }
                VsqEvent ve = vsq_track.getEvent( index );
                items[indx] = (VsqEvent)ve.clone();
                original_symbol[indx] = ve.ID.LyricHandle.L0.getPhoneticSymbol();
                original_phrase[indx] = ve.ID.LyricHandle.L0.Phrase;
                symbol_protected[indx] = ve.ID.LyricHandle.L0.PhoneticSymbolProtected;
            }

#if DEBUG
            AppManager.debugWriteLine( "    original_phase,symbol=" + original_phrase + "," + original_symbol[0] );
            AppManager.debugWriteLine( "    phonetic_symbol_edit_mode=" + phonetic_symbol_edit_mode );
            AppManager.debugWriteLine( "    AppManager.inputTextBox.setText(=" + AppManager.inputTextBox.getText() );
#endif
            String[] phrase = new String[count];
            String[] phonetic_symbol = new String[count];
            for ( int i = 0; i < count; i++ ) {
                phrase[i] = original_phrase[i];
                phonetic_symbol[i] = original_symbol[i];
            }
            String txt = AppManager.inputTextBox.getText();
            int txtlen = PortUtil.getStringLength( txt );
            if ( txtlen > 0 ) {
                // 1文字目は，UTAUの連続音入力のハイフンの可能性があるので，無駄に置換されるのを回避
                phrase[0] = txt.Substring( 0, 1 ) + ((txtlen > 1) ? txt.Substring( 1 ).Replace( "-", "" ) : "");
            } else {
                phrase[0] = "";
            }
            if ( !phonetic_symbol_edit_mode ) {
                // 歌詞を編集するモードで、
                if ( AppManager.editorConfig.SelfDeRomanization ) {
                    // かつローマ字の入力を自動でひらがなに展開する設定だった場合。
                    // ローマ字をひらがなに展開
                    phrase[0] = KanaDeRomanization.Attach( phrase[0] );
                }
            }

            // 発音記号または歌詞が変更された場合の処理
            if ( (phonetic_symbol_edit_mode && !AppManager.inputTextBox.getText().Equals( original_symbol[0] )) ||
                 (!phonetic_symbol_edit_mode && !phrase[0].Equals( original_phrase[0] )) ) {
                if ( phonetic_symbol_edit_mode ) {
                    // 発音記号を編集するモード
                    phrase[0] = AppManager.inputTextBox.getBufferText();
                    phonetic_symbol[0] = AppManager.inputTextBox.getText();

                    // 入力された発音記号のうち、有効なものだけをピックアップ
                    String[] spl = PortUtil.splitString( phonetic_symbol[0], new char[] { ' ' }, true );
                    Vector<String> list = new Vector<String>();
                    for ( int i = 0; i < spl.Length; i++ ) {
                        String s = spl[i];
                        if ( VsqPhoneticSymbol.isValidSymbol( s ) ) {
                            list.add( s );
                        }
                    }

                    // ピックアップした発音記号をスペース区切りで結合
                    phonetic_symbol[0] = "";
                    boolean first = true;
                    for ( Iterator<String> itr = list.iterator(); itr.hasNext(); ) {
                        String s = itr.next();
                        if ( first ) {
                            phonetic_symbol[0] += s;
                            first = false;
                        } else {
                            phonetic_symbol[0] += " " + s;
                        }
                    }

                    // 発音記号を編集すると、自動で「発音記号をプロテクトする」モードになるよ
                    symbol_protected[0] = true;
                } else {
                    // 歌詞を編集するモード
                    if ( !symbol_protected[0] ) {
                        // 発音記号をプロテクトしない場合、歌詞から発音記号を引当てる
                        SymbolTableEntry entry = SymbolTable.attatch( phrase[0] );
                        if ( entry == null ) {
                            phonetic_symbol[0] = "a";
                        } else {
                            phonetic_symbol[0] = entry.getSymbol();
                            // 分節の分割記号'-'が入っている場合
                            if ( entry.Word.IndexOf( '-' ) >= 0 ) {
                                String[] spl_phrase = PortUtil.splitString( entry.Word, '\t' );
                                if ( spl_phrase.Length <= count ) {
                                    // 分節の分割数が，後続の音符数と同じか少ない場合
                                    String[] spl_symbol = PortUtil.splitString( entry.getRawSymbol(), '\t' );
                                    for ( int i = 0; i < spl_phrase.Length; i++ ) {
                                        phrase[i] = spl_phrase[i];
                                        phonetic_symbol[i] = spl_symbol[i];
                                    }
                                } else {
                                    // 後続の音符の個数が足りない
                                    phrase[0] = entry.Word.Replace( "\t", "" );
                                }
                            }
                        }
                    } else {
                        // 発音記号をプロテクトする場合、発音記号は最初のやつを使う
                        phonetic_symbol[0] = original_symbol[0];
                    }
                }
#if DEBUG
                AppManager.debugWriteLine( "    phrase,phonetic_symbol=" + phrase + "," + phonetic_symbol );
#endif

                for ( int j = 0; j < count; j++ ) {
                    if ( phonetic_symbol_edit_mode ) {
                        items[j].ID.LyricHandle.L0.setPhoneticSymbol( phonetic_symbol[j] );
                    } else {
                        items[j].ID.LyricHandle.L0.Phrase = phrase[j];
                        items[j].ID.LyricHandle.L0.setPhoneticSymbol( phonetic_symbol[j] );
                        VsqEvent singer = vsq_track.getSingerEventAt( items[j].Clock );
                        SingerConfig sc = AppManager.getSingerInfoUtau( singer.ID.IconHandle.Language, singer.ID.IconHandle.Program );
                        if ( sc != null && AppManager.utauVoiceDB.containsKey( sc.VOICEIDSTR ) ) {
                            UtauVoiceDB db = AppManager.utauVoiceDB.get( sc.VOICEIDSTR );
                            OtoArgs oa = db.attachFileNameFromLyric( phrase[j] );
                            items[j].UstEvent.PreUtterance = oa.msPreUtterance;
                            items[j].UstEvent.VoiceOverlap = oa.msOverlap;
                        }
                    }
                    if ( !original_symbol[j].Equals( phonetic_symbol[j] ) ) {
                        String[] spl = items[j].ID.LyricHandle.L0.getPhoneticSymbolList();
                        int[] adjustment = new int[spl.Length];
                        for ( int i = 0; i < adjustment.Length; i++ ) {
                            adjustment[i] = VsqPhoneticSymbol.isConsonant( spl[i] ) ? 64 : 0;
                        }
                        items[j].ID.LyricHandle.L0.setConsonantAdjustmentList( adjustment );
                    }
                }

                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventReplaceRange( selected, items ) );
                AppManager.register( vsq.executeCommand( run ) );
                setEdited( true );
            }
        }

        /// <summary>
        /// 識別済みのゲームコントローラを取り外します
        /// </summary>
        public void removeGameControler() {
#if !JAVA
            if ( m_timer != null ) {
                m_timer.stop();
                m_timer.Dispose();
                m_timer = null;
            }
            m_game_mode = GameControlMode.DISABLED;
            updateGameControlerStatus( null, null );
#endif
        }

        /// <summary>
        /// PCに接続されているゲームコントローラを識別・接続します
        /// </summary>
        public void loadGameControler() {
#if !JAVA
            try {
                boolean init_success = false;
                int num_joydev = winmmhelp.JoyInit();
                if ( num_joydev <= 0 ) {
                    init_success = false;
                } else {
                    init_success = true;
                }
                if ( init_success ) {
                    m_game_mode = GameControlMode.NORMAL;
                    stripLblGameCtrlMode.setIcon( null );
                    stripLblGameCtrlMode.setText( m_game_mode.ToString() );
                    m_timer = new BTimer();
                    m_timer.setDelay( 10 );
                    m_timer.Tick += new EventHandler( m_timer_Tick );
                    m_timer.start();
                } else {
                    m_game_mode = GameControlMode.DISABLED;
                }
            } catch ( Exception ex ) {
                m_game_mode = GameControlMode.DISABLED;
#if DEBUG
                AppManager.debugWriteLine( "FormMain+ReloadGameControler" );
                AppManager.debugWriteLine( "    ex=" + ex );
#endif
            }
            updateGameControlerStatus( null, null );
#endif
        }

#if ENABLE_MIDI
        /// <summary>
        /// MIDI入力句デバイスを再読込みします
        /// </summary>
        public void reloadMidiIn() {
            if ( m_midi_in != null ) {
                m_midi_in.MidiReceived -= m_midi_in_MidiReceived;
                m_midi_in.Dispose();
                m_midi_in = null;
            }
            int portNumber = AppManager.editorConfig.MidiInPort.PortNumber;
            int portNumberMtc = AppManager.editorConfig.MidiInPortMtc.PortNumber;
#if DEBUG
            PortUtil.println( "FormMain#reloadMidiIn; portNumber=" + portNumber + "; portNumberMtc=" + portNumberMtc );
#endif
            try {
                m_midi_in = new MidiInDevice( portNumber );
                m_midi_in.MidiReceived += m_midi_in_MidiReceived;
#if ENABLE_MTC
                if ( portNumber == portNumberMtc ) {
                    m_midi_in.setReceiveSystemCommonMessage( true );
                    m_midi_in.setReceiveSystemRealtimeMessage( true );
                    m_midi_in.MidiReceived += handleMtcMidiReceived;
                    m_midi_in.Start();
                } else {
                    m_midi_in.setReceiveSystemCommonMessage( false );
                    m_midi_in.setReceiveSystemRealtimeMessage( false );
                }
#else
                m_midi_in.setReceiveSystemCommonMessage( false );
                m_midi_in.setReceiveSystemRealtimeMessage( false );
#endif
            } catch ( Exception ex ) {
                PortUtil.stderr.println( "FormMain#reloadMidiIn; ex=" + ex );
            }

#if ENABLE_MTC
            if ( m_midi_in_mtc != null ) {
                m_midi_in_mtc.MidiReceived -= handleMtcMidiReceived;
                m_midi_in_mtc.Dispose();
                m_midi_in_mtc = null;
            }
            if ( portNumber != portNumberMtc ) {
                try {
                    m_midi_in_mtc = new MidiInDevice( AppManager.editorConfig.MidiInPortMtc.PortNumber );
                    m_midi_in_mtc.MidiReceived += handleMtcMidiReceived;
                    m_midi_in_mtc.setReceiveSystemCommonMessage( true );
                    m_midi_in_mtc.setReceiveSystemRealtimeMessage( true );
                    m_midi_in_mtc.Start();
                } catch ( Exception ex ) {
                    PortUtil.stderr.println( "FormMain#reloadMidiIn; ex=" + ex );
                }
            }
#endif
            updateMidiInStatus();
        }
#endif

#if ENABLE_MIDI
        public void updateMidiInStatus() {
            int midiport = AppManager.editorConfig.MidiInPort.PortNumber;
            org.kbinani.MIDIINCAPS[] devices = MidiInDevice.GetMidiInDevices();
            if ( midiport < 0 || devices.Length <= 0 ) {
                stripLblMidiIn.setText( _( "Disabled" ) );
                stripLblMidiIn.setIcon( new ImageIcon( Resources.get_slash() ) );
            } else {
                if ( midiport >= devices.Length ) {
                    midiport = 0;
                    AppManager.editorConfig.MidiInPort.PortNumber = midiport;
                }
                stripLblMidiIn.setText( devices[midiport].szPname );
                stripLblMidiIn.setIcon( new ImageIcon( Resources.get_piano() ) );
            }
        }
#endif

#if ENABLE_SCRIPT
        /// <summary>
        /// スクリプトフォルダ中のスクリプトへのショートカットを作成する
        /// </summary>
        public void updateScriptShortcut() {
            // 既存のアイテムを削除
            menuScript.removeAll();
            // スクリプトをリロード
            ScriptServer.reload();

            // スクリプトごとのメニューを追加
            int count = 0;
            for ( Iterator<String> itr = ScriptServer.getScriptIdIterator(); itr.hasNext(); ) {
                String id = itr.next();
                if ( PortUtil.getFileNameWithoutExtension( id ).ToLower().Equals( "runonce" ) ) {
                    continue;
                }
                String display = ScriptServer.getDisplayName( id );
                String name = "menuScript" + id.Replace( '.', '_' );
                BMenuItem item = new BMenuItem();
                item.setText( display );
                item.setName( name );
                item.setTag( id );
                item.clickEvent.add( new BEventHandler( this, "handleScriptMenuItem_Click" ) );
                menuScript.add( item );
                count++;
            }

            // 「スクリプトのリストを更新」を追加
            if ( count > 0 ) {
                menuScript.addSeparator();
            }
            menuScript.add( menuScriptUpdate );
            Util.applyToolStripFontRecurse( menuScript, AppManager.editorConfig.getBaseFont() );
            applyShortcut();
        }
#endif
        /// <summary>
        /// 指定したノートナンバーが可視状態となるよう、縦スクロールバーを移動させます。
        /// </summary>
        /// <param name="note"></param>
        public void ensureVisibleY( int note ) {
            if ( note == 0 ) {
                vScroll.setValue( vScroll.getMaximum() );
                return;
            } else if ( note == 127 ) {
                vScroll.setValue( vScroll.getMinimum() );
                return;
            }
            int height = vScroll.getHeight();
            int noteTop = AppManager.noteFromYCoord( 0 ); //画面上端でのノートナンバー
            int noteBottom = AppManager.noteFromYCoord( height ); // 画面下端でのノートナンバー

            int maximum = vScroll.getMaximum();
            int track_height = AppManager.editorConfig.PxTrackHeight;
            if ( note < noteBottom ) {
                // noteBottomがnoteになるようにstartToDrawYを変える
                int draft = (127 - note) * track_height - height;
                int value = draft * maximum / (128 * track_height - height);
                vScroll.setValue( value );
            } else if ( noteTop < note ) {
                // noteTopがnoteになるようにstartToDrawYを変える
                int draft = (127 - note) * track_height;
                int value = draft * maximum / (128 * track_height - height);
                vScroll.setValue( value );
            }
        }

        /// <summary>
        /// 指定したゲートタイムがピアノロール上で可視状態となるよう、横スクロールバーを移動させます。
        /// </summary>
        /// <param name="clock"></param>
        public void ensureVisible( int clock ) {
            // カーソルが画面内にあるかどうか検査
            int clock_left = AppManager.clockFromXCoord( AppManager.keyWidth );
            int clock_right = AppManager.clockFromXCoord( pictPianoRoll.getWidth() );
            int uwidth = clock_right - clock_left;
            if ( clock < clock_left || clock_right < clock ) {
                int cl_new_center = (clock / uwidth) * uwidth + uwidth / 2;
                float f_draft = cl_new_center - (pictPianoRoll.getWidth() / 2 + 34 - 70) * AppManager.getScaleXInv();
                if ( f_draft < 0f ) {
                    f_draft = 0;
                }
                int draft = (int)(f_draft);
                if ( draft < hScroll.getMinimum() ) {
                    draft = hScroll.getMinimum();
                } else if ( hScroll.getMaximum() < draft ) {
                    draft = hScroll.getMaximum();
                }
                if ( hScroll.getValue() != draft ) {
                    AppManager.drawStartIndex[AppManager.getSelected() - 1] = 0;
                    hScroll.setValue( draft );
                }
            }
        }

        /// <summary>
        /// プレイカーソルが見えるようスクロールする
        /// </summary>
        public void ensureCursorVisible() {
            ensureVisible( AppManager.getCurrentClock() );
        }

        /// <summary>
        /// 特殊なショートカットキーを処理します。
        /// </summary>
        /// <param name="e"></param>
        /// <param name="onPreviewKeyDown">PreviewKeyDownイベントから送信されてきた場合、true（送る側が設定する）</param>
        public void processSpecialShortcutKey( BKeyEventArgs e, boolean onPreviewKeyDown ) {
            boolean flipPlaying = false; // 再生/停止状態の切り替えが要求されたらtrue

            // 最初に、特殊な取り扱いが必要なショートカット、について、
            // 該当するショートカットがあればそいつらを発動する。
            int modifier = PortUtil.getCurrentModifierKey();
            if ( onPreviewKeyDown ) {
                KeyStroke stroke = KeyStroke.getKeyStroke( e.KeyValue, modifier );
                int keycode = stroke.getKeyCode();
#if DEBUG
                PortUtil.println( "FormMain#processSpecialShortcutKey; e.KeyCode=" + e.KeyCode + "; keycode=" + keycode + "; modifier=" + modifier );
#endif

                foreach ( SpecialShortcutHolder holder in specialShortcutHolders ) {
                    if ( holder.shortcut.getKeyCode() == keycode && holder.shortcut.getModifiers() == modifier ) {
                        try {
                            holder.menu.clickEvent.raise( holder.menu, new EventArgs() );
                        } catch ( Exception ex ) {
                            PortUtil.stderr.println( "FormMain#processSpecialShortcutKey; ex=" + ex );
                        }
                        return;
                    }
                }
            }

            if ( modifier != KeyEvent.VK_UNDEFINED ) {
                return;
            }
#if JAVA
            if ( !AppManager.inputTextBox.isVisible() ) {
#else
            if ( !AppManager.inputTextBox.Enabled ) {
#endif

#if JAVA
                if ( e.KeyValue == KeyEvent.VK_ENTER ) {
#else
                if ( e.KeyCode == System.Windows.Forms.Keys.Return ) {
#endif
                    numEnterKeyAfterHideInputTextBox++;
                    if ( numEnterKeyAfterHideInputTextBox >= 2 ) {
                        // 2回目以降しか受け付けないことにする
                        flipPlaying = true;
                    }
#if JAVA
                } else if ( e.KeyValue == KeyEvent.VK_SPACE ) {
#else
                } else if ( e.KeyCode == System.Windows.Forms.Keys.Space ) {
#endif
                    if ( !AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier ) {
                        flipPlaying = true;
                    }
#if JAVA
                } else if ( e.KeyValue == KeyEvent.VK_PERIOD ) {
#else
                } else if ( e.KeyCode == System.Windows.Forms.Keys.OemPeriod ) {
#endif
                    if ( !onPreviewKeyDown ) {

                        if ( AppManager.isPlaying() ) {
                            AppManager.setPlaying( false );
                        } else {
                            if ( !AppManager.startMarkerEnabled ) {
                                AppManager.setCurrentClock( 0 );
                            } else {
                                AppManager.setCurrentClock( AppManager.startMarker );
                            }
                            refreshScreen();
                        }
                    }
#if JAVA
                } else if( e.KeyValue == KeyEvent.VK_ADD || e.KeyValue == KeyEvent.VK_PLUS || e.KeyValue == KeyEvent.VK_RIGHT ) {
#else
                } else if ( e.KeyCode == System.Windows.Forms.Keys.Add || e.KeyCode == System.Windows.Forms.Keys.Oemplus || e.KeyCode == System.Windows.Forms.Keys.Right ) {
#endif
                    if ( onPreviewKeyDown ) {
                        forward();
                    }
#if JAVA
                } else if ( e.KeyValue == KeyEvent.VK_MINUS || e.KeyValue == KeyEvent.VK_LEFT ) {
#else
                } else if ( e.KeyCode == System.Windows.Forms.Keys.Subtract || e.KeyCode == System.Windows.Forms.Keys.OemMinus || e.KeyCode == System.Windows.Forms.Keys.Left ) {
#endif
                    if ( onPreviewKeyDown ) {
                        rewind();
                    }
                } else {
                    if ( !AppManager.isPlaying() ) {
                        // 最初に戻る、の機能を発動
                        BKeys[] specialGoToFirst = AppManager.editorConfig.SpecialShortcutGoToFirst;
                        if ( specialGoToFirst != null && specialGoToFirst.Length > 0 ) {
                            KeyStroke ks = BKeysUtility.getKeyStrokeFromBKeys( specialGoToFirst );
#if JAVA
                            if( e.KeyCode == ks.getKeyCode() )
#else
                            if ( e.KeyCode == ks.keys )
#endif
 {
                                AppManager.setCurrentClock( 0 );
                                ensureCursorVisible();
                                refreshScreen();
                            }
                        }
                    }
                }
                if ( !onPreviewKeyDown && flipPlaying ) {
                    if ( AppManager.isPlaying() ) {
                        double elapsed = PlaySound.getPosition();
                        double threshold = AppManager.forbidFlipPlayingThresholdSeconds;
                        if ( threshold < 0 ) {
                            threshold = 0.0;
                        }
                        if ( elapsed > threshold ) {
                            timer.stop();
                            AppManager.setPlaying( false );
                        }
                    } else {
                        AppManager.setPlaying( true );
                    }
                }
            }
            return;
            #region OLD CODES DO NOT REMOVE
            /*if ( AppManager.EditorConfig.Platform == Platform.Macintosh ) {
                if ( AppManager.EditorConfig.CommandKeyAsControl ) {
                    #region menuStripMain
                    if ( e.Alt && e.KeyCode == Keys.N && menuFileNew.isEnabled() ) {
                        this.menuFileNew_Click( menuFileNew, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.O && menuFileOpen.isEnabled() ) {
                        this.menuFileOpen_Click( menuFileOpen, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.S && menuFileSave.isEnabled() ) {
                        this.menuFileSave_Click( menuFileSave, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.Q && menuFileQuit.isEnabled() ) {
                        this.menuFileQuit_Click( menuFileQuit, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.Z && menuEditUndo.isEnabled() ) {
                        this.menuEditUndo_Click( menuEditUndo, null );
                        return;
                    } else if ( e.Alt && e.Shift && e.KeyCode == Keys.Z && menuEditRedo.isEnabled() ) {
                        this.menuEditRedo_Click( this.menuEditRedo, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.X && this.menuEditCut.isEnabled() ) {
                        this.menuEditCut_Click( this.menuEditCut, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.C && this.menuEditCopy.isEnabled() ) {
                        this.menuEditCopy_Click( this.menuEditCopy, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.V && this.menuEditPaste.isEnabled() ) {
                        this.menuEditPaste_Click( this.menuEditPaste, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.A && this.menuEditSelectAll.isEnabled() ) {
                        this.menuEditSelectAll_Click( this.menuEditSelectAll, null );
                        return;
                    } else if ( e.Alt && e.Shift && this.menuEditSelectAllEvents.isEnabled() ) {
                        this.menuEditSelectAllEvents_Click( this.menuEditSelectAllEvents, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.V && this.menuHiddenEditPaste.isEnabled() ) {
                        this.menuHiddenEditPaste_Click( this.menuHiddenEditPaste, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.W && this.menuHiddenEditFlipToolPointerPencil.isEnabled() ) {
                        this.menuHiddenEditFlipToolPointerPencil_Click( this.menuHiddenEditFlipToolPointerPencil, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.E && this.menuHiddenEditFlipToolPointerEraser.isEnabled() ) {
                        this.menuHiddenEditFlipToolPointerEraser_Click( this.menuHiddenEditFlipToolPointerEraser, null );
                        return;
                    } else if ( (e.KeyCode & Keys.Clear) == Keys.Clear && e.Alt && e.Shift && this.menuHiddenVisualForwardParameter.isEnabled() ) {
                        this.menuHiddenVisualForwardParameter_Click( this.menuHiddenVisualForwardParameter, null );
                        return;
                    } else if ( (e.KeyCode & Keys.LButton) == Keys.LButton && (e.KeyCode & Keys.LineFeed) == Keys.LineFeed && e.Alt && e.Shift && this.menuHiddenVisualBackwardParameter.isEnabled() ) {
                        this.menuHiddenVisualBackwardParameter_Click( this.menuHiddenVisualBackwardParameter, null );
                        return;
                    } else if ( (e.KeyCode & Keys.Clear) == Keys.Clear && e.Alt && this.menuHiddenTrackNext.isEnabled() ) {
                        this.menuHiddenTrackNext_Click( this.menuHiddenTrackNext, null );
                        return;
                    } else if ( (e.KeyCode & Keys.LButton) == Keys.LButton && (e.KeyCode & Keys.LineFeed) == Keys.LineFeed && e.Alt && this.menuHiddenTrackBack.isEnabled() ) {
                        this.menuHiddenTrackBack_Click( this.menuHiddenTrackBack, null );
                        return;
                    }
                    #endregion

                    #region cMenuPiano
                    if ( e.Alt && e.KeyCode == Keys.Z && cMenuPianoUndo.isEnabled() ) {
                        this.cMenuPianoUndo_Click( this.cMenuPianoUndo, null );
                        return;
                    } else if ( e.Alt && e.Shift && e.KeyCode == Keys.Z && this.cMenuPianoRedo.isEnabled() ) {
                        this.cMenuPianoRedo_Click( this.cMenuPianoRedo, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.X && this.cMenuPianoCut.isEnabled() ) {
                        this.cMenuPianoCut_Click( this.cMenuPianoCut, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.C && this.cMenuPianoCopy.isEnabled() ) {
                        this.cMenuPianoCopy_Click( this.cMenuPianoCopy, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.A && cMenuPianoSelectAll.isEnabled() ) {
                        this.cMenuPianoSelectAll_Click( this.cMenuPianoSelectAll, null );
                        return;
                    } else if ( e.Alt && e.Shift && e.KeyCode == Keys.A && cMenuPianoSelectAllEvents.isEnabled() ) {
                        this.cMenuPianoSelectAllEvents_Click( this.cMenuPianoSelectAllEvents, null );
                        return;
                    }
                    #endregion

                    #region cMenuTrackSelector
                    if ( e.Alt && e.KeyCode == Keys.Z && cMenuTrackSelectorUndo.isEnabled() ) {
                        this.cMenuTrackSelectorUndo_Click( this.cMenuTrackSelectorUndo, null );
                        return;
                    } else if ( e.Alt && e.Shift && e.KeyCode == Keys.Z && this.cMenuTrackSelectorRedo.isEnabled() ) {
                        this.cMenuTrackSelectorRedo_Click( this.cMenuTrackSelectorRedo, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.X && this.cMenuTrackSelectorCut.isEnabled() ) {
                        this.cMenuTrackSelectorCut_Click( this.cMenuTrackSelectorCut, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.C && this.cMenuTrackSelectorCopy.isEnabled() ) {
                        this.cMenuTrackSelectorCopy_Click( this.cMenuTrackSelectorCopy, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.V && this.cMenuTrackSelectorPaste.isEnabled() ) {
                        this.cMenuTrackSelectorPaste_Click( this.cMenuTrackSelectorPaste, null );
                        return;
                    } else if ( e.Alt && e.Shift && e.KeyCode == Keys.A && this.cMenuTrackSelectorSelectAll.isEnabled() ) {
                        this.cMenuTrackSelectorSelectAll_Click( this.cMenuTrackSelectorSelectAll, null );
                        return;
                    }
                    #endregion
                } else {
                    boolean RButton = (e.KeyCode & Keys.RButton) == Keys.RButton;
                    boolean Clear = (e.KeyCode & Keys.Clear) == Keys.Clear;
                    boolean Return = (e.KeyCode & Keys.Return) == Keys.Return;
                    boolean Pause = (e.KeyCode & Keys.Pause) == Keys.Pause;
                    boolean FinalMode = (e.KeyCode & Keys.FinalMode) == Keys.FinalMode;
                    boolean Cancel = (e.KeyCode & Keys.Cancel) == Keys.Cancel;
                    boolean CapsLock = (e.KeyCode & Keys.CapsLock) == Keys.CapsLock;
                    boolean LButton = (e.KeyCode & Keys.LButton) == Keys.LButton;
                    boolean JunjaMode = (e.KeyCode & Keys.JunjaMode) == Keys.JunjaMode;
                    boolean LineFeed = (e.KeyCode & Keys.LineFeed) == Keys.LineFeed;
                    boolean ControlKey = (e.KeyCode & Keys.ControlKey) == Keys.ControlKey;
                    boolean XButton1 = (e.KeyCode & Keys.XButton1) == Keys.XButton1;

                    #region menuStripMain
                    if ( RButton && Clear && (e.KeyCode & Keys.N) == Keys.N && menuFileNew.isEnabled() ) {
                        this.menuFileNew_Click( menuFileNew, null );
                        return;
                    } else if ( RButton && Return && (e.KeyCode & Keys.O) == Keys.O && menuFileOpen.isEnabled() ) {
                        this.menuFileOpen_Click( menuFileOpen, null );
                        return;
                    } else if ( Pause && (e.KeyCode & Keys.S) == Keys.S && menuFileSave.isEnabled() ) {
                        this.menuFileSave_Click( menuFileSave, null );
                        return;
                    } else if ( ControlKey && (e.KeyCode & Keys.Q) == Keys.Q && menuFileQuit.isEnabled() ) {
                        this.menuFileQuit_Click( menuFileQuit, null );
                        return;
                    } else if ( RButton && FinalMode && (e.KeyCode & Keys.Z) == Keys.Z && menuEditUndo.isEnabled() ) {
                        this.menuEditUndo_Click( menuEditUndo, null );
                        return;
                    } else if ( RButton && FinalMode && e.Shift && (e.KeyCode & Keys.Z) == Keys.Z && menuEditRedo.isEnabled() ) {
                        this.menuEditRedo_Click( this.menuEditRedo, null );
                        return;
                    } else if ( FinalMode && (e.KeyCode & Keys.X) == Keys.X && this.menuEditCut.isEnabled() ) {
                        this.menuEditCut_Click( this.menuEditCut, null );
                        return;
                    } else if ( Cancel && (e.KeyCode & Keys.C) == Keys.C && this.menuEditCopy.isEnabled() ) {
                        this.menuEditCopy_Click( this.menuEditCopy, null );
                        return;
                    } else if ( RButton && CapsLock && (e.KeyCode & Keys.V) == Keys.V && this.menuEditPaste.isEnabled() ) {
                        this.menuEditPaste_Click( this.menuEditPaste, null );
                        return;
                    } else if ( LButton && (e.KeyCode & Keys.A) == Keys.A && this.menuEditSelectAll.isEnabled() ) {
                        this.menuEditSelectAll_Click( this.menuEditSelectAll, null );
                        return;
                    } else if ( LButton && e.Shift && (e.KeyCode & Keys.A) == Keys.A && this.menuEditSelectAllEvents.isEnabled() ) {
                        this.menuEditSelectAllEvents_Click( this.menuEditSelectAllEvents, null );
                        return;
                    } else if ( RButton && CapsLock && (e.KeyCode & Keys.V) == Keys.V && this.menuHiddenEditPaste.isEnabled() ) {
                        this.menuHiddenEditPaste_Click( this.menuHiddenEditPaste, null );
                        return;
                    } else if ( JunjaMode && (e.KeyCode & Keys.W) == Keys.W && this.menuHiddenEditFlipToolPointerPencil.isEnabled() ) {
                        this.menuHiddenEditFlipToolPointerPencil_Click( this.menuHiddenEditFlipToolPointerPencil, null );
                        return;
                    } else if ( XButton1 && (e.KeyCode & Keys.E) == Keys.E && this.menuHiddenEditFlipToolPointerEraser.isEnabled() ) {
                        this.menuHiddenEditFlipToolPointerEraser_Click( this.menuHiddenEditFlipToolPointerEraser, null );
                        return;
                    } else if ( Clear && e.Control && e.Shift && this.menuHiddenVisualForwardParameter.isEnabled() ) {
                        this.menuHiddenVisualForwardParameter_Click( this.menuHiddenVisualForwardParameter, null );
                        return;
                    } else if ( LButton && LineFeed && e.Control && e.Shift && this.menuHiddenVisualBackwardParameter.isEnabled() ) {
                        this.menuHiddenVisualBackwardParameter_Click( this.menuHiddenVisualBackwardParameter, null );
                        return;
                    } else if ( Clear && e.Control && this.menuHiddenTrackNext.isEnabled() ) {
                        this.menuHiddenTrackNext_Click( this.menuHiddenTrackNext, null );
                        return;
                    } else if ( LButton && LineFeed && e.Control && this.menuHiddenTrackBack.isEnabled() ) {
                        this.menuHiddenTrackBack_Click( this.menuHiddenTrackBack, null );
                        return;
                    }
                    #endregion

                    #region cMenuPiano
                    if ( RButton && FinalMode && (e.KeyCode & Keys.Z) == Keys.Z && cMenuPianoUndo.isEnabled() ) {
                        this.cMenuPianoUndo_Click( this.cMenuPianoUndo, null );
                        return;
                    } else if ( RButton && FinalMode && e.Shift && (e.KeyCode & Keys.Z) == Keys.Z && this.cMenuPianoRedo.isEnabled() ) {
                        this.cMenuPianoRedo_Click( this.cMenuPianoRedo, null );
                        return;
                    } else if ( FinalMode && (e.KeyCode & Keys.X) == Keys.X && this.cMenuPianoCut.isEnabled() ) {
                        this.cMenuPianoCut_Click( this.cMenuPianoCut, null );
                        return;
                    } else if ( Cancel && (e.KeyCode & Keys.C) == Keys.C && this.cMenuPianoCopy.isEnabled() ) {
                        this.cMenuPianoCopy_Click( this.cMenuPianoCopy, null );
                        return;
                    } else if ( LButton && (e.KeyCode & Keys.A) == Keys.A && cMenuPianoSelectAll.isEnabled() ) {
                        this.cMenuPianoSelectAll_Click( this.cMenuPianoSelectAll, null );
                        return;
                    } else if ( LButton && e.Shift && (e.KeyCode & Keys.A) == Keys.A && cMenuPianoSelectAllEvents.isEnabled() ) {
                        this.cMenuPianoSelectAllEvents_Click( this.cMenuPianoSelectAllEvents, null );
                        return;
                    }
                    #endregion

                    #region cMenuTrackSelector
                    if ( RButton && FinalMode && (e.KeyCode & Keys.Z) == Keys.Z && cMenuTrackSelectorUndo.isEnabled() ) {
                        this.cMenuTrackSelectorUndo_Click( this.cMenuTrackSelectorUndo, null );
                        return;
                    } else if ( RButton && FinalMode && e.Shift && (e.KeyCode & Keys.Z) == Keys.Z && this.cMenuTrackSelectorRedo.isEnabled() ) {
                        this.cMenuTrackSelectorRedo_Click( this.cMenuTrackSelectorRedo, null );
                        return;
                    } else if ( FinalMode && (e.KeyCode & Keys.X) == Keys.X && this.cMenuTrackSelectorCut.isEnabled() ) {
                        this.cMenuTrackSelectorCut_Click( this.cMenuTrackSelectorCut, null );
                        return;
                    } else if ( Cancel && (e.KeyCode & Keys.C) == Keys.C && this.cMenuTrackSelectorCopy.isEnabled() ) {
                        this.cMenuTrackSelectorCopy_Click( this.cMenuTrackSelectorCopy, null );
                        return;
                    } else if ( RButton && CapsLock && (e.KeyCode & Keys.V) == Keys.V && this.cMenuTrackSelectorPaste.isEnabled() ) {
                        this.cMenuTrackSelectorPaste_Click( this.cMenuTrackSelectorPaste, null );
                        return;
                    } else if ( LButton && e.Shift && (e.KeyCode & Keys.A) == Keys.A && this.cMenuTrackSelectorSelectAll.isEnabled() ) {
                        this.cMenuTrackSelectorSelectAll_Click( this.cMenuTrackSelectorSelectAll, null );
                        return;
                    }
                    #endregion
                }
            } else {
                #region menuStripMain
                if ( e.Control && e.KeyCode == Keys.N && menuFileNew.isEnabled() ) {
                    this.menuFileNew_Click( menuFileNew, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.O && menuFileOpen.isEnabled() ) {
                    this.menuFileOpen_Click( menuFileOpen, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.S && menuFileSave.isEnabled() ) {
                    this.menuFileSave_Click( menuFileSave, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.Q && menuFileQuit.isEnabled() ) {
                    this.menuFileQuit_Click( menuFileQuit, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.Z && menuEditUndo.isEnabled() ) {
                    this.menuEditUndo_Click( menuEditUndo, null );
                    return;
                } else if ( e.Control && e.Shift && e.KeyCode == Keys.Z && menuEditRedo.isEnabled() ) {
                    this.menuEditRedo_Click( this.menuEditRedo, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.X && this.menuEditCut.isEnabled() ) {
                    this.menuEditCut_Click( this.menuEditCut, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.C && this.menuEditCopy.isEnabled() ) {
                    this.menuEditCopy_Click( this.menuEditCopy, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.V && this.menuEditPaste.isEnabled() ) {
                    this.menuEditPaste_Click( this.menuEditPaste, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.A && this.menuEditSelectAll.isEnabled() ) {
                    this.menuEditSelectAll_Click( this.menuEditSelectAll, null );
                    return;
                } else if ( e.Control && e.Shift && this.menuEditSelectAllEvents.isEnabled() ) {
                    this.menuEditSelectAllEvents_Click( this.menuEditSelectAllEvents, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.V && this.menuHiddenEditPaste.isEnabled() ) {
                    this.menuHiddenEditPaste_Click( this.menuHiddenEditPaste, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.W && this.menuHiddenEditFlipToolPointerPencil.isEnabled() ) {
                    this.menuHiddenEditFlipToolPointerPencil_Click( this.menuHiddenEditFlipToolPointerPencil, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.E && this.menuHiddenEditFlipToolPointerEraser.isEnabled() ) {
                    this.menuHiddenEditFlipToolPointerEraser_Click( this.menuHiddenEditFlipToolPointerEraser, null );
                    return;
                } else if ( e.Control && e.Alt && (e.KeyCode & Keys.PageDown) == Keys.PageDown && this.menuHiddenVisualForwardParameter.isEnabled() ) {
                    this.menuHiddenVisualForwardParameter_Click( this.menuHiddenVisualForwardParameter, null );
                    return;
                } else if ( e.Control && e.Alt && (e.KeyCode & Keys.PageUp) == Keys.PageUp && this.menuHiddenVisualBackwardParameter.isEnabled() ) {
                    this.menuHiddenVisualBackwardParameter_Click( this.menuHiddenVisualBackwardParameter, null );
                    return;
                } else if ( e.Control && (e.KeyCode & Keys.PageDown) == Keys.PageDown && this.menuHiddenTrackNext.isEnabled() ) {
                    this.menuHiddenTrackNext_Click( this.menuHiddenTrackNext, null );
                    return;
                } else if ( e.Control && (e.KeyCode & Keys.PageUp) == Keys.PageUp && this.menuHiddenTrackBack.isEnabled() ) {
                    this.menuHiddenTrackBack_Click( this.menuHiddenTrackBack, null );
                    return;
                }
                #endregion

                #region cMenuPiano
                if ( e.Control && e.KeyCode == Keys.Z && cMenuPianoUndo.isEnabled() ) {
                    this.cMenuPianoUndo_Click( this.cMenuPianoUndo, null );
                    return;
                } else if ( e.Control && e.Shift && e.KeyCode == Keys.Z && this.cMenuPianoRedo.isEnabled() ) {
                    this.cMenuPianoRedo_Click( this.cMenuPianoRedo, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.X && this.cMenuPianoCut.isEnabled() ) {
                    this.cMenuPianoCut_Click( this.cMenuPianoCut, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.C && this.cMenuPianoCopy.isEnabled() ) {
                    this.cMenuPianoCopy_Click( this.cMenuPianoCopy, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.A && cMenuPianoSelectAll.isEnabled() ) {
                    this.cMenuPianoSelectAll_Click( this.cMenuPianoSelectAll, null );
                    return;
                } else if ( e.Control && e.Shift && e.KeyCode == Keys.A && cMenuPianoSelectAllEvents.isEnabled() ) {
                    this.cMenuPianoSelectAllEvents_Click( this.cMenuPianoSelectAllEvents, null );
                    return;
                }
                #endregion

                #region cMenuTrackSelector
                if ( e.Control && e.KeyCode == Keys.Z && cMenuTrackSelectorUndo.isEnabled() ) {
                    this.cMenuTrackSelectorUndo_Click( this.cMenuTrackSelectorUndo, null );
                    return;
                } else if ( e.Control && e.Shift && e.KeyCode == Keys.Z && this.cMenuTrackSelectorRedo.isEnabled() ) {
                    this.cMenuTrackSelectorRedo_Click( this.cMenuTrackSelectorRedo, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.X && this.cMenuTrackSelectorCut.isEnabled() ) {
                    this.cMenuTrackSelectorCut_Click( this.cMenuTrackSelectorCut, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.C && this.cMenuTrackSelectorCopy.isEnabled() ) {
                    this.cMenuTrackSelectorCopy_Click( this.cMenuTrackSelectorCopy, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.V && this.cMenuTrackSelectorPaste.isEnabled() ) {
                    this.cMenuTrackSelectorPaste_Click( this.cMenuTrackSelectorPaste, null );
                    return;
                } else if ( e.Control && e.Shift && e.KeyCode == Keys.A && this.cMenuTrackSelectorSelectAll.isEnabled() ) {
                    this.cMenuTrackSelectorSelectAll_Click( this.cMenuTrackSelectorSelectAll, null );
                    return;
                }
                #endregion
            }*/
            #endregion
        }

        public void setHScrollRange( int draft_length ) {
#if JAVA
            draft_length += 240;
            // 画面上で何クロックが見えてるか？
            int visible_clocks = (int)((pictPianoRoll.getWidth() - AppManager.keyWidth) * AppManager.getScaleXInv());
            if( draft_length + visible_clocks > hScroll.getMaximum() ){
                hScroll.setMaximum( draft_length + visible_clocks );
            }
            hScroll.setVisibleAmount( visible_clocks );
            /*int unit_increment = visible_clocks / 10;
            if( unit_increment <= 0 ){
                unit_increment = 1;
            }
            hScroll.setUnitIncrement( unit_increment );
            hScroll.setBlockIncrement( visible_clocks );*/
#else
            int _ARROWS = 40; // 両端の矢印の表示幅px（おおよその値）
            draft_length += 240;
            if ( draft_length > hScroll.getMaximum() ) {
                hScroll.setMaximum( draft_length );
            }
            if ( pictPianoRoll.getWidth() <= AppManager.keyWidth || hScroll.getWidth() <= _ARROWS ) {
                return;
            }
            int large_change = (int)((pictPianoRoll.getWidth() - AppManager.keyWidth) * AppManager.getScaleXInv());
            int box_width = (int)((hScroll.getWidth() - _ARROWS) * (float)large_change / (float)(hScroll.getMaximum() + large_change));
            if ( box_width < AppManager.editorConfig.MinimumScrollHandleWidth ) {
                box_width = AppManager.editorConfig.MinimumScrollHandleWidth;
                large_change = (int)((float)hScroll.getMaximum() * (float)box_width / (float)(hScroll.getWidth() - _ARROWS - box_width));
            }
            if ( large_change > 0 ) {
                hScroll.setVisibleAmount( large_change );
            }
#endif
        }

        public void setVScrollRange( int draft_length ) {
#if JAVA
            // 画面上で何ピクセルが見えてるか？
            int visible_amount = (int)pictPianoRoll.getHeight();
            if( draft_length + visible_amount > vScroll.getMaximum() ){
                vScroll.setMaximum( draft_length );
            }
            vScroll.setVisibleAmount( visible_amount );
            /*int unit_increment = visible_amount / 10;
            if( unit_increment <= 0 ){
                unit_increment = 1;
            }
            vScroll.setUnitIncrement( unit_increment );
            vScroll.setBlockIncrement( visible_amount );*/
#else
            int _ARROWS = 40; // 両端の矢印の表示幅px（おおよその値）
            if ( draft_length > vScroll.getMaximum() ) {
                vScroll.setMaximum( draft_length );
            }
            int large_change = (int)pictPianoRoll.getHeight();
            int box_width = (int)((vScroll.getHeight() - _ARROWS) * (float)large_change / (float)(vScroll.getMaximum() + large_change));
            if ( box_width < AppManager.editorConfig.MinimumScrollHandleWidth ) {
                box_width = AppManager.editorConfig.MinimumScrollHandleWidth;
                large_change = (int)((float)vScroll.getMaximum() * (float)box_width / (float)(vScroll.getWidth() - _ARROWS - box_width));
            }
            if ( large_change > 0 ) {
                vScroll.setVisibleAmount( large_change );
            }
#endif
        }

        public void refreshScreen() {
#if JAVA
            //refreshScreenCore( this, null );
            this.repaint();
            //trackSelector.repaint();
#else
            if ( !bgWorkScreen.IsBusy ) {
                double now = PortUtil.getCurrentTime();
                double dt = now - _last_screen_refreshed_sec;
                double mindt = 1.0 / AppManager.editorConfig.MaximumFrameRate;
                if ( dt > mindt ) {
                    _last_screen_refreshed_sec = now;
                    bgWorkScreen.RunWorkerAsync();
                }
            }
#endif
        }

        public void flipMixerDialogVisible( boolean visible ) {
            AppManager.mixerWindow.setVisible( visible );
            AppManager.editorConfig.MixerVisible = visible;
            menuVisualMixer.setSelected( visible );
        }

        /// <summary>
        /// メニューのショートカットキーを、AppManager.EditorConfig.ShorcutKeysの内容に応じて変更します
        /// </summary>
        public void applyShortcut() {
            specialShortcutHolders.clear();

            if ( AppManager.editorConfig.Platform == PlatformEnum.Macintosh ) {
                #region Platform.Macintosh
                String _CO = "";
                //if ( AppManager.EditorConfig.CommandKeyAsControl ) {
#if JAVA
                char[] arr = new char[]{ 0x2318 };
                _CO = new String( arr );
#else
                _CO = new String( '\x2318', 1 );
#endif
                //} else {
                //_CO = "^";
                //}
                String _SHIFT = "⇧";
                //if ( AppManager.EditorConfig.CommandKeyAsControl ) {
                #region menuStripMain
                menuFileNew.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_N, InputEvent.META_MASK ) );
                menuFileOpen.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_O, InputEvent.META_MASK ) );
                menuFileSave.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_S, InputEvent.META_MASK ) );
                menuFileQuit.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_Q, InputEvent.META_MASK ) );

                menuEditUndo.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_Z, InputEvent.META_MASK ) );
                menuEditRedo.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_Z, InputEvent.META_MASK | InputEvent.SHIFT_MASK ) );
                menuEditCut.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_X, InputEvent.META_MASK ) );
                menuEditCopy.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_C, InputEvent.META_MASK ) );
                menuEditPaste.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_V, InputEvent.META_MASK ) );
                menuEditSelectAll.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_A, InputEvent.META_MASK ) );
                menuEditSelectAllEvents.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_A, InputEvent.META_MASK | InputEvent.SHIFT_MASK ) );

                menuHiddenEditFlipToolPointerPencil.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_W, InputEvent.META_MASK ) );
                menuHiddenEditFlipToolPointerEraser.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_E, InputEvent.META_MASK ) );
                menuHiddenVisualForwardParameter.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_RIGHT, 0 ) );
                menuHiddenVisualBackwardParameter.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_LEFT, 0 ) );
                menuHiddenTrackNext.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_PAGE_DOWN, 0 ) );
                menuHiddenTrackBack.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_PAGE_UP, 0 ) );
                #endregion

                #region cMenuPiano
                cMenuPianoUndo.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_Z, InputEvent.META_MASK ) );
                cMenuPianoRedo.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_Z, InputEvent.META_MASK | InputEvent.SHIFT_MASK ) );
                cMenuPianoCut.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_X, InputEvent.META_MASK ) );
                cMenuPianoCopy.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_C, InputEvent.META_MASK ) );
                cMenuPianoSelectAll.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_A, InputEvent.META_MASK ) );
                cMenuPianoSelectAllEvents.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_A, InputEvent.META_MASK | InputEvent.SHIFT_MASK ) );
                #endregion

                #region cMenuTrackSelector
                cMenuTrackSelectorUndo.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_Z, InputEvent.META_MASK ) );
                cMenuTrackSelectorRedo.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_Z, InputEvent.META_MASK | InputEvent.SHIFT_MASK ) );
                cMenuTrackSelectorCut.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_X, InputEvent.META_MASK ) );
                cMenuTrackSelectorCopy.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_C, InputEvent.META_MASK ) );
                cMenuTrackSelectorPaste.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_V, InputEvent.META_MASK ) );
                cMenuTrackSelectorSelectAll.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_A, InputEvent.META_MASK | InputEvent.SHIFT_MASK ) );
                #endregion
                #endregion
            } else {
                TreeMap<String, BKeys[]> dict = AppManager.editorConfig.getShortcutKeysDictionary();
                #region menuStripMain
                for ( Iterator<String> itr = dict.keySet().iterator(); itr.hasNext(); ) {
                    String key = itr.next();
                    if ( key.Equals( "menuEditCopy" ) || key.Equals( "menuEditCut" ) || key.Equals( "menuEditPaste" ) || key.Equals( "SpecialShortcutGoToFirst" ) ) {
                        continue;
                    }
                    Object menu = searchMenuItemFromName( key );
                    if ( menu != null ) {
                        String menu_name = "";
#if JAVA
                        if( menu instanceof Component ){
                            menu_name = ((Component)menu).getName();
                        }else{
                            continue;
                        }
#else
                        if ( menu is BMenuItem ) {
                            menu_name = ((BMenuItem)menu).Name;
                        } else {
                            continue;
                        }
#endif
                        applyMenuItemShortcut( dict, menu, menu_name );
                    }
                }
                if ( dict.containsKey( "menuEditCopy" ) ) {
                    applyMenuItemShortcut( dict, menuHiddenCopy, "menuEditCopy" );
                }
                if ( dict.containsKey( "menuEditCut" ) ) {
                    applyMenuItemShortcut( dict, menuHiddenCut, "menuEditCut" );
                }
                if ( dict.containsKey( "menuEditCopy" ) ) {
                    applyMenuItemShortcut( dict, menuHiddenPaste, "menuEditPaste" );
                }
                #endregion

                Vector<ValuePair<String, BMenuItem[]>> work = new Vector<ValuePair<String, BMenuItem[]>>();
                work.add( new ValuePair<String, BMenuItem[]>( "menuEditUndo", new BMenuItem[] { cMenuPianoUndo, cMenuTrackSelectorUndo } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuEditRedo", new BMenuItem[] { cMenuPianoRedo, cMenuTrackSelectorRedo } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuEditCut", new BMenuItem[] { cMenuPianoCut, cMenuTrackSelectorCut, menuEditCut } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuEditCopy", new BMenuItem[] { cMenuPianoCopy, cMenuTrackSelectorCopy, menuEditCopy } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuEditPaste", new BMenuItem[] { cMenuPianoPaste, cMenuTrackSelectorPaste, menuEditPaste } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuEditSelectAll", new BMenuItem[] { cMenuPianoSelectAll, cMenuTrackSelectorSelectAll } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuEditSelectAllEvents", new BMenuItem[] { cMenuPianoSelectAllEvents } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuEditDelete", new BMenuItem[] { menuEditDelete } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuVisualGridline", new BMenuItem[] { cMenuPianoGrid } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuJobLyric", new BMenuItem[] { cMenuPianoImportLyric } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuLyricExpressionProperty", new BMenuItem[] { cMenuPianoExpressionProperty } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuLyricVibratoProperty", new BMenuItem[] { cMenuPianoVibratoProperty } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuTrackOn", new BMenuItem[] { cMenuTrackTabTrackOn } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuTrackAdd", new BMenuItem[] { cMenuTrackTabAdd } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuTrackCopy", new BMenuItem[] { cMenuTrackTabCopy } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuTrackDelete", new BMenuItem[] { cMenuTrackTabDelete } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuTrackRenderCurrent", new BMenuItem[] { cMenuTrackTabRenderCurrent } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuTrackRenderAll", new BMenuItem[] { cMenuTrackTabRenderAll } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuTrackOverlay", new BMenuItem[] { cMenuTrackTabOverlay } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuTrackRendererVOCALOID1", new BMenuItem[] { cMenuTrackTabRendererVOCALOID100 } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuTrackRendererVOCALOID2", new BMenuItem[] { cMenuTrackTabRendererVOCALOID2 } ) );
                work.add( new ValuePair<String, BMenuItem[]>( "menuTrackRendererUtau", new BMenuItem[] { cMenuTrackTabRendererUtau } ) );
                int c = work.size();
                for ( int j = 0; j < c; j++ ) {
                    ValuePair<String, BMenuItem[]> item = work.get( j );
                    if ( dict.containsKey( item.getKey() ) ) {
                        BKeys[] k = dict.get( item.getKey() );
                        String s = Utility.getShortcutDisplayString( k );
#if !JAVA
                        if ( s != "" ) {
                            for ( int i = 0; i < item.getValue().Length; i++ ) {
                                item.getValue()[i].ShortcutKeyDisplayString = s;
                            }
                        }
#endif
                    }
                }

                // ミキサーウィンドウ
                if ( AppManager.mixerWindow != null ) {
                    if ( dict.containsKey( "menuVisualMixer" ) ) {
                        KeyStroke shortcut = BKeysUtility.getKeyStrokeFromBKeys( dict.get( "menuVisualMixer" ) );
                        AppManager.mixerWindow.applyShortcut( shortcut );
                    }
                }

                // アイコンパレット
                if ( AppManager.iconPalette != null ) {
                    if ( dict.containsKey( "menuVisualIconPalette" ) ) {
                        KeyStroke shortcut = BKeysUtility.getKeyStrokeFromBKeys( dict.get( "menuVisualIconPalette" ) );
                        AppManager.iconPalette.applyShortcut( shortcut );
                    }
                }

                // スクリプトにショートカットを適用
#if JAVA
                MenuElement[] sub_menu_script = menuScript.getSubElements();
                for ( int i = 0; i < sub_menu_script.Length; i++ ) {
                    MenuElement tsi = sub_menu_script[i];
                    MenuElement[] sub_tsi = tsi.getSubElements();
                    if ( sub_tsi.Length == 1 ) {
                        MenuElement dd_run = sub_tsi[0];
#if DEBUG
                        AppManager.debugWriteLine( "    dd_run.name=" + PortUtil.getComponentName( dd_run ) );
#endif
                        if ( dict.containsKey( PortUtil.getComponentName( dd_run ) ) ) {
                            applyMenuItemShortcut( dict, tsi, PortUtil.getComponentName( tsi ) );
                        }
                    }
                }
#else
                int count = menuScript.DropDownItems.Count;
                for ( int i = 0; i < count; i++ ) {
                    System.Windows.Forms.ToolStripItem tsi = menuScript.DropDownItems[i];
                    if ( tsi is System.Windows.Forms.ToolStripMenuItem ) {
                        System.Windows.Forms.ToolStripMenuItem tsmi = (System.Windows.Forms.ToolStripMenuItem)tsi;
                        if ( tsmi.DropDownItems.Count == 1 ) {
                            System.Windows.Forms.ToolStripItem subtsi_tsmi = tsmi.DropDownItems[0];
                            if ( subtsi_tsmi is System.Windows.Forms.ToolStripMenuItem ) {
                                System.Windows.Forms.ToolStripMenuItem dd_run = (System.Windows.Forms.ToolStripMenuItem)subtsi_tsmi;
                                if ( dict.containsKey( PortUtil.getComponentName( dd_run ) ) ) {
                                    applyMenuItemShortcut( dict, tsmi, PortUtil.getComponentName( tsi ) );
                                }
                            }
                        }
                    }
                }
#endif
            }
        }

        /// <summary>
        /// dictの中から
        /// </summary>
        /// <param name="dict"></param>
        /// <param name="item"></param>
        /// <param name="item_name"></param>
        /// <param name="default_shortcut"></param>
        public void applyMenuItemShortcut( TreeMap<String, BKeys[]> dict, Object item, String item_name ) {
            try {
                if ( dict.containsKey( item_name ) ) {
#if JAVA
                    if( item instanceof JMenuItem ){
                        ((JMenuItem)item).setAccelerator( BKeysUtility.getKeyStrokeFromBKeys( dict.get( item_name ) ) );
                    }
#else
#if DEBUG
                    if ( !(item is BMenuItem) ) {
                        throw new Exception( "FormMain#applyMenuItemShortcut; item is NOT BMenuItem" );
                    }
#endif
                    if ( item is BMenuItem ) {
                        BMenuItem menu = (BMenuItem)item;
                        BKeys[] keys = dict.get( item_name );
                        System.Windows.Forms.Keys shortcut = BKeysUtility.getKeyStrokeFromBKeys( keys ).keys;

                        if ( shortcut == System.Windows.Forms.Keys.Delete ) {
                            menu.ShortcutKeyDisplayString = "Delete";
                            menu.ShortcutKeys = System.Windows.Forms.Keys.None;
                            specialShortcutHolders.add(
                                new SpecialShortcutHolder( BKeysUtility.getKeyStrokeFromBKeys( keys ), menu ) );
                        } else {
                            try {
                                menu.ShortcutKeyDisplayString = "";
                                menu.ShortcutKeys = shortcut;
                            } catch ( Exception ex ) {
                                // ショートカットの適用に失敗する→特殊な取り扱いが必要
                                menu.ShortcutKeyDisplayString = Utility.getShortcutDisplayString( keys );
                                menu.ShortcutKeys = System.Windows.Forms.Keys.None;
                                specialShortcutHolders.add(
                                    new SpecialShortcutHolder( BKeysUtility.getKeyStrokeFromBKeys( keys ), menu ) );
#if DEBUG
                                PortUtil.println( "FormMain#applyMenuItemShortcut; display_string=" + menu.ShortcutKeyDisplayString + "; menu.getName()=" + menu.getName() );
#endif
                            }
                        }
                    }
#endif
                } else {
#if JAVA
                    if( item instanceof JMenuItem ){
                        ((JMenuItem)item).setAccelerator( KeyStroke.getKeyStroke( 0, 0 ) );
                    }
#else
                    if ( item is BMenuItem ) {
                        ((BMenuItem)item).setAccelerator( BKeysUtility.getKeyStrokeFromBKeys( new BKeys[] { BKeys.None } ) );
                    }
#endif
                }
            } catch ( Exception ex ) {
            }
        }

        /// <summary>
        /// ソングポジションを1小節進めます
        /// </summary>
        public void forward() {
            boolean playing = AppManager.isPlaying();
            if ( playing ) {
                return;
            }
            int current = AppManager.getVsqFile().getBarCountFromClock( AppManager.getCurrentClock() ) + 1;
            int new_clock = AppManager.getVsqFile().getClockFromBarCount( current );
            if ( new_clock <= hScroll.getMaximum() + (pictPianoRoll.getWidth() - AppManager.keyWidth) * AppManager.getScaleXInv() ) {
                AppManager.setCurrentClock( new_clock );
                ensureCursorVisible();
                AppManager.setPlaying( playing );
                refreshScreen();
            }
        }

        /// <summary>
        /// ソングポジションを1小節戻します
        /// </summary>
        public void rewind() {
            boolean playing = AppManager.isPlaying();
            if ( playing ) {
                return;
            }
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }
            int cl_clock = AppManager.getCurrentClock();
            int b_current = vsq.getBarCountFromClock( cl_clock );
            if ( b_current > 0 ) {
                int cl_b_current = vsq.getClockFromBarCount( b_current );
                if ( cl_b_current >= cl_clock ) {
                    b_current--;
                }
            }
            int cl_new = vsq.getClockFromBarCount( b_current );
            AppManager.setCurrentClock( cl_new );
            ensureCursorVisible();
            AppManager.setPlaying( playing );
            refreshScreen();
        }

        /// <summary>
        /// cMenuPianoの固定長音符入力の各メニューのチェック状態をm_pencil_modeを元に更新します
        /// </summary>
        public void updateCMenuPianoFixed() {
            cMenuPianoFixed01.setSelected( false );
            cMenuPianoFixed02.setSelected( false );
            cMenuPianoFixed04.setSelected( false );
            cMenuPianoFixed08.setSelected( false );
            cMenuPianoFixed16.setSelected( false );
            cMenuPianoFixed32.setSelected( false );
            cMenuPianoFixed64.setSelected( false );
            cMenuPianoFixed128.setSelected( false );
            cMenuPianoFixedOff.setSelected( false );
            cMenuPianoFixedTriplet.setSelected( false );
            cMenuPianoFixedDotted.setSelected( false );
            PencilModeEnum mode = m_pencil_mode.getMode();
            if ( mode == PencilModeEnum.L1 ) {
                cMenuPianoFixed01.setSelected( true );
            } else if ( mode == PencilModeEnum.L2 ) {
                cMenuPianoFixed02.setSelected( true );
            } else if ( mode == PencilModeEnum.L4 ) {
                cMenuPianoFixed04.setSelected( true );
            } else if ( mode == PencilModeEnum.L8 ) {
                cMenuPianoFixed08.setSelected( true );
            } else if ( mode == PencilModeEnum.L16 ) {
                cMenuPianoFixed16.setSelected( true );
            } else if ( mode == PencilModeEnum.L32 ) {
                cMenuPianoFixed32.setSelected( true );
            } else if ( mode == PencilModeEnum.L64 ) {
                cMenuPianoFixed64.setSelected( true );
            } else if ( mode == PencilModeEnum.L128 ) {
                cMenuPianoFixed128.setSelected( true );
            } else if ( mode == PencilModeEnum.Off ) {
                cMenuPianoFixedOff.setSelected( true );
            }
            cMenuPianoFixedTriplet.setSelected( m_pencil_mode.isTriplet() );
            cMenuPianoFixedDotted.setSelected( m_pencil_mode.isDot() );
        }

        public void clearTempWave() {
            String tmppath = PortUtil.combinePath( AppManager.getCadenciiTempDir(), AppManager.getID() );
            if ( !PortUtil.isDirectoryExists( tmppath ) ) {
                return;
            }

            // 今回このPCが起動されるよりも以前に，Cadenciiが残したデータを削除する
            //TODO: システムカウンタは約49日でリセットされてしまい，厳密には実装できないようなので，保留．

            // このFormMainのインスタンスが使用したデータを消去する
            for ( int i = 1; i <= 16; i++ ) {
                String file = PortUtil.combinePath( tmppath, i + ".wav" );
                if ( PortUtil.isFileExists( file ) ) {
                    for ( int error = 0; error < 100; error++ ) {
                        try {
                            PortUtil.deleteFile( file );
                            break;
                        } catch ( Exception ex ) {
#if !JAVA
#if DEBUG
                            org.kbinani.debug.push_log( "FormMain+ClearTempWave()" );
                            org.kbinani.debug.push_log( "    ex=" + ex.ToString() );
                            org.kbinani.debug.push_log( "    error_count=" + error );
#endif
#endif

#if JAVA
                            try{
                                Thread.sleep( 100 );
                            }catch( Exception ex2 ){
                            }
#else
                            Thread.Sleep( 100 );
#endif
                        }
                    }
                }
            }
            String whd = PortUtil.combinePath( tmppath, UtauRenderingRunner.FILEBASE + ".whd" );
            if ( PortUtil.isFileExists( whd ) ) {
                try {
                    PortUtil.deleteFile( whd );
                } catch ( Exception ex ) {
                }
            }
            String dat = PortUtil.combinePath( tmppath, UtauRenderingRunner.FILEBASE + ".dat" );
            if ( PortUtil.isFileExists( dat ) ) {
                try {
                    PortUtil.deleteFile( dat );
                } catch ( Exception ex ) {
                }
            }
        }

        public void playPreviewSound( int note ) {
            KeySoundPlayer.play( note );
        }

#if ENABLE_MOUSEHOVER
        public void MouseHoverEventGenerator( Object arg ) {
            int note = (int)arg;
            if ( AppManager.editorConfig.MouseHoverTime > 0 ) {
                Thread.Sleep( AppManager.editorConfig.MouseHoverTime );
            }
            KeySoundPlayer.play( note );
        }
#endif

        public static String _( String id ) {
            return Messaging.getMessage( id );
        }

        public void applyLanguage() {
            openXmlVsqDialog.clearChoosableFileFilter();
            try {
                openXmlVsqDialog.addFileFilter( _( "XML-VSQ Format(*.xvsq)|*.xvsq" ) );
                openXmlVsqDialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
            } catch ( Exception ex ) {
                openXmlVsqDialog.addFileFilter( "XML-VSQ Format(*.xvsq)|*.xvsq" );
                openXmlVsqDialog.addFileFilter( "All Files(*.*)|*.*" );
            }

            saveXmlVsqDialog.clearChoosableFileFilter();
            try {
                saveXmlVsqDialog.addFileFilter( _( "XML-VSQ Format(*.xvsq)|*.xvsq" ) );
                saveXmlVsqDialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
            } catch ( Exception ex ) {
                saveXmlVsqDialog.addFileFilter( "XML-VSQ Format(*.xvsq)|*.xvsq" );
                saveXmlVsqDialog.addFileFilter( "All Files(*.*)|*.*" );
            }

            openUstDialog.clearChoosableFileFilter();
            try {
                openUstDialog.addFileFilter( _( "UTAU Script Format(*.ust)|*.ust" ) );
                openUstDialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
            } catch ( Exception ex ) {
                openUstDialog.addFileFilter( "UTAU Script Format(*.ust)|*.ust" );
                openUstDialog.addFileFilter( "All Files(*.*)|*.*" );
            }

            openMidiDialog.clearChoosableFileFilter();
            try {
                openMidiDialog.addFileFilter( _( "MIDI Format(*.mid)|*.mid" ) );
                openMidiDialog.addFileFilter( _( "VSQ Format(*.vsq)|*.vsq" ) );
                openMidiDialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
            } catch ( Exception ex ) {
                openMidiDialog.addFileFilter( "MIDI Format(*.mid)|*.mid" );
                openMidiDialog.addFileFilter( "VSQ Format(*.vsq)|*.vsq" );
                openMidiDialog.addFileFilter( "All Files(*.*)|*.*" );
            }

            saveMidiDialog.clearChoosableFileFilter();
            try {
                saveMidiDialog.addFileFilter( _( "MIDI Format(*.mid)|*.mid" ) );
                saveMidiDialog.addFileFilter( _( "VSQ Format(*.vsq)|*.vsq" ) );
                saveMidiDialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
            } catch ( Exception ex ) {
                saveMidiDialog.addFileFilter( "MIDI Format(*.mid)|*.mid" );
                saveMidiDialog.addFileFilter( "VSQ Format(*.vsq)|*.vsq" );
                saveMidiDialog.addFileFilter( "All Files(*.*)|*.*" );
            }

            openWaveDialog.clearChoosableFileFilter();
            try {
                openWaveDialog.addFileFilter( _( "Wave File(*.wav)|*.wav" ) );
                openWaveDialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
            } catch ( Exception ex ) {
                openWaveDialog.addFileFilter( "Wave File(*.wav)|*.wav" );
                openWaveDialog.addFileFilter( "All Files(*.*)|*.*" );
            }

            stripLblGameCtrlMode.setToolTipText( _( "Game Controler" ) );
#if JAVA
            updateGameControlerStatus( this, new EventArgs() );
#else
            this.Invoke( new EventHandler( updateGameControlerStatus ) );
#endif

            stripBtnPointer.setText( _( "Pointer" ) );
            stripBtnPointer.setToolTipText( _( "Pointer" ) );
            stripBtnPencil.setText( _( "Pencil" ) );
            stripBtnPencil.setToolTipText( _( "Pencil" ) );
            stripBtnLine.setText( _( "Line" ) );
            stripBtnLine.setToolTipText( _( "Line" ) );
            stripBtnEraser.setText( _( "Eraser" ) );
            stripBtnEraser.setToolTipText( _( "Eraser" ) );
            stripBtnCurve.setText( _( "Curve" ) );
            stripBtnCurve.setToolTipText( _( "Curve" ) );
            stripBtnGrid.setText( _( "Grid" ) );
            stripBtnGrid.setToolTipText( _( "Grid" ) );

            #region main menu
            menuFile.setText( _( "File" ) );
            menuFile.setMnemonic( KeyEvent.VK_F );
            menuFileNew.setText( _( "New" ) );
            menuFileNew.setMnemonic( KeyEvent.VK_N );
            menuFileOpen.setText( _( "Open" ) );
            menuFileOpen.setMnemonic( KeyEvent.VK_O );
            menuFileOpenVsq.setText( _( "Open VSQ/Vocaloid Midi" ) );
            menuFileOpenVsq.setMnemonic( KeyEvent.VK_V );
            menuFileOpenUst.setText( _( "Open UTAU Project File" ) );
            menuFileOpenUst.setMnemonic( KeyEvent.VK_U );
            menuFileSave.setText( _( "Save" ) );
            menuFileSave.setMnemonic( KeyEvent.VK_S );
            menuFileSaveNamed.setText( _( "Save As" ) );
            menuFileSaveNamed.setMnemonic( KeyEvent.VK_A );
            menuFileImport.setText( _( "Import" ) );
            menuFileImport.setMnemonic( KeyEvent.VK_I );
            menuFileImportVsq.setText( _( "VSQ / Vocaloid Midi" ) );
            menuFileExport.setText( _( "Export" ) );
            menuFileExport.setMnemonic( KeyEvent.VK_E );
            menuFileRecent.setText( _( "Recent Files" ) );
            menuFileRecent.setMnemonic( KeyEvent.VK_R );
            menuFileQuit.setText( _( "Quit" ) );
            menuFileQuit.setMnemonic( KeyEvent.VK_Q );

            menuEdit.setText( _( "Edit" ) );
            menuEdit.setMnemonic( KeyEvent.VK_E );
            menuEditUndo.setText( _( "Undo" ) );
            menuEditUndo.setMnemonic( KeyEvent.VK_U );
            menuEditRedo.setText( _( "Redo" ) );
            menuEditRedo.setMnemonic( KeyEvent.VK_R );
            menuEditCut.setText( _( "Cut" ) );
            menuEditCut.setMnemonic( KeyEvent.VK_T );
            menuEditCopy.setText( _( "Copy" ) );
            menuEditCopy.setMnemonic( KeyEvent.VK_C );
            menuEditPaste.setText( _( "Paste" ) );
            menuEditPaste.setMnemonic( KeyEvent.VK_P );
            menuEditDelete.setText( _( "Delete" ) );
            menuEditDelete.setMnemonic( KeyEvent.VK_D );
            menuEditAutoNormalizeMode.setText( _( "Auto Normalize Mode" ) );
            menuEditAutoNormalizeMode.setMnemonic( KeyEvent.VK_N );
            menuEditSelectAll.setText( _( "Select All" ) );
            menuEditSelectAll.setMnemonic( KeyEvent.VK_A );
            menuEditSelectAllEvents.setText( _( "Select All Events" ) );
            menuEditSelectAllEvents.setMnemonic( KeyEvent.VK_E );

            menuVisual.setText( _( "View" ) );
            menuVisual.setMnemonic( KeyEvent.VK_V );
            menuVisualControlTrack.setText( _( "Control Track" ) );
            menuVisualControlTrack.setMnemonic( KeyEvent.VK_C );
            menuVisualMixer.setText( _( "Mixer" ) );
            menuVisualMixer.setMnemonic( KeyEvent.VK_X );
            menuVisualWaveform.setText( _( "Waveform" ) );
            menuVisualWaveform.setMnemonic( KeyEvent.VK_W );
            menuVisualProperty.setText( _( "Property Window" ) );
            menuVisualOverview.setText( _( "Navigation" ) );
            menuVisualOverview.setMnemonic( KeyEvent.VK_V );
            menuVisualGridline.setText( _( "Grid Line" ) );
            menuVisualGridline.setMnemonic( KeyEvent.VK_G );
            menuVisualStartMarker.setText( _( "Start Marker" ) );
            menuVisualStartMarker.setMnemonic( KeyEvent.VK_S );
            menuVisualEndMarker.setText( _( "End Marker" ) );
            menuVisualEndMarker.setMnemonic( KeyEvent.VK_E );
            menuVisualLyrics.setText( _( "Lyrics/Phoneme" ) );
            menuVisualLyrics.setMnemonic( KeyEvent.VK_L );
            menuVisualNoteProperty.setText( _( "Note Expression/Vibrato" ) );
            menuVisualNoteProperty.setMnemonic( KeyEvent.VK_N );
            menuVisualPitchLine.setText( _( "Pitch Line" ) );
            menuVisualPitchLine.setMnemonic( KeyEvent.VK_P );
            menuVisualPluginUi.setText( _( "VSTi Plugin UI" ) );
            menuVisualPluginUi.setMnemonic( KeyEvent.VK_U );
            menuVisualIconPalette.setText( _( "Icon Palette" ) );
            menuVisualIconPalette.setMnemonic( KeyEvent.VK_I );

            menuJob.setText( _( "Job" ) );
            menuJob.setMnemonic( KeyEvent.VK_J );
            menuJobNormalize.setText( _( "Normalize Notes" ) );
            menuJobNormalize.setMnemonic( KeyEvent.VK_N );
            menuJobInsertBar.setText( _( "Insert Bars" ) );
            menuJobInsertBar.setMnemonic( KeyEvent.VK_I );
            menuJobDeleteBar.setText( _( "Delete Bars" ) );
            menuJobDeleteBar.setMnemonic( KeyEvent.VK_D );
            menuJobRandomize.setText( _( "Randomize" ) );
            menuJobRandomize.setMnemonic( KeyEvent.VK_R );
            menuJobConnect.setText( _( "Connect Notes" ) );
            menuJobConnect.setMnemonic( KeyEvent.VK_C );
            menuJobLyric.setText( _( "Insert Lyrics" ) );
            menuJobLyric.setMnemonic( KeyEvent.VK_L );
            menuJobRewire.setText( _( "Import ReWire Host Tempo" ) );
            menuJobRewire.setMnemonic( KeyEvent.VK_T );
            menuJobRealTime.setText( _( "Start Realtime Input" ) );
            menuJobReloadVsti.setText( _( "Reload VSTi" ) );
            menuJobReloadVsti.setMnemonic( KeyEvent.VK_R );

            menuTrack.setText( _( "Track" ) );
            menuTrack.setMnemonic( KeyEvent.VK_T );
            menuTrackOn.setText( _( "Track On" ) );
            menuTrackOn.setMnemonic( KeyEvent.VK_K );
            menuTrackPlayAfterSynth.setText( _( "Play After Synth" ) );
            menuTrackPlayAfterSynth.setMnemonic( KeyEvent.VK_P );
            menuTrackAdd.setText( _( "Add Track" ) );
            menuTrackAdd.setMnemonic( KeyEvent.VK_A );
            menuTrackCopy.setText( _( "Copy Track" ) );
            menuTrackCopy.setMnemonic( KeyEvent.VK_C );
            menuTrackChangeName.setText( _( "Rename Track" ) );
            menuTrackDelete.setText( _( "Delete Track" ) );
            menuTrackDelete.setMnemonic( KeyEvent.VK_D );
            menuTrackRenderCurrent.setText( _( "Render Current Track" ) );
            menuTrackRenderCurrent.setMnemonic( KeyEvent.VK_T );
            menuTrackRenderAll.setText( _( "Render All Tracks" ) );
            menuTrackRenderAll.setMnemonic( KeyEvent.VK_S );
            menuTrackOverlay.setText( _( "Overlay" ) );
            menuTrackOverlay.setMnemonic( KeyEvent.VK_O );
            menuTrackRenderer.setText( _( "Renderer" ) );
            menuTrackRenderer.setMnemonic( KeyEvent.VK_R );

            menuLyric.setText( _( "Lyrics" ) );
            menuLyric.setMnemonic( KeyEvent.VK_L );
            menuLyricExpressionProperty.setText( _( "Note Expression Property" ) );
            menuLyricExpressionProperty.setMnemonic( KeyEvent.VK_E );
            menuLyricVibratoProperty.setText( _( "Note Vibrato Property" ) );
            menuLyricVibratoProperty.setMnemonic( KeyEvent.VK_V );
            menuLyricPhonemeTransformation.setText( _( "Phoneme Transformation" ) );
            menuLyricPhonemeTransformation.setMnemonic( KeyEvent.VK_T );
            menuLyricDictionary.setText( _( "User Word Dictionary" ) );
            menuLyricDictionary.setMnemonic( KeyEvent.VK_C );

            menuScript.setText( _( "Script" ) );
            menuScript.setMnemonic( KeyEvent.VK_C );
            menuScriptUpdate.setText( _( "Update Script List" ) );
            menuScriptUpdate.setMnemonic( KeyEvent.VK_U );

            menuSetting.setText( _( "Setting" ) );
            menuSetting.setMnemonic( KeyEvent.VK_S );
            menuSettingPreference.setText( _( "Preference" ) );
            menuSettingPreference.setMnemonic( KeyEvent.VK_P );
            menuSettingGameControler.setText( _( "Game Controler" ) );
            menuSettingGameControler.setMnemonic( KeyEvent.VK_G );
            menuSettingGameControlerLoad.setText( _( "Load" ) );
            menuSettingGameControlerLoad.setMnemonic( KeyEvent.VK_L );
            menuSettingGameControlerRemove.setText( _( "Remove" ) );
            menuSettingGameControlerRemove.setMnemonic( KeyEvent.VK_R );
            menuSettingGameControlerSetting.setText( _( "Setting" ) );
            menuSettingGameControlerSetting.setMnemonic( KeyEvent.VK_S );
            menuSettingShortcut.setText( _( "Shortcut Key" ) );
            menuSettingShortcut.setMnemonic( KeyEvent.VK_S );
            menuSettingUtauVoiceDB.setText( _( "UTAU Voice DB" ) );
            menuSettingUtauVoiceDB.setMnemonic( KeyEvent.VK_U );
            menuSettingDefaultSingerStyle.setText( _( "Singing Style Defaults" ) );
            menuSettingDefaultSingerStyle.setMnemonic( KeyEvent.VK_D );
            menuSettingPositionQuantize.setText( _( "Quantize" ) );
            menuSettingPositionQuantize.setMnemonic( KeyEvent.VK_Q );
            menuSettingPositionQuantizeOff.setText( _( "Off" ) );
            menuSettingPositionQuantizeTriplet.setText( _( "Triplet" ) );
            menuSettingLengthQuantize.setText( _( "Length" ) );
            menuSettingLengthQuantize.setMnemonic( KeyEvent.VK_L );
            menuSettingLengthQuantizeOff.setText( _( "Off" ) );
            menuSettingLengthQuantizeTriplet.setText( _( "Triplet" ) );
            menuSettingSingerProperty.setText( _( "Singer Properties" ) );
            menuSettingSingerProperty.setMnemonic( KeyEvent.VK_S );
            menuSettingPaletteTool.setText( _( "Palette Tool" ) );
            menuSettingPaletteTool.setMnemonic( KeyEvent.VK_T );

            menuHelp.setText( _( "Help" ) );
            menuHelp.setMnemonic( KeyEvent.VK_H );
            menuHelpAbout.setText( _( "About Cadencii" ) );
            menuHelpAbout.setMnemonic( KeyEvent.VK_A );

            menuHiddenCopy.setText( _( "Copy" ) );
            menuHiddenCut.setText( _( "Cut" ) );
            menuHiddenEditFlipToolPointerEraser.setText( _( "Chagne Tool Pointer / Eraser" ) );
            menuHiddenEditFlipToolPointerPencil.setText( _( "Change Tool Pointer / Pencil" ) );
            menuHiddenEditLyric.setText( _( "Start Lyric Input" ) );
            menuHiddenGoToEndMarker.setText( _( "GoTo End Marker" ) );
            menuHiddenGoToStartMarker.setText( _( "GoTo Start Marker" ) );
            menuHiddenLengthen.setText( _( "Lengthen" ) );
            menuHiddenMoveDown.setText( _( "Move Down" ) );
            menuHiddenMoveLeft.setText( _( "Move Left" ) );
            menuHiddenMoveRight.setText( _( "Move Right" ) );
            menuHiddenMoveUp.setText( _( "Move Up" ) );
            menuHiddenPaste.setText( _( "Paste" ) );
            menuHiddenPlayFromStartMarker.setText( _( "Play From Start Marker" ) );
            menuHiddenSelectBackward.setText( _( "Select Backward" ) );
            menuHiddenSelectForward.setText( _( "Select Forward" ) );
            menuHiddenShorten.setText( _( "Shorten" ) );
            menuHiddenTrackBack.setText( _( "Previous Track" ) );
            menuHiddenTrackNext.setText( _( "Next Track" ) );
            menuHiddenVisualBackwardParameter.setText( _( "Previous Control Curve" ) );
            menuHiddenVisualForwardParameter.setText( _( "Next Control Curve" ) );
            #endregion

            #region cMenuPiano
            cMenuPianoPointer.setText( _( "Arrow" ) );
            cMenuPianoPointer.setMnemonic( KeyEvent.VK_A );
            cMenuPianoPencil.setText( _( "Pencil" ) );
            cMenuPianoPencil.setMnemonic( KeyEvent.VK_W );
            cMenuPianoEraser.setText( _( "Eraser" ) );
            cMenuPianoEraser.setMnemonic( KeyEvent.VK_E );
            cMenuPianoPaletteTool.setText( _( "Palette Tool" ) );

            cMenuPianoCurve.setText( _( "Curve" ) );
            cMenuPianoCurve.setMnemonic( KeyEvent.VK_V );

            cMenuPianoFixed.setText( _( "Note Fixed Length" ) );
            cMenuPianoFixed.setMnemonic( KeyEvent.VK_N );
            cMenuPianoFixedTriplet.setText( _( "Triplet" ) );
            cMenuPianoFixedOff.setText( _( "Off" ) );
            cMenuPianoFixedDotted.setText( _( "Dot" ) );
            cMenuPianoQuantize.setText( _( "Quantize" ) );
            cMenuPianoQuantize.setMnemonic( KeyEvent.VK_Q );
            cMenuPianoQuantizeTriplet.setText( _( "Triplet" ) );
            cMenuPianoQuantizeOff.setText( _( "Off" ) );
            cMenuPianoLength.setText( _( "Length" ) );
            cMenuPianoLength.setMnemonic( KeyEvent.VK_L );
            cMenuPianoLengthTriplet.setText( _( "Triplet" ) );
            cMenuPianoLengthOff.setText( _( "Off" ) );
            cMenuPianoGrid.setText( _( "Show/Hide Grid Line" ) );
            cMenuPianoGrid.setMnemonic( KeyEvent.VK_S );

            cMenuPianoUndo.setText( _( "Undo" ) );
            cMenuPianoUndo.setMnemonic( KeyEvent.VK_U );
            cMenuPianoRedo.setText( _( "Redo" ) );
            cMenuPianoRedo.setMnemonic( KeyEvent.VK_R );

            cMenuPianoCut.setText( _( "Cut" ) );
            cMenuPianoCut.setMnemonic( KeyEvent.VK_T );
            cMenuPianoPaste.setText( _( "Paste" ) );
            cMenuPianoPaste.setMnemonic( KeyEvent.VK_P );
            cMenuPianoCopy.setText( _( "Copy" ) );
            cMenuPianoCopy.setMnemonic( KeyEvent.VK_C );
            cMenuPianoDelete.setText( _( "Delete" ) );
            cMenuPianoDelete.setMnemonic( KeyEvent.VK_D );

            cMenuPianoSelectAll.setText( _( "Select All" ) );
            cMenuPianoSelectAll.setMnemonic( KeyEvent.VK_A );
            cMenuPianoSelectAllEvents.setText( _( "Select All Events" ) );
            cMenuPianoSelectAllEvents.setMnemonic( KeyEvent.VK_E );

            cMenuPianoExpressionProperty.setText( _( "Note Expression Property" ) );
            cMenuPianoExpressionProperty.setMnemonic( KeyEvent.VK_P );
            cMenuPianoVibratoProperty.setText( _( "Note Vibrato Property" ) );
            cMenuPianoImportLyric.setText( _( "Insert Lyrics" ) );
            cMenuPianoImportLyric.setMnemonic( KeyEvent.VK_P );
            #endregion

            #region cMenuTrackTab
            cMenuTrackTabTrackOn.setText( _( "Track On" ) );
            cMenuTrackTabTrackOn.setMnemonic( KeyEvent.VK_K );
            cMenuTrackTabPlayAfterSynth.setText( _( "Play After Synth" ) );
            cMenuTrackTabPlayAfterSynth.setMnemonic( KeyEvent.VK_P );
            cMenuTrackTabAdd.setText( _( "Add Track" ) );
            cMenuTrackTabAdd.setMnemonic( KeyEvent.VK_A );
            cMenuTrackTabCopy.setText( _( "Copy Track" ) );
            cMenuTrackTabCopy.setMnemonic( KeyEvent.VK_C );
            cMenuTrackTabChangeName.setText( _( "Rename Track" ) );
            cMenuTrackTabDelete.setText( _( "Delete Track" ) );
            cMenuTrackTabDelete.setMnemonic( KeyEvent.VK_D );

            cMenuTrackTabRenderCurrent.setText( _( "Render Current Track" ) );
            cMenuTrackTabRenderCurrent.setMnemonic( KeyEvent.VK_T );
            cMenuTrackTabRenderAll.setText( _( "Render All Tracks" ) );
            cMenuTrackTabRenderAll.setMnemonic( KeyEvent.VK_S );
            cMenuTrackTabOverlay.setText( _( "Overlay" ) );
            cMenuTrackTabOverlay.setMnemonic( KeyEvent.VK_O );
            cMenuTrackTabRenderer.setText( _( "Renderer" ) );
            cMenuTrackTabRenderer.setMnemonic( KeyEvent.VK_R );
            #endregion

            #region cMenuTrackSelector
            cMenuTrackSelectorPointer.setText( _( "Arrow" ) );
            cMenuTrackSelectorPointer.setMnemonic( KeyEvent.VK_A );
            cMenuTrackSelectorPencil.setText( _( "Pencil" ) );
            cMenuTrackSelectorPencil.setMnemonic( KeyEvent.VK_W );
            cMenuTrackSelectorLine.setText( _( "Line" ) );
            cMenuTrackSelectorLine.setMnemonic( KeyEvent.VK_L );
            cMenuTrackSelectorEraser.setText( _( "Eraser" ) );
            cMenuTrackSelectorEraser.setMnemonic( KeyEvent.VK_E );
            cMenuTrackSelectorPaletteTool.setText( _( "Palette Tool" ) );

            cMenuTrackSelectorCurve.setText( _( "Curve" ) );
            cMenuTrackSelectorCurve.setMnemonic( KeyEvent.VK_V );

            cMenuTrackSelectorUndo.setText( _( "Undo" ) );
            cMenuTrackSelectorUndo.setMnemonic( KeyEvent.VK_U );
            cMenuTrackSelectorRedo.setText( _( "Redo" ) );
            cMenuTrackSelectorRedo.setMnemonic( KeyEvent.VK_R );

            cMenuTrackSelectorCut.setText( _( "Cut" ) );
            cMenuTrackSelectorCut.setMnemonic( KeyEvent.VK_T );
            cMenuTrackSelectorCopy.setText( _( "Copy" ) );
            cMenuTrackSelectorCopy.setMnemonic( KeyEvent.VK_C );
            cMenuTrackSelectorPaste.setText( _( "Paste" ) );
            cMenuTrackSelectorPaste.setMnemonic( KeyEvent.VK_P );
            cMenuTrackSelectorDelete.setText( _( "Delete" ) );
            cMenuTrackSelectorDelete.setMnemonic( KeyEvent.VK_D );
            cMenuTrackSelectorDeleteBezier.setText( _( "Delete Bezier Point" ) );
            cMenuTrackSelectorDeleteBezier.setMnemonic( KeyEvent.VK_B );

            cMenuTrackSelectorSelectAll.setText( _( "Select All Events" ) );
            cMenuTrackSelectorSelectAll.setMnemonic( KeyEvent.VK_E );
            #endregion

            stripLblGameCtrlMode.setToolTipText( _( "Game Controler" ) );

            // Palette Tool
#if DEBUG
            AppManager.debugWriteLine( "FormMain#applyLanguage; Messaging.Language=" + Messaging.getLanguage() );
#endif
#if ENABLE_SCRIPT
            int count = toolStripTool.getComponentCount();
            for ( int i = 0; i < count; i++ ) {
                Object tsi = toolStripTool.getComponentAtIndex( i );
                if ( tsi is BToolStripButton ) {
                    BToolStripButton tsb = (BToolStripButton)tsi;
                    if ( tsb.getTag() != null && tsb.getTag() is String ) {
                        String id = (String)tsb.getTag();
                        if ( PaletteToolServer.loadedTools.containsKey( id ) ) {
                            IPaletteTool ipt = (IPaletteTool)PaletteToolServer.loadedTools.get( id );
                            tsb.setText( ipt.getName( Messaging.getLanguage() ) );
                            tsb.setToolTipText( ipt.getDescription( Messaging.getLanguage() ) );
                        }
                    }
                }
            }

            foreach ( MenuElement tsi in cMenuPianoPaletteTool.getSubElements() ) {
                if ( tsi is BMenuItem ) {
                    BMenuItem tsmi = (BMenuItem)tsi;
                    if ( tsmi.getTag() != null && tsmi.getTag() is String ) {
                        String id = (String)tsmi.getTag();
                        if ( PaletteToolServer.loadedTools.containsKey( id ) ) {
                            IPaletteTool ipt = (IPaletteTool)PaletteToolServer.loadedTools.get( id );
                            tsmi.setText( ipt.getName( Messaging.getLanguage() ) );
                            tsmi.setToolTipText( ipt.getDescription( Messaging.getLanguage() ) );
                        }
                    }
                }
            }

            foreach ( MenuElement tsi in cMenuTrackSelectorPaletteTool.getSubElements() ) {
                if ( tsi is BMenuItem ) {
                    BMenuItem tsmi = (BMenuItem)tsi;
                    if ( tsmi.getTag() != null && tsmi.getTag() is String ) {
                        String id = (String)tsmi.getTag();
                        if ( PaletteToolServer.loadedTools.containsKey( id ) ) {
                            IPaletteTool ipt = (IPaletteTool)PaletteToolServer.loadedTools.get( id );
                            tsmi.setText( ipt.getName( Messaging.getLanguage() ) );
                            tsmi.setToolTipText( ipt.getDescription( Messaging.getLanguage() ) );
                        }
                    }
                }
            }

            foreach ( MenuElement tsi in menuSettingPaletteTool.getSubElements() ) {
                if ( tsi is BMenuItem ) {
                    BMenuItem tsmi = (BMenuItem)tsi;
                    if ( tsmi.getTag() != null && tsmi.getTag() is String ) {
                        String id = (String)tsmi.getTag();
                        if ( PaletteToolServer.loadedTools.containsKey( id ) ) {
                            IPaletteTool ipt = (IPaletteTool)PaletteToolServer.loadedTools.get( id );
                            tsmi.setText( ipt.getName( Messaging.getLanguage() ) );
                        }
                    }
                }
            }

            for ( Iterator<String> itr = PaletteToolServer.loadedTools.keySet().iterator(); itr.hasNext(); ) {
                String id = (String)itr.next();
                IPaletteTool ipt = (IPaletteTool)PaletteToolServer.loadedTools.get( id );
                ipt.applyLanguage( Messaging.getLanguage() );
            }
#endif

#if ENABLE_STRIP_DROPDOWN
            updateStripDDBtnSpeed();
#endif
        }

        /// <summary>
        /// 歌詞の流し込みダイアログを開き，選択された音符を起点に歌詞を流し込みます
        /// </summary>
        public void importLyric() {
            int start = 0;
            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            VsqTrack vsq_track = vsq.Track.get( selected );
            int selectedid = AppManager.getLastSelectedEvent().original.InternalID;
            int numEvents = vsq_track.getEventCount();
            for ( int i = 0; i < numEvents; i++ ) {
                if ( selectedid == vsq_track.getEvent( i ).InternalID ) {
                    start = i;
                    break;
                }
            }
            int count = vsq_track.getEventCount() - 1 - start + 1;
            try {
                if ( formImportLyric == null ) {
                    formImportLyric = new FormImportLyric( count );
                } else {
                    formImportLyric.setMaxNotes( count );
                }
                formImportLyric.setLocation( getFormPreferedLocation( formImportLyric ) );
                formImportLyric.setModal( true );
                formImportLyric.setVisible( true );
                if ( formImportLyric.getDialogResult() == BDialogResult.OK ) {
                    String[] phrases = formImportLyric.getLetters();
#if DEBUG
                    foreach ( String s in phrases ) {
                        PortUtil.println( "FormMain#importLyric; phrases; s=" + s );
                    }
#endif
                    int min = Math.Min( count, phrases.Length );
                    Vector<String> new_phrases = new Vector<String>();
                    Vector<String> new_symbols = new Vector<String>();
                    for ( int i = 0; i < phrases.Length; i++ ) {
                        SymbolTableEntry entry = SymbolTable.attatch( phrases[i] );
                        if ( new_phrases.size() + 1 > count ) {
                            break;
                        }
                        if ( entry == null ) {
                            new_phrases.add( phrases[i] );
                            new_symbols.add( "a" );
                        } else {
                            if ( entry.Word.IndexOf( '-' ) >= 0 ) {
                                // 分節に分割する必要がある
                                String[] spl = PortUtil.splitString( entry.Word, '\t' );
                                if ( new_phrases.size() + spl.Length > count ) {
                                    // 分節の全部を分割すると制限個数を超えてしまう
                                    // 分割せずにハイフンを付けたまま登録
                                    new_phrases.add( entry.Word.Replace( "\t", "" ) );
                                    new_symbols.add( entry.getSymbol() );
                                } else {
                                    String[] spl_symbol = PortUtil.splitString( entry.getRawSymbol(), '\t' );
                                    for ( int j = 0; j < spl.Length; j++ ) {
                                        new_phrases.add( spl[j] );
                                        new_symbols.add( spl_symbol[j] );
                                    }
                                }
                            } else {
                                // 分節に分割しない
                                new_phrases.add( phrases[i] );
                                new_symbols.add( entry.getSymbol() );
                            }
                        }
                    }
                    VsqID[] new_ids = new VsqID[new_phrases.size()];
                    int[] ids = new int[new_phrases.size()];
                    int indx = -1;
                    for ( Iterator<Integer> itr = vsq_track.indexIterator( IndexIteratorKind.NOTE ); itr.hasNext(); ) {
                        int index = itr.next();
                        if ( index < start ) {
                            continue;
                        }
                        indx++;
                        VsqEvent item = vsq_track.getEvent( index );
                        new_ids[indx] = (VsqID)item.ID.clone();
                        new_ids[indx].LyricHandle.L0.Phrase = new_phrases.get( indx );
                        new_ids[indx].LyricHandle.L0.setPhoneticSymbol( new_symbols.get( indx ) );
                        ids[indx] = item.InternalID;
                        if ( indx + 1 >= new_phrases.size() ) {
                            break;
                        }
                    }
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventChangeIDContaintsRange( selected, ids, new_ids ) );
                    AppManager.register( vsq.executeCommand( run ) );
                    setEdited( true );
                    repaint();
                }
            } catch ( Exception ex ) {
            } finally {
                formImportLyric.setVisible( false );
            }
        }

        public void editNoteVibratoProperty() {
            SelectedEventEntry item = AppManager.getLastSelectedEvent();
            if ( item == null ) {
                return;
            }

            VsqEvent ev = item.original;
            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            RendererKind kind = VsqFileEx.getTrackRendererKind( vsq.Track.get( selected ) );
            SynthesizerType type = SynthesizerType.VOCALOID2;
            if ( kind == RendererKind.VOCALOID1_100 || kind == RendererKind.VOCALOID1_101 ) {
                type = SynthesizerType.VOCALOID1;
            }
            FormVibratoConfig dlg = null;
            try {
                dlg = new FormVibratoConfig( 
                    ev.ID.VibratoHandle, 
                    ev.ID.getLength(), 
                    AppManager.editorConfig.DefaultVibratoLength,
                    type );
                dlg.setLocation( getFormPreferedLocation( dlg ) );
                dlg.setModal( true );
                dlg.setVisible( true );
                if ( dlg.getDialogResult() == BDialogResult.OK ) {
                    VsqEvent edited = (VsqEvent)ev.clone();
                    if ( dlg.getVibratoHandle() != null ) {
                        edited.ID.VibratoHandle = (VibratoHandle)dlg.getVibratoHandle().clone();
                        //edited.ID.VibratoHandle.setStartDepth( AppManager.editorConfig.DefaultVibratoDepth );
                        //edited.ID.VibratoHandle.setStartRate( AppManager.editorConfig.DefaultVibratoRate );
                        edited.ID.VibratoDelay = ev.ID.getLength() - dlg.getVibratoHandle().getLength();
                    } else {
                        edited.ID.VibratoHandle = null;
                    }
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventChangeIDContaints( selected, ev.InternalID, edited.ID ) );
                    AppManager.register( vsq.executeCommand( run ) );
                    setEdited( true );
                    refreshScreen();
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        public void editNoteExpressionProperty() {
            SelectedEventEntry item = AppManager.getLastSelectedEvent();
            if ( item == null ) {
                return;
            }

            VsqEvent ev = item.original;
            SynthesizerType type = SynthesizerType.VOCALOID2;
            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            RendererKind kind = VsqFileEx.getTrackRendererKind( vsq.Track.get( selected ) );
            if ( kind == RendererKind.VOCALOID1_100 || kind == RendererKind.VOCALOID1_101 ) {
                type = SynthesizerType.VOCALOID1;
            }
            FormNoteExpressionConfig dlg = null;
            try {
                dlg = new FormNoteExpressionConfig( type, ev.ID.NoteHeadHandle );
                dlg.setPMBendDepth( ev.ID.PMBendDepth );
                dlg.setPMBendLength( ev.ID.PMBendLength );
                dlg.setPMbPortamentoUse( ev.ID.PMbPortamentoUse );
                dlg.setDEMdecGainRate( ev.ID.DEMdecGainRate );
                dlg.setDEMaccent( ev.ID.DEMaccent );

                dlg.setLocation( getFormPreferedLocation( dlg ) );
                dlg.setModal( true );
                dlg.setVisible( true );
                if ( dlg.getDialogResult() == BDialogResult.OK ) {
                    VsqEvent edited = (VsqEvent)ev.clone();
                    edited.ID.PMBendDepth = dlg.getPMBendDepth();
                    edited.ID.PMBendLength = dlg.getPMBendLength();
                    edited.ID.PMbPortamentoUse = dlg.getPMbPortamentoUse();
                    edited.ID.DEMdecGainRate = dlg.getDEMdecGainRate();
                    edited.ID.DEMaccent = dlg.getDEMaccent();
                    edited.ID.NoteHeadHandle = dlg.getEditedNoteHeadHandle();
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventChangeIDContaints( selected, ev.InternalID, edited.ID ) );
                    AppManager.register( vsq.executeCommand( run ) );
                    setEdited( true );
                    refreshScreen();
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        public int computeScrollValueFromWheelDelta( int delta ) {
            double new_val = (double)hScroll.getValue() - delta * AppManager.editorConfig.WheelOrder / (5.0 * AppManager.getScaleX());
            if ( new_val < 0.0 ) {
                new_val = 0;
            }
            int draft = (int)new_val;
            if ( draft > hScroll.getMaximum() ) {
                draft = hScroll.getMaximum();
            } else if ( draft < hScroll.getMinimum() ) {
                draft = hScroll.getMinimum();
            }
            return draft;
        }

        #region 音符の編集関連
        public void selectAll() {
            AppManager.clearSelectedEvent();
            AppManager.clearSelectedTempo();
            AppManager.clearSelectedTimesig();
            AppManager.clearSelectedPoint();
            int min = int.MaxValue;
            int max = int.MinValue;
            int premeasure = AppManager.getVsqFile().getPreMeasureClocks();
            Vector<Integer> add_required = new Vector<Integer>();
            for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEventIterator(); itr.hasNext(); ) {
                VsqEvent ve = itr.next();
                if ( premeasure <= ve.Clock ) {
                    add_required.add( ve.InternalID );
                    min = Math.Min( min, ve.Clock );
                    max = Math.Max( max, ve.Clock + ve.ID.getLength() );
                }
            }
            if ( add_required.size() > 0 ) {
                AppManager.addSelectedEventAll( add_required );
            }
            foreach ( CurveType vct in Utility.CURVE_USAGE ) {
                if ( vct.isScalar() || vct.isAttachNote() ) {
                    continue;
                }
                VsqBPList target = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( vct.getName() );
                int count = target.size();
                if ( count >= 1 ) {
                    //int[] keys = target.getKeys();
                    int max_key = target.getKeyClock( count - 1 );
                    max = Math.Max( max, target.getValue( max_key ) );
                    for ( int i = 0; i < count; i++ ) {
                        int key = target.getKeyClock( i );
                        if ( premeasure <= key ) {
                            min = Math.Min( min, key );
                            break;
                        }
                    }
                }
            }
            if ( min < premeasure ) {
                min = premeasure;
            }
            if ( min < max ) {
                //int stdx = AppManager.startToDrawX;
                //min = xCoordFromClocks( min ) + stdx;
                //max = xCoordFromClocks( max ) + stdx;
                AppManager.wholeSelectedInterval = new SelectedRegion( min );
                AppManager.wholeSelectedInterval.setEnd( max );
                AppManager.setWholeSelectedIntervalEnabled( true );
            }
        }

        public void selectAllEvent() {
            AppManager.clearSelectedTempo();
            AppManager.clearSelectedTimesig();
            AppManager.clearSelectedEvent();
            AppManager.clearSelectedPoint();
            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            VsqTrack vsq_track = vsq.Track.get( selected );
            int premeasureclock = vsq.getPreMeasureClocks();
            Vector<Integer> add_required = new Vector<Integer>();
            for ( Iterator<VsqEvent> itr = vsq_track.getEventIterator(); itr.hasNext(); ) {
                VsqEvent ev = itr.next();
                if ( ev.ID.type == VsqIDType.Anote && ev.Clock >= premeasureclock ) {
                    add_required.add( ev.InternalID );
                }
            }
            if ( add_required.size() > 0 ) {
                AppManager.addSelectedEventAll( add_required );
            }
            refreshScreen();
        }

        public void deleteEvent() {
#if DEBUG
            AppManager.debugWriteLine( 
                "FormMain#deleteEvent(); AppManager.inputTextBox.isEnabled()=" + 
                AppManager.inputTextBox.isEnabled() );
#endif

            if ( AppManager.inputTextBox.isVisible() ) {
                return;
            }
#if ENABLE_PROPERTY
            if ( AppManager.propertyPanel.isEditing() ) {
                return;
            }
#endif

            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            VsqTrack vsq_track = vsq.Track.get( selected );

            if ( AppManager.getSelectedEventCount() > 0 ) {
                Vector<Integer> ids = new Vector<Integer>();
                boolean contains_aicon = false;
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry ev = itr.next();
                    ids.add( ev.original.InternalID );
                    if ( ev.original.ID.type == VsqIDType.Aicon ) {
                        contains_aicon = true;
                    }
                }
                VsqCommand run = VsqCommand.generateCommandEventDeleteRange( selected, ids );
                if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                    VsqFileEx work = (VsqFileEx)vsq.clone();
                    work.executeCommand( run );
                    int stdx = AppManager.getStartToDrawX();
                    int start_clock = AppManager.wholeSelectedInterval.getStart();
                    int end_clock = AppManager.wholeSelectedInterval.getEnd();
                    Vector<Vector<BPPair>> curves = new Vector<Vector<BPPair>>();
                    Vector<CurveType> types = new Vector<CurveType>();
                    VsqTrack work_vsq_track = work.Track.get( selected );
                    foreach ( CurveType vct in Utility.CURVE_USAGE ) {
                        if ( vct.isScalar() || vct.isAttachNote() ) {
                            continue;
                        }
                        VsqBPList work_curve = work_vsq_track.getCurve( vct.getName() );
                        Vector<BPPair> t = new Vector<BPPair>();
                        t.add( new BPPair( start_clock, work_curve.getValue( start_clock ) ) );
                        t.add( new BPPair( end_clock, work_curve.getValue( end_clock ) ) );
                        curves.add( t );
                        types.add( vct );
                    }
                    Vector<String> strs = new Vector<String>();
                    for ( int i = 0; i < types.size(); i++ ) {
                        strs.add( types.get( i ).getName() );
                    }
                    CadenciiCommand delete_curve = new CadenciiCommand(
                        VsqCommand.generateCommandTrackCurveEditRange( selected, strs, curves ) );
                    work.executeCommand( delete_curve );
                    if ( contains_aicon ) {
                        work.Track.get( selected ).reflectDynamics();
                    }
                    CadenciiCommand run2 = new CadenciiCommand( VsqCommand.generateCommandReplace( work ) );
                    AppManager.register( vsq.executeCommand( run2 ) );
                    setEdited( true );
                } else {
                    CadenciiCommand run2 = null;
                    if ( contains_aicon ) {
                        VsqFileEx work = (VsqFileEx)vsq.clone();
                        work.executeCommand( run );
                        VsqTrack vsq_track_copied = work.Track.get( selected );
                        vsq_track_copied.reflectDynamics();
                        run2 = VsqFileEx.generateCommandTrackReplace( selected,
                                                                      vsq_track_copied,
                                                                      work.AttachedCurves.get( selected - 1 ) );
                    } else {
                        run2 = new CadenciiCommand( run );
                    }
                    AppManager.register( vsq.executeCommand( run2 ) );
                    setEdited( true );
                    AppManager.clearSelectedEvent();
                }
                repaint();
            } else if ( AppManager.getSelectedTempoCount() > 0 ) {
                Vector<Integer> clocks = new Vector<Integer>();
                for ( Iterator<ValuePair<Integer, SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                    if ( item.getKey() <= 0 ) {
                        statusLabel.setText( _( "Cannot remove first symbol of track!" ) );
#if !JAVA
                        SystemSounds.Asterisk.Play();
#endif
                        return;
                    }
                    clocks.add( item.getKey() );
                }
                int[] dum = new int[clocks.size()];
                for ( int i = 0; i < dum.Length; i++ ) {
                    dum[i] = -1;
                }
                CadenciiCommand run = new CadenciiCommand( 
                    VsqCommand.generateCommandUpdateTempoRange( PortUtil.convertIntArray( clocks.toArray( new Integer[] { } ) ),
                                                                PortUtil.convertIntArray( clocks.toArray( new Integer[] { } ) ), 
                                                                dum ) );
                AppManager.register( vsq.executeCommand( run ) );
                setEdited( true );
                AppManager.clearSelectedTempo();
                repaint();
            } else if ( AppManager.getSelectedTimesigCount() > 0 ) {
#if DEBUG
                AppManager.debugWriteLine( "    Timesig" );
#endif
                int[] barcounts = new int[AppManager.getSelectedTimesigCount()];
                int[] numerators = new int[AppManager.getSelectedTimesigCount()];
                int[] denominators = new int[AppManager.getSelectedTimesigCount()];
                int count = -1;
                for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                    int key = item.getKey();
                    SelectedTimesigEntry value = item.getValue();
                    count++;
                    barcounts[count] = key;
                    if ( key <= 0 ) {
                        statusLabel.setText( _( "Cannot remove first symbol of track!" ) );
#if !JAVA
                        SystemSounds.Asterisk.Play();
#endif
                        return;
                    }
                    numerators[count] = -1;
                    denominators[count] = -1;
                }
                CadenciiCommand run = new CadenciiCommand(
                    VsqCommand.generateCommandUpdateTimesigRange( barcounts, barcounts, numerators, denominators ) );
                AppManager.register( vsq.executeCommand( run ) );
                setEdited( true );
                AppManager.clearSelectedTimesig();
                repaint();
            }
            if ( AppManager.getSelectedPointIDCount() > 0 ) {
#if DEBUG
                AppManager.debugWriteLine( "    Curve" );
#endif
                String curve;
                if ( !trackSelector.getSelectedCurve().isAttachNote() ) {
                    curve = trackSelector.getSelectedCurve().getName();
                    VsqBPList src = vsq_track.getCurve( curve );
                    VsqBPList list = (VsqBPList)src.clone();
                    Vector<Integer> remove_clock_queue = new Vector<Integer>();
                    int count = list.size();
                    for ( int i = 0; i < count; i++ ) {
                        VsqBPPair item = list.getElementB( i );
                        if ( AppManager.isSelectedPointContains( item.id ) ) {
                            remove_clock_queue.add( list.getKeyClock( i ) );
                        }
                    }
                    count = remove_clock_queue.size();
                    for ( int i = 0; i < count; i++ ) {
                        list.remove( remove_clock_queue.get( i ) );
                    }
                    CadenciiCommand run = new CadenciiCommand( 
                        VsqCommand.generateCommandTrackCurveReplace( selected,
                                                                     trackSelector.getSelectedCurve().getName(),
                                                                     list ) );
                    AppManager.register( vsq.executeCommand( run ) );
                    setEdited( true );
                } else {
                    //todo: FormMain+DeleteEvent; VibratoDepth, VibratoRateの場合
                }
                AppManager.clearSelectedPoint();
                refreshScreen();
            }
        }

        public void pasteEvent() {
            int clock = AppManager.getCurrentClock();
            int unit = AppManager.getPositionQuantizeClock();
            clock = doQuantize( clock, unit );

            VsqCommand add_event = null; // VsqEventを追加するコマンド

            ClipboardEntry ce = AppManager.getCopiedItems();
            int copy_started_clock = ce.copyStartedClock;
            Vector<VsqEvent> copied_events = ce.events;
#if DEBUG
            PortUtil.println( "FormMain#pasteEvent; copy_started_clock=" + copy_started_clock );
            PortUtil.println( "FormMain#pasteEvent; copied_events.size()=" + copied_events.size() );
#endif
            if ( copied_events.size() != 0 ) {
                // VsqEventのペーストを行うコマンドを発行
                int dclock = clock - copy_started_clock;
                if ( clock >= AppManager.getVsqFile().getPreMeasureClocks() ) {
                    Vector<VsqEvent> paste = new Vector<VsqEvent>();
                    int count = copied_events.size();
                    for ( int i = 0; i < count; i++ ) {
                        VsqEvent item = (VsqEvent)copied_events.get( i ).clone();
                        item.Clock = copied_events.get( i ).Clock + dclock;
                        paste.add( item );
                    }
                    add_event = VsqCommand.generateCommandEventAddRange( 
                        AppManager.getSelected(), paste.toArray( new VsqEvent[] { } ) );
                }
            }
            Vector<TempoTableEntry> copied_tempo = ce.tempo;
            if ( copied_tempo.size() != 0 ) {
                // テンポ変更の貼付けを実行
                int dclock = clock - copy_started_clock;
                int count = copied_tempo.size();
                int[] clocks = new int[count];
                int[] tempos = new int[count];
                for ( int i = 0; i < count; i++ ) {
                    TempoTableEntry item = copied_tempo.get( i );
                    clocks[i] = item.Clock + dclock;
                    tempos[i] = item.Tempo;
                }
                CadenciiCommand run = new CadenciiCommand( 
                    VsqCommand.generateCommandUpdateTempoRange( clocks, clocks, tempos ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                refreshScreen();
                return;
            }
            Vector<TimeSigTableEntry> copied_timesig = ce.timesig;
            if ( copied_timesig.size() > 0 ) {
                // 拍子変更の貼付けを実行
                int bar_count = AppManager.getVsqFile().getBarCountFromClock( clock );
                int min_barcount = copied_timesig.get( 0 ).BarCount;
                for ( Iterator<TimeSigTableEntry> itr = copied_timesig.iterator(); itr.hasNext(); ) {
                    TimeSigTableEntry tste = itr.next();
                    min_barcount = Math.Min( min_barcount, tste.BarCount );
                }
                int dbarcount = bar_count - min_barcount;
                int count = copied_timesig.size();
                int[] barcounts = new int[count];
                int[] numerators = new int[count];
                int[] denominators = new int[count];
                for ( int i = 0; i < count; i++ ) {
                    TimeSigTableEntry item = copied_timesig.get( i );
                    barcounts[i] = item.BarCount + dbarcount;
                    numerators[i] = item.Numerator;
                    denominators[i] = item.Denominator;
                }
                CadenciiCommand run = new CadenciiCommand(
                    VsqCommand.generateCommandUpdateTimesigRange( 
                        barcounts, barcounts, numerators, denominators ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                refreshScreen();
                return;
            }

            // BPPairの貼付け
            VsqCommand edit_bpcurve = null; // BPListを変更するコマンド
            TreeMap<CurveType, VsqBPList> copied_curve = ce.points;
#if DEBUG
            PortUtil.println( "FormMain#pasteEvent; copied_curve.size()=" + copied_curve.size() );
#endif
            if ( copied_curve.size() > 0 ) {
                int dclock = clock - copy_started_clock;

                TreeMap<String, VsqBPList> work = new TreeMap<String, VsqBPList>();
                for ( Iterator<CurveType> itr = copied_curve.keySet().iterator(); itr.hasNext(); ) {
                    CurveType curve = itr.next();
                    VsqBPList list = copied_curve.get( curve );
#if DEBUG
                    AppManager.debugWriteLine( "FormMain#pasteEvent; curve=" + curve );
#endif
                    if ( curve.isScalar() ) {
                        continue;
                    }
                    if ( list.size() <= 0 ) {
                        continue;
                    }
                    if ( curve.isAttachNote() ) {
                        //todo: FormMain+PasteEvent; VibratoRate, VibratoDepthカーブのペースト処理
                    } else {
                        VsqBPList target = (VsqBPList)AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( curve.getName() ).clone();
                        int count = list.size();
#if DEBUG
                        PortUtil.println( "FormMain#pasteEvent; list.getCount()=" + count );
#endif
                        int min = list.getKeyClock( 0 ) + dclock;
                        int max = list.getKeyClock( count - 1 ) + dclock;
                        int valueAtEnd = target.getValue( max );
                        for ( int i = 0; i < target.size(); i++ ) {
                            int cl = target.getKeyClock( i );
                            if ( min <= cl && cl <= max ) {
                                target.removeElementAt( i );
                                i--;
                            }
                        }
                        int lastClock = min;
                        for ( int i = 0; i < count - 1; i++ ) {
                            lastClock = list.getKeyClock( i ) + dclock;
                            target.add( lastClock, list.getElementA( i ) );
                        }
                        // 最後のやつ
                        if ( lastClock < max - 1 ) {
                            target.add( max - 1, list.getElementA( count - 1 ) );
                        }
                        target.add( max, valueAtEnd );
                        if ( copied_curve.size() == 1 ) {
                            work.put( trackSelector.getSelectedCurve().getName(), target );
                        } else {
                            work.put( curve.getName(), target );
                        }
                    }
                }
#if DEBUG
                PortUtil.println( "FormMain#pasteEvent; work.size()=" + work.size() );
#endif
                if ( work.size() > 0 ) {
                    String[] curves = new String[work.size()];
                    VsqBPList[] bplists = new VsqBPList[work.size()];
                    int count = -1;
                    for ( Iterator<String> itr = work.keySet().iterator(); itr.hasNext(); ) {
                        String s = itr.next();
                        count++;
                        curves[count] = s;
                        bplists[count] = work.get( s );
                    }
                    edit_bpcurve = VsqCommand.generateCommandTrackCurveReplaceRange( AppManager.getSelected(), curves, bplists );
                }
                AppManager.clearSelectedPoint();
            }

            // ベジエ曲線の貼付け
            CadenciiCommand edit_bezier = null;
            TreeMap<CurveType, Vector<BezierChain>> copied_bezier = ce.beziers;
#if DEBUG
            PortUtil.println( "FormMain#pasteEvent; copied_bezier.size()=" + copied_bezier.size() );
#endif
            if ( copied_bezier.size() > 0 ) {
                int dclock = clock - copy_started_clock;
                BezierCurves attached_curve = (BezierCurves)AppManager.getVsqFile().AttachedCurves.get( AppManager.getSelected() - 1 ).clone();
                TreeMap<CurveType, Vector<BezierChain>> command_arg = new TreeMap<CurveType, Vector<BezierChain>>();
                for ( Iterator<CurveType> itr = copied_bezier.keySet().iterator(); itr.hasNext(); ) {
                    CurveType curve = itr.next();
                    if ( curve.isScalar() ) {
                        continue;
                    }
                    for ( Iterator<BezierChain> itr2 = copied_bezier.get( curve ).iterator(); itr2.hasNext(); ) {
                        BezierChain bc = itr2.next();
                        BezierChain bc_copy = (BezierChain)bc.clone();
                        for ( Iterator<BezierPoint> itr3 = bc_copy.points.iterator(); itr3.hasNext(); ) {
                            BezierPoint bp = itr3.next();
                            bp.setBase( new PointD( bp.getBase().getX() + dclock, bp.getBase().getY() ) );
                        }
                        attached_curve.mergeBezierChain( curve, bc_copy );
                    }
                    Vector<BezierChain> arg = new Vector<BezierChain>();
                    for ( Iterator<BezierChain> itr2 = attached_curve.get( curve ).iterator(); itr2.hasNext(); ) {
                        BezierChain bc = itr2.next();
                        arg.add( bc );
                    }
                    command_arg.put( curve, arg );
                }
                edit_bezier = VsqFileEx.generateCommandReplaceAttachedCurveRange( AppManager.getSelected(), command_arg );
            }

            int commands = 0;
            commands += (add_event != null) ? 1 : 0;
            commands += (edit_bpcurve != null) ? 1 : 0;
            commands += (edit_bezier != null) ? 1 : 0;

#if DEBUG
            AppManager.debugWriteLine( "FormMain#pasteEvent; commands=" + commands );
            AppManager.debugWriteLine( "FormMain#pasteEvent; (add_event != null)=" + (add_event != null) );
            AppManager.debugWriteLine( "FormMain#pasteEvent; (edit_bpcurve != null)=" + (edit_bpcurve != null) );
            AppManager.debugWriteLine( "FormMain#pasteEvent; (edit_bezier != null)=" + (edit_bezier != null) );
#endif
            if ( commands == 1 ) {
                if ( add_event != null ) {
                    CadenciiCommand run = new CadenciiCommand( add_event );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                } else if ( edit_bpcurve != null ) {
                    CadenciiCommand run = new CadenciiCommand( edit_bpcurve );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                } else if ( edit_bezier != null ) {
                    AppManager.register( AppManager.getVsqFile().executeCommand( edit_bezier ) );
                }
                AppManager.getVsqFile().updateTotalClocks();
                setEdited( true );
                refreshScreen();
            } else if ( commands > 1 ) {
                VsqFileEx work = (VsqFileEx)AppManager.getVsqFile().clone();
                if ( add_event != null ) {
                    work.executeCommand( add_event );
                }
                if ( edit_bezier != null ) {
                    work.executeCommand( edit_bezier );
                }
                if ( edit_bpcurve != null ) {
                    // edit_bpcurveのVsqCommandTypeはTrackEditCurveRangeしかありえない
                    work.executeCommand( edit_bpcurve );
                }
                CadenciiCommand run = VsqFileEx.generateCommandReplace( work );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                AppManager.getVsqFile().updateTotalClocks();
                setEdited( true );
                refreshScreen();
            }
        }

        /// <summary>
        /// アイテムのコピーを行います
        /// </summary>
        public void copyEvent() {
#if DEBUG
            AppManager.debugWriteLine( "FormMain#copyEvent" );
#endif
            AppManager.clearClipBoard();
            int min = int.MaxValue; // コピーされたアイテムの中で、最小の開始クロック

            if ( AppManager.isWholeSelectedIntervalEnabled() ) {
#if DEBUG
                PortUtil.println( "FormMain#copyEvent; selected with CTRL key" );
#endif
                int stdx = AppManager.getStartToDrawX();
                int start_clock = AppManager.wholeSelectedInterval.getStart();
                int end_clock = AppManager.wholeSelectedInterval.getEnd();
                ClipboardEntry ce = new ClipboardEntry();
                ce.copyStartedClock = start_clock;
                ce.points = new TreeMap<CurveType, VsqBPList>();
                ce.beziers = new TreeMap<CurveType, Vector<BezierChain>>();
                for ( int i = 0; i < Utility.CURVE_USAGE.Length; i++ ) {
                    CurveType vct = Utility.CURVE_USAGE[i];
                    VsqBPList list = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( vct.getName() );
                    if ( list == null ) {
                        continue;
                    }
                    Vector<BezierChain> tmp_bezier = new Vector<BezierChain>();
                    copyCurveCor( AppManager.getSelected(),
                                  vct,
                                  start_clock,
                                  end_clock,
                                  tmp_bezier );
                    VsqBPList tmp_bplist = new VsqBPList( list.getName(), list.getDefault(), list.getMinimum(), list.getMaximum() );
                    int c = list.size();
                    for ( int j = 0; j < c; j++ ) {
                        int clock = list.getKeyClock( j );
                        if ( start_clock <= clock && clock <= end_clock ) {
                            tmp_bplist.add( clock, list.getElement( j ) );
                        } else if ( end_clock < clock ) {
                            break;
                        }
                    }
                    ce.beziers.put( vct, tmp_bezier );
                    ce.points.put( vct, tmp_bplist );
                }

                if ( AppManager.getSelectedEventCount() > 0 ) {
                    Vector<VsqEvent> list = new Vector<VsqEvent>();
                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry item = itr.next();
                        if ( item.original.ID.type == VsqIDType.Anote ) {
                            min = Math.Min( item.original.Clock, min );
                            list.add( (VsqEvent)item.original.clone() );
                        }
                    }
                    ce.events = list;
                }
                AppManager.setClipboard( ce );
            } else if ( AppManager.getSelectedEventCount() > 0 ) {
                Vector<VsqEvent> list = new Vector<VsqEvent>();
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    min = Math.Min( item.original.Clock, min );
                    list.add( (VsqEvent)item.original.clone() );
                }
                AppManager.setCopiedEvent( list, min );
            } else if ( AppManager.getSelectedTempoCount() > 0 ) {
                Vector<TempoTableEntry> list = new Vector<TempoTableEntry>();
                for ( Iterator<ValuePair<Integer, SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                    int key = item.getKey();
                    SelectedTempoEntry value = item.getValue();
                    min = Math.Min( value.original.Clock, min );
                    list.add( (TempoTableEntry)value.original.clone() );
                }
                AppManager.setCopiedTempo( list, min );
            } else if ( AppManager.getSelectedTimesigCount() > 0 ) {
                Vector<TimeSigTableEntry> list = new Vector<TimeSigTableEntry>();
                for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                    int key = item.getKey();
                    SelectedTimesigEntry value = item.getValue();
                    min = Math.Min( value.original.Clock, min );
                    list.add( (TimeSigTableEntry)value.original.clone() );
                }
                AppManager.setCopiedTimesig( list, min );
            } else if ( AppManager.getSelectedPointIDCount() > 0 ) {
                ClipboardEntry ce = new ClipboardEntry();
                ce.points = new TreeMap<CurveType, VsqBPList>();
                ce.beziers = new TreeMap<CurveType, Vector<BezierChain>>();

                ValuePair<Integer, Integer> t = trackSelector.getSelectedRegion();
                int start = t.getKey();
                int end = t.getValue();
                ce.copyStartedClock = start;
                Vector<BezierChain> tmp_bezier = new Vector<BezierChain>();
                copyCurveCor( AppManager.getSelected(),
                              trackSelector.getSelectedCurve(),
                              start,
                              end,
                              tmp_bezier );
                if ( tmp_bezier.size() > 0 ) {
                    // ベジエ曲線が1個以上コピーされた場合
                    // 範囲内のデータ点を追加する
                    ce.beziers.put( trackSelector.getSelectedCurve(), tmp_bezier );
                    CurveType curve = trackSelector.getSelectedCurve();
                    VsqBPList list = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( curve.getName() );
                    if ( list != null ) {
                        VsqBPList tmp_bplist = new VsqBPList( list.getName(), list.getDefault(), list.getMinimum(), list.getMaximum() );
                        int c = list.size();
                        for ( int i = 0; i < c; i++ ) {
                            int clock = list.getKeyClock( i );
                            if ( start <= clock && clock <= end ) {
                                tmp_bplist.add( clock, list.getElement( i ) );
                            } else if ( end < clock ) {
                                break;
                            }
                        }
                        ce.points.put( curve, tmp_bplist );
                    }
                } else {
                    // ベジエ曲線がコピーされなかった場合
                    // AppManager.selectedPointIDIteratorの中身のみを選択
                    CurveType curve = trackSelector.getSelectedCurve();
                    VsqBPList list = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( curve.getName() );
                    if ( list != null ) {
                        VsqBPList tmp_bplist = new VsqBPList( curve.getName(), curve.getDefault(), curve.getMinimum(), curve.getMaximum() );
                        for ( Iterator<Long> itr = AppManager.getSelectedPointIDIterator(); itr.hasNext(); ) {
                            long id = itr.next();
                            VsqBPPairSearchContext cxt = list.findElement( id );
                            if ( cxt.index >= 0 ) {
                                tmp_bplist.add( cxt.clock, cxt.point.value );
                            }
                        }
                        if ( tmp_bplist.size() > 0 ) {
                            ce.copyStartedClock = tmp_bplist.getKeyClock( 0 );
                            ce.points.put( curve, tmp_bplist );
                        }
                    }
                }
                AppManager.setClipboard( ce );
            }
        }

        public void cutEvent() {
            // まずコピー
            copyEvent();

            int track = AppManager.getSelected();

            // 選択されたノートイベントがあれば、まず、削除を行うコマンドを発行
            VsqCommand delete_event = null;
            boolean other_command_executed = false;
            if ( AppManager.getSelectedEventCount() > 0 ) {
                Vector<Integer> ids = new Vector<Integer>();
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    ids.add( item.original.InternalID );
                }
                delete_event = VsqCommand.generateCommandEventDeleteRange( AppManager.getSelected(), ids );
            }

            // Ctrlキーを押しながらドラッグしたか、そうでないかで分岐
            if ( AppManager.isWholeSelectedIntervalEnabled() || AppManager.getSelectedPointIDCount() > 0 ) {
                int stdx = AppManager.getStartToDrawX();
                int start_clock, end_clock;
                if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                    start_clock = AppManager.wholeSelectedInterval.getStart();
                    end_clock = AppManager.wholeSelectedInterval.getEnd();
                } else {
                    start_clock = trackSelector.getSelectedRegion().getKey();
                    end_clock = trackSelector.getSelectedRegion().getValue();
                }

                // クローンを作成
                VsqFileEx work = (VsqFileEx)AppManager.getVsqFile().clone();
                if ( delete_event != null ) {
                    // 選択されたノートイベントがあれば、クローンに対して削除を実行
                    work.executeCommand( delete_event );
                }

                // BPListに削除処理を施す
                for ( int i = 0; i < Utility.CURVE_USAGE.Length; i++ ) {
                    CurveType curve = Utility.CURVE_USAGE[i];
                    VsqBPList list = work.Track.get( track ).getCurve( curve.getName() );
                    if ( list == null ) {
                        continue;
                    }
                    int c = list.size();
                    Vector<Long> delete = new Vector<Long>();
                    if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                        // 一括選択モード
                        for ( int j = 0; j < c; j++ ) {
                            int clock = list.getKeyClock( j );
                            if ( start_clock <= clock && clock <= end_clock ) {
                                delete.add( list.getElementB( j ).id );
                            } else if ( end_clock < clock ) {
                                break;
                            }
                        }
                    } else {
                        // 普通の範囲選択
                        for ( Iterator<Long> itr = AppManager.getSelectedPointIDIterator(); itr.hasNext(); ) {
                            long id = (Long)itr.next();
                            delete.add( id );
                        }
                    }
                    VsqCommand tmp = VsqCommand.generateCommandTrackCurveEdit2( track, curve.getName(), delete, new TreeMap<Integer, VsqBPPair>() );
                    work.executeCommand( tmp );
                }

                // ベジエ曲線に削除処理を施す
                Vector<CurveType> target_curve = new Vector<CurveType>();
                if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                    // ctrlによる全選択モード
                    for ( int i = 0; i < Utility.CURVE_USAGE.Length; i++ ) {
                        CurveType ct = Utility.CURVE_USAGE[i];
                        if ( ct.isScalar() || ct.isAttachNote() ) {
                            continue;
                        }
                        target_curve.add( ct );
                    }
                } else {
                    // 普通の選択モード
                    target_curve.add( trackSelector.getSelectedCurve() );
                }
                work.AttachedCurves.get( AppManager.getSelected() - 1 ).deleteBeziers( target_curve, start_clock, end_clock );

                // コマンドを発行し、実行
                CadenciiCommand run = VsqFileEx.generateCommandReplace( work );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                this.setEdited( true );

                other_command_executed = true;
            } else if ( AppManager.getSelectedTempoCount() > 0 ) {
                // テンポ変更のカット
                int count = -1;
                int[] dum = new int[AppManager.getSelectedTempoCount()];
                int[] clocks = new int[AppManager.getSelectedTempoCount()];
                for ( Iterator<ValuePair<Integer, SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                    int key = item.getKey();
                    SelectedTempoEntry value = item.getValue();
                    count++;
                    dum[count] = -1;
                    clocks[count] = value.original.Clock;
                }
                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTempoRange( clocks, clocks, dum ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                other_command_executed = true;
            } else if ( AppManager.getSelectedTimesigCount() > 0 ) {
                // 拍子変更のカット
                int[] barcounts = new int[AppManager.getSelectedTimesigCount()];
                int[] numerators = new int[AppManager.getSelectedTimesigCount()];
                int[] denominators = new int[AppManager.getSelectedTimesigCount()];
                int count = -1;
                for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                    int key = item.getKey();
                    SelectedTimesigEntry value = item.getValue();
                    count++;
                    barcounts[count] = value.original.BarCount;
                    numerators[count] = -1;
                    denominators[count] = -1;
                }
                CadenciiCommand run = new CadenciiCommand(
                    VsqCommand.generateCommandUpdateTimesigRange( barcounts, barcounts, numerators, denominators ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                other_command_executed = true;
            }

            // 冒頭で作成した音符イベント削除以外に、コマンドが実行されなかった場合
            if ( delete_event != null && !other_command_executed ) {
                CadenciiCommand run = new CadenciiCommand( delete_event );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
            }

            refreshScreen();
        }

        public void copyCurveCor(
            int track,
            CurveType curve_type,
            int start,
            int end,
            Vector<BezierChain> copied_chain
        ) {
            for ( Iterator<BezierChain> itr = AppManager.getVsqFile().AttachedCurves.get( track - 1 ).get( curve_type ).iterator(); itr.hasNext(); ) {
                BezierChain bc = itr.next();
                int len = bc.points.size();
                if ( len < 2 ) {
                    continue;
                }
                int chain_start = (int)bc.points.get( 0 ).getBase().getX();
                int chain_end = (int)bc.points.get( len - 1 ).getBase().getX();
                BezierChain add = null;
                if ( start < chain_start && chain_start < end && end < chain_end ) {
                    // (1) chain_start ~ end をコピー
                    try {
                        add = bc.extractPartialBezier( chain_start, end );
                    } catch ( Exception ex ) {
                        add = null;
                    }
                } else if ( chain_start <= start && end <= chain_end ) {
                    // (2) start ~ endをコピー
                    try {
                        add = bc.extractPartialBezier( start, end );
                    } catch ( Exception ex ) {
                        add = null;
                    }
                } else if ( chain_start < start && start < chain_end && chain_end <= end ) {
                    // (3) start ~ chain_endをコピー
                    try {
                        add = bc.extractPartialBezier( start, chain_end );
                    } catch ( Exception ex ) {
                        add = null;
                    }
                } else if ( start <= chain_start && chain_end <= end ) {
                    // (4) 全部コピーでOK
                    add = (BezierChain)bc.clone();
                }
                if ( add != null ) {
                    copied_chain.add( add );
                }
            }
        }
        #endregion

        #region トラックの編集関連
        public void copyTrackCore() {
            VsqFileEx vsq = AppManager.getVsqFile();
            int selected = AppManager.getSelected();
            VsqTrack track = (VsqTrack)vsq.Track.get( selected ).clone();
            track.setName( track.getName() + " (1)" );
            CadenciiCommand run = VsqFileEx.generateCommandAddTrack( track,
                                                                     vsq.Mixer.Slave.get( selected - 1 ),
                                                                     vsq.Track.size(),
                                                                     vsq.AttachedCurves.get( selected - 1 ) ); ;
            AppManager.register( vsq.executeCommand( run ) );
            setEdited( true );
            AppManager.mixerWindow.updateStatus();
            refreshScreen();
        }

        public void changeTrackNameCore() {
            if ( m_txtbox_track_name != null ) {
#if !JAVA
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
#endif
                m_txtbox_track_name = null;
            }
#if JAVA
            m_txtbox_track_name = new LyricTextBox( this );
#else
            m_txtbox_track_name = new LyricTextBox();
#endif
            m_txtbox_track_name.setVisible( false );
            int selector_width = trackSelector.getSelectorWidth();
            int x = AppManager.keyWidth + (AppManager.getSelected() - 1) * selector_width;
            m_txtbox_track_name.setLocation( x, trackSelector.getHeight() - TrackSelector.OFFSET_TRACK_TAB + 1 );
            m_txtbox_track_name.setText( AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getName() );
#if JAVA
            m_txtbox_track_name.keyUpEvent.add( new BKeyEventHandler( this, "m_txtbox_track_name_KeyUp" ) );
#else
            m_txtbox_track_name.BorderStyle = System.Windows.Forms.BorderStyle.None;
            m_txtbox_track_name.KeyUp += new System.Windows.Forms.KeyEventHandler( m_txtbox_track_name_KeyUp );
            m_txtbox_track_name.Parent = trackSelector;
#endif
            m_txtbox_track_name.setSize( selector_width, TrackSelector.OFFSET_TRACK_TAB );
            m_txtbox_track_name.setVisible( true );
            m_txtbox_track_name.requestFocus();
            m_txtbox_track_name.selectAll();
        }

        public void deleteTrackCore() {
            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( AppManager.showMessageBox(
                    PortUtil.formatMessage( _( "Do you wish to remove track? {0} : '{1}'" ), selected, vsq.Track.get( selected ).getName() ),
                    _APP_NAME,
                    org.kbinani.windows.forms.Utility.MSGBOX_YES_NO_OPTION,
                    org.kbinani.windows.forms.Utility.MSGBOX_QUESTION_MESSAGE ) == BDialogResult.YES ) {
                CadenciiCommand run = VsqFileEx.generateCommandDeleteTrack( selected );
                if ( selected >= 2 ) {
                    AppManager.setSelected( selected - 1 );
                }
                AppManager.register( vsq.executeCommand( run ) );
                updateDrawObjectList();
                setEdited( true );
                AppManager.mixerWindow.updateStatus();
                refreshScreen();
            }
        }

        public void addTrackCore() {
            VsqFileEx vsq = AppManager.getVsqFile();
            int i = vsq.Track.size();
            String name = "Voice" + i;
            String singer = AppManager.editorConfig.DefaultSingerName;
            VsqTrack vsq_track = new VsqTrack( name, singer );
            
            RendererKind kind = AppManager.editorConfig.DefaultSynthesizer;
            String renderer = AppManager.getVersionStringFromRendererKind( kind );
            Vector<VsqID> singers = AppManager.getSingerListFromRendererKind( kind );

            vsq_track.changeRenderer( renderer, singers );
            CadenciiCommand run = VsqFileEx.generateCommandAddTrack( vsq_track,
                                                                     new VsqMixerEntry( 0, 0, 0, 0 ),
                                                                     i,
                                                                     new BezierCurves() );
            AppManager.register( vsq.executeCommand( run ) );
            updateDrawObjectList();
            setEdited( true );
            AppManager.setSelected( i );
            AppManager.mixerWindow.updateStatus();
            refreshScreen();
        }
        #endregion

        /// <summary>
        /// length, positionの各Quantizeモードに応じて、表示状態を更新します
        /// </summary>
        public void applyQuantizeMode() {
            cMenuPianoQuantize04.setSelected( false );
            cMenuPianoQuantize08.setSelected( false );
            cMenuPianoQuantize16.setSelected( false );
            cMenuPianoQuantize32.setSelected( false );
            cMenuPianoQuantize64.setSelected( false );
            cMenuPianoQuantize128.setSelected( false );
            cMenuPianoQuantizeOff.setSelected( false );

#if ENABLE_STRIP_DROPDOWN
            stripDDBtnQuantize04.setSelected( false );
            stripDDBtnQuantize08.setSelected( false );
            stripDDBtnQuantize16.setSelected( false );
            stripDDBtnQuantize32.setSelected( false );
            stripDDBtnQuantize64.setSelected( false );
            stripDDBtnQuantize128.setSelected( false );
            stripDDBtnQuantizeOff.setSelected( false );
#endif

            menuSettingPositionQuantize04.setSelected( false );
            menuSettingPositionQuantize08.setSelected( false );
            menuSettingPositionQuantize16.setSelected( false );
            menuSettingPositionQuantize32.setSelected( false );
            menuSettingPositionQuantize64.setSelected( false );
            menuSettingPositionQuantize128.setSelected( false );
            menuSettingPositionQuantizeOff.setSelected( false );

#if !JAVA
            stripDDBtnQuantize.setText( "QUANTIZE " + QuantizeModeUtil.getString( AppManager.editorConfig.getPositionQuantize() ) );
#endif
            if ( AppManager.editorConfig.getPositionQuantize() == QuantizeMode.p4 ) {
                cMenuPianoQuantize04.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnQuantize04.setSelected( true );
#endif
                menuSettingPositionQuantize04.setSelected( true );
            } else if ( AppManager.editorConfig.getPositionQuantize() == QuantizeMode.p8 ) {
                cMenuPianoQuantize08.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnQuantize08.setSelected( true );
#endif
                menuSettingPositionQuantize08.setSelected( true );
            } else if ( AppManager.editorConfig.getPositionQuantize() == QuantizeMode.p16 ) {
                cMenuPianoQuantize16.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnQuantize16.setSelected( true );
#endif
                menuSettingPositionQuantize16.setSelected( true );
            } else if ( AppManager.editorConfig.getPositionQuantize() == QuantizeMode.p32 ) {
                cMenuPianoQuantize32.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnQuantize32.setSelected( true );
#endif
                menuSettingPositionQuantize32.setSelected( true );
            } else if ( AppManager.editorConfig.getPositionQuantize() == QuantizeMode.p64 ) {
                cMenuPianoQuantize64.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnQuantize64.setSelected( true );
#endif
                menuSettingPositionQuantize64.setSelected( true );
            } else if ( AppManager.editorConfig.getPositionQuantize() == QuantizeMode.p128 ) {
                cMenuPianoQuantize128.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnQuantize128.setSelected( true );
#endif
                menuSettingPositionQuantize128.setSelected( true );
            } else if ( AppManager.editorConfig.getPositionQuantize() == QuantizeMode.off ) {
                cMenuPianoQuantizeOff.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnQuantizeOff.setSelected( true );
#endif
                menuSettingPositionQuantizeOff.setSelected( true );
            }
            cMenuPianoQuantizeTriplet.setSelected( AppManager.editorConfig.isPositionQuantizeTriplet() );
#if ENABLE_STRIP_DROPDOWN
            stripDDBtnQuantizeTriplet.setSelected( AppManager.editorConfig.isPositionQuantizeTriplet() );
#endif
            menuSettingPositionQuantizeTriplet.setSelected( AppManager.editorConfig.isPositionQuantizeTriplet() );

            cMenuPianoLength04.setSelected( false );
            cMenuPianoLength08.setSelected( false );
            cMenuPianoLength16.setSelected( false );
            cMenuPianoLength32.setSelected( false );
            cMenuPianoLength64.setSelected( false );
            cMenuPianoLength128.setSelected( false );
            cMenuPianoLengthOff.setSelected( false );

#if ENABLE_STRIP_DROPDOWN
            stripDDBtnLength04.setSelected( false );
            stripDDBtnLength08.setSelected( false );
            stripDDBtnLength16.setSelected( false );
            stripDDBtnLength32.setSelected( false );
            stripDDBtnLength64.setSelected( false );
            stripDDBtnLength128.setSelected( false );
            stripDDBtnLengthOff.setSelected( false );
#endif

            menuSettingLengthQuantize04.setSelected( false );
            menuSettingLengthQuantize08.setSelected( false );
            menuSettingLengthQuantize16.setSelected( false );
            menuSettingLengthQuantize32.setSelected( false );
            menuSettingLengthQuantize64.setSelected( false );
            menuSettingLengthQuantize128.setSelected( false );
            menuSettingLengthQuantizeOff.setSelected( false );

#if !JAVA
            stripDDBtnLength.setText( "LENGTH " + QuantizeModeUtil.getString( AppManager.editorConfig.getLengthQuantize() ) );
#endif
            if ( AppManager.editorConfig.getLengthQuantize() == QuantizeMode.p4 ) {
                cMenuPianoLength04.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnLength04.setSelected( true );
#endif
                menuSettingLengthQuantize04.setSelected( true );
            } else if ( AppManager.editorConfig.getLengthQuantize() == QuantizeMode.p8 ) {
                cMenuPianoLength08.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnLength08.setSelected( true );
#endif
                menuSettingLengthQuantize08.setSelected( true );
            } else if ( AppManager.editorConfig.getLengthQuantize() == QuantizeMode.p16 ) {
                cMenuPianoLength16.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnLength16.setSelected( true );
#endif
                menuSettingLengthQuantize16.setSelected( true );
            } else if ( AppManager.editorConfig.getLengthQuantize() == QuantizeMode.p32 ) {
                cMenuPianoLength32.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnLength32.setSelected( true );
#endif
                menuSettingLengthQuantize32.setSelected( true );
            } else if ( AppManager.editorConfig.getLengthQuantize() == QuantizeMode.p64 ) {
                cMenuPianoLength64.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnLength64.setSelected( true );
#endif
                menuSettingLengthQuantize64.setSelected( true );
            } else if ( AppManager.editorConfig.getLengthQuantize() == QuantizeMode.p128 ) {
                cMenuPianoLength128.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnLength128.setSelected( true );
#endif
                menuSettingLengthQuantize128.setSelected( true );
            } else if ( AppManager.editorConfig.getLengthQuantize() == QuantizeMode.off ) {
                cMenuPianoLengthOff.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnLengthOff.setSelected( true );
#endif
                menuSettingLengthQuantizeOff.setSelected( true );
            }
            cMenuPianoLengthTriplet.setSelected( AppManager.editorConfig.isLengthQuantizeTriplet() );
#if ENABLE_STRIP_DROPDOWN
            stripDDBtnLengthTriplet.setSelected( AppManager.editorConfig.isLengthQuantizeTriplet() );
#endif
            menuSettingLengthQuantizeTriplet.setSelected( AppManager.editorConfig.isLengthQuantizeTriplet() );
        }

        /// <summary>
        /// 現在選択されている編集ツールに応じて、メニューのチェック状態を更新します
        /// </summary>
        public void applySelectedTool() {
            EditTool tool = AppManager.getSelectedTool();

            int count = toolStripTool.getComponentCount();
            for ( int i = 0; i < count; i++ ) {
                Object tsi = toolStripTool.getComponentAtIndex( i );
                if ( tsi is BToolStripButton ) {
                    BToolStripButton tsb = (BToolStripButton)tsi;
                    Object tag = tsb.getTag();
                    if ( tag != null && tag is String ) {
#if ENABLE_SCRIPT
                        if ( tool == EditTool.PALETTE_TOOL ) {
                            String id = (String)tag;
                            tsb.setSelected( (AppManager.selectedPaletteTool.Equals( id )) );
                        } else
#endif
 {
                            tsb.setSelected( false );
                        }
                    }
                }
            }
            MenuElement[] items = cMenuTrackSelectorPaletteTool.getSubElements();
            foreach ( MenuElement tsi in items ) {
                if ( tsi is BMenuItem ) {
                    BMenuItem tsmi = (BMenuItem)tsi;
                    Object tag = tsmi.getTag();
                    if ( tag != null && tag is String ) {
#if ENABLE_SCRIPT
                        if ( tool == EditTool.PALETTE_TOOL ) {
                            String id = (String)tsmi.getTag();
                            tsmi.setSelected( (AppManager.selectedPaletteTool.Equals( id )) );
                        } else
#endif
 {
                            tsmi.setSelected( false );
                        }
                    }
                }
            }

            items = cMenuPianoPaletteTool.getSubElements();
            foreach ( MenuElement tsi in items ) {
                if ( tsi is BMenuItem ) {
                    BMenuItem tsmi = (BMenuItem)tsi;
                    Object tag = tsmi.getTag();
                    if ( tag != null && tag is String ) {
#if ENABLE_SCRIPT
                        if ( tool == EditTool.PALETTE_TOOL ) {
                            String id = (String)tsmi.getTag();
                            tsmi.setSelected( (AppManager.selectedPaletteTool.Equals( id )) );
                        } else
#endif
 {
                            tsmi.setSelected( false );
                        }
                    }
                }
            }

            EditTool selected_tool = AppManager.getSelectedTool();
            if ( selected_tool == EditTool.ARROW ) {
                cMenuPianoPointer.setSelected( true );
                cMenuPianoPencil.setSelected( false );
                cMenuPianoEraser.setSelected( false );

                cMenuTrackSelectorPointer.setSelected( true );
                cMenuTrackSelectorPencil.setSelected( false );
                cMenuTrackSelectorLine.setSelected( false );
                cMenuTrackSelectorEraser.setSelected( false );

                stripBtnPointer.setSelected( true );
                stripBtnPencil.setSelected( false );
                stripBtnLine.setSelected( false );
                stripBtnEraser.setSelected( false );
            } else if ( selected_tool == EditTool.PENCIL ) {
                cMenuPianoPointer.setSelected( false );
                cMenuPianoPencil.setSelected( true );
                cMenuPianoEraser.setSelected( false );

                cMenuTrackSelectorPointer.setSelected( false );
                cMenuTrackSelectorPencil.setSelected( true );
                cMenuTrackSelectorLine.setSelected( false );
                cMenuTrackSelectorEraser.setSelected( false );

                stripBtnPointer.setSelected( false );
                stripBtnPencil.setSelected( true );
                stripBtnLine.setSelected( false );
                stripBtnEraser.setSelected( false );
            } else if ( selected_tool == EditTool.ERASER ) {
                cMenuPianoPointer.setSelected( false );
                cMenuPianoPencil.setSelected( false );
                cMenuPianoEraser.setSelected( true );

                cMenuTrackSelectorPointer.setSelected( false );
                cMenuTrackSelectorPencil.setSelected( false );
                cMenuTrackSelectorLine.setSelected( false );
                cMenuTrackSelectorEraser.setSelected( true );

                stripBtnPointer.setSelected( false );
                stripBtnPencil.setSelected( false );
                stripBtnLine.setSelected( false );
                stripBtnEraser.setSelected( true );
            } else if ( selected_tool == EditTool.LINE ) {
                cMenuPianoPointer.setSelected( false );
                cMenuPianoPencil.setSelected( false );
                cMenuPianoEraser.setSelected( false );

                cMenuTrackSelectorPointer.setSelected( false );
                cMenuTrackSelectorPencil.setSelected( false );
                cMenuTrackSelectorLine.setSelected( true );
                cMenuTrackSelectorEraser.setSelected( false );

                stripBtnPointer.setSelected( false );
                stripBtnPencil.setSelected( false );
                stripBtnLine.setSelected( true );
                stripBtnEraser.setSelected( false );
#if ENABLE_SCRIPT
            } else if ( selected_tool == EditTool.PALETTE_TOOL ) {
                cMenuPianoPointer.setSelected( false );
                cMenuPianoPencil.setSelected( false );
                cMenuPianoEraser.setSelected( false );

                cMenuTrackSelectorPointer.setSelected( false );
                cMenuTrackSelectorPencil.setSelected( false );
                cMenuTrackSelectorLine.setSelected( false );
                cMenuTrackSelectorEraser.setSelected( false );

                stripBtnPointer.setSelected( false );
                stripBtnPencil.setSelected( false );
                stripBtnLine.setSelected( false );
                stripBtnEraser.setSelected( false );
#endif
            }
            cMenuPianoCurve.setSelected( AppManager.isCurveMode() );
            cMenuTrackSelectorCurve.setSelected( AppManager.isCurveMode() );
            stripBtnCurve.setSelected( AppManager.isCurveMode() );
        }

        /// <summary>
        /// 描画すべきオブジェクトのリスト，AppManager.drawObjectsを更新します
        /// </summary>
        public void updateDrawObjectList() {
            // AppManager.m_draw_objects
            if ( AppManager.drawObjects == null ) {
                AppManager.drawObjects = new Vector<Vector<DrawObject>>();
            }
            lock ( AppManager.drawObjects ) {
                if ( AppManager.getVsqFile() == null ) {
                    return;
                }
                for ( int i = 0; i < AppManager.drawStartIndex.Length; i++ ) {
                    AppManager.drawStartIndex[i] = 0;
                }
                if ( AppManager.drawObjects != null ) {
                    for ( Iterator<Vector<DrawObject>> itr = AppManager.drawObjects.iterator(); itr.hasNext(); ) {
                        Vector<DrawObject> list = itr.next();
                        list.clear();
                    }
                    AppManager.drawObjects.clear();
                }

                int xoffset = 6;// 6 + AppManager.keyWidth;
                int yoffset = 127 * AppManager.editorConfig.PxTrackHeight;
                float scalex = AppManager.getScaleX();
                Font SMALL_FONT = null;
                try {
                    SMALL_FONT = new Font( AppManager.editorConfig.ScreenFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE8 );
                    int track_height = AppManager.editorConfig.PxTrackHeight;
                    VsqFileEx vsq = AppManager.getVsqFile();
                    int track_count = vsq.Track.size();
                    for ( int track = 1; track < track_count; track++ ) {
                        VsqTrack vsq_track = vsq.Track.get( track );
                        Vector<DrawObject> tmp = new Vector<DrawObject>();

                        // 音符イベント
                        for ( Iterator<VsqEvent> itr = vsq_track.getEventIterator(); itr.hasNext(); ) {
                            VsqEvent ev = itr.next();
                            int timesig = ev.Clock;
                            if ( ev.ID.LyricHandle != null ) {
                                int length = ev.ID.getLength();
                                int note = ev.ID.Note;
                                int x = (int)(timesig * scalex + xoffset);
                                int y = -note * track_height + yoffset;
                                int lyric_width = (int)(length * scalex);
                                String lyric_jp = ev.ID.LyricHandle.L0.Phrase;
                                String lyric_en = ev.ID.LyricHandle.L0.getPhoneticSymbol();
                                String title = Utility.trimString( lyric_jp + " [" + lyric_en + "]", SMALL_FONT, lyric_width );
                                int accent = ev.ID.DEMaccent;
                                int px_vibrato_start = x + lyric_width;
                                int px_vibrato_end = x;
                                int px_vibrato_delay = lyric_width * 2;
                                int vib_delay = length;
                                if ( ev.ID.VibratoHandle != null ) {
                                    vib_delay = ev.ID.VibratoDelay;
                                    double rate = (double)vib_delay / (double)length;
                                    px_vibrato_delay = _PX_ACCENT_HEADER + (int)((lyric_width - _PX_ACCENT_HEADER) * rate);
                                }
                                VibratoBPList rate_bp = null;
                                VibratoBPList depth_bp = null;
                                int rate_start = 0;
                                int depth_start = 0;
                                if ( ev.ID.VibratoHandle != null ) {
                                    rate_bp = ev.ID.VibratoHandle.getRateBP();
                                    depth_bp = ev.ID.VibratoHandle.getDepthBP();
                                    rate_start = ev.ID.VibratoHandle.getStartRate();
                                    depth_start = ev.ID.VibratoHandle.getStartDepth();
                                }

                                // analyzed/のSTFが引き当てられるかどうか
                                boolean is_valid_for_straight = false;
                                // UTAUのWAVが引き当てられるかどうか
                                boolean is_valid_for_utau = false;
                                VsqEvent singer_at_clock = vsq_track.getSingerEventAt( timesig );
                                int program = singer_at_clock.ID.IconHandle.Program;
                                if ( 0 <= program && program < AppManager.editorConfig.UtauSingers.size() ) {
                                    SingerConfig sc = AppManager.editorConfig.UtauSingers.get( program );
                                    // 通常のUTAU音源
                                    if ( AppManager.utauVoiceDB.containsKey( sc.VOICEIDSTR ) ) {
                                        UtauVoiceDB db = AppManager.utauVoiceDB.get( sc.VOICEIDSTR );
                                        OtoArgs oa = db.attachFileNameFromLyric( lyric_jp );
                                        if ( oa.fileName == null ||
                                            (oa.fileName != null && oa.fileName.Equals( "" )) ) {
                                            is_valid_for_utau = false;
                                        } else {
                                            is_valid_for_utau = PortUtil.isFileExists( PortUtil.combinePath( sc.VOICEIDSTR, oa.fileName ) );
                                        }
                                    }
                                    // STRAIGHT用の解析音源
                                    String analyzed = PortUtil.combinePath( sc.VOICEIDSTR, "analyzed" );
#if DEBUG
                                    PortUtil.println( "FormMain#updateDrawObjectList; analyzed=" + analyzed + "; AppManager.utauVoiceDB.containsKey(analyzed)=" + AppManager.utauVoiceDB.containsKey( analyzed ) );
#endif
                                    if ( AppManager.utauVoiceDB.containsKey( analyzed ) ) {
                                        UtauVoiceDB db = AppManager.utauVoiceDB.get( analyzed );
                                        OtoArgs oa = db.attachFileNameFromLyric( lyric_jp );
#if DEBUG
                                        PortUtil.println( "FormMain#updateDrawObjectList; oa.fileName=" + oa.fileName );
#endif
                                        if ( oa.fileName == null ||
                                             (oa.fileName != null && oa.fileName.Equals( "" )) ) {
                                            is_valid_for_straight = false;
                                        } else {
                                            is_valid_for_straight = PortUtil.isFileExists( PortUtil.combinePath( analyzed, oa.fileName ) );
                                            if ( !is_valid_for_straight ) {
                                                // wavファイルが無くても、stfがあればokとする。
                                                is_valid_for_straight =
                                                    PortUtil.isFileExists(
                                                        PortUtil.combinePath(
                                                            analyzed,
                                                            PortUtil.getFileNameWithoutExtension( oa.fileName ) + ".stf" ) );
                                            }
                                        }
                                    }
                                }

                                //追加
                                tmp.add( new DrawObject( DrawObjectType.Note,
                                                         new Rectangle( x, y, lyric_width, track_height ),
                                                         title,
                                                         accent,
                                                         ev.InternalID,
                                                         px_vibrato_delay,
                                                         false,
                                                         ev.ID.LyricHandle.L0.PhoneticSymbolProtected,
                                                         rate_bp,
                                                         depth_bp,
                                                         rate_start,
                                                         depth_start,
                                                         ev.ID.Note,
                                                         ev.UstEvent.Envelope,
                                                         length,
                                                         timesig,
                                                         is_valid_for_utau,
                                                         is_valid_for_straight,
                                                         vib_delay ) );
                            }
                        }

                        // Dynaff, Crescendイベント
                        for ( Iterator<VsqEvent> itr = vsq_track.getDynamicsEventIterator(); itr.hasNext(); ) {
                            VsqEvent item = itr.next();
                            IconDynamicsHandle handle = item.ID.IconDynamicsHandle;
                            if ( handle == null ) {
                                continue;
                            }
                            int clock = item.Clock;
                            int length = item.ID.getLength();
                            if ( length <= 0 ) {
                                length = 1;
                            }
                            int raw_width = (int)(length * scalex);
                            DrawObjectType type = DrawObjectType.Note;
                            int width = 0;
                            String str = "";
                            if ( handle.isDynaffType() ) {
                                // 強弱記号
                                type = DrawObjectType.Dynaff;
                                width = AppManager.DYNAFF_ITEM_WIDTH;
                                int startDyn = handle.getStartDyn();
                                if ( startDyn == 120 ) {
                                    str = "fff";
                                } else if ( startDyn == 104 ) {
                                    str = "ff";
                                } else if ( startDyn == 88 ) {
                                    str = "f";
                                } else if ( startDyn == 72 ) {
                                    str = "mf";
                                } else if ( startDyn == 56 ) {
                                    str = "mp";
                                } else if ( startDyn == 40 ) {
                                    str = "p";
                                } else if ( startDyn == 24 ) {
                                    str = "pp";
                                } else if ( startDyn == 8 ) {
                                    str = "ppp";
                                } else {
                                    str = "?";
                                }
                            } else if ( handle.isCrescendType() ) {
                                // クレッシェンド
                                type = DrawObjectType.Crescend;
                                width = raw_width;
                                str = handle.IDS;
                            } else if ( handle.isDecrescendType() ) {
                                // デクレッシェンド
                                type = DrawObjectType.Decrescend;
                                width = raw_width;
                                str = handle.IDS;
                            }
                            if ( type == DrawObjectType.Note ) {
                                continue;
                            }
                            int note = item.ID.Note;
                            int x = (int)(clock * scalex + xoffset);
                            int y = -note * AppManager.editorConfig.PxTrackHeight + yoffset;
                            tmp.add( new DrawObject( type,
                                                     new Rectangle( x, y, width, track_height ),
                                                     str,
                                                     0,
                                                     item.InternalID,
                                                     0,
                                                     false,
                                                     false,
                                                     null,
                                                     null,
                                                     0,
                                                     0,
                                                     item.ID.Note,
                                                     null,
                                                     length,
                                                     clock,
                                                     true,
                                                     true,
                                                     length ) );
                        }

                        // 重複部分があるかどうかを判定
                        int count = tmp.size();
                        for ( int i = 0; i < count - 1; i++ ) {
                            DrawObject itemi = tmp.get( i );
                            DrawObjectType parent_type = itemi.type;
                            /*if ( itemi.type != DrawObjectType.Note ) {
                                continue;
                            }*/
                            boolean overwrapped = false;
                            int istart = itemi.clock;
                            int iend = istart + itemi.length;
                            if ( itemi.isOverlapped ) {
                                continue;
                            }
                            for ( int j = i + 1; j < count; j++ ) {
                                DrawObject itemj = tmp.get( j );
                                if ( (itemj.type == DrawObjectType.Note && parent_type != DrawObjectType.Note) ||
                                     (itemj.type != DrawObjectType.Note && parent_type == DrawObjectType.Note) ) {
                                    continue;
                                }
                                int jstart = itemj.clock;
                                int jend = jstart + itemj.length;
                                if ( jstart <= istart ) {
                                    if ( istart < jend ) {
                                        overwrapped = true;
                                        itemj.isOverlapped = true;
                                        // breakできない．2個以上の重複を検出する必要があるので．
                                    }
                                }
                                if ( istart <= jstart ) {
                                    if ( jstart < iend ) {
                                        overwrapped = true;
                                        itemj.isOverlapped = true;
                                    }
                                }
                            }
                            if ( overwrapped ) {
                                itemi.isOverlapped = true;
                            }
                        }
                        Collections.sort( tmp );
                        AppManager.drawObjects.add( tmp );
                    }
                } catch ( Exception ex ) {
                    PortUtil.stderr.println( "FormMain#updateDrawObjectList; ex=" + ex );
                } finally {
#if !JAVA
                    if ( SMALL_FONT != null ) {
                        SMALL_FONT.font.Dispose();
                    }
#endif
                }
            }
        }

        /// <summary>
        /// _editor_configのRecentFilesを元に，menuFileRecentのドロップダウンアイテムを更新します
        /// </summary>
        public void updateRecentFileMenu() {
            int added = 0;
            menuFileRecent.removeAll();
            if ( AppManager.editorConfig.RecentFiles != null ) {
                for ( int i = 0; i < AppManager.editorConfig.RecentFiles.size(); i++ ) {
                    String item = AppManager.editorConfig.RecentFiles.get( i );
                    if ( item == null ) {
                        continue;
                    }
                    if ( item != "" ) {
                        String short_name = PortUtil.getFileName( item );
                        boolean available = PortUtil.isFileExists( item );
                        BMenuItem itm = new BMenuItem();
                        itm.setText( short_name );
                        if ( !available ) {
                            itm.setToolTipText( _( "[file not found]" ) + " " );
                        }
                        itm.setToolTipText( itm.getToolTipText() + item );
                        itm.setTag( item );
                        itm.setEnabled( available );
#if JAVA
                        itm.clickEvent.add( new BEventHandler( this, "handleRecentFileMenuItem_Click" ) );
                        itm.mouseEnterEvent.add( new BEventHandler( this, "handleRecentFileMenuItem_MouseEnter" ) );
#else
                        itm.Click += new EventHandler( handleRecentFileMenuItem_Click );
                        itm.MouseEnter += new EventHandler( handleRecentFileMenuItem_MouseEnter );
#endif
                        menuFileRecent.add( itm );
                        added++;
                    }
                }
            } else {
                AppManager.editorConfig.pushRecentFiles( "" );
            }
            if ( added == 0 ) {
                menuFileRecent.setEnabled( false );
            } else {
                menuFileRecent.setEnabled( true );
            }
        }

        /// <summary>
        /// 最後に保存したときから変更されているかどうかを取得または設定します
        /// </summary>
        public boolean isEdited() {
            return m_edited;
        }

        public void setEdited( boolean value ) {
            m_edited = value;
            String file = AppManager.getFileName();
            if ( file.Equals( "" ) ) {
                file = "Untitled";
            } else {
                file = PortUtil.getFileNameWithoutExtension( file );
            }
            if ( m_edited ) {
                file += " *";
            }
            String title = file + " - " + _APP_NAME;
            if ( !getTitle().Equals( title ) ) {
                setTitle( title );
            }
            boolean redo = AppManager.isRedoAvailable();
            boolean undo = AppManager.isUndoAvailable();
            menuEditRedo.setEnabled( redo );
            menuEditUndo.setEnabled( undo );
            cMenuPianoRedo.setEnabled( redo );
            cMenuPianoUndo.setEnabled( undo );
            cMenuTrackSelectorRedo.setEnabled( redo );
            cMenuTrackSelectorUndo.setEnabled( undo );
            stripBtnUndo.setEnabled( undo );
            stripBtnRedo.setEnabled( redo );
            //AppManager.setRenderRequired( AppManager.getSelected(), true );
            if ( AppManager.getVsqFile() != null ) {
                int draft = AppManager.getVsqFile().TotalClocks;
#if DEBUG
                PortUtil.println( "FormMain#setEdited; total_clocks=" + draft );
#endif
                setHScrollRange( draft );
            }
            updateDrawObjectList();

#if ENABLE_PROPERTY
            AppManager.propertyPanel.UpdateValue( AppManager.getSelected() );
#endif
        }

        /// <summary>
        /// 入力用のテキストボックスを初期化します
        /// </summary>
        public void showInputTextBox( String phrase, String phonetic_symbol, Point position, boolean phonetic_symbol_edit_mode ) {
#if DEBUG
            AppManager.debugWriteLine( "InitializeInputTextBox" );
#endif
            hideInputTextBox();
            
            AppManager.inputTextBox.keyUpEvent.add( new BKeyEventHandler( this, "m_input_textbox_KeyUp" ) );
            AppManager.inputTextBox.keyDownEvent.add( new BKeyEventHandler( this, "m_input_textbox_KeyDown" ) );
#if JAVA
            //TODO: FormMain#showInputTextBox
#else
            AppManager.inputTextBox.ImeModeChanged += m_input_textbox_ImeModeChanged;
#endif

            AppManager.inputTextBox.setImeModeOn( m_last_is_imemode_on );
            if ( phonetic_symbol_edit_mode ) {
                AppManager.inputTextBox.setBufferText( phrase );
                AppManager.inputTextBox.setPhoneticSymbolEditMode( true );
                AppManager.inputTextBox.setText( phonetic_symbol );
                AppManager.inputTextBox.setBackground( s_txtbox_backcolor );
            } else {
                AppManager.inputTextBox.setBufferText( phonetic_symbol );
                AppManager.inputTextBox.setPhoneticSymbolEditMode( false );
                AppManager.inputTextBox.setText( phrase );
                AppManager.inputTextBox.setBackground( Color.white );
            }
            AppManager.inputTextBox.setFont( new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE9 ) );
            AppManager.inputTextBox.setLocation( position.x + 4, position.y + 2 );
#if !JAVA
            AppManager.inputTextBox.Parent = pictPianoRoll;
#endif
            AppManager.inputTextBox.setEnabled( true );
            AppManager.inputTextBox.setVisible( true );
            AppManager.inputTextBox.requestFocusInWindow();
            AppManager.inputTextBox.selectAll();
        }

        public void hideInputTextBox() {
            AppManager.inputTextBox.keyUpEvent.remove( new BKeyEventHandler( this, "m_input_textbox_KeyUp" ) );
            AppManager.inputTextBox.keyDownEvent.remove( new BKeyEventHandler( this, "m_input_textbox_KeyDown" ) );
#if JAVA
            // TODO: FormMain#hideInputTextBox
            /*AppManager.inputTextBox.ImeModeChanged -= m_input_textbox_ImeModeChanged;*/
#else
            AppManager.inputTextBox.ImeModeChanged -= m_input_textbox_ImeModeChanged;
#endif
            m_last_symbol_edit_mode = AppManager.inputTextBox.isPhoneticSymbolEditMode();
            AppManager.inputTextBox.setVisible( false );
#if !JAVA
            AppManager.inputTextBox.Parent = null;
#endif
            AppManager.inputTextBox.setEnabled( false );
            pictPianoRoll.requestFocus();
            numEnterKeyAfterHideInputTextBox = 0;
        }

        /// <summary>
        /// 歌詞入力用テキストボックスのモード（歌詞/発音記号）を切り替えます
        /// </summary>
        public void flipInputTextBoxMode() {
            String new_value = AppManager.inputTextBox.getText();
            if ( !AppManager.inputTextBox.isPhoneticSymbolEditMode() ) {
                AppManager.inputTextBox.setBackground( s_txtbox_backcolor );
            } else {
                AppManager.inputTextBox.setBackground( Color.white );
            }
            AppManager.inputTextBox.setText( AppManager.inputTextBox.getBufferText() );
            AppManager.inputTextBox.setBufferText( new_value );
            AppManager.inputTextBox.setPhoneticSymbolEditMode( !AppManager.inputTextBox.isPhoneticSymbolEditMode() );
        }

        /// <summary>
        /// アンドゥ処理を行います
        /// </summary>
        public void undo() {
            if ( AppManager.isUndoAvailable() ) {
                AppManager.undo();
                menuEditRedo.setEnabled( AppManager.isRedoAvailable() );
                menuEditUndo.setEnabled( AppManager.isUndoAvailable() );
                cMenuPianoRedo.setEnabled( AppManager.isRedoAvailable() );
                cMenuPianoUndo.setEnabled( AppManager.isUndoAvailable() );
                cMenuTrackSelectorRedo.setEnabled( AppManager.isRedoAvailable() );
                cMenuTrackSelectorUndo.setEnabled( AppManager.isUndoAvailable() );
                AppManager.mixerWindow.updateStatus();
                setEdited( true );
                updateDrawObjectList();

#if ENABLE_PROPERTY
                if ( AppManager.propertyPanel != null ) {
                    AppManager.propertyPanel.UpdateValue( AppManager.getSelected() );
                }
#endif
            }
        }

        /// <summary>
        /// リドゥ処理を行います
        /// </summary>
        public void redo() {
            if ( AppManager.isRedoAvailable() ) {
                AppManager.redo();
                menuEditRedo.setEnabled( AppManager.isRedoAvailable() );
                menuEditUndo.setEnabled( AppManager.isUndoAvailable() );
                cMenuPianoRedo.setEnabled( AppManager.isRedoAvailable() );
                cMenuPianoUndo.setEnabled( AppManager.isUndoAvailable() );
                cMenuTrackSelectorRedo.setEnabled( AppManager.isRedoAvailable() );
                cMenuTrackSelectorUndo.setEnabled( AppManager.isUndoAvailable() );
                AppManager.mixerWindow.updateStatus();
                setEdited( true );
                updateDrawObjectList();

#if ENABLE_PROPERTY
                if ( AppManager.propertyPanel != null ) {
                    AppManager.propertyPanel.UpdateValue( AppManager.getSelected() );
                }
#endif
            }
        }

        /// <summary>
        /// 現在表示されているピアノロール画面の右上の、仮想スクリーン上座標で見たときのy座標(pixel)を取得します
        /// </summary>
        private int calculateStartToDrawY() {
            return (int)((128 * AppManager.editorConfig.PxTrackHeight - vScroll.getHeight()) * (float)vScroll.getValue() / ((float)vScroll.getMaximum()));
        }

        public void openVsqCor( String file ) {
            AppManager.readVsq( file );
            if ( AppManager.getVsqFile().Track.size() >= 2 ) {
                AppManager.setBaseTempo( AppManager.getVsqFile().getBaseTempo() );
                setHScrollRange( AppManager.getVsqFile().TotalClocks );
            }
            AppManager.editorConfig.pushRecentFiles( file );
            updateRecentFileMenu();
            setEdited( false );
            AppManager.clearCommandBuffer();
            AppManager.mixerWindow.updateStatus();
        }

        public void updateMenuFonts() {
            if ( AppManager.editorConfig.BaseFontName.Equals( "" ) ) {
                return;
            }
            Font font = AppManager.editorConfig.getBaseFont();
            Util.applyFontRecurse( this, font );
            Util.applyContextMenuFontRecurse( cMenuPiano, font );
            Util.applyContextMenuFontRecurse( cMenuTrackSelector, font );
            if ( AppManager.mixerWindow != null ) {
                Util.applyFontRecurse( AppManager.mixerWindow, font );
            }
            Util.applyContextMenuFontRecurse( cMenuTrackTab, font );
            trackSelector.applyFont( font );
            Util.applyToolStripFontRecurse( menuFile, font );
            Util.applyToolStripFontRecurse( menuEdit, font );
            Util.applyToolStripFontRecurse( menuVisual, font );
            Util.applyToolStripFontRecurse( menuJob, font );
            Util.applyToolStripFontRecurse( menuTrack, font );
            Util.applyToolStripFontRecurse( menuLyric, font );
            Util.applyToolStripFontRecurse( menuScript, font );
            Util.applyToolStripFontRecurse( menuSetting, font );
            Util.applyToolStripFontRecurse( menuHelp, font );
            Util.applyFontRecurse( toolStripFile, font );
            Util.applyFontRecurse( toolStripMeasure, font );
            Util.applyFontRecurse( toolStripPosition, font );
            Util.applyFontRecurse( toolStripTool, font );
            if ( m_preference_dlg != null ) {
                Util.applyFontRecurse( m_preference_dlg, font );
            }

            AppManager.baseFont10Bold = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.BOLD, AppManager.FONT_SIZE10 );
            AppManager.baseFont8 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE8 );
            AppManager.baseFont10 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE10 );
            AppManager.baseFont9 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE9 );
            AppManager.baseFont50Bold = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.BOLD, AppManager.FONT_SIZE50 );
            AppManager.baseFont10OffsetHeight = Util.getStringDrawOffset( AppManager.baseFont10 );
            AppManager.baseFont8OffsetHeight = Util.getStringDrawOffset( AppManager.baseFont8 );
            AppManager.baseFont9OffsetHeight = Util.getStringDrawOffset( AppManager.baseFont9 );
            AppManager.baseFont50OffsetHeight = Util.getStringDrawOffset( AppManager.baseFont50Bold );
            AppManager.baseFont8Height = Util.measureString( Util.PANGRAM, AppManager.baseFont8 ).height;
            AppManager.baseFont9Height = Util.measureString( Util.PANGRAM, AppManager.baseFont9 ).height;
            AppManager.baseFont10Height = Util.measureString( Util.PANGRAM, AppManager.baseFont10 ).height;
            AppManager.baseFont50Height = Util.measureString( Util.PANGRAM, AppManager.baseFont50Bold ).height;
        }

        public void picturePositionIndicatorDrawTo( java.awt.Graphics g1 ) {
            Graphics2D g = (Graphics2D)g1;
            Font SMALL_FONT = AppManager.baseFont8;
            int small_font_offset = AppManager.baseFont8OffsetHeight;
            try {
                int width = picturePositionIndicator.getWidth();
                int height = picturePositionIndicator.getHeight();
                VsqFileEx vsq = AppManager.getVsqFile();

                #region 小節ごとの線
                int dashed_line_step = AppManager.getPositionQuantizeClock();
                for ( Iterator<VsqBarLineType> itr = vsq.getBarLineIterator( AppManager.clockFromXCoord( width ) ); itr.hasNext(); ) {
                    VsqBarLineType blt = itr.next();
                    int local_clock_step = 480 * 4 / blt.getLocalDenominator();
                    int x = AppManager.xCoordFromClocks( blt.clock() );
                    if ( blt.isSeparator() ) {
                        int current = blt.getBarCount() - vsq.getPreMeasure() + 1;
                        g.setColor( s_pen_105_105_105 );
                        g.drawLine( x, 0, x, 49 );
                        // 小節の数字
                        //g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
                        g.setColor( Color.black );
                        g.setFont( SMALL_FONT );
                        g.drawString( current + "", x + 4, 8 - small_font_offset + 1 );
                        //g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.Default;
                    } else {
                        g.setColor( s_pen_105_105_105 );
                        g.drawLine( x, 11, x, 16 );
                        g.drawLine( x, 26, x, 31 );
                        g.drawLine( x, 41, x, 46 );
                    }
                    if ( dashed_line_step > 1 && AppManager.isGridVisible() ) {
                        int numDashedLine = local_clock_step / dashed_line_step;
                        for ( int i = 1; i < numDashedLine; i++ ) {
                            int x2 = AppManager.xCoordFromClocks( blt.clock() + i * dashed_line_step );
                            g.setColor( s_pen_065_065_065 );
                            g.drawLine( x2, 9 + 5, x2, 14 + 3 );
                            g.drawLine( x2, 24 + 5, x2, 29 + 3 );
                            g.drawLine( x2, 39 + 5, x2, 44 + 3 );
                        }
                    }
                }
                #endregion

                if ( vsq != null ) {
                    #region 拍子の変更
                    int c = vsq.TimesigTable.size();
                    for ( int i = 0; i < c; i++ ) {
                        TimeSigTableEntry itemi = vsq.TimesigTable.get( i );
                        int clock = itemi.Clock;
                        int barcount = itemi.BarCount;
                        int x = AppManager.xCoordFromClocks( clock );
                        if ( width < x ) {
                            break;
                        }
                        String s = itemi.Numerator + "/" + itemi.Denominator;
                        g.setFont( SMALL_FONT );
                        if ( AppManager.isSelectedTimesigContains( barcount ) ) {
                            g.setColor( AppManager.getHilightColor() );
                            g.drawString( s, x + 4, 40 - small_font_offset + 1 );
                        } else {
                            g.setColor( Color.black );
                            g.drawString( s, x + 4, 40 - small_font_offset + 1 );
                        }

                        if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.TIMESIG ) {
                            if ( AppManager.isSelectedTimesigContains( barcount ) ) {
                                int edit_clock_x = AppManager.xCoordFromClocks( vsq.getClockFromBarCount( AppManager.getSelectedTimesig( barcount ).editing.BarCount ) );
                                g.setColor( s_pen_187_187_255 );
                                g.drawLine( edit_clock_x - 1, 32,
                                            edit_clock_x - 1, picturePositionIndicator.getHeight() - 1 );
                                g.setColor( s_pen_007_007_151 );
                                g.drawLine( edit_clock_x, 32,
                                            edit_clock_x, picturePositionIndicator.getHeight() - 1 );
                            }
                        }
                    }
                    #endregion

                    #region テンポの変更
                    g.setFont( SMALL_FONT );
                    c = vsq.TempoTable.size();
                    for ( int i = 0; i < c; i++ ) {
                        TempoTableEntry itemi = vsq.TempoTable.get( i );
                        int clock = itemi.Clock;
                        int x = AppManager.xCoordFromClocks( clock );
                        if ( width < x ) {
                            break;
                        }
                        String s = PortUtil.formatDecimal( "#.00", 60e6 / (float)itemi.Tempo );
                        if ( AppManager.isSelectedTempoContains( clock ) ) {
                            g.setColor( AppManager.getHilightColor() );
                            g.drawString( s, x + 4, 24 - small_font_offset + 1 );
                        } else {
                            g.setColor( Color.black );
                            g.drawString( s, x + 4, 24 - small_font_offset + 1 );
                        }

                        if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.TEMPO ) {
                            if ( AppManager.isSelectedTempoContains( clock ) ) {
                                int edit_clock_x = AppManager.xCoordFromClocks( AppManager.getSelectedTempo( clock ).editing.Clock );
                                g.setColor( s_pen_187_187_255 );
                                g.drawLine( edit_clock_x - 1, 18,
                                            edit_clock_x - 1, 32 );
                                g.setColor( s_pen_007_007_151 );
                                g.drawLine( edit_clock_x, 18,
                                            edit_clock_x, 32 );
                            }
                        }
                    }
                    #endregion
                }

                #region 現在のマーカー
                float xoffset = AppManager.keyWidth + AppManager.keyOffset - AppManager.getStartToDrawX();
                int marker_x = (int)(AppManager.getCurrentClock() * AppManager.getScaleX() + xoffset);
                if ( AppManager.keyWidth <= marker_x && marker_x <= width ) {
                    g.setStroke( new BasicStroke( 2.0f ) );
                    g.setColor( Color.white );
                    g.drawLine( marker_x, 0, marker_x, height );
                    g.setStroke( new BasicStroke() );
                }
                if ( AppManager.startMarkerEnabled ) {
                    int x = AppManager.xCoordFromClocks( AppManager.startMarker );
                    g.drawImage(
                        Resources.get_start_marker(), x, 3, this );
                }
                if ( AppManager.endMarkerEnabled ) {
                    int x = AppManager.xCoordFromClocks( AppManager.endMarker ) - 6;
                    g.drawImage(
                        Resources.get_end_marker(), x, 3, this );
                }
                #endregion

                #region TEMPO & BEAT
                // TEMPO BEATの文字の部分。小節数が被っている可能性があるので、塗り潰す
                g.setColor( picturePositionIndicator.getBackground() );
                g.fillRect( 0, 0, AppManager.keyWidth, 48 );
                // 横ライン上
                g.setColor( new Color( 104, 104, 104 ) );
                g.drawLine( 0, 17, width, 17 );
                // 横ライン中央
                g.drawLine( 0, 32, width, 32 );
                // 横ライン下
                g.drawLine( 0, 47, width, 47 );
                // 縦ライン
                g.drawLine( AppManager.keyWidth, 0, AppManager.keyWidth, 48 );
                /* TEMPO&BEATとピアノロールの境界 */
                g.drawLine( AppManager.keyWidth, 48, width - 18, 48 );
                g.setFont( SMALL_FONT );
                g.setColor( Color.black );
                g.drawString( "TEMPO", 11, 24 - small_font_offset + 1 );
                g.drawString( "BEAT", 11, 40 - small_font_offset + 1 );
                #endregion
            } catch ( Exception ex ) {
                PortUtil.stderr.println( "FormMain#picturePositionIndicatorDrawTo; ex=" + ex );
            }
        }

        public void overviewStopThread() {
            if ( m_overview_update_thread != null ) {
                try {
#if JAVA
                    m_overview_update_thread.stop();
                    while( m_overview_update_thread.isAlive() ){
                        Thread.sleep( 0 );
                    }
#else
                    m_overview_update_thread.Abort();
                    while ( m_overview_update_thread != null && m_overview_update_thread.IsAlive ) {
                        System.Windows.Forms.Application.DoEvents();
                    }
#endif
                } catch ( Exception ex ) {
                }
                m_overview_update_thread = null;
            }
        }

        public void registerEventHandlers() {
            loadEvent.add( new BEventHandler( this, "FormMain_Load" ) );
            menuStripMain.mouseDownEvent.add( new BMouseEventHandler( this, "menuStrip1_MouseDown" ) );
            menuFileNew.mouseEnterEvent.add( new BEventHandler( this, "menuFileNew_MouseEnter" ) );
            menuFileNew.clickEvent.add( new BEventHandler( this, "commonFileNew_Click" ) );
            menuFileOpen.mouseEnterEvent.add( new BEventHandler( this, "menuFileOpen_MouseEnter" ) );
            menuFileOpen.clickEvent.add( new BEventHandler( this, "commonFileOpen_Click" ) );
            menuFileSave.mouseEnterEvent.add( new BEventHandler( this, "menuFileSave_MouseEnter" ) );
            menuFileSave.clickEvent.add( new BEventHandler( this, "commonFileSave_Click" ) );
            menuFileSaveNamed.mouseEnterEvent.add( new BEventHandler( this, "menuFileSaveNamed_MouseEnter" ) );
            menuFileSaveNamed.clickEvent.add( new BEventHandler( this, "menuFileSaveNamed_Click" ) );
            menuFileOpenVsq.mouseEnterEvent.add( new BEventHandler( this, "menuFileOpenVsq_MouseEnter" ) );
            menuFileOpenVsq.clickEvent.add( new BEventHandler( this, "menuFileOpenVsq_Click" ) );
            menuFileOpenUst.mouseEnterEvent.add( new BEventHandler( this, "menuFileOpenUst_MouseEnter" ) );
            menuFileOpenUst.clickEvent.add( new BEventHandler( this, "menuFileOpenUst_Click" ) );
            menuFileImport.mouseEnterEvent.add( new BEventHandler( this, "menuFileImport_MouseEnter" ) );
            menuFileImportVsq.mouseEnterEvent.add( new BEventHandler( this, "menuFileImportVsq_MouseEnter" ) );
            menuFileImportVsq.clickEvent.add( new BEventHandler( this, "menuFileImportVsq_Click" ) );
            menuFileImportMidi.mouseEnterEvent.add( new BEventHandler( this, "menuFileImportMidi_MouseEnter" ) );
            menuFileImportMidi.clickEvent.add( new BEventHandler( this, "menuFileImportMidi_Click" ) );
            menuFileExport.dropDownOpeningEvent.add( new BEventHandler( this, "menuFileExport_DropDownOpening" ) );
            menuFileExportWave.mouseEnterEvent.add( new BEventHandler( this, "menuFileExportWave_MouseEnter" ) );
            menuFileExportWave.clickEvent.add( new BEventHandler( this, "menuFileExportWave_Click" ) );
            menuFileExportMidi.mouseEnterEvent.add( new BEventHandler( this, "menuFileExportMidi_MouseEnter" ) );
            menuFileExportMidi.clickEvent.add( new BEventHandler( this, "menuFileExportMidi_Click" ) );
            menuFileExportMusicXml.clickEvent.add( new BEventHandler( this, "menuFileExportMusicXml_Click" ) );
            menuFileRecent.mouseEnterEvent.add( new BEventHandler( this, "menuFileRecent_MouseEnter" ) );
            menuFileQuit.mouseEnterEvent.add( new BEventHandler( this, "menuFileQuit_MouseEnter" ) );
            menuFileQuit.clickEvent.add( new BEventHandler( this, "menuFileQuit_Click" ) );
            menuEdit.dropDownOpeningEvent.add( new BEventHandler( this, "menuEdit_DropDownOpening" ) );
            menuEditUndo.mouseEnterEvent.add( new BEventHandler( this, "menuEditUndo_MouseEnter" ) );
            menuEditUndo.clickEvent.add( new BEventHandler( this, "commonEditUndo_Click" ) );
            menuEditRedo.mouseEnterEvent.add( new BEventHandler( this, "menuEditRedo_MouseEnter" ) );
            menuEditRedo.clickEvent.add( new BEventHandler( this, "commonEditRedo_Click" ) );
            menuEditCut.mouseEnterEvent.add( new BEventHandler( this, "menuEditCut_MouseEnter" ) );
            menuEditCut.clickEvent.add( new BEventHandler( this, "commonEditCut_Click" ) );
            menuEditCopy.mouseEnterEvent.add( new BEventHandler( this, "menuEditCopy_MouseEnter" ) );
            menuEditCopy.clickEvent.add( new BEventHandler( this, "commonEditCopy_Click" ) );
            menuEditPaste.mouseEnterEvent.add( new BEventHandler( this, "menuEditPaste_MouseEnter" ) );
            menuEditPaste.clickEvent.add( new BEventHandler( this, "commonEditPaste_Click" ) );
            menuEditDelete.mouseEnterEvent.add( new BEventHandler( this, "menuEditDelete_MouseEnter" ) );
            menuEditDelete.clickEvent.add( new BEventHandler( this, "menuEditDelete_Click" ) );
            menuEditAutoNormalizeMode.mouseEnterEvent.add( new BEventHandler( this, "menuEditAutoNormalizeMode_MouseEnter" ) );
            menuEditAutoNormalizeMode.clickEvent.add( new BEventHandler( this, "menuEditAutoNormalizeMode_Click" ) );
            menuEditSelectAll.mouseEnterEvent.add( new BEventHandler( this, "menuEditSelectAll_MouseEnter" ) );
            menuEditSelectAll.clickEvent.add( new BEventHandler( this, "menuEditSelectAll_Click" ) );
            menuEditSelectAllEvents.mouseEnterEvent.add( new BEventHandler( this, "menuEditSelectAllEvents_MouseEnter" ) );
            menuEditSelectAllEvents.clickEvent.add( new BEventHandler( this, "menuEditSelectAllEvents_Click" ) );
            menuVisualControlTrack.checkedChangedEvent.add( new BEventHandler( this, "menuVisualControlTrack_CheckedChanged" ) );
            menuVisualControlTrack.mouseEnterEvent.add( new BEventHandler( this, "menuVisualControlTrack_MouseEnter" ) );
            menuVisualMixer.mouseEnterEvent.add( new BEventHandler( this, "menuVisualMixer_MouseEnter" ) );
            menuVisualMixer.clickEvent.add( new BEventHandler( this, "menuVisualMixer_Click" ) );
            menuVisualWaveform.checkedChangedEvent.add( new BEventHandler( this, "menuVisualWaveform_CheckedChanged" ) );
            menuVisualWaveform.mouseEnterEvent.add( new BEventHandler( this, "menuVisualWaveform_MouseEnter" ) );
            menuVisualProperty.mouseEnterEvent.add( new BEventHandler( this, "menuVisualProperty_MouseEnter" ) );
            menuVisualProperty.clickEvent.add( new BEventHandler( this, "menuVisualProperty_Click" ) );
            menuVisualGridline.checkedChangedEvent.add( new BEventHandler( this, "menuVisualGridline_CheckedChanged" ) );
            menuVisualGridline.mouseEnterEvent.add( new BEventHandler( this, "menuVisualGridline_MouseEnter" ) );
            menuVisualIconPalette.clickEvent.add( new BEventHandler( this, "menuVisualIconPalette_Click" ) );
            menuVisualStartMarker.mouseEnterEvent.add( new BEventHandler( this, "menuVisualStartMarker_MouseEnter" ) );
            menuVisualStartMarker.clickEvent.add( new BEventHandler( this, "handleStartMarker_Click" ) );
            menuVisualEndMarker.mouseEnterEvent.add( new BEventHandler( this, "menuVisualEndMarker_MouseEnter" ) );
            menuVisualEndMarker.clickEvent.add( new BEventHandler( this, "handleEndMarker_Click" ) );
            menuVisualLyrics.checkedChangedEvent.add( new BEventHandler( this, "menuVisualLyrics_CheckedChanged" ) );
            menuVisualLyrics.mouseEnterEvent.add( new BEventHandler( this, "menuVisualLyrics_MouseEnter" ) );
            menuVisualNoteProperty.checkedChangedEvent.add( new BEventHandler( this, "menuVisualNoteProperty_CheckedChanged" ) );
            menuVisualNoteProperty.mouseEnterEvent.add( new BEventHandler( this, "menuVisualNoteProperty_MouseEnter" ) );
            menuVisualPitchLine.checkedChangedEvent.add( new BEventHandler( this, "menuVisualPitchLine_CheckedChanged" ) );
            menuVisualPitchLine.mouseEnterEvent.add( new BEventHandler( this, "menuVisualPitchLine_MouseEnter" ) );
            menuVisualPluginUi.dropDownOpeningEvent.add( new BEventHandler( this, "menuVisualPluginUi_DropDownOpening" ) );
            menuVisualPluginUiVocaloid100.clickEvent.add( new BEventHandler( this, "menuVisualPluginUiVocaloidCommon_Click" ) );
            menuVisualPluginUiVocaloid101.clickEvent.add( new BEventHandler( this, "menuVisualPluginUiVocaloidCommon_Click" ) );
            menuVisualPluginUiVocaloid2.clickEvent.add( new BEventHandler( this, "menuVisualPluginUiVocaloidCommon_Click" ) );
            menuVisualPluginUiAquesTone.clickEvent.add( new BEventHandler( this, "menuVisualPluginUiAquesTone_Click" ) );
            menuJob.dropDownOpeningEvent.add( new BEventHandler( this, "menuJob_DropDownOpening" ) );
            menuJobNormalize.mouseEnterEvent.add( new BEventHandler( this, "menuJobNormalize_MouseEnter" ) );
            menuJobNormalize.clickEvent.add( new BEventHandler( this, "menuJobNormalize_Click" ) );
            menuJobInsertBar.mouseEnterEvent.add( new BEventHandler( this, "menuJobInsertBar_MouseEnter" ) );
            menuJobInsertBar.clickEvent.add( new BEventHandler( this, "menuJobInsertBar_Click" ) );
            menuJobDeleteBar.mouseEnterEvent.add( new BEventHandler( this, "menuJobDeleteBar_MouseEnter" ) );
            menuJobDeleteBar.clickEvent.add( new BEventHandler( this, "menuJobDeleteBar_Click" ) );
            menuJobRandomize.mouseEnterEvent.add( new BEventHandler( this, "menuJobRandomize_MouseEnter" ) );
            menuJobRandomize.clickEvent.add( new BEventHandler( this, "menuJobRandomize_Click" ) );
            menuJobConnect.mouseEnterEvent.add( new BEventHandler( this, "menuJobConnect_MouseEnter" ) );
            menuJobConnect.clickEvent.add( new BEventHandler( this, "menuJobConnect_Click" ) );
            menuJobLyric.mouseEnterEvent.add( new BEventHandler( this, "menuJobLyric_MouseEnter" ) );
            menuJobLyric.clickEvent.add( new BEventHandler( this, "menuJobLyric_Click" ) );
            menuJobRewire.mouseEnterEvent.add( new BEventHandler( this, "menuJobRewire_MouseEnter" ) );
            menuJobRealTime.mouseEnterEvent.add( new BEventHandler( this, "menuJobRealTime_MouseEnter" ) );
            menuJobRealTime.clickEvent.add( new BEventHandler( this, "menuJobRealTime_Click" ) );
            menuJobReloadVsti.mouseEnterEvent.add( new BEventHandler( this, "menuJobReloadVsti_MouseEnter" ) );
            menuJobReloadVsti.clickEvent.add( new BEventHandler( this, "menuJobReloadVsti_Click" ) );
            menuTrack.dropDownOpeningEvent.add( new BEventHandler( this, "menuTrack_DropDownOpening" ) );
            menuTrackOn.mouseEnterEvent.add( new BEventHandler( this, "menuTrackOn_MouseEnter" ) );
            menuTrackOn.clickEvent.add( new BEventHandler( this, "commonTrackOn_Click" ) );
            menuTrackPlayAfterSynth.clickEvent.add( new BEventHandler( this, "commonPlayAfterSynth_Click" ) );
            menuTrackAdd.mouseEnterEvent.add( new BEventHandler( this, "menuTrackAdd_MouseEnter" ) );
            menuTrackAdd.clickEvent.add( new BEventHandler( this, "menuTrackAdd_Click" ) );
            menuTrackCopy.mouseEnterEvent.add( new BEventHandler( this, "menuTrackCopy_MouseEnter" ) );
            menuTrackCopy.clickEvent.add( new BEventHandler( this, "menuTrackCopy_Click" ) );
            menuTrackChangeName.mouseEnterEvent.add( new BEventHandler( this, "menuTrackChangeName_MouseEnter" ) );
            menuTrackChangeName.clickEvent.add( new BEventHandler( this, "menuTrackChangeName_Click" ) );
            menuTrackDelete.mouseEnterEvent.add( new BEventHandler( this, "menuTrackDelete_MouseEnter" ) );
            menuTrackDelete.clickEvent.add( new BEventHandler( this, "menuTrackDelete_Click" ) );
            menuTrackRenderCurrent.mouseEnterEvent.add( new BEventHandler( this, "menuTrackRenderCurrent_MouseEnter" ) );
            menuTrackRenderCurrent.clickEvent.add( new BEventHandler( this, "menuTrackRenderCurrent_Click" ) );
            menuTrackRenderAll.mouseEnterEvent.add( new BEventHandler( this, "menuTrackRenderAll_MouseEnter" ) );
            menuTrackRenderAll.clickEvent.add( new BEventHandler( this, "commonTrackRenderAll_Click" ) );
            menuTrackOverlay.mouseEnterEvent.add( new BEventHandler( this, "menuTrackOverlay_MouseEnter" ) );
            menuTrackOverlay.clickEvent.add( new BEventHandler( this, "menuTrackOverlay_Click" ) );
            menuTrackRenderer.mouseEnterEvent.add( new BEventHandler( this, "menuTrackRenderer_MouseEnter" ) );
            menuTrackRenderer.dropDownOpeningEvent.add( new BEventHandler( this, "menuTrackRenderer_DropDownOpening" ) );
            menuTrackRendererVOCALOID100.mouseEnterEvent.add( new BEventHandler( this, "menuTrackRendererVOCALOID1_MouseEnter" ) );
            menuTrackRendererVOCALOID100.clickEvent.add( new BEventHandler( this, "commonChangeRenderer" ) );
            menuTrackRendererVOCALOID101.clickEvent.add( new BEventHandler( this, "commonChangeRenderer" ) );
            menuTrackRendererVOCALOID2.mouseEnterEvent.add( new BEventHandler( this, "menuTrackRendererVOCALOID2_MouseEnter" ) );
            menuTrackRendererVOCALOID2.clickEvent.add( new BEventHandler( this, "commonChangeRenderer" ) );
            menuTrackRendererUtau.mouseEnterEvent.add( new BEventHandler( this, "menuTrackRendererUtau_MouseEnter" ) );
            menuTrackRendererUtau.clickEvent.add( new BEventHandler( this, "commonChangeRenderer" ) );
            menuTrackRendererStraight.clickEvent.add( new BEventHandler( this, "commonChangeRenderer" ) );
            menuTrackRendererAquesTone.clickEvent.add( new BEventHandler( this, "commonChangeRenderer" ) );
            menuTrackManager.clickEvent.add( new BEventHandler( this, "menuTrackManager_Click" ) );
            menuLyricExpressionProperty.clickEvent.add( new BEventHandler( this, "menuLyricExpressionProperty_Click" ) );
            menuLyricVibratoProperty.clickEvent.add( new BEventHandler( this, "menuLyricVibratoProperty_Click" ) );
            menuLyricDictionary.clickEvent.add( new BEventHandler( this, "menuLyricDictionary_Click" ) );
            menuLyricPhonemeTransformation.clickEvent.add( new BEventHandler( this, "menuLyricPhonemeTransformation_Click" ) );
            menuScriptUpdate.clickEvent.add( new BEventHandler( this, "menuScriptUpdate_Click" ) );
            menuSetting.dropDownOpeningEvent.add( new BEventHandler( this, "menuSetting_DropDownOpening" ) );
            menuSettingPreference.clickEvent.add( new BEventHandler( this, "menuSettingPreference_Click" ) );
            menuSettingGameControlerSetting.clickEvent.add( new BEventHandler( this, "menuSettingGameControlerSetting_Click" ) );
            menuSettingGameControlerLoad.clickEvent.add( new BEventHandler( this, "menuSettingGameControlerLoad_Click" ) );
            menuSettingGameControlerRemove.clickEvent.add( new BEventHandler( this, "menuSettingGameControlerRemove_Click" ) );
            menuSettingShortcut.clickEvent.add( new BEventHandler( this, "menuSettingShortcut_Click" ) );
#if ENABLE_MIDI
            menuSettingMidi.clickEvent.add( new BEventHandler( this, "menuSettingMidi_Click" ) );
#endif
            menuSettingUtauVoiceDB.clickEvent.add( new BEventHandler( this, "menuSettingUtauVoiceDB_Click" ) );
            menuSettingDefaultSingerStyle.clickEvent.add( new BEventHandler( this, "menuSettingDefaultSingerStyle_Click" ) );
            menuSettingPositionQuantize04.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            menuSettingPositionQuantize08.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            menuSettingPositionQuantize16.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            menuSettingPositionQuantize32.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            menuSettingPositionQuantize64.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            menuSettingPositionQuantize128.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            menuSettingPositionQuantizeOff.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            menuSettingPositionQuantizeTriplet.clickEvent.add( new BEventHandler( this, "h_positionQuantizeTriplet" ) );
            menuSettingLengthQuantize04.clickEvent.add( new BEventHandler( this, "h_lengthQuantize04" ) );
            menuSettingLengthQuantize08.clickEvent.add( new BEventHandler( this, "h_lengthQuantize08" ) );
            menuSettingLengthQuantize16.clickEvent.add( new BEventHandler( this, "h_lengthQuantize16" ) );
            menuSettingLengthQuantize32.clickEvent.add( new BEventHandler( this, "h_lengthQuantize32" ) );
            menuSettingLengthQuantize64.clickEvent.add( new BEventHandler( this, "h_lengthQuantize64" ) );
            menuSettingLengthQuantize128.clickEvent.add( new BEventHandler( this, "h_lengthQuantize128" ) );
            menuSettingLengthQuantizeOff.clickEvent.add( new BEventHandler( this, "h_lengthQuantizeOff" ) );
            menuSettingLengthQuantizeTriplet.clickEvent.add( new BEventHandler( this, "h_lengthQuantizeTriplet" ) );
            menuHelpAbout.clickEvent.add( new BEventHandler( this, "menuHelpAbout_Click" ) );
            menuHelpDebug.clickEvent.add( new BEventHandler( this, "menuHelpDebug_Click" ) );
            menuHiddenEditLyric.clickEvent.add( new BEventHandler( this, "menuHiddenEditLyric_Click" ) );
            menuHiddenEditFlipToolPointerPencil.clickEvent.add( new BEventHandler( this, "menuHiddenEditFlipToolPointerPencil_Click" ) );
            menuHiddenEditFlipToolPointerEraser.clickEvent.add( new BEventHandler( this, "menuHiddenEditFlipToolPointerEraser_Click" ) );
            menuHiddenVisualForwardParameter.clickEvent.add( new BEventHandler( this, "menuHiddenVisualForwardParameter_Click" ) );
            menuHiddenVisualBackwardParameter.clickEvent.add( new BEventHandler( this, "menuHiddenVisualBackwardParameter_Click" ) );
            menuHiddenTrackNext.clickEvent.add( new BEventHandler( this, "menuHiddenTrackNext_Click" ) );
            menuHiddenTrackBack.clickEvent.add( new BEventHandler( this, "menuHiddenTrackBack_Click" ) );
            menuHiddenCopy.clickEvent.add( new BEventHandler( this, "commonEditCopy_Click" ) );
            menuHiddenPaste.clickEvent.add( new BEventHandler( this, "commonEditPaste_Click" ) );
            menuHiddenCut.clickEvent.add( new BEventHandler( this, "commonEditCut_Click" ) );
            menuHiddenSelectBackward.clickEvent.add( new BEventHandler( this, "menuHiddenSelectBackward_Click" ) );
            menuHiddenSelectForward.clickEvent.add( new BEventHandler( this, "menuHiddenSelectForward_Click" ) );
            menuHiddenMoveUp.clickEvent.add( new BEventHandler( this, "menuHiddenMoveUp_Click" ) );
            menuHiddenMoveDown.clickEvent.add( new BEventHandler( this, "menuHiddenMoveDown_Click" ) );
            menuHiddenMoveLeft.clickEvent.add( new BEventHandler( this, "menuHiddenMoveLeft_Click" ) );
            menuHiddenMoveRight.clickEvent.add( new BEventHandler( this, "menuHiddenMoveRight_Click" ) );
            menuHiddenLengthen.clickEvent.add( new BEventHandler( this, "menuHiddenLengthen_Click" ) );
            menuHiddenShorten.clickEvent.add( new BEventHandler( this, "menuHiddenShorten_Click" ) );
            menuHiddenGoToEndMarker.clickEvent.add( new BEventHandler( this, "menuHiddenGoToEndMarker_Click" ) );
            menuHiddenGoToStartMarker.clickEvent.add( new BEventHandler( this, "menuHiddenGoToStartMarker_Click" ) );
            menuHiddenPlayFromStartMarker.clickEvent.add( new BEventHandler( this, "menuHiddenPlayFromStartMarker_Click" ) );
            menuHiddenFlipCurveOnPianorollMode.clickEvent.add( new BEventHandler( this, "menuHiddenFlipCurveOnPianorollMode_Click" ) );

            cMenuPiano.openingEvent.add( new BCancelEventHandler( this, "cMenuPiano_Opening" ) );
            cMenuPianoPointer.clickEvent.add( new BEventHandler( this, "cMenuPianoPointer_Click" ) );
            cMenuPianoPencil.clickEvent.add( new BEventHandler( this, "cMenuPianoPencil_Click" ) );
            cMenuPianoEraser.clickEvent.add( new BEventHandler( this, "cMenuPianoEraser_Click" ) );
            cMenuPianoCurve.clickEvent.add( new BEventHandler( this, "cMenuPianoCurve_Click" ) );
            cMenuPianoFixed01.clickEvent.add( new BEventHandler( this, "cMenuPianoFixed01_Click" ) );
            cMenuPianoFixed02.clickEvent.add( new BEventHandler( this, "cMenuPianoFixed02_Click" ) );
            cMenuPianoFixed04.clickEvent.add( new BEventHandler( this, "cMenuPianoFixed04_Click" ) );
            cMenuPianoFixed08.clickEvent.add( new BEventHandler( this, "cMenuPianoFixed08_Click" ) );
            cMenuPianoFixed16.clickEvent.add( new BEventHandler( this, "cMenuPianoFixed16_Click" ) );
            cMenuPianoFixed32.clickEvent.add( new BEventHandler( this, "cMenuPianoFixed32_Click" ) );
            cMenuPianoFixed64.clickEvent.add( new BEventHandler( this, "cMenuPianoFixed64_Click" ) );
            cMenuPianoFixed128.clickEvent.add( new BEventHandler( this, "cMenuPianoFixed128_Click" ) );
            cMenuPianoFixedOff.clickEvent.add( new BEventHandler( this, "cMenuPianoFixedOff_Click" ) );
            cMenuPianoFixedTriplet.clickEvent.add( new BEventHandler( this, "cMenuPianoFixedTriplet_Click" ) );
            cMenuPianoFixedDotted.clickEvent.add( new BEventHandler( this, "cMenuPianoFixedDotted_Click" ) );
            cMenuPianoQuantize04.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            cMenuPianoQuantize08.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            cMenuPianoQuantize16.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            cMenuPianoQuantize32.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            cMenuPianoQuantize64.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            cMenuPianoQuantize128.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            cMenuPianoQuantizeOff.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            cMenuPianoQuantizeTriplet.clickEvent.add( new BEventHandler( this, "h_positionQuantizeTriplet" ) );
            cMenuPianoLength04.clickEvent.add( new BEventHandler( this, "h_lengthQuantize04" ) );
            cMenuPianoLength08.clickEvent.add( new BEventHandler( this, "h_lengthQuantize08" ) );
            cMenuPianoLength16.clickEvent.add( new BEventHandler( this, "h_lengthQuantize16" ) );
            cMenuPianoLength32.clickEvent.add( new BEventHandler( this, "h_lengthQuantize32" ) );
            cMenuPianoLength64.clickEvent.add( new BEventHandler( this, "h_lengthQuantize64" ) );
            cMenuPianoLength128.clickEvent.add( new BEventHandler( this, "h_lengthQuantize128" ) );
            cMenuPianoLengthOff.clickEvent.add( new BEventHandler( this, "h_lengthQuantizeOff" ) );
            cMenuPianoLengthTriplet.clickEvent.add( new BEventHandler( this, "h_lengthQuantizeTriplet" ) );
            cMenuPianoGrid.clickEvent.add( new BEventHandler( this, "cMenuPianoGrid_Click" ) );
            cMenuPianoUndo.clickEvent.add( new BEventHandler( this, "cMenuPianoUndo_Click" ) );
            cMenuPianoRedo.clickEvent.add( new BEventHandler( this, "cMenuPianoRedo_Click" ) );
            cMenuPianoCut.clickEvent.add( new BEventHandler( this, "cMenuPianoCut_Click" ) );
            cMenuPianoCopy.clickEvent.add( new BEventHandler( this, "cMenuPianoCopy_Click" ) );
            cMenuPianoPaste.clickEvent.add( new BEventHandler( this, "cMenuPianoPaste_Click" ) );
            cMenuPianoDelete.clickEvent.add( new BEventHandler( this, "cMenuPianoDelete_Click" ) );
            cMenuPianoSelectAll.clickEvent.add( new BEventHandler( this, "cMenuPianoSelectAll_Click" ) );
            cMenuPianoSelectAllEvents.clickEvent.add( new BEventHandler( this, "cMenuPianoSelectAllEvents_Click" ) );
            cMenuPianoImportLyric.clickEvent.add( new BEventHandler( this, "cMenuPianoImportLyric_Click" ) );
            cMenuPianoExpressionProperty.clickEvent.add( new BEventHandler( this, "cMenuPianoProperty_Click" ) );
            cMenuPianoVibratoProperty.clickEvent.add( new BEventHandler( this, "cMenuPianoVibratoProperty_Click" ) );
            cMenuTrackTab.openingEvent.add( new BCancelEventHandler( this, "cMenuTrackTab_Opening" ) );
            cMenuTrackTabTrackOn.clickEvent.add( new BEventHandler( this, "commonTrackOn_Click" ) );
            cMenuTrackTabPlayAfterSynth.clickEvent.add( new BEventHandler( this, "commonPlayAfterSynth_Click" ) );
            cMenuTrackTabAdd.clickEvent.add( new BEventHandler( this, "cMenuTrackTabAdd_Click" ) );
            cMenuTrackTabCopy.clickEvent.add( new BEventHandler( this, "cMenuTrackTabCopy_Click" ) );
            cMenuTrackTabChangeName.clickEvent.add( new BEventHandler( this, "cMenuTrackTabChangeName_Click" ) );
            cMenuTrackTabDelete.clickEvent.add( new BEventHandler( this, "cMenuTrackTabDelete_Click" ) );
            cMenuTrackTabRenderCurrent.clickEvent.add( new BEventHandler( this, "cMenuTrackTabRenderCurrent_Click" ) );
            cMenuTrackTabRenderAll.clickEvent.add( new BEventHandler( this, "commonTrackRenderAll_Click" ) );
            cMenuTrackTabOverlay.clickEvent.add( new BEventHandler( this, "cMenuTrackTabOverlay_Click" ) );
            cMenuTrackTabRenderer.dropDownOpeningEvent.add( new BEventHandler( this, "cMenuTrackTabRenderer_DropDownOpening" ) );
            cMenuTrackTabRendererVOCALOID100.clickEvent.add( new BEventHandler( this, "commonChangeRenderer" ) );
            cMenuTrackTabRendererVOCALOID101.clickEvent.add( new BEventHandler( this, "commonChangeRenderer" ) );
            cMenuTrackTabRendererVOCALOID2.clickEvent.add( new BEventHandler( this, "commonChangeRenderer" ) );
            cMenuTrackTabRendererUtau.clickEvent.add( new BEventHandler( this, "commonChangeRenderer" ) );
            cMenuTrackTabRendererStraight.clickEvent.add( new BEventHandler( this, "commonChangeRenderer" ) );
            cMenuTrackTabRendererAquesTone.clickEvent.add( new BEventHandler( this, "commonChangeRenderer" ) );
            cMenuTrackSelector.openingEvent.add( new BCancelEventHandler( this, "cMenuTrackSelector_Opening" ) );
            cMenuTrackSelectorPointer.clickEvent.add( new BEventHandler( this, "cMenuTrackSelectorPointer_Click" ) );
            cMenuTrackSelectorPencil.clickEvent.add( new BEventHandler( this, "cMenuTrackSelectorPencil_Click" ) );
            cMenuTrackSelectorLine.clickEvent.add( new BEventHandler( this, "cMenuTrackSelectorLine_Click" ) );
            cMenuTrackSelectorEraser.clickEvent.add( new BEventHandler( this, "cMenuTrackSelectorEraser_Click" ) );
            cMenuTrackSelectorCurve.clickEvent.add( new BEventHandler( this, "cMenuTrackSelectorCurve_Click" ) );
            cMenuTrackSelectorUndo.clickEvent.add( new BEventHandler( this, "cMenuTrackSelectorUndo_Click" ) );
            cMenuTrackSelectorRedo.clickEvent.add( new BEventHandler( this, "cMenuTrackSelectorRedo_Click" ) );
            cMenuTrackSelectorCut.clickEvent.add( new BEventHandler( this, "cMenuTrackSelectorCut_Click" ) );
            cMenuTrackSelectorCopy.clickEvent.add( new BEventHandler( this, "cMenuTrackSelectorCopy_Click" ) );
            cMenuTrackSelectorPaste.clickEvent.add( new BEventHandler( this, "cMenuTrackSelectorPaste_Click" ) );
            cMenuTrackSelectorDelete.clickEvent.add( new BEventHandler( this, "cMenuTrackSelectorDelete_Click" ) );
            cMenuTrackSelectorDeleteBezier.clickEvent.add( new BEventHandler( this, "cMenuTrackSelectorDeleteBezier_Click" ) );
            cMenuTrackSelectorSelectAll.clickEvent.add( new BEventHandler( this, "cMenuTrackSelectorSelectAll_Click" ) );
            trackBar.valueChangedEvent.add( new BEventHandler( this, "trackBar_ValueChanged" ) );
            trackBar.mouseDownEvent.add( new BMouseEventHandler( this, "trackBar_MouseDown" ) );
            trackBar.enterEvent.add( new BEventHandler( this, "trackBar_Enter" ) );
            bgWorkScreen.doWorkEvent.add( new BDoWorkEventHandler( this, "bgWorkScreen_DoWork" ) );
            timer.tickEvent.add( new BEventHandler( this, "timer_Tick" ) );
            pictKeyLengthSplitter.mouseMoveEvent.add( new BMouseEventHandler( this, "pictKeyLengthSplitter_MouseMove" ) );
            pictKeyLengthSplitter.mouseDownEvent.add( new BMouseEventHandler( this, "pictKeyLengthSplitter_MouseDown" ) );
            pictKeyLengthSplitter.mouseUpEvent.add( new BMouseEventHandler( this, "pictKeyLengthSplitter_MouseUp" ) );
            /*btnRight1.mouseDownEvent.add( new BMouseEventHandler( this, "btnRight_MouseDown" ) );
            btnRight1.mouseUpEvent.add( new BMouseEventHandler( this, "btnRight_MouseUp" ) );
            btnRight1.mouseLeaveEvent.add( new BEventHandler( this, "overviewCommon_MouseLeave" ) );
            btnLeft2.mouseDownEvent.add( new BMouseEventHandler( this, "btnLeft_MouseDown" ) );
            btnLeft2.mouseUpEvent.add( new BMouseEventHandler( this, "btnLeft_MouseUp" ) );
            btnLeft2.mouseLeaveEvent.add( new BEventHandler( this, "overviewCommon_MouseLeave" ) );
            btnZoom.clickEvent.add( new BEventHandler( this, "btnZoom_Click" ) );
            btnMooz.clickEvent.add( new BEventHandler( this, "btnMooz_Click" ) );
            btnLeft1.mouseDownEvent.add( new BMouseEventHandler( this, "btnLeft_MouseDown" ) );
            btnLeft1.mouseUpEvent.add( new BMouseEventHandler( this, "btnLeft_MouseUp" ) );
            btnLeft1.mouseLeaveEvent.add( new BEventHandler( this, "overviewCommon_MouseLeave" ) );
            btnRight2.mouseDownEvent.add( new BMouseEventHandler( this, "btnRight_MouseDown" ) );
            btnRight2.mouseUpEvent.add( new BMouseEventHandler( this, "btnRight_MouseUp" ) );
            btnRight2.mouseLeaveEvent.add( new BEventHandler( this, "overviewCommon_MouseLeave" ) );*/
            panelOverview.mouseMoveEvent.add( new BMouseEventHandler( this, "pictOverview_MouseMove" ) );
            panelOverview.mouseDoubleClickEvent.add( new BMouseEventHandler( this, "pictOverview_MouseDoubleClick" ) );
            panelOverview.mouseDownEvent.add( new BMouseEventHandler( this, "pictOverview_MouseDown" ) );
            panelOverview.paintEvent.add( new BPaintEventHandler( this, "pictOverview_Paint" ) );
            panelOverview.mouseUpEvent.add( new BMouseEventHandler( this, "pictOverview_MouseUp" ) );
            panelOverview.keyUpEvent.add( new BKeyEventHandler( this, "commonCaptureSpaceKeyUp" ) );
            panelOverview.keyDownEvent.add( new BKeyEventHandler( this, "commonCaptureSpaceKeyDown" ) );
            vScroll.valueChangedEvent.add( new BEventHandler( this, "vScroll_ValueChanged" ) );
            vScroll.resizeEvent.add( new BEventHandler( this, "vScroll_Resize" ) );
            vScroll.enterEvent.add( new BEventHandler( this, "vScroll_Enter" ) );
            hScroll.valueChangedEvent.add( new BEventHandler( this, "hScroll_ValueChanged" ) );
            hScroll.resizeEvent.add( new BEventHandler( this, "hScroll_Resize" ) );
            hScroll.enterEvent.add( new BEventHandler( this, "hScroll_Enter" ) );
            picturePositionIndicator.previewKeyDownEvent.add( new BPreviewKeyDownEventHandler( this, "picturePositionIndicator_PreviewKeyDown" ) );
            picturePositionIndicator.mouseMoveEvent.add( new BMouseEventHandler( this, "picturePositionIndicator_MouseMove" ) );
            picturePositionIndicator.mouseDoubleClickEvent.add( new BMouseEventHandler( this, "picturePositionIndicator_MouseDoubleClick" ) );
            picturePositionIndicator.mouseDownEvent.add( new BMouseEventHandler( this, "picturePositionIndicator_MouseDown" ) );
            picturePositionIndicator.mouseUpEvent.add( new BMouseEventHandler( this, "picturePositionIndicator_MouseUp" ) );
            picturePositionIndicator.paintEvent.add( new BPaintEventHandler( this, "picturePositionIndicator_Paint" ) );
            pictPianoRoll.previewKeyDownEvent.add( new BPreviewKeyDownEventHandler( this, "pictPianoRoll_PreviewKeyDown" ) );
            pictPianoRoll.keyUpEvent.add( new BKeyEventHandler( this, "commonCaptureSpaceKeyUp" ) );
            pictPianoRoll.keyUpEvent.add( new BKeyEventHandler( this, "pictPianoRoll_KeyUp" ) );
            pictPianoRoll.mouseMoveEvent.add( new BMouseEventHandler( this, "pictPianoRoll_MouseMove" ) );
            pictPianoRoll.mouseDoubleClickEvent.add( new BMouseEventHandler( this, "pictPianoRoll_MouseDoubleClick" ) );
            pictPianoRoll.mouseClickEvent.add( new BMouseEventHandler( this, "pictPianoRoll_MouseClick" ) );
            pictPianoRoll.mouseDownEvent.add( new BMouseEventHandler( this, "pictPianoRoll_MouseDown" ) );
            pictPianoRoll.mouseUpEvent.add( new BMouseEventHandler( this, "pictPianoRoll_MouseUp" ) );
            pictPianoRoll.keyDownEvent.add( new BKeyEventHandler( this, "commonCaptureSpaceKeyDown" ) );
#if !JAVA
            this.DragEnter += new System.Windows.Forms.DragEventHandler( FormMain_DragEnter );
            this.DragDrop += new System.Windows.Forms.DragEventHandler( FormMain_DragDrop );
            this.DragOver += new System.Windows.Forms.DragEventHandler( FormMain_DragOver );
            this.DragLeave += new EventHandler( FormMain_DragLeave );
#endif
            pictureBox3.mouseDownEvent.add( new BMouseEventHandler( this, "pictureBox3_MouseDown" ) );
            pictureBox2.mouseDownEvent.add( new BMouseEventHandler( this, "pictureBox2_MouseDown" ) );
            stripBtnPointer.clickEvent.add( new BEventHandler( this, "stripBtnArrow_Click" ) );
            stripBtnPencil.clickEvent.add( new BEventHandler( this, "stripBtnPencil_Click" ) );
            stripBtnLine.clickEvent.add( new BEventHandler( this, "stripBtnLine_Click" ) );
            stripBtnEraser.clickEvent.add( new BEventHandler( this, "stripBtnEraser_Click" ) );
            stripBtnGrid.checkedChangedEvent.add( new BEventHandler( this, "stripBtnGrid_CheckedChanged" ) );
            stripBtnCurve.clickEvent.add( new BEventHandler( this, "stripBtnCurve_Click" ) );
#if !JAVA
            toolStripContainer.TopToolStripPanel.SizeChanged += new EventHandler( toolStripContainer_TopToolStripPanel_SizeChanged );
            stripDDBtnSpeed.dropDownOpeningEvent.add( new BEventHandler( this, "stripDDBtnSpeed_DropDownOpening" ) );
            stripDDBtnSpeedTextbox.keyDownEvent.add( new BKeyEventHandler( this, "stripDDBtnSpeedTextbox_KeyDown" ) );
            stripDDBtnSpeed033.clickEvent.add( new BEventHandler( this, "stripDDBtnSpeed033_Click" ) );
            stripDDBtnSpeed050.clickEvent.add( new BEventHandler( this, "stripDDBtnSpeed050_Click" ) );
            stripDDBtnSpeed100.clickEvent.add( new BEventHandler( this, "stripDDBtnSpeed100_Click" ) );
            stripDDBtnLength04.clickEvent.add( new BEventHandler( this, "h_lengthQuantize04" ) );
            stripDDBtnLength08.clickEvent.add( new BEventHandler( this, "h_lengthQuantize08" ) );
            stripDDBtnLength16.clickEvent.add( new BEventHandler( this, "h_lengthQuantize16" ) );
            stripDDBtnLength32.clickEvent.add( new BEventHandler( this, "h_lengthQuantize32" ) );
            stripDDBtnLength64.clickEvent.add( new BEventHandler( this, "h_lengthQuantize64" ) );
            stripDDBtnLength128.clickEvent.add( new BEventHandler( this, "h_lengthQuantize128" ) );
            stripDDBtnLengthOff.clickEvent.add( new BEventHandler( this, "h_lengthQuantizeOff" ) );
            stripDDBtnLengthTriplet.clickEvent.add( new BEventHandler( this, "h_lengthQuantizeTriplet" ) );
            stripDDBtnQuantize04.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            stripDDBtnQuantize08.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            stripDDBtnQuantize16.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            stripDDBtnQuantize32.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            stripDDBtnQuantize64.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            stripDDBtnQuantize128.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            stripDDBtnQuantizeOff.clickEvent.add( new BEventHandler( this, "handlePositionQuantize" ) );
            stripDDBtnQuantizeTriplet.clickEvent.add( new BEventHandler( this, "h_positionQuantizeTriplet" ) );
#endif
            stripBtnFileNew.clickEvent.add( new BEventHandler( this, "commonFileNew_Click" ) );
            stripBtnFileOpen.clickEvent.add( new BEventHandler( this, "commonFileOpen_Click" ) );
            stripBtnFileSave.clickEvent.add( new BEventHandler( this, "commonFileSave_Click" ) );
            stripBtnCut.clickEvent.add( new BEventHandler( this, "commonEditCut_Click" ) );
            stripBtnCopy.clickEvent.add( new BEventHandler( this, "commonEditCopy_Click" ) );
            stripBtnPaste.clickEvent.add( new BEventHandler( this, "commonEditPaste_Click" ) );
            stripBtnUndo.clickEvent.add( new BEventHandler( this, "commonEditUndo_Click" ) );
            stripBtnRedo.clickEvent.add( new BEventHandler( this, "commonEditRedo_Click" ) );
            stripBtnMoveTop.clickEvent.add( new BEventHandler( this, "stripBtnMoveTop_Click" ) );
            stripBtnRewind.clickEvent.add( new BEventHandler( this, "stripBtnRewind_Click" ) );
            stripBtnForward.clickEvent.add( new BEventHandler( this, "stripBtnForward_Click" ) );
            stripBtnMoveEnd.clickEvent.add( new BEventHandler( this, "stripBtnMoveEnd_Click" ) );
            stripBtnPlay.clickEvent.add( new BEventHandler( this, "stripBtnPlay_Click" ) );
            stripBtnStop.clickEvent.add( new BEventHandler( this, "stripBtnStop_Click" ) );
            stripBtnScroll.clickEvent.add( new BEventHandler( this, "stripBtnScroll_Click" ) );
            stripBtnLoop.clickEvent.add( new BEventHandler( this, "stripBtnLoop_Click" ) );
            stripBtnStartMarker.clickEvent.add( new BEventHandler( this, "handleStartMarker_Click" ) );
            stripBtnEndMarker.clickEvent.add( new BEventHandler( this, "handleEndMarker_Click" ) );
            deactivateEvent.add( new BEventHandler( this, "FormMain_Deactivate" ) );
            activatedEvent.add( new BEventHandler( this, "FormMain_Activated" ) );
            formClosedEvent.add( new BFormClosedEventHandler( this, "FormMain_FormClosed" ) );
            formClosingEvent.add( new BFormClosingEventHandler( this, "FormMain_FormClosing" ) );
            previewKeyDownEvent.add( new BPreviewKeyDownEventHandler( this, "FormMain_PreviewKeyDown" ) );
            panelOverview.enterEvent.add( new BEventHandler( this, "panelOverview_Enter" ) );
        }

        public void setResources() {
            try {
                this.stripBtnPointer.setIcon( new ImageIcon( Resources.get_arrow_135() ) );
                this.stripBtnPencil.setIcon( new ImageIcon( Resources.get_pencil() ) );
                this.stripBtnLine.setIcon( new ImageIcon( Resources.get_layer_shape_line() ) );
                this.stripBtnEraser.setIcon( new ImageIcon( Resources.get_eraser() ) );
                this.stripBtnGrid.setIcon( new ImageIcon( Resources.get_ruler_crop() ) );
                this.stripBtnCurve.setIcon( new ImageIcon( Resources.get_layer_shape_curve() ) );
                this.stripLblGameCtrlMode.setIcon( new ImageIcon( Resources.get_slash() ) );
                this.stripLblMidiIn.setIcon( new ImageIcon( Resources.get_slash() ) );
                this.stripBtnFileNew.setIcon( new ImageIcon( Resources.get_disk__plus() ) );
                this.stripBtnFileOpen.setIcon( new ImageIcon( Resources.get_folder_horizontal_open() ) );
                this.stripBtnFileSave.setIcon( new ImageIcon( Resources.get_disk() ) );
                this.stripBtnCut.setIcon( new ImageIcon( Resources.get_scissors() ) );
                this.stripBtnCopy.setIcon( new ImageIcon( Resources.get_documents() ) );
                this.stripBtnPaste.setIcon( new ImageIcon( Resources.get_clipboard_paste() ) );
                this.stripBtnUndo.setIcon( new ImageIcon( Resources.get_arrow_skip_180() ) );
                this.stripBtnRedo.setIcon( new ImageIcon( Resources.get_arrow_skip() ) );
                this.stripBtnMoveTop.setIcon( new ImageIcon( Resources.get_control_stop_180() ) );
                this.stripBtnRewind.setIcon( new ImageIcon( Resources.get_control_double_180() ) );
                this.stripBtnForward.setIcon( new ImageIcon( Resources.get_control_double() ) );
                this.stripBtnMoveEnd.setIcon( new ImageIcon( Resources.get_control_stop() ) );
                this.stripBtnPlay.setIcon( new ImageIcon( Resources.get_control() ) );
                this.stripBtnStop.setIcon( new ImageIcon( Resources.get_control_pause() ) );
                this.stripBtnScroll.setIcon( new ImageIcon( Resources.get_arrow_circle_double() ) );
                this.stripBtnLoop.setIcon( new ImageIcon( Resources.get_arrow_return() ) );
                this.stripBtnStartMarker.setIcon( new ImageIcon( Resources.get_pin__arrow() ) );
                this.stripBtnEndMarker.setIcon( new ImageIcon( Resources.get_pin__arrow_inv() ) );
                setIconImage( Resources.get_icon() );
            } catch ( Exception ex ) {
                PortUtil.stderr.println( "FormMain#setResources; ex=" + ex );
            }
        }
        #endregion // public methods

        #region event handlers
        public void panelOverview_Enter( Object sender, EventArgs e ) {
            pictPianoRoll.requestFocus();
        }

#if ENABLE_MIDI
        public void m_strip_ddbtn_metronome_CheckedChanged( Object sender, EventArgs e ) {
            AppManager.editorConfig.MetronomeEnabled = m_strip_ddbtn_metronome.isSelected();
            if ( AppManager.editorConfig.MetronomeEnabled && AppManager.getEditMode() == EditMode.REALTIME ) {
                MidiPlayer.RestartMetronome();
            }
        }
#endif

        public void commonStripPaletteTool_Clicked( Object sender, EventArgs e ) {
            String id = "";  //選択されたツールのID
#if ENABLE_SCRIPT
            if ( sender is BToolStripButton ) {
                BToolStripButton tsb = (BToolStripButton)sender;
                if ( tsb.getTag() != null && tsb.getTag() is String ) {
                    id = (String)tsb.getTag();
                    AppManager.selectedPaletteTool = id;
                    AppManager.setSelectedTool( EditTool.PALETTE_TOOL );
                    tsb.setSelected( true );
                }
            } else if ( sender is BMenuItem ) {
                BMenuItem tsmi = (BMenuItem)sender;
                if ( tsmi.getTag() != null && tsmi.getTag() is String ) {
                    id = (String)tsmi.getTag();
                    AppManager.selectedPaletteTool = id;
                    AppManager.setSelectedTool( EditTool.PALETTE_TOOL );
                    tsmi.setSelected( true );
                }
            }
#endif

            int count = toolStripTool.getComponentCount();
            for ( int i = 0; i < count; i++ ) {
                Object item = toolStripTool.getComponentAtIndex( i );
                if ( item is BToolStripButton ) {
                    BToolStripButton button = (BToolStripButton)item;
                    if ( button.getTag() != null && button.getTag() is String ) {
                        if ( ((String)button.getTag()).Equals( id ) ) {
                            button.setSelected( true );
                        } else {
                            button.setSelected( false );
                        }
                    }
                }
            }

            MenuElement[] sub_cmenu_piano_palette_tool = cMenuPianoPaletteTool.getSubElements();
            for ( int i = 0; i < sub_cmenu_piano_palette_tool.Length; i++ ) {
                MenuElement item = sub_cmenu_piano_palette_tool[i];
                if ( item is BMenuItem ) {
                    BMenuItem menu = (BMenuItem)item;
                    if ( menu.getTag() != null && menu.getTag() is String ) {
                        if ( ((String)menu.getTag()).Equals( id ) ) {
                            menu.setSelected( true );
                        } else {
                            menu.setSelected( false );
                        }
                    }
                }
            }

            MenuElement[] sub_cmenu_track_selectro_palette_tool = cMenuTrackSelectorPaletteTool.getSubElements();
            for ( int i = 0; i < sub_cmenu_track_selectro_palette_tool.Length; i++ ) {
                MenuElement item = sub_cmenu_track_selectro_palette_tool[i];
                if ( item is BMenuItem ) {
                    BMenuItem menu = (BMenuItem)item;
                    if ( menu.getTag() != null && menu.getTag() is String ) {
                        if ( ((String)menu.getTag()).Equals( id ) ) {
                            menu.setSelected( true );
                        } else {
                            menu.setSelected( false );
                        }
                    }
                }
            }
        }

        #region AppManager.inputTextBox
        public void m_input_textbox_KeyDown( Object sender, BKeyEventArgs e ) {
#if DEBUG
            PortUtil.println( "FormMain#m_input_textbox_KeyDown" );
#endif
#if JAVA
            int keycode = e.getKeyCode();
            int modifiers = e.getModifiers();
            if ( keycode == KeyEvent.VK_TAB || 
                 keycode == KeyEvent.VK_ENTER ) {
#else
            if ( e.KeyCode == System.Windows.Forms.Keys.Tab || 
                 e.KeyCode == System.Windows.Forms.Keys.Return ) {
#endif
                executeLyricChangeCommand();
                int selected = AppManager.getSelected();
                int index = -1;
                VsqTrack track = AppManager.getVsqFile().Track.get( selected );
                track.sortEvent();
#if JAVA
                if( keycode == KeyEvent.VK_TAB ) {
#else
                if ( e.KeyCode == System.Windows.Forms.Keys.Tab ) {
#endif
                    int clock = 0;
                    int search_index = AppManager.getLastSelectedEvent().original.InternalID;
                    int c = track.getEventCount();
                    for ( int i = 0; i < c; i++ ) {
                        VsqEvent item = track.getEvent( i );
                        if ( item.InternalID == search_index ) {
                            index = i;
                            clock = item.Clock;
                            break;
                        }
                    }
#if JAVA
                    if( (modifiers & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK ) {
#else
                    if ( (e.Modifiers & System.Windows.Forms.Keys.Shift) == System.Windows.Forms.Keys.Shift ) {
#endif
                        // 1個前の音符イベントを検索
                        int tindex = -1;
                        for ( int i = track.getEventCount() - 1; i >= 0; i-- ) {
                            VsqEvent ve = track.getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote && i != index && ve.Clock <= clock ) {
                                tindex = i;
                                break;
                            }
                        }
                        index = tindex;
                    } else {
                        // 1個後の音符イベントを検索
                        int tindex = -1;
                        int c2 = track.getEventCount();
                        for ( int i = 0; i < c2; i++ ) {
                            VsqEvent ve = track.getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote && i != index && ve.Clock >= clock ) {
                                tindex = i;
                                break;
                            }
                        }
                        index = tindex;
                    }
                }
                if ( 0 <= index && index < track.getEventCount() ) {
                    AppManager.clearSelectedEvent();
                    VsqEvent item = track.getEvent( index );
                    AppManager.addSelectedEvent( item.InternalID );
                    int x = AppManager.xCoordFromClocks( item.Clock );
                    int y = AppManager.yCoordFromNote( item.ID.Note );
                    boolean phonetic_symbol_edit_mode = AppManager.inputTextBox.isPhoneticSymbolEditMode();
                    showInputTextBox( 
                        item.ID.LyricHandle.L0.Phrase,
                        item.ID.LyricHandle.L0.getPhoneticSymbol(),
                        new Point( x, y ),
                        phonetic_symbol_edit_mode );
                    int clWidth = (int)(AppManager.inputTextBox.getWidth() * AppManager.getScaleXInv());

                    // 画面上にAppManager.inputTextBoxが見えるように，移動
                    int SPACE = 20;
                    if ( x < AppManager.keyWidth || pictPianoRoll.getWidth() < x + AppManager.inputTextBox.getWidth() ) {
                        int clock, clock_x;
                        if ( x < AppManager.keyWidth ) {
                            clock = item.Clock;
                            clock_x = AppManager.keyWidth + SPACE;
                        } else {
                            clock = item.Clock + clWidth;
                            clock_x = pictPianoRoll.getWidth() - SPACE;
                        }
                        double draft_d = (73 - clock_x) * AppManager.getScaleXInv() + clock;
                        if ( draft_d < 0.0 ) {
                            draft_d = 0.0;
                        }
                        int draft = (int)draft_d;
                        if ( draft < hScroll.getMinimum() ) {
                            draft = hScroll.getMinimum();
                        } else if ( hScroll.getMaximum() < draft ) {
                            draft = hScroll.getMaximum();
                        }
                        hScroll.setValue( draft );
                    } else {
                        refreshScreen();
                    }
                } else {
                    int id = AppManager.getLastSelectedEvent().original.InternalID;
                    AppManager.clearSelectedEvent();
                    AppManager.addSelectedEvent( id );
                    hideInputTextBox();
                }
            }
        }

        public void m_input_textbox_KeyUp( Object sender, BKeyEventArgs e ) {
#if DEBUG
            PortUtil.println( "FormMain#m_input_textbox_KeyUp" );
#endif
#if JAVA
            boolean flip = (e.getKeyCode() == KeyEvent.VK_UP || e.getKeyCode() == KeyEvent.VK_DOWN) && ((e.getModifiers() & InputEvent.ALT_MASK) == InputEvent.ALT_MASK);
            boolean hide = (e.getKeyCode() == KeyEvent.VK_ESCAPE);
#else
            bool flip = (e.KeyCode == System.Windows.Forms.Keys.Up || e.KeyCode == System.Windows.Forms.Keys.Down) && (PortUtil.getCurrentModifierKey() == InputEvent.ALT_MASK);
            bool hide = e.KeyCode == System.Windows.Forms.Keys.Escape;
#endif

            if ( flip ) {
                if ( AppManager.inputTextBox.isVisible() ) {
                    flipInputTextBoxMode();
                }
            } else if ( hide ) {
                hideInputTextBox();
            }
        }

        public void m_input_textbox_ImeModeChanged( Object sender, EventArgs e ) {
            m_last_is_imemode_on = AppManager.inputTextBox.isImeModeOn();
        }

        public void m_input_textbox_KeyPress( Object sender, BKeyPressEventArgs e ) {
#if DEBUG
            PortUtil.println( "FormMain#m_input_textbox_KeyPress" );
#endif
#if !JAVA
            //           Enter                                  Tab
            e.Handled = (e.KeyChar == Convert.ToChar( 13 )) || (e.KeyChar == Convert.ToChar( 09 ));
#endif
        }
        #endregion

        public void m_toolbar_edit_SelectedToolChanged( EditTool tool ) {
            AppManager.setSelectedTool( tool );
        }

        public void m_toolbar_measure_EndMarkerClick( Object sender, EventArgs e ) {
            AppManager.endMarkerEnabled = !AppManager.endMarkerEnabled;
#if DEBUG
            AppManager.debugWriteLine( "m_toolbar_measure_EndMarkerClick" );
            AppManager.debugWriteLine( "    m_config.EndMarkerEnabled=" + AppManager.endMarkerEnabled );
#endif
            refreshScreen();
        }

        public void m_toolbar_measure_StartMarkerClick( Object sender, EventArgs e ) {
            AppManager.startMarkerEnabled = !AppManager.startMarkerEnabled;
#if DEBUG
            AppManager.debugWriteLine( "m_toolbar_measure_StartMarkerClick" );
            AppManager.debugWriteLine( "    m_config.StartMarkerEnabled=" + AppManager.startMarkerEnabled );
#endif
            refreshScreen();
        }

        public void handleRecentFileMenuItem_Click( Object sender, EventArgs e ) {
            if ( sender is BMenuItem ) {
                BMenuItem item = (BMenuItem)sender;
                if ( item.getTag() is String ) {
                    String filename = (String)item.getTag();
                    openVsqCor( filename );
                    refreshScreen();
                }
            }
        }

        public void handleRecentFileMenuItem_MouseEnter( Object sender, EventArgs e ) {
            if ( sender is BMenuItem ) {
                BMenuItem item = (BMenuItem)sender;
#if JAVA
                statusLabel.setText( item.getToolTipText() );
#else
                statusLabel.setText( item.ToolTipText );
#endif
            }
        }

        #region AppManager
        public void AppManager_GridVisibleChanged( Object sender, EventArgs e ) {
            menuVisualGridline.setSelected( AppManager.isGridVisible() );
            stripBtnGrid.setSelected( AppManager.isGridVisible() );
            cMenuPianoGrid.setSelected( AppManager.isGridVisible() );
        }

        public void AppManager_PreviewAborted( Object sender, EventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "AppManager_PreviewAborted" );
#endif
            timer.stop();

            if ( AppManager.getEditMode() == EditMode.REALTIME ) {
                menuJobRealTime.setText( _( "Start Realtime Input" ) );
                AppManager.setEditMode( EditMode.NONE );
            }
#if DEBUG
            PortUtil.println( "  calling VSTiProxy.abortRendering..." );
#endif
            VSTiProxy.abortRendering();
#if DEBUG
            PortUtil.println( "  done" );
#endif
            AppManager.firstBufferWritten = false;
#if ENABLE_MIDI
            if ( m_midi_in != null ) {
                m_midi_in.Stop();
            }
#endif

            PlaySound.exit();
            for ( int i = 0; i < AppManager.drawStartIndex.Length; i++ ) {
                AppManager.drawStartIndex[i] = 0;
            }
#if ENABLE_MIDI
            MidiPlayer.Stop();
#endif
        }

        public void AppManager_PreviewStarted( Object sender, EventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "m_config_PreviewStarted" );
#endif
            int ms_resolution = AppManager.editorConfig.BufferSizeMilliSeconds;
            if ( ms_resolution < MIN_WAVE_MSEC_RESOLUTION ) {
                ms_resolution = MIN_WAVE_MSEC_RESOLUTION;
            }
            if ( ms_resolution > MAX_WAVE_MSEC_RESOLUTION ) {
                ms_resolution = MAX_WAVE_MSEC_RESOLUTION;
            }
            PlaySound.setResolution( (int)(ms_resolution / 1000.0 * VSTiProxy.SAMPLE_RATE) );
            PlaySound.prepare( VSTiProxy.SAMPLE_RATE );
#if DEBUG
            PortUtil.println( "FormMain#AppManager_PreviewStarted; VSTiProxy.SAMPLE_RATE=" + VSTiProxy.SAMPLE_RATE );
#endif

            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            RendererKind renderer = VsqFileEx.getTrackRendererKind( vsq.Track.get( selected ) );
            int clock = AppManager.getCurrentClock();
            m_direct_play_shift = (float)vsq.getSecFromClock( clock );
            if ( AppManager.getEditMode() != EditMode.REALTIME ) {
                String tmppath = AppManager.getTempWaveDir();

                double amp_master = VocaloSysUtil.getAmplifyCoeffFromFeder( vsq.Mixer.MasterFeder );
                double pan_left_master = VocaloSysUtil.getAmplifyCoeffFromPanLeft( vsq.Mixer.MasterPanpot );
                double pan_right_master = VocaloSysUtil.getAmplifyCoeffFromPanRight( vsq.Mixer.MasterPanpot );

                Vector<WaveReader> sounds = new Vector<WaveReader>();
                int track_count = vsq.Track.size();

                Vector<Integer> tracks = new Vector<Integer>();
                for ( int track = 1; track < track_count; track++ ) {
                    VsqTrack vsq_track = vsq.Track.get( track );
                    boolean trackMuted = vsq.getActualMuted( track );
                    int playMode = vsq_track.getPlayMode();
                    if ( trackMuted ) {
                        continue;
                    } else if ( playMode == PlayMode.PlayWithSynth ) {
                        if ( track == selected ) {
                            continue;
                        }
                    }
                    tracks.add( track );
                }

                patchWorkToFreeze( tracks.toArray( new Integer[] { } ) );
                
                for ( int i = 0; i < tracks.size(); i++ ) {
                    int track = tracks.get( i );
                    String file = PortUtil.combinePath( tmppath, track + ".wav" );
                    WaveReader wr = null;
                    try {
                        wr = new WaveReader( file );
                        wr.setTag( track );
                        sounds.add( wr );
                    } catch ( Exception ex ) {
                        PortUtil.stderr.println( "FormMain#AppManager_PreviewStarted; ex=" + ex );
                    }
                }

                // リアルタイム再生用のデータを準備
                int preview_ending_clock = vsq.TotalClocks;
                if ( AppManager.endMarkerEnabled ) {
                    //preview_ending_clock = Math.Max( preview_ending_clock, AppManager.endMarker + 480 );
                    //TODO: fixme FormMain#AppManager_PreviewStarted
                }
                m_preview_ending_time = vsq.getSecFromClock( preview_ending_clock ) + 1.0;

                // clock以降に音符があるかどうかを調べる
                int count = 0;
                for ( Iterator<VsqEvent> itr = vsq.Track.get( selected ).getNoteEventIterator(); itr.hasNext(); ) {
                    VsqEvent ve = itr.next();
                    if ( ve.Clock >= clock ) {
                        count++;
                        break;
                    }
                }
#if DEBUG
                PortUtil.println( "FormMain#AppManager_PreviewStarted; count=" + count );
#endif

                int bgm_count = AppManager.getBgmCount();
                double pre_measure_sec = vsq.getSecFromClock( vsq.getPreMeasureClocks() );
                for ( int i = 0; i < bgm_count; i++ ) {
                    BgmFile bgm = AppManager.getBgm( i );
                    WaveReader wr = null;
                    try {
                        wr = new WaveReader( bgm.file );
                        wr.setTag( (int)(-i - 1) );
                        double offset = bgm.readOffsetSeconds;
                        if ( bgm.startAfterPremeasure ) {
                            offset -= pre_measure_sec;
                        }
                        wr.setOffsetSeconds( offset );
                        sounds.add( wr );
                    } catch ( Exception ex ) {
                        PortUtil.stderr.println( "FormMain#AppManager_PreviewStarted; ex=" + ex );
                    }
                }

                boolean mode_infinite = AppManager.getEditMode() == EditMode.REALTIME;
                if ( vsq.Track.get( selected ).getPlayMode() == PlayMode.PlayWithSynth && count > 0 && !vsq.getActualMuted( selected ) ) {
                    int ms_presend = AppManager.editorConfig.PreSendTime;
                    if ( renderer == RendererKind.UTAU ) {
                        ms_presend = 0;
                    }
#if DEBUG
                    AppManager.debugWriteLine( "FormMain#AppManager_PreviewStarted; m_preview_ending_time=" + m_preview_ending_time );
                    AppManager.debugWriteLine( "FormMain#AppManager_PreviewStarted; m_direct_play_shift=" + m_direct_play_shift );
#endif
                    VSTiProxy.render( vsq,
                                      selected,
                                      null,
                                      m_direct_play_shift,
                                      m_preview_ending_time,
                                      ms_presend,
                                      true,
                                      sounds.toArray( new WaveReader[] { } ),
                                      m_direct_play_shift,
                                      mode_infinite,
                                      AppManager.getTempWaveDir(),
                                      false );

                    for ( int i = 0; i < AppManager.drawStartIndex.Length; i++ ) {
                        AppManager.drawStartIndex[i] = 0;
                    }
                    //int clock_now = AppManager.getCurrentClock();
                    //double sec_now = vsq.getSecFromClock( clock_now );
                } else {
                    VsqFileEx tvsq = new VsqFileEx( "Miku", vsq.getPreMeasure(), 4, 4, 500000 );
                    VsqFileEx.setTrackRendererKind( tvsq.Track.get( 1 ), RendererKind.NULL );
                    VSTiProxy.render( tvsq,
                                      1,
                                      null,
                                      0,
                                      m_preview_ending_time,
                                      AppManager.editorConfig.PreSendTime,
                                      true,
                                      sounds.toArray( new WaveReader[] { } ),
                                      m_direct_play_shift,
                                      mode_infinite,
                                      tmppath,
                                      false );
                }
            }

            double now = PortUtil.getCurrentTime();
            if ( AppManager.getEditMode() == EditMode.REALTIME ) {
                menuJobRealTime.setText( _( "Stop Realtime Input" ) );
                AppManager.rendererAvailable = false;
#if ENABLE_MTC
                if ( m_midi_in_mtc != null ) {
                    m_midi_in_mtc.Start();
                }
#endif
#if ENABLE_MIDI
                if ( m_midi_in != null ) {
                    m_midi_in.Start();
                }
                MidiPlayer.SetSpeed( AppManager.editorConfig.getRealtimeInputSpeed(), now );
                MidiPlayer.Start( vsq, clock, now );
#endif
            } else {
                AppManager.rendererAvailable = VSTiProxy.isRendererAvailable( renderer );
            }
            AppManager.firstBufferWritten = true;
            AppManager.previewStartedTime = now;
#if DEBUG
            AppManager.debugWriteLine( "    vsq.TotalClocks=" + vsq.TotalClocks );
            AppManager.debugWriteLine( "    total seconds=" + vsq.getSecFromClock( (int)vsq.TotalClocks ) );
#endif
            timer.start();
        }

        public void AppManager_SelectedToolChanged( Object sender, EventArgs e ) {
            applySelectedTool();
        }

        public void AppManager_SelectedEventChanged( Object sender, boolean selected_event_is_null ) {
            menuEditCut.setEnabled( !selected_event_is_null );
            menuEditPaste.setEnabled( !selected_event_is_null );
            menuEditDelete.setEnabled( !selected_event_is_null );
            cMenuPianoCut.setEnabled( !selected_event_is_null );
            cMenuPianoCopy.setEnabled( !selected_event_is_null );
            cMenuPianoDelete.setEnabled( !selected_event_is_null );
            cMenuPianoExpressionProperty.setEnabled( !selected_event_is_null );
            menuLyricVibratoProperty.setEnabled( !selected_event_is_null );
            menuLyricExpressionProperty.setEnabled( !selected_event_is_null );
            stripBtnCut.setEnabled( !selected_event_is_null );
            stripBtnCopy.setEnabled( !selected_event_is_null );
        }

        public void render( Integer[] tracks ) {
            VsqFileEx vsq = AppManager.getVsqFile();

            String tmppath = AppManager.getTempWaveDir();
            if ( !PortUtil.isDirectoryExists( tmppath ) ) {
                PortUtil.createDirectory( tmppath );
            }
            String[] files = new String[tracks.Length];
            Integer[] ends = new Integer[tracks.Length];
            Integer[] starts = new Integer[tracks.Length];
            for ( int i = 0; i < tracks.Length; i++ ) {
                files[i] = PortUtil.combinePath( tmppath, tracks[i] + ".wav" );
                ends[i] = vsq.TotalClocks + 240;
                starts[i] = 0;
            }
            FormSynthesize dlg = null;
            try {
                dlg = new FormSynthesize( vsq, AppManager.editorConfig.PreSendTime, tracks, files, starts, ends, false );
                dlg.setModal( true );
                dlg.setVisible( true );
                int finished = dlg.getFinished();
                for ( int i = 0; i < finished; i++ ) {
                    AppManager.setRenderRequired( tracks[i], false );
                    AppManager.lastRenderedStatus[tracks[i] - 1] = new RenderedStatus( (VsqTrack)vsq.Track.get( tracks[i] ).clone(), vsq.TempoTable );
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        /// <summary>
        /// 指定したトラックの、レンダリングが必要な部分を再レンダリングし、ツギハギすることでトラックのキャッシュをフリーズさせます。
        /// </summary>
        /// <param name="track"></param>
        private void patchWorkToFreeze( Integer[] tracks ) {
            VsqFileEx vsq = AppManager.getVsqFile();
            vsq.updateTotalClocks();
            String temppath = AppManager.getTempWaveDir();
            int presend = AppManager.editorConfig.PreSendTime;
            int totalClocks = vsq.TotalClocks;

            Vector<Integer> startList = new Vector<Integer>();
            Vector<Integer> endList = new Vector<Integer>();
            Vector<Integer> trackList = new Vector<Integer>();
            Vector<String> files = new Vector<String>();
            int[] startIndex = new int[tracks.Length + 1]; // startList, endList, trackList, filesの内，第startIndex[j]からが，第tracks[j]トラックについてのレンダリング要求かを表す.

            for ( int k = 0; k < tracks.Length; k++ ) {
                startIndex[k] = trackList.size();
                int track = tracks[k];
                VsqTrack vsq_track = vsq.Track.get( track );
                String wavePath = PortUtil.combinePath( temppath, track + ".wav" );

                if ( AppManager.lastRenderedStatus[track - 1] == null ) {
                    // この場合は全部レンダリングする必要がある
                    trackList.add( track );
                    startList.add( 0 );
                    endList.add( totalClocks + 240 );
                    files.add( wavePath );
                    continue;
                }

                // 部分レンダリング
                EditedZoneUnit[] areas = 
                    Utility.detectRenderedStatusDifference( AppManager.lastRenderedStatus[track - 1],
                                                            new RenderedStatus( (VsqTrack)vsq_track.clone(), vsq.TempoTable ) );

                // areasとかぶっている音符がどれかを判定する
                EditedZone zone = new EditedZone();
                zone.add( areas );
                checkSerializedEvents( zone, vsq_track, areas );
                checkSerializedEvents( zone, AppManager.lastRenderedStatus[track - 1].track, areas );

                // レンダリング済みのwaveがあれば、zoneに格納された編集範囲に隣接する前後が無音でない場合、
                // 編集範囲を無音部分まで延長する。
                if ( PortUtil.isFileExists( wavePath ) ) {
                    WaveReader wr = null;
                    try {
                        wr = new WaveReader( wavePath );
                        int sampleRate = wr.getSampleRate();
                        int buflen = 1024;
                        double[] left = new double[buflen];
                        double[] right = new double[buflen];

                        // まずzoneから編集範囲を抽出
                        Vector<EditedZoneUnit> areasList = new Vector<EditedZoneUnit>();
                        for ( Iterator<EditedZoneUnit> itr = zone.iterator(); itr.hasNext(); ) {
                            EditedZoneUnit e = itr.next();
                            areasList.add( (EditedZoneUnit)e.clone() );
                        }

                        for ( Iterator<EditedZoneUnit> itr = areasList.iterator(); itr.hasNext(); ) {
                            EditedZoneUnit e = itr.next();
                            int exStart = e.start;
                            int exEnd = e.end;

                            // 前方に1クロックずつ検索する。
                            int end = e.start;
                            int start = end - 1;
                            double secEnd = vsq.getSecFromClock( end );
                            long saEnd = (long)(secEnd * sampleRate);
                            double secStart = 0.0;
                            long saStart = 0;
                            while ( true ) {
                                start = end - 1;
                                if ( start < 0 ) {
                                    start = 0;
                                    break;
                                }
                                secStart = vsq.getSecFromClock( start );
                                saStart = (long)(secStart * sampleRate);
                                int samples = (int)(saEnd - saStart);
                                long pos = saStart;
                                boolean allzero = true;
                                while ( samples > 0 ) {
                                    int delta = samples > buflen ? buflen : samples;
                                    wr.read( pos, delta, left, right );
                                    for ( int i = 0; i < delta; i++ ) {
                                        if ( left[i] != 0.0 || right[i] != 0.0 ) {
                                            allzero = false;
                                            break;
                                        }
                                    }
                                    pos += delta;
                                    samples -= delta;
                                    if ( !allzero ) {
                                        break;
                                    }
                                }
                                if ( allzero ) {
                                    break;
                                }
                                secEnd = secStart;
                                end = start;
                                saEnd = saStart;
                            }
                            // endクロックより先は無音であるようだ。
                            exStart = end;

                            // 後方に1クロックずつ検索する
                            if ( e.end < int.MaxValue ) {
                                start = e.end;
                                secStart = vsq.getSecFromClock( start );
                                while ( true ) {
                                    end = start + 1;
                                    secEnd = vsq.getSecFromClock( end );
                                    saEnd = (long)(secEnd * sampleRate);
                                    int samples = (int)(saEnd - saStart);
                                    long pos = saStart;
                                    boolean allzero = true;
                                    while ( samples > 0 ) {
                                        int delta = samples > buflen ? buflen : samples;
                                        wr.read( pos, delta, left, right );
                                        for ( int i = 0; i < delta; i++ ) {
                                            if ( left[i] != 0.0 || right[i] != 0.0 ) {
                                                allzero = false;
                                                break;
                                            }
                                        }
                                        pos += delta;
                                        samples -= delta;
                                        if ( !allzero ) {
                                            break;
                                        }
                                    }
                                    if ( allzero ) {
                                        break;
                                    }
                                    secStart = secEnd;
                                    start = end;
                                    saStart = saEnd;
                                }
                                // startクロック以降は無音のようだ
                                exEnd = start;
                            }
#if DEBUG
                            if ( e.start != exStart ) {
                                PortUtil.println( "FormMain#patchWorkToFreeze; start extended; " + e.start + " => " + exStart );
                            }
                            if ( e.end != exEnd ) {
                                PortUtil.println( "FormMain#patchWorkToFreeze; end extended; " + e.end + " => " + exEnd );
                            }
#endif

                            zone.add( exStart, exEnd );
                        }
                    } catch ( Exception ex ) {
                        PortUtil.stderr.println( "FormMain#patchWorkToFreeze; ex=" + ex );
                    } finally {
                        if ( wr != null ) {
                            try {
                                wr.close();
                            } catch ( Exception ex2 ) {
                                PortUtil.stderr.println( "FormMain#patchWorkToFreeze; ex2=" + ex2 );
                            }
                        }
                    }
                }

                // zoneに、レンダリングが必要なアイテムの範囲が格納されているので。
                int j = -1;
                for ( Iterator<EditedZoneUnit> itr = zone.iterator(); itr.hasNext(); ) {
                    EditedZoneUnit unit = itr.next();
                    j++;
                    trackList.add( track );
                    startList.add( unit.start );
                    endList.add( unit.end );
                    files.add( PortUtil.combinePath( temppath, track + "_" + j + ".wav" ) );
                }
            }
            startIndex[tracks.Length] = trackList.size();

#if DEBUG
            for ( int i = 0; i < startList.size(); i++ ) {
                PortUtil.println( "FormMain#patchWorkToFreeze; #" + i + "; start=" + startList.get( i ) + "; end=" + endList.get( i ) );
            }
#endif

            if ( trackList.size() <= 0 ) {
                // パッチワークする必要なし
                for ( int i = 0; i < tracks.Length; i++ ) {
                    AppManager.setRenderRequired( tracks[i], false );
                }
                return;
            }

            FormSynthesize dialog = null;
            String tempWave = PortUtil.combinePath( temppath, "temp.wav" );
            try {
                dialog = new FormSynthesize( vsq,
                                             presend,
                                             trackList.toArray( new Integer[] { } ),
                                             files.toArray( new String[] { } ),
                                             startList.toArray( new Integer[] { } ),
                                             endList.toArray( new Integer[] { } ),
                                             false );
                dialog.setModal( true );
                dialog.setVisible( true );
                int finished = dialog.getFinished();
                for ( int k = 0; k < tracks.Length; k++ ) {
                    int track = tracks[k];
                    String wavePath = PortUtil.combinePath( temppath, track + ".wav" );

                    if ( wavePath.Equals( files.get( startIndex[k] ) ) && startIndex[k] < finished ) {
                        // このとき，パッチワークを行う必要なし．
                        AppManager.lastRenderedStatus[track - 1] = new RenderedStatus( (VsqTrack)vsq.Track.get( track ).clone(), vsq.TempoTable );
                        AppManager.serializeRenderingStatus( temppath, track );
                        waveView.load( track - 1, wavePath );
                        continue;
                    }

                    WaveWriter writer = null;
                    try {
                        int sampleRate = VSTiProxy.SAMPLE_RATE;
                        long totalLength = (long)((vsq.getSecFromClock( vsq.TotalClocks ) + 1.0) * sampleRate);
                        writer = new WaveWriter( wavePath, AppManager.editorConfig.WaveFileOutputChannel, 16, sampleRate );
                        int BUFLEN = 1024;
                        double[] bufl = new double[BUFLEN];
                        double[] bufr = new double[BUFLEN];
                        for ( int i = startIndex[k]; i < startIndex[k + 1] && i < finished; i++ ) {
                            double secStart = vsq.getSecFromClock( startList.get( i ) );
                            int clockEnd = endList.get( i );
                            if ( clockEnd == int.MaxValue ) {
                                clockEnd = vsq.TotalClocks + 240;
                            }
                            double secEnd = vsq.getSecFromClock( clockEnd );
                            long sampleStart = (long)(secStart * sampleRate);
                            long sampleEnd = (long)(secEnd * sampleRate);

                            WaveReader wr = null;
                            try {
                                wr = new WaveReader( files.get( i ) );
                                long remain2 = sampleEnd - sampleStart;
                                long proc = 0;
                                while ( remain2 > 0 ) {
                                    int delta = remain2 > BUFLEN ? BUFLEN : (int)remain2;
                                    wr.read( proc, delta, bufl, bufr );
                                    writer.replace( sampleStart + proc, delta, bufl, bufr );
                                    proc += delta;
                                    remain2 -= delta;
                                }
                            } catch ( Exception ex ) {
                                PortUtil.stderr.println( "FormMain#patchWorkToFreeze; ex=" + ex );
                            } finally {
                                if ( wr != null ) {
                                    try {
                                        wr.close();
                                    } catch ( Exception ex2 ) {
                                        PortUtil.stderr.println( "FormMain#patchWorkToFreeze; ex2=" + ex2 );
                                    }
                                }
                            }

                            try {
                                PortUtil.deleteFile( files.get( i ) );
                            } catch ( Exception ex ) {
                                PortUtil.stderr.println( "FormMain#patchWorkToFreeze; ex=" + ex );
                            }
                        }

                        VsqTrack vsq_track = vsq.Track.get( track );
                        if ( startIndex[k + 1] - 1 < finished ) {
                            // 途中で終了せず，このトラックの全てのパッチワークが完了した．
                            AppManager.lastRenderedStatus[track - 1] = new RenderedStatus( (VsqTrack)vsq_track.clone(), vsq.TempoTable );
                            AppManager.serializeRenderingStatus( temppath, track );
                            AppManager.setRenderRequired( track, false );
                        } else {
                            // パッチワークの作成途中で，キャンセルされた
                            // キャンセルされたやつ以降の範囲に、プログラムチェンジ17の歌手変更イベントを挿入する。→AppManager#detectTrackDifferenceに必ず検出してもらえる。
                            VsqTrack copied = (VsqTrack)vsq_track.clone();
                            VsqEvent dumy = new VsqEvent();
                            dumy.ID.type = VsqIDType.Singer;
                            dumy.ID.IconHandle = new IconHandle();
                            dumy.ID.IconHandle.Program = 17;
                            for ( int i = startIndex[k]; i < startIndex[k + 1]; i++ ) {
                                if ( i < finished ) {
                                    continue;
                                }
                                int start = startList.get( i );
                                int end = endList.get( i );
                                VsqEvent singerAtEnd = vsq_track.getSingerEventAt( end );
                                
                                // startの位置に歌手変更が既に指定されていないかどうかを検査
                                int foundStart = -1;
                                int foundEnd = -1;
                                for ( Iterator<Integer> itr = copied.indexIterator( IndexIteratorKind.SINGER ); itr.hasNext(); ) {
                                    int j = itr.next();
                                    VsqEvent ve = copied.getEvent( j );
                                    if ( ve.Clock == start ) {
                                        foundStart = j;
                                    }
                                    if ( ve.Clock == end ) {
                                        foundEnd = j;
                                    }
                                    if ( end < ve.Clock ) {
                                        break;
                                    }
                                }

                                VsqEvent dumyStart = (VsqEvent)dumy.clone();
                                dumyStart.Clock = start;
                                if ( foundStart >= 0 ) {
                                    copied.setEvent( foundStart, dumyStart );
                                } else {
                                    copied.addEvent( dumyStart );
                                }

                                if ( end != int.MaxValue ) {
                                    VsqEvent dumyEnd = (VsqEvent)singerAtEnd.clone();
                                    dumyEnd.Clock = end;
                                    if ( foundEnd >= 0 ) {
                                        copied.setEvent( foundEnd, dumyEnd );
                                    } else {
                                        copied.addEvent( dumyEnd );
                                    }
                                }

                                copied.sortEvent();
                            }

                            AppManager.lastRenderedStatus[track - 1] = new RenderedStatus( copied, vsq.TempoTable );
                            AppManager.serializeRenderingStatus( temppath, track );
                        }
                    } catch ( Exception ex ) {
                        PortUtil.stderr.println( "FormMain#patchWorkToFreeze; ex=" + ex );
                    } finally {
                        if ( writer != null ) {
                            try {
                                writer.close();
                            } catch ( Exception ex2 ) {
                                PortUtil.stderr.println( "FormMain#patchWorkToFreeze; ex2=" + ex2 );
                            }
                        }
                    }

                    // 波形表示用のWaveDrawContextの内容を更新する。
                    for ( int i = startIndex[k]; i < startIndex[k + 1] && i < finished; i++ ) {
                        double secStart = vsq.getSecFromClock( startList.get( i ) );
                        int clockEnd = endList.get( i );
                        if ( clockEnd == int.MaxValue ) {
                            clockEnd = vsq.TotalClocks + 240;
                        }
                        double secEnd = vsq.getSecFromClock( clockEnd );

                        waveView.reloadPartial( tracks[k] - 1, wavePath, secStart, secEnd );
                    }
                }
            } catch ( Exception ex ) {
                PortUtil.stderr.println( "FormMain#patchWorkToFreeze; ex=" + ex );
            } finally {
                if ( dialog != null ) {
                    try {
                        dialog.close();
                    } catch ( Exception ex2 ) {
                        PortUtil.stderr.println( "FormMain#patchWorkToFreeez; ex2=" + ex2 );
                    }
                }
            }
        }

        /// <summary>
        /// 指定されたトラックにあるイベントの内、配列areasで指定されたゲートタイム範囲とオーバーラップしているか、
        /// または連続している音符を抽出し、その範囲をzoneに追加します。
        /// </summary>
        /// <param name="zone"></param>
        /// <param name="vsq_track"></param>
        /// <param name="areas"></param>
        private static void checkSerializedEvents( EditedZone zone, VsqTrack vsq_track, EditedZoneUnit[] areas ) {
            if ( vsq_track == null || zone == null || areas == null ) {
                return;
            }
            if ( areas.Length == 0 ) {
                return;
            }
            TreeMap<Integer, Integer> ids = new TreeMap<Integer, Integer>();
            for ( Iterator<Integer> itr = vsq_track.indexIterator( IndexIteratorKind.NOTE ); itr.hasNext(); ) {
                int indx = itr.next();
                VsqEvent item = vsq_track.getEvent( indx );
                int clockStart = item.Clock;
                int clockEnd = clockStart + item.ID.getLength();
                for ( int i = 0; i < areas.Length; i++ ) {
                    EditedZoneUnit area = areas[i];
                    if ( clockStart < area.end && area.end <= clockEnd ) {
                        if ( !ids.containsKey( item.InternalID ) ) {
                            ids.put( item.InternalID, indx );
                            zone.add( clockStart, clockEnd );
                        }
                    } else if ( clockStart <= area.start && area.start < clockEnd ) {
                        if ( !ids.containsKey( item.InternalID ) ) {
                            ids.put( item.InternalID, indx );
                            zone.add( clockStart, clockEnd );
                        }
                    } else if ( area.start <= clockStart && clockEnd < area.end ) {
                        if ( !ids.containsKey( item.InternalID ) ) {
                            ids.put( item.InternalID, indx );
                            zone.add( clockStart, clockEnd );
                        }
                    } else if ( clockStart <= area.start && area.end < clockEnd ) {
                        if ( !ids.containsKey( item.InternalID ) ) {
                            ids.put( item.InternalID, indx );
                            zone.add( clockStart, clockEnd );
                        }
                    }
                }
            }

            // idsに登録された音符のうち、前後がつながっているものを列挙する。
            boolean changed = true;
            int numEvents = vsq_track.getEventCount();
            while ( changed ) {
                changed = false;
                for ( Iterator<Integer> itr = ids.keySet().iterator(); itr.hasNext(); ) {
                    int id = itr.next();
                    int indx = ids.get( id ); // InternalIDがidのアイテムの禁書目録
                    VsqEvent item = vsq_track.getEvent( indx );

                    // アイテムを遡り、連続していれば追加する
                    int clock = item.Clock;
                    for ( int i = indx - 1; i >= 0; i-- ) {
                        VsqEvent search = vsq_track.getEvent( i );
                        if ( search.ID.type != VsqIDType.Anote ) {
                            continue;
                        }
                        int searchClock = search.Clock;
                        int searchLength = search.ID.getLength();
                        if ( searchClock + searchLength == clock ) {
                            if ( !ids.containsKey( search.InternalID ) ) {
                                ids.put( search.InternalID, i );
                                zone.add( searchClock, searchClock + searchLength );
                                changed = true;
                            }
                            clock = searchClock;
                        } else {
                            break;
                        }
                    }

                    // アイテムを辿り、連続していれば追加する
                    clock = item.Clock + item.ID.getLength();
                    for ( int i = indx + 1; i < numEvents; i++ ) {
                        VsqEvent search = vsq_track.getEvent( i );
                        if ( search.ID.type != VsqIDType.Anote ) {
                            continue;
                        }
                        int searchClock = search.Clock;
                        int searchLength = search.ID.getLength();
                        if ( clock == searchClock ) {
                            if ( !ids.containsKey( search.InternalID ) ) {
                                ids.put( search.InternalID, i );
                                zone.add( searchClock, searchClock + searchLength );
                                changed = true;
                            }
                            clock = searchClock + searchLength;
                        } else {
                            break;
                        }
                    }

                    if ( changed ) {
                        break;
                    }
                }
            }
        }
        #endregion

        #region pictPianoRoll
        public void pictPianoRoll_KeyUp( Object sender, BKeyEventArgs e ) {
            processSpecialShortcutKey( e, false );
        }

        public void pictPianoRoll_MouseClick( Object sender, BMouseEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "pictPianoRoll_MouseClick" );
#endif
            int modefiers = PortUtil.getCurrentModifierKey();
            EditMode edit_mode = AppManager.getEditMode();

            boolean is_button_left = e.Button == BMouseButtons.Left;
            int selected = AppManager.getSelected();

            if ( e.Button == BMouseButtons.Left ) {
#if ENABLE_MOUSEHOVER
                if ( m_mouse_hover_thread != null ) {
                    m_mouse_hover_thread.Abort();
                }
#endif

                // クリック位置にIDが無いかどうかを検査
                ByRef<Rectangle> out_id_rect = new ByRef<Rectangle>( new Rectangle() );
                VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_id_rect );
                Rectangle id_rect = out_id_rect.value;
#if DEBUG
                AppManager.debugWriteLine( "    (item==null)=" + (item == null) );
#endif
                if ( item != null &&
                     edit_mode != EditMode.MOVE_ENTRY_WAIT_MOVE &&
                     edit_mode != EditMode.MOVE_ENTRY &&
                     edit_mode != EditMode.MOVE_ENTRY_WHOLE_WAIT_MOVE &&
                     edit_mode != EditMode.MOVE_ENTRY_WHOLE &&
                     edit_mode != EditMode.EDIT_LEFT_EDGE &&
                     edit_mode != EditMode.EDIT_RIGHT_EDGE &&
                     edit_mode != EditMode.MIDDLE_DRAG &&
                     edit_mode != EditMode.CURVE_ON_PIANOROLL ) {
                    if ( (modefiers & InputEvent.SHIFT_MASK) != InputEvent.SHIFT_MASK && (modefiers & s_modifier_key) != s_modifier_key ) {
                        AppManager.clearSelectedEvent();
                    }
                    AppManager.addSelectedEvent( item.InternalID );
                    int internal_id = item.InternalID;
                    hideInputTextBox();
                    if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                        CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventDelete( selected, internal_id ) );
                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                        setEdited( true );
                        AppManager.clearSelectedEvent();
                        return;
#if ENABLE_SCRIPT
                    } else if ( AppManager.getSelectedTool() == EditTool.PALETTE_TOOL ) {
                        Vector<Integer> internal_ids = new Vector<Integer>();
                        for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                            SelectedEventEntry see = itr.next();
                            internal_ids.add( see.original.InternalID );
                        }
                        BMouseButtons btn = e.Button;
                        if ( AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier && m_spacekey_downed && e.Button == System.Windows.Forms.MouseButtons.Left ) {
                            btn = BMouseButtons.Middle;
                        }
                        boolean result = PaletteToolServer.invokePaletteTool( AppManager.selectedPaletteTool,
                                                                              selected,
                                                                              internal_ids.toArray( new Integer[] { } ),
                                                                              btn );
                        if ( result ) {
                            setEdited( true );
                            AppManager.clearSelectedEvent();
                            return;
                        }
#endif
                    }
                } else {
                    if ( edit_mode != EditMode.MOVE_ENTRY_WAIT_MOVE &&
                         edit_mode != EditMode.MOVE_ENTRY &&
                         edit_mode != EditMode.MOVE_ENTRY_WHOLE_WAIT_MOVE &&
                         edit_mode != EditMode.MOVE_ENTRY_WHOLE &&
                         edit_mode != EditMode.EDIT_LEFT_EDGE &&
                         edit_mode != EditMode.EDIT_RIGHT_EDGE ) {
                        if ( !AppManager.isPointerDowned ) {
                            AppManager.clearSelectedEvent();
                        }
                        hideInputTextBox();
                    }
                    if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                        // マウス位置にビブラートの波波があったら削除する
                        int stdx = AppManager.getStartToDrawX();
                        int stdy = AppManager.getStartToDrawY();
                        for ( int i = 0; i < AppManager.drawObjects.get( selected - 1 ).size(); i++ ) {
                            DrawObject dobj = AppManager.drawObjects.get( selected - 1 ).get( i );
                            if ( dobj.pxRectangle.x + AppManager.getStartToDrawX() + dobj.pxRectangle.width - stdx < 0 ) {
                                continue;
                            } else if ( pictPianoRoll.getWidth() < dobj.pxRectangle.x + AppManager.keyWidth - stdx ) {
                                break;
                            }
                            Rectangle rc = new Rectangle( dobj.pxRectangle.x + AppManager.keyWidth + dobj.pxVibratoDelay - stdx,
                                                          dobj.pxRectangle.y + AppManager.editorConfig.PxTrackHeight - stdy,
                                                          dobj.pxRectangle.width - dobj.pxVibratoDelay,
                                                          AppManager.editorConfig.PxTrackHeight );
                            if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                                //ビブラートの範囲なのでビブラートを消す
                                VsqEvent item3 = null;
                                VsqID item2 = null;
                                int internal_id = -1;
                                internal_id = dobj.internalID;
                                for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( selected ).getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = itr.next();
                                    if ( ve.InternalID == dobj.internalID ) {
                                        item2 = (VsqID)ve.ID.clone();
                                        item3 = ve;
                                        break;
                                    }
                                }
                                if ( item2 != null ) {
                                    item2.VibratoHandle = null;
                                    CadenciiCommand run = new CadenciiCommand(
                                        VsqCommand.generateCommandEventChangeIDContaints( selected,
                                                                                          internal_id,
                                                                                          item2 ) );
                                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                    setEdited( true );
                                }
                                break;
                            }
                        }
                    }
                }
            } else if ( e.Button == BMouseButtons.Right ) {
                boolean show_context_menu = (e.X > AppManager.keyWidth);
#if ENABLE_MOUSEHOVER
                if ( m_mouse_hover_thread != null ) {
                    if ( !m_mouse_hover_thread.IsAlive && AppManager.editorConfig.PlayPreviewWhenRightClick ) {
                        show_context_menu = false;
                    }
                } else {
                    if ( AppManager.editorConfig.PlayPreviewWhenRightClick ) {
                        show_context_menu = false;
                    }
                }
#endif
                show_context_menu = AppManager.showContextMenuWhenRightClickedOnPianoroll ? (show_context_menu && !m_mouse_moved) : false;
                if ( show_context_menu ) {
#if ENABLE_MOUSEHOVER
                    if ( m_mouse_hover_thread != null ) {
                        m_mouse_hover_thread.Abort();
                    }
#endif
                    ByRef<Rectangle> out_id_rect = new ByRef<Rectangle>();
                    VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_id_rect );
                    Rectangle id_rect = out_id_rect.value;
                    if ( item != null ) {
                        if ( !AppManager.isSelectedEventContains( AppManager.getSelected(), item.InternalID ) ) {
                            AppManager.clearSelectedEvent();
                        }
                        AppManager.addSelectedEvent( item.InternalID );
                    }
                    boolean item_is_null = (item == null);
                    cMenuPianoCopy.setEnabled( !item_is_null );
                    cMenuPianoCut.setEnabled( !item_is_null );
                    cMenuPianoDelete.setEnabled( !item_is_null );
                    cMenuPianoImportLyric.setEnabled( !item_is_null );
                    cMenuPianoExpressionProperty.setEnabled( !item_is_null );

                    int clock = AppManager.clockFromXCoord( e.X );
                    cMenuPianoPaste.setEnabled( ((AppManager.getCopiedItems().events.size() != 0) && (clock >= AppManager.getVsqFile().getPreMeasureClocks())) );
                    refreshScreen();

                    m_cMenuOpenedPosition = new Point( e.X, e.Y );
                    cMenuPiano.show( pictPianoRoll, e.X, e.Y );
                } else {
                    ByRef<Rectangle> out_id_rect = new ByRef<Rectangle>();
                    VsqEvent item = getItemAtClickedPosition( m_button_initial, out_id_rect );
                    Rectangle id_rect = out_id_rect.value;
#if DEBUG
                    AppManager.debugWriteLine( "pitcPianoRoll_MouseClick; button is right; (item==null)=" + (item == null) );
#endif
                    if ( item != null ) {
                        int itemx = AppManager.xCoordFromClocks( item.Clock );
                        int itemy = AppManager.yCoordFromNote( item.ID.Note );
                    }
                }
            } else if ( e.Button == BMouseButtons.Middle ) {
#if ENABLE_SCRIPT
                if ( AppManager.getSelectedTool() == EditTool.PALETTE_TOOL ) {
                    ByRef<Rectangle> out_id_rect = new ByRef<Rectangle>();
                    VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_id_rect );
                    Rectangle id_rect = out_id_rect.value;
                    if ( item != null ) {
                        AppManager.clearSelectedEvent();
                        AppManager.addSelectedEvent( item.InternalID );
                        Vector<Integer> internal_ids = new Vector<Integer>();
                        for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                            SelectedEventEntry see = itr.next();
                            internal_ids.add( see.original.InternalID );
                        }
                        boolean result = PaletteToolServer.invokePaletteTool( AppManager.selectedPaletteTool,
                                                                           AppManager.getSelected(),
                                                                           internal_ids.toArray( new Integer[] { } ),
                                                                           e.Button );
                        if ( result ) {
                            setEdited( true );
                            AppManager.clearSelectedEvent();
                            return;
                        }
                    }
                }
#endif
            }
        }

        public void pictPianoRoll_MouseDoubleClick( Object sender, BMouseEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "pictureBox1_MouseDoubleClick" );
#endif
            ByRef<Rectangle> out_rect = new ByRef<Rectangle>();
            VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_rect );
            Rectangle rect = out_rect.value;
            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( item != null && item.ID.type == VsqIDType.Anote ) {
#if ENABLE_SCRIPT
                if ( AppManager.getSelectedTool() != EditTool.PALETTE_TOOL )
#endif
                {
                    AppManager.clearSelectedEvent();
                    AppManager.addSelectedEvent( item.InternalID );
#if ENABLE_MOUSEHOVER
                    m_mouse_hover_thread.Abort();
#endif
                    if ( !AppManager.editorConfig.KeepLyricInputMode ) {
                        m_last_symbol_edit_mode = false;
                    }
                    showInputTextBox( item.ID.LyricHandle.L0.Phrase, item.ID.LyricHandle.L0.getPhoneticSymbol(), new Point( rect.x, rect.y ), m_last_symbol_edit_mode );
                    refreshScreen();
                    return;
                }
            } else {
                AppManager.clearSelectedEvent();
                hideInputTextBox();
                if ( AppManager.editorConfig.ShowExpLine && AppManager.keyWidth <= e.X ) {
                    int stdx = AppManager.getStartToDrawX();
                    int stdy = AppManager.getStartToDrawY();
                    for ( Iterator<DrawObject> itr = AppManager.drawObjects.get( selected - 1 ).iterator(); itr.hasNext(); ) {
                        DrawObject dobj = itr.next();
                        // 表情コントロールプロパティを表示するかどうかを決める
                        rect = new Rectangle(
                            dobj.pxRectangle.x + AppManager.keyWidth - stdx,
                            dobj.pxRectangle.y - stdy + AppManager.editorConfig.PxTrackHeight,
                            21,
                            AppManager.editorConfig.PxTrackHeight );
                        if ( isInRect( new Point( e.X, e.Y ), rect ) ) {
                            VsqEvent selectedEvent = null;
                            for ( Iterator<VsqEvent> itr2 = vsq.Track.get( selected ).getEventIterator(); itr2.hasNext(); ) {
                                VsqEvent ev = itr2.next();
                                if ( ev.InternalID == dobj.internalID ) {
                                    selectedEvent = ev;
                                    break;
                                }
                            }
                            if ( selectedEvent != null ) {
#if ENABLE_MOUSEHOVER
                                if ( m_mouse_hover_thread != null ) {
                                    m_mouse_hover_thread.Abort();
                                }
#endif
                                SynthesizerType type = SynthesizerType.VOCALOID2;
                                RendererKind kind = VsqFileEx.getTrackRendererKind( vsq.Track.get( selected ) );
                                if ( kind == RendererKind.VOCALOID1_100 || kind == RendererKind.VOCALOID1_101 ) {
                                    type = SynthesizerType.VOCALOID1;
                                }
                                FormNoteExpressionConfig dlg = null;
                                try {
                                    dlg = new FormNoteExpressionConfig( type, selectedEvent.ID.NoteHeadHandle );
                                    dlg.setPMBendDepth( selectedEvent.ID.PMBendDepth );
                                    dlg.setPMBendLength( selectedEvent.ID.PMBendLength );
                                    dlg.setPMbPortamentoUse( selectedEvent.ID.PMbPortamentoUse );
                                    dlg.setDEMdecGainRate( selectedEvent.ID.DEMdecGainRate );
                                    dlg.setDEMaccent( selectedEvent.ID.DEMaccent );
                                    dlg.setLocation( getFormPreferedLocation( dlg ) );
                                    dlg.setModal( true );
                                    dlg.setVisible( true );
                                    if ( dlg.getDialogResult() == BDialogResult.OK ) {
                                        VsqID id = (VsqID)selectedEvent.ID.clone();
                                        id.PMBendDepth = dlg.getPMBendDepth();
                                        id.PMBendLength = dlg.getPMBendLength();
                                        id.PMbPortamentoUse = dlg.getPMbPortamentoUse();
                                        id.DEMdecGainRate = dlg.getDEMdecGainRate();
                                        id.DEMaccent = dlg.getDEMaccent();
                                        id.NoteHeadHandle = dlg.getEditedNoteHeadHandle();
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandEventChangeIDContaints( selected, selectedEvent.InternalID, id ) );
                                        AppManager.register( vsq.executeCommand( run ) );
                                        setEdited( true );
                                        refreshScreen();
                                    }
                                } catch ( Exception ex ) {
                                    AppManager.reportError( ex, "FormMain#pictPianoRoll_MouseDoubleClick", 0 );
                                } finally {
                                    if ( dlg != null ) {
                                        try {
                                            dlg.close();
                                        } catch ( Exception ex2 ) {
                                            AppManager.reportError( ex2, "FormMain#pictPianoRoll_MouseDoubleClick", 0 );
                                        }
                                    }
                                }
                                return;
                            }
                            break;
                        }

                        // ビブラートプロパティダイアログを表示するかどうかを決める
                        rect = new Rectangle( dobj.pxRectangle.x + AppManager.keyWidth - stdx + 21,
                                              dobj.pxRectangle.y - stdy + AppManager.editorConfig.PxTrackHeight,
                                              dobj.pxRectangle.width - 21,
                                              AppManager.editorConfig.PxTrackHeight );
                        if ( isInRect( new Point( e.X, e.Y ), rect ) ) {
                            VsqEvent selectedEvent = null;
                            for ( Iterator<VsqEvent> itr2 = vsq.Track.get( AppManager.getSelected() ).getEventIterator(); itr2.hasNext(); ) {
                                VsqEvent ev = itr2.next();
                                if ( ev.InternalID == dobj.internalID ) {
                                    selectedEvent = ev;
                                    break;
                                }
                            }
                            if ( selectedEvent != null ) {
#if ENABLE_MOUSEHOVER
                                if ( m_mouse_hover_thread != null ) {
                                    m_mouse_hover_thread.Abort();
                                }
#endif
                                SynthesizerType type = SynthesizerType.VOCALOID2;
                                RendererKind kind = VsqFileEx.getTrackRendererKind( vsq.Track.get( selected ) );
#if DEBUG
                                PortUtil.println( "FormMain#pictPianoRoll_MouseDoubleClick; kind=" + kind );
#endif
                                if ( kind == RendererKind.VOCALOID1_100 || kind == RendererKind.VOCALOID1_101 ) {
                                    type = SynthesizerType.VOCALOID1;
                                }
                                FormVibratoConfig dlg = null;
                                try {
                                    dlg = new FormVibratoConfig( selectedEvent.ID.VibratoHandle, selectedEvent.ID.getLength(), AppManager.editorConfig.DefaultVibratoLength, type );
                                    dlg.setLocation( getFormPreferedLocation( dlg ) );
                                    dlg.setModal( true );
                                    dlg.setVisible( true );
                                    if ( dlg.getDialogResult() == BDialogResult.OK ) {
                                        VsqID t = (VsqID)selectedEvent.ID.clone();
                                        t.VibratoHandle = dlg.getVibratoHandle();
                                        if ( t.VibratoHandle != null ) {
                                            int vibrato_length = t.VibratoHandle.getLength();
                                            int note_length = selectedEvent.ID.getLength();
                                            t.VibratoDelay = note_length - vibrato_length;
                                            //t.VibratoHandle.setStartDepth( AppManager.editorConfig.DefaultVibratoDepth );
                                            //t.VibratoHandle.setStartRate( AppManager.editorConfig.DefaultVibratoRate );
                                        }
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandEventChangeIDContaints( selected,
                                                                                    selectedEvent.InternalID,
                                                                                    t ) );
                                        AppManager.register( vsq.executeCommand( run ) );
                                        setEdited( true );
                                        refreshScreen();
                                    }
                                } catch ( Exception ex ) {
                                } finally {
                                    if ( dlg != null ) {
                                        try {
                                            dlg.close();
                                        } catch ( Exception ex2 ) {
                                        }
                                    }
                                }
                                return;
                            }
                            break;
                        }

                    }
                }
            }

            if ( e.Button == BMouseButtons.Left ){
                // 必要な操作が何も無ければ，クリック位置にソングポジションを移動
                if ( AppManager.keyWidth < e.X ) {
                    int clock = doQuantize( AppManager.clockFromXCoord( e.X ), AppManager.getPositionQuantizeClock() );
                    AppManager.setCurrentClock( clock );
                }
            } else if ( e.Button == BMouseButtons.Middle ) {
                // ツールをポインター <--> 鉛筆に切り替える
                if ( AppManager.keyWidth < e.X ) {
                    if ( AppManager.getSelectedTool() == EditTool.ARROW ) {
                        AppManager.setSelectedTool( EditTool.PENCIL );
                    } else {
                        AppManager.setSelectedTool( EditTool.ARROW );
                    }
                }
            }
        }

        public void pictPianoRoll_MouseDown( Object sender, BMouseEventArgs e0 ) {
#if DEBUG
            AppManager.debugWriteLine( "pictPianoRoll_MouseDown" );
#endif
            if ( AppManager.getEditMode() == EditMode.REALTIME ) {
                return;
            }

            BMouseButtons btn0 = e0.Button;
            if ( AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier && m_spacekey_downed && e0.Button == BMouseButtons.Left ) {
                btn0 = BMouseButtons.Middle;
            }
            BMouseEventArgs e = new BMouseEventArgs( btn0, e0.Clicks, e0.X, e0.Y, e0.Delta );

            m_mouse_moved = false;
            if ( !AppManager.isPlaying() && 0 <= e.X && e.X <= AppManager.keyWidth ) {
                int note = AppManager.noteFromYCoord( e.Y );
                if ( 0 <= note && note <= 126 ) {
                    if ( e.Button == BMouseButtons.Left ) {
                        KeySoundPlayer.play( note );
                    }
                    return;
                }
            }

            AppManager.clearSelectedTempo();
            AppManager.clearSelectedTimesig();
            AppManager.clearSelectedPoint();
            /*if ( e.Button == BMouseButtons.Left ) {
                AppManager.selectedRegionEnabled = false;
            }*/

            m_mouse_downed = true;
            m_button_initial = new Point( e.X, e.Y );
            int modefier = PortUtil.getCurrentModifierKey();
            if ( m_txtbox_track_name != null ) {
#if JAVA
                m_txtbox_track_name.setVisible( false );
#else
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
#endif
                m_txtbox_track_name = null;
            }

            EditTool selected_tool = AppManager.getSelectedTool();
#if ENABLE_SCRIPT
            if ( selected_tool != EditTool.PALETTE_TOOL && e.Button == BMouseButtons.Middle ) {
#else
            if ( e.Button == BMouseButtons.Middle ) {
#endif
                AppManager.setEditMode( EditMode.MIDDLE_DRAG );
                m_middle_button_vscroll = vScroll.getValue();
                m_middle_button_hscroll = hScroll.getValue();
                return;
            }

            int stdx = AppManager.getStartToDrawX();
            int stdy = AppManager.getStartToDrawY();
            if ( e.Button == BMouseButtons.Left && AppManager.curveOnPianoroll && (selected_tool == EditTool.PENCIL || selected_tool == EditTool.LINE) ) {
                pictPianoRoll.mouseTracer.clear();
                pictPianoRoll.mouseTracer.appendFirst( e.X + stdx, e.Y + stdy );
                setCursor( new Cursor( java.awt.Cursor.DEFAULT_CURSOR ) );
                AppManager.setEditMode( EditMode.CURVE_ON_PIANOROLL );
                return;
            }

            ByRef<Rectangle> out_rect = new ByRef<Rectangle>();
            VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_rect );
            Rectangle rect = out_rect.value;

#if ENABLE_SCRIPT
            if ( selected_tool == EditTool.PALETTE_TOOL && item == null && e.Button == BMouseButtons.Middle ) {
                AppManager.setEditMode( EditMode.MIDDLE_DRAG );
                m_middle_button_vscroll = vScroll.getValue();
                m_middle_button_hscroll = hScroll.getValue();
                return;
            }
#endif

            int selected = AppManager.getSelected();
            int key_width = AppManager.keyWidth;

            // マウス位置にある音符を検索
            if ( item == null ) {
                if ( e.Button == BMouseButtons.Left ) {
                    AppManager.setWholeSelectedIntervalEnabled( false );
                }
                #region 音符がなかった時
#if DEBUG
                AppManager.debugWriteLine( "    No Event" );
#endif
                if ( AppManager.getLastSelectedEvent() != null ) {
                    executeLyricChangeCommand();
                }
                boolean start_mouse_hover_generator = true;

                // CTRLキーを押しながら範囲選択
                if ( (modefier & s_modifier_key) == s_modifier_key ) {
                    AppManager.setWholeSelectedIntervalEnabled( true );
                    AppManager.setCurveSelectedIntervalEnabled( false );
                    AppManager.clearSelectedPoint();
                    int startClock = AppManager.clockFromXCoord( e.X );
                    if ( AppManager.editorConfig.CurveSelectingQuantized ) {
                        int unit = AppManager.getPositionQuantizeClock();
                        startClock = doQuantize( startClock, unit );
                    }
                    AppManager.wholeSelectedInterval = new SelectedRegion( startClock );
                    AppManager.wholeSelectedInterval.setEnd( startClock );
                    AppManager.isPointerDowned = true;
                } else {
                    boolean vibrato_found = false;
                    if ( selected_tool == EditTool.LINE || selected_tool == EditTool.PENCIL ) {
                        // ビブラート範囲の編集
                        int px_vibrato_length = 0;
                        m_vibrato_editing_id = -1;
                        Rectangle pxFound = new Rectangle();
                        Vector<DrawObject> target_list = AppManager.drawObjects.get( selected - 1 );
                        int count = target_list.size();
                        for ( int i = 0; i < count; i++ ) {
                            DrawObject dobj = target_list.get( i );
                            if ( dobj.pxRectangle.width <= dobj.pxVibratoDelay ) {
                                continue;
                            }
                            if ( dobj.pxRectangle.x + key_width + dobj.pxRectangle.width - stdx < 0 ) {
                                continue;
                            } else if ( pictPianoRoll.getWidth() < dobj.pxRectangle.x + key_width - stdx ) {
                                break;
                            }
                            Rectangle rc = new Rectangle( dobj.pxRectangle.x + key_width + dobj.pxVibratoDelay - stdx - _EDIT_HANDLE_WIDTH / 2,
                                                dobj.pxRectangle.y + AppManager.editorConfig.PxTrackHeight - stdy,
                                                _EDIT_HANDLE_WIDTH,
                                                AppManager.editorConfig.PxTrackHeight );
                            if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                                vibrato_found = true;
                                m_vibrato_editing_id = dobj.internalID;
                                pxFound = dobj.pxRectangle;
                                pxFound.x += key_width;
                                px_vibrato_length = dobj.pxRectangle.width - dobj.pxVibratoDelay;
                                break;
                            }
                        }
                        if ( vibrato_found ) {
                            int clock = AppManager.clockFromXCoord( pxFound.x + pxFound.width - px_vibrato_length - stdx );
                            int note = AppManager.noteFromYCoord( pxFound.y + AppManager.editorConfig.PxTrackHeight - stdy );
                            int length = (int)(pxFound.width * AppManager.getScaleXInv());
                            AppManager.addingEvent = new VsqEvent( clock, new VsqID( 0 ) );
                            AppManager.addingEvent.ID.type = VsqIDType.Anote;
                            AppManager.addingEvent.ID.Note = note;
                            AppManager.addingEvent.ID.setLength( (int)(px_vibrato_length * AppManager.getScaleXInv()) );
                            AppManager.addingEventLength = length;
                            AppManager.addingEvent.ID.VibratoDelay = length - (int)(px_vibrato_length * AppManager.getScaleXInv());
                            AppManager.setEditMode( EditMode.EDIT_VIBRATO_DELAY );
                            start_mouse_hover_generator = false;
                        }
                    }
                    if ( !vibrato_found ) {
                        if ( (selected_tool == EditTool.PENCIL || selected_tool == EditTool.LINE) &&
                            e.Button == BMouseButtons.Left &&
                            e.X >= key_width ) {
                            int clock = AppManager.clockFromXCoord( e.X );
                            if ( AppManager.getVsqFile().getPreMeasureClocks() - AppManager.editorConfig.PxTolerance * AppManager.getScaleXInv() <= clock ) {
                                //10ピクセルまでは許容範囲
                                if ( AppManager.getVsqFile().getPreMeasureClocks() > clock ) { //だけど矯正するよ。
                                    clock = AppManager.getVsqFile().getPreMeasureClocks();
                                }
                                int note = AppManager.noteFromYCoord( e.Y );
                                AppManager.clearSelectedEvent();
                                int unit = AppManager.getPositionQuantizeClock();
                                int new_clock = doQuantize( clock, unit );
                                AppManager.addingEvent = new VsqEvent( new_clock, new VsqID( 0 ) );
                                AppManager.addingEvent.ID.PMBendDepth = AppManager.editorConfig.DefaultPMBendDepth;
                                AppManager.addingEvent.ID.PMBendLength = AppManager.editorConfig.DefaultPMBendLength;
                                AppManager.addingEvent.ID.PMbPortamentoUse = AppManager.editorConfig.DefaultPMbPortamentoUse;
                                AppManager.addingEvent.ID.DEMdecGainRate = AppManager.editorConfig.DefaultDEMdecGainRate;
                                AppManager.addingEvent.ID.DEMaccent = AppManager.editorConfig.DefaultDEMaccent;
                                if ( m_pencil_mode.getMode() == PencilModeEnum.Off ) {
                                    AppManager.setEditMode( EditMode.ADD_ENTRY );
                                    m_button_initial = new Point( e.X, e.Y );
                                    AppManager.addingEvent.ID.setLength( 0 );
                                    AppManager.addingEvent.ID.Note = note;
                                    setCursor( new Cursor( java.awt.Cursor.DEFAULT_CURSOR ) );
#if DEBUG
                                    AppManager.debugWriteLine( "    EditMode=" + AppManager.getEditMode() );
#endif
                                } else {
                                    AppManager.setEditMode( EditMode.ADD_FIXED_LENGTH_ENTRY );
                                    AppManager.addingEvent.ID.setLength( m_pencil_mode.getUnitLength() );
                                    AppManager.addingEvent.ID.Note = note;
                                    setCursor( new Cursor( java.awt.Cursor.DEFAULT_CURSOR ) );
                                }
                            } else {
#if !JAVA
                                SystemSounds.Asterisk.Play();
#endif
                            }
#if ENABLE_SCRIPT
                        } else if ( (selected_tool == EditTool.ARROW || selected_tool == EditTool.PALETTE_TOOL) && e.Button == BMouseButtons.Left ) {
#else
                        } else if ( (selected_tool == EditTool.ARROW) && e.Button == BMouseButtons.Left ) {
#endif
                            AppManager.setWholeSelectedIntervalEnabled( false );
                            AppManager.clearSelectedEvent();
                            AppManager.mouseDownLocation = new Point( e.X + stdx, e.Y + stdy );
                            AppManager.isPointerDowned = true;
#if DEBUG
                            AppManager.debugWriteLine( "    EditMode=" + AppManager.getEditMode() );
#endif
                        }
                    }
                }
                if ( e.Button == BMouseButtons.Right && !AppManager.editorConfig.PlayPreviewWhenRightClick ) {
                    start_mouse_hover_generator = false;
                }
#if ENABLE_MOUSEHOVER
                if ( start_mouse_hover_generator ) {
                    m_mouse_hover_thread = new Thread( new ParameterizedThreadStart( MouseHoverEventGenerator ) );
                    m_mouse_hover_thread.Start( AppManager.noteFromYCoord( e.Y ) );
                }
#endif
                #endregion
            } else {
                #region 音符があった時
#if DEBUG
                AppManager.debugWriteLine( "    Event Found" );
#endif
                if ( AppManager.isSelectedEventContains( selected, item.InternalID ) ) {
                    executeLyricChangeCommand();
                }
                hideInputTextBox();
                if ( selected_tool != EditTool.ERASER ) {
#if ENABLE_MOUSEHOVER
                    m_mouse_hover_thread = new Thread( new ParameterizedThreadStart( MouseHoverEventGenerator ) );
                    m_mouse_hover_thread.Start( item.ID.Note );
#endif
                }

                // まず、両端の編集モードに移行可能かどうか調べる
                if ( item.ID.type != VsqIDType.Aicon ||
                     (item.ID.type == VsqIDType.Aicon && !item.ID.IconDynamicsHandle.isDynaffType()) ) {
#if ENABLE_SCRIPT
                    if ( selected_tool != EditTool.ERASER && selected_tool != EditTool.PALETTE_TOOL && e.Button == BMouseButtons.Left ) {
#else
                    if ( selected_tool != EditTool.ERASER && e.Button == BMouseButtons.Left ) {
#endif
                        int min_width = 4 * _EDIT_HANDLE_WIDTH;
                        for ( Iterator<DrawObject> itr = AppManager.drawObjects.get( selected - 1 ).iterator(); itr.hasNext(); ) {
                            DrawObject dobj = itr.next();

                            int edit_handle_width = _EDIT_HANDLE_WIDTH;
                            if ( dobj.pxRectangle.width < min_width ) {
                                edit_handle_width = dobj.pxRectangle.width / 4;
                            }

                            // 左端の"のり代"にマウスがあるかどうか
                            Rectangle rc = new Rectangle( dobj.pxRectangle.x - stdx + key_width, 
                                                          dobj.pxRectangle.y - stdy,
                                                          edit_handle_width, 
                                                          dobj.pxRectangle.height );
                            if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                                AppManager.setWholeSelectedIntervalEnabled( false );
                                AppManager.setEditMode( EditMode.EDIT_LEFT_EDGE );
                                if ( !AppManager.isSelectedEventContains( selected, item.InternalID ) ) {
                                    AppManager.clearSelectedEvent();
                                }
                                AppManager.addSelectedEvent( item.InternalID );
#if JAVA
                                setCursor( new Cursor( Cursor.S_RESIZE_CURSOR ) );
#else
                                this.Cursor = System.Windows.Forms.Cursors.VSplit;
#endif
                                refreshScreen();
#if DEBUG
                                AppManager.debugWriteLine( "    EditMode=" + AppManager.getEditMode() );
#endif
                                return;
                            }

                            // 右端の糊代にマウスがあるかどうか
                            rc = new Rectangle( dobj.pxRectangle.x + key_width + dobj.pxRectangle.width - stdx - edit_handle_width,
                                                dobj.pxRectangle.y - stdy,
                                                edit_handle_width,
                                                dobj.pxRectangle.height );
                            if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                                AppManager.setWholeSelectedIntervalEnabled( false );
                                AppManager.setEditMode( EditMode.EDIT_RIGHT_EDGE );
                                if ( !AppManager.isSelectedEventContains( selected, item.InternalID ) ) {
                                    AppManager.clearSelectedEvent();
                                }
                                AppManager.addSelectedEvent( item.InternalID );
#if JAVA
                                setCursor( new Cursor( Cursor.S_RESIZE_CURSOR ) );
#else
                                this.Cursor = System.Windows.Forms.Cursors.VSplit;
#endif
                                refreshScreen();
                                return;
                            }
                        }
                    }
                }

                if ( e.Button == BMouseButtons.Left || e.Button == BMouseButtons.Middle ) {
#if ENABLE_SCRIPT
                    if ( selected_tool == EditTool.PALETTE_TOOL ) {
                        AppManager.setWholeSelectedIntervalEnabled( false );
                        AppManager.setEditMode( EditMode.NONE );
                        AppManager.clearSelectedEvent();
                        AppManager.addSelectedEvent( item.InternalID );
                    } else
#endif
                        if ( selected_tool != EditTool.ERASER ) {
                            m_mouse_move_init = new Point( e.X + stdx, e.Y + stdy );
                            int head_x = AppManager.xCoordFromClocks( item.Clock );
                            m_mouse_move_offset = e.X - head_x;
                            if ( (modefier & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK ) {
                                // 範囲選択
                                int last_id = AppManager.getLastSelectedEvent().original.InternalID;
                                int last_clock = 0;
                                int this_clock = 0;
                                boolean this_found = false, last_found = false;
                                for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( selected ).getEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ev = itr.next();
                                    if ( ev.InternalID == last_id ) {
                                        last_clock = ev.Clock;
                                        last_found = true;
                                    } else if ( ev.InternalID == item.InternalID ) {
                                        this_clock = ev.Clock;
                                        this_found = true;
                                    }
                                    if ( last_found && this_found ) {
                                        break;
                                    }
                                }
                                int start = Math.Min( last_clock, this_clock );
                                int end = Math.Max( last_clock, this_clock );
                                Vector<Integer> add_required = new Vector<Integer>();
                                for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( selected ).getEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ev = itr.next();
                                    if ( start <= ev.Clock && ev.Clock <= end ) {
                                        if ( !add_required.contains( ev.InternalID ) ) {
                                            add_required.add( ev.InternalID );
                                        }
                                    }
                                }
                                if ( !add_required.contains( item.InternalID ) ) {
                                    add_required.add( item.InternalID );
                                }
                                AppManager.addSelectedEventAll( add_required );
                            } else if ( (modefier & s_modifier_key) == s_modifier_key ) {
                                // CTRLキーを押しながら選択／選択解除
                                if ( AppManager.isSelectedEventContains( selected, item.InternalID ) ) {
                                    AppManager.removeSelectedEvent( item.InternalID );
                                } else {
                                    AppManager.addSelectedEvent( item.InternalID );
                                }
                            } else {
                                if ( !AppManager.isSelectedEventContains( selected, item.InternalID ) ) {
                                    // MouseDownしたアイテムが、まだ選択されていなかった場合。当該アイテム単独に選択しなおす
                                    AppManager.clearSelectedEvent();
                                }
                                AppManager.addSelectedEvent( item.InternalID );
                            }

                            // 範囲選択モードで、かつマウス位置の音符がその範囲に入っていた場合にのみ、MOVE_ENTRY_WHOLE_WAIT_MOVEに移行
                            if ( AppManager.isWholeSelectedIntervalEnabled() &&
                                 AppManager.wholeSelectedInterval.getStart() <= item.Clock && item.Clock <= AppManager.wholeSelectedInterval.getEnd() ) {
                                AppManager.setEditMode( EditMode.MOVE_ENTRY_WHOLE_WAIT_MOVE );
                                AppManager.wholeSelectedIntervalStartForMoving = AppManager.wholeSelectedInterval.getStart();
                            } else {
                                AppManager.setWholeSelectedIntervalEnabled( false );
                                AppManager.setEditMode( EditMode.MOVE_ENTRY_WAIT_MOVE );
                            }

                            setCursor( new Cursor( java.awt.Cursor.HAND_CURSOR ) );
#if DEBUG
                            AppManager.debugWriteLine( "    EditMode=" + AppManager.getEditMode() );
                            AppManager.debugWriteLine( "    m_config.SelectedEvent.Count=" + AppManager.getSelectedEventCount() );
#endif
                        }
                }
                #endregion
            }
            refreshScreen();
        }

        private static int doQuantize( int clock, int unit ) {
            int odd = clock % unit;
            int new_clock = clock - odd;
            if ( odd > unit / 2 ) {
                new_clock += unit;
            }
            return new_clock;
        }

        public void pictPianoRoll_MouseMove( Object sender, BMouseEventArgs e ) {
            if ( m_form_activated ) {
#if ENABLE_PROPERTY
#if JAVA
                if ( AppManager.inputTextBox != null && !AppManager.inputTextBox.isVisible() && !AppManager.propertyPanel.isEditing() ) {
#else
                if ( AppManager.inputTextBox != null && !AppManager.inputTextBox.IsDisposed && !AppManager.inputTextBox.isVisible() && !AppManager.propertyPanel.isEditing() ) {
#endif
#else
#if JAVA
                if ( AppManager.inputTextBox != null && !AppManager.inputTextBox.isVisible() ) {
#else
                if ( AppManager.inputTextBox != null && !AppManager.inputTextBox.IsDisposed && !AppManager.inputTextBox.isVisible() ) {
#endif
#endif
                    pictPianoRoll.requestFocus();
                }
            }

            EditMode edit_mode = AppManager.getEditMode();
            int stdx = AppManager.getStartToDrawX();
            int stdy = AppManager.getStartToDrawY();
            int selected = AppManager.getSelected();
            EditTool selected_tool = AppManager.getSelectedTool();

            if ( edit_mode == EditMode.CURVE_ON_PIANOROLL && AppManager.curveOnPianoroll ) {
                pictPianoRoll.mouseTracer.append( e.X + stdx, e.Y + stdy );
                if ( !timer.isRunning() ) {
                    refreshScreen();
                }
                return;
            }

            if ( !m_mouse_moved && edit_mode == EditMode.MIDDLE_DRAG ) {
#if JAVA
                setCursor( new Cursor( java.awt.Cursor.MOVE_CURSOR ) );
#else
                this.Cursor = HAND;
#endif
            }

            if ( e.X != m_button_initial.x || e.Y != m_button_initial.y ) {
                m_mouse_moved = true;
            }
            if ( !(edit_mode == EditMode.MIDDLE_DRAG) && AppManager.isPlaying() ) {
                return;
            }

            if ( edit_mode == EditMode.MOVE_ENTRY_WAIT_MOVE ||
                 edit_mode == EditMode.MOVE_ENTRY_WHOLE_WAIT_MOVE ) {
                int x = e.X + stdx;
                int y = e.Y + stdy;
                if ( m_mouse_move_init.x != x || m_mouse_move_init.y != y ) {
                    if ( edit_mode == EditMode.MOVE_ENTRY_WAIT_MOVE ) {
                        AppManager.setEditMode( EditMode.MOVE_ENTRY );
                        edit_mode = EditMode.MOVE_ENTRY;
                    } else {
                        AppManager.setEditMode( EditMode.MOVE_ENTRY_WHOLE );
                        edit_mode = EditMode.MOVE_ENTRY_WHOLE;
                    }
                }
            }

#if ENABLE_MOUSEHOVER
            if ( m_mouse_moved && m_mouse_hover_thread != null ) {
                m_mouse_hover_thread.Abort();
            }
#endif

            int clock = AppManager.clockFromXCoord( e.X );
            if ( m_mouse_downed ) {
                if ( m_ext_dragx == ExtDragXMode.NONE ) {
                    if ( AppManager.keyWidth > e.X ) {
                        m_ext_dragx = ExtDragXMode.LEFT;
                    } else if ( pictPianoRoll.getWidth() < e.X ) {
                        m_ext_dragx = ExtDragXMode.RIGHT;
                    }
                } else {
                    if ( AppManager.keyWidth <= e.X && e.X <= pictPianoRoll.getWidth() ) {
                        m_ext_dragx = ExtDragXMode.NONE;
                    }
                }

                if ( m_ext_dragy == ExtDragYMode.NONE ) {
                    if ( 0 > e.Y ) {
                        m_ext_dragy = ExtDragYMode.UP;
                    } else if ( pictPianoRoll.getHeight() < e.Y ) {
                        m_ext_dragy = ExtDragYMode.DOWN;
                    }
                } else {
                    if ( 0 <= e.Y && e.Y <= pictPianoRoll.getHeight() ) {
                        m_ext_dragy = ExtDragYMode.NONE;
                    }
                }
            } else {
                m_ext_dragx = ExtDragXMode.NONE;
                m_ext_dragy = ExtDragYMode.NONE;
            }

            double now = 0, dt = 0;
            if ( m_ext_dragx != ExtDragXMode.NONE || m_ext_dragy != ExtDragYMode.NONE ) {
                now = PortUtil.getCurrentTime();
                dt = now - m_timer_drag_last_ignitted;
            }
            if ( m_ext_dragx == ExtDragXMode.RIGHT || m_ext_dragx == ExtDragXMode.LEFT ) {
                int px_move = AppManager.editorConfig.MouseDragIncrement;
                if ( px_move / dt > AppManager.editorConfig.MouseDragMaximumRate ) {
                    px_move = (int)(dt * AppManager.editorConfig.MouseDragMaximumRate);
                }
                double d_draft;
                if ( m_ext_dragx == ExtDragXMode.LEFT ) {
                    px_move *= -1;
                }
                int left_clock = AppManager.clockFromXCoord( AppManager.keyWidth );
                float inv_scale_x = AppManager.getScaleXInv();
                int dclock = (int)(px_move * inv_scale_x);
                d_draft = 5 * inv_scale_x + left_clock + dclock;
                if ( d_draft < 0.0 ) {
                    d_draft = 0.0;
                }
                int draft = (int)d_draft;
                if ( hScroll.getMaximum() < draft ) {
                    if ( edit_mode == EditMode.ADD_ENTRY || 
                         edit_mode == EditMode.MOVE_ENTRY || 
                         edit_mode == EditMode.ADD_FIXED_LENGTH_ENTRY ||
                         edit_mode == EditMode.DRAG_DROP ) {
                        hScroll.setMaximum( draft );
                    } else {
                        draft = hScroll.getMaximum();
                    }
                }
                if ( draft < hScroll.getMinimum() ) {
                    draft = hScroll.getMinimum();
                }
                hScroll.setValue( draft );
            }
            if ( m_ext_dragy == ExtDragYMode.UP || m_ext_dragy == ExtDragYMode.DOWN ) {
                int px_move = AppManager.editorConfig.MouseDragIncrement;
                if ( px_move / dt > AppManager.editorConfig.MouseDragMaximumRate ) {
                    px_move = (int)(dt * AppManager.editorConfig.MouseDragMaximumRate);
                }
                if ( m_ext_dragy == ExtDragYMode.UP ) {
                    px_move *= -1;
                }
                int draft_stdy = stdy + px_move;
                int draft = (int)((draft_stdy * (double)vScroll.getMaximum()) / (128.0 * AppManager.editorConfig.PxTrackHeight - vScroll.getHeight()));
                if ( draft < 0 ) {
                    draft = 0;
                }
                int df = (int)draft;
                if ( df < vScroll.getMinimum() ) {
                    df = vScroll.getMinimum();
                } else if ( vScroll.getMaximum() < df ) {
                    df = vScroll.getMaximum();
                }
                vScroll.setValue( df );
            }
            if ( m_ext_dragx != ExtDragXMode.NONE || m_ext_dragy != ExtDragYMode.NONE ) {
                m_timer_drag_last_ignitted = now;
            }

            // 選択範囲にあるイベントを選択．
            if ( AppManager.isPointerDowned ) {
                if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                    int endClock = AppManager.clockFromXCoord( e.X );
                    if ( AppManager.editorConfig.CurveSelectingQuantized ) {
                        int unit = AppManager.getPositionQuantizeClock();
                        endClock = doQuantize( endClock, unit );
                    }
                    AppManager.wholeSelectedInterval.setEnd( endClock );
                } else {
                    Point mouse = new Point( e.X + stdx, e.Y + stdy );
                    int tx, ty, twidth, theight;
                    int lx = AppManager.mouseDownLocation.x;
                    if ( lx < mouse.x ) {
                        tx = lx;
                        twidth = mouse.x - lx;
                    } else {
                        tx = mouse.x;
                        twidth = lx - mouse.x;
                    }
                    int ly = AppManager.mouseDownLocation.y;
                    if ( ly < mouse.y ) {
                        ty = ly;
                        theight = mouse.y - ly;
                    } else {
                        ty = mouse.y;
                        theight = ly - mouse.y;
                    }

                    Rectangle rect = new Rectangle( tx, ty, twidth, theight );
                    Vector<Integer> add_required = new Vector<Integer>();
                    int internal_id = -1;
                    for ( Iterator<DrawObject> itr = AppManager.drawObjects.get( selected - 1 ).iterator(); itr.hasNext(); ) {
                        DrawObject dobj = itr.next();
                        int x0 = dobj.pxRectangle.x + AppManager.keyWidth;
                        int x1 = dobj.pxRectangle.x + AppManager.keyWidth + dobj.pxRectangle.width;
                        int y0 = dobj.pxRectangle.y;
                        int y1 = dobj.pxRectangle.y + dobj.pxRectangle.height;
                        internal_id = dobj.internalID;
                        if ( x1 < tx ) {
                            continue;
                        }
                        if ( tx + twidth < x0 ) {
                            break;
                        }
                        boolean found = isInRect( new Point( x0, y0 ), rect ) | 
                                        isInRect( new Point( x0, y1 ), rect ) |
                                        isInRect( new Point( x1, y0 ), rect ) |
                                        isInRect( new Point( x1, y1 ), rect );
                        if ( found ) {
                            add_required.add( internal_id );
                        } else {
                            if ( x0 <= tx && tx + twidth <= x1 ) {
                                if ( ty < y0 ) {
                                    if ( y0 <= ty + theight ) {
                                        add_required.add( internal_id );
                                    }
                                } else if ( y0 <= ty && ty < y1 ) {
                                    add_required.add( internal_id );
                                }
                            } else if ( y0 <= ty && ty + theight <= y1 ) {
                                if ( tx < x0 ) {
                                    if ( x0 <= tx + twidth ) {
                                        add_required.add( internal_id );
                                    }
                                } else if ( x0 <= tx && tx < x1 ) {
                                    add_required.add( internal_id );
                                }
                            }
                        }
                    }
                    Vector<Integer> remove_required = new Vector<Integer>();
                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry selectedEvent = itr.next();
                        if ( !add_required.contains( selectedEvent.original.InternalID ) ) {
                            remove_required.add( selectedEvent.original.InternalID );
                        }
                    }
                    if ( remove_required.size() > 0 ) {
                        AppManager.removeSelectedEventRange( PortUtil.convertIntArray( remove_required.toArray( new Integer[] { } ) ) );
                    }
                    for ( Iterator<Integer> itr = add_required.iterator(); itr.hasNext(); ) {
                        int id = itr.next();
                        if ( AppManager.isSelectedEventContains( selected, id ) ) {
                            itr.remove();
                        }
                    }
                    AppManager.addSelectedEventAll( add_required );
                }
            }

            if ( edit_mode == EditMode.MIDDLE_DRAG ) {
                #region MiddleDrag
                int dx = e.X - m_button_initial.x;
                int dy = e.Y - m_button_initial.y;
                double new_vscroll_value = (double)m_middle_button_vscroll - dy * (double)vScroll.getMaximum() / (128.0 * AppManager.editorConfig.PxTrackHeight - (double)vScroll.getHeight());
                double new_hscroll_value = (double)m_middle_button_hscroll - (double)dx * AppManager.getScaleXInv();
                if ( new_vscroll_value < vScroll.getMinimum() ) {
                    vScroll.setValue( vScroll.getMinimum() );
                } else if ( vScroll.getMaximum() < new_vscroll_value ) {
                    vScroll.setValue( vScroll.getMaximum() );
                } else {
                    vScroll.setValue( (int)new_vscroll_value );
                }
                if ( new_hscroll_value < hScroll.getMinimum() ) {
                    hScroll.setValue( hScroll.getMinimum() );
                } else if ( hScroll.getMaximum() < new_hscroll_value ) {
                    hScroll.setValue( hScroll.getMaximum() );
                } else {
                    hScroll.setValue( (int)new_hscroll_value );
                }
                if ( AppManager.isPlaying() ) {
                    return;
                }
                #endregion
                return;
            } else if ( edit_mode == EditMode.ADD_ENTRY ) {
                #region ADD_ENTRY
                int unit = AppManager.getLengthQuantizeClock();
                int length = clock - AppManager.addingEvent.Clock;
                int odd = length % unit;
                int new_length = length - odd;

                if ( unit * AppManager.getScaleX() > 10 ) { //これをしないと、グリッド2個分増えることがある
                    int next_clock = AppManager.clockFromXCoord( e.X + 10 );
                    int next_length = next_clock - AppManager.addingEvent.Clock;
                    int next_new_length = next_length - (next_length % unit);
                    if ( next_new_length == new_length + unit ) {
                        new_length = next_new_length;
                    }
                }

                if ( new_length <= 0 ) {
                    new_length = 0;
                }
                AppManager.addingEvent.ID.setLength( new_length );
                #endregion
            } else if ( edit_mode == EditMode.MOVE_ENTRY || edit_mode == EditMode.MOVE_ENTRY_WHOLE ) {
                #region MOVE_ENTRY, MOVE_ENTRY_WHOLE
                if ( AppManager.getSelectedEventCount() > 0 ) {
                    VsqEvent original = AppManager.getLastSelectedEvent().original;
                    int note = AppManager.noteFromYCoord( e.Y );                           // 現在のマウス位置でのnote
                    int note_init = original.ID.Note;
                    int dnote = (edit_mode == EditMode.MOVE_ENTRY) ? note - note_init : 0;

                    int tclock = AppManager.clockFromXCoord( e.X - m_mouse_move_offset );
                    int clock_init = original.Clock;

                    int dclock = tclock - clock_init;

                    if ( AppManager.editorConfig.getPositionQuantize() != QuantizeMode.off ) {
                        int unit = AppManager.getPositionQuantizeClock();
                        int new_clock = doQuantize( original.Clock + dclock, unit );
                        dclock = new_clock - clock_init;
                    }

                    AppManager.wholeSelectedIntervalStartForMoving = AppManager.wholeSelectedInterval.getStart() + dclock;

                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry item = itr.next();
                        int new_clock = item.original.Clock + dclock;
                        int new_note = item.original.ID.Note + dnote;
                        item.editing.Clock = new_clock;
                        item.editing.ID.Note = new_note;
                    }
                }
                #endregion
            } else if ( edit_mode == EditMode.EDIT_LEFT_EDGE ) {
                #region EditLeftEdge
                int unit = AppManager.getLengthQuantizeClock();
                VsqEvent original = AppManager.getLastSelectedEvent().original;
                int clock_init = original.Clock;
                int dclock = clock - clock_init;
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    int end_clock = item.original.Clock + item.original.ID.getLength();
                    int new_clock = item.original.Clock + dclock;
                    int new_length = doQuantize( end_clock - new_clock, unit );
                    if ( new_length <= 0 ) {
                        new_length = unit;
                    }
                    item.editing.Clock = end_clock - new_length;
                    if ( AppManager.vibratoLengthEditingRule == VibratoLengthEditingRule.PERCENTAGE ) {
                        double percentage = item.original.ID.VibratoDelay / (double)item.original.ID.getLength() * 100.0;
                        int newdelay = (int)(new_length * percentage / 100.0);
                        item.editing.ID.VibratoDelay = newdelay;
                    }
                    item.editing.ID.setLength( new_length );
                }
                #endregion
            } else if ( edit_mode == EditMode.EDIT_RIGHT_EDGE ) {
                #region EditRightEdge
                int unit = AppManager.getLengthQuantizeClock();

                VsqEvent original = AppManager.getLastSelectedEvent().original;
                int dlength = clock - (original.Clock + original.ID.getLength());
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    int new_length = doQuantize( item.original.ID.getLength() + dlength, unit );
                    if ( new_length <= 0 ) {
                        new_length = unit;
                    }
                    if ( AppManager.vibratoLengthEditingRule == VibratoLengthEditingRule.PERCENTAGE ) {
                        double percentage = item.original.ID.VibratoDelay / (double)item.original.ID.getLength() * 100.0;
                        int newdelay = (int)(new_length * percentage / 100.0);
                        item.editing.ID.VibratoDelay = newdelay;
                    }
                    item.editing.ID.setLength( new_length );
#if DEBUG
                    PortUtil.println( "FormMain#pictPianoRoll_MouseMove; length(before,after)=(" + item.original.ID.getLength() + "," + item.editing.ID.getLength() + ")" );
#endif
                }
                #endregion
            } else if ( edit_mode == EditMode.ADD_FIXED_LENGTH_ENTRY ) {
                #region AddFixedLengthEntry
                int note = AppManager.noteFromYCoord( e.Y );
                int unit = AppManager.getPositionQuantizeClock();
                int new_clock = doQuantize( AppManager.clockFromXCoord( e.X ), unit );
                AppManager.addingEvent.ID.Note = note;
                AppManager.addingEvent.Clock = new_clock;
                #endregion
            } else if ( edit_mode == EditMode.EDIT_VIBRATO_DELAY ) {
                #region EditVibratoDelay
                int new_vibrato_start = clock;
                int old_vibrato_end = AppManager.addingEvent.Clock + AppManager.addingEvent.ID.getLength();
                int new_vibrato_length = old_vibrato_end - new_vibrato_start;
                int max_length = (int)(AppManager.addingEventLength - _PX_ACCENT_HEADER * AppManager.getScaleXInv());
                if ( max_length < 0 ) {
                    max_length = 0;
                }
                if ( new_vibrato_length > max_length ) {
                    new_vibrato_start = old_vibrato_end - max_length;
                    new_vibrato_length = max_length;
                }
                if ( new_vibrato_length < 0 ) {
                    new_vibrato_start = old_vibrato_end;
                    new_vibrato_length = 0;
                }
                AppManager.addingEvent.Clock = new_vibrato_start;
                AppManager.addingEvent.ID.setLength( new_vibrato_length );
                if ( !timer.isRunning() ) {
                    refreshScreen();
                }
                #endregion
                return;
            } else if ( edit_mode == EditMode.DRAG_DROP ) {
                #region DRAG_DROP
                // クオンタイズの処理
                int unit = AppManager.getPositionQuantizeClock();
                int clock1 = doQuantize( clock, unit );
                int note = AppManager.noteFromYCoord( e.Y );
                AppManager.addingEvent.Clock = clock1;
                AppManager.addingEvent.ID.Note = note;
                #endregion
            }

            // カーソルの形を決める
            if ( !m_mouse_downed && 
                 edit_mode != EditMode.CURVE_ON_PIANOROLL && 
                 !(AppManager.curveOnPianoroll && (selected_tool == EditTool.PENCIL || selected_tool == EditTool.LINE)) ) {
                boolean split_cursor = false;
                boolean hand_cursor = false;
                int min_width = 4 * _EDIT_HANDLE_WIDTH;
                for ( Iterator<DrawObject> itr = AppManager.drawObjects.get( selected - 1 ).iterator(); itr.hasNext(); ) {
                    DrawObject dobj = itr.next();
                    Rectangle rc;
                    if ( dobj.type != DrawObjectType.Dynaff ) {
                        int edit_handle_width = _EDIT_HANDLE_WIDTH;
                        if ( dobj.pxRectangle.width < min_width ) {
                            edit_handle_width = dobj.pxRectangle.width / 4;
                        }

                        // 音符左側の編集領域
                        rc = new Rectangle(
                                            dobj.pxRectangle.x + AppManager.keyWidth - stdx,
                                            dobj.pxRectangle.y - stdy,
                                            edit_handle_width,
                                            AppManager.editorConfig.PxTrackHeight );
                        if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                            split_cursor = true;
                            break;
                        }

                        // 音符右側の編集領域
                        rc = new Rectangle( dobj.pxRectangle.x + AppManager.keyWidth + dobj.pxRectangle.width - stdx - edit_handle_width,
                                            dobj.pxRectangle.y - stdy,
                                            edit_handle_width,
                                            AppManager.editorConfig.PxTrackHeight );
                        if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                            split_cursor = true;
                            break;
                        }
                    }

                    // 音符本体
                    rc = new Rectangle( dobj.pxRectangle.x + AppManager.keyWidth - stdx,
                                        dobj.pxRectangle.y - stdy,
                                        dobj.pxRectangle.width,
                                        dobj.pxRectangle.height );
                    if ( dobj.type == DrawObjectType.Note ) {
                        if ( AppManager.editorConfig.ShowExpLine && !dobj.isOverlapped ) {
                            rc.height *= 2;
                            if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                                // ビブラートの開始位置
                                rc = new Rectangle( dobj.pxRectangle.x + AppManager.keyWidth + dobj.pxVibratoDelay - stdx - _EDIT_HANDLE_WIDTH / 2,
                                                    dobj.pxRectangle.y + AppManager.editorConfig.PxTrackHeight - stdy,
                                                    _EDIT_HANDLE_WIDTH,
                                                    AppManager.editorConfig.PxTrackHeight );
                                if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                                    split_cursor = true;
                                    break;
                                } else {
                                    hand_cursor = true;
                                    break;
                                }
                            }
                        } else {
                            if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                                hand_cursor = true;
                                break;
                            }
                        }
                    } else {
                        if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                            hand_cursor = true;
                            break;
                        }
                    }
                }

                if ( split_cursor ) {
#if JAVA
                    setCursor( new Cursor( java.awt.Cursor.E_RESIZE_CURSOR ) );
#else
                    Cursor = System.Windows.Forms.Cursors.VSplit;
#endif
                } else if ( hand_cursor ) {
                    setCursor( new Cursor( java.awt.Cursor.HAND_CURSOR ) );
                } else {
                    setCursor( new Cursor( java.awt.Cursor.DEFAULT_CURSOR ) );
                }
            }
            if ( !timer.isRunning() ) {
                refreshScreen();
            }
        }

        /// <summary>
        /// ピアノロールからマウスボタンが離れたときの処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void pictPianoRoll_MouseUp( Object sender, BMouseEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "pictureBox1_MouseUp" );
            AppManager.debugWriteLine( "    m_config.EditMode=" + AppManager.getEditMode() );
#endif
            AppManager.isPointerDowned = false;
            m_mouse_downed = false;

            int modefiers = PortUtil.getCurrentModifierKey();

            EditMode edit_mode = AppManager.getEditMode();
            VsqFileEx vsq = AppManager.getVsqFile();
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );
            CurveType selected_curve = trackSelector.getSelectedCurve();
            int stdx = AppManager.getStartToDrawX();
            int stdy = AppManager.getStartToDrawY();
            double d2_13 = 8192; // = 2^13
            int track_height = AppManager.editorConfig.PxTrackHeight;
            int half_track_height = track_height / 2;

            if ( edit_mode == EditMode.CURVE_ON_PIANOROLL ) {
                if ( pictPianoRoll.mouseTracer.size() > 1 ) {
                    // マウスの軌跡の左右端(px)
                    int px_start = pictPianoRoll.mouseTracer.firstKey();
                    int px_end = pictPianoRoll.mouseTracer.lastKey();

                    // マウスの軌跡の左右端(クロック)
                    int cl_start = AppManager.clockFromXCoord( px_start - stdx );
                    int cl_end = AppManager.clockFromXCoord( px_end - stdx );

                    // 編集が行われたかどうか
                    boolean edited = false;
                    // 作業用のPITカーブのコピー
                    VsqBPList pit = (VsqBPList)vsq_track.getCurve( "pit" ).clone();
                    VsqBPList pbs = (VsqBPList)vsq_track.getCurve( "pbs" ); // こっちはクローンしないよ

                    // トラック内の全音符に対して、マウス軌跡と被っている部分のPITを編集する
                    for ( Iterator<VsqEvent> itr = vsq_track.getNoteEventIterator(); itr.hasNext(); ) {
                        VsqEvent item = itr.next();
                        int cl_item_start = item.Clock;
                        if ( cl_end < cl_item_start ) {
                            break;
                        }
                        int cl_item_end = cl_item_start + item.ID.getLength();
                        if ( cl_item_end < cl_start ) {
                            continue;
                        }

                        // ここに到達するってことは、pitに編集が加えられるってこと。
                        edited = true;
                        
                        // マウス軌跡と被っている部分のPITを削除
                        int cl_remove_start = Math.Max( cl_item_start, cl_start );
                        int cl_remove_end = Math.Min( cl_item_end, cl_end );
                        int value_at_remove_end = pit.getValue( cl_remove_end );
                        int value_at_remove_start = pit.getValue( cl_remove_start );
                        Vector<Integer> remove = new Vector<Integer>();
                        for ( Iterator<Integer> itr2 = pit.keyClockIterator(); itr2.hasNext(); ) {
                            int clock = itr2.next();
                            if ( cl_remove_start <= clock && clock <= cl_remove_end ) {
                                remove.add( clock );
                            }
                        }
                        for ( Iterator<Integer> itr2 = remove.iterator(); itr2.hasNext(); ) {
                            int clock = itr2.next();
                            pit.remove( clock );
                        }
                        remove = null;

                        int px_item_start = AppManager.xCoordFromClocks( cl_item_start ) + stdx;
                        int px_item_end = AppManager.xCoordFromClocks( cl_item_end ) + stdx;

                        int lastv = value_at_remove_start;
                        boolean cl_item_end_added = false;
                        boolean cl_item_start_added = false;
                        int last_px = 0, last_py = 0;
                        for ( Iterator<Point> itr2 = pictPianoRoll.mouseTracer.iterator(); itr2.hasNext(); ) {
                            Point p = itr2.next();
                            if ( p.x < px_item_start ) {
                                last_px = p.x;
                                last_py = p.y;
                                continue;
                            }
                            if ( px_item_end < p.x ) {
                                break;
                            }
                            
                            int clock = AppManager.clockFromXCoord( p.x - stdx );
                            if ( clock < cl_item_start ) {
                                last_px = p.x;
                                last_py = p.y;
                                continue;
                            } else if ( cl_item_end < clock ) {
                                break;
                            }
                            double note = AppManager.noteFromYCoordDoublePrecision( p.y - stdy - half_track_height );
                            int v_pit = (int)(d2_13 / (double)pbs.getValue( clock ) * (note - item.ID.Note));

                            // 正規化
                            if ( v_pit < pit.getMinimum() ) {
                                v_pit = pit.getMinimum();
                            } else if ( pit.getMaximum() < v_pit ) {
                                v_pit = pit.getMaximum();
                            }

                            if ( cl_item_start < clock && !cl_item_start_added &&
                                 cl_start <= cl_item_start && cl_item_start < cl_end ) {
                                // これから追加しようとしているデータ点の時刻が、音符の開始時刻よりも後なんだけれど、
                                // 音符の開始時刻におけるデータをまだ書き込んでない場合
                                double a = (p.y - last_py) / (double)(p.x - last_px);
                                double x_at_clock = AppManager.xCoordFromClocks( cl_item_start ) + stdx;
                                double ext_y = last_py + a * (x_at_clock - last_px);
                                double tnote = AppManager.noteFromYCoordDoublePrecision( (int)(ext_y - stdy - half_track_height) );
                                int t_vpit = (int)(d2_13 / (double)pbs.getValue( cl_item_start ) * (tnote - item.ID.Note));
                                pit.add( cl_item_start, t_vpit );
                                lastv = t_vpit;
                                cl_item_start_added = true;
                            }

                            // 直前の値と違っている場合にのみ追加
                            if ( v_pit != lastv ) {
                                pit.add( clock, v_pit );
                                lastv = v_pit;
                                if ( clock == cl_item_end ) {
                                    cl_item_end_added = true;
                                } else if ( clock == cl_item_start ) {
                                    cl_item_start_added = true;
                                }
                            }
                        }

                        if ( !cl_item_end_added &&
                             cl_start <= cl_item_end && cl_item_end <= cl_end ) {
                             pit.add( cl_item_end, lastv );
                        }

                        pit.add( cl_remove_end, value_at_remove_end );
                    }

                    // 編集操作が行われた場合のみ、コマンドを発行
                    if ( edited ) {
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandTrackCurveReplace( selected, "PIT", pit ) );
                        AppManager.register( vsq.executeCommand( run ) );
                        setEdited( true );
                    }
                }
                pictPianoRoll.mouseTracer.clear();
                AppManager.setEditMode( EditMode.NONE );
                return;
            }

            if ( edit_mode == EditMode.MIDDLE_DRAG ) {
                setCursor( new Cursor( java.awt.Cursor.DEFAULT_CURSOR ) );
            } else if ( edit_mode == EditMode.ADD_ENTRY || edit_mode == EditMode.ADD_FIXED_LENGTH_ENTRY ) {
                #region AddEntry || AddFixedLengthEntry
                if ( AppManager.getSelected() >= 0 ) {
                    if ( (edit_mode == EditMode.ADD_FIXED_LENGTH_ENTRY) ||
                         (edit_mode == EditMode.ADD_ENTRY && (m_button_initial.x != e.X || m_button_initial.y != e.Y) && AppManager.addingEvent.ID.getLength() > 0) ) {
                        LyricHandle lyric = new LyricHandle( "あ", "a" );
                        VibratoHandle vibrato = null;
                        int vibrato_delay = 0;
                        if ( AppManager.editorConfig.EnableAutoVibrato ) {
                            int note_length = AppManager.addingEvent.ID.getLength();
                            // 音符位置での拍子を調べる
                            //int denom, numer;
                            Timesig timesig = vsq.getTimesigAt( AppManager.addingEvent.Clock );

                            // ビブラートを自動追加するかどうかを決める閾値
                            int autovib = AutoVibratoMinLengthUtil.getValue( AppManager.editorConfig.AutoVibratoMinimumLength );
                            int threshold = 480 * 4 / timesig.denominator * autovib;
                            if ( note_length >= threshold ) {
                                int vibrato_clocks = 0;
                                if ( AppManager.editorConfig.DefaultVibratoLength == DefaultVibratoLengthEnum.L100 ) {
                                    vibrato_clocks = note_length;
                                } else if ( AppManager.editorConfig.DefaultVibratoLength == DefaultVibratoLengthEnum.L50 ) {
                                    vibrato_clocks = note_length / 2;
                                } else if ( AppManager.editorConfig.DefaultVibratoLength == DefaultVibratoLengthEnum.L66 ) {
                                    vibrato_clocks = note_length * 2 / 3;
                                } else if ( AppManager.editorConfig.DefaultVibratoLength == DefaultVibratoLengthEnum.L75 ) {
                                    vibrato_clocks = note_length * 3 / 4;
                                }
                                SynthesizerType type = SynthesizerType.VOCALOID2;
                                RendererKind kind = VsqFileEx.getTrackRendererKind( vsq.Track.get( selected ) );
                                if ( kind == RendererKind.VOCALOID1_100 || kind == RendererKind.VOCALOID1_101 ) {
                                    type = SynthesizerType.VOCALOID1;
                                }
                                vibrato = AppManager.editorConfig.createAutoVibrato( type, vibrato_clocks );
                                vibrato_delay = note_length - vibrato_clocks;
                            }
                        }

                        // oto.iniの設定を反映
                        VsqEvent item = vsq_track.getSingerEventAt( AppManager.addingEvent.Clock );
                        SingerConfig singerConfig = AppManager.getSingerInfoUtau( item.ID.IconHandle.Language, item.ID.IconHandle.Program );

                        if ( singerConfig != null && AppManager.utauVoiceDB.containsKey( singerConfig.VOICEIDSTR ) ) {
                            UtauVoiceDB utauVoiceDb = AppManager.utauVoiceDB.get( singerConfig.VOICEIDSTR );
                            OtoArgs otoArgs = utauVoiceDb.attachFileNameFromLyric( lyric.L0.Phrase );
                            AppManager.addingEvent.UstEvent.PreUtterance = otoArgs.msPreUtterance;
                            AppManager.addingEvent.UstEvent.VoiceOverlap = otoArgs.msOverlap;
                        }

                        // 自動ノーマライズのモードで、処理を分岐
                        if ( AppManager.autoNormalize ) {
                            VsqTrack work = (VsqTrack)vsq_track.clone();
                            AppManager.addingEvent.ID.type = VsqIDType.Anote;
                            AppManager.addingEvent.ID.Dynamics = 64;
                            AppManager.addingEvent.ID.VibratoHandle = vibrato;
                            AppManager.addingEvent.ID.LyricHandle = lyric;
                            AppManager.addingEvent.ID.VibratoDelay = vibrato_delay;

                            boolean changed = true;
                            while ( changed ) {
                                changed = false;
                                for ( int i = 0; i < work.getEventCount(); i++ ) {
                                    int start_clock = work.getEvent( i ).Clock;
                                    int end_clock = work.getEvent( i ).ID.getLength() + start_clock;
                                    if ( start_clock < AppManager.addingEvent.Clock && AppManager.addingEvent.Clock < end_clock ) {
                                        work.getEvent( i ).ID.setLength( AppManager.addingEvent.Clock - start_clock );
                                        changed = true;
                                    } else if ( start_clock == AppManager.addingEvent.Clock ) {
                                        work.removeEvent( i );
                                        changed = true;
                                        break;
                                    } else if ( AppManager.addingEvent.Clock < start_clock && start_clock < AppManager.addingEvent.Clock + AppManager.addingEvent.ID.getLength() ) {
                                        AppManager.addingEvent.ID.setLength( start_clock - AppManager.addingEvent.Clock );
                                        changed = true;
                                    }
                                }
                            }
                            VsqEvent add = (VsqEvent)AppManager.addingEvent.clone();
                            work.addEvent( add );
                            CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( selected,
                                                                                         work,
                                                                                         AppManager.getVsqFile().AttachedCurves.get( selected - 1 ) );
                            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                            setEdited( true );
                        } else {
                            VsqEvent[] items = new VsqEvent[1];
                            AppManager.addingEvent.ID.type = VsqIDType.Anote;
                            AppManager.addingEvent.ID.Dynamics = 64;
                            items[0] = (VsqEvent)AppManager.addingEvent.clone();// new VsqEvent( 0, AppManager.addingEvent.ID );
                            items[0].Clock = AppManager.addingEvent.Clock;
                            items[0].ID.LyricHandle = lyric;
                            items[0].ID.VibratoDelay = vibrato_delay;
                            items[0].ID.VibratoHandle = vibrato;

                            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventAddRange( AppManager.getSelected(), items ) );
                            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                            setEdited( true );
                        }
                    }
                }
                #endregion
            } else if ( edit_mode == EditMode.MOVE_ENTRY ) {
                #region MoveEntry
#if DEBUG
                AppManager.debugWriteLine( "    m_config.SelectedEvent.Count=" + AppManager.getSelectedEventCount() );
#endif
                if ( AppManager.getSelectedEventCount() > 0 ) {
                    VsqEvent original = AppManager.getLastSelectedEvent().original;
                    if ( original.Clock != AppManager.getLastSelectedEvent().editing.Clock || original.ID.Note != AppManager.getLastSelectedEvent().editing.ID.Note ) {
                        boolean out_of_range = false; // プリメジャーにめり込んでないかどうか
                        boolean contains_dynamics = false; // Dynaff, Crescend, Desrecendが含まれているかどうか
                        VsqTrack copied = (VsqTrack)vsq_track.clone();
                        int clockAtPremeasure = vsq.getPreMeasureClocks();
                        for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                            SelectedEventEntry ev = itr.next();
                            int internal_id = ev.original.InternalID;
                            if ( ev.editing.Clock < clockAtPremeasure ) {
                                out_of_range = true;
                                break;
                            }
                            if ( ev.editing.ID.Note < 0 || 128 < ev.editing.ID.Note ) {
                                out_of_range = true;
                                break;
                            }
                            for ( Iterator<VsqEvent> itr2 = copied.getEventIterator(); itr2.hasNext(); ) {
                                VsqEvent item = itr2.next();
                                if ( item.InternalID == internal_id ) {
                                    item.Clock = ev.editing.Clock;
                                    item.ID = (VsqID)ev.editing.ID.clone();
                                    break;
                                }
                            }
                            if ( ev.original.ID.type == VsqIDType.Aicon ) {
                                contains_dynamics = true;
                            }
                        }
                        if ( out_of_range ) {
#if !JAVA
                            SystemSounds.Asterisk.Play();
#endif
                        } else {
                            if ( contains_dynamics ) {
                                copied.reflectDynamics();
                            }
                            CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( selected,
                                                                                         copied,
                                                                                         vsq.AttachedCurves.get( selected - 1 ) );
                            AppManager.register( vsq.executeCommand( run ) );
                            AppManager.updateSelectedEventInstance();
                            setEdited( true );
                        }
                    } else {
                        /*if ( (modefier & Keys.Shift) == Keys.Shift || (modefier & Keys.Control) == Keys.Control ) {
                            Rectangle rc;
                            VsqEvent select = IdOfClickedPosition( e.Location, out rc );
                            if ( select != null ) {
                                m_config.addSelectedEvent( item.InternalID );
                            }
                        }*/
                    }
                    lock ( AppManager.drawObjects ) {
                        Collections.sort( AppManager.drawObjects.get( selected - 1 ) );
                    }
                }
                #endregion
            } else if ( edit_mode == EditMode.EDIT_LEFT_EDGE || edit_mode == EditMode.EDIT_RIGHT_EDGE ) {
                #region EDIT_LEFT_EDGE | EDIT_RIGHT_EDGE
                if ( m_mouse_moved ) {
                    VsqEvent original = AppManager.getLastSelectedEvent().original;
                    int count = AppManager.getSelectedEventCount();
                    int[] ids = new int[count];
                    int[] clocks = new int[count];
                    VsqID[] values = new VsqID[count];
                    int i = -1;
                    boolean contains_aicon = false; // dynaff, crescend, decrescendが含まれていればtrue
                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry ev = itr.next();
                        if ( ev.original.ID.type == VsqIDType.Aicon ) {
                            contains_aicon = true;
                        }
                        i++;

                        Utility.editLengthOfVsqEvent( ev.editing, ev.editing.ID.getLength(), AppManager.vibratoLengthEditingRule );
                        ids[i] = ev.original.InternalID;
                        clocks[i] = ev.editing.Clock;
                        values[i] = ev.editing.ID;
                    }

                    CadenciiCommand run = null;
                    if ( contains_aicon ) {
                        VsqFileEx copied_vsq = (VsqFileEx)vsq.clone();
                        VsqCommand vsq_command = 
                            VsqCommand.generateCommandEventChangeClockAndIDContaintsRange( selected,
                                                                                           ids,
                                                                                           clocks,
                                                                                           values );
                        copied_vsq.executeCommand( vsq_command );
                        VsqTrack copied = (VsqTrack)copied_vsq.Track.get( selected ).clone();
                        copied.reflectDynamics();
                        run = VsqFileEx.generateCommandTrackReplace( selected,
                                                                     copied,
                                                                     vsq.AttachedCurves.get( selected - 1 ) );
                    } else {
                        run = new CadenciiCommand(
                            VsqCommand.generateCommandEventChangeClockAndIDContaintsRange( selected,
                                                                                 ids,
                                                                                 clocks,
                                                                                 values ) );
                    }
                    AppManager.register( vsq.executeCommand( run ) );
                    setEdited( true );
                }
                #endregion
            } else if ( edit_mode == EditMode.EDIT_VIBRATO_DELAY ) {
                #region EditVibratoDelay
                if ( m_mouse_moved ) {
                    double max_length = AppManager.addingEventLength - _PX_ACCENT_HEADER * AppManager.getScaleXInv();
                    double rate = AppManager.addingEvent.ID.getLength() / max_length;
                    if ( rate > 0.99 ) {
                        rate = 1.0;
                    }
                    int vibrato_length = (int)(AppManager.addingEventLength * rate);
                    VsqEvent item = null;
                    for ( Iterator<VsqEvent> itr = vsq_track.getNoteEventIterator(); itr.hasNext(); ) {
                        VsqEvent ve = itr.next();
                        if ( ve.InternalID == m_vibrato_editing_id ) {
                            item = (VsqEvent)ve.clone();
                            break;
                        }
                    }
                    if ( item != null ) {
                        if ( vibrato_length <= 0 ) {
                            item.ID.VibratoHandle = null;
                            item.ID.VibratoDelay = item.ID.getLength();
                        } else {
                            item.ID.VibratoHandle.setLength( vibrato_length );
                            item.ID.VibratoDelay = item.ID.getLength() - vibrato_length;
                        }
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandEventChangeIDContaints( selected, m_vibrato_editing_id, item.ID ) );
                        AppManager.register( vsq.executeCommand( run ) );
                        setEdited( true );
                    }
                }
                #endregion
            } else if ( edit_mode == EditMode.MOVE_ENTRY_WHOLE ) {
#if DEBUG
                PortUtil.println( "FormMain#pictPianoRoll_MouseUp; EditMode.MOVE_ENTRY_WHOLE" );
#endif
                #region MOVE_ENTRY_WHOLE
                int src_clock_start = AppManager.wholeSelectedInterval.getStart();
                int src_clock_end = AppManager.wholeSelectedInterval.getEnd();
                int dst_clock_start = AppManager.wholeSelectedIntervalStartForMoving;
                int dst_clock_end = dst_clock_start + (src_clock_end - src_clock_start);
                int dclock = dst_clock_start - src_clock_start;

                int num = AppManager.getSelectedEventCount();
                int[] selected_ids = new int[num]; // 後段での再選択用のInternalIDのリスト
                int last_selected_id = AppManager.getLastSelectedEvent().original.InternalID;

                // 音符イベントを移動
                VsqTrack work = (VsqTrack)vsq_track.clone();
                int k = 0;
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    int internal_id = item.original.InternalID;
                    selected_ids[k] = internal_id;
                    k++;
#if DEBUG
                    PortUtil.println( "FormMain#pictPianoRoll_MouseUp; internal_id=" + internal_id );
#endif
                    for ( Iterator<VsqEvent> itr2 = work.getNoteEventIterator(); itr2.hasNext(); ) {
                        VsqEvent vsq_event = itr2.next();
                        if ( internal_id == vsq_event.InternalID ) {
#if DEBUG
                            PortUtil.println( "FormMain#pictPianoRoll_MouseUp; before: clock=" + vsq_event.Clock + "; after: clock=" + item.editing.Clock );
#endif
                            vsq_event.Clock = item.editing.Clock;
                            break;
                        }
                    }
                }

                // 全てのコントロールカーブのデータ点を移動
                for ( int i = 0; i < Utility.CURVE_USAGE.Length; i++ ) {
                    CurveType curve_type = Utility.CURVE_USAGE[i];
                    VsqBPList bplist = work.getCurve( curve_type.getName() );
                    if ( bplist == null ) {
                        continue;
                    }

                    // src_clock_startからsrc_clock_endの範囲にあるデータ点をコピー＆削除
                    VsqBPList copied = new VsqBPList( bplist.getName(), bplist.getDefault(), bplist.getMinimum(), bplist.getMaximum() );
                    int size = bplist.size();
                    for ( int j = size - 1; j >= 0; j-- ) {
                        int clock = bplist.getKeyClock( j );
                        if ( src_clock_start <= clock && clock <= src_clock_end ) {
                            VsqBPPair bppair = bplist.getElementB( j );
                            copied.add( clock, bppair.value );
                            bplist.removeElementAt( j );
                        }
                    }

                    // dst_clock_startからdst_clock_endの範囲にあるコントロールカーブのデータ点をすべて削除
                    size = bplist.size();
                    for ( int j = size - 1; j >= 0; j-- ) {
                        int clock = bplist.getKeyClock( j );
                        if ( dst_clock_start <= clock && clock <= dst_clock_end ) {
                            bplist.removeElementAt( j );
                        }
                    }

                    // コピーしたデータを、クロックをずらしながら追加
                    size = copied.size();
                    for ( int j = 0; j < size; j++ ) {
                        int clock = copied.getKeyClock( j );
                        VsqBPPair bppair = copied.getElementB( j );
                        bplist.add( clock + dclock, bppair.value );
                    }
                }

                // コマンドを作成＆実行
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( selected,
                                                                             work,
                                                                             vsq.AttachedCurves.get( selected - 1 ) );
                AppManager.register( vsq.executeCommand( run ) );

                // 選択範囲を更新
                AppManager.wholeSelectedInterval = new SelectedRegion( dst_clock_start );
                AppManager.wholeSelectedInterval.setEnd( dst_clock_end );
                AppManager.wholeSelectedIntervalStartForMoving = dst_clock_start;

                // 音符の再選択
                AppManager.clearSelectedEvent();
                Vector<Integer> list_selected_ids = new Vector<Integer>();
                for ( int i = 0; i < num; i++ ) {
                    list_selected_ids.add( selected_ids[i] );
                }
                AppManager.addSelectedEventAll( list_selected_ids );
                AppManager.addSelectedEvent( last_selected_id );

                setEdited( true );
                #endregion
            } else if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                int start = AppManager.wholeSelectedInterval.getStart();
                int end = AppManager.wholeSelectedInterval.getEnd();
#if DEBUG
                PortUtil.println( "FormMain#pictPianoRoll_MouseUp; WholeSelectedInterval; (start,end)=" + start + ", " + end );
#endif
                AppManager.clearSelectedEvent();

                // 音符の選択状態を更新
                Vector<Integer> add_required_event = new Vector<Integer>();
                for ( Iterator<VsqEvent> itr = vsq_track.getEventIterator(); itr.hasNext(); ) {
                    VsqEvent ve = itr.next();
                    if ( start <= ve.Clock && ve.Clock + ve.ID.getLength() <= end ) {
                        add_required_event.add( ve.InternalID );
                    }
                }
                AppManager.addSelectedEventAll( add_required_event );

                // コントロールカーブ点の選択状態を更新
                Vector<Long> add_required_point = new Vector<Long>();
                VsqBPList list = vsq_track.getCurve( selected_curve.getName() );
                if ( list != null ) {
                    int count = list.size();
                    for ( int i = 0; i < count; i++ ) {
                        int clock = list.getKeyClock( i );
                        if ( clock < start ) {
                            continue;
                        } else if ( end < clock ) {
                            break;
                        } else {
                            VsqBPPair v = list.getElementB( i );
                            add_required_point.add( v.id );
                        }
                    }
                }
                if ( add_required_point.size() > 0 ) {
                    AppManager.addSelectedPointAll( selected_curve,
                                                    PortUtil.convertLongArray( add_required_point.toArray( new Long[] { } ) ) );
                }
            }
            refreshScreen();
            if ( AppManager.getEditMode() != EditMode.REALTIME ) {
                AppManager.setEditMode( EditMode.NONE );
            }
        }

        public void pictPianoRoll_MouseWheel( Object sender, BMouseEventArgs e ) {
            boolean horizontal = (PortUtil.getCurrentModifierKey() & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK;
            if ( AppManager.editorConfig.ScrollHorizontalOnWheel ) {
                horizontal = !horizontal;
            }
            if ( e.X <= AppManager.keyWidth || pictPianoRoll.getWidth() < e.X ) {
                horizontal = false;
            }
            if ( horizontal ) {
                hScroll.setValue( computeScrollValueFromWheelDelta( e.Delta ) );
            } else {
                double new_val = (double)vScroll.getValue() - e.Delta;
                if ( new_val > vScroll.getMaximum() ) {
                    vScroll.setValue( vScroll.getMaximum() );
                } else if ( new_val < vScroll.getMinimum() ) {
                    vScroll.setValue( vScroll.getMinimum() );
                } else {
                    vScroll.setValue( (int)new_val );
                }
            }
            refreshScreen();
        }

        public void pictPianoRoll_PreviewKeyDown( Object sender, BPreviewKeyDownEventArgs e ) {
#if JAVA
            BKeyEventArgs e0 = new BKeyEventArgs( e.getRawEvent() );
#else
            BKeyEventArgs e0 = new BKeyEventArgs( e.KeyData );
#endif
            processSpecialShortcutKey( e0, true );
        }
        #endregion

        #region menuVisual*
        public void menuVisualMixer_Click( Object sender, EventArgs e ) {
            menuVisualMixer.setSelected( !menuVisualMixer.isSelected() );
            AppManager.editorConfig.MixerVisible = menuVisualMixer.isSelected();
            AppManager.mixerWindow.setVisible( AppManager.editorConfig.MixerVisible );
            requestFocus();
        }

        public void menuVisualGridline_CheckedChanged( Object sender, EventArgs e ) {
            AppManager.setGridVisible( menuVisualGridline.isSelected() );
            refreshScreen();
        }

        public void menuVisualIconPalette_Click( Object sender, EventArgs e ) {
            if ( AppManager.iconPalette == null ) {
                AppManager.iconPalette = new FormIconPalette();
                AppManager.iconPalette.formClosingEvent.add( new BFormClosingEventHandler( this, "IconPalette_FormClosing" ) );
                Point p = AppManager.editorConfig.FormIconPaletteLocation.toPoint();
                if( !PortUtil.isPointInScreens( p ) ){
                    Rectangle workingArea = PortUtil.getWorkingArea( this );
                    p = new Point( workingArea.x, workingArea.y );
                }
                AppManager.iconPalette.setLocation( p );
                AppManager.iconPalette.locationChangedEvent.add( new BEventHandler( this, "IconPalette_LocationChanged" ) );
                AppManager.iconPalette.setTopMost( AppManager.editorConfig.FormIconTopMost );
            }
            boolean old = menuVisualIconPalette.isSelected();
            menuVisualIconPalette.setSelected( !old );
            AppManager.iconPalette.setVisible( !old );
        }

        public void IconPalette_LocationChanged( Object sender, EventArgs e ) {
            AppManager.editorConfig.FormIconPaletteLocation = new XmlPoint( AppManager.iconPalette.getLocation() );
        }

        public void IconPalette_FormClosing( Object sender, BFormClosingEventArgs e ) {
            menuVisualIconPalette.setSelected( false );
        }

        public void menuVisualLyrics_CheckedChanged( Object sender, EventArgs e ) {
            AppManager.editorConfig.ShowLyric = menuVisualLyrics.isSelected();
        }

        public void menuVisualNoteProperty_CheckedChanged( Object sender, EventArgs e ) {
            AppManager.editorConfig.ShowExpLine = menuVisualNoteProperty.isSelected();
            refreshScreen();
        }

        public void menuVisualPitchLine_CheckedChanged( Object sender, EventArgs e ) {
            AppManager.editorConfig.ViewAtcualPitch = menuVisualPitchLine.isSelected();
        }

        public void menuVisualControlTrack_CheckedChanged( Object sender, EventArgs e ) {
            trackSelector.setCurveVisible( menuVisualControlTrack.isSelected() );
            if ( menuVisualControlTrack.isSelected() ) {
                splitContainer1.setSplitterFixed( false );
                splitContainer1.setDividerSize( _SPL_SPLITTER_WIDTH );
                splitContainer1.setDividerLocation( splitContainer1.getHeight() - AppManager.lastTrackSelectorHeight - splitContainer1.getDividerSize() );
                splitContainer1.setPanel2MinSize( trackSelector.getPreferredMinSize() );
            } else {
                AppManager.lastTrackSelectorHeight = splitContainer1.getHeight() - splitContainer1.getDividerLocation() - splitContainer1.getDividerSize();
                splitContainer1.setSplitterFixed( true );
                splitContainer1.setDividerSize( 0 );
                int panel2height = TrackSelector.OFFSET_TRACK_TAB * 2;
                splitContainer1.setDividerLocation( splitContainer1.getHeight() - panel2height - splitContainer1.getDividerSize() );
                splitContainer1.setPanel2MinSize( panel2height );
            }
            refreshScreen();
        }

        public void menuHiddenVisualForwardParameter_Click( Object sender, EventArgs e ) {
            trackSelector.SelectNextCurve();
        }

        public void menuHiddenVisualBackwardParameter_Click( Object sender, EventArgs e ) {
            trackSelector.SelectPreviousCurve();
        }

        public void menuVisualWaveform_CheckedChanged( Object sender, EventArgs e ) {
            AppManager.editorConfig.ViewWaveform = menuVisualWaveform.isSelected();
            updateSplitContainer2Size();
        }

        public void menuVisualControlTrack_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Show/Hide control curves." ) );
        }

        public void menuVisualMixer_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Show/Hide mixer window." ) );
        }

        public void menuVisualWaveform_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Show/Hide waveform." ) );
        }

        public void menuVisualProperty_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Show/Hide property window." ) );
        }

        public void menuVisualGridline_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Show/Hide grid line." ) );
        }

        public void menuVisualStartMarker_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Enable/Disable start marker." ) );
        }

        public void menuVisualEndMarker_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Enable/Disable end marker." ) );
        }

        public void menuVisualLyrics_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Show/Hide lyrics." ) );
        }

        public void menuVisualNoteProperty_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Show/Hide expression lines." ) );
        }

        public void menuVisualPitchLine_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Show/Hide pitch bend lines." ) );
        }

        public void menuVisualPluginUi_DropDownOpening( Object sender, EventArgs e ) {
#if ENABLE_VOCALOID
            // VOCALOID1, 2
            int c = VSTiProxy.vocaloidDriver.size();
            for( int i = 0; i < c; i++ ){
                VocaloidDriver vd = VSTiProxy.vocaloidDriver.get( i );
                boolean chkv = true;
                if ( vd == null ){
                    chkv = false;
                } else if ( !vd.loaded ){
                    chkv = false;
                } else if ( vd.getUi() == null ){
                    chkv = false;
                } else if ( vd.getUi().IsDisposed ){
                    chkv = false;
                } else if ( !vd.getUi().isVisible() ){
                    chkv = false;
                }
                RendererKind kind = vd.kind;
                if ( kind == RendererKind.VOCALOID1_100 ) {
                    menuVisualPluginUiVocaloid100.setSelected( chkv );
                } else if ( kind == RendererKind.VOCALOID1_101 ) {
                    menuVisualPluginUiVocaloid101.setSelected( chkv );
                } else if ( kind == RendererKind.VOCALOID2 ) {
                    menuVisualPluginUiVocaloid2.setSelected( chkv );
                }
            }
#endif

#if ENABLE_AQUESTONE
            // AquesTone
            AquesToneDriver drv = VSTiProxy.aquesToneDriver;
            boolean chk = true;
            if ( drv == null ) {
                chk = false;
            } else if( !drv.loaded ){
                chk = false;
            } else if ( drv.getUi() == null ) {
                chk = false;
            } else if ( drv.getUi().IsDisposed ) {
                chk = false;
            } else if ( !drv.getUi().isVisible() ) {
                chk = false;
            }
            menuVisualPluginUiAquesTone.setSelected( chk );
#endif
        }

        public void menuVisualPluginUiVocaloidCommon_Click( Object sender, EventArgs e ) {
            RendererKind search = RendererKind.NULL;
            //int vocaloid = 0;
            if ( sender == menuVisualPluginUiVocaloid100 ) {
                search = RendererKind.VOCALOID1_100;
                //vocaloid = 1;
            } else if ( sender == menuVisualPluginUiVocaloid2 ) {
                search = RendererKind.VOCALOID2;
                //vocaloid = 2;
            } else if ( sender == menuVisualPluginUiVocaloid101 ) {
                search = RendererKind.VOCALOID1_101;
            } else {
                return;
            }
#if DEBUG
            PortUtil.println( "FormMain#menuVisualPluginVocaloidCommon_Click; search=" + search );
#endif

#if ENABLE_VOCALOID
            int c = VSTiProxy.vocaloidDriver.size();
            for ( int i = 0; i < c; i++ ) {
                VocaloidDriver vd = VSTiProxy.vocaloidDriver.get( i );
                boolean chk = true;
                if ( vd == null ) {
                    chk = false;
                } else if ( !vd.loaded ) {
                    chk = false;
                } else if ( vd.getUi() == null ) {
                    chk = false;
                } else if ( vd.getUi().IsDisposed ) {
                    chk = false;
                }
                if ( !chk ) {
                    continue;
                }
                RendererKind kind = vd.kind;
                boolean v = true;
                if ( kind == search ) {
                    if ( search == RendererKind.VOCALOID1_100 ) {
                        v = !menuVisualPluginUiVocaloid100.isSelected();
                        menuVisualPluginUiVocaloid100.setSelected( v );
                        vd.getUi().setVisible( v );
                    } else if ( search == RendererKind.VOCALOID1_101 ) {
                        v = !menuVisualPluginUiVocaloid101.isSelected();
                        menuVisualPluginUiVocaloid101.setSelected( v );
                        vd.getUi().setVisible( v );
                    } else if ( search == RendererKind.VOCALOID2 ) {
                        v = !menuVisualPluginUiVocaloid2.isSelected();
                        menuVisualPluginUiVocaloid2.setSelected( v );
                        vd.getUi().setVisible( v );
                    }
                    break;
                }
            }
#endif
        }

        public void menuVisualPluginUiAquesTone_Click( Object sender, EventArgs e ) {
            boolean visible = !menuVisualPluginUiAquesTone.isSelected();
            menuVisualPluginUiAquesTone.setSelected( visible );

#if ENABLE_AQUESTONE
            AquesToneDriver drv = VSTiProxy.aquesToneDriver;
            boolean chk = true;
            if ( drv == null ) {
                chk = false;
            } else if ( !drv.loaded ) {
                chk = false;
            } else if ( drv.getUi() == null ) {
                chk = false;

            } else if ( drv.getUi().IsDisposed ) {
                chk = false;
            }
            if ( !chk ) {
                menuVisualPluginUiAquesTone.setSelected( false );
                return;
            }
            drv.getUi().setVisible( visible );
#endif
        }
        #endregion

        #region m_mixer_dlg
        public void m_mixer_dlg_SoloChanged( int track, boolean solo ) {
#if DEBUG
            AppManager.debugWriteLine( "m_mixer_dlg_SoloChanged" );
            AppManager.debugWriteLine( "    track=" + track );
            AppManager.debugWriteLine( "    solo=" + solo );
#endif
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }
            vsq.setSolo( track, solo );
            if ( AppManager.mixerWindow != null ) {
                AppManager.mixerWindow.updateSoloMute();
            }
        }

        public void m_mixer_dlg_MuteChanged( int track, boolean mute ) {
#if DEBUG
            AppManager.debugWriteLine( "m_mixer_dlg_MuteChanged" );
            AppManager.debugWriteLine( "    track=" + track );
            AppManager.debugWriteLine( "    mute=" + mute );
#endif
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }
            if ( track < 0 ) {
                AppManager.getBgm( -track - 1 ).mute = mute ? 1 : 0;
            } else {
                vsq.setMute( track, mute );
            }
            if ( AppManager.mixerWindow != null ) {
                AppManager.mixerWindow.updateSoloMute();
            }
        }

        public void m_mixer_dlg_PanpotChanged( int track, int panpot ) {
            if ( track == 0 ) {
                // master
                AppManager.getVsqFile().Mixer.MasterPanpot = panpot;
            } else if ( track > 0 ) {
                // slave
                AppManager.getVsqFile().Mixer.Slave.get( track - 1 ).Panpot = panpot;
            } else {
                AppManager.getBgm( -track - 1 ).panpot = panpot;
            }
        }

        public void m_mixer_dlg_FederChanged( int track, int feder ) {
#if DEBUG
            PortUtil.println( "FormMain#m_mixer_dlg_FederChanged; track=" + track + "; feder=" + feder );
#endif
            if ( track == 0 ) {
                AppManager.getVsqFile().Mixer.MasterFeder = feder;
            } else if ( track > 0 ) {
                AppManager.getVsqFile().Mixer.Slave.get( track - 1 ).Feder = feder;
            } else {
                AppManager.getBgm( -track - 1 ).feder = feder;
            }
        }

        public void m_mixer_dlg_TopMostChanged( Object sender, boolean arg ) {
            AppManager.editorConfig.MixerTopMost = arg;
        }
        #endregion

        #region FormMain
        public void FormMain_FormClosed( Object sender, BFormClosedEventArgs e ) {
            clearTempWave();
            String tempdir = PortUtil.combinePath( AppManager.getCadenciiTempDir(), AppManager.getID() );
            if ( !PortUtil.isDirectoryExists( tempdir ) ) {
                PortUtil.createDirectory( tempdir );
            }
            String log = PortUtil.combinePath( tempdir, "run.log" );
#if !JAVA
            org.kbinani.debug.close();
#endif
            try {
                if ( PortUtil.isFileExists( log ) ) {
                    PortUtil.deleteFile( log );
                }
                PortUtil.deleteDirectory( tempdir, true );
            } catch ( Exception ex ) {
                PortUtil.stderr.println( "FormMain#FormMain_FormClosed; ex=" + ex );
            }
            VSTiProxy.abortRendering();
            VSTiProxy.terminate();
#if ENABLE_MIDI
            MidiPlayer.Stop();
            if ( m_midi_in != null ) {
                m_midi_in.Close();
            }
#endif
#if ENABLE_MTC
            if ( m_midi_in_mtc != null ) {
                m_midi_in_mtc.Close();
            }
#endif
            PlaySound.kill();
            Utility.cleanupUnusedAssemblyCache();
#if JAVA
            System.exit( 0 );
#endif
        }

        public void FormMain_FormClosing( Object sender, BFormClosingEventArgs e ) {
            if ( isEdited() ) {
                String file = AppManager.getFileName();
                if ( file.Equals( "" ) ) {
                    file = "Untitled";
                } else {
                    file = PortUtil.getFileName( file );
                }
                BDialogResult ret = AppManager.showMessageBox( _( "Save this sequence?" ),
                                                               _( "Affirmation" ),
                                                               org.kbinani.windows.forms.Utility.MSGBOX_YES_NO_CANCEL_OPTION,
                                                               org.kbinani.windows.forms.Utility.MSGBOX_QUESTION_MESSAGE );
                if ( ret == BDialogResult.YES ) {
                    if ( AppManager.getFileName().Equals( "" ) ) {
                        int dr = saveXmlVsqDialog.showSaveDialog( this );
                        if ( dr == BFileChooser.APPROVE_OPTION ) {
                            AppManager.saveTo( saveXmlVsqDialog.getSelectedFile() );
                        } else {
                            e.Cancel = true;
                            return;
                        }
                    } else {
                        AppManager.saveTo( AppManager.getFileName() );
                    }

                } else if ( ret == BDialogResult.CANCEL ) {
                    e.Cancel = true;
                    return;
                }
            }
            AppManager.editorConfig.WindowMaximized = (getExtendedState() == BForm.MAXIMIZED_BOTH);
            if ( AppManager.iconPalette != null ) {
                AppManager.editorConfig.FormIconTopMost = AppManager.iconPalette.isAlwaysOnTop();
            }
            AppManager.saveConfig();
            UtauRenderingRunner.clearCache();
            StraightRenderingRunner.clearCache();
#if ENABLE_MIDI
            if ( m_midi_in != null ) {
                m_midi_in.Dispose();
            }
#endif
#if !JAVA
            bgWorkScreen.Dispose();
#endif
            e.Cancel = false;
        }

        public void FormMain_Load( Object sender, EventArgs e ) {
            applyLanguage();
            trackBar.setValue( AppManager.editorConfig.DefaultXScale );
            AppManager.setCurrentClock( 0 );
            setEdited( false );

            AppManager.previewStartedEvent.add( new BEventHandler( this, "AppManager_PreviewStarted" ) );
            AppManager.previewAbortedEvent.add( new BEventHandler( this, "AppManager_PreviewAborted" ) );
            AppManager.gridVisibleChangedEvent.add( new BEventHandler( this, "AppManager_GridVisibleChanged" ) );
            AppManager.selectedEventChangedEvent.add( new SelectedEventChangedEventHandler( this, "AppManager_SelectedEventChanged" ) );
            AppManager.selectedToolChangedEvent.add( new BEventHandler( this, "AppManager_SelectedToolChanged" ) );
            EditorConfig.quantizeModeChangedEvent.add( new BEventHandler( this, "EditorConfig_QuantizeModeChanged" ) );

#if ENABLE_PROPERTY
            m_property_panel_container.StateChangeRequired += new StateChangeRequiredEventHandler( m_property_panel_container_StateChangeRequired );
#endif

            updateRecentFileMenu();

            // C3が画面中央に来るように調整
            int draft_start_to_draw_y = 68 * AppManager.editorConfig.PxTrackHeight - pictPianoRoll.getHeight() / 2;
            int draft_vscroll_value = (int)((draft_start_to_draw_y * (double)vScroll.getMaximum()) / (128 * AppManager.editorConfig.PxTrackHeight - vScroll.getHeight()));
            try {
                vScroll.setValue( draft_vscroll_value );
            } catch ( Exception ex ) {
            }

            // x=97がプリメジャークロックになるように調整
            int cp = AppManager.getVsqFile().getPreMeasureClocks();
            int draft_hscroll_value = (int)(cp - 24.0 * AppManager.getScaleXInv());
            try {
                hScroll.setValue( draft_hscroll_value );
            } catch ( Exception ex ) {
            }

            //s_pen_dashed_171_171_171.DashPattern = new float[] { 3, 3 };
            //s_pen_dashed_209_204_172.DashPattern = new float[] { 3, 3 };

            menuVisualNoteProperty.setSelected( AppManager.editorConfig.ShowExpLine );
            menuVisualLyrics.setSelected( AppManager.editorConfig.ShowLyric );
            menuVisualMixer.setSelected( AppManager.editorConfig.MixerVisible );
            menuVisualPitchLine.setSelected( AppManager.editorConfig.ViewAtcualPitch );

            AppManager.mixerWindow = new FormMixer( this );

            updateMenuFonts();

            AppManager.mixerWindow.federChangedEvent.add( new FederChangedEventHandler( this, "m_mixer_dlg_FederChanged" ) );
            AppManager.mixerWindow.panpotChangedEvent.add( new PanpotChangedEventHandler( this, "m_mixer_dlg_PanpotChanged" ) );
            AppManager.mixerWindow.muteChangedEvent.add( new MuteChangedEventHandler( this, "m_mixer_dlg_MuteChanged" ) );
            AppManager.mixerWindow.soloChangedEvent.add( new SoloChangedEventHandler( this, "m_mixer_dlg_SoloChanged" ) );
            AppManager.mixerWindow.topMostChangedEvent.add( new TopMostChangedEventHandler( this, "m_mixer_dlg_TopMostChanged" ) );
            AppManager.mixerWindow.setShowTopMost( AppManager.editorConfig.MixerTopMost );
            AppManager.mixerWindow.updateStatus();
            if ( AppManager.editorConfig.MixerVisible ) {
                AppManager.mixerWindow.setVisible( true );
            }

            trackSelector.commandExecutedEvent.add( new BEventHandler( this, "trackSelector_CommandExecuted" ) );

#if ENABLE_SCRIPT
            updateScriptShortcut();
            // RunOnceという名前のスクリプトがあれば，そいつを実行
            for ( Iterator<String> itr = ScriptServer.getScriptIdIterator(); itr.hasNext(); ) {
                String id = itr.next();
                if ( PortUtil.getFileNameWithoutExtension( id ).ToLower().Equals( "runonce" ) ) {
                    ScriptServer.invokeScript( id, AppManager.getVsqFile() );
                    break;
                }
            }
#endif

            clearTempWave();
            setHScrollRange( AppManager.getVsqFile().TotalClocks );
            setVScrollRange( vScroll.getMaximum() );
            m_pencil_mode.setMode( PencilModeEnum.Off );
            updateCMenuPianoFixed();
            loadGameControler();
#if ENABLE_MIDI
            reloadMidiIn();
#endif
            menuVisualWaveform.setSelected( AppManager.editorConfig.ViewWaveform );
            updateSplitContainer2Size();

            updateRendererMenu();

            if ( AppManager.editorConfig.WindowMaximized ) {
                setExtendedState( BForm.MAXIMIZED_BOTH );
            } else {
                setExtendedState( BForm.NORMAL );
            }
            this.setBounds( AppManager.editorConfig.WindowRect );

            // プロパティウィンドウの位置を復元
            Rectangle rc1 = PortUtil.getScreenBounds( this );
            Rectangle rcScreen = new Rectangle( rc1.x, rc1.y, rc1.width, rc1.height );
            Point p = this.getLocation();
            XmlRectangle xr = AppManager.editorConfig.PropertyWindowStatus.Bounds;
            Point p0 = new Point( xr.x, xr.y );
            Point a = new Point( p.x + p0.x, p.y + p0.y );
            Rectangle rc = new Rectangle( a.x,
                                          a.y,
                                          AppManager.editorConfig.PropertyWindowStatus.Bounds.getWidth(),
                                          AppManager.editorConfig.PropertyWindowStatus.Bounds.getHeight() );

            if ( a.y > rcScreen.y + rcScreen.height ) {
                a = new Point( a.x, rcScreen.y + rcScreen.height - rc.height );
            }
            if ( a.y < rcScreen.y ) {
                a = new Point( a.x, rcScreen.y );
            }
            if ( a.x > rcScreen.x + rcScreen.width ) {
                a = new Point( rcScreen.x + rcScreen.width - rc.width, a.y );
            }
            if ( a.x < rcScreen.x ) {
                a = new Point( rcScreen.x, a.y );
            }
#if DEBUG
            AppManager.debugWriteLine( "FormMain_Load; a=" + a );
#endif

#if ENABLE_PROPERTY
            AppManager.propertyWindow.setBounds( a.x, a.y, rc.width, rc.height );
            AppManager.propertyWindow.LocationChanged += new EventHandler( m_note_proerty_dlg_LocationOrSizeChanged );
            AppManager.propertyWindow.SizeChanged += new EventHandler( m_note_proerty_dlg_LocationOrSizeChanged );
            AppManager.propertyWindow.FormClosing += new System.Windows.Forms.FormClosingEventHandler( m_note_proerty_dlg_FormClosing );
            AppManager.propertyPanel.CommandExecuteRequired += new CommandExecuteRequiredEventHandler( m_note_proerty_dlg_CommandExecuteRequired );
            AppManager.propertyWindow.setFormCloseShortcutKey( AppManager.editorConfig.getShortcutKeyFor( menuVisualProperty ) );
            updatePropertyPanelState( AppManager.editorConfig.PropertyWindowStatus.State );
#endif
            updateBgmMenuState();

#if JAVA
            sizeChangedEvent.add( new BEventHandler( this, "FormMain_SizeChanged" ) );
            locationChangedEvent.add( new BEventHandler( this, "FormMain_LocationChanged" ) );
#else
            this.SizeChanged += new System.EventHandler( this.FormMain_SizeChanged );
            this.LocationChanged += new System.EventHandler( this.FormMain_LocationChanged );
#endif
            repaint();
            updateLayout();
#if DEBUG
            menuHidden.setVisible( true );
#endif

            // 鍵盤用のキャッシュが古い位置に保存されている場合。
            String cache_new = Utility.getKeySoundPath();
            String cache_old = PortUtil.combinePath( PortUtil.getApplicationStartupPath(), "cache" );
            if ( PortUtil.isDirectoryExists( cache_old ) ) {
                boolean exists = false;
                for ( int i = 0; i < 127; i++ ) {
                    String s = PortUtil.combinePath( cache_new, i + ".wav" );
                    if ( PortUtil.isFileExists( s ) ) {
                        exists = true;
                        break;
                    }
                }

                // 新しいキャッシュが1つも無い場合に、古いディレクトリからコピーする
                if ( !exists ) {
                    for ( int i = 0; i < 127; i++ ) {
                        String wav_from = PortUtil.combinePath( cache_old, i + ".wav" );
                        String wav_to = PortUtil.combinePath( cache_new, i + ".wav" );
                        if ( PortUtil.isFileExists( wav_from ) ) {
                            try {
                                PortUtil.copyFile( wav_from, wav_to );
                                PortUtil.deleteFile( wav_from );
                            } catch ( Exception ex ) {
                                PortUtil.stderr.println( "FormMain#FormMain_Load; ex=" + ex );
                            }
                        }
                    }
                }
            }

            // 足りてないキャッシュがひとつでもあればFormGenerateKeySound発動する
            boolean cache_is_incomplete = false;
            for ( int i = 0; i < 127; i++ ) {
                String wav = PortUtil.combinePath( cache_new, i + ".wav" );
                if ( !PortUtil.isFileExists( wav ) ) {
                    cache_is_incomplete = true;
                    break;
                }
            }

            boolean init_key_sound_player_immediately = true; //FormGenerateKeySoundの終了を待たずにKeySoundPlayer.initするかどうか。
            if ( !AppManager.editorConfig.DoNotAskKeySoundGeneration && cache_is_incomplete ) {
                FormAskKeySoundGeneration dialog = null;
                BDialogResult dialog_result = BDialogResult.NO;
                boolean always_check_this = !AppManager.editorConfig.DoNotAskKeySoundGeneration;
                try {
                    dialog = new FormAskKeySoundGeneration();
                    dialog.setAlwaysPerformThisCheck( always_check_this );
                    AppManager.beginShowDialog();
                    dialog.setModal( true );
                    dialog.setVisible( true );
                    dialog_result = dialog.getDialogResult();
                    AppManager.endShowDialog();
                    always_check_this = dialog.isAlwaysPerformThisCheck();
                } catch ( Exception ex ) {
                    PortUtil.stderr.println( "FormMain#FormMain_Load; ex=" + ex );
                } finally {
                    if ( dialog != null ) {
                        try {
                            dialog.close();
                        } catch ( Exception ex2 ) {
                            PortUtil.stderr.println( "FormMain#FormMain_Load; ex2=" + ex2 );
                        }
                    }
                }
                AppManager.editorConfig.DoNotAskKeySoundGeneration = !always_check_this;

                if ( dialog_result == BDialogResult.YES ) {
                    FormGenerateKeySound form = null;
                    try {
                        form = new FormGenerateKeySound( true );
                        form.formClosedEvent.add( new BFormClosedEventHandler( this, "FormGenerateKeySound_FormClosed" ) );
                        form.setVisible( true );
                    } catch ( Exception ex ) {
                        PortUtil.stderr.println( "FormMain#FormMain_Load; ex=" + ex );
                    }
                    init_key_sound_player_immediately = false;
                }
            }

            if ( init_key_sound_player_immediately ) {
                try {
                    KeySoundPlayer.init();
                } catch ( Exception ex ) {
                    PortUtil.stderr.println( "FormMain#FormMain_Load; ex=" + ex );
                }
            }
        }

        public void FormGenerateKeySound_FormClosed( Object sender, BFormClosedEventArgs e ) {
            try {
                KeySoundPlayer.init();
            } catch ( Exception ex ) {
                PortUtil.stderr.println( "FormMain#FormGenerateKeySound_FormClosed; ex=" + ex );
            }
        }

#if ENABLE_PROPERTY
        public void m_property_panel_container_StateChangeRequired( Object sender, PanelState arg ) {
            updatePropertyPanelState( arg );
        }
#endif

#if ENABLE_PROPERTY
        public void m_note_proerty_dlg_CommandExecuteRequired( CadenciiCommand command ) {
#if DEBUG
            AppManager.debugWriteLine( "m_note_property_dlg_CommandExecuteRequired" );
#endif
            AppManager.register( AppManager.getVsqFile().executeCommand( command ) );
            updateDrawObjectList();
            refreshScreen();
            setEdited( true );
        }
#endif

#if ENABLE_PROPERTY
        public void m_note_proerty_dlg_FormClosing( Object sender, BFormClosingEventArgs e ) {
            if ( e.CloseReason == System.Windows.Forms.CloseReason.UserClosing ) {
                e.Cancel = true;
                updatePropertyPanelState( PanelState.Hidden );
            }
        }
#endif

#if ENABLE_PROPERTY
        public void m_note_proerty_dlg_LocationOrSizeChanged( Object sender, EventArgs e ) {
#if DEBUG
            PortUtil.println( "m_note_proeprty_dlg_LocationOrSizeChanged; WindowState=" + AppManager.propertyWindow.WindowState );
#endif
            if ( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Window ) {
                if ( AppManager.propertyWindow.getExtendedState() == BForm.ICONIFIED ) {
                    updatePropertyPanelState( PanelState.Docked );
                } else {
                    Point parent = this.getLocation();
                    Point proeprty = AppManager.propertyWindow.getLocation();
                    AppManager.editorConfig.PropertyWindowStatus.Bounds = new XmlRectangle( proeprty.x - parent.x,
                                                                                            proeprty.y - parent.y,
                                                                                            AppManager.propertyWindow.getWidth(),
                                                                                            AppManager.propertyWindow.getHeight() );
                }
            }
        }
#endif

        public void FormMain_LocationChanged( Object sender, EventArgs e ) {
            if ( getExtendedState() == BForm.NORMAL ) {
                AppManager.editorConfig.WindowRect = this.getBounds();
            }
        }

        public void FormMain_SizeChanged( Object sender, EventArgs e ) {
            if ( getExtendedState() == BForm.NORMAL ) {
                AppManager.editorConfig.WindowRect = this.getBounds();
#if ENABLE_PROPERTY
                AppManager.propertyWindow.setExtendedState( BForm.NORMAL );
                AppManager.propertyWindow.setVisible( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Window );
#endif
                AppManager.mixerWindow.setVisible( AppManager.editorConfig.MixerVisible );
                if ( AppManager.iconPalette != null && menuVisualIconPalette.isSelected() ) {
                    AppManager.iconPalette.setVisible( true );
                }
                updateLayout();
            } else if ( getExtendedState() == BForm.ICONIFIED ) {
#if ENABLE_PROPERTY
                AppManager.propertyWindow.setVisible( false );
#endif
                AppManager.mixerWindow.setVisible( false );
                if ( AppManager.iconPalette != null ) {
                    AppManager.iconPalette.setVisible( false );
                }
            } else if ( getExtendedState() == BForm.MAXIMIZED_BOTH ) {
#if ENABLE_PROPERTY
                AppManager.propertyWindow.setExtendedState( BForm.NORMAL );
                AppManager.propertyWindow.setVisible( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Window );
#endif
                AppManager.mixerWindow.setVisible( AppManager.editorConfig.MixerVisible );
                if ( AppManager.iconPalette != null && menuVisualIconPalette.isSelected() ) {
                    AppManager.iconPalette.setVisible( true );
                }
            }
        }

        public void FormMain_MouseWheel( Object sender, BMouseEventArgs e ) {
            if ( (PortUtil.getCurrentModifierKey() & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK ) {
                hScroll.setValue( computeScrollValueFromWheelDelta( e.Delta ) );
            } else {
                double new_val = (double)vScroll.getValue() - e.Delta;
                if ( new_val > vScroll.getMaximum() ) {
                    vScroll.setValue( vScroll.getMaximum() );
                } else if ( new_val < vScroll.getMinimum() ) {
                    vScroll.setValue( vScroll.getMinimum() );
                } else {
                    vScroll.setValue( (int)new_val );
                }
            }
            refreshScreen();
        }

        public void FormMain_PreviewKeyDown( Object sender, BPreviewKeyDownEventArgs e ) {
#if DEBUG
            PortUtil.println( "FormMain#FormMain_PreviewKeyDown" );
#endif
#if JAVA
            BKeyEventArgs ex = new BKeyEventArgs( e.getRawEvent() );
#else
            BKeyEventArgs ex = new BKeyEventArgs( e.KeyData );
#endif
            processSpecialShortcutKey( ex, true );
        }

        public void FormMain_Deactivate( Object sender, EventArgs e ) {
            m_form_activated = false;
        }

        public void FormMain_Activated( Object sender, EventArgs e ) {
            m_form_activated = true;
        }
        #endregion

#if !JAVA
        public void m_timer_Tick( Object sender, EventArgs e ) {
            if ( !m_form_activated ) {
                return;
            }
            try {
                double now = PortUtil.getCurrentTime();
                byte[] buttons;
                int pov0;
#if !JAVA
                winmmhelp.JoyGetStatus( 0, out buttons, out pov0 );
#endif
                boolean event_processed = false;
                double dt_ms = (now - m_last_event_processed) * 1000.0;

                EditorConfig m = AppManager.editorConfig;
                boolean btn_x = (0 <= m.GameControlerCross && m.GameControlerCross < buttons.Length && buttons[m.GameControlerCross] > 0x00);
                boolean btn_o = (0 <= m.GameControlerCircle && m.GameControlerCircle < buttons.Length && buttons[m.GameControlerCircle] > 0x00);
                boolean btn_tr = (0 <= m.GameControlerTriangle && m.GameControlerTriangle < buttons.Length && buttons[m.GameControlerTriangle] > 0x00);
                boolean btn_re = (0 <= m.GameControlerRectangle && m.GameControlerRectangle < buttons.Length && buttons[m.GameControlerRectangle] > 0x00);
                boolean pov_r = pov0 == m.GameControlPovRight;
                boolean pov_l = pov0 == m.GameControlPovLeft;
                boolean pov_u = pov0 == m.GameControlPovUp;
                boolean pov_d = pov0 == m.GameControlPovDown;
                boolean L1 = (0 <= m.GameControlL1 && m.GameControlL1 < buttons.Length && buttons[m.GameControlL1] > 0x00);
                boolean R1 = (0 <= m.GameControlL2 && m.GameControlL2 < buttons.Length && buttons[m.GameControlR1] > 0x00);
                boolean L2 = (0 <= m.GameControlR1 && m.GameControlR1 < buttons.Length && buttons[m.GameControlL2] > 0x00);
                boolean R2 = (0 <= m.GameControlR2 && m.GameControlR2 < buttons.Length && buttons[m.GameControlR2] > 0x00);
                boolean SELECT = (0 <= m.GameControlSelect && m.GameControlSelect <= buttons.Length && buttons[m.GameControlSelect] > 0x00);
                if ( m_game_mode == GameControlMode.NORMAL ) {
                    m_last_btn_x = btn_x;

                    if ( !event_processed && !btn_o && m_last_btn_o ) {
                        if ( AppManager.isPlaying() ) {
                            timer.stop();
                        }
                        AppManager.setPlaying( !AppManager.isPlaying() );
                        m_last_event_processed = now;
                        event_processed = true;
                    }
                    m_last_btn_o = btn_o;

                    if ( !event_processed && pov_r && dt_ms > AppManager.editorConfig.GameControlerMinimumEventInterval ) {
                        forward();
                        m_last_event_processed = now;
                        event_processed = true;
                    }
                    m_last_pov_r = pov_r;

                    if ( !event_processed && pov_l && dt_ms > AppManager.editorConfig.GameControlerMinimumEventInterval ) {
                        rewind();
                        m_last_event_processed = now;
                        event_processed = true;
                    }
                    m_last_pov_l = pov_l;

                    if ( !event_processed && pov_u && dt_ms > AppManager.editorConfig.GameControlerMinimumEventInterval ) {
                        int draft_vscroll = vScroll.getValue() - AppManager.editorConfig.PxTrackHeight * 3;
                        if ( draft_vscroll < vScroll.getMinimum() ) {
                            draft_vscroll = vScroll.getMinimum();
                        }
                        vScroll.setValue( draft_vscroll );
                        refreshScreen();
                        m_last_event_processed = now;
                        event_processed = true;
                    }

                    if ( !event_processed && pov_d && dt_ms > AppManager.editorConfig.GameControlerMinimumEventInterval ) {
                        int draft_vscroll = vScroll.getValue() + AppManager.editorConfig.PxTrackHeight * 3;
                        if ( draft_vscroll > vScroll.getMaximum() ) {
                            draft_vscroll = vScroll.getMaximum();
                        }
                        vScroll.setValue( draft_vscroll );
                        refreshScreen();
                        m_last_event_processed = now;
                        event_processed = true;
                    }

                    if ( !event_processed && !SELECT && m_last_select ) {
                        event_processed = true;
                        m_game_mode = GameControlMode.KEYBOARD;
                        stripLblGameCtrlMode.setText( m_game_mode.ToString() );
                        stripLblGameCtrlMode.setIcon( new ImageIcon( Resources.get_piano() ) );
                    }
                    m_last_select = SELECT;
                } else if ( m_game_mode == GameControlMode.KEYBOARD ) {
                    if ( !event_processed && !SELECT && m_last_select ) {
                        event_processed = true;
                        m_game_mode = GameControlMode.NORMAL;
                        updateGameControlerStatus( null, null );
                        m_last_select = SELECT;
                        return;
                    }
                    m_last_select = SELECT;
                    if ( L1 && R1 && L2 && R2 && dt_ms > AppManager.editorConfig.GameControlerMinimumEventInterval ) {
                        if ( AppManager.isPlaying() ) {
                            AppManager.setEditMode( EditMode.NONE );
                            AppManager.setPlaying( false );
                            timer.stop();
                        } else {
                            m_timer.stop();
                            FormRealtimeConfig frc = null;
                            try {
                                frc = new FormRealtimeConfig();
                                frc.setModal( true );
                                frc.setVisible( true );
                                if ( frc.getDialogResult() == BDialogResult.OK ) {
                                    AppManager.addingEvent = null;
                                    AppManager.setEditMode( EditMode.REALTIME );
                                    AppManager.editorConfig.setRealtimeInputSpeed( frc.getSpeed() );
                                    AppManager.setPlaying( true );
                                }
                            } catch ( Exception ex ) {
                            } finally {
                                try {
                                    frc.close();
                                } catch ( Exception ex2 ) {
                                }
                            }
                            m_timer.start();
                        }
                        m_last_btn_o = btn_o;
                        m_last_btn_x = btn_x;
                        m_last_btn_re = btn_re;
                        m_last_btn_tr = btn_tr;
                        m_last_pov_l = pov_l;
                        m_last_pov_d = pov_d;
                        m_last_pov_r = pov_r;
                        m_last_pov_u = pov_u;
                        return;
                    }

                    int note = -1;
                    if ( pov_r && !m_last_pov_r ) {
                        note = 60;
                    } else if ( btn_re && !m_last_btn_re ) {
                        note = 62;
                    } else if ( btn_tr && !m_last_btn_tr ) {
                        note = 64;
                    } else if ( btn_o && !m_last_btn_o ) {
                        note = 65;
                    } else if ( btn_x && !m_last_btn_x ) {
                        note = 67;
                    } else if ( pov_u && !m_last_pov_u ) {
                        note = 59;
                    } else if ( pov_l && !m_last_pov_l ) {
                        note = 57;
                    } else if ( pov_d && !m_last_pov_d ) {
                        note = 55;
                    }
                    if ( note >= 0 ) {
                        if ( L1 ) {
                            note += 12;
                        } else if ( L2 ) {
                            note -= 12;
                        }
                        if ( R1 ) {
                            note += 1;
                        } else if ( R2 ) {
                            note -= 1;
                        }
                    }
                    m_last_btn_o = btn_o;
                    m_last_btn_x = btn_x;
                    m_last_btn_re = btn_re;
                    m_last_btn_tr = btn_tr;
                    m_last_pov_l = pov_l;
                    m_last_pov_d = pov_d;
                    m_last_pov_r = pov_r;
                    m_last_pov_u = pov_u;
                    if ( note >= 0 ) {
#if DEBUG
                        AppManager.debugWriteLine( "FormMain+m_timer_Tick" );
                        AppManager.debugWriteLine( "    note=" + note );
#endif
                        if ( AppManager.isPlaying() ) {
                            int clock = AppManager.getCurrentClock();
                            int selected = AppManager.getSelected();
                            if ( AppManager.addingEvent != null ) {
                                AppManager.addingEvent.ID.setLength( clock - AppManager.addingEvent.Clock );
                                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventAdd( selected,
                                                                                                               AppManager.addingEvent ) );
                                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                if ( !isEdited() ) {
                                    setEdited( true );
                                }
                                updateDrawObjectList();
                            }
                            AppManager.addingEvent = new VsqEvent( clock, new VsqID( 0 ) );
                            AppManager.addingEvent.ID.type = VsqIDType.Anote;
                            AppManager.addingEvent.ID.Dynamics = 64;
                            AppManager.addingEvent.ID.VibratoHandle = null;
                            AppManager.addingEvent.ID.LyricHandle = new LyricHandle( "a", "a" );
                            AppManager.addingEvent.ID.Note = note;
                        }
                        if ( AppManager.getEditMode() == EditMode.REALTIME ) {
#if ENABLE_MIDI
                            MidiPlayer.PlayImmediate( (byte)note );
#endif
                        } else {
                            KeySoundPlayer.play( note );
                        }
                    } else {
                        if ( AppManager.isPlaying() && AppManager.addingEvent != null ) {
                            AppManager.addingEvent.ID.setLength( AppManager.getCurrentClock() - AppManager.addingEvent.Clock );
                        }
                    }
                }
            } catch ( Exception ex ) {
#if DEBUG
                AppManager.debugWriteLine( "    ex=" + ex );
#endif
                m_game_mode = GameControlMode.DISABLED;
                updateGameControlerStatus( null, null );
                if ( AppManager.getEditMode() == EditMode.REALTIME ) {
                    AppManager.setPlaying( false );
                    AppManager.setEditMode( EditMode.NONE );
                    AppManager.addingEvent = null;
                }
                m_timer.stop();
            }
        }
#endif

        public void EditorConfig_QuantizeModeChanged( Object sender, EventArgs e ) {
            applyQuantizeMode();
        }

        #region menuFile*
        public void menuFileSaveNamed_Click( Object sender, EventArgs e ) {
            for ( int track = 1; track < AppManager.getVsqFile().Track.size(); track++ ) {
                if ( AppManager.getVsqFile().Track.get( track ).getEventCount() == 0 ) {
                    AppManager.showMessageBox(
                        PortUtil.formatMessage(
                            _( "Invalid note data.\nTrack {0} : {1}\n\n-> Piano roll : Blank sequence." ), track, AppManager.getVsqFile().Track.get( track ).getName()
                        ),
                        _APP_NAME,
                        org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION,
                        org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                    return;
                }
            }

            int dr = saveXmlVsqDialog.showSaveDialog( this );
            if ( dr == BFileChooser.APPROVE_OPTION ) {
                String file = saveXmlVsqDialog.getSelectedFile();
                AppManager.saveTo( file );
                updateRecentFileMenu();
                setEdited( false );
            }
        }

        public void commonFileSave_Click( Object sender, EventArgs e ) {
            for ( int track = 1; track < AppManager.getVsqFile().Track.size(); track++ ) {
                if ( AppManager.getVsqFile().Track.get( track ).getEventCount() == 0 ) {
                    AppManager.showMessageBox(
                        PortUtil.formatMessage(
                            _( "Invalid note data.\nTrack {0} : {1}\n\n-> Piano roll : Blank sequence." ), track, AppManager.getVsqFile().Track.get( track ).getName()
                        ),
                        _APP_NAME,
                        org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION,
                        org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                    return;
                }
            }
            String file = AppManager.getFileName();
            if ( AppManager.getFileName().Equals( "" ) ) {
                int dr = saveXmlVsqDialog.showSaveDialog( this );
                if ( dr == BFileChooser.APPROVE_OPTION ) {
                    file = saveXmlVsqDialog.getSelectedFile();
                }
            }
            if ( file != "" ) {
                AppManager.saveTo( file );
                updateRecentFileMenu();
                setEdited( false );
            }
        }

        public void menuFileQuit_Click( Object sender, EventArgs e ) {
            close();
        }

        public void menuFileExportWave_Click( Object sender, EventArgs e ) {
            int dialog_result = BFileChooser.CANCEL_OPTION;
            String filename = "";
            BFileChooser sfd = null;
            try {
                sfd = new BFileChooser( "" );
                sfd.setDialogTitle( _( "Wave Export" ) );
                sfd.addFileFilter( _( "Wave File(*.wav)|*.wav" ) );
                sfd.addFileFilter( _( "All Files(*.*)|*.*" ) );
                dialog_result = sfd.showSaveDialog( this );
                filename = sfd.getSelectedFile();
            } catch ( Exception ex ) {
            } finally {
                if ( sfd != null ) {
                    try {
#if !JAVA
                        sfd.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                    }
                }
            }

            if ( dialog_result != BFileChooser.APPROVE_OPTION ) {
                return;
            }
            FormSynthesize fs = null;
            try {
                VsqFileEx vsq = AppManager.getVsqFile();
                int clockStart = AppManager.startMarkerEnabled ? AppManager.startMarker : 0;
                int clockEnd = AppManager.endMarkerEnabled ? AppManager.endMarker : vsq.TotalClocks + 240;
                if ( clockStart > clockEnd ) {
                    AppManager.showMessageBox( _( "invalid rendering region; start>=end" ), _( "Error" ), PortUtil.OK_OPTION, org.kbinani.windows.forms.Utility.MSGBOX_INFORMATION_MESSAGE );
                    return;
                }
                fs = new FormSynthesize( vsq,
                                         AppManager.editorConfig.PreSendTime,
                                         AppManager.getSelected(),
                                         filename,
                                         clockStart,
                                         clockEnd,
                                         true );
                double started = PortUtil.getCurrentTime();
                fs.setModal( true );
                fs.setVisible( true );
            } catch ( Exception ex ) {
            } finally {
                if ( fs != null ) {
                    try {
                        fs.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        public void menuFileExport_DropDownOpening( Object sender, EventArgs e ) {
            menuFileExportWave.setEnabled( (AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEventCount() > 0) && VSTiProxy.CurrentUser.Equals( "" ) );
        }

        public void menuFileImportMidi_Click( Object sender, EventArgs e ) {
            if ( m_midi_imexport_dialog == null ) {
                m_midi_imexport_dialog = new FormMidiImExport();
            }
            m_midi_imexport_dialog.listTrack.clear();
            m_midi_imexport_dialog.setMode( FormMidiImExport.FormMidiMode.IMPORT );

            int dialog_result = openMidiDialog.showOpenDialog( this );

            if ( dialog_result != BFileChooser.APPROVE_OPTION ) {
                return;
            }
            m_midi_imexport_dialog.setLocation( getFormPreferedLocation( m_midi_imexport_dialog ) );
            MidiFile mf = null;
            try {
                mf = new MidiFile( openMidiDialog.getSelectedFile() );
            } catch ( Exception ex ) {
                AppManager.showMessageBox( _( "Invalid MIDI file." ), _( "Error" ), org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION, org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                return;
            }
            if ( mf == null ) {
                AppManager.showMessageBox( _( "Invalid MIDI file." ), _( "Error" ), org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION, org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                return;
            }
            int count = mf.getTrackCount();
            //Encoding def_enc = Encoding.GetEncoding( 0 );
            for ( int i = 0; i < count; i++ ) {
                String track_name = "";
                int notes = 0;
                Vector<MidiEvent> events = mf.getMidiEventList( i );
                int events_count = events.size();

                // トラック名を取得
                for ( int j = 0; j < events_count; j++ ) {
                    MidiEvent item = events.get( j );
                    if ( item.firstByte == 0xff && item.data.Length >= 2 && item.data[0] == 0x03 ) {
                        int[] d = new int[item.data.Length];
                        for ( int k = 0; k < item.data.Length; k++ ) {
                            d[k] = 0xff & item.data[k];
                        }
                        track_name = PortUtil.getDecodedString( "Shift_JIS", d, 1, item.data.Length - 1 );
                        break;
                    }
                }

                // イベント数を数える
                for ( int j = 0; j < events_count; j++ ) {
                    MidiEvent item = events.get( j );
                    if ( (item.firstByte & 0xf0) == 0x90 && item.data.Length > 1 && item.data[1] > 0x00 ) {
                        notes++;
                    }
                }
                m_midi_imexport_dialog.listTrack.addItem( "", new BListViewItem( new String[] { i + "", track_name, notes + "" } ) );
                m_midi_imexport_dialog.listTrack.setItemCheckedAt( "", i, true );
            }

            m_midi_imexport_dialog.setModal( true );
            m_midi_imexport_dialog.setVisible( true );
            if ( m_midi_imexport_dialog.getDialogResult() != BDialogResult.OK ) {
                return;
            }

            boolean secondBasis = m_midi_imexport_dialog.isSecondBasis();
            int offsetClocks = m_midi_imexport_dialog.getOffsetClocks();
            double offsetSeconds = m_midi_imexport_dialog.getOffsetSeconds();
            boolean importFromPremeasure = m_midi_imexport_dialog.isPreMeasure();

            // インポートするしないにかかわらずテンポと拍子を取得
            VsqFileEx tempo = new VsqFileEx( "Miku", 2, 4, 4, 500000 ); //テンポリスト用のVsqFile。テンポの部分のみ使用
            tempo.executeCommand( VsqCommand.generateCommandChangePreMeasure( 0 ) );
            boolean tempo_added = false;
            boolean timesig_added = false;
            tempo.TempoTable.clear();
            tempo.TimesigTable.clear();
            int mf_getTrackCount = mf.getTrackCount();
            for ( int i = 0; i < mf_getTrackCount; i++ ) {
                Vector<MidiEvent> events = mf.getMidiEventList( i );
                boolean t_tempo_added = false;   //第iトラックからテンポをインポートしたかどうか
                boolean t_timesig_added = false; //第iトラックから拍子をインポートしたかどうか
                int last_timesig_clock = 0; // 最後に拍子変更を検出したゲートタイム
                int last_num = 4; // 最後に検出した拍子変更の分子
                int last_den = 4; // 最後に検出した拍子変更の分母
                int last_barcount = 0;
                int events_Count = events.size();
                for ( int j = 0; j < events_Count; j++ ) {
                    MidiEvent itemj = events.get( j );
                    if ( !tempo_added && itemj.firstByte == 0xff && itemj.data.Length >= 4 && itemj.data[0] == 0x51 ) {
                        boolean contains_same_clock = false;
                        int size = tempo.TempoTable.size();
                        // 同時刻のテンポ変更は、最初以外無視する
                        for ( int k = 0; k < size; k++ ) {
                            if ( tempo.TempoTable.get( k ).Clock == itemj.clock ) {
                                contains_same_clock = true;
                                break;
                            }
                        }
                        if ( !contains_same_clock ) {
                            int vtempo = itemj.data[1] << 16 | itemj.data[2] << 8 | itemj.data[3];
                            tempo.TempoTable.add( new TempoTableEntry( (int)itemj.clock, vtempo, 0.0 ) );
                            t_tempo_added = true;
                        }
                    }
                    if ( !timesig_added && itemj.firstByte == 0xff && itemj.data.Length >= 5 && itemj.data[0] == 0x58 ) {
                        int num = itemj.data[1];
                        int den = 1;
                        for ( int k = 0; k < itemj.data[2]; k++ ) {
                            den = den * 2;
                        }
                        int clock_per_bar = last_num * 480 * 4 / last_den;
                        int barcount_at_itemj = last_barcount + ((int)itemj.clock - last_timesig_clock) / clock_per_bar;
                        // 同時刻の拍子変更は、最初以外無視する
                        int size = tempo.TimesigTable.size();
                        boolean contains_same_clock = false;
                        for ( int k = 0; k < size; k++ ) {
                            if ( tempo.TimesigTable.get( k ).Clock == itemj.clock ) {
                                contains_same_clock = true;
                                break;
                            }
                        }
                        if ( !contains_same_clock ) {
                            tempo.TimesigTable.add( new TimeSigTableEntry( (int)itemj.clock, num, den, barcount_at_itemj ) );
                            last_timesig_clock = (int)itemj.clock;
                            last_den = den;
                            last_num = num;
                            last_barcount = barcount_at_itemj;
                            t_timesig_added = true;
                        }
                    }
                }
                if ( t_tempo_added ) {
                    tempo_added = true;
                }
                if ( t_timesig_added ) {
                    timesig_added = true;
                }
                if ( timesig_added && tempo_added ) {
                    // 両方ともインポート済みならexit。2個以上のトラックから、重複してテンポや拍子をインポートするのはNG（たぶん）
                    break;
                }
            }
            boolean contains_zero = false;
            int c = tempo.TempoTable.size();
            for ( int i = 0; i < c; i++ ) {
                if ( tempo.TempoTable.get( i ).Clock == 0 ) {
                    contains_zero = true;
                    break;
                }
            }
            if ( !contains_zero ) {
                tempo.TempoTable.add( new TempoTableEntry( 0, 500000, 0.0 ) );
            }
            contains_zero = false;
            // =>
            // Thanks, げっぺータロー.
            // BEFORE:
            // c = tempo.TempoTable.size();
            // AFTER:
            c = tempo.TimesigTable.size();
            // <=
            for ( int i = 0; i < c; i++ ) {
                if ( tempo.TimesigTable.get( i ).Clock == 0 ) {
                    contains_zero = true;
                    break;
                }
            }
            if ( !contains_zero ) {
                tempo.TimesigTable.add( new TimeSigTableEntry( 0, 4, 4, 0 ) );
            }
            VsqFileEx work = (VsqFileEx)AppManager.getVsqFile().clone(); //後でReplaceコマンドを発行するための作業用
            int preMeasureClocks = work.getPreMeasureClocks();
            double sec_at_premeasure = work.getSecFromClock( preMeasureClocks );
            if ( !m_midi_imexport_dialog.isPreMeasure() ) {
                sec_at_premeasure = 0.0;
            }
            VsqFileEx copy_src = (VsqFileEx)tempo.clone();
            if ( sec_at_premeasure != 0.0 ) {
                int t = work.TempoTable.get( 0 ).Tempo;
                VsqFileEx.shift( copy_src, sec_at_premeasure, t );
            }
            tempo.updateTempoInfo();
            tempo.updateTimesigInfo();

            // tempoをインポート
            boolean import_tempo = m_midi_imexport_dialog.isTempo();
            if ( import_tempo ) {
#if DEBUG
                PortUtil.println( "FormMain#menuFileImportMidi_Click; sec_at_premeasure=" + sec_at_premeasure );
#endif
                // 最初に、workにある全てのイベント・コントロールカーブ・ベジエ曲線をtempoのテンポテーブルに合うように、シフトする
                //ShiftClockToMatchWith( work, copy_src, work.getSecFromClock( work.getPreMeasureClocks() ) );
                //ShiftClockToMatchWith( work, copy_src, copy_src.getSecFromClock( copy_src.getPreMeasureClocks() ) );
                if ( secondBasis ) {
                    shiftClockToMatchWith( work, copy_src, sec_at_premeasure );
                }

                work.TempoTable.clear();
                Vector<TempoTableEntry> list = copy_src.TempoTable;
                int list_count = list.size();
                for ( int i = 0; i < list_count; i++ ) {
                    TempoTableEntry item = list.get( i );
                    work.TempoTable.add( new TempoTableEntry( item.Clock, item.Tempo, item.Time ) );
                }
                work.updateTempoInfo();
            }

            // timesig
            if ( m_midi_imexport_dialog.isTimesig() ) {
                work.TimesigTable.clear();
                Vector<TimeSigTableEntry> list = tempo.TimesigTable;
                int list_count = list.size();
                for ( int i = 0; i < list_count; i++ ) {
                    TimeSigTableEntry item = list.get( i );
                    work.TimesigTable.add( new TimeSigTableEntry( item.Clock,
                                                                  item.Numerator,
                                                                  item.Denominator,
                                                                  item.BarCount ) );
                }
                Collections.sort( work.TimesigTable );
                work.updateTimesigInfo();
            }

            for ( int i = 0; i < m_midi_imexport_dialog.listTrack.getItemCount( "" ); i++ ) {
                if ( !m_midi_imexport_dialog.listTrack.isItemCheckedAt( "", i ) ) {
                    continue;
                }
                if ( work.Track.size() + 1 > 16 ) {
                    break;
                }
                VsqTrack work_track = new VsqTrack( m_midi_imexport_dialog.listTrack.getItemAt( "", i ).getSubItemAt( 1 ), "Miku" );

                // デフォルトの音声合成システムに切り替え
                RendererKind kind = AppManager.editorConfig.DefaultSynthesizer;
                String renderer = AppManager.getVersionStringFromRendererKind( kind );
                Vector<VsqID> singers = AppManager.getSingerListFromRendererKind( kind );
                work_track.changeRenderer( renderer, singers );

                Vector<MidiEvent> events = mf.getMidiEventList( i );
                Collections.sort( events );
                int events_count = events.size();

                // note
                if ( m_midi_imexport_dialog.isNotes() ) {
                    int[] onclock_each_note = new int[128];
                    int[] velocity_each_note = new int[128];
                    for ( int j = 0; j < 128; j++ ) {
                        onclock_each_note[j] = -1;
                        velocity_each_note[j] = 64;
                    }
                    int last_note = -1;
                    for ( int j = 0; j < events_count; j++ ) {
                        MidiEvent itemj = events.get( j );
                        int not_closed_note = -1;
                        if ( (itemj.firstByte & 0xf0) == 0x90 && itemj.data.Length >= 2 && itemj.data[1] > 0 ) {
                            for ( int m = 0; m < 128; m++ ) {
                                if ( onclock_each_note[m] >= 0 ) {
                                    not_closed_note = m;
                                    break;
                                }
                            }
                        }
#if DEBUG
                        PortUtil.println( "FormMain#menuFileImprotMidi_Click; not_closed_note=" + not_closed_note );
#endif
                        if ( ((itemj.firstByte & 0xf0) == 0x90 && itemj.data.Length >= 2 && itemj.data[1] == 0) ||
                             ((itemj.firstByte & 0xf0) == 0x80 && itemj.data.Length >= 2) ||
                             not_closed_note >= 0 ) {
                            int clock_off = (int)itemj.clock;
                            int note = (int)itemj.data[0];
                            if ( not_closed_note >= 0 ) {
                                note = not_closed_note;
                            }
                            if ( onclock_each_note[note] >= 0 ) {
                                int add_clock_on = onclock_each_note[note];
                                int add_clock_off = clock_off;
                                if ( secondBasis ) {
                                    double time_clock_on = tempo.getSecFromClock( onclock_each_note[note] ) + sec_at_premeasure + offsetSeconds;
                                    double time_clock_off = tempo.getSecFromClock( clock_off ) + sec_at_premeasure + offsetSeconds;
                                    add_clock_on = (int)work.getClockFromSec( time_clock_on );
                                    add_clock_off = (int)work.getClockFromSec( time_clock_off );
                                } else {
                                    add_clock_on += (importFromPremeasure ? preMeasureClocks : 0) + offsetClocks;
                                    add_clock_off += (importFromPremeasure ? preMeasureClocks : 0) + offsetClocks;
                                }
                                if ( add_clock_on < 0 ) {
                                    add_clock_on = 0;
                                }
                                if ( add_clock_off < 0 ) {
                                    continue;
                                }
                                VsqID vid = new VsqID( 0 );
                                vid.type = VsqIDType.Anote;
                                vid.setLength( add_clock_off - add_clock_on );
#if DEBUG
                                PortUtil.println( "FormMain#menuFileImportMidi_Click; vid.Length=" + vid.getLength() );
#endif
                                String phrase = "a";
                                if ( m_midi_imexport_dialog.isLyric() ) {
                                    for ( int k = 0; k < events_count; k++ ) {
                                        MidiEvent itemk = events.get( k );
                                        if ( onclock_each_note[note] <= (int)itemk.clock && (int)itemk.clock <= clock_off ) {
                                            if ( itemk.firstByte == 0xff && itemk.data.Length >= 2 && itemk.data[0] == 0x05 ) {
                                                int[] d = new int[itemk.data.Length - 1];
                                                for ( int m = 1; m < itemk.data.Length; m++ ) {
                                                    d[m - 1] = 0xff & itemk.data[m];
                                                }
                                                phrase = PortUtil.getDecodedString( "Shift_JIS", d, 0, itemk.data.Length );
                                                break;
                                            }
                                        }
                                    }
                                }
                                vid.LyricHandle = new LyricHandle( phrase, "a" );
                                vid.Note = note;
                                vid.Dynamics = velocity_each_note[note];
                                vid.DEMaccent = 50;
                                vid.DEMdecGainRate = 50;

                                // ビブラート
                                if ( AppManager.editorConfig.EnableAutoVibrato ) {
                                    int note_length = vid.getLength();
                                    // 音符位置での拍子を調べる
                                    Timesig timesig = work.getTimesigAt( add_clock_on );

                                    // ビブラートを自動追加するかどうかを決める閾値
                                    int autovib = AutoVibratoMinLengthUtil.getValue( AppManager.editorConfig.AutoVibratoMinimumLength );
                                    int threshold = 480 * 4 / timesig.denominator * autovib;
                                    if ( note_length >= threshold ) {
                                        int vibrato_clocks = 0;
                                        DefaultVibratoLengthEnum vib_length = AppManager.editorConfig.DefaultVibratoLength;
                                        if ( vib_length == DefaultVibratoLengthEnum.L100 ) {
                                            vibrato_clocks = note_length;
                                        } else if ( vib_length == DefaultVibratoLengthEnum.L50 ) {
                                            vibrato_clocks = note_length / 2;
                                        } else if ( vib_length == DefaultVibratoLengthEnum.L66 ) {
                                            vibrato_clocks = note_length * 2 / 3;
                                        } else if ( vib_length == DefaultVibratoLengthEnum.L75 ) {
                                            vibrato_clocks = note_length * 3 / 4;
                                        }
                                        // とりあえずVOCALOID2のデフォルトビブラートの設定を使用
                                        vid.VibratoHandle = AppManager.editorConfig.createAutoVibrato( SynthesizerType.VOCALOID2, vibrato_clocks );
                                        vid.VibratoDelay = note_length - vibrato_clocks;
                                    }
                                }

                                VsqEvent ve = new VsqEvent( add_clock_on, vid );
                                work_track.addEvent( ve );
                                onclock_each_note[note] = -1;
                            }
                        }
                        if ( (itemj.firstByte & 0xf0) == 0x90 && itemj.data.Length >= 2 && itemj.data[1] > 0 ) {
                            int note = itemj.data[0];
                            onclock_each_note[note] = (int)itemj.clock;
                            int vel = itemj.data[1];
                            velocity_each_note[note] = vel;
                            last_note = note;
                        }
                    }

                    int track = work.Track.size();
                    CadenciiCommand run_add = VsqFileEx.generateCommandAddTrack( work_track,
                                                                                 new VsqMixerEntry( 0, 0, 0, 0 ),
                                                                                 track,
                                                                                 new BezierCurves() );
                    work.executeCommand( run_add );
                }
            }

            CadenciiCommand lastrun = VsqFileEx.generateCommandReplace( work );
            AppManager.register( AppManager.getVsqFile().executeCommand( lastrun ) );
            setEdited( true );
            refreshScreen();
        }

        public void menuFileExportMidi_Click( Object sender, EventArgs e ) {
            if ( m_midi_imexport_dialog == null ) {
                m_midi_imexport_dialog = new FormMidiImExport();
            }
            m_midi_imexport_dialog.listTrack.clear();
            VsqFileEx vsq = (VsqFileEx)AppManager.getVsqFile().clone();

            for ( int i = 0; i < vsq.Track.size(); i++ ) {
                VsqTrack track = vsq.Track.get( i );
                int notes = 0;
                for ( Iterator<VsqEvent> itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                    VsqEvent obj = itr.next();
                    notes++;
                }
                m_midi_imexport_dialog.listTrack.addItem( "", new BListViewItem( new String[] { i + "", track.getName(), notes + "" } ) );
                m_midi_imexport_dialog.listTrack.setItemCheckedAt( "", i, true );
            }
            m_midi_imexport_dialog.setMode( FormMidiImExport.FormMidiMode.EXPORT );
            m_midi_imexport_dialog.setLocation( getFormPreferedLocation( m_midi_imexport_dialog ) );
            m_midi_imexport_dialog.setModal( true );
            m_midi_imexport_dialog.setVisible( true );
            if ( m_midi_imexport_dialog.getDialogResult() == BDialogResult.OK ) {
                if ( !m_midi_imexport_dialog.isPreMeasure() ) {
                    vsq.removePart( 0, vsq.getPreMeasureClocks() );
                }
                int track_count = 0;
                for ( int i = 0; i < m_midi_imexport_dialog.listTrack.getItemCount( "" ); i++ ) {
                    if ( m_midi_imexport_dialog.listTrack.isItemCheckedAt( "", i ) ) {
                        track_count++;
                    }
                }
                if ( track_count == 0 ) {
                    return;
                }

                int dialog_result = saveMidiDialog.showSaveDialog( this );

                if ( dialog_result == BFileChooser.APPROVE_OPTION ) {
                    RandomAccessFile fs = null;
                    try {
                        fs = new RandomAccessFile( saveMidiDialog.getSelectedFile(), "rw" );
                        // ヘッダー
                        fs.write( new byte[] { 0x4d, 0x54, 0x68, 0x64 }, 0, 4 );
                        //データ長
                        fs.write( (byte)0x00 );
                        fs.write( (byte)0x00 );
                        fs.write( (byte)0x00 );
                        fs.write( (byte)0x06 );
                        //フォーマット
                        fs.write( (byte)0x00 );
                        fs.write( (byte)0x01 );
                        //トラック数
                        VsqFile.writeUnsignedShort( fs, track_count );
                        //時間単位
                        fs.write( (byte)0x01 );
                        fs.write( (byte)0xe0 );
                        int count = -1;
                        for ( int i = 0; i < m_midi_imexport_dialog.listTrack.getItemCount( "" ); i++ ) {
                            if ( !m_midi_imexport_dialog.listTrack.isItemCheckedAt( "", i ) ) {
                                continue;
                            }
                            VsqTrack track = vsq.Track.get( i );
                            count++;
                            fs.write( new byte[] { 0x4d, 0x54, 0x72, 0x6b }, 0, 4 );
                            //データ長。とりあえず0を入れておく
                            fs.write( new byte[] { 0x00, 0x00, 0x00, 0x00 }, 0, 4 );
                            long first_position = fs.getFilePointer();
                            //トラック名
                            VsqFile.writeFlexibleLengthUnsignedLong( fs, 0 );//デルタタイム
                            fs.write( (byte)0xff );//ステータスタイプ
                            fs.write( (byte)0x03 );//イベントタイプSequence/Track Name
                            byte[] track_name = PortUtil.getEncodedByte( "Shift_JIS", track.getName() );
                            fs.write( (byte)track_name.Length );
                            fs.write( track_name, 0, track_name.Length );

                            Vector<MidiEvent> events = new Vector<MidiEvent>();

                            // tempo
                            boolean print_tempo = m_midi_imexport_dialog.isTempo();
                            if ( print_tempo && count == 0 ) {
                                Vector<MidiEvent> tempo_events = vsq.generateTempoChange();
                                for ( int j = 0; j < tempo_events.size(); j++ ) {
                                    events.add( tempo_events.get( j ) );
                                }
                            }

                            // timesig
                            if ( m_midi_imexport_dialog.isTimesig() && count == 0 ) {
                                Vector<MidiEvent> timesig_events = vsq.generateTimeSig();
                                for ( int j = 0; j < timesig_events.size(); j++ ) {
                                    events.add( timesig_events.get( j ) );
                                }
                            }

                            // Notes
                            if ( m_midi_imexport_dialog.isNotes() ) {
                                for ( Iterator<VsqEvent> itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = itr.next();
                                    int clock_on = ve.Clock;
                                    int clock_off = ve.Clock + ve.ID.getLength();
                                    if ( !print_tempo ) {
                                        // テンポを出力しない場合、テンポを500000（120）と見なしてクロックを再計算
                                        double time_on = vsq.getSecFromClock( clock_on );
                                        double time_off = vsq.getSecFromClock( clock_off );
                                        clock_on = (int)(960.0 * time_on);
                                        clock_off = (int)(960.0 * time_off);
                                    }
                                    MidiEvent noteon = new MidiEvent();
                                    noteon.clock = clock_on;
                                    noteon.firstByte = 0x90;
                                    noteon.data = new int[2];
                                    noteon.data[0] = ve.ID.Note;
                                    noteon.data[1] = ve.ID.Dynamics;
                                    events.add( noteon );
                                    MidiEvent noteoff = new MidiEvent();
                                    noteoff.clock = clock_off;
                                    noteoff.firstByte = 0x80;
                                    noteoff.data = new int[2];
                                    noteoff.data[0] = ve.ID.Note;
                                    noteoff.data[1] = 0x7f;
                                    events.add( noteoff );
                                }
                            }

                            // lyric
                            if ( m_midi_imexport_dialog.isLyric() ) {
                                for ( Iterator<VsqEvent> itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = itr.next();
                                    int clock_on = ve.Clock;
                                    if ( !print_tempo ) {
                                        double time_on = vsq.getSecFromClock( clock_on );
                                        clock_on = (int)(960.0 * time_on);
                                    }
                                    MidiEvent add = new MidiEvent();
                                    add.clock = clock_on;
                                    add.firstByte = 0xff;
                                    byte[] lyric = PortUtil.getEncodedByte( "Shift_JIS", ve.ID.LyricHandle.L0.Phrase );
                                    add.data = new int[lyric.Length + 1];
                                    add.data[0] = 0x05;
                                    for ( int j = 0; j < lyric.Length; j++ ) {
                                        add.data[j + 1] = lyric[j];
                                    }
                                    events.add( add );
                                }
                            }

                            // vocaloid metatext
                            Vector<MidiEvent> meta;
                            if ( m_midi_imexport_dialog.isVocaloidMetatext() && i > 0 ) {
                                meta = vsq.generateMetaTextEvent( i, "Shift_JIS" );
                            } else {
                                meta = new Vector<MidiEvent>();
                            }

                            // vocaloid nrpn
                            Vector<MidiEvent> vocaloid_nrpn_midievent;
                            if ( m_midi_imexport_dialog.isVocaloidNrpn() && i > 0 ) {
                                VsqNrpn[] vsqnrpn = VsqFileEx.generateNRPN( (VsqFile)vsq, i, AppManager.editorConfig.PreSendTime );
                                NrpnData[] nrpn = VsqNrpn.convert( vsqnrpn );

                                vocaloid_nrpn_midievent = new Vector<MidiEvent>();
                                for ( int j = 0; j < nrpn.Length; j++ ) {
                                    MidiEvent me = new MidiEvent();
                                    me.clock = nrpn[j].getClock();
                                    me.firstByte = 0xb0;
                                    me.data = new int[2];
                                    me.data[0] = nrpn[j].getParameter();
                                    me.data[1] = nrpn[j].Value;
                                    vocaloid_nrpn_midievent.add( me );
                                }
                            } else {
                                vocaloid_nrpn_midievent = new Vector<MidiEvent>();
                            }
#if DEBUG
                            PortUtil.println( "menuFileExportMidi_Click" );
                            PortUtil.println( "    vocaloid_nrpn_midievent.size()=" + vocaloid_nrpn_midievent.size() );
#endif

                            // midi eventを出力
                            Collections.sort( events );
                            long last_clock = 0;
                            int events_count = events.size();
                            if ( events_count > 0 ) {
                                for ( int j = 0; j < events_count; j++ ) {
                                    if ( events.get( j ).clock > 0 && meta.size() > 0 ) {
                                        for ( int k = 0; k < meta.size(); k++ ) {
                                            VsqFile.writeFlexibleLengthUnsignedLong( fs, 0 );
                                            meta.get( k ).writeData( fs );
                                        }
                                        meta.clear();
                                        last_clock = 0;
                                    }
                                    long clock = events.get( j ).clock;
                                    while ( vocaloid_nrpn_midievent.size() > 0 && vocaloid_nrpn_midievent.get( 0 ).clock < clock ) {
                                        VsqFile.writeFlexibleLengthUnsignedLong( fs, (long)(vocaloid_nrpn_midievent.get( 0 ).clock - last_clock) );
                                        last_clock = vocaloid_nrpn_midievent.get( 0 ).clock;
                                        vocaloid_nrpn_midievent.get( 0 ).writeData( fs );
                                        vocaloid_nrpn_midievent.removeElementAt( 0 );
                                    }
                                    VsqFile.writeFlexibleLengthUnsignedLong( fs, (long)(events.get( j ).clock - last_clock) );
                                    events.get( j ).writeData( fs );
                                    last_clock = events.get( j ).clock;
                                }
                            } else {
                                int c = vocaloid_nrpn_midievent.size();
                                for ( int k = 0; k < meta.size(); k++ ) {
                                    VsqFile.writeFlexibleLengthUnsignedLong( fs, 0 );
                                    meta.get( k ).writeData( fs );
                                }
                                meta.clear();
                                last_clock = 0;
                                for ( int j = 0; j < c; j++ ) {
                                    MidiEvent item = vocaloid_nrpn_midievent.get( j );
                                    long clock = item.clock;
                                    VsqFile.writeFlexibleLengthUnsignedLong( fs, (long)(clock - last_clock) );
                                    item.writeData( fs );
                                    last_clock = clock;
                                }
                            }

                            // トラックエンドを記入し、
                            VsqFile.writeFlexibleLengthUnsignedLong( fs, (long)0 );
                            fs.write( (byte)0xff );
                            fs.write( (byte)0x2f );
                            fs.write( (byte)0x00 );
                            // チャンクの先頭に戻ってチャンクのサイズを記入
                            long pos = fs.getFilePointer();
                            fs.seek( first_position - 4 );
                            VsqFile.writeUnsignedInt( fs, pos - first_position );
                            // ファイルを元の位置にseek
                            fs.seek( pos );
                        }
                    } catch ( Exception ex ) {
                    } finally {
                        if ( fs != null ) {
                            try {
                                fs.close();
                            } catch ( Exception ex2 ) {
                            }
                        }
                    }
                }
            }
        }

        public void menuFileExportMusicXml_Click( Object sender, EventArgs e ) {
            BFileChooser dialog = null;
            try {
                VsqFileEx vsq = AppManager.getVsqFile();
                if ( vsq == null ) {
                    return;
                }
                String dir = "";
                String lastFile = "";
                if ( AppManager.editorConfig.LastMusicXmlPath != null && !AppManager.editorConfig.LastMusicXmlPath.Equals( "" ) ) {
                    dir = PortUtil.getDirectoryName( AppManager.editorConfig.LastMusicXmlPath );
                    lastFile = PortUtil.getFileName( AppManager.editorConfig.LastMusicXmlPath );
                }
                dialog = new BFileChooser( dir );
                dialog.addFileFilter( _( "MusicXML(*.xml)|*.xml" ) );
                dialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
                dialog.setSelectedFile( lastFile );
                int result = dialog.showSaveDialog( this );
                if ( result != BFileChooser.APPROVE_OPTION ) {
                    return;
                }
                String file = dialog.getSelectedFile();
                String software = "Cadencii version " + BAssemblyInfo.fileVersion;
                vsq.printAsMusicXml( file, "UTF-8", software );
                AppManager.editorConfig.LastMusicXmlPath = file;
            } catch ( Exception ex ) {
                PortUtil.stderr.println( "FormMain#menuFileExportMusicXml_Click; ex=" + ex );
            } finally {
                if ( dialog != null ) {
                    try {
#if !JAVA
                        dialog.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                        PortUtil.stderr.println( "FormMain#menuFileExportMusicXml_Click; ex2=" + ex2 );
                    }
                }
            }
        }

        public void menuFileOpenVsq_Click( Object sender, EventArgs e ) {
            if ( !dirtyCheck() ) {
                return;
            }

            String[] filters = openMidiDialog.getChoosableFileFilter();
            String filter = "";
            foreach ( String f in filters ) {
                if ( f.EndsWith( AppManager.editorConfig.LastUsedExtension ) ) {
                    filter = f;
                    break;
                }
            }

            openMidiDialog.setFileFilter( filter );
            int dialog_result = openMidiDialog.showOpenDialog( this );
            if ( dialog_result == BFileChooser.APPROVE_OPTION ) {
#if DEBUG
                AppManager.debugWriteLine( "openMidiDialog.getFileFilter()=" + openMidiDialog.getFileFilter() );
#endif
                if ( openMidiDialog.getFileFilter().EndsWith( ".mid" ) ) {
                    AppManager.editorConfig.LastUsedExtension = ".mid";
                } else if ( openMidiDialog.getFileFilter().EndsWith( ".vsq" ) ) {
                    AppManager.editorConfig.LastUsedExtension = ".vsq";
                }
            } else {
                return;
            }
            try {
                VsqFileEx vsq = new VsqFileEx( openMidiDialog.getSelectedFile(), "Shift_JIS" );
                AppManager.setVsqFile( vsq );
            } catch ( Exception ex ) {
#if DEBUG
                PortUtil.println( "FormMain#menuFileOpenVsq_Click; ex=" + ex );
#endif
                AppManager.showMessageBox( _( "Invalid VSQ/VOCALOID MIDI file" ), _( "Error" ), org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION, org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                return;
            }
            AppManager.setSelected( 1 );
            clearExistingData();
            setEdited( false );
            AppManager.mixerWindow.updateStatus();
            clearTempWave();
            updateDrawObjectList();
            refreshScreen();
        }

        public void menuFileOpenUst_Click( Object sender, EventArgs e ) {
            if ( !dirtyCheck() ) {
                return;
            }
            int dialog_result = openUstDialog.showOpenDialog( this );

            if ( dialog_result != BFileChooser.APPROVE_OPTION ) {
                return;
            }

            try {
                UstFile ust = new UstFile( openUstDialog.getSelectedFile() );
                VsqFileEx vsq = new VsqFileEx( ust );
                clearExistingData();
                AppManager.setVsqFile( vsq );
                setEdited( false );
                AppManager.mixerWindow.updateStatus();
                clearTempWave();
                updateDrawObjectList();
                refreshScreen();
            } catch ( Exception ex ) {
#if DEBUG
                PortUtil.println( "FormMain#menuFileOpenUst_Click; ex=" + ex );
#endif
            }
        }

        public void menuFileImportVsq_Click( Object sender, EventArgs e ) {
            int dialog_result = openMidiDialog.showOpenDialog( this );

            if ( dialog_result != BFileChooser.APPROVE_OPTION ) {
                return;
            }
            VsqFileEx vsq = null;
            try {
                vsq = new VsqFileEx( openMidiDialog.getSelectedFile(), "Shift_JIS" );
            } catch ( Exception ex ) {
                AppManager.showMessageBox( _( "Invalid VSQ/VOCALOID MIDI file" ), _( "Error" ), org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION, org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                return;
            }
            if ( m_midi_imexport_dialog == null ) {
                m_midi_imexport_dialog = new FormMidiImExport();
            }
            m_midi_imexport_dialog.listTrack.clear();
            for ( int track = 1; track < vsq.Track.size(); track++ ) {
                m_midi_imexport_dialog.listTrack.addItem( "", new BListViewItem( new String[] { track + "", 
                                                                                                vsq.Track.get( track ).getName(),
                                                                                                vsq.Track.get( track ).getEventCount() + "" } ) );
                m_midi_imexport_dialog.listTrack.setItemCheckedAt( "", track - 1, true );
            }
            m_midi_imexport_dialog.setMode( FormMidiImExport.FormMidiMode.IMPORT_VSQ );
            m_midi_imexport_dialog.setTempo( false );
            m_midi_imexport_dialog.setTimesig( false );
            m_midi_imexport_dialog.setLocation( getFormPreferedLocation( m_midi_imexport_dialog ) );
            m_midi_imexport_dialog.setModal( true );
            m_midi_imexport_dialog.setVisible( true );
            if ( m_midi_imexport_dialog.getDialogResult() != BDialogResult.OK ) {
                return;
            }

            Vector<Integer> add_track = new Vector<Integer>();
            for ( int i = 0; i < m_midi_imexport_dialog.listTrack.getItemCount( "" ); i++ ) {
                if ( m_midi_imexport_dialog.listTrack.isItemCheckedAt( "", i ) ) {
                    add_track.add( i + 1 );
                }
            }
            if ( add_track.size() <= 0 ) {
                return;
            }

            VsqFileEx replace = (VsqFileEx)AppManager.getVsqFile().clone();
            double premeasure_sec_replace = replace.getSecFromClock( replace.getPreMeasureClocks() );
            double premeasure_sec_vsq = vsq.getSecFromClock( vsq.getPreMeasureClocks() );

            if ( m_midi_imexport_dialog.isTempo() ) {
                shiftClockToMatchWith( replace, vsq, premeasure_sec_replace - premeasure_sec_vsq );
                // テンポテーブルを置き換え
                replace.TempoTable.clear();
                for ( int i = 0; i < vsq.TempoTable.size(); i++ ) {
                    replace.TempoTable.add( (TempoTableEntry)vsq.TempoTable.get( i ).clone() );
                }
                replace.updateTempoInfo();
                replace.updateTotalClocks();
            }

            if ( m_midi_imexport_dialog.isTimesig() ) {
                // 拍子をリプレースする場合
                replace.TimesigTable.clear();
                for ( int i = 0; i < vsq.TimesigTable.size(); i++ ) {
                    replace.TimesigTable.add( (TimeSigTableEntry)vsq.TimesigTable.get( i ).clone() );
                }
                replace.updateTimesigInfo();
            }

            for ( Iterator<Integer> itr = add_track.iterator(); itr.hasNext(); ) {
                int track = itr.next();
                if ( replace.Track.size() + 1 >= 16 ) {
                    break;
                }
                if ( !m_midi_imexport_dialog.isTempo() ) {
                    // テンポをリプレースしない場合。インポートするトラックのクロックを調節する
                    for ( Iterator<VsqEvent> itr2 = vsq.Track.get( track ).getEventIterator(); itr2.hasNext(); ) {
                        VsqEvent item = itr2.next();
                        if ( item.ID.type == VsqIDType.Singer && item.Clock == 0 ) {
                            continue;
                        }
                        int clock = item.Clock;
                        double sec_start = vsq.getSecFromClock( clock ) - premeasure_sec_vsq + premeasure_sec_replace;
                        double sec_end = vsq.getSecFromClock( clock + item.ID.getLength() ) - premeasure_sec_vsq + premeasure_sec_replace;
                        int clock_start = (int)replace.getClockFromSec( sec_start );
                        int clock_end = (int)replace.getClockFromSec( sec_end );
                        item.Clock = clock_start;
                        item.ID.setLength( clock_end - clock_start );
                        if ( item.ID.VibratoHandle != null ) {
                            double sec_vib_start = vsq.getSecFromClock( clock + item.ID.VibratoDelay ) - premeasure_sec_vsq + premeasure_sec_replace;
                            int clock_vib_start = (int)replace.getClockFromSec( sec_vib_start );
                            item.ID.VibratoDelay = clock_vib_start - clock_start;
                            item.ID.VibratoHandle.setLength( clock_end - clock_vib_start );
                        }
                    }

                    // コントロールカーブをシフト
                    foreach ( CurveType ct in Utility.CURVE_USAGE ) {
                        VsqBPList item = vsq.Track.get( track ).getCurve( ct.getName() );
                        if ( item == null ) {
                            continue;
                        }
                        VsqBPList repl = new VsqBPList( item.getName(), item.getDefault(), item.getMinimum(), item.getMaximum() );
                        for ( int i = 0; i < item.size(); i++ ) {
                            int clock = item.getKeyClock( i );
                            int value = item.getElement( i );
                            double sec = vsq.getSecFromClock( clock ) - premeasure_sec_vsq + premeasure_sec_replace;
                            if ( sec >= premeasure_sec_replace ) {
                                int clock_new = (int)replace.getClockFromSec( sec );
                                repl.add( clock_new, value );
                            }
                        }
                        vsq.Track.get( track ).setCurve( ct.getName(), repl );
                    }

                    // ベジエカーブをシフト
                    foreach ( CurveType ct in Utility.CURVE_USAGE ) {
                        Vector<BezierChain> list = vsq.AttachedCurves.get( track - 1 ).get( ct );
                        if ( list == null ) {
                            continue;
                        }
                        for ( Iterator<BezierChain> itr2 = list.iterator(); itr2.hasNext(); ) {
                            BezierChain chain = itr2.next();
                            for ( Iterator<BezierPoint> itr3 = chain.points.iterator(); itr3.hasNext(); ) {
                                BezierPoint point = itr3.next();
                                PointD bse = new PointD( replace.getClockFromSec( vsq.getSecFromClock( point.getBase().getX() ) - premeasure_sec_vsq + premeasure_sec_replace ),
                                                         point.getBase().getY() );
                                PointD ctrl_r = new PointD( replace.getClockFromSec( vsq.getSecFromClock( point.controlLeft.getX() ) - premeasure_sec_vsq + premeasure_sec_replace ),
                                                            point.controlLeft.getY() );
                                PointD ctrl_l = new PointD( replace.getClockFromSec( vsq.getSecFromClock( point.controlRight.getX() ) - premeasure_sec_vsq + premeasure_sec_replace ),
                                                            point.controlRight.getY() );
                                point.setBase( bse );
                                point.controlLeft = ctrl_l;
                                point.controlRight = ctrl_r;
                            }
                        }
                    }
                }
                replace.Mixer.Slave.add( new VsqMixerEntry() );
                replace.Track.add( vsq.Track.get( track ) );
                replace.AttachedCurves.add( vsq.AttachedCurves.get( track - 1 ) );
            }

            // コマンドを発行し、実行
            CadenciiCommand run = VsqFileEx.generateCommandReplace( replace );
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
            setEdited( true );
        }

        public void commonFileOpen_Click( Object sender, EventArgs e ) {
            if ( !dirtyCheck() ) {
                return;
            }
            int dialog_result = openXmlVsqDialog.showOpenDialog( this );
            if ( dialog_result == BFileChooser.APPROVE_OPTION ) {
                if ( AppManager.isPlaying() ) {
                    AppManager.setPlaying( false );
                }
                String file = openXmlVsqDialog.getSelectedFile();
                openVsqCor( file );
                clearExistingData();

                if ( AppManager.editorConfig.UseProjectCache ) {
                    #region キャッシュディレクトリの処理
                    VsqFileEx vsq = AppManager.getVsqFile();
                    String cacheDir = vsq.cacheDir; // xvsqに保存されていたキャッシュのディレクトリ
                    String dir = PortUtil.getDirectoryName( file );
                    String name = PortUtil.getFileNameWithoutExtension( file );
                    String estimatedCacheDir = PortUtil.combinePath( dir, name + ".cadencii" ); // ファイル名から推測されるキャッシュディレクトリ
                    if ( cacheDir == null ) cacheDir = "";
                    if ( !cacheDir.Equals( "" ) && PortUtil.isDirectoryExists( cacheDir ) ) {
                        if ( !estimatedCacheDir.Equals( "" ) &&
                             !cacheDir.Equals( estimatedCacheDir ) ) {
                            // ファイル名から推測されるキャッシュディレクトリ名と
                            // xvsqに指定されているキャッシュディレクトリと異なる場合
                            // cacheDirの必要な部分をestimatedCacheDirに移す

                            // estimatedCacheDirが存在しない場合、新しく作る
                            if ( !PortUtil.isDirectoryExists( estimatedCacheDir ) ) {
                                try {
                                    PortUtil.createDirectory( estimatedCacheDir );
                                } catch ( Exception ex ) {
                                    PortUtil.stderr.println( "FormMain#commonFileOpen_Click; ex=" + ex );
                                    AppManager.showMessageBox( PortUtil.formatMessage( _( "cannot create cache directory: '{0}'" ), estimatedCacheDir ),
                                                               _( "Info." ),
                                                               PortUtil.OK_OPTION,
                                                               org.kbinani.windows.forms.Utility.MSGBOX_INFORMATION_MESSAGE );
                                    return;
                                }
                            }

                            // ファイルを移す
                            for ( int i = 1; i < vsq.Track.size(); i++ ) {
                                String wavFrom = PortUtil.combinePath( cacheDir, i + ".wav" );
                                String xmlFrom = PortUtil.combinePath( cacheDir, i + ".xml" );

                                String wavTo = PortUtil.combinePath( estimatedCacheDir, i + ".wav" );
                                String xmlTo = PortUtil.combinePath( estimatedCacheDir, i + ".xml" );
                                if ( PortUtil.isFileExists( wavFrom ) ) {
                                    try {
                                        PortUtil.moveFile( wavFrom, wavTo );
                                    } catch ( Exception ex ) {
                                        PortUtil.stderr.println( "FormMain#commonFileOpen; ex=" + ex );
                                    }
                                }
                                if ( PortUtil.isFileExists( xmlFrom ) ) {
                                    try {
                                        PortUtil.moveFile( xmlFrom, xmlTo );
                                    } catch ( Exception ex ) {
                                        PortUtil.stderr.println( "FormMain#commonFileOpen; ex=" + ex );
                                    }
                                }
                            }

                        }
                    }
                    cacheDir = estimatedCacheDir;

                    // キャッシュが無かったら作成
                    if ( !PortUtil.isDirectoryExists( cacheDir ) ) {
                        try {
                            PortUtil.createDirectory( cacheDir );
                        } catch ( Exception ex ) {
                            PortUtil.stderr.println( "FormMain#commonFileOpen_Click; ex=" + ex );
                            AppManager.showMessageBox( PortUtil.formatMessage( _( "cannot create cache directory: '{0}'" ), estimatedCacheDir ),
                                                       _( "Info." ),
                                                       PortUtil.OK_OPTION,
                                                       org.kbinani.windows.forms.Utility.MSGBOX_INFORMATION_MESSAGE );
                            return;
                        }
                    }

                    // RenderedStatusを読み込む
                    for ( int i = 1; i < vsq.Track.size(); i++ ) {
                        String xml = PortUtil.combinePath( cacheDir, i + ".xml" );
                        if ( !PortUtil.isFileExists( xml ) ) {
                            continue;
                        }
                        FileInputStream fs = null;
                        RenderedStatus status = null;
                        try {
                            fs = new FileInputStream( xml );
                            Object obj = AppManager.renderingStatusSerializer.deserialize( fs );
                            if ( obj != null && obj is RenderedStatus ) {
                                status = (RenderedStatus)obj;
                            }
                        } catch ( Exception ex ) {
                            status = null;
                            PortUtil.stderr.println( "FormMain#commonFileOpen_Click; ex=" + ex );
                        } finally {
                            if ( fs != null ) {
                                try {
                                    fs.close();
                                } catch ( Exception ex2 ) {
                                    PortUtil.stderr.println( "FormMain#commonFileOpen_Click; ex2=" + ex2 );
                                }
                            }
                        }
                        AppManager.lastRenderedStatus[i - 1] = status;
                    }

                    // キャッシュ内のwavを、waveViewに読み込む
                    waveView.unloadAll();
                    for ( int i = 1; i < vsq.Track.size(); i++ ) {
                        String wav = PortUtil.combinePath( cacheDir, i + ".wav" );
                        if ( !PortUtil.isFileExists( wav ) ) {
                            continue;
                        }
                        waveView.load( i - 1, wav );
                    }

                    // 一時ディレクトリを、cachedirに変更
                    AppManager.setTempWaveDir( cacheDir );
                    #endregion
                }

                setEdited( false );
                AppManager.mixerWindow.updateStatus();
                clearTempWave();
                updateDrawObjectList();
                refreshScreen();
            }
        }

        public void commonFileNew_Click( Object sender, EventArgs e ) {
            if ( !dirtyCheck() ) {
                return;
            }
            AppManager.setSelected( 1 );
            VsqFileEx vsq = new VsqFileEx( AppManager.editorConfig.DefaultSingerName, AppManager.editorConfig.DefaultPreMeasure, 4, 4, 500000 );

            RendererKind kind = AppManager.editorConfig.DefaultSynthesizer;
            String renderer = AppManager.getVersionStringFromRendererKind( kind );
            Vector<VsqID> singers = AppManager.getSingerListFromRendererKind( kind );
            vsq.Track.get( 1 ).changeRenderer( renderer, singers );

            AppManager.setVsqFile( vsq );
            clearExistingData();
            setEdited( false );
            AppManager.mixerWindow.updateStatus();
            clearTempWave();

            // キャッシュディレクトリのパスを、デフォルトに戻す
            AppManager.setTempWaveDir( PortUtil.combinePath( AppManager.getCadenciiTempDir(), AppManager.getID() ) );

            updateDrawObjectList();
            refreshScreen();
        }

        public void menuFileNew_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Create new project." ) );
        }

        public void menuFileOpen_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Open Cadencii project." ) );
        }

        public void menuFileSave_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Save current project." ) );
        }

        public void menuFileSaveNamed_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Save current project with new name." ) );
        }

        public void menuFileOpenVsq_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Open VSQ / VOCALOID MIDI and create new project." ) );
        }

        public void menuFileOpenUst_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Open UTAU project and create new project." ) );
        }

        public void menuFileImport_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Import." ) );
        }

        public void menuFileImportVsq_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Import VSQ / VOCALOID MIDI." ) );
        }

        public void menuFileImportMidi_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Import Standard MIDI." ) );
        }

        public void menuFileExportWave_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Export to WAVE file." ) );
        }

        public void menuFileExportMidi_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Export to Standard MIDI." ) );
        }

        public void menuFileRecent_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Recent projects." ) );
        }

        public void menuFileQuit_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Close this window." ) );
        }
        #endregion

        #region menuSetting*
        public void menuSettingDefaultSingerStyle_Click( Object sender, EventArgs e ) {
            FormSingerStyleConfig dlg = null;
            try {
                dlg = new FormSingerStyleConfig();
                dlg.setPMBendDepth( AppManager.editorConfig.DefaultPMBendDepth );
                dlg.setPMBendLength( AppManager.editorConfig.DefaultPMBendLength );
                dlg.setPMbPortamentoUse( AppManager.editorConfig.DefaultPMbPortamentoUse );
                dlg.setDEMdecGainRate( AppManager.editorConfig.DefaultDEMdecGainRate );
                dlg.setDEMaccent( AppManager.editorConfig.DefaultDEMaccent );

                int selected = AppManager.getSelected();
                dlg.setLocation( getFormPreferedLocation( dlg ) );
                dlg.setModal( true );
                dlg.setVisible( true );
                if ( dlg.getDialogResult() == BDialogResult.OK ) {
                    if ( dlg.getApplyCurrentTrack() ) {
                        VsqFileEx vsq = AppManager.getVsqFile();
                        VsqTrack vsq_track = vsq.Track.get( selected );
                        VsqTrack copy = (VsqTrack)vsq_track.clone();
                        boolean changed = false;
                        for ( int i = 0; i < copy.getEventCount(); i++ ) {
                            if ( copy.getEvent( i ).ID.type == VsqIDType.Anote ) {
                                copy.getEvent( i ).ID.PMBendDepth = dlg.getPMBendDepth();
                                copy.getEvent( i ).ID.PMBendLength = dlg.getPMBendLength();
                                copy.getEvent( i ).ID.PMbPortamentoUse = dlg.getPMbPortamentoUse();
                                copy.getEvent( i ).ID.DEMdecGainRate = dlg.getDEMdecGainRate();
                                copy.getEvent( i ).ID.DEMaccent = dlg.getDEMaccent();
                                changed = true;
                            }
                        }
                        if ( changed ) {
                            CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( selected,
                                                                                         copy,
                                                                                         vsq.AttachedCurves.get( selected - 1 ) );
                            AppManager.register( vsq.executeCommand( run ) );
                            updateDrawObjectList();
                            refreshScreen();
                        }
                    }
                    AppManager.editorConfig.DefaultPMBendDepth = dlg.getPMBendDepth();
                    AppManager.editorConfig.DefaultPMBendLength = dlg.getPMBendLength();
                    AppManager.editorConfig.DefaultPMbPortamentoUse = dlg.getPMbPortamentoUse();
                    AppManager.editorConfig.DefaultDEMdecGainRate = dlg.getDEMdecGainRate();
                    AppManager.editorConfig.DefaultDEMaccent = dlg.getDEMaccent();
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

#if ENABLE_MIDI
        public void menuSettingMidi_Click( Object sender, EventArgs e ) {
            FormMidiConfig form = null;
            try {
                form = new FormMidiConfig();
                form.setLocation( getFormPreferedLocation( form ) );
                form.setModal( true );
                form.setVisible( true );
                if ( form.getDialogResult() == BDialogResult.OK ) {

                }
            } catch ( Exception ex ) {
            } finally {
                if ( form != null ) {
                    try {
                        form.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }
#endif

        public void menuSettingPreference_Click( Object sender, EventArgs e ) {
            try {
                if ( m_preference_dlg == null ) {
                    m_preference_dlg = new Preference();
                }
                m_preference_dlg.setBaseFont( new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE9 ) );
                m_preference_dlg.setScreenFont( new Font( AppManager.editorConfig.ScreenFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE9 ) );
                m_preference_dlg.setWheelOrder( AppManager.editorConfig.WheelOrder );
                m_preference_dlg.setCursorFixed( AppManager.editorConfig.CursorFixed );
                m_preference_dlg.setDefaultVibratoLength( AppManager.editorConfig.DefaultVibratoLength );
                m_preference_dlg.setAutoVibratoMinimumLength( AppManager.editorConfig.AutoVibratoMinimumLength );
                m_preference_dlg.setAutoVibratoType1( AppManager.editorConfig.AutoVibratoType1 );
                m_preference_dlg.setAutoVibratoType2( AppManager.editorConfig.AutoVibratoType2 );
                m_preference_dlg.setEnableAutoVibrato( AppManager.editorConfig.EnableAutoVibrato );
                m_preference_dlg.setPreMeasure( AppManager.getVsqFile().getPreMeasure() );
                m_preference_dlg.setPreSendTime( AppManager.editorConfig.PreSendTime );
                m_preference_dlg.setControlCurveResolution( AppManager.editorConfig.ControlCurveResolution );
                m_preference_dlg.setDefaultSingerName( AppManager.editorConfig.DefaultSingerName );
                m_preference_dlg.setScrollHorizontalOnWheel( AppManager.editorConfig.ScrollHorizontalOnWheel );
                m_preference_dlg.setMaximumFrameRate( AppManager.editorConfig.MaximumFrameRate );
                m_preference_dlg.setPlatform( AppManager.editorConfig.Platform );
                m_preference_dlg.setKeepLyricInputMode( AppManager.editorConfig.KeepLyricInputMode );
                m_preference_dlg.setPxTrackHeight( AppManager.editorConfig.PxTrackHeight );
                m_preference_dlg.setMouseHoverTime( AppManager.editorConfig.getMouseHoverTime() );
                m_preference_dlg.setPlayPreviewWhenRightClick( AppManager.editorConfig.PlayPreviewWhenRightClick );
                m_preference_dlg.setCurveSelectingQuantized( AppManager.editorConfig.CurveSelectingQuantized );
                m_preference_dlg.setCurveVisibleAccent( AppManager.editorConfig.CurveVisibleAccent );
                m_preference_dlg.setCurveVisibleBre( AppManager.editorConfig.CurveVisibleBreathiness );
                m_preference_dlg.setCurveVisibleBri( AppManager.editorConfig.CurveVisibleBrightness );
                m_preference_dlg.setCurveVisibleCle( AppManager.editorConfig.CurveVisibleClearness );
                m_preference_dlg.setCurveVisibleDecay( AppManager.editorConfig.CurveVisibleDecay );
                m_preference_dlg.setCurveVisibleDyn( AppManager.editorConfig.CurveVisibleDynamics );
                m_preference_dlg.setCurveVisibleGen( AppManager.editorConfig.CurveVisibleGendorfactor );
                m_preference_dlg.setCurveVisibleOpe( AppManager.editorConfig.CurveVisibleOpening );
                m_preference_dlg.setCurveVisiblePit( AppManager.editorConfig.CurveVisiblePit );
                m_preference_dlg.setCurveVisiblePbs( AppManager.editorConfig.CurveVisiblePbs );
                m_preference_dlg.setCurveVisiblePor( AppManager.editorConfig.CurveVisiblePortamento );
                m_preference_dlg.setCurveVisibleVel( AppManager.editorConfig.CurveVisibleVelocity );
                m_preference_dlg.setCurveVisibleVibratoDepth( AppManager.editorConfig.CurveVisibleVibratoDepth );
                m_preference_dlg.setCurveVisibleVibratoRate( AppManager.editorConfig.CurveVisibleVibratoRate );
                m_preference_dlg.setCurveVisibleFx2Depth( AppManager.editorConfig.CurveVisibleFx2Depth );
                m_preference_dlg.setCurveVisibleHarmonics( AppManager.editorConfig.CurveVisibleHarmonics );
                m_preference_dlg.setCurveVisibleReso1( AppManager.editorConfig.CurveVisibleReso1 );
                m_preference_dlg.setCurveVisibleReso2( AppManager.editorConfig.CurveVisibleReso2 );
                m_preference_dlg.setCurveVisibleReso3( AppManager.editorConfig.CurveVisibleReso3 );
                m_preference_dlg.setCurveVisibleReso4( AppManager.editorConfig.CurveVisibleReso4 );
                m_preference_dlg.setCurveVisibleEnvelope( AppManager.editorConfig.CurveVisibleEnvelope );
#if ENABLE_MIDI
                m_preference_dlg.setMidiInPort( AppManager.editorConfig.MidiInPort.PortNumber );
#endif
#if ENABLE_MTC
            m_preference_dlg.setMtcMidiInPort( AppManager.editorConfig.MidiInPortMtc.PortNumber );

#endif
                m_preference_dlg.setInvokeWithWine( AppManager.editorConfig.InvokeUtauCoreWithWine );
                m_preference_dlg.setPathResampler( AppManager.editorConfig.PathResampler );
                m_preference_dlg.setPathWavtool( AppManager.editorConfig.PathWavtool );
                m_preference_dlg.setUtauSingers( AppManager.editorConfig.UtauSingers );
                m_preference_dlg.setSelfDeRomantization( AppManager.editorConfig.SelfDeRomanization );
                m_preference_dlg.setAutoBackupIntervalMinutes( AppManager.editorConfig.AutoBackupIntervalMinutes );
                m_preference_dlg.setUseSpaceKeyAsMiddleButtonModifier( AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier );
                m_preference_dlg.setPathAquesTone( AppManager.editorConfig.PathAquesTone );
                m_preference_dlg.setWaveFileOutputFromMasterTrack( AppManager.editorConfig.WaveFileOutputFromMasterTrack );
                m_preference_dlg.setWaveFileOutputChannel( AppManager.editorConfig.WaveFileOutputChannel );
                m_preference_dlg.setUseProjectCache( AppManager.editorConfig.UseProjectCache );
                m_preference_dlg.setLoadAquesTone( !AppManager.editorConfig.DoNotUseAquesTone );
                m_preference_dlg.setLoadSecondaryVocaloid1Dll( AppManager.editorConfig.LoadSecondaryVocaloid1Dll );
                m_preference_dlg.setLoadVocaloid100( !AppManager.editorConfig.DoNotUseVocaloid100 );
                m_preference_dlg.setLoadVocaloid101( !AppManager.editorConfig.DoNotUseVocaloid101 );
                m_preference_dlg.setLoadVocaloid2( !AppManager.editorConfig.DoNotUseVocaloid2 );
                m_preference_dlg.setBufferSize( AppManager.editorConfig.BufferSizeMilliSeconds );
                m_preference_dlg.setDefaultVibratoDepth( AppManager.editorConfig.DefaultVibratoDepth );
                m_preference_dlg.setDefaultVibratoRate( AppManager.editorConfig.DefaultVibratoRate );
                m_preference_dlg.setDefaultSynthesizer( AppManager.editorConfig.DefaultSynthesizer );
                m_preference_dlg.setUseUserDefinedAutoVibratoType( AppManager.editorConfig.UseUserDefinedAutoVibratoType );

                m_preference_dlg.setLocation( getFormPreferedLocation( m_preference_dlg ) );

                m_preference_dlg.setModal( true );
                m_preference_dlg.setVisible( true );
                if ( m_preference_dlg.getDialogResult() == BDialogResult.OK ) {
                    String old_base_font_name = AppManager.editorConfig.BaseFontName;
                    float old_base_font_size = AppManager.editorConfig.BaseFontSize;
                    Font new_base_font = m_preference_dlg.getBaseFont();
#if DEBUG
                PortUtil.println( "FormMain#menuSettingPreference; old_base_font_name=" + old_base_font_name + "; new_base_font.getName()=" + new_base_font.getName() );
                PortUtil.println( "FormMain#menuSettingPreference; old_base_font_size=" + old_base_font_size + "; new_base_font.getSize2D()=" + new_base_font.getSize2D() );
#endif
                    if ( !old_base_font_name.Equals( new_base_font.getName() ) ||
                         old_base_font_size != new_base_font.getSize2D() ) {
#if DEBUG
                    PortUtil.println( "FormMain#menuSettingPreference; font changed" );
#endif
                        AppManager.editorConfig.BaseFontName = m_preference_dlg.getBaseFont().getName();
                        AppManager.editorConfig.BaseFontSize = m_preference_dlg.getBaseFont().getSize2D();
                        updateMenuFonts();
                    }

                    AppManager.editorConfig.ScreenFontName = m_preference_dlg.getScreenFont().getName();
                    AppManager.editorConfig.WheelOrder = m_preference_dlg.getWheelOrder();
                    AppManager.editorConfig.CursorFixed = m_preference_dlg.isCursorFixed();

                    AppManager.editorConfig.DefaultVibratoLength = m_preference_dlg.getDefaultVibratoLength();
                    AppManager.editorConfig.AutoVibratoMinimumLength = m_preference_dlg.getAutoVibratoMinimumLength();
                    AppManager.editorConfig.AutoVibratoType1 = m_preference_dlg.getAutoVibratoType1();
                    AppManager.editorConfig.AutoVibratoType2 = m_preference_dlg.getAutoVibratoType2();

                    AppManager.editorConfig.EnableAutoVibrato = m_preference_dlg.isEnableAutoVibrato();
                    AppManager.editorConfig.PreSendTime = m_preference_dlg.getPreSendTime();
                    AppManager.editorConfig.DefaultPreMeasure = m_preference_dlg.getPreMeasure();
                    if ( m_preference_dlg.getPreMeasure() != AppManager.getVsqFile().getPreMeasure() ) {
                        CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandChangePreMeasure( m_preference_dlg.getPreMeasure() ) );
                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                        setEdited( true );
                    }
                    AppManager.editorConfig.Language = m_preference_dlg.getLanguage();
                    if ( !Messaging.getLanguage().Equals( AppManager.editorConfig.Language ) ) {
                        Messaging.setLanguage( AppManager.editorConfig.Language );
                        applyLanguage();
                        m_preference_dlg.applyLanguage();
                        AppManager.mixerWindow.applyLanguage();
#if JAVA
                    if ( m_versioninfo != null ) {
#else
                        if ( m_versioninfo != null && !m_versioninfo.IsDisposed ) {
#endif
                            m_versioninfo.applyLanguage();
                        }
#if ENABLE_PROPERTY
                        AppManager.propertyWindow.applyLanguage();
                        AppManager.propertyPanel.UpdateValue( AppManager.getSelected() );
#endif
                    }

                    AppManager.editorConfig.ControlCurveResolution = m_preference_dlg.getControlCurveResolution();
                    AppManager.editorConfig.DefaultSingerName = m_preference_dlg.getDefaultSingerName();
                    AppManager.editorConfig.ScrollHorizontalOnWheel = m_preference_dlg.isScrollHorizontalOnWheel();
                    AppManager.editorConfig.MaximumFrameRate = m_preference_dlg.getMaximumFrameRate();
                    int fps = 1000 / AppManager.editorConfig.MaximumFrameRate;
                    timer.setDelay( (fps <= 0) ? 1 : fps );
                    AppManager.editorConfig.Platform = m_preference_dlg.getPlatform();
                    s_modifier_key = ((AppManager.editorConfig.Platform == PlatformEnum.Macintosh) ? InputEvent.META_MASK : InputEvent.CTRL_MASK);
                    applyShortcut();
                    AppManager.editorConfig.KeepLyricInputMode = m_preference_dlg.isKeepLyricInputMode();
                    if ( AppManager.editorConfig.PxTrackHeight != m_preference_dlg.getPxTrackHeight() ) {
                        AppManager.editorConfig.PxTrackHeight = m_preference_dlg.getPxTrackHeight();
                        updateDrawObjectList();
                    }
                    AppManager.editorConfig.setMouseHoverTime( m_preference_dlg.getMouseHoverTime() );
                    AppManager.editorConfig.PlayPreviewWhenRightClick = m_preference_dlg.isPlayPreviewWhenRightClick();
                    AppManager.editorConfig.CurveSelectingQuantized = m_preference_dlg.isCurveSelectingQuantized();

                    AppManager.editorConfig.CurveVisibleAccent = m_preference_dlg.isCurveVisibleAccent();
                    AppManager.editorConfig.CurveVisibleBreathiness = m_preference_dlg.isCurveVisibleBre();
                    AppManager.editorConfig.CurveVisibleBrightness = m_preference_dlg.isCurveVisibleBri();
                    AppManager.editorConfig.CurveVisibleClearness = m_preference_dlg.isCurveVisibleCle();
                    AppManager.editorConfig.CurveVisibleDecay = m_preference_dlg.isCurveVisibleDecay();
                    AppManager.editorConfig.CurveVisibleDynamics = m_preference_dlg.isCurveVisibleDyn();
                    AppManager.editorConfig.CurveVisibleGendorfactor = m_preference_dlg.isCurveVisibleGen();
                    AppManager.editorConfig.CurveVisibleOpening = m_preference_dlg.isCurveVisibleOpe();
                    AppManager.editorConfig.CurveVisiblePit = m_preference_dlg.isCurveVisiblePit();
                    AppManager.editorConfig.CurveVisiblePbs = m_preference_dlg.isCurveVisiblePbs();
                    AppManager.editorConfig.CurveVisiblePortamento = m_preference_dlg.isCurveVisiblePor();
                    AppManager.editorConfig.CurveVisibleVelocity = m_preference_dlg.isCurveVisibleVel();
                    AppManager.editorConfig.CurveVisibleVibratoDepth = m_preference_dlg.isCurveVisibleVibratoDepth();
                    AppManager.editorConfig.CurveVisibleVibratoRate = m_preference_dlg.isCurveVisibleVibratoRate();
                    AppManager.editorConfig.CurveVisibleFx2Depth = m_preference_dlg.isCurveVisibleFx2Depth();
                    AppManager.editorConfig.CurveVisibleHarmonics = m_preference_dlg.isCurveVisibleHarmonics();
                    AppManager.editorConfig.CurveVisibleReso1 = m_preference_dlg.isCurveVisibleReso1();
                    AppManager.editorConfig.CurveVisibleReso2 = m_preference_dlg.isCurveVisibleReso2();
                    AppManager.editorConfig.CurveVisibleReso3 = m_preference_dlg.isCurveVisibleReso3();
                    AppManager.editorConfig.CurveVisibleReso4 = m_preference_dlg.isCurveVisibleReso4();
                    AppManager.editorConfig.CurveVisibleEnvelope = m_preference_dlg.isCurveVisibleEnvelope();

#if ENABLE_MIDI
                    AppManager.editorConfig.MidiInPort.PortNumber = m_preference_dlg.getMidiInPort();
#endif
#if ENABLE_MTC
                AppManager.editorConfig.MidiInPortMtc.PortNumber = m_preference_dlg.getMtcMidiInPort();
#endif
#if ENABLE_MIDI || ENABLE_MTC
                    updateMidiInStatus();
                    reloadMidiIn();
#endif

                    AppManager.editorConfig.InvokeUtauCoreWithWine = m_preference_dlg.isInvokeWithWine();
                    AppManager.editorConfig.PathResampler = m_preference_dlg.getPathResampler();
                    AppManager.editorConfig.PathWavtool = m_preference_dlg.getPathWavtool();

                    AppManager.editorConfig.UtauSingers.clear();
                    for ( Iterator<SingerConfig> itr = m_preference_dlg.getUtauSingers().iterator(); itr.hasNext(); ) {
                        SingerConfig sc = itr.next();
                        AppManager.editorConfig.UtauSingers.add( (SingerConfig)sc.clone() );
                    }
                    AppManager.reloadUtauVoiceDB();

                    AppManager.editorConfig.SelfDeRomanization = m_preference_dlg.isSelfDeRomantization();
                    AppManager.editorConfig.AutoBackupIntervalMinutes = m_preference_dlg.getAutoBackupIntervalMinutes();
                    AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier = m_preference_dlg.isUseSpaceKeyAsMiddleButtonModifier();
#if ENABLE_AQUESTONE
                    String old_aquestone_dll = AppManager.editorConfig.PathAquesTone;
                    String new_aquestone_dll = m_preference_dlg.getPathAquesTone();
                    AppManager.editorConfig.PathAquesTone = m_preference_dlg.getPathAquesTone();
                    if ( !old_aquestone_dll.Equals( new_aquestone_dll ) ) {
                        VSTiProxy.reloadAquesTone();
                    }
#endif
                    AppManager.editorConfig.WaveFileOutputFromMasterTrack = m_preference_dlg.isWaveFileOutputFromMasterTrack();
                    AppManager.editorConfig.WaveFileOutputChannel = m_preference_dlg.getWaveFileOutputChannel();
                    if ( AppManager.editorConfig.UseProjectCache && !m_preference_dlg.isUseProjectCache() ) {
                        // プロジェクト用キャッシュを使用していたが，使用しないように変更された場合.
                        // プロジェクト用キャッシュが存在するなら，共用のキャッシュに移動する．
                        String file = AppManager.getFileName();
                        if ( file != null && !file.Equals( "" ) ) {
                            String dir = PortUtil.getDirectoryName( file );
                            String name = PortUtil.getFileNameWithoutExtension( file );
                            String projectCacheDir = PortUtil.combinePath( dir, name + ".cadencii" );
                            String commonCacheDir = PortUtil.combinePath( AppManager.getCadenciiTempDir(), AppManager.getID() );
                            if ( PortUtil.isDirectoryExists( projectCacheDir ) ) {
                                VsqFileEx vsq = AppManager.getVsqFile();
                                for ( int i = 1; i < vsq.Track.size(); i++ ) {
                                    // wavを移動
                                    String wavFrom = PortUtil.combinePath( projectCacheDir, i + ".wav" );
                                    String wavTo = PortUtil.combinePath( commonCacheDir, i + ".wav" );
                                    if ( !PortUtil.isFileExists( wavFrom ) ) {
                                        continue;
                                    }
                                    if ( PortUtil.isFileExists( wavTo ) ) {
                                        try {
                                            PortUtil.deleteFile( wavTo );
                                        } catch ( Exception ex ) {
                                            PortUtil.stderr.println( "FormMain#menuSettingPreference_Click; ex=" + ex );
                                            continue;
                                        }
                                    }
                                    try {
                                        PortUtil.moveFile( wavFrom, wavTo );
                                    } catch ( Exception ex ) {
                                        PortUtil.stderr.println( "FormMain#menuSettingPreference_Click; ex=" + ex );
                                    }

                                    // xmlを移動
                                    String xmlFrom = PortUtil.combinePath( projectCacheDir, i + ".xml" );
                                    String xmlTo = PortUtil.combinePath( commonCacheDir, i + ".xml" );
                                    if ( !PortUtil.isFileExists( xmlFrom ) ) {
                                        continue;
                                    }
                                    if ( PortUtil.isFileExists( xmlTo ) ) {
                                        try {
                                            PortUtil.deleteFile( xmlTo );
                                        } catch ( Exception ex ) {
                                            PortUtil.stderr.println( "FormMain#menuSettingPreference_Click; ex=" + ex );
                                            continue;
                                        }
                                    }
                                    try {
                                        PortUtil.moveFile( xmlFrom, xmlTo );
                                    } catch ( Exception ex ) {
                                        PortUtil.stderr.println( "FormMain#menuSettingPreference_Click; ex=" + ex );
                                    }
                                }

                                // projectCacheDirが空なら，ディレクトリごと削除する
                                String[] files = PortUtil.listFiles( projectCacheDir, "*.*" );
                                if ( files.Length <= 0 ) {
                                    try {
                                        PortUtil.deleteDirectory( projectCacheDir );
                                    } catch ( Exception ex ) {
                                        PortUtil.stderr.println( "FormMain#menuSettingPreference_Click; ex=" + ex );
                                    }
                                }

                                // キャッシュのディレクトリを再指定
                                AppManager.setTempWaveDir( commonCacheDir );
                            }
                        }
                    }
                    AppManager.editorConfig.UseProjectCache = m_preference_dlg.isUseProjectCache();
                    AppManager.editorConfig.DoNotUseAquesTone = !m_preference_dlg.isLoadAquesTone();
                    AppManager.editorConfig.DoNotUseVocaloid100 = !m_preference_dlg.isLoadVocaloid100();
                    AppManager.editorConfig.DoNotUseVocaloid101 = !m_preference_dlg.isLoadVocaloid101();
                    AppManager.editorConfig.DoNotUseVocaloid2 = !m_preference_dlg.isLoadVocaloid2();
                    AppManager.editorConfig.LoadSecondaryVocaloid1Dll = m_preference_dlg.isLoadSecondaryVocaloid1Dll();
                    AppManager.editorConfig.BufferSizeMilliSeconds = m_preference_dlg.getBufferSize();
                    AppManager.editorConfig.DefaultVibratoRate = m_preference_dlg.getDefaultVibratoRate();
                    AppManager.editorConfig.DefaultVibratoDepth = m_preference_dlg.getDefaultVibratoDepth();
                    AppManager.editorConfig.DefaultSynthesizer = m_preference_dlg.getDefaultSynthesizer();
                    AppManager.editorConfig.UseUserDefinedAutoVibratoType = m_preference_dlg.isUseUserDefinedAutoVibratoType();

                    AppManager.clearViewingCurve();
                    trackSelector.prepareSingerMenu( VsqFileEx.getTrackRendererKind( AppManager.getVsqFile().Track.get( AppManager.getSelected() ) ) );

                    updateTrackSelectorVisibleCurve();
                    updateRendererMenu();
                    AppManager.updateAutoBackupTimerStatus();

                    // editorConfig.PxTrackHeightが変更されている可能性があるので，更新が必要
                    AppManager.setStartToDrawY( calculateStartToDrawY() );

                    if ( menuVisualControlTrack.isSelected() ) {
                        splitContainer1.setPanel2MinSize( trackSelector.getPreferredMinSize() );
                    }

                    AppManager.saveConfig();
                    applyLanguage();
#if ENABLE_SCRIPT
                    updateScriptShortcut();
#endif

                    updateDrawObjectList();
                    refreshScreen();
                }
            } catch ( Exception ex ) {
                AppManager.debugWriteLine( "FormMain#menuSettingPreference_Click; ex=" + ex );
            }
        }

        public void menuSettingShortcut_Click( Object sender, EventArgs e ) {
            TreeMap<String, ValuePair<String, BKeys[]>> dict = new TreeMap<String, ValuePair<String, BKeys[]>>();
            TreeMap<String, BKeys[]> configured = AppManager.editorConfig.getShortcutKeysDictionary();

            // スクリプトのToolStripMenuITemを蒐集
            Vector<String> script_shortcut = new Vector<String>();
            MenuElement[] sub_menu_script = menuScript.getSubElements();
            for ( int i = 0; i < sub_menu_script.Length; i++ ) {
                MenuElement tsi = sub_menu_script[i];
                if ( tsi is BMenuItem ) {
                    BMenuItem tsmi = (BMenuItem)tsi;
                    String name = tsmi.getName();
                    script_shortcut.add( name );
                    if ( !configured.containsKey( name ) ) {
                        configured.put( name, new BKeys[] { } );
                    }
                }
            }

            for ( Iterator<String> itr = configured.keySet().iterator(); itr.hasNext(); ) {
                String name = itr.next();
                Object menu = searchMenuItemFromName( name );
#if DEBUG
                PortUtil.println( "menuSettingShrtcut_Click; name=" + name + "; (menu==null)=" + (menu == null) );
#endif
                if ( menu != null ) {
                    String parent = "";
                    MenuElement owner_item = null;
                    if ( !(menu is BMenuItem) ) {
                        continue;
                    }
                    BMenuItem casted_menu = (BMenuItem)menu;
                    Object pa = casted_menu.getParent();
                    if ( pa != null && pa is MenuElement ) {
                        owner_item = (MenuElement)pa;
                    }

                    if ( owner_item == null ) {
                        continue;
                    }
                    if ( !(owner_item is BMenuItem) ) {
                        continue;
                    }
                    BMenuItem casted_owner_item = (BMenuItem)owner_item;
                    if ( !casted_owner_item.getName().Equals( menuHidden.getName() ) ) {
                        String s = casted_owner_item.getText();
                        int i = s.IndexOf( "(&" );
                        if ( i > 0 ) {
                            s = s.Substring( 0, i );
                        }
                        parent = s + " -> ";
                    }
                    String s1 = casted_menu.getText();
                    int i1 = s1.IndexOf( "(&" );
                    if ( i1 > 0 ) {
                        s1 = s1.Substring( 0, i1 );
                    }
                    dict.put( parent + s1, new ValuePair<String, BKeys[]>( name, configured.get( name ) ) );
                }
            }

            // 最初に戻る、のショートカットキー
            BKeys[] keysGoToFirst = AppManager.editorConfig.SpecialShortcutGoToFirst;
            if ( keysGoToFirst == null ) {
                keysGoToFirst = new BKeys[] { };
            }
            dict.put( _( "Go to the first" ), new ValuePair<String, BKeys[]>( "SpecialShortcutGoToFirst", keysGoToFirst ) );

            FormShortcutKeys form = null;
            try {
                form = new FormShortcutKeys( dict );
                form.setLocation( getFormPreferedLocation( form ) );
                form.setModal( true );
                form.setVisible( true );
                if ( form.getDialogResult() == BDialogResult.OK ) {
                    TreeMap<String, ValuePair<String, BKeys[]>> res = form.getResult();
                    for ( Iterator<String> itr = res.keySet().iterator(); itr.hasNext(); ) {
                        String display = itr.next();
                        String name = res.get( display ).getKey();
                        BKeys[] keys = res.get( display ).getValue();
                        boolean found = false;
                        if ( name.Equals( "SpecialShortcutGoToFirst" ) ) {
                            AppManager.editorConfig.SpecialShortcutGoToFirst = keys;
                        } else {
                            for ( int i = 0; i < AppManager.editorConfig.ShortcutKeys.size(); i++ ) {
                                if ( AppManager.editorConfig.ShortcutKeys.get( i ).Key.Equals( name ) ) {
                                    AppManager.editorConfig.ShortcutKeys.get( i ).Value = keys;
                                    found = true;
                                    break;
                                }
                            }
                            if ( !found ) {
                                AppManager.editorConfig.ShortcutKeys.add( new ValuePairOfStringArrayOfKeys( name, keys ) );
                            }
                        }
                    }
                    applyShortcut();
#if ENABLE_PROPERTY
                    AppManager.propertyWindow.setFormCloseShortcutKey( AppManager.editorConfig.getShortcutKeyFor( menuVisualProperty ) );
#endif
                }
            } catch ( Exception ex ) {
            } finally {
                if ( form != null ) {
                    try {
                        form.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        public void menuSettingGameControlerLoad_Click( Object sender, EventArgs e ) {
            loadGameControler();
        }

        public void menuSettingGameControlerRemove_Click( Object sender, EventArgs e ) {
            removeGameControler();
        }

        public void menuSettingGameControlerSetting_Click( Object sender, EventArgs e ) {
            FormGameControlerConfig dlg = null;
            try {
                dlg = new FormGameControlerConfig();
                dlg.setLocation( getFormPreferedLocation( dlg ) );
                dlg.setModal( true );
                dlg.setVisible( true );
                if ( dlg.getDialogResult() == BDialogResult.OK ) {
                    AppManager.editorConfig.GameControlerRectangle = dlg.getRectangle();
                    AppManager.editorConfig.GameControlerTriangle = dlg.getTriangle();
                    AppManager.editorConfig.GameControlerCircle = dlg.getCircle();
                    AppManager.editorConfig.GameControlerCross = dlg.getCross();
                    AppManager.editorConfig.GameControlL1 = dlg.getL1();
                    AppManager.editorConfig.GameControlL2 = dlg.getL2();
                    AppManager.editorConfig.GameControlR1 = dlg.getR1();
                    AppManager.editorConfig.GameControlR2 = dlg.getR2();
                    AppManager.editorConfig.GameControlSelect = dlg.getSelect();
                    AppManager.editorConfig.GameControlStart = dlg.getStart();
                    AppManager.editorConfig.GameControlPovDown = dlg.getPovDown();
                    AppManager.editorConfig.GameControlPovLeft = dlg.getPovLeft();
                    AppManager.editorConfig.GameControlPovUp = dlg.getPovUp();
                    AppManager.editorConfig.GameControlPovRight = dlg.getPovRight();
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }
        #endregion

        #region menuEdit*
        public void menuEditDelete_Click( Object sender, EventArgs e ) {
            deleteEvent();
        }

        public void commonEditPaste_Click( Object sender, EventArgs e ) {
            pasteEvent();
        }

        public void commonEditCopy_Click( Object sender, EventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "commonEditCopy_Click" );
#endif
            copyEvent();
        }

        public void commonEditCut_Click( Object sender, EventArgs e ) {
            cutEvent();
        }

        public void menuEdit_DropDownOpening( Object sender, EventArgs e ) {
            updateCopyAndPasteButtonStatus();
        }

        public void commonEditUndo_Click( Object sender, EventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "menuEditUndo_Click" );
#endif
            undo();
            refreshScreen();
        }


        public void commonEditRedo_Click( Object sender, EventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "menuEditRedo_Click" );
#endif
            redo();
            refreshScreen();
        }

        public void menuEditSelectAllEvents_Click( Object sender, EventArgs e ) {
            selectAllEvent();
        }

        public void menuEditSelectAll_Click( Object sender, EventArgs e ) {
            selectAll();
        }

        public void menuEditAutoNormalizeMode_Click( Object sender, EventArgs e ) {
            AppManager.autoNormalize = !AppManager.autoNormalize;
            menuEditAutoNormalizeMode.setSelected( AppManager.autoNormalize );
        }

        public void menuEditUndo_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Undo." ) );
        }

        public void menuEditRedo_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Redo." ) );
        }

        public void menuEditCut_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Cut selected items." ) );
        }

        public void menuEditCopy_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Copy selected items." ) );
        }

        public void menuEditPaste_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Paste copied items to current song position." ) );
        }

        public void menuEditDelete_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Delete selected items." ) );
        }

        public void menuEditAutoNormalizeMode_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Avoid automaticaly polyphonic editing." ) );
        }

        public void menuEditSelectAll_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Select all items and control curves of current track." ) );
        }

        public void menuEditSelectAllEvents_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Select all items of current track." ) );
        }
        #endregion

        #region menuLyric*
        public void menuLyricExpressionProperty_Click( Object sender, EventArgs e ) {
            editNoteExpressionProperty();
        }

        public void menuLyricPhonemeTransformation_Click( Object sender, EventArgs e ) {
            Vector<Integer> internal_ids = new Vector<Integer>();
            Vector<VsqID> ids = new Vector<VsqID>();
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );
            for ( Iterator<VsqEvent> itr = vsq_track.getNoteEventIterator(); itr.hasNext(); ) {
                VsqEvent item = itr.next();
                VsqID id = item.ID;
                if ( id.LyricHandle.L0.PhoneticSymbolProtected ) {
                    continue;
                }
                String phrase = id.LyricHandle.L0.Phrase;
                String symbolOld = id.LyricHandle.L0.getPhoneticSymbol();
                String symbolResult = symbolOld;
                SymbolTableEntry entry = SymbolTable.attatch( phrase );
                if ( entry == null ) {
                    continue;
                }
                symbolResult = entry.getSymbol();
                if ( symbolResult.Equals( symbolOld ) ) {
                    continue;
                }
                VsqID idNew = (VsqID)id.clone();
                idNew.LyricHandle.L0.setPhoneticSymbol( symbolResult );
                ids.add( idNew );
                internal_ids.add( item.InternalID );
            }
            if ( ids.size() <= 0 ) {
                return;
            }
            CadenciiCommand run = new CadenciiCommand(
                VsqCommand.generateCommandEventChangeIDContaintsRange(
                    selected,
                    PortUtil.convertIntArray( internal_ids.toArray( new Integer[] { } ) ),
                    ids.toArray( new VsqID[] { } ) ) );
            AppManager.register( vsq.executeCommand( run ) );
            setEdited( true );
        }

        public void menuLyricDictionary_Click( Object sender, EventArgs e ) {
            FormWordDictionary dlg = null;
            try {
                dlg = new FormWordDictionary();
                dlg.setLocation( getFormPreferedLocation( dlg ) );
                dlg.setModal( true );
                dlg.setVisible( true );
                if ( dlg.getDialogResult() == BDialogResult.OK ) {
                    Vector<ValuePair<String, Boolean>> result = dlg.getResult();
                    SymbolTable.changeOrder( result );
                }
            } catch ( Exception ex ) {
                PortUtil.stderr.println( "FormMain#menuLyricDictionary_Click; ex=" + ex );
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        public void menuLyricVibratoProperty_Click( Object sender, EventArgs e ) {
            editNoteVibratoProperty();
        }
        #endregion

        #region menuJob
        public void menuJobRealTime_Click( Object sender, EventArgs e ) {
            if ( !AppManager.isPlaying() ) {
                AppManager.addingEvent = null;
                AppManager.setEditMode( EditMode.REALTIME );
                AppManager.setPlaying( true );
                //menuJobRealTime.setText( _( "Stop Realtime Input" );
            } else {
                timer.stop();
                AppManager.setPlaying( false );
                AppManager.setEditMode( EditMode.NONE );
                //menuJobRealTime.setText( _( "Start Realtime Input" );
            }
        }

        public void menuJobReloadVsti_Click( Object sender, EventArgs e ) {
            //VSTiProxy.ReloadPlugin(); //todo: FormMain+menuJobReloadVsti_Click
        }

        public void menuJob_DropDownOpening( Object sender, EventArgs e ) {
            if ( AppManager.getSelectedEventCount() <= 1 ) {
                menuJobConnect.setEnabled( false );
            } else {
                // menuJobConnect(音符の結合)がEnableされるかどうかは、選択されている音符がピアノロール上で連続かどうかで決まる
                int[] list = new int[AppManager.getSelectedEventCount()];
                for ( int i = 0; i < AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEventCount(); i++ ) {
                    int count = -1;
                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry item = itr.next();
                        int key = item.original.InternalID;
                        count++;
                        if ( key == AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEvent( i ).InternalID ) {
                            list[count] = i;
                            break;
                        }
                    }
                }
                boolean changed = true;
                while ( changed ) {
                    changed = false;
                    for ( int i = 0; i < list.Length - 1; i++ ) {
                        if ( list[i] > list[i + 1] ) {
                            int b = list[i];
                            list[i] = list[i + 1];
                            list[i + 1] = b;
                            changed = true;
                        }
                    }
                }
                boolean continued = true;
                for ( int i = 0; i < list.Length - 1; i++ ) {
                    if ( list[i] + 1 != list[i + 1] ) {
                        continued = false;
                        break;
                    }
                }
                menuJobConnect.setEnabled( continued );
            }

            menuJobLyric.setEnabled( AppManager.getLastSelectedEvent() != null );
        }

        public void menuJobLyric_Click( Object sender, EventArgs e ) {
            importLyric();
        }

        public void menuJobConnect_Click( Object sender, EventArgs e ) {
            int count = AppManager.getSelectedEventCount();
            int[] clocks = new int[count];
            VsqID[] ids = new VsqID[count];
            int[] internalids = new int[count];
            int i = -1;
            for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                SelectedEventEntry item = itr.next();
                i++;
                clocks[i] = item.original.Clock;
                ids[i] = (VsqID)item.original.ID.clone();
                internalids[i] = item.original.InternalID;
            }
            boolean changed = true;
            while ( changed ) {
                changed = false;
                for ( int j = 0; j < clocks.Length - 1; j++ ) {
                    if ( clocks[j] > clocks[j + 1] ) {
                        int b = clocks[j];
                        clocks[j] = clocks[j + 1];
                        clocks[j + 1] = b;
                        VsqID a = ids[j];
                        ids[j] = ids[j + 1];
                        ids[j + 1] = a;
                        changed = true;
                        b = internalids[j];
                        internalids[j] = internalids[j + 1];
                        internalids[j + 1] = b;
                    }
                }
            }

            for ( int j = 0; j < ids.Length - 1; j++ ) {
                ids[j].setLength( clocks[j + 1] - clocks[j] );
            }
            CadenciiCommand run = new CadenciiCommand(
                VsqCommand.generateCommandEventChangeIDContaintsRange( AppManager.getSelected(), internalids, ids ) );
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
            setEdited( true );
            repaint();
        }

        public void menuJobInsertBar_Click( Object sender, EventArgs e ) {
            int total_clock = AppManager.getVsqFile().TotalClocks;
            int total_barcount = AppManager.getVsqFile().getBarCountFromClock( total_clock ) + 1;
            FormInsertBar dlg = null;
            try {
                dlg = new FormInsertBar( total_barcount );
                int current_clock = AppManager.getCurrentClock();
                int barcount = AppManager.getVsqFile().getBarCountFromClock( current_clock );
                int draft = barcount - AppManager.getVsqFile().getPreMeasure() + 1;
                if ( draft <= 0 ) {
                    draft = 1;
                }
                dlg.setPosition( draft );

                dlg.setLocation( getFormPreferedLocation( dlg ) );
                dlg.setModal( true );
                dlg.setVisible( true );
                if ( dlg.getDialogResult() == BDialogResult.OK ) {
                    int pos = dlg.getPosition() + AppManager.getVsqFile().getPreMeasure() - 1;
                    int length = dlg.getLength();

                    int clock_start = AppManager.getVsqFile().getClockFromBarCount( pos );
                    int clock_end = AppManager.getVsqFile().getClockFromBarCount( pos + length );
                    int dclock = clock_end - clock_start;
                    VsqFileEx temp = (VsqFileEx)AppManager.getVsqFile().clone();

                    for ( int track = 1; track < temp.Track.size(); track++ ) {
                        BezierCurves newbc = new BezierCurves();
                        foreach ( CurveType ct in Utility.CURVE_USAGE ) {
                            int index = ct.getIndex();
                            if ( index < 0 ) {
                                continue;
                            }

                            Vector<BezierChain> list = new Vector<BezierChain>();
                            for ( Iterator<BezierChain> itr = temp.AttachedCurves.get( track - 1 ).get( ct ).iterator(); itr.hasNext(); ) {
                                BezierChain bc = itr.next();
                                if ( bc.size() < 2 ) {
                                    continue;
                                }
                                int chain_start = (int)bc.points.get( 0 ).getBase().getX();
                                int chain_end = (int)bc.points.get( bc.points.size() - 1 ).getBase().getX();

                                if ( clock_start <= chain_start ) {
                                    for ( int i = 0; i < bc.points.size(); i++ ) {
                                        PointD t = bc.points.get( i ).getBase();
                                        bc.points.get( i ).setBase( new PointD( t.getX() + dclock, t.getY() ) );
                                    }
                                    list.add( bc );
                                } else if ( chain_start < clock_start && clock_start < chain_end ) {
                                    BezierChain adding1 = bc.extractPartialBezier( chain_start, clock_start );
                                    BezierChain adding2 = bc.extractPartialBezier( clock_start, chain_end );
                                    for ( int i = 0; i < adding2.points.size(); i++ ) {
                                        PointD t = adding2.points.get( i ).getBase();
                                        adding2.points.get( i ).setBase( new PointD( t.getX() + dclock, t.getY() ) );
                                    }
                                    adding1.points.get( adding1.points.size() - 1 ).setControlRightType( BezierControlType.None );
                                    adding2.points.get( 0 ).setControlLeftType( BezierControlType.None );
                                    for ( int i = 0; i < adding2.points.size(); i++ ) {
                                        adding1.points.add( adding2.points.get( i ) );
                                    }
                                    adding1.id = bc.id;
                                    list.add( adding1 );
                                } else {
                                    list.add( (BezierChain)bc.clone() );
                                }
                            }

                            newbc.set( ct, list );
                        }
                        temp.AttachedCurves.set( track - 1, newbc );
                    }

                    for ( int track = 1; track < AppManager.getVsqFile().Track.size(); track++ ) {
                        for ( int i = 0; i < temp.Track.get( track ).getEventCount(); i++ ) {
                            if ( temp.Track.get( track ).getEvent( i ).Clock >= clock_start ) {
                                temp.Track.get( track ).getEvent( i ).Clock += dclock;
                            }
                        }
                        foreach ( CurveType curve in Utility.CURVE_USAGE ) {
                            if ( curve.isScalar() || curve.isAttachNote() ) {
                                continue;
                            }
                            VsqBPList target = temp.Track.get( track ).getCurve( curve.getName() );
                            VsqBPList src = AppManager.getVsqFile().Track.get( track ).getCurve( curve.getName() );
                            target.clear();
                            for ( Iterator<Integer> itr = src.keyClockIterator(); itr.hasNext(); ) {
                                int key = itr.next();
                                if ( key >= clock_start ) {
                                    target.add( key + dclock, src.getValue( key ) );
                                } else {
                                    target.add( key, src.getValue( key ) );
                                }
                            }
                        }
                    }
                    for ( int i = 0; i < temp.TempoTable.size(); i++ ) {
                        if ( temp.TempoTable.get( i ).Clock >= clock_start ) {
                            temp.TempoTable.get( i ).Clock = temp.TempoTable.get( i ).Clock + dclock;
                        }
                    }
                    for ( int i = 0; i < temp.TimesigTable.size(); i++ ) {
                        if ( temp.TimesigTable.get( i ).Clock >= clock_start ) {
                            temp.TimesigTable.get( i ).Clock = temp.TimesigTable.get( i ).Clock + dclock;
                        }
                    }
                    temp.updateTempoInfo();
                    temp.updateTimesigInfo();

                    CadenciiCommand run = VsqFileEx.generateCommandReplace( temp );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    setEdited( true );
                    repaint();
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        public void menuJobDeleteBar_Click( Object sender, EventArgs e ) {
            int total_clock = AppManager.getVsqFile().TotalClocks;
            int total_barcount = AppManager.getVsqFile().getBarCountFromClock( total_clock ) + 1;
            int clock = AppManager.getCurrentClock();
            int barcount = AppManager.getVsqFile().getBarCountFromClock( clock );
            FormDeleteBar dlg = null;
            try {
                dlg = new FormDeleteBar( total_barcount );
                int draft = barcount - AppManager.getVsqFile().getPreMeasure() + 1;
                if ( draft <= 0 ) {
                    draft = 1;
                }
                dlg.setStart( draft );
                dlg.setEnd( draft + 1 );

                dlg.setLocation( getFormPreferedLocation( dlg ) );
                dlg.setModal( true );
                dlg.setVisible( true );
                if ( dlg.getDialogResult() == BDialogResult.OK ) {
                    VsqFileEx temp = (VsqFileEx)AppManager.getVsqFile().clone();
                    int start = dlg.getStart() + AppManager.getVsqFile().getPreMeasure() - 1;
                    int end = dlg.getEnd() + AppManager.getVsqFile().getPreMeasure() - 1;
#if DEBUG
                    AppManager.debugWriteLine( "FormMain+menuJobDeleteBar_Click" );
                    AppManager.debugWriteLine( "    start,end=" + start + "," + end );
#endif
                    int clock_start = temp.getClockFromBarCount( start );
                    int clock_end = temp.getClockFromBarCount( end );
                    int dclock = clock_end - clock_start;
                    for ( int track = 1; track < temp.Track.size(); track++ ) {
                        BezierCurves newbc = new BezierCurves();
                        for ( int j = 0; j < Utility.CURVE_USAGE.Length; j++ ) {
                            CurveType ct = Utility.CURVE_USAGE[j];
                            int index = ct.getIndex();
                            if ( index < 0 ) {
                                continue;
                            }

                            Vector<BezierChain> list = new Vector<BezierChain>();
                            for ( Iterator<BezierChain> itr = temp.AttachedCurves.get( track - 1 ).get( ct ).iterator(); itr.hasNext(); ) {
                                BezierChain bc = itr.next();
                                if ( bc.size() < 2 ) {
                                    continue;
                                }
                                int chain_start = (int)bc.points.get( 0 ).getBase().getX();
                                int chain_end = (int)bc.points.get( bc.points.size() - 1 ).getBase().getX();

                                if ( clock_start < chain_start && chain_start < clock_end && clock_end < chain_end ) {
                                    BezierChain adding = bc.extractPartialBezier( clock_end, chain_end );
                                    adding.id = bc.id;
                                    for ( int i = 0; i < adding.points.size(); i++ ) {
                                        PointD t = adding.points.get( i ).getBase();
                                        adding.points.get( i ).setBase( new PointD( t.getX() - dclock, t.getY() ) );
                                    }
                                    list.add( adding );
                                } else if ( chain_start < clock_start && clock_end < chain_end ) {
                                    BezierChain adding1 = bc.extractPartialBezier( chain_start, clock_start );
                                    adding1.id = bc.id;
                                    adding1.points.get( adding1.points.size() - 1 ).setControlRightType( BezierControlType.None );
                                    BezierChain adding2 = bc.extractPartialBezier( clock_end, chain_end );
                                    adding2.points.get( 0 ).setControlLeftType( BezierControlType.None );
                                    PointD t = adding2.points.get( 0 ).getBase();
                                    adding2.points.get( 0 ).setBase( new PointD( t.getX() - dclock, t.getY() ) );
                                    adding1.points.add( adding2.points.get( 0 ) );
                                    for ( int i = 1; i < adding2.points.size(); i++ ) {
                                        t = adding2.points.get( i ).getBase();
                                        adding2.points.get( i ).setBase( new PointD( t.getX() - dclock, t.getY() ) );
                                        adding1.points.add( adding2.points.get( i ) );
                                    }
                                    list.add( adding1 );
                                } else if ( chain_start < clock_start && clock_start < chain_end && chain_end < clock_end ) {
                                    BezierChain adding = bc.extractPartialBezier( chain_start, clock_start );
                                    adding.id = bc.id;
                                    list.add( adding );
                                } else if ( clock_end <= chain_start || chain_end <= clock_start ) {
                                    if ( clock_end <= chain_start ) {
                                        for ( int i = 0; i < bc.points.size(); i++ ) {
                                            PointD t = bc.points.get( i ).getBase();
                                            bc.points.get( i ).setBase( new PointD( t.getX() - dclock, t.getY() ) );
                                        }
                                    }
                                    list.add( (BezierChain)bc.clone() );
                                }
                            }

                            newbc.set( ct, list );
                        }
                        temp.AttachedCurves.set( track - 1, newbc );
                    }

                    temp.removePart( clock_start, clock_end );
                    CadenciiCommand run = VsqFileEx.generateCommandReplace( temp );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    setEdited( true );
                    repaint();
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        public void menuJobNormalize_Click( Object sender, EventArgs e ) {
            VsqFile work = (VsqFile)AppManager.getVsqFile().clone();
            int track = AppManager.getSelected();
            boolean changed = true;
            boolean total_changed = false;

            // 最初、開始時刻が同じになっている奴を削除
            while ( changed ) {
                changed = false;
                for ( int i = 0; i < work.Track.get( track ).getEventCount() - 1; i++ ) {
                    int clock = work.Track.get( track ).getEvent( i ).Clock;
                    int id = work.Track.get( track ).getEvent( i ).InternalID;
                    for ( int j = i + 1; j < work.Track.get( track ).getEventCount(); j++ ) {
                        if ( clock == work.Track.get( track ).getEvent( j ).Clock ) {
                            if ( id < work.Track.get( track ).getEvent( j ).InternalID ) { //内部IDが小さい＝より高年齢（音符追加時刻が古い）
                                work.Track.get( track ).removeEvent( i );
                            } else {
                                work.Track.get( track ).removeEvent( j );
                            }
                            changed = true;
                            total_changed = true;
                            break;
                        }
                    }
                    if ( changed ) {
                        break;
                    }
                }
            }

            changed = true;
            while ( changed ) {
                changed = false;
                for ( int i = 0; i < work.Track.get( track ).getEventCount() - 1; i++ ) {
                    int start_clock = work.Track.get( track ).getEvent( i ).Clock;
                    int end_clock = work.Track.get( track ).getEvent( i ).ID.getLength() + start_clock;
                    for ( int j = i + 1; j < work.Track.get( track ).getEventCount(); j++ ) {
                        int this_start_clock = work.Track.get( track ).getEvent( j ).Clock;
                        if ( this_start_clock < end_clock ) {
                            work.Track.get( track ).getEvent( i ).ID.setLength( this_start_clock - start_clock );
                            changed = true;
                            total_changed = true;
                        }
                    }
                }
            }

            if ( total_changed ) {
                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandReplace( work ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                refreshScreen();
            }
        }

        public void menuJobNormalize_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Correct overlapped item." ) );
        }

        public void menuJobInsertBar_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Insert bar." ) );
        }

        public void menuJobDeleteBar_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Delete bar." ) );
        }

        public void menuJobRandomize_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Randomize items." ) + _( "(not implemented)" ) );
        }

        public void menuJobRandomize_Click( Object sender, EventArgs e ) {
            FormRandomize dlg = null;
            try {
                dlg = new FormRandomize();
                dlg.setLocation( getFormPreferedLocation( dlg ) );
                dlg.setModal( true );
                dlg.setVisible( true );
                if ( dlg.getDialogResult() == BDialogResult.OK ) {
                    VsqFileEx vsq = AppManager.getVsqFile();
                    int preMeasure = vsq.getPreMeasure();
                    int startBar = dlg.getStartBar() + (preMeasure - 1);
                    int startBeat = dlg.getStartBeat() - 1;
                    int endBar = dlg.getEndBar() + (preMeasure - 1);
                    int endBeat = dlg.getEndBeat();
                    int startBarClock = vsq.getClockFromBarCount( startBar );
                    int endBarClock = vsq.getClockFromBarCount( endBar );
                    Timesig startTimesig = vsq.getTimesigAt( startBarClock );
                    Timesig endTimesig = vsq.getTimesigAt( endBarClock );
                    int startClock = startBarClock + startBeat * 480 * 4 / startTimesig.denominator;
                    int endClock = endBarClock + endBeat * 480 * 4 / endTimesig.denominator;

                    int selected = AppManager.getSelected();
                    VsqTrack vsq_track = vsq.Track.get( selected );
                    VsqTrack work = (VsqTrack)vsq_track.clone();
                    Random r = new Random();

                    // 音符位置のシフト
                    #region 音符位置のシフト
                    if ( dlg.isPositionRandomizeEnabled() ) {
                        int[] sigmaPreset = new int[] { 10, 20, 30, 60, 120 };
                        int sigma = sigmaPreset[dlg.getPositionRandomizeValue() - 1]; // 標準偏差

                        int count = work.getEventCount(); // イベントの個数
                        int lastItemIndex = -1;  // 直前に処理した音符イベントのインデクス
                        int thisItemIndex = -1;  // 処理中の音符イベントのインデクス
                        int nextItemIndex = -1;  // 処理中の音符イベントの次の音符イベントのインデクス
                        double sqrt2 = Math.Sqrt( 2.0 );
                        int clockPreMeasure = vsq.getPreMeasureClocks(); // プリメジャーいちでのゲートタイム
                        
                        while ( true ) {
                            // nextItemIndexを決定
                            if ( nextItemIndex != -2 ) {
                                int start = nextItemIndex + 1;
                                nextItemIndex = -2;  // -2は、トラックの最後まで走査し終わった、という意味
                                for ( int i = start; i < count; i++ ) {
                                    if ( work.getEvent( i ).ID.type == VsqIDType.Anote ) {
                                        nextItemIndex = i;
                                        break;
                                    }
                                }
                            }

                            if ( thisItemIndex >= 0 ) {
                                // ここにメインの処理
                                VsqEvent lastItem = lastItemIndex >= 0 ? work.getEvent( lastItemIndex ) : null;
                                VsqEvent thisItem = work.getEvent( thisItemIndex );
                                VsqEvent nextItem = nextItemIndex >= 0 ? work.getEvent( nextItemIndex ) : null;
                                int lastItemClock = lastItem == null ? 0 : lastItem.Clock;
                                int lastItemLength = lastItem == null ? 0 : lastItem.ID.getLength();

                                int clock = thisItem.Clock;
                                int length = thisItem.ID.getLength();
                                if ( startClock <= thisItem.Clock && thisItem.Clock + thisItem.ID.getLength() <= endClock ) {
                                    int draftClock = 0;
                                    int draftLength = 0;
                                    int draftLastItemLength = lastItemLength;
                                    // 音符のめり込み等のチェックをクリアするまで、draft(Clock|Length|LastItemLength)をトライ＆エラーで決定する
                                    while ( true ) {
                                        int x = 3 * sigma;
                                        while ( Math.Abs( x ) > 2 * sigma ) {
#if JAVA
                                            double d = r.nextDouble();
#else
                                            double d = r.NextDouble();
#endif
                                            double y = (d - 0.5) * 2.0;
                                            x = (int)(sigma * sqrt2 * math.erfinv( y ));
                                        }
                                        draftClock = clock + x;
                                        draftLength = clock + length - draftClock;
                                        if ( lastItem != null ) {
                                            if ( clock == lastItemClock + lastItemLength ) {
                                                // 音符が連続していた場合
                                                draftLastItemLength = lastItem.ID.getLength() + x;
                                            }
                                        }
                                        // 音符がめり込んだりしてないかどうかをチェック
                                        if ( draftClock < clockPreMeasure ) {
                                            continue;
                                        }
                                        if ( lastItem != null ) {
                                            if ( clock != lastItemClock + lastItemLength ) {
                                                // 音符が連続していなかった場合に、直前の音符にめり込んでいないかどうか
                                                if ( draftClock + draftLength < lastItem.Clock + lastItem.ID.getLength() ) {
                                                    continue;
                                                }
                                            }
                                        }
                                        // チェックにクリアしたのでループを抜ける
                                        break;
                                    }
                                    // draft*の値を適用
                                    thisItem.Clock = draftClock;
                                    thisItem.ID.setLength( draftLength );
                                    if ( lastItem != null ) {
                                        lastItem.ID.setLength( draftLastItemLength );
                                    }
                                } else if ( endClock < thisItem.Clock ) {
                                    break;
                                }
                            }

                            // インデクスを移す
                            lastItemIndex = thisItemIndex;
                            thisItemIndex = nextItemIndex;

                            if ( lastItemIndex == -2 && thisItemIndex == -2 && nextItemIndex == -2 ) {
                                // トラックの最後まで走査し終わったので抜ける
                                break;
                            }
                        }
                    }
                    #endregion

                    // ピッチベンドのランダマイズ
                    #region ピッチベンドのランダマイズ
                    if ( dlg.isPitRandomizeEnabled() ) {
                        int pattern = dlg.getPitRandomizePattern();
                        int value = dlg.getPitRandomizeValue();
                        double order = 1.0 / Math.Pow( 2.0, 5.0 - value );
                        int[] patternPreset = pattern == 1 ? Utility.getRandomizePitPattern1() : pattern == 2 ? Utility.getRandomizePitPattern2() : Utility.getRandomizePitPattern3();
                        int resolution = dlg.getResolution();
                        VsqBPList pit = work.getCurve( "pit" );
                        VsqBPList pbs = work.getCurve( "pbs" );
                        int pbsAtStart = pbs.getValue( startClock );
                        int pbsAtEnd = pbs.getValue( endClock );

                        // startClockからendClock - 1までのpit, pbsをクリアする
                        int count = pit.size();
                        for ( int i = count - 1; i >= 0; i-- ) {
                            int keyClock = pit.getKeyClock( i );
                            if ( startClock <= keyClock && keyClock < endClock ) {
                                pit.removeElementAt( i );
                            }
                        }
                        count = pbs.size();
                        for ( int i = count - 1; i >= 0; i-- ) {
                            int keyClock = pbs.getKeyClock( i );
                            if ( startClock <= keyClock && keyClock < endClock ) {
                                pbs.removeElementAt( i );
                            }
                        }

                        // pbsをデフォルト値にする
                        if ( pbsAtStart != 2 ) {
                            pbs.add( startClock, 2 );
                        }
                        if ( pbsAtEnd != 2 ) {
                            pbs.add( endClock, pbsAtEnd );
                        }

                        StringBuilder sb = new StringBuilder();
                        count = pit.size();
                        boolean first = true;
                        for ( int i = 0; i < count; i++ ) {
                            int clock = pit.getKeyClock( i );
                            if ( clock < startClock ) {
                                int v = pit.getElementA( i );
#if JAVA
                                sb.append( (first ? "" : ",") + (clock + "=" + v) );
#else
                                sb.Append( (first ? "" : ",") + (clock + "=" + v) );
#endif
                                first = false;
                            } else if ( clock <= endClock ) {
                                break;
                            }
                        }
#if JAVA
                        double d = r.nextDouble();
#else
                        double d = r.NextDouble();
#endif
                        int start = (int)(d * (patternPreset.Length - 1));
                        for ( int clock = startClock; clock < endClock; clock += resolution ) {
                            int copyIndex = start + (clock - startClock);
                            int odd = copyIndex / patternPreset.Length;
                            copyIndex = copyIndex - patternPreset.Length * odd;
                            int v = (int)(patternPreset[copyIndex] * order);
#if JAVA
                            sb.append( (first ? "" : ",") + (clock + "=" + v) );
#else
                            sb.Append( (first ? "" : ",") + (clock + "=" + v) );
#endif
                            first = false;
                            //pit.add( clock, v );
                        }
                        for ( int i = 0; i < count; i++ ) {
                            int clock = pit.getKeyClock( i );
                            if ( endClock <= clock ) {
                                int v = pit.getElementA( i );
#if JAVA
                                sb.append( (first ? "" : ",") + (clock + "=" + v) );
#else
                                sb.Append( (first ? "" : ",") + (clock + "=" + v) );
#endif
                                first = false;
                            }
                        }
                        pit.setData( sb.ToString() );
                    }
                    #endregion

                    CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( selected, work, vsq.AttachedCurves.get( selected - 1 ) );
                    AppManager.register( vsq.executeCommand( run ) );
                    setEdited( true );
                }
            } catch ( Exception ex ) {
                PortUtil.stderr.println( "FormMain#menuJobRandomize_Click; ex=" + ex );
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                        PortUtil.stderr.println( "FormMain#menuJobRandomize; ex2=" + ex2 );
                    }
                }
            }
        }

        public void menuJobConnect_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Lengthen note end to neighboring note." ) );
        }

        public void menuJobLyric_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Import lyric." ) );
        }

        public void menuJobRewire_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Import tempo from ReWire host." ) + _( "(not implemented)" ) );
        }

        public void menuJobRealTime_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Start realtime input." ) );
        }

        public void menuJobReloadVsti_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Reload VSTi dll." ) + _( "(not implemented)" ) );
        }
        #endregion

        #region menuScript
        public void menuScriptUpdate_Click( Object sender, EventArgs e ) {
#if ENABLE_SCRIPT
            updateScriptShortcut();
            applyShortcut();
#endif
        }
        #endregion

        #region vScroll
        public void vScroll_Enter( Object sender, EventArgs e ) {
            pictPianoRoll.requestFocus();
        }

        public void vScroll_Resize( Object sender, EventArgs e ) {
            AppManager.setStartToDrawY( calculateStartToDrawY() );
            setVScrollRange( vScroll.getMaximum() );
        }

        public void vScroll_ValueChanged( Object sender, EventArgs e ) {
            AppManager.setStartToDrawY( calculateStartToDrawY() );
            if ( m_txtbox_track_name != null ) {
#if !JAVA
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
#endif
                m_txtbox_track_name = null;
            }
            refreshScreen();
        }
        #endregion

        #region hScroll
        public void hScroll_Enter( Object sender, EventArgs e ) {
            pictPianoRoll.requestFocus();
        }

        public void hScroll_Resize( Object sender, EventArgs e ) {
            if ( getExtendedState() != BForm.ICONIFIED ) {
                int length = AppManager.getVsqFile().TotalClocks;
#if DEBUG
                PortUtil.println( "FormMain#hScroll_Resize; total_clocks=" + length );
#endif
                setHScrollRange( length );
            }
        }

        public void hScroll_ValueChanged( Object sender, EventArgs e ) {
            AppManager.setStartToDrawX( calculateStartToDrawX() );
            if ( m_txtbox_track_name != null ) {
#if !JAVA
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
#endif
                m_txtbox_track_name = null;
            }
            refreshScreen();
        }
        #endregion

        private int calculateStartToDrawX() {
            return (int)(hScroll.getValue() * AppManager.getScaleX());
        }

        #region picturePositionIndicator
        public void picturePositionIndicator_MouseWheel( Object sender, BMouseEventArgs e ) {
            hScroll.setValue( computeScrollValueFromWheelDelta( e.Delta ) );
        }

        public void picturePositionIndicator_MouseDoubleClick( Object sender, BMouseEventArgs e ) {
            if ( e.X < AppManager.keyWidth || getWidth() - 3 < e.X ) {
                return;
            }
            if ( e.Button == BMouseButtons.Left ) {
                VsqFileEx vsq = AppManager.getVsqFile();
                if ( 18 < e.Y && e.Y <= 32 ) {
                    #region テンポの変更
#if DEBUG
                    AppManager.debugWriteLine( "TempoChange" );
#endif
                    AppManager.clearSelectedEvent();
                    AppManager.clearSelectedTimesig();

                    if ( AppManager.getSelectedTempoCount() > 0 ) {
                        #region テンポ変更があった場合
                        int index = -1;
                        int clock = AppManager.getLastSelectedTempoClock();
                        for ( int i = 0; i < vsq.TempoTable.size(); i++ ) {
                            if ( clock == vsq.TempoTable.get( i ).Clock ) {
                                index = i;
                                break;
                            }
                        }
                        if ( index >= 0 ) {
                            if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                                #region ツールがEraser
                                if ( vsq.TempoTable.get( index ).Clock == 0 ) {
                                    statusLabel.setText( _( "Cannot remove first symbol of track!" ) );
#if !JAVA
                                    SystemSounds.Asterisk.Play();
#endif
                                    return;
                                }
                                CadenciiCommand run = new CadenciiCommand(
                                    VsqCommand.generateCommandUpdateTempo( vsq.TempoTable.get( index ).Clock,
                                                                           vsq.TempoTable.get( index ).Clock,
                                                                           -1 ) );
                                AppManager.register( vsq.executeCommand( run ) );
                                setEdited( true );
                                #endregion
                            } else {
                                #region ツールがEraser以外
                                TempoTableEntry tte = vsq.TempoTable.get( index );
                                AppManager.clearSelectedTempo();
                                AppManager.addSelectedTempo( tte.Clock );
                                int bar_count = vsq.getBarCountFromClock( tte.Clock );
                                int bar_top_clock = vsq.getClockFromBarCount( bar_count );
                                //int local_denominator, local_numerator;
                                Timesig timesig = vsq.getTimesigAt( tte.Clock );
                                int clock_per_beat = 480 * 4 / timesig.denominator;
                                int clocks_in_bar = tte.Clock - bar_top_clock;
                                int beat_in_bar = clocks_in_bar / clock_per_beat + 1;
                                int clocks_in_beat = clocks_in_bar - (beat_in_bar - 1) * clock_per_beat;
                                FormTempoConfig dlg = null;
                                try {
                                    dlg = new FormTempoConfig( bar_count, beat_in_bar, timesig.numerator, clocks_in_beat, clock_per_beat, (float)(6e7 / tte.Tempo), AppManager.getVsqFile().getPreMeasure() );
                                    dlg.setLocation( getFormPreferedLocation( dlg ) );
                                    dlg.setModal( true );
                                    dlg.setVisible( true );
                                    if ( dlg.getDialogResult() == BDialogResult.OK ) {
                                        int new_beat = dlg.getBeatCount();
                                        int new_clocks_in_beat = dlg.getClock();
                                        int new_clock = bar_top_clock + (new_beat - 1) * clock_per_beat + new_clocks_in_beat;
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTempo( new_clock, new_clock, (int)(6e7 / (double)dlg.getTempo()) ) );
                                        AppManager.register( vsq.executeCommand( run ) );
                                        setEdited( true );
                                        refreshScreen();
                                    }
                                } catch ( Exception ex ) {
                                    PortUtil.stderr.println( "FormMain#picturePositionIndicator_MouseDoubleClick; ex=" + ex );
                                } finally {
                                    if ( dlg != null ) {
                                        try {
                                            dlg.close();
                                        } catch ( Exception ex2 ) {
                                            PortUtil.stderr.println( "FormMain#picturePositionIndicator_MouseDoubleClick; ex2=" + ex2 );
                                        }
                                    }
                                }
                                #endregion
                            }
                        }
                        #endregion
                    } else {
                        #region テンポ変更がなかった場合
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        AppManager.clearSelectedTimesig();
                        EditTool selected = AppManager.getSelectedTool();
                        if ( selected == EditTool.PENCIL ||
                            selected == EditTool.LINE ) {
                            int changing_clock = AppManager.clockFromXCoord( e.X );
                            int changing_tempo = vsq.getTempoAt( changing_clock );
                            int bar_count;
                            int bar_top_clock;
                            int local_denominator, local_numerator;
                            bar_count = vsq.getBarCountFromClock( changing_clock );
                            bar_top_clock = vsq.getClockFromBarCount( bar_count );
                            int index2 = -1;
                            for ( int i = 0; i < vsq.TimesigTable.size(); i++ ) {
                                if ( vsq.TimesigTable.get( i ).BarCount > bar_count ) {
                                    index2 = i;
                                    break;
                                }
                            }
                            if ( index2 >= 1 ) {
                                local_denominator = vsq.TimesigTable.get( index2 - 1 ).Denominator;
                                local_numerator = vsq.TimesigTable.get( index2 - 1 ).Numerator;
                            } else {
                                local_denominator = vsq.TimesigTable.get( 0 ).Denominator;
                                local_numerator = vsq.TimesigTable.get( 0 ).Numerator;
                            }
                            int clock_per_beat = 480 * 4 / local_denominator;
                            int clocks_in_bar = changing_clock - bar_top_clock;
                            int beat_in_bar = clocks_in_bar / clock_per_beat + 1;
                            int clocks_in_beat = clocks_in_bar - (beat_in_bar - 1) * clock_per_beat;
                            FormTempoConfig dlg = null;
                            try {
                                dlg = new FormTempoConfig( bar_count - vsq.getPreMeasure() + 1,
                                                           beat_in_bar,
                                                           local_numerator,
                                                           clocks_in_beat,
                                                           clock_per_beat,
                                                           (float)(6e7 / changing_tempo),
                                                           vsq.getPreMeasure() );
                                dlg.setLocation( getFormPreferedLocation( dlg ) );
                                dlg.setModal( true );
                                dlg.setVisible( true );
                                if ( dlg.getDialogResult() == BDialogResult.OK ) {
                                    int new_beat = dlg.getBeatCount();
                                    int new_clocks_in_beat = dlg.getClock();
                                    int new_clock = bar_top_clock + (new_beat - 1) * clock_per_beat + new_clocks_in_beat;
#if DEBUG
                                    AppManager.debugWriteLine( "    new_beat=" + new_beat );
                                    AppManager.debugWriteLine( "    new_clocks_in_beat=" + new_clocks_in_beat );
                                    AppManager.debugWriteLine( "    changing_clock=" + changing_clock );
                                    AppManager.debugWriteLine( "    new_clock=" + new_clock );
#endif
                                    CadenciiCommand run = new CadenciiCommand(
                                        VsqCommand.generateCommandUpdateTempo( new_clock, new_clock, (int)(6e7 / (double)dlg.getTempo()) ) );
                                    AppManager.register( vsq.executeCommand( run ) );
                                    setEdited( true );
                                    refreshScreen();
                                }
                            } catch ( Exception ex ) {
                            } finally {
                                if ( dlg != null ) {
                                    try {
                                        dlg.close();
                                    } catch ( Exception ex2 ) {
                                    }
                                }
                            }
                        }
                        #endregion
                    }
                    m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
                    #endregion
                } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.getHeight() - 1 ) {
                    #region 拍子の変更
                    AppManager.clearSelectedEvent();
                    AppManager.clearSelectedTempo();
                    if ( AppManager.getSelectedTimesigCount() > 0 ) {
                        #region 拍子変更があった場合
                        int index = 0;
                        int last_barcount = AppManager.getLastSelectedTimesigBarcount();
                        for ( int i = 0; i < vsq.TimesigTable.size(); i++ ) {
                            if ( vsq.TimesigTable.get( i ).BarCount == last_barcount ) {
                                index = i;
                                break;
                            }
                        }
                        if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                            #region ツールがEraser
                            if ( vsq.TimesigTable.get( index ).Clock == 0 ) {
                                statusLabel.setText( _( "Cannot remove first symbol of track!" ) );
#if !JAVA
                                SystemSounds.Asterisk.Play();
#endif
                                return;
                            }
                            int barcount = vsq.TimesigTable.get( index ).BarCount;
                            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTimesig( barcount, barcount, -1, -1 ) );
                            AppManager.register( vsq.executeCommand( run ) );
                            setEdited( true );
                            #endregion
                        } else {
                            #region ツールがEraser以外
                            int pre_measure = vsq.getPreMeasure();
                            int clock = AppManager.clockFromXCoord( e.X );
                            int bar_count = vsq.getBarCountFromClock( clock );
                            int total_clock = vsq.TotalClocks;
                            Timesig timesig = vsq.getTimesigAt( clock );
                            boolean num_enabled = !(bar_count == 0);
                            FormBeatConfig dlg = null;
                            try {
                                dlg = new FormBeatConfig( bar_count - pre_measure + 1, timesig.numerator, timesig.denominator, num_enabled, pre_measure );
                                dlg.setLocation( getFormPreferedLocation( dlg ) );
                                dlg.setModal( true );
                                dlg.setVisible( true );
                                if ( dlg.getDialogResult() == BDialogResult.OK ) {
                                    if ( dlg.isEndSpecified() ) {
                                        int[] new_barcounts = new int[2];
                                        int[] numerators = new int[2];
                                        int[] denominators = new int[2];
                                        int[] barcounts = new int[2];
                                        new_barcounts[0] = dlg.getStart() + pre_measure - 1;
                                        new_barcounts[1] = dlg.getEnd() + pre_measure - 1;
                                        numerators[0] = dlg.getNumerator();
                                        denominators[0] = dlg.getDenominator();
                                        numerators[1] = timesig.numerator;
                                        denominators[1] = timesig.denominator;
                                        barcounts[0] = bar_count;
                                        barcounts[1] = dlg.getEnd() + pre_measure - 1;
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                                        AppManager.register( vsq.executeCommand( run ) );
                                        setEdited( true );
                                    } else {
#if DEBUG
                                        PortUtil.println( "picturePositionIndicator_MouseDoubleClick" );
                                        PortUtil.println( "    bar_count=" + bar_count );
                                        PortUtil.println( "    dlg.Start+pre_measure-1=" + (dlg.getStart() + pre_measure - 1) );
#endif
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTimesig( bar_count, 
                                                                                     dlg.getStart() + pre_measure - 1,
                                                                                     dlg.getNumerator(),
                                                                                     dlg.getDenominator() ) );
                                        AppManager.register( vsq.executeCommand( run ) );
                                        setEdited( true );
                                    }
                                }
                            } catch ( Exception ex ) {
                                PortUtil.stderr.println( "FormMain#picturePositionIndicator_MouseDoubleClick; ex=" + ex );
                            } finally {
                                if ( dlg != null ) {
                                    try {
                                        dlg.close();
                                    } catch ( Exception ex2 ) {
                                        PortUtil.stderr.println( "FormMain#picturePositionIndicator_MouseDoubleClic; ex2=" + ex2 );
                                    }
                                }
                            }
                            #endregion
                        }
                        #endregion
                    } else {
                        #region 拍子変更がなかった場合
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        AppManager.clearSelectedTimesig();
                        EditTool selected = AppManager.getSelectedTool();
                        if ( selected == EditTool.PENCIL ||
                            selected == EditTool.LINE ) {
                            int pre_measure = AppManager.getVsqFile().getPreMeasure();
                            int clock = AppManager.clockFromXCoord( e.X );
                            int bar_count = AppManager.getVsqFile().getBarCountFromClock( clock );
                            int numerator, denominator;
                            Timesig timesig = AppManager.getVsqFile().getTimesigAt( clock );
                            int total_clock = AppManager.getVsqFile().TotalClocks;
                            //int max_barcount = AppManager.VsqFile.getBarCountFromClock( total_clock ) - pre_measure + 1;
                            //int min_barcount = 1;
#if DEBUG
                            AppManager.debugWriteLine( "FormMain.picturePositionIndicator_MouseClick; bar_count=" + (bar_count - pre_measure + 1) );
#endif
                            FormBeatConfig dlg = null;
                            try {
                                dlg = new FormBeatConfig( bar_count - pre_measure + 1, timesig.numerator, timesig.denominator, true, pre_measure );
                                dlg.setLocation( getFormPreferedLocation( dlg ) );
                                dlg.setModal( true );
                                dlg.setVisible( true );
                                if ( dlg.getDialogResult() == BDialogResult.OK ) {
                                    if ( dlg.isEndSpecified() ) {
                                        int[] new_barcounts = new int[2];
                                        int[] numerators = new int[2];
                                        int[] denominators = new int[2];
                                        int[] barcounts = new int[2];
                                        new_barcounts[0] = dlg.getStart() + pre_measure - 1;
                                        new_barcounts[1] = dlg.getEnd() + pre_measure - 1 + 1;
                                        numerators[0] = dlg.getNumerator();
                                        numerators[1] = timesig.numerator;

                                        denominators[0] = dlg.getDenominator();
                                        denominators[1] = timesig.denominator;

                                        barcounts[0] = dlg.getStart() + pre_measure - 1;
                                        barcounts[1] = dlg.getEnd() + pre_measure - 1 + 1;
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                        setEdited( true );
                                    } else {
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTimesig( bar_count,
                                                                           dlg.getStart() + pre_measure - 1,
                                                                           dlg.getNumerator(),
                                                                           dlg.getDenominator() ) );
                                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                        setEdited( true );
                                    }
                                }
                            } catch ( Exception ex ) {
                            } finally {
                                if ( dlg != null ) {
                                    try {
                                        dlg.close();
                                    } catch ( Exception ex2 ) {
                                    }
                                }
                            }
                        }
                        #endregion
                    }
                    m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
                    #endregion
                }
                picturePositionIndicator.repaint();
                pictPianoRoll.repaint();
            }
        }

        public void picturePositionIndicator_MouseDown( Object sender, BMouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
#if !JAVA
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
#endif
                m_txtbox_track_name = null;
            }

            if ( e.X < AppManager.keyWidth || getWidth() - 3 < e.X ) {
                return;
            }

            m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
            int modifiers = PortUtil.getCurrentModifierKey();
            if ( e.Button == BMouseButtons.Left ) {
                if ( 0 <= e.Y && e.Y <= 18 ) {
                    #region スタート/エンドマーク
                    if ( AppManager.startMarkerEnabled ) {
                        int startx = AppManager.xCoordFromClocks( AppManager.startMarker ) - AppManager.editorConfig.PxTolerance;
                        int marker_width = Resources.get_start_marker().getWidth( this );
                        if ( startx <= e.X && e.X <= startx + AppManager.editorConfig.PxTolerance * 2 + marker_width ) {
                            m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.MARK_START;
                        }
                    }
                    if ( AppManager.endMarkerEnabled && m_position_indicator_mouse_down_mode != PositionIndicatorMouseDownMode.MARK_START ) {
                        int marker_width = Resources.get_end_marker().getWidth( this );
                        int endx = AppManager.xCoordFromClocks( AppManager.endMarker ) - marker_width - AppManager.editorConfig.PxTolerance;
                        if ( endx <= e.X && e.X <= endx + AppManager.editorConfig.PxTolerance * 2 + marker_width ) {
                            m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.MARK_END;
                        }
                    }
                    #endregion
                } else if ( 18 < e.Y && e.Y <= 32 ) {
                    #region テンポ
                    int index = -1;
                    int count = AppManager.getVsqFile().TempoTable.size();
                    for ( int i = 0; i < count; i++ ) {
                        int clock = AppManager.getVsqFile().TempoTable.get( i ).Clock;
                        int x = AppManager.xCoordFromClocks( clock );
                        if ( x < 0 ) {
                            continue;
                        } else if ( getWidth() < x ) {
                            break;
                        }
                        String s = PortUtil.formatDecimal( "#.00", 60e6 / (float)AppManager.getVsqFile().TempoTable.get( i ).Tempo );
                        Dimension size = Util.measureString( s, new Font( AppManager.editorConfig.ScreenFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE8 ) );
                        if ( isInRect( new Point( e.X, e.Y ), new Rectangle( x, 14, (int)size.width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index >= 0 ) {
                        int clock = AppManager.getVsqFile().TempoTable.get( index ).Clock;
                        if ( AppManager.getSelectedTool() != EditTool.ERASER ) {
                            int mouse_clock = AppManager.clockFromXCoord( e.X );
                            m_tempo_dragging_deltaclock = mouse_clock - clock;
                            m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.TEMPO;
                        }
                        if ( (modifiers & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK ) {
                            if ( AppManager.getSelectedTempoCount() > 0 ) {
                                int last_clock = AppManager.getLastSelectedTempoClock();
                                int start = Math.Min( last_clock, clock );
                                int end = Math.Max( last_clock, clock );
                                for ( int i = 0; i < AppManager.getVsqFile().TempoTable.size(); i++ ) {
                                    int tclock = AppManager.getVsqFile().TempoTable.get( i ).Clock;
                                    if ( tclock < start ) {
                                        continue;
                                    } else if ( end < tclock ) {
                                        break;
                                    }
                                    if ( start <= tclock && tclock <= end ) {
                                        AppManager.addSelectedTempo( tclock );
                                    }
                                }
                            } else {
                                AppManager.addSelectedTempo( clock );
                            }
                        } else if ( (modifiers & s_modifier_key) == s_modifier_key ) {
                            if ( AppManager.isSelectedTempoContains( clock ) ) {
                                AppManager.removeSelectedTempo( clock );
                            } else {
                                AppManager.addSelectedTempo( clock );
                            }
                        } else {
                            if ( !AppManager.isSelectedTempoContains( clock ) ) {
                                AppManager.clearSelectedTempo();
                            }
                            AppManager.addSelectedTempo( clock );
                        }
                    } else {
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        AppManager.clearSelectedTimesig();
                    }
                    #endregion
                } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.getHeight() - 1 ) {
                    #region 拍子
                    // クリック位置に拍子が表示されているかどうか検査
                    int index = -1;
                    for ( int i = 0; i < AppManager.getVsqFile().TimesigTable.size(); i++ ) {
                        String s = AppManager.getVsqFile().TimesigTable.get( i ).Numerator + "/" + AppManager.getVsqFile().TimesigTable.get( i ).Denominator;
                        int x = AppManager.xCoordFromClocks( AppManager.getVsqFile().TimesigTable.get( i ).Clock );
                        Dimension size = Util.measureString( s, new Font( AppManager.editorConfig.ScreenFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE8 ) );
                        if ( isInRect( new Point( e.X, e.Y ), new Rectangle( x, 28, (int)size.width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index >= 0 ) {
                        int barcount = AppManager.getVsqFile().TimesigTable.get( index ).BarCount;
                        if ( AppManager.getSelectedTool() != EditTool.ERASER ) {
                            int barcount_clock = AppManager.getVsqFile().getClockFromBarCount( barcount );
                            int mouse_clock = AppManager.clockFromXCoord( e.X );
                            m_timesig_dragging_deltaclock = mouse_clock - barcount_clock;
                            m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.TIMESIG;
                        }
                        if ( (modifiers & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK ) {
                            if ( AppManager.getSelectedTimesigCount() > 0 ) {
                                int last_barcount = AppManager.getLastSelectedTimesigBarcount();
                                int start = Math.Min( last_barcount, barcount );
                                int end = Math.Max( last_barcount, barcount );
                                for ( int i = 0; i < AppManager.getVsqFile().TimesigTable.size(); i++ ) {
                                    int tbarcount = AppManager.getVsqFile().TimesigTable.get( i ).BarCount;
                                    if ( tbarcount < start ) {
                                        continue;
                                    } else if ( end < tbarcount ) {
                                        break;
                                    }
                                    if ( start <= tbarcount && tbarcount <= end ) {
                                        AppManager.addSelectedTimesig( AppManager.getVsqFile().TimesigTable.get( i ).BarCount );
                                    }
                                }
                            } else {
                                AppManager.addSelectedTimesig( barcount );
                            }
                        } else if ( (modifiers & s_modifier_key) == s_modifier_key ) {
                            if ( AppManager.isSelectedTimesigContains( barcount ) ) {
                                AppManager.removeSelectedTimesig( barcount );
                            } else {
                                AppManager.addSelectedTimesig( barcount );
                            }
                        } else {
                            if ( !AppManager.isSelectedTimesigContains( barcount ) ) {
                                AppManager.clearSelectedTimesig();
                            }
                            AppManager.addSelectedTimesig( barcount );
                        }
                    } else {
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        AppManager.clearSelectedTimesig();
                    }
                    #endregion
                }
            }
            refreshScreen();
        }

        public void picturePositionIndicator_MouseUp( Object sender, BMouseEventArgs e ) {
            int modifiers = PortUtil.getCurrentModifierKey();
#if DEBUG
            AppManager.debugWriteLine( "picturePositionIndicator_MouseClick" );
#endif
            if ( e.Button == BMouseButtons.Left ) {
                VsqFileEx vsq = AppManager.getVsqFile();
                if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.NONE ) {
                    if ( 4 <= e.Y && e.Y <= 18 ) {
                        #region マーカー位置の変更
                        int clock = AppManager.clockFromXCoord( e.X );
                        if ( AppManager.editorConfig.getPositionQuantize() != QuantizeMode.off ) {
                            int unit = AppManager.getPositionQuantizeClock();
                            clock = doQuantize( clock, unit );
                        }
                        AppManager.setCurrentClock( clock );
                        refreshScreen();
                        #endregion
                    } else if ( 18 < e.Y && e.Y <= 32 ) {
                        #region テンポの変更
#if DEBUG
                        AppManager.debugWriteLine( "TempoChange" );
#endif
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTimesig();
                        if ( AppManager.getSelectedTempoCount() > 0 ) {
                            #region テンポ変更があった場合
                            int index = -1;
                            int clock = AppManager.getLastSelectedTempoClock();
                            for ( int i = 0; i < vsq.TempoTable.size(); i++ ) {
                                if ( clock == vsq.TempoTable.get( i ).Clock ) {
                                    index = i;
                                    break;
                                }
                            }
                            if ( index >= 0 && AppManager.getSelectedTool() == EditTool.ERASER ) {
                                #region ツールがEraser
                                if ( vsq.TempoTable.get( index ).Clock == 0 ) {
                                    statusLabel.setText( _( "Cannot remove first symbol of track!" ) );
#if !JAVA
                                    SystemSounds.Asterisk.Play();
#endif
                                    return;
                                }
                                CadenciiCommand run = new CadenciiCommand(
                                    VsqCommand.generateCommandUpdateTempo( vsq.TempoTable.get( index ).Clock,
                                                                           vsq.TempoTable.get( index ).Clock,
                                                                           -1 ) );
                                AppManager.register( vsq.executeCommand( run ) );
                                setEdited( true );
                                #endregion
                            }
                            #endregion
                        }
                        m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
                        #endregion
                    } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.getHeight() - 1 ) {
                        #region 拍子の変更
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        if ( AppManager.getSelectedTimesigCount() > 0 ) {
                            #region 拍子変更があった場合
                            int index = 0;
                            int last_barcount = AppManager.getLastSelectedTimesigBarcount();
                            for ( int i = 0; i < vsq.TimesigTable.size(); i++ ) {
                                if ( vsq.TimesigTable.get( i ).BarCount == last_barcount ) {
                                    index = i;
                                    break;
                                }
                            }
                            if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                                #region ツールがEraser
                                if ( vsq.TimesigTable.get( index ).Clock == 0 ) {
                                    statusLabel.setText( _( "Cannot remove first symbol of track!" ) );
#if !JAVA
                                    SystemSounds.Asterisk.Play();
#endif
                                    return;
                                }
                                int barcount = vsq.TimesigTable.get( index ).BarCount;
                                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTimesig( barcount, barcount, -1, -1 ) );
                                AppManager.register( vsq.executeCommand( run ) );
                                setEdited( true );
                                #endregion
                            }
                            #endregion
                        }
                        #endregion
                    }
                } else if( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.TEMPO ){
                    int count = AppManager.getSelectedTempoCount();
                    int[] clocks = new int[count];
                    int[] new_clocks = new int[count];
                    int[] tempos = new int[count];
                    int i = -1;
                    boolean contains_first_tempo = false;
                    for ( Iterator<ValuePair<Integer, SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                        ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                        int clock = item.getKey();
                        i++;
                        clocks[i] = clock;
                        if ( clock == 0 ) {
                            contains_first_tempo = true;
                            break;
                        }
                        TempoTableEntry editing = AppManager.getSelectedTempo( clock ).editing;
                        new_clocks[i] = editing.Clock;
                        tempos[i] = editing.Tempo;
                    }
                    if ( contains_first_tempo ) {
#if !JAVA
                        SystemSounds.Asterisk.Play();
#endif
                    } else {
                        CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTempoRange( clocks, new_clocks, tempos ) );
                        AppManager.register( vsq.executeCommand( run ) );
                        setEdited( true );
                    }
                } else if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.TIMESIG ) {
                    int count = AppManager.getSelectedTimesigCount();
                    int[] barcounts = new int[count];
                    int[] new_barcounts = new int[count];
                    int[] numerators = new int[count];
                    int[] denominators = new int[count];
                    int i = -1;
                    boolean contains_first_bar = false;
                    for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                        ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                        int bar = item.getKey();
                        i++;
                        barcounts[i] = bar;
                        if ( bar == 0 ) {
                            contains_first_bar = true;
                            break;
                        }
                        TimeSigTableEntry editing = AppManager.getSelectedTimesig( bar ).editing;
                        new_barcounts[i] = editing.BarCount;
                        numerators[i] = editing.Numerator;
                        denominators[i] = editing.Denominator;
                    }
                    if ( contains_first_bar ) {
#if !JAVA
                        SystemSounds.Asterisk.Play();
#endif
                    } else {
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                        AppManager.register( vsq.executeCommand( run ) );
                        setEdited( true );
                    }
                }
            }
            m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
            pictPianoRoll.repaint();
            picturePositionIndicator.repaint();
        }

        public void picturePositionIndicator_MouseMove( Object sender, BMouseEventArgs e ) {
            if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.TEMPO ) {
                int clock = AppManager.clockFromXCoord( e.X ) - m_tempo_dragging_deltaclock;
                int step = AppManager.getPositionQuantizeClock();
                clock = doQuantize( clock, step );
                int last_clock = AppManager.getLastSelectedTempoClock();
                int dclock = clock - last_clock;
                for ( Iterator<ValuePair<Integer, SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                    int key = item.getKey();
                    AppManager.getSelectedTempo( key ).editing.Clock = AppManager.getSelectedTempo( key ).original.Clock + dclock;
                }
                picturePositionIndicator.repaint();
            } else if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.TIMESIG ) {
                int clock = AppManager.clockFromXCoord( e.X ) - m_timesig_dragging_deltaclock;
                int barcount = AppManager.getVsqFile().getBarCountFromClock( clock );
                int last_barcount = AppManager.getLastSelectedTimesigBarcount();
                int dbarcount = barcount - last_barcount;
                for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                    int bar = item.getKey();
                    AppManager.getSelectedTimesig( bar ).editing.BarCount = AppManager.getSelectedTimesig( bar ).original.BarCount + dbarcount;
                }
                picturePositionIndicator.repaint();
            } else if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.MARK_START ) {
                int clock = AppManager.clockFromXCoord( e.X );
                int unit = AppManager.getPositionQuantizeClock();
                clock = doQuantize( clock, unit );
                if ( clock < 0 ) {
                    clock = 0;
                }
                int draft_start = Math.Min( clock, AppManager.endMarker );
                int draft_end = Math.Max( clock, AppManager.endMarker );
                if ( draft_start != AppManager.startMarker ) {
                    AppManager.startMarker = draft_start;
                }
                if ( draft_end != AppManager.endMarker ) {
                    AppManager.endMarker = draft_end;
                }
                refreshScreen();
            } else if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.MARK_END ) {
                int clock = AppManager.clockFromXCoord( e.X );
                int unit = AppManager.getPositionQuantizeClock();
                clock = doQuantize( clock, unit );
                if ( clock < 0 ) {
                    clock = 0;
                }
                int draft_start = Math.Min( clock, AppManager.startMarker );
                int draft_end = Math.Max( clock, AppManager.startMarker );
                if ( draft_start != AppManager.startMarker ) {
                    AppManager.startMarker = draft_start;
                }
                if ( draft_end != AppManager.endMarker ) {
                    AppManager.endMarker = draft_end;
                }
                refreshScreen();
            }
        }

        public void picturePositionIndicator_Paint( Object sender, BPaintEventArgs e ) {
#if JAVA
            Graphics2D g = e.Graphics;
#else
            Graphics2D g = new Graphics2D( e.Graphics );
#endif
#if JAVA
            picturePositionIndicatorDrawTo( g );
#else
            picturePositionIndicatorDrawTo( g );
#endif
#if MONITOR_FPS
            g.setColor( Color.red );
            g.setFont( AppManager.baseFont10Bold );
            g.drawString( PortUtil.formatDecimal( "#.00", mFps ) + " / " + PortUtil.formatDecimal( "#.00", mFps2 ), 5, 5 );
#endif
        }

        public void picturePositionIndicator_PreviewKeyDown( Object sender, BPreviewKeyDownEventArgs e ) {
#if JAVA
            BKeyEventArgs e0 = new BKeyEventArgs( e.getRawEvent() );
#else
            BKeyEventArgs e0 = new BKeyEventArgs( e.KeyData );
#endif
            processSpecialShortcutKey( e0, true );
        }
        #endregion

        #region trackBar
        public void trackBar_Enter( Object sender, EventArgs e ) {
            pictPianoRoll.requestFocus();
        }

        public void trackBar_MouseDown( Object sender, BMouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
#if !JAVA
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
#endif
                m_txtbox_track_name = null;
            }
        }

        public void trackBar_ValueChanged( Object sender, EventArgs e ) {
            AppManager.setScaleX( trackBar.getValue() / 480f );
            AppManager.setStartToDrawX( calculateStartToDrawX() );
            updateDrawObjectList();
            repaint();
        }
        #endregion

        #region menuHelp
        public void menuHelpAbout_Click( Object sender, EventArgs e ) {
#if DEBUG
            PortUtil.println( "FormMain#menuHelpAbout_Click" );
#endif

#if JAVA
            String version_str = Utility.getVersion();
#else
            String version_str = Utility.getVersion() + "\n\n" +
                                 Utility.getAssemblyNameAndFileVersion( typeof( org.kbinani.apputil.Util ) ) + "\n" +
                                 Utility.getAssemblyNameAndFileVersion( typeof( org.kbinani.media.Wave ) ) + "\n" +
                                 Utility.getAssemblyNameAndFileVersion( typeof( org.kbinani.vsq.VsqFile ) ) + "\n" +
                                 Utility.getAssemblyNameAndFileVersion( typeof( org.kbinani.math ) );
#endif
            if ( m_versioninfo == null ) {
                m_versioninfo = new VersionInfo( _APP_NAME, version_str );
                m_versioninfo.setAuthorList( _CREDIT );
                m_versioninfo.setVisible( true );
            } else {
#if !JAVA
                if ( m_versioninfo.IsDisposed ) 
#endif
                {
                    m_versioninfo = new VersionInfo( _APP_NAME, version_str );
                    m_versioninfo.setAuthorList( _CREDIT );
                }
                m_versioninfo.setVisible( true );
            }
        }

        public void menuHelpDebug_Click( Object sender, EventArgs e ) {
#if DEBUG
            PortUtil.println( "FormMain#menuHelpDebug_Click" );

            /*VsqFileEx vsq = AppManager.getVsqFile();
            int ms_presend = AppManager.editorConfig.PreSendTime;
            for ( int i = vsq.getPreMeasureClocks(); i < vsq.TotalClocks; i++ ) {
                int presend_clock = vsq.getPresendClockAt( i, ms_presend );
                double sec_at_i = vsq.getSecFromClock( i );
                double sec_at_ipresend = vsq.getSecFromClock( i - presend_clock );
                double sec_at_i2 = sec_at_ipresend + ms_presend / 1000.0;
                if ( Math.Abs( sec_at_i - sec_at_i2 ) > 1 ) {
                    PortUtil.println( "sec_at_i=" + sec_at_i + "; sec_at_i2=" + sec_at_i2 );
                }
            }*/

            /*InputBox ib = new InputBox( "enter clock" );
            VsqFileEx vsq = AppManager.getVsqFile();
            int ms_presend = AppManager.editorConfig.PreSendTime;
            while ( ib.showDialog() == BDialogResult.OK ) {
                string s = ib.getResult();
                int i = int.Parse( s );
                int presend_clock = vsq.getPresendClockAt( i, ms_presend );
                double sec_at_i = vsq.getSecFromClock( i );
                double sec_at_i2 = vsq.getSecFromClock( i - presend_clock ) + ms_presend / 1000.0;
                AppManager.showMessageBox( "presend_clock=" + presend_clock + "; delta=" + (sec_at_i - sec_at_i2) );
            }*/

            /*string dir = @"E:\Documents and Settings\kbinani\My Documents\svn\cadencii\Cadencii\trunk\buildDefaultEnglishDictionary\LOLA";
            string ext = ".mid";
            string defSymbol = "u:";
            System.Collections.Generic.Dictionary<string, string> dict = new System.Collections.Generic.Dictionary<string, string>();

            // preload existing dictionary
            string dictFile = dir + "\\dictionary.txt";
            if ( !System.IO.Directory.Exists( dir ) ) {
                System.IO.Directory.CreateDirectory( dir );
            }
            if ( System.IO.File.Exists( dictFile ) ) {
                using ( System.IO.StreamReader sr = new System.IO.StreamReader( dictFile ) ) {
                    string line = "";
                    while ( (line = sr.ReadLine()) != null ) {
                        string[] spl = line.Split( '\t' );
                        dict.Add( spl[0], spl[1] );
                    }
                }
            }

            System.IO.DirectoryInfo di = new System.IO.DirectoryInfo( dir );
            foreach ( System.IO.FileInfo fi in di.GetFiles( "*" + ext ) ) {
                Console.WriteLine( fi.FullName );
                VsqFile vsq = new VsqFile( fi.FullName, "Shift_JIS" );
                for ( Iterator itr = vsq.Track.get( 1 ).getNoteEventIterator(); itr.hasNext(); ) {
                    VsqEvent item = (VsqEvent)itr.next();
                    string symbol = item.ID.LyricHandle.L0.getPhoneticSymbol();
                    if ( symbol != defSymbol ) {
                        string phrase = item.ID.LyricHandle.L0.Phrase;
                        if ( !dict.ContainsKey( phrase ) ) {
                            dict.Add( phrase, symbol );
                        }
                    }
                }
            }

            using ( System.IO.StreamWriter sw = new System.IO.StreamWriter( dictFile ) ) {
                System.Collections.Generic.List<string> list = new System.Collections.Generic.List<string>();
                foreach ( string key in dict.Keys ) {
                    list.Add( key );
                }
                list.Sort();
                int num = list.Count;
                for ( int i = 0; i < num; i++ ) {
                    string key = list[i];
                    sw.WriteLine( key + "\t" + dict[key] );
                }
            }*/
            /*if ( AppManager.getVsqFile().Track.size() >= 3 ) {
                EditedZoneUnit[] ret = AppManager.detectTrackDifference( AppManager.getVsqFile().Track.get( 1 ), AppManager.getVsqFile().Track.get( 2 ) );
                PortUtil.println( "FormMain#menuHelpDebug_Click; ret.Length=" + ret.Length );
                using ( System.IO.StreamWriter sw = new System.IO.StreamWriter( PortUtil.combinePath( System.Windows.Forms.Application.StartupPath, "track_difference.txt" ) ) ) {
                    for ( int i = 0; i < ret.Length; i++ ) {
                        sw.WriteLine( ret[i].start + "\t" + ret[i].end );
                    }
                }
            }*/
            /*InputBox box = new InputBox( "input sample rate" );
            if ( box.showDialog() == BDialogResult.OK ) {
                String ret = box.getResult();
                try {
                    int v = PortUtil.parseInt( ret );
                    VSTiProxy.SAMPLE_RATE = v;
                    PortUtil.println( "menuHelpDebug_Click; VSTiProxy.SAMPLE_RATE=" + VSTiProxy.SAMPLE_RATE );
                } catch ( Exception ex ) {
                }
            }*/
            /*BFileChooser dialog = new BFileChooser( "" );
            if ( dialog.showOpenDialog( this ) == BFileChooser.APPROVE_OPTION ) {
                String fileIn = dialog.getSelectedFile();
                if ( dialog.showSaveDialog( this ) == BFileChooser.APPROVE_OPTION ) {
                    String fileOut = dialog.getSelectedFile();
                    SimpleWaveReceiver receiver = new SimpleWaveReceiver( fileOut, 44100 );
                    WaveReader wr = new WaveReader( fileIn );
                    WaveRateConvertAdapter adapter = new WaveRateConvertAdapter( receiver, wr.getSampleRate() );
                    long total = wr.getTotalSamples();
                    try {
                        long proc = 0;
                        int BUFLEN = 1024;
                        double[] l = new double[BUFLEN];
                        double[] r = new double[BUFLEN];
                        int remain = 1;
                        while ( remain > 0 ) {
                            remain = (int)(total - proc);
                            remain = (remain > BUFLEN) ? BUFLEN : remain;
                            double[] left = null;
                            double[] right = null;
                            if ( remain == BUFLEN ) {
                                left = l;
                                right = r;
                            } else {
                                left = new double[remain];
                                right = new double[remain];
                            }
                            wr.read( proc, remain, l, r );
                            adapter.append( left, right );
                            proc += remain;
                        }
                    } catch ( Exception ex ) {
                        PortUtil.println( "FormMain#menuHelpDebug_Click; ex=" + ex );
                    }
                    wr.close();
                    receiver.close();
                }
            }*/
            /*try {
                BFileChooser dialog = new BFileChooser( "" );
                if ( dialog.showOpenDialog( this ) == BFileChooser.APPROVE_OPTION ) {
                    String file = dialog.getSelectedFile();
                    WaveRateConverter converter = new WaveRateConverter( new WaveReader( file ), 44100 );
                    String dir = PortUtil.getDirectoryName( file );
                    WaveWriter writer = new WaveWriter( PortUtil.combinePath( dir, PortUtil.getFileNameWithoutExtension( file ) + "_.wav" ), 2, 16, 44100 );
                    long remain = converter.getTotalSamples();
                    long procesed = 0;
                    int buflen = 1024;
                    double[] left = new double[buflen];
                    double[] right = new double[buflen];
                    while ( remain > 0 ) {
                        int read = remain > buflen ? buflen : (int)remain;
                        converter.read( procesed, read, left, right );
                        writer.append( left, right );
                        procesed += read;
                        remain -= read;
                    }
                    writer.close();
                    converter.close();
                }
            } catch ( Exception ex ) {
                PortUtil.stderr.println( "FormMain#menuHelpDebug_Click; ex=" + ex );
            }*/
            /*int i = 4;
            for ( Iterator itr = VocaloSysUtil.dynamicsConfigIterator( SynthesizerType.VOCALOID1 ); itr.hasNext(); ) {
                IconDynamicsHandle item = (IconDynamicsHandle)((IconDynamicsHandle)itr.next()).clone();
                VsqEvent ve = new VsqEvent( i * 480, new VsqID() );
                ve.ID.type = VsqIDType.Aicon;
                ve.ID.IconDynamicsHandle = item;
                if ( item.IconID.StartsWith( "$0501" ) ) {
                    ve.ID.setLength( 1 );
                } else {
                    ve.ID.setLength( 480 );
                }
                ve.ID.Note = 64;
                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventAdd( AppManager.getSelected(), ve ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                i++;
            }
            AppManager.getVsqFile().Track.get( AppManager.getSelected() ).reflectDynamics();*/
            /*int i = -1;
            for ( Iterator itr = VocaloSysUtil.dynamicsConfigIterator( SynthesizerType.VOCALOID1 ); itr.hasNext(); ) {
                IconDynamicsHandle handle = (IconDynamicsHandle)itr.next();
                i++;
                String valname = "d" + i;
                debug.push_log( "IconDynamicsHandle " + valname + " = new IconDynamicsHandle();" );
                debug.push_log( valname + ".IDS = \"" + handle.IDS + "\";" );
                debug.push_log( valname + ".IconID = \"" + handle.IconID + "\";" );
                debug.push_log( valname + ".Original = " + handle.Original + ";" );
                debug.push_log( valname + ".setCaption( \"" + handle.getCaption() + "\" );" );
                debug.push_log( valname + ".setStartDyn( " + handle.getStartDyn() + " );" );
                debug.push_log( valname + ".setEndDyn( " + handle.getEndDyn() + " );" );
                debug.push_log( valname + ".setLength( " + handle.getLength() + " );" );
                VibratoBPList dynbp = handle.getDynBP();
                if ( dynbp != null ) {
                    String x = "";
                    String y = "";
                    for ( int j = 0; j < dynbp.getCount(); j++ ) {
                        x += (j == 0 ? "" : ", ") + dynbp.getElement( j ).X + "f";
                        y += (j == 0 ? "" : ", ") + dynbp.getElement( j ).Y;
                    }
                    debug.push_log( valname + ".setDynBP( new VibratoBPList( new float[]{ " + x + " }, new int[]{ " + y + " } ) );" );
                }
                debug.push_log( "ret.m_dynamics_configs.add( " + valname + " );" );
                debug.push_log( "" );
            }*/
            /*InputBox ib = new InputBox( "input shift seconds" );
            if ( ib.ShowDialog() == DialogResult.OK ) {
                VsqFileEx vsq = (VsqFileEx)AppManager.getVsqFile().clone();
                VsqFileEx.shift( vsq, double.Parse( ib.Result ) );
                CadenciiCommand run = VsqFileEx.generateCommandReplace( vsq );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                Edited = true;
            }*/
            /*DialogResult dr = DialogResult.OK;
            while ( dr == DialogResult.OK ) {
                FileDialog fd = new FileDialog( FileDialog.DialogMode.Open );
                fd.Filter = "All Files(*.*)|*.*|VSQ Format(*.vsq)|*.vsq";
                dr = fd.ShowDialog();
                AppManager.DebugWriteLine( "fd.FileName=" + fd.FileName );
            }*/
            /*using ( OpenFileDialog ofd = new OpenFileDialog() ) {
                if ( ofd.ShowDialog() == DialogResult.OK ) {
                    using ( SaveFileDialog sfd = new SaveFileDialog() ) {
                        sfd.InitialDirectory = Path.GetDirectoryName( ofd.FileName );
                        sfd.FileName = PortUtil.getFileNameWithoutExtension( ofd.FileName ) + ".txt";
                        if ( sfd.ShowDialog() == DialogResult.OK ) {
                            using ( Wave w = new Wave( ofd.FileName ) ) {
                                w.PrintToText( sfd.FileName );
                            }
                        }
                    }
                }
            }*/

            /*using ( OpenFileDialog ofd = new OpenFileDialog() ) {
                if ( ofd.ShowDialog() == DialogResult.OK ) {
                    String file = ofd.FileName;
                    using ( Wave wv = new Wave( file ) ) {
                        const double sec_dt = 0.0025;
                        uint samples = wv.TotalSamples;
                        const int _WINDOW_WIDTH = 2048;
                        uint spl_dt = (uint)(sec_dt * wv.SampleRate);
                        double[] window_func = new double[_WINDOW_WIDTH];
                        for ( int i = 0; i < _WINDOW_WIDTH; i++ ) {
                            window_func[i] = org.kbinani.math.window_func( org.kbinani.math.WindowFunctionType.Hamming, i / (double)_WINDOW_WIDTH );
                        }
                        Wave.TestEnabled = false;

                        InputBox ib = new InputBox( "input clock count" );
                        if ( ib.ShowDialog() == DialogResult.OK ) {
                            int count = 0;
                            if ( int.TryParse( ib.Result, out count ) ) {
                                Wave.TestEnabled = true;
                                double f0 = wv.GetF0( (uint)count, window_func );
                                AppManager.showMessageBox( "f0=" + f0 + " at sample=" + count );
                                Wave.TestEnabled = false;
                            }
                        }
                        if ( AppManager.showMessageBox( "calculate all formant profile?", "Cadencii", MessageBoxButtons.YesNo ) == DialogResult.Yes ) {
                            using ( StreamWriter sw = new StreamWriter( ofd.FileName + "_formanto.txt" ) ) {
                                FormantoDetectionArguments fda = new FormantoDetectionArguments();
                                fda.PeakDetectionThreshold = 0.05;
                                for ( uint spl_i = 0; spl_i < samples; spl_i += spl_dt ) {
                                    double f0 = wv.GetF0( spl_i, window_func, fda );
                                    double note;
                                    if ( f0 > 0.0 ) {
                                        note = 12.0 * Math.Log( f0 / 440.0, 2.0 ) + 69;
                                    } else {
                                        note = 0.0;
                                    }
                                    sw.WriteLine( spl_i + "\t" + (spl_i / (double)wv.SampleRate) + "\t" + f0 + "\t" + note + "\t" + Math.Round( note, 0, MidpointRounding.AwayFromZero ) );
                                }
                            }
                        }
                        if ( AppManager.showMessageBox( "calculate volume profile?", "Cadencii", MessageBoxButtons.YesNo ) == DialogResult.Yes ) {
                            using ( StreamWriter sw = new StreamWriter( ofd.FileName + "_volume.txt" ) ) {
                                for ( uint spl_i = 0; spl_i < samples; spl_i += spl_dt ) {
                                    double volume = wv.GetVolume( (int)spl_i, window_func );
                                    sw.WriteLine( spl_i + "\t" + (spl_i / (double)wv.SampleRate) + "\t" + volume );
                                }
                            }
                        }
                    }
                }
            }*/
#endif
#if FOO
            using ( OpenFileDialog ofd = new OpenFileDialog() ) {
                if ( ofd.ShowDialog() == DialogResult.OK ) {
                    using ( Wave wv = new Wave( ofd.FileName ) ) {
                        wv.TrimSilence();
                        const int _WIN_LEN = 441;
                        double[] window = new double[_WIN_LEN];
                        for ( int i = 0; i < _WIN_LEN; i++ ) {
                            window[i] = org.kbinani.math.window_func( org.kbinani.math.WindowFunctionType.Hamming, (double)i / (double)_WIN_LEN );
                        }
                        using ( StreamWriter sw = new StreamWriter( ofd.FileName + ".txt" ) ) {
                            for ( int i = 0; i < wv.TotalSamples - _WIN_LEN / 10; i += _WIN_LEN / 10 ) {
                                sw.WriteLine( i / (double)wv.SampleRate + "\t" + wv.GetVolume( i, window ) );
                            }
                        }
                        /*using ( StreamWriter sw = new StreamWriter( ofd.FileName + ".txt" ) ) {
                            double to = 7000.0 * 2.0 / (double)wv.SampleRate;
                            int jmax = (int)(to * _WIN_LEN);
                            double resolution = 1e-3;
                            uint di = (uint)(resolution * wv.SampleRate);
                            for ( uint i = 0; i < wv.TotalSamples; i += di ) {
                                double[] formanto = wv.GetFormanto( i, window );
                                for ( int j = 1; j < _WIN_LEN && j < jmax; j++ ) {
                                    //double f = (double)j / (double)_WIN_LEN * (double)wv.SampleRate / 2.0;
                                    sw.Write( "{0:f4}\t", Math.Abs( formanto[j] ) );
                                }
                                sw.WriteLine();
                            }
                        }*/
                    }
                }
            }
#endif
        }
        #endregion

        #region trackSelector
        public void trackSelector_CommandExecuted( Object sender, EventArgs e ) {
            setEdited( true );
            refreshScreen();
        }

        public void trackSelector_MouseClick( Object sender, BMouseEventArgs e ) {
            if ( e.Button == BMouseButtons.Right ) {
                if ( AppManager.keyWidth < e.X && e.X < trackSelector.getWidth() ) {
                    if ( trackSelector.getHeight() - TrackSelector.OFFSET_TRACK_TAB <= e.Y && e.Y <= trackSelector.getHeight() ) {
                        cMenuTrackTab.show( trackSelector, e.X, e.Y );
                    } else {
                        cMenuTrackSelector.show( trackSelector, e.X, e.Y );
                    }
                }
            }
            if ( m_txtbox_track_name != null ) {
#if !JAVA
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
#endif
                m_txtbox_track_name = null;
            }
        }

        public void trackSelector_MouseDoubleClick( Object sender, BMouseEventArgs e ) {
            if ( e.Button == BMouseButtons.Middle ) {
                // ツールをポインター <--> 鉛筆に切り替える
                if ( AppManager.keyWidth < e.X &&
                     e.Y < trackSelector.getHeight() - TrackSelector.OFFSET_TRACK_TAB * 2 ) {
                    if ( AppManager.getSelectedTool() == EditTool.ARROW ) {
                        AppManager.setSelectedTool( EditTool.PENCIL );
                    } else {
                        AppManager.setSelectedTool( EditTool.ARROW );
                    }
                }
            }
        }

        public void trackSelector_MouseDown( Object sender, BMouseEventArgs e ) {
            if ( AppManager.keyWidth < e.X ) {
                m_mouse_downed_trackselector = true;
                BMouseButtons btn = e.Button;
                if ( AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier && m_spacekey_downed && e.Button == BMouseButtons.Left ) {
                    btn = BMouseButtons.Middle;
                }
                if ( btn == BMouseButtons.Middle ) {
                    m_edit_curve_mode = CurveEditMode.MIDDLE_DRAG;
                    m_button_initial = new Point( e.X, e.Y );
                    m_middle_button_hscroll = hScroll.getValue();
#if !JAVA
                    this.Cursor = HAND;
#endif
                }
            }
        }

        public void trackSelector_MouseMove( Object sender, BMouseEventArgs e ) {
            if ( m_form_activated ) {
#if ENABLE_PROPERTY
                if ( AppManager.inputTextBox != null && !AppManager.inputTextBox.IsDisposed && !AppManager.inputTextBox.isVisible() && !AppManager.propertyPanel.isEditing() ) {
#else
#if JAVA
                if ( AppManager.inputTextBox != null && !AppManager.inputTextBox.isVisible() ) {
#else
                if ( AppManager.inputTextBox != null && !AppManager.inputTextBox.IsDisposed && !AppManager.inputTextBox.isVisible() ) {
#endif
#endif
                    trackSelector.requestFocus();
                }
            }
            if ( e.Button == BMouseButtons.None ) {
                refreshScreen();
                return;
            }
            int parent_width = ((TrackSelector)sender).getWidth();
            if ( m_edit_curve_mode == CurveEditMode.MIDDLE_DRAG ) {
                int dx = e.X - m_button_initial.x;
                int dy = e.Y - m_button_initial.y;
                double new_hscroll_value = (double)m_middle_button_hscroll - (double)dx * AppManager.getScaleXInv();
                int draft;
                if ( new_hscroll_value < hScroll.getMinimum() ) {
                    draft = hScroll.getMinimum();
                } else if ( hScroll.getMaximum() < new_hscroll_value ) {
                    draft = hScroll.getMaximum();
                } else {
                    draft = (int)new_hscroll_value;
                }
                if ( AppManager.isPlaying() ) {
                    return;
                }
                if ( hScroll.getValue() != draft ) {
                    hScroll.setValue( draft );
                }
            } else {
                if ( m_mouse_downed_trackselector ) {
                    if ( m_ext_dragx_trackselector == ExtDragXMode.NONE ) {
                        if ( AppManager.keyWidth > e.X ) {
                            m_ext_dragx_trackselector = ExtDragXMode.LEFT;
                        } else if ( parent_width < e.X ) {
                            m_ext_dragx_trackselector = ExtDragXMode.RIGHT;
                        }
                    } else {
                        if ( AppManager.keyWidth <= e.X && e.X <= parent_width ) {
                            m_ext_dragx_trackselector = ExtDragXMode.NONE;
                        }
                    }
                } else {
                    m_ext_dragx_trackselector = ExtDragXMode.NONE;
                }

                if ( m_ext_dragx_trackselector != ExtDragXMode.NONE ) {
                    double now = PortUtil.getCurrentTime();
                    double dt = now - m_timer_drag_last_ignitted;
                    m_timer_drag_last_ignitted = now;
                    int px_move = AppManager.editorConfig.MouseDragIncrement;
                    if ( px_move / dt > AppManager.editorConfig.MouseDragMaximumRate ) {
                        px_move = (int)(dt * AppManager.editorConfig.MouseDragMaximumRate);
                    }
                    px_move += 5;
                    if ( m_ext_dragx_trackselector == ExtDragXMode.LEFT ) {
                        px_move *= -1;
                    }
                    double d_draft = hScroll.getValue() + px_move * AppManager.getScaleXInv();
                    if ( d_draft < 0.0 ) {
                        d_draft = 0.0;
                    }
                    int draft = (int)d_draft;
                    if ( hScroll.getMaximum() < draft ) {
                        hScroll.setMaximum( draft );
                    }
                    if ( draft < hScroll.getMinimum() ) {
                        draft = hScroll.getMinimum();
                    }
                    hScroll.setValue( draft );
                }
            }
            refreshScreen();
        }

        public void trackSelector_MouseUp( Object sender, BMouseEventArgs e ) {
            m_mouse_downed_trackselector = false;
            if ( m_edit_curve_mode == CurveEditMode.MIDDLE_DRAG ) {
                m_edit_curve_mode = CurveEditMode.NONE;
                setCursor( new Cursor( java.awt.Cursor.DEFAULT_CURSOR ) );
            }
        }

        public void trackSelector_MouseWheel( Object sender, BMouseEventArgs e ) {
            if ( (PortUtil.getCurrentModifierKey() & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK ) {
                double new_val = (double)vScroll.getValue() - e.Delta;
                if ( new_val > vScroll.getMaximum() ) {
                    vScroll.setValue( vScroll.getMaximum() );
                } else if ( new_val < vScroll.getMinimum() ) {
                    vScroll.setValue( vScroll.getMinimum() );
                } else {
                    vScroll.setValue( (int)new_val );
                }
            } else {
                hScroll.setValue( computeScrollValueFromWheelDelta( e.Delta ) );
            }
            refreshScreen();
        }

        public void trackSelector_PreferredMinHeightChanged( Object sender, EventArgs e ) {
            if ( menuVisualControlTrack.isSelected() ) {
                splitContainer1.setPanel2MinSize( trackSelector.getPreferredMinSize() );
#if DEBUG
                PortUtil.println( "FormMain#trackSelector_PreferredMinHeightChanged; splitContainer1.Panel2MinSize changed" );
#endif
            }
        }

        public void trackSelector_PreviewKeyDown( Object sender, BPreviewKeyDownEventArgs e ) {
#if JAVA
            BKeyEventArgs e0 = new BKeyEventArgs( e.getRawEvent() );
#else
            BKeyEventArgs e0 = new BKeyEventArgs( e.KeyData );
#endif
            processSpecialShortcutKey( e0, true );
        }

        public void trackSelector_RenderRequired( Object sender, Integer[] tracks ) {
            patchWorkToFreeze( tracks );
            /*int selected = AppManager.getSelected();
            Vector<Integer> t = new Vector<Integer>( Arrays.asList( PortUtil.convertIntArray( tracks ) ) );
            if ( t.contains( selected) ) {
                String file = PortUtil.combinePath( AppManager.getTempWaveDir(), selected + ".wav" );
                if ( PortUtil.isFileExists( file ) ) {
#if JAVA
                    Thread loadwave_thread = new Thread( new LoadWaveProc( file ) );
                    loadwave_thread.start();
#else
                    Thread loadwave_thread = new Thread( new ParameterizedThreadStart( this.loadWave ) );
                    loadwave_thread.IsBackground = true;
                    loadwave_thread.Start( new Object[]{ file, selected - 1 } );
#endif
                }
            }*/
        }

        public void trackSelector_SelectedCurveChanged( Object sender, CurveType type ) {
            refreshScreen();
        }

        public void trackSelector_SelectedTrackChanged( Object sender, int selected ) {
            AppManager.clearSelectedBezier();
            AppManager.clearSelectedEvent();
            AppManager.clearSelectedPoint();
            updateDrawObjectList();
            refreshScreen();
        }
        #endregion

        #region cMenuPiano*
        public void cMenuPianoDelete_Click( Object sender, EventArgs e ) {
            deleteEvent();
        }

        public void cMenuPianoVibratoProperty_Click( Object sender, EventArgs e ) {
            editNoteVibratoProperty();
        }

        public void cMenuPianoPaste_Click( Object sender, EventArgs e ) {
            pasteEvent();
        }

        public void cMenuPianoCopy_Click( Object sender, EventArgs e ) {
            copyEvent();
        }

        public void cMenuPianoCut_Click( Object sender, EventArgs e ) {
            cutEvent();
        }

        public void cMenuPianoExpression_Click( Object sender, EventArgs e ) {
            if ( AppManager.getSelectedEventCount() > 0 ) {
                VsqFileEx vsq = AppManager.getVsqFile();
                int selected = AppManager.getSelected();
                SynthesizerType type = SynthesizerType.VOCALOID2;
                RendererKind kind = VsqFileEx.getTrackRendererKind( vsq.Track.get( selected ) );
                if ( kind == RendererKind.VOCALOID1_100 || kind == RendererKind.VOCALOID1_101 ) {
                    type = SynthesizerType.VOCALOID1;
                }
                VsqEvent original = AppManager.getLastSelectedEvent().original;
                FormNoteExpressionConfig dlg = null;
                try {
                    dlg = new FormNoteExpressionConfig( type, original.ID.NoteHeadHandle );
                    int id = AppManager.getLastSelectedEvent().original.InternalID;
                    dlg.setPMBendDepth( original.ID.PMBendDepth );
                    dlg.setPMBendLength( original.ID.PMBendLength );
                    dlg.setPMbPortamentoUse( original.ID.PMbPortamentoUse );
                    dlg.setDEMdecGainRate( original.ID.DEMdecGainRate );
                    dlg.setDEMaccent( original.ID.DEMaccent );
                    dlg.setModal( true );
                    dlg.setVisible( true );
                    if ( dlg.getDialogResult() == BDialogResult.OK ) {
                        VsqID copy = (VsqID)original.ID.clone();
                        copy.PMBendDepth = dlg.getPMBendDepth();
                        copy.PMBendLength = dlg.getPMBendLength();
                        copy.PMbPortamentoUse = dlg.getPMbPortamentoUse();
                        copy.DEMdecGainRate = dlg.getDEMdecGainRate();
                        copy.DEMaccent = dlg.getDEMaccent();
                        copy.NoteHeadHandle = dlg.getEditedNoteHeadHandle();
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandEventChangeIDContaints( selected, id, copy ) );
                        AppManager.register( vsq.executeCommand( run ) );
                        setEdited( true );
                    }
                } catch ( Exception ex ) {
                } finally {
                    if ( dlg != null ) {
                        try {
                            dlg.close();
                        } catch ( Exception ex2 ) {
                        }
                    }
                }
            }
        }

        public void cMenuPianoPointer_Click( Object sender, EventArgs e ) {
            AppManager.setSelectedTool( EditTool.ARROW );
        }

        public void cMenuPianoPencil_Click( Object sender, EventArgs e ) {
            AppManager.setSelectedTool( EditTool.PENCIL );
        }

        public void cMenuPianoEraser_Click( Object sender, EventArgs e ) {
            AppManager.setSelectedTool( EditTool.ERASER );
        }

        public void handlePositionQuantize( Object sender, EventArgs e ) {
            QuantizeMode qm = AppManager.editorConfig.getPositionQuantize();
            if ( sender == cMenuPianoQuantize04 ||
#if ENABLE_STRIP_DROPDOWN
                sender == stripDDBtnQuantize04 ||
#endif
                sender == menuSettingPositionQuantize04 ) {
                qm = QuantizeMode.p4;
            } else if ( sender == cMenuPianoQuantize08 ||
#if ENABLE_STRIP_DROPDOWN
                        sender == stripDDBtnQuantize08 ||
#endif
                        sender == menuSettingPositionQuantize08 ) {
                qm = QuantizeMode.p8;
            } else if ( sender == cMenuPianoQuantize16 ||
#if ENABLE_STRIP_DROPDOWN
                        sender == stripDDBtnQuantize16 ||
#endif
                        sender == menuSettingPositionQuantize16 ) {
                qm = QuantizeMode.p16;
            } else if ( sender == cMenuPianoQuantize32 ||
#if ENABLE_STRIP_DROPDOWN
                        sender == stripDDBtnQuantize32 ||
#endif
                        sender == menuSettingPositionQuantize32 ) {
                qm = QuantizeMode.p32;
            } else if ( sender == cMenuPianoQuantize64 ||
#if ENABLE_STRIP_DROPDOWN
                        sender == stripDDBtnQuantize64 ||
#endif
                        sender == menuSettingPositionQuantize64 ) {
                qm = QuantizeMode.p64;
            } else if ( sender == cMenuPianoQuantize128 ||
#if ENABLE_STRIP_DROPDOWN
                        sender == stripDDBtnQuantize128 ||
#endif
                        sender == menuSettingPositionQuantize128 ) {
                qm = QuantizeMode.p128;
            } else if ( sender == cMenuPianoQuantizeOff ||
#if ENABLE_STRIP_DROPDOWN
                        sender == stripDDBtnQuantizeOff ||
#endif
                        sender == menuSettingPositionQuantizeOff ) {
                qm = QuantizeMode.off;
            }
            AppManager.editorConfig.setPositionQuantize( qm );
            refreshScreen();
        }

        public void h_positionQuantizeTriplet( Object sender, EventArgs e ) {
            AppManager.editorConfig.setPositionQuantizeTriplet( !AppManager.editorConfig.isPositionQuantizeTriplet() );
            refreshScreen();
        }

        public void h_lengthQuantize04( Object sender, EventArgs e ) {
            AppManager.editorConfig.setLengthQuantize(QuantizeMode.p4 );
        }

        public void h_lengthQuantize08( Object sender, EventArgs e ) {
            AppManager.editorConfig.setLengthQuantize( QuantizeMode.p8 );
        }

        public void h_lengthQuantize16( Object sender, EventArgs e ) {
            AppManager.editorConfig.setLengthQuantize( QuantizeMode.p16 );
        }

        public void h_lengthQuantize32( Object sender, EventArgs e ) {
            AppManager.editorConfig.setLengthQuantize( QuantizeMode.p32 );
        }

        public void h_lengthQuantize64( Object sender, EventArgs e ) {
            AppManager.editorConfig.setLengthQuantize( QuantizeMode.p64 );
        }

        public void h_lengthQuantize128( Object sender, EventArgs e ) {
            AppManager.editorConfig.setLengthQuantize( QuantizeMode.p128 );
        }

        public void h_lengthQuantizeOff( Object sender, EventArgs e ) {
            AppManager.editorConfig.setLengthQuantize( QuantizeMode.off );
        }

        public void h_lengthQuantizeTriplet( Object sender, EventArgs e ) {
            AppManager.editorConfig.setLengthQuantizeTriplet( !AppManager.editorConfig.isLengthQuantizeTriplet() );
        }

        public void cMenuPianoGrid_Click( Object sender, EventArgs e ) {
            cMenuPianoGrid.setSelected( !cMenuPianoGrid.isSelected() );
            AppManager.setGridVisible( cMenuPianoGrid.isSelected() );
        }

        public void cMenuPianoUndo_Click( Object sender, EventArgs e ) {
            undo();
        }

        public void cMenuPianoRedo_Click( Object sender, EventArgs e ) {
            redo();
        }

        public void cMenuPianoSelectAllEvents_Click( Object sender, EventArgs e ) {
            selectAllEvent();
        }

        public void cMenuPianoProperty_Click( Object sender, EventArgs e ) {
            editNoteExpressionProperty();
        }

        public void cMenuPianoImportLyric_Click( Object sender, EventArgs e ) {
            importLyric();
        }

        public void cMenuPiano_Opening( Object sender, BCancelEventArgs e ) {
            updateCopyAndPasteButtonStatus();
            cMenuPianoImportLyric.setEnabled( AppManager.getLastSelectedEvent() != null );
        }

        public void cMenuPianoSelectAll_Click( Object sender, EventArgs e ) {
            selectAll();
        }

        public void cMenuPianoFixed01_Click( Object sender, EventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L1 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixed02_Click( Object sender, EventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L2 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixed04_Click( Object sender, EventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L4 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixed08_Click( Object sender, EventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L8 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixed16_Click( Object sender, EventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L16 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixed32_Click( Object sender, EventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L32 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixed64_Click( Object sender, EventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L64 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixed128_Click( Object sender, EventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L128 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixedOff_Click( Object sender, EventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.Off );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixedTriplet_Click( Object sender, EventArgs e ) {
            m_pencil_mode.setTriplet( !m_pencil_mode.isTriplet() );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixedDotted_Click( Object sender, EventArgs e ) {
            m_pencil_mode.setDot( !m_pencil_mode.isDot() );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoCurve_Click( Object sender, EventArgs e ) {
            AppManager.setCurveMode( !AppManager.isCurveMode() );
            applySelectedTool();
        }
        #endregion

        #region menuTrack*
        public void menuTrack_DropDownOpening( Object sender, EventArgs e ) {
            updateTrackMenuStatus();
        }

        public void menuTrackCopy_Click( Object sender, EventArgs e ) {
            copyTrackCore();
        }

        public void menuTrackChangeName_Click( Object sender, EventArgs e ) {
            changeTrackNameCore();
        }

        public void menuTrackDelete_Click( Object sender, EventArgs e ) {
            deleteTrackCore();
        }

        public void menuTrackAdd_Click( Object sender, EventArgs e ) {
            addTrackCore();
        }

        public void menuTrackOverlay_Click( Object sender, EventArgs e ) {
            AppManager.setOverlay( !AppManager.isOverlay() );
            refreshScreen();
        }

        public void menuTrackRenderCurrent_Click( Object sender, EventArgs e ) {
            patchWorkToFreeze( new Integer[] { AppManager.getSelected() } );
        }

        public void commonTrackOn_Click( Object sender, EventArgs e ) {
            boolean newStatus = (sender == cMenuTrackTabTrackOn) ? !cMenuTrackTabTrackOn.isSelected() : !menuTrackOn.isSelected();
            menuTrackOn.setSelected( newStatus );
            cMenuTrackTabTrackOn.setSelected( newStatus );

            int selected = AppManager.getSelected();
            VsqTrack vsq_track = AppManager.getVsqFile().Track.get( selected );
            int last_play_mode = vsq_track.getCommon().LastPlayMode;
            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandTrackChangePlayMode( selected,
                                                                                                      newStatus ? last_play_mode : PlayMode.Off,
                                                                                                      last_play_mode ) );
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
            setEdited( true );
            refreshScreen();
        }

        public void commonTrackRenderAll_Click( Object sender, EventArgs e ) {
            Vector<Integer> list = new Vector<Integer>();
            int c = AppManager.getVsqFile().Track.size();
            for ( int i = 1; i < c; i++ ) {
                if ( AppManager.getRenderRequired( i ) ) {
                    list.add( i );
                }
            }
            if ( list.size() <= 0 ) {
                return;
            }
            patchWorkToFreeze( list.toArray( new Integer[] { } ) );
        }

        public void menuTrackRenderer_DropDownOpening( Object sender, EventArgs e ) {
            updateRendererMenu();
        }

        public void menuTrackOn_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Enable current track." ) );
        }

        public void menuTrackAdd_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Add new track." ) );
        }

        public void menuTrackCopy_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Copy current track." ) );
        }

        public void menuTrackChangeName_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Change track name." ) );
        }

        public void menuTrackDelete_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Delete current track." ) );
        }

        public void menuTrackRenderCurrent_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Render current track." ) );
        }

        public void menuTrackRenderAll_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Render all tracks." ) );
        }

        public void menuTrackOverlay_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Show background items." ) );
        }

        public void menuTrackRenderer_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Select voice synthesis engine." ) );
        }

        public void menuTrackRendererVOCALOID1_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "VOCALOID1" ) );
        }

        public void menuTrackRendererVOCALOID2_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "VOCALOID2" ) );
        }

        public void menuTrackRendererUtau_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "UTAU" ) );
        }

        public void menuTrackMasterTuning_MouseEnter( Object sender, EventArgs e ) {
            statusLabel.setText( _( "Set global pitch shift." ) );
        }
        #endregion

        #region menuHidden*
        public void menuHiddenTrackNext_Click( Object sender, EventArgs e ) {
            if ( AppManager.getSelected() == AppManager.getVsqFile().Track.size() - 1 ) {
                AppManager.setSelected( 1 );
            } else {
                AppManager.setSelected( AppManager.getSelected() + 1 );
            }
            refreshScreen();
        }

        public void menuHiddenShorten_Click( Object sender, EventArgs e ) {
            QuantizeMode qmode = AppManager.editorConfig.getLengthQuantize();
            boolean triplet = AppManager.editorConfig.isLengthQuantizeTriplet();
            int delta = -QuantizeModeUtil.getQuantizeClock( qmode, triplet );
            lengthenSelectedEvent( delta );
        }

        public void menuHiddenTrackBack_Click( Object sender, EventArgs e ) {
            if ( AppManager.getSelected() == 1 ) {
                AppManager.setSelected( AppManager.getVsqFile().Track.size() - 1 );
            } else {
                AppManager.setSelected( AppManager.getSelected() - 1 );
            }
            refreshScreen();
        }

        public void menuHiddenEditPaste_Click( Object sender, EventArgs e ) {
            pasteEvent();
        }

        public void menuHiddenFlipCurveOnPianorollMode_Click( Object sender, EventArgs e ) {
            AppManager.curveOnPianoroll = !AppManager.curveOnPianoroll;
            refreshScreen();
        }

        public void menuHiddenGoToEndMarker_Click( Object sender, EventArgs e ) {
            if ( AppManager.isPlaying() ) {
                return;
            }

            if ( AppManager.endMarkerEnabled ) {
                AppManager.setCurrentClock( AppManager.endMarker );
                ensureCursorVisible();
                refreshScreen();
            }
        }

        public void menuHiddenGoToStartMarker_Click( Object sender, EventArgs e ) {
            if ( AppManager.isPlaying() ) {
                return;
            }

            if ( AppManager.startMarkerEnabled ) {
                AppManager.setCurrentClock( AppManager.startMarker );
                ensureCursorVisible();
                refreshScreen();
            }
        }

        public void menuHiddenLengthen_Click( Object sender, EventArgs e ) {
            QuantizeMode qmode = AppManager.editorConfig.getLengthQuantize();
            boolean triplet = AppManager.editorConfig.isLengthQuantizeTriplet();
            int delta = QuantizeModeUtil.getQuantizeClock( qmode, triplet );
            lengthenSelectedEvent( delta );
        }

        public void menuHiddenMoveDown_Click( Object sender, EventArgs e ) {
            moveUpDownLeftRight( -1, 0 );
        }

        public void menuHiddenMoveUp_Click( Object sender, EventArgs e ) {
            moveUpDownLeftRight( 1, 0 );
        }

        public void menuHiddenPlayFromStartMarker_Click( Object sender, EventArgs e ) {
            if ( AppManager.isPlaying() ) {
                return;
            }
            if ( !AppManager.startMarkerEnabled ) {
                return;
            }

            AppManager.setCurrentClock( AppManager.startMarker );
            AppManager.setPlaying( true );
        }
        
        public void menuHiddenMoveLeft_Click( Object sender, EventArgs e ) {
            QuantizeMode mode = AppManager.editorConfig.getPositionQuantize();
            boolean triplet = AppManager.editorConfig.isPositionQuantizeTriplet();
            int delta = -QuantizeModeUtil.getQuantizeClock( mode, triplet );
#if DEBUG
            PortUtil.println( "FormMain#menuHiddenMoveLeft_Click; delta=" + delta );
#endif
            moveUpDownLeftRight( 0, delta );
        }

        public void menuHiddenMoveRight_Click( Object sender, EventArgs e ) {
            QuantizeMode mode = AppManager.editorConfig.getPositionQuantize();
            boolean triplet = AppManager.editorConfig.isPositionQuantizeTriplet();
            int delta = QuantizeModeUtil.getQuantizeClock( mode, triplet );
            moveUpDownLeftRight( 0, delta );
        }

        public void menuHiddenSelectBackward_Click( Object sender, EventArgs e ) {
            selectBackward();
        }

        public void menuHiddenSelectForward_Click( Object sender, EventArgs e ) {
            selectForward();
        }

        public void menuHiddenEditFlipToolPointerPencil_Click( Object sender, EventArgs e ) {
            if ( AppManager.getSelectedTool() == EditTool.ARROW ) {
                AppManager.setSelectedTool( EditTool.PENCIL );
            } else {
                AppManager.setSelectedTool( EditTool.ARROW );
            }
            refreshScreen();
        }

        public void menuHiddenEditFlipToolPointerEraser_Click( Object sender, EventArgs e ) {
            if ( AppManager.getSelectedTool() == EditTool.ARROW ) {
                AppManager.setSelectedTool( EditTool.ERASER );
            } else {
                AppManager.setSelectedTool( EditTool.ARROW );
            }
            refreshScreen();
        }

        public void menuHiddenEditLyric_Click( Object sender, EventArgs e ) {
#if JAVA
            boolean input_enabled = AppManager.inputTextBox.isVisible();
#else
            boolean input_enabled = AppManager.inputTextBox.Enabled;
#endif
            if ( !input_enabled && AppManager.getSelectedEventCount() > 0 ) {
                VsqEvent original = AppManager.getLastSelectedEvent().original;
                int clock = original.Clock;
                int note = original.ID.Note;
                Point pos = new Point( AppManager.xCoordFromClocks( clock ), AppManager.yCoordFromNote( note ) );
                if ( !AppManager.editorConfig.KeepLyricInputMode ) {
                    m_last_symbol_edit_mode = false;
                }
                showInputTextBox( original.ID.LyricHandle.L0.Phrase,
                                  original.ID.LyricHandle.L0.getPhoneticSymbol(),
                                  pos, m_last_symbol_edit_mode );
            } else if ( input_enabled ) {
                if ( AppManager.inputTextBox.isPhoneticSymbolEditMode() ) {
                    flipInputTextBoxMode();
                }
            }
        }
        #endregion

        #region cMenuTrackTab
        public void cMenuTrackTabCopy_Click( Object sender, EventArgs e ) {
            copyTrackCore();
        }

        public void cMenuTrackTabChangeName_Click( Object sender, EventArgs e ) {
            changeTrackNameCore();
        }

        public void cMenuTrackTabDelete_Click( Object sender, EventArgs e ) {
            deleteTrackCore();
        }

        public void cMenuTrackTabAdd_Click( Object sender, EventArgs e ) {
            addTrackCore();
        }

        public void cMenuTrackTab_Opening( Object sender, BCancelEventArgs e ) {
            updateTrackMenuStatus();
        }

        public void updateTrackMenuStatus() {
            VsqFileEx vsq = AppManager.getVsqFile();
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );
            int tracks = vsq.Track.size();
            cMenuTrackTabDelete.setEnabled( tracks >= 3 );
            menuTrackDelete.setEnabled( tracks >= 3 );
            cMenuTrackTabAdd.setEnabled( tracks <= 16 );
            menuTrackAdd.setEnabled( tracks <= 16 );
            cMenuTrackTabCopy.setEnabled( tracks <= 16 );
            menuTrackCopy.setEnabled( tracks <= 16 );

            boolean on = vsq_track.isTrackOn();
            cMenuTrackTabTrackOn.setSelected( on );
            menuTrackOn.setSelected( on );

            boolean playAfterSynth = vsq_track.getCommon().LastPlayMode == PlayMode.PlayAfterSynth;
            cMenuTrackTabPlayAfterSynth.setSelected( playAfterSynth );
            menuTrackPlayAfterSynth.setSelected( playAfterSynth );
            
            if ( tracks > 2 ) {
                cMenuTrackTabOverlay.setEnabled( true );
                menuTrackOverlay.setEnabled( true );
                cMenuTrackTabOverlay.setSelected( AppManager.isOverlay() );
                menuTrackOverlay.setSelected( AppManager.isOverlay() );
            } else {
                cMenuTrackTabOverlay.setEnabled( false );
                menuTrackOverlay.setEnabled( false );
                cMenuTrackTabOverlay.setSelected( false );
                menuTrackOverlay.setSelected( false );
            }
            cMenuTrackTabRenderCurrent.setEnabled( !AppManager.isPlaying() );
            menuTrackRenderCurrent.setEnabled( !AppManager.isPlaying() );
            cMenuTrackTabRenderAll.setEnabled( !AppManager.isPlaying() );
            menuTrackRenderAll.setEnabled( !AppManager.isPlaying() );
            cMenuTrackTabRendererVOCALOID100.setSelected( false );
            menuTrackRendererVOCALOID100.setSelected( false );
            cMenuTrackTabRendererVOCALOID101.setSelected( false );
            menuTrackRendererVOCALOID101.setSelected( false );
            cMenuTrackTabRendererVOCALOID2.setSelected( false );
            menuTrackRendererVOCALOID2.setSelected( false );
            cMenuTrackTabRendererUtau.setSelected( false );
            menuTrackRendererUtau.setSelected( false );
            cMenuTrackTabRendererStraight.setSelected( false );
            menuTrackRendererStraight.setSelected( false );
            cMenuTrackTabRendererAquesTone.setSelected( false );
            menuTrackRendererAquesTone.setSelected( false );

            RendererKind kind = VsqFileEx.getTrackRendererKind( vsq_track );
            if ( kind == RendererKind.VOCALOID1_100 ) {
                cMenuTrackTabRendererVOCALOID100.setSelected( true );
                menuTrackRendererVOCALOID100.setSelected( true );
            } else if ( kind == RendererKind.VOCALOID1_101 ) {
                cMenuTrackTabRendererVOCALOID101.setSelected( true );
                menuTrackRendererVOCALOID101.setSelected( true );
            } else if ( kind == RendererKind.VOCALOID2 ) {
                cMenuTrackTabRendererVOCALOID2.setSelected( true );
                menuTrackRendererVOCALOID2.setSelected( true );
            } else if ( kind == RendererKind.UTAU ) {
                cMenuTrackTabRendererUtau.setSelected( true );
                menuTrackRendererUtau.setSelected( true );
            } else if ( kind == RendererKind.STRAIGHT_UTAU ) {
                cMenuTrackTabRendererStraight.setSelected( true );
                menuTrackRendererStraight.setSelected( true );
            } else if ( kind == RendererKind.AQUES_TONE ) {
                cMenuTrackTabRendererAquesTone.setSelected( true );
                menuTrackRendererAquesTone.setSelected( true );
            }
        }

        public void cMenuTrackTabOverlay_Click( Object sender, EventArgs e ) {
            AppManager.setOverlay( !AppManager.isOverlay() );
            refreshScreen();
        }

        public void cMenuTrackTabRenderCurrent_Click( Object sender, EventArgs e ) {
            patchWorkToFreeze( new Integer[] { AppManager.getSelected() } );
        }

        public void cMenuTrackTabRenderer_DropDownOpening( Object sender, EventArgs e ) {
            updateRendererMenu();
        }
        #endregion

        #region m_txtbox_track_name
        public void m_txtbox_track_name_KeyUp( Object sender, BKeyEventArgs e ) {
#if JAVA
            if ( e.KeyValue == KeyEvent.VK_ENTER ){
#else
            if ( e.KeyCode == System.Windows.Forms.Keys.Enter ) {
#endif
                CadenciiCommand run = new CadenciiCommand(
                    VsqCommand.generateCommandTrackChangeName( AppManager.getSelected(), m_txtbox_track_name.getText() ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
#if !JAVA
                m_txtbox_track_name.Dispose();
#endif
                m_txtbox_track_name = null;
                refreshScreen();
#if JAVA
            } else if ( e.KeyValue == KeyEvent.VK_ESCAPE ) {
#else
            } else if ( e.KeyCode == System.Windows.Forms.Keys.Escape ) {
#endif

#if !JAVA
                m_txtbox_track_name.Dispose();
#endif
                m_txtbox_track_name = null;
            }
        }
        #endregion

        #region cMenuTrackSelector
        public void cMenuTrackSelector_Opening( Object sender, BCancelEventArgs e ) {
            updateCopyAndPasteButtonStatus();

            // 選択ツールの状態に合わせて表示を更新
            cMenuTrackSelectorPointer.setSelected( false );
            cMenuTrackSelectorPencil.setSelected( false );
            cMenuTrackSelectorLine.setSelected( false );
            cMenuTrackSelectorEraser.setSelected( false );
            EditTool tool = AppManager.getSelectedTool();
            if ( tool == EditTool.ARROW ) {
                cMenuTrackSelectorPointer.setSelected( true );
            } else if ( tool == EditTool.PENCIL ) {
                cMenuTrackSelectorPencil.setSelected( true );
            } else if ( tool == EditTool.LINE ) {
                cMenuTrackSelectorLine.setSelected( true );
            } else if ( tool == EditTool.ERASER ) {
                cMenuTrackSelectorEraser.setSelected( true );
            }
            cMenuTrackSelectorCurve.setSelected( AppManager.isCurveMode() );
        }

        public void cMenuTrackSelectorPointer_Click( Object sender, EventArgs e ) {
            AppManager.setSelectedTool( EditTool.ARROW );
            refreshScreen();
        }

        public void cMenuTrackSelectorPencil_Click( Object sender, EventArgs e ) {
            AppManager.setSelectedTool( EditTool.PENCIL );
            refreshScreen();
        }

        public void cMenuTrackSelectorLine_Click( Object sender, EventArgs e ) {
            AppManager.setSelectedTool( EditTool.LINE );
        }

        public void cMenuTrackSelectorEraser_Click( Object sender, EventArgs e ) {
            AppManager.setSelectedTool( EditTool.ERASER );
        }

        public void cMenuTrackSelectorCurve_Click( Object sender, EventArgs e ) {
            AppManager.setCurveMode( !AppManager.isCurveMode() );
        }

        public void cMenuTrackSelectorSelectAll_Click( Object sender, EventArgs e ) {
            selectAllEvent();
        }

        public void cMenuTrackSelectorCut_Click( Object sender, EventArgs e ) {
            cutEvent();
        }

        public void cMenuTrackSelectorCopy_Click( Object sender, EventArgs e ) {
            copyEvent();
        }

        public void cMenuTrackSelectorDelete_Click( Object sender, EventArgs e ) {
            deleteEvent();
        }

        public void cMenuTrackSelectorDeleteBezier_Click( Object sender, EventArgs e ) {
            for ( Iterator<SelectedBezierPoint> itr = AppManager.getSelectedBezierIterator(); itr.hasNext(); ) {
                SelectedBezierPoint sbp = itr.next();
                int chain_id = sbp.chainID;
                int point_id = sbp.pointID;
                VsqFileEx vsq = AppManager.getVsqFile();
                int selected = AppManager.getSelected();
                BezierChain chain = (BezierChain)vsq.AttachedCurves.get( selected - 1 ).getBezierChain( trackSelector.getSelectedCurve(), chain_id ).clone();
                int index = -1;
                for ( int i = 0; i < chain.points.size(); i++ ) {
                    if ( chain.points.get( i ).getID() == point_id ) {
                        index = i;
                        break;
                    }
                }
                if ( index >= 0 ) {
                    chain.points.removeElementAt( index );
                    if ( chain.points.size() == 0 ) {
                        CadenciiCommand run = VsqFileEx.generateCommandDeleteBezierChain( selected,
                                                                                          trackSelector.getSelectedCurve(),
                                                                                          chain_id,
                                                                                          AppManager.editorConfig.getControlCurveResolutionValue() );
                        AppManager.register( vsq.executeCommand( run ) );
                    } else {
                        CadenciiCommand run = VsqFileEx.generateCommandReplaceBezierChain( selected,
                                                                                           trackSelector.getSelectedCurve(),
                                                                                           chain_id,
                                                                                           chain,
                                                                                           AppManager.editorConfig.getControlCurveResolutionValue() );
                        AppManager.register( vsq.executeCommand( run ) );
                    }
                    setEdited( true );
                    refreshScreen();
                    break;
                }
            }
        }

        public void cMenuTrackSelectorPaste_Click( Object sender, EventArgs e ) {
            pasteEvent();
        }

        public void cMenuTrackSelectorUndo_Click( Object sender, EventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "cMenuTrackSelectorUndo_Click" );
#endif
            undo();
            refreshScreen();
        }

        public void cMenuTrackSelectorRedo_Click( Object sender, EventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "cMenuTrackSelectorRedo_Click" );
#endif
            redo();
            refreshScreen();
        }
        #endregion

        public void pictureBox3_MouseDown( Object sender, BMouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
#if !JAVA
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
#endif
                m_txtbox_track_name = null;
            }
        }

        public void pictureBox2_MouseDown( Object sender, BMouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
#if !JAVA
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
#endif
                m_txtbox_track_name = null;
            }
        }

        public void menuStrip1_MouseDown( Object sender, BMouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
#if !JAVA
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
#endif
                m_txtbox_track_name = null;
            }
        }

        public void timer_Tick( Object sender, EventArgs e ) {
#if DEBUG
            //PortUtil.println( "FormMain#timer_Tick; AppManager.firstBufferWritten=" + AppManager.firstBufferWritten );
#endif
            float play_time = -1.0f;
            if ( AppManager.rendererAvailable ) {
                // レンダリング用VSTiが利用可能な状態でAppManager_PreviewStartedした場合
                if ( !AppManager.firstBufferWritten ) {
                    return;
                }
                play_time = VSTiProxy.getPlayTime();
            } else {
                play_time = (float)(PortUtil.getCurrentTime() - AppManager.previewStartedTime);
            }
            if ( AppManager.getEditMode() == EditMode.REALTIME ) {
                play_time = play_time * AppManager.editorConfig.getRealtimeInputSpeed();
            }
            float now = (float)(play_time + m_direct_play_shift);
#if DEBUG
            //PortUtil.println( "FormMain#timer_Tick; play_time=" + play_time + "; m_preview_ending_time=" + m_preview_ending_time + "; now=" + now );
            //PortUtil.println( "FormMain#timer_Tick; AppManager.isPlaying()=" + AppManager.isPlaying() );
#endif
            if ( (play_time < 0.0 || m_preview_ending_time <= now) && 
                 AppManager.getEditMode() != EditMode.REALTIME ) {
#if DEBUG
                PortUtil.println( "FormMain#timer_Tick; stop at A; play_time=" + play_time + "; m_preview_ending_time=" + m_preview_ending_time + "; now=" + now );
#endif
                AppManager.setPlaying( false );
                timer.stop();
                if ( AppManager.startMarkerEnabled ) {
                    AppManager.setCurrentClock( AppManager.startMarker );
                    ensureCursorVisible();
                }
                if ( AppManager.isRepeatMode() ) {
                    AppManager.setPlaying( true );
                } else {
                    return;
                }
            }
            int clock = (int)AppManager.getVsqFile().getClockFromSec( now );
            if ( clock > hScroll.getMaximum() ) {
                if ( AppManager.getEditMode() == EditMode.REALTIME ) {
                    hScroll.setMaximum( clock + (int)((pictPianoRoll.getWidth() - AppManager.keyWidth) / 2.0f * AppManager.getScaleXInv()) );
                } else {
                    if ( !AppManager.isRepeatMode() ) {
                        timer.stop();
#if DEBUG
                        PortUtil.println( "FormMain#timer_Tick; stop at B" );
#endif
                        AppManager.setPlaying( false );
                    }
                }
            } else if ( AppManager.endMarkerEnabled && clock > (int)AppManager.endMarker && AppManager.getEditMode() != EditMode.REALTIME ) {
#if DEBUG
                PortUtil.println( "FormMain#timer_Tick; stop at C" );
#endif
                timer.stop();
                if ( AppManager.isRepeatMode() ) {
                    AppManager.setPlaying( false );
                    PlaySound.unprepare();
                    AppManager.setCurrentClock( (AppManager.startMarkerEnabled) ? AppManager.startMarker : 0 );
                    AppManager.setPlaying( true );
                } else {
                    AppManager.setPlaying( false );
                    AppManager.setCurrentClock( (AppManager.startMarkerEnabled) ? AppManager.startMarker : 0 );
                    ensureCursorVisible();
                }
            } else {
                AppManager.setCurrentClock( (int)clock );
                if ( AppManager.autoScroll ) {
                    if ( AppManager.editorConfig.CursorFixed ) {
                        float f_draft = clock - (pictPianoRoll.getWidth() / 2 + 34 - 70) * AppManager.getScaleXInv();
                        if ( f_draft < 0f ) {
                            f_draft = 0;
                        }
                        int draft = (int)(f_draft);
                        if ( draft < hScroll.getMinimum() ) {
                            draft = hScroll.getMinimum();
                        } else if ( hScroll.getMaximum() < draft ) {
                            draft = hScroll.getMaximum();
                        }
                        if ( hScroll.getValue() != draft ) {
                            hScroll.setValue( draft );
                        }
                    } else {
                        ensureCursorVisible();
                    }
                }
            }
            refreshScreen();
        }

        public void bgWorkScreen_DoWork( Object sender, BDoWorkEventArgs e ) {
            try {
#if JAVA
                refreshScreenCore( this, new EventArgs() );
#else
                this.Invoke( new EventHandler( this.refreshScreenCore ) );
#endif
            } catch ( Exception ex ) {
                PortUtil.stderr.println( "FormMain#bgWorkScreen_DoWork; ex=" + ex );
            }
        }

#if !JAVA
        public void toolStripEdit_Move( Object sender, EventArgs e ) {
            AppManager.editorConfig.ToolEditTool.Location = new XmlPoint( toolStripTool.getX(), toolStripTool.getY() );
        }

        public void toolStripEdit_ParentChanged( Object sender, EventArgs e ) {
            if ( toolStripTool.getParent() != null ) {
                if ( toolStripTool.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.editorConfig.ToolEditTool.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.editorConfig.ToolEditTool.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        public void toolStripPosition_Move( Object sender, EventArgs e ) {
            AppManager.editorConfig.ToolPositionLocation.Location = new XmlPoint( toolStripPosition.getX(), toolStripPosition.getY() );
        }

        public void toolStripPosition_ParentChanged( Object sender, EventArgs e ) {
            if ( toolStripPosition.Parent != null ) {
                if ( toolStripPosition.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.editorConfig.ToolPositionLocation.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.editorConfig.ToolPositionLocation.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        public void toolStripMeasure_Move( Object sender, EventArgs e ) {
            AppManager.editorConfig.ToolMeasureLocation.Location = new XmlPoint( toolStripMeasure.Location.X, toolStripMeasure.Location.Y );
        }

        public void toolStripMeasure_ParentChanged( Object sender, EventArgs e ) {
            if ( toolStripMeasure.Parent != null ) {
                if ( toolStripMeasure.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.editorConfig.ToolMeasureLocation.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.editorConfig.ToolMeasureLocation.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        void toolStripFile_Move( Object sender, EventArgs e ) {
            AppManager.editorConfig.ToolFileLocation.Location = new XmlPoint( toolStripFile.getX(), toolStripFile.getY() );
        }

        void toolStripFile_ParentChanged( Object sender, EventArgs e ) {
            if ( toolStripFile.Parent != null ) {
                if ( toolStripFile.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.editorConfig.ToolFileLocation.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.editorConfig.ToolFileLocation.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }
#endif

        #region stripBtn*
        public void stripBtnGrid_CheckedChanged( Object sender, EventArgs e ) {
            AppManager.setGridVisible( stripBtnGrid.isSelected() );
        }

        public void stripBtnArrow_Click( Object sender, EventArgs e ) {
            AppManager.setSelectedTool( EditTool.ARROW );
        }

        public void stripBtnPencil_Click( Object sender, EventArgs e ) {
            AppManager.setSelectedTool( EditTool.PENCIL );
        }

        public void stripBtnLine_Click( Object sender, EventArgs e ) {
            AppManager.setSelectedTool( EditTool.LINE );
        }

        public void stripBtnEraser_Click( Object sender, EventArgs e ) {
            AppManager.setSelectedTool( EditTool.ERASER );
        }

        public void stripBtnCurve_Click( Object sender, EventArgs e ) {
            AppManager.setCurveMode( !AppManager.isCurveMode() );
        }

        public void stripBtnPlay_Click( Object sender, EventArgs e ) {
            if ( !AppManager.isPlaying() ) {
                AppManager.setPlaying( true );
            }
            pictPianoRoll.requestFocus();
        }

        public void stripBtnScroll_Click( Object sender, EventArgs e ) {
            stripBtnScroll.setSelected(  !stripBtnScroll.isSelected() );
            AppManager.autoScroll = stripBtnScroll.isSelected();
            pictPianoRoll.requestFocus();
        }

        public void stripBtnLoop_Click( Object sender, EventArgs e ) {
            stripBtnLoop.setSelected( !stripBtnLoop.isSelected() );
            AppManager.setRepeatMode( stripBtnLoop.isSelected() );
            pictPianoRoll.requestFocus();
        }

        public void stripBtnStop_Click( Object sender, EventArgs e ) {
            AppManager.setPlaying( false );
            timer.stop();
            pictPianoRoll.requestFocus();
        }

        public void handleStartMarker_Click( Object sender, EventArgs e ) {
            AppManager.startMarkerEnabled = !AppManager.startMarkerEnabled;
            stripBtnStartMarker.setSelected( AppManager.startMarkerEnabled );
            menuVisualStartMarker.setSelected( AppManager.startMarkerEnabled );
            pictPianoRoll.requestFocus();
            refreshScreen();
        }

        public void handleEndMarker_Click( Object sender, EventArgs e ) {
            AppManager.endMarkerEnabled = !AppManager.endMarkerEnabled;
            stripBtnEndMarker.setSelected( AppManager.endMarkerEnabled );
            menuVisualEndMarker.setSelected( AppManager.endMarkerEnabled );
            pictPianoRoll.requestFocus();
            refreshScreen();
        }

        public void stripBtnMoveEnd_Click( Object sender, EventArgs e ) {
            if ( AppManager.isPlaying() ) {
                AppManager.setPlaying( false );
            }
            AppManager.setCurrentClock( AppManager.getVsqFile().TotalClocks );
            ensureCursorVisible();
            refreshScreen();
        }

        public void stripBtnMoveTop_Click( Object sender, EventArgs e ) {
            if ( AppManager.isPlaying() ) {
                AppManager.setPlaying( false );
            }
            AppManager.setCurrentClock( 0 );
            ensureCursorVisible();
            refreshScreen();
        }

        public void stripBtnRewind_Click( Object sender, EventArgs e ) {
            rewind();
        }

        public void stripBtnForward_Click( Object sender, EventArgs e ) {
            forward();
        }
        #endregion

        public void commonCaptureSpaceKeyDown( Object sender, BKeyEventArgs e ) {
#if JAVA
            if ( (e.KeyValue & KeyEvent.VK_SPACE) == KeyEvent.VK_SPACE ) {
#else
            if ( (e.KeyCode & System.Windows.Forms.Keys.Space) == System.Windows.Forms.Keys.Space ) {
#endif
                m_spacekey_downed = true;
            }
        }

        public void commonCaptureSpaceKeyUp( Object sender, BKeyEventArgs e ) {
#if JAVA
            if ( (e.KeyValue & KeyEvent.VK_SPACE) == KeyEvent.VK_SPACE ) {
#else
            if ( (e.KeyCode & System.Windows.Forms.Keys.Space) == System.Windows.Forms.Keys.Space ) {
#endif
                m_spacekey_downed = false;
            }
        }

        public void commonChangeRenderer( Object sender, EventArgs e ) {
            RendererKind kind = RendererKind.NULL;
            if ( sender == cMenuTrackTabRendererAquesTone || sender == menuTrackRendererAquesTone ) {
                kind = RendererKind.AQUES_TONE;
            } else if ( sender == cMenuTrackTabRendererUtau || sender == menuTrackRendererUtau ) {
                kind = RendererKind.UTAU;
            } else if ( sender == cMenuTrackTabRendererStraight || sender == menuTrackRendererStraight ) {
                kind = RendererKind.STRAIGHT_UTAU;
            } else if ( sender == cMenuTrackTabRendererVOCALOID100 || sender == menuTrackRendererVOCALOID100 ) {
                kind = RendererKind.VOCALOID1_100;
            } else if ( sender == cMenuTrackTabRendererVOCALOID101 || sender == menuTrackRendererVOCALOID101 ) {
                kind = RendererKind.VOCALOID1_101;
            } else if ( sender == cMenuTrackTabRendererVOCALOID2 || sender == menuTrackRendererVOCALOID2 ) {
                kind = RendererKind.VOCALOID2;
            } else {
                return;
            }
            VsqFileEx vsq = AppManager.getVsqFile();
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );
            RendererKind old = VsqFileEx.getTrackRendererKind( vsq_track );
            if ( old != kind ) {
                VsqTrack item = (VsqTrack)vsq_track.clone();
                Vector<VsqID> singers = AppManager.getSingerListFromRendererKind( kind );
                String renderer = AppManager.getVersionStringFromRendererKind( kind );
                if ( singers == null ) {
                    PortUtil.stderr.println( "FormMain#changeRendererCor; singers is null" );
                    return;
                }

                item.changeRenderer( renderer, singers );
                VsqFileEx.setTrackRendererKind( item, kind );
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( selected,
                                                                             item,
                                                                             vsq.AttachedCurves.get( selected - 1 ) );
                AppManager.register( vsq.executeCommand( run ) );
                cMenuTrackTabRendererVOCALOID100.setSelected( kind == RendererKind.VOCALOID1_100 );
                cMenuTrackTabRendererVOCALOID101.setSelected( kind == RendererKind.VOCALOID1_101 );
                cMenuTrackTabRendererVOCALOID2.setSelected( kind == RendererKind.VOCALOID2 );
                cMenuTrackTabRendererUtau.setSelected( kind == RendererKind.UTAU );
                cMenuTrackTabRendererStraight.setSelected( kind == RendererKind.STRAIGHT_UTAU );
                menuTrackRendererVOCALOID100.setSelected( kind == RendererKind.VOCALOID1_100 );
                menuTrackRendererVOCALOID101.setSelected( kind == RendererKind.VOCALOID1_101 );
                menuTrackRendererVOCALOID2.setSelected( kind == RendererKind.VOCALOID2 );
                menuTrackRendererUtau.setSelected( kind == RendererKind.UTAU );
                menuTrackRendererStraight.setSelected( kind == RendererKind.STRAIGHT_UTAU );
                setEdited( true );
                refreshScreen();
            }
        }

        public void commonPlayAfterSynth_Click( Object sender, EventArgs e ) {
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) return;
            int selected = AppManager.getSelected();
            if ( selected < 1 || vsq.Track.size() < selected ) return;
            VsqTrack vsqTrack = vsq.Track.get( selected );
            if ( vsqTrack == null ) return;
            int play_mode = (vsqTrack.getCommon().LastPlayMode == PlayMode.PlayWithSynth) ? PlayMode.PlayAfterSynth : PlayMode.PlayWithSynth;
            int newPlayMode = vsqTrack.isTrackOn() ? play_mode : PlayMode.Off;
            int newLastPlayMode = play_mode;
            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandTrackChangePlayMode( selected, newPlayMode, newLastPlayMode ) );
            AppManager.register( vsq.executeCommand( run ) );
            setEdited( true );

            boolean newStatus = newLastPlayMode == PlayMode.PlayAfterSynth;
            menuTrackPlayAfterSynth.setSelected( newStatus );
            cMenuTrackTabPlayAfterSynth.setSelected( newStatus );
        }

        public void toolStripContainer_TopToolStripPanel_SizeChanged( Object sender, EventArgs e ) {
            if ( getExtendedState() == BForm.ICONIFIED ) {
                return;
            }
            Dimension minsize = getWindowMinimumSize();
            int wid = getWidth();
            int hei = getHeight();
            boolean change_size_required = false;
            if ( minsize.width > wid ) {
                wid = minsize.width;
                change_size_required = true;
            }
            if ( minsize.height > hei ) {
                hei = minsize.height;
                change_size_required = true;
            }
            setMinimumSize( getWindowMinimumSize() );
            if ( change_size_required ) {
                setSize( wid, hei );
            }
        }

#if ENABLE_STRIP_DROPDOWN
        public void stripDDBtnSpeed_DropDownOpening( Object sender, EventArgs e ) {
            if ( AppManager.editorConfig.getRealtimeInputSpeed() == 1.0f ) {
                stripDDBtnSpeed100.setSelected( true );
                stripDDBtnSpeed050.setSelected( false );
                stripDDBtnSpeed033.setSelected( false );
                stripDDBtnSpeedTextbox.setText( "100" );
            } else if ( AppManager.editorConfig.getRealtimeInputSpeed() == 0.5f ) {
                stripDDBtnSpeed100.setSelected( false );
                stripDDBtnSpeed050.setSelected( true );
                stripDDBtnSpeed033.setSelected( false );
                stripDDBtnSpeedTextbox.setText( "50" );
            } else if ( AppManager.editorConfig.getRealtimeInputSpeed() == 1.0f / 3.0f ) {
                stripDDBtnSpeed100.setSelected( false );
                stripDDBtnSpeed050.setSelected( false );
                stripDDBtnSpeed033.setSelected( true );
                stripDDBtnSpeedTextbox.setText( "33.333" );
            } else {
                stripDDBtnSpeed100.setSelected( false );
                stripDDBtnSpeed050.setSelected( false );
                stripDDBtnSpeed033.setSelected( false );
                stripDDBtnSpeedTextbox.setText( (AppManager.editorConfig.getRealtimeInputSpeed() * 100.0f).ToString() );
            }
        }
#endif

#if ENABLE_STRIP_DROPDOWN
        public void stripDDBtnSpeed100_Click( Object sender, EventArgs e ) {
            changeRealtimeInputSpeed( 1.0f );
            AppManager.editorConfig.setRealtimeInputSpeed( 1.0f );
            updateStripDDBtnSpeed();
        }
#endif

#if ENABLE_STRIP_DROPDOWN
        public void stripDDBtnSpeed050_Click( Object sender, EventArgs e ) {
            changeRealtimeInputSpeed( 0.5f );
            AppManager.editorConfig.setRealtimeInputSpeed( 0.5f );
            updateStripDDBtnSpeed();
        }
#endif

#if ENABLE_STRIP_DROPDOWN
        public void stripDDBtnSpeed033_Click( Object sender, EventArgs e ) {
            changeRealtimeInputSpeed( 1.0f / 3.0f );
            AppManager.editorConfig.setRealtimeInputSpeed( 1.0f / 3.0f );
            updateStripDDBtnSpeed();
        }
#endif

#if ENABLE_STRIP_DROPDOWN
        public void stripDDBtnSpeedTextbox_KeyDown( Object sender, BKeyEventArgs e ) {
#if JAVA
            if ( e.KeyValue == KeyEvent.VK_ENTER ) {
#else
            if ( e.KeyCode == System.Windows.Forms.Keys.Enter ) {
#endif
                float v;
                try {
                    v = PortUtil.parseFloat( stripDDBtnSpeedTextbox.getText() );
                    changeRealtimeInputSpeed( v / 100.0f );
                    AppManager.editorConfig.setRealtimeInputSpeed( v / 100.0f );
#if JAVA
                    //TODO: FormMain#stripDDBtnSpeedTextBox_KeyDown
#else
                    stripDDBtnSpeed.HideDropDown();
#endif
                    updateStripDDBtnSpeed();
                } catch ( Exception ex ) {
                    PortUtil.stderr.println( "FormMain#stripDDBtnSpeedTextBox_KeyDown; ex=" + ex );
                }
            }
        }
#endif

        public void menuSetting_DropDownOpening( Object sender, EventArgs e ) {
            menuSettingMidi.setEnabled( AppManager.getEditMode() != EditMode.REALTIME );
        }

        public void menuVisualProperty_Click( Object sender, EventArgs e ) {
#if ENABLE_PROPERTY
            if ( menuVisualProperty.isSelected() ) {
                if ( AppManager.editorConfig.PropertyWindowStatus.WindowState == BFormWindowState.Minimized ) {
                    updatePropertyPanelState( PanelState.Docked );
                } else {
                    updatePropertyPanelState( PanelState.Window );
                }
            } else {
                updatePropertyPanelState( PanelState.Hidden );
            }
#endif
        }

        public void menuSettingUtauVoiceDB_Click( Object sender, EventArgs e ) {
            String edit_oto_ini = PortUtil.combinePath( PortUtil.getApplicationStartupPath(), "EditOtoIni.exe" );
            if ( !PortUtil.isFileExists( edit_oto_ini ) ) {
                return;
            }

#if JAVA
            Runtime r = Runtime.getRuntime();
            try{
                r.exec( "\"" + edit_oto_ini + "\"" );
            }catch( Exception ex ){
            }
#else
            ProcessStartInfo psi = new ProcessStartInfo();
            psi.FileName = Environment.GetEnvironmentVariable( "ComSpec" );
            psi.Arguments = "/c \"" + edit_oto_ini + "\"";
            psi.WindowStyle = ProcessWindowStyle.Hidden;
            psi.CreateNoWindow = true;
            psi.UseShellExecute = false;
            Process.Start( psi );
#endif
        }

        public void menuVisualOverview_CheckedChanged( Object sender, EventArgs e ) {
            AppManager.editorConfig.OverviewEnabled = menuVisualOverview.isSelected();
            updateLayout();
        }

        public void pictOverview_MouseMove( Object sender, BMouseEventArgs e ) {
            int xoffset = AppManager.keyWidth + AppManager.keyOffset;
            if ( m_overview_mouse_down_mode == OverviewMouseDownMode.LEFT ) {
                int draft = getOverviewStartToDrawX( e.X - xoffset );
                if ( draft < 0 ) {
                    draft = 0;
                }
                AppManager.setStartToDrawX( draft );
                refreshScreen();
            } else if ( m_overview_mouse_down_mode == OverviewMouseDownMode.MIDDLE ) {
                int dx = e.X - m_overview_mouse_downed_locationx;
                int draft = m_overview_start_to_draw_clock_initial_value - (int)(dx / m_overview_px_per_clock);
                int key_width = AppManager.keyWidth;
                int clock = getOverviewClockFromXCoord( panelOverview.getWidth() - xoffset, draft );
                if ( AppManager.getVsqFile().TotalClocks < clock ) {
                    draft = AppManager.getVsqFile().TotalClocks - (int)((panelOverview.getWidth() - xoffset) / m_overview_px_per_clock);
                }
                if ( draft < 0 ) {
                    draft = 0;
                }
                m_overview_start_to_draw_clock = draft;
                refreshScreen();
            }
        }

        public void pictOverview_MouseDown( Object sender, BMouseEventArgs e ) {
            BMouseButtons btn = e.Button;
            if ( AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier && m_spacekey_downed && e.Button == BMouseButtons.Left ) {
                btn = BMouseButtons.Middle;
            }
            if ( btn == BMouseButtons.Middle ) {
                m_overview_mouse_down_mode = OverviewMouseDownMode.MIDDLE;
                m_overview_mouse_downed_locationx = e.X;
                m_overview_start_to_draw_clock_initial_value = m_overview_start_to_draw_clock;
            } else if ( e.Button == BMouseButtons.Left ) {
                if ( e.X <= AppManager.keyWidth || panelOverview.getWidth() - 19 <= e.X ) {
                    Point mouse = new Point( e.X, e.Y );
                    if ( isInRect( mouse, getButtonBoundsLeft1() ) ) {
                        btnLeft_MouseDown( null, null );
                        _overviewButtonLeft1MouseDowned = true;
                    } else if ( isInRect( mouse, getButtonBoundsRight1() ) ) {
                        btnLeft_MouseDown( null, null );
                        _overviewButtonRight1MouseDowned = true;
                    } else if ( isInRect( mouse, getButtonBoundsLeft2() ) ) {
                        btnRight_MouseDown( null, null );
                        _overviewButtonLeft2MouseDowned = true;
                    } else if ( isInRect( mouse, getButtonBoundsRight2() ) ) {
                        btnRight_MouseDown( null, null );
                        _overviewButtonRight2MouseDowned = true;
                    } else if ( isInRect( mouse, getButtonBoundsZoom() ) ) {
                        btnZoom_Click( null, null );
                        _overviewButtonZoomMouseDowned = true;
                    } else if ( isInRect( mouse, getButtonBoundsMooz() ) ) {
                        btnMooz_Click( null, null );
                        _overviewButtonMoozMouseDowned = true;
                    }
                    panelOverview.invalidate();
                } else {
                    if ( e.Clicks == 1 ) {
                        m_overview_mouse_down_mode = OverviewMouseDownMode.LEFT;
                        int draft = getOverviewStartToDrawX( e.X - AppManager.keyWidth - AppManager.keyOffset );
                        if ( draft < 0 ) {
                            draft = 0;
                        }
                        AppManager.setStartToDrawX( draft );
                        refreshScreen();
                        return;
                    }
                }
            }
        }

        public void pictOverview_MouseUp( Object sender, BMouseEventArgs e ) {
            Point mouse = new Point( e.X, e.Y );
            if ( isInRect( mouse, getButtonBoundsLeft1() ) ){
                btnLeft_MouseUp( null, null );
            } else if ( isInRect( mouse, getButtonBoundsRight1() ) ) {
                btnLeft_MouseUp( null, null );
            } else if ( isInRect( mouse, getButtonBoundsLeft2() ) ){
                btnRight_MouseUp( null, null );
            } else if ( isInRect( mouse, getButtonBoundsRight2() ) ) {
                btnRight_MouseUp( null, null );
            }
            _overviewButtonLeft1MouseDowned = false;
            _overviewButtonLeft2MouseDowned = false;
            _overviewButtonRight1MouseDowned = false;
            _overviewButtonRight2MouseDowned = false;
            _overviewButtonZoomMouseDowned = false;
            _overviewButtonMoozMouseDowned = false;
            if ( m_overview_mouse_down_mode == OverviewMouseDownMode.LEFT ) {
                AppManager.setStartToDrawX( calculateStartToDrawX() );
            }
            m_overview_mouse_down_mode = OverviewMouseDownMode.NONE;
            refreshScreen();
        }

        public void pictOverview_Paint( Object sender, BPaintEventArgs e ) {
#if JAVA
            Graphics2D g = (Graphics2D)e.Graphics;
#else
            Graphics2D g = new org.kbinani.java.awt.Graphics2D( e.Graphics );
#endif
            int count = 0;
            int sum = 0;
            int height = panelOverview.getHeight();
            BasicStroke pen = new java.awt.BasicStroke( _OVERVIEW_DOT_DIAM );
            g.setStroke( pen );
            g.setColor( s_note_fill );
            int xoffset = AppManager.keyWidth + AppManager.keyOffset;
            for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getNoteEventIterator(); itr.hasNext(); ) {
                VsqEvent item = itr.next();
                int x = getOverviewXCoordFromClock( item.Clock );
                if ( x < 0 ) {
                    continue;
                }
                if ( panelOverview.getWidth() - AppManager.keyWidth < x ) {
                    break;
                }
                count++;
                sum += item.ID.Note;
                int y = height - (height / 2 + (int)((item.ID.Note - m_overview_average_note) * _OVERVIEW_DOT_DIAM));
                int length = (int)(item.ID.getLength() * m_overview_px_per_clock);
                if ( length < _OVERVIEW_DOT_DIAM ) {
                    length = _OVERVIEW_DOT_DIAM;
                }
                g.drawLine( x + xoffset, y, x + length + xoffset, y );
            }
            g.setStroke( new BasicStroke() );
            //}
            int current_start = AppManager.clockFromXCoord( AppManager.keyWidth );
            int current_end = AppManager.clockFromXCoord( pictPianoRoll.getWidth() );
            int x_start = getOverviewXCoordFromClock( current_start );
            int x_end = getOverviewXCoordFromClock( current_end );

            // 小節ごとの線
            int clock_start = getOverviewClockFromXCoord( 0 );
            int clock_end = getOverviewClockFromXCoord( panelOverview.getWidth() - AppManager.keyWidth );
            int premeasure = AppManager.getVsqFile().getPreMeasure();
            g.setClip( null );
            BasicStroke pen_bold = new java.awt.BasicStroke( 2 );
            Color pen_color = new java.awt.Color( 0, 0, 0, 130 );

            int barcountx = 0;
            String barcountstr = "";
            for ( Iterator<VsqBarLineType> itr = AppManager.getVsqFile().getBarLineIterator( clock_end * 3 / 2 ); itr.hasNext(); ) {
                VsqBarLineType bar = itr.next();
                if ( bar.clock() < clock_start ) {
                    continue;
                }
                if ( panelOverview.getWidth() - AppManager.keyWidth < barcountx ) {
                    break;
                }
                if ( bar.isSeparator() ) {
                    int barcount = bar.getBarCount() - premeasure + 1;
                    int x = getOverviewXCoordFromClock( bar.clock() );
                    if ( (barcount % 5 == 0 && barcount > 0) || barcount == 1 ) {
                        g.setColor( pen_color );
                        g.setStroke( pen_bold );
                        g.drawLine( x + xoffset, 0, x + xoffset, panelOverview.getHeight() );

                        g.setStroke( new BasicStroke() );
                        if ( !barcountstr.Equals( "" ) ) {
                            g.setColor( Color.white );
                            g.setFont( AppManager.baseFont9 );
                            g.drawString( barcountstr, barcountx + 1 + xoffset, 1 + AppManager.baseFont9Height / 2 - AppManager.baseFont9OffsetHeight + 1 );
                        }
                        barcountstr = barcount + "";
                        barcountx = x;
                    } else {
                        g.setColor( pen_color );
                        g.drawLine( x + xoffset, 0, x + xoffset, panelOverview.getHeight() );
                    }
                }
            }
            g.setClip( null );

            // 移動中している最中に，移動開始直前の部分を影付で表示する
            int stdx = AppManager.getStartToDrawX();
            int act_start_to_draw_x = (int)(hScroll.getValue() * AppManager.getScaleX());
            if ( act_start_to_draw_x != stdx ) {
                int act_start_clock = AppManager.clockFromXCoord( AppManager.keyWidth - stdx + act_start_to_draw_x );
                int act_end_clock = AppManager.clockFromXCoord( pictPianoRoll.getWidth() - stdx + act_start_to_draw_x );
                int act_start_x = getOverviewXCoordFromClock( act_start_clock );
                int act_end_x = getOverviewXCoordFromClock( act_end_clock );
                Rectangle rcm = new Rectangle( act_start_x, 0, act_end_x - act_start_x, height );
                g.setColor( new Color( 0, 0, 0, 100 ) );
                g.fillRect( rcm.x + xoffset, rcm.y, rcm.width, rcm.height );
            }

            // 現在の表示範囲
            Rectangle rc = new Rectangle( x_start, 0, x_end - x_start, height - 1 );
            g.setColor( new Color( 255, 255, 255, 50 ) );
            g.fillRect( rc.x + xoffset, rc.y, rc.width, rc.height );
            g.setColor( AppManager.getHilightColor() );
            g.drawRect( rc.x + xoffset, rc.y, rc.width, rc.height );
            if ( count > 0 ) {
                m_overview_average_note = sum / (float)count;
            }

            // ソングポジション
            int px_current_clock = (int)((AppManager.getCurrentClock() - m_overview_start_to_draw_clock) * m_overview_px_per_clock);
            g.setStroke( new BasicStroke( 2 ) );
            g.setColor( Color.white );
            g.drawLine( px_current_clock + xoffset, 0, px_current_clock + xoffset, panelOverview.getHeight() );
            g.setStroke( new BasicStroke() );

            int btn_width = 16;
            // 左側のボタン類
            g.setStroke( getStrokeDefault() );
            g.setColor( Color.lightGray );
            g.fillRect( 0, 0, AppManager.keyWidth, panelOverview.getHeight() );
            g.setColor( AppManager.COLOR_BORDER );
            // zoomボタン
            rc = getButtonBoundsZoom();
            g.setColor( _overviewButtonZoomMouseDowned ? Color.gray : Color.lightGray );
            g.fillRect( rc.x, rc.y, rc.width, rc.height );
            g.setColor( AppManager.COLOR_BORDER );
            g.drawRect( rc.x, rc.y, rc.width, rc.height );
            int centerx = rc.x + rc.width / 2 + 1;
            int centery = rc.y + rc.height / 2 + 1;
            g.setColor( _overviewButtonZoomMouseDowned ? Color.lightGray : Color.gray );
            g.setStroke( getStroke2px() );
            g.drawLine( centerx - 4, centery, centerx + 4, centery );
            g.drawLine( centerx, centery - 4, centerx, centery + 4 );
            g.setStroke( getStrokeDefault() );
            // moozボタン
            rc = getButtonBoundsMooz();
            g.setColor( _overviewButtonMoozMouseDowned ? Color.gray : Color.lightGray );
            g.fillRect( rc.x, rc.y, rc.width, rc.height );
            g.setColor( AppManager.COLOR_BORDER );
            g.drawRect( rc.x, rc.y, rc.width, rc.height );
            centerx = rc.x + rc.width / 2 + 1;
            centery = rc.y + rc.height / 2 + 1;
            g.setColor( _overviewButtonMoozMouseDowned ? Color.lightGray : Color.gray );
            g.setStroke( getStroke2px() );
            g.drawLine( centerx - 4, centery, centerx + 4, centery );
            g.setStroke( getStrokeDefault() );
            // left1ボタン
            rc = getButtonBoundsLeft1();
            g.setColor( _overviewButtonLeft1MouseDowned ? Color.gray : Color.lightGray );
            g.fillRect( rc.x, rc.y, rc.width, rc.height );
            g.setColor( AppManager.COLOR_BORDER );
            g.drawRect( rc.x, rc.y, rc.width, rc.height );
            centerx = rc.x + rc.width / 2 + 1;
            centery = rc.y + rc.height / 2 + 1;
            g.setColor( _overviewButtonLeft1MouseDowned ? Color.lightGray : Color.gray );
            g.drawPolyline( new int[] { centerx + 4, centerx - 4, centerx + 4 }, new int[] { centery - 4, centery, centery + 4 }, 3 );
            // left2ボタン
            rc = getButtonBoundsLeft2();
            g.setColor( _overviewButtonLeft2MouseDowned ? Color.gray : Color.lightGray );
            g.fillRect( rc.x, rc.y, rc.width, rc.height );
            g.setColor( AppManager.COLOR_BORDER );
            g.drawRect( rc.x, rc.y, rc.width, rc.height );
            centerx = rc.x + rc.width / 2 + 1;
            centery = rc.y + rc.height / 2 + 1;
            g.setColor( _overviewButtonLeft2MouseDowned ? Color.lightGray : Color.gray );
            g.drawPolyline( new int[] { centerx - 4, centerx + 4, centerx - 4 }, new int[] { centery - 4, centery, centery + 4 }, 3 );

            // 右側のボタン類
            g.setColor( Color.lightGray );
            g.fillRect( panelOverview.getWidth() - btn_width - 3, 0, btn_width + 3, panelOverview.getHeight() );
            // right1ボタン
            rc = getButtonBoundsRight1();
            g.setColor( _overviewButtonRight1MouseDowned ? Color.gray : Color.lightGray );
            g.fillRect( rc.x, rc.y, rc.width, rc.height );
            g.setColor( AppManager.COLOR_BORDER );
            g.drawRect( rc.x, rc.y, rc.width, rc.height );
            centerx = rc.x + rc.width / 2 + 1;
            centery = rc.y + rc.height / 2 + 1;
            g.setColor( _overviewButtonRight1MouseDowned ? Color.lightGray : Color.gray );
            g.drawPolyline( new int[] { centerx + 4, centerx - 4, centerx + 4 }, new int[] { centery - 4, centery, centery + 4 }, 3 );
            // right2ボタン
            rc = getButtonBoundsRight2();
            g.setColor( _overviewButtonRight2MouseDowned ? Color.gray : Color.lightGray );
            g.fillRect( rc.x, rc.y, rc.width, rc.height );
            g.setColor( AppManager.COLOR_BORDER );
            g.drawRect( rc.x, rc.y, rc.width, rc.height );
            centerx = rc.x + rc.width / 2 + 1;
            centery = rc.y + rc.height / 2 + 1;
            g.setColor( _overviewButtonRight2MouseDowned ? Color.lightGray : Color.gray );
            g.drawPolyline( new int[] { centerx - 4, centerx + 4, centerx - 4 }, new int[] { centery - 4, centery, centery + 4 }, 3 );
        }

        /// <summary>
        /// btnLeft1の描画位置を取得します
        /// </summary>
        /// <returns></returns>
        private Rectangle getButtonBoundsLeft1() {
            return new Rectangle( AppManager.keyWidth - 16 - 2, 1, 16, 26 );
        }

        /// <summary>
        /// btnLeft2の描画位置を取得します
        /// </summary>
        /// <returns></returns>
        private Rectangle getButtonBoundsLeft2() {
            return new Rectangle( AppManager.keyWidth - 16 - 2, 26 + 3, 16, 19 );
        }

        /// <summary>
        /// btnRight1の描画位置を取得します
        /// </summary>
        /// <returns></returns>
        private Rectangle getButtonBoundsRight1() {
            return new Rectangle( panelOverview.getWidth() - 16 - 2, 1, 16, 19 );
        }

        /// <summary>
        /// btnRight2の描画位置を取得します
        /// </summary>
        /// <returns></returns>
        private Rectangle getButtonBoundsRight2() {
            return new Rectangle( panelOverview.getWidth() - 16 - 2, 19 + 3, 16, 26 );
        }

        /// <summary>
        /// Zoomボタンの描画位置を取得します
        /// </summary>
        /// <returns></returns>
        private Rectangle getButtonBoundsZoom() {
            return new Rectangle( AppManager.keyWidth - 16 - 2 - 24, 13, 22, 23 );
        }

        /// <summary>
        /// Moozボタンの描画位置を取得します
        /// </summary>
        /// <returns></returns>
        private Rectangle getButtonBoundsMooz() {
            return new Rectangle( AppManager.keyWidth - 16 - 2 - 48, 13, 22, 23 );
        }

        public void pictOverview_MouseDoubleClick( Object sender, BMouseEventArgs e ) {
            if ( AppManager.keyWidth < e.X && e.X < panelOverview.getWidth() - 19 ) {
                m_overview_mouse_down_mode = OverviewMouseDownMode.NONE;
                int draft_stdx = getOverviewStartToDrawX( e.X - AppManager.keyWidth - AppManager.keyOffset );
                int draft = (int)(draft_stdx * AppManager.getScaleXInv());
                if ( draft < hScroll.getMinimum() ) {
                    draft = hScroll.getMinimum();
                } else if ( hScroll.getMaximum() < draft ) {
                    draft = hScroll.getMaximum();
                }
                hScroll.setValue( draft );
                refreshScreen();
            }
        }

        public void btnLeft_MouseDown( Object sender, BMouseEventArgs e ) {
            m_overview_btn_downed = PortUtil.getCurrentTime();
            m_overview_start_to_draw_clock_initial_value = m_overview_start_to_draw_clock;
            if ( m_overview_update_thread != null ) {
                try {
#if JAVA
                    m_overview_update_thread.stop();
                    while( m_overview_update_thread.isAlive() ){
                        Thread.sleep( 0 );
                    }
#else
                    m_overview_update_thread.Abort();
                    while ( m_overview_update_thread.IsAlive ) {
                        System.Windows.Forms.Application.DoEvents();
                    }
#endif
                } catch ( Exception ex ) {
                    PortUtil.stderr.println( "FormMain#btnLeft_MouseDown; ex=" + ex );
                }
                m_overview_update_thread = null;
            }
            m_overview_direction = -1;
#if JAVA
            m_overview_update_thread = new UpdateOverviewProc();
            m_overview_update_thread.start();
#else
            m_overview_update_thread = new Thread( new ThreadStart( this.updateOverview ) );
            m_overview_update_thread.Start();
#endif
        }

        public void btnLeft_MouseUp( Object sender, BMouseEventArgs e ) {
            overviewStopThread();
        }

        public void btnRight_MouseDown( Object sender, BMouseEventArgs e ) {
            m_overview_btn_downed = PortUtil.getCurrentTime();
            m_overview_start_to_draw_clock_initial_value = m_overview_start_to_draw_clock;
            if ( m_overview_update_thread != null ) {
                try {
#if JAVA
                    while( m_overview_update_thread.isAlive() ){
                        Thread.sleep( 0 );
                    }
#else
                    while ( m_overview_update_thread.IsAlive ) {
                        System.Windows.Forms.Application.DoEvents();
                    }
#endif
                } catch ( Exception ex ) {
                    PortUtil.stderr.println( "FormMain#btnRight_MouseDown; ex=" + ex );
                }
                m_overview_update_thread = null;
            }
            m_overview_direction = 1;
#if JAVA
            m_overview_update_thread = new UpdateOverviewProc();
            m_overview_update_thread.start();
#else
            m_overview_update_thread = new Thread( new ThreadStart( this.updateOverview ) );
            m_overview_update_thread.Start();
#endif
        }

        public void btnRight_MouseUp( Object sender, BMouseEventArgs e ) {
            overviewStopThread();
        }

        public void btnMooz_Click( Object sender, EventArgs e ) {
            int draft = m_overview_scale_count - 1;
            if ( draft < _OVERVIEW_SCALE_COUNT_MIN ) {
                draft = _OVERVIEW_SCALE_COUNT_MIN;
            }
            m_overview_scale_count = draft;
            m_overview_px_per_clock = getOverviewScaleX( m_overview_scale_count );
            AppManager.editorConfig.OverviewScaleCount = m_overview_scale_count;
            refreshScreen();
        }

        public void btnZoom_Click( Object sender, EventArgs e ) {
            int draft = m_overview_scale_count + 1;
            if ( _OVERVIEW_SCALE_COUNT_MAX < draft ) {
                draft = _OVERVIEW_SCALE_COUNT_MAX;
            }
            m_overview_scale_count = draft;
            m_overview_px_per_clock = getOverviewScaleX( m_overview_scale_count );
            AppManager.editorConfig.OverviewScaleCount = m_overview_scale_count;
            refreshScreen();
        }

        public void handleBgmOffsetSeconds_Click( Object sender, EventArgs e ) {
            if ( !(sender is BMenuItem) ) {
                return;
            }
            BMenuItem parent = (BMenuItem)sender;
            if ( parent.getTag() == null ) {
                return;
            }
            if ( !(parent.getTag() is Integer) ) {
                return;
            }
            int index = (Integer)parent.getTag();
            InputBox ib = null;
            try {
                ib = new InputBox( _( "Input Offset Seconds" ) );
                ib.setLocation( getFormPreferedLocation( ib ) );
                ib.setResult( AppManager.getBgm( index ).readOffsetSeconds + "" );
                ib.setModal( true );
                ib.setVisible( true );
                if ( ib.getDialogResult() != BDialogResult.OK ) {
                    return;
                }
                Vector<BgmFile> list = new Vector<BgmFile>();
                int count = AppManager.getBgmCount();
                BgmFile item = null;
                for ( int i = 0; i < count; i++ ) {
                    if ( i == index ) {
                        item = (BgmFile)AppManager.getBgm( i ).clone();
                        list.add( item );
                    } else {
                        list.add( AppManager.getBgm( i ) );
                    }
                }
                double draft;
                try {
                    draft = PortUtil.parseDouble( ib.getResult() );
                    item.readOffsetSeconds = draft;
                    parent.setToolTipText( draft + " " + _( "seconds" ) );
                } catch ( Exception ex3 ) {
                }
                CadenciiCommand run = VsqFileEx.generateCommandBgmUpdate( list );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
            } catch ( Exception ex ) {
            } finally {
                if ( ib != null ) {
                    try {
#if !JAVA
                        ib.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        public void handleBgmStartAfterPremeasure_CheckedChanged( Object sender, EventArgs e ) {
            if ( !(sender is BMenuItem) ) {
                return;
            }
            BMenuItem parent = (BMenuItem)sender;
            if ( parent.getTag() == null ) {
                return;
            }
            if ( !(parent.getTag() is Integer) ) {
                return;
            }
            int index = (Integer)parent.getTag();
            Vector<BgmFile> list = new Vector<BgmFile>();
            int count = AppManager.getBgmCount();
            for ( int i = 0; i < count; i++ ) {
                if ( i == index ) {
                    BgmFile item = (BgmFile)AppManager.getBgm( i ).clone();
                    item.startAfterPremeasure = parent.isSelected();
                    list.add( item );
                } else {
                    list.add( AppManager.getBgm( i ) );
                }
            }
            CadenciiCommand run = VsqFileEx.generateCommandBgmUpdate( list );
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
            setEdited( true );
        }

        public void handleBgmAdd_Click( Object sender, EventArgs e ) {
            if ( openWaveDialog.showOpenDialog( this ) != BFileChooser.APPROVE_OPTION ) {
                return;
            }

            String file = openWaveDialog.getSelectedFile();

            // 既に開かれていたらキャンセル
            int count = AppManager.getBgmCount();
            boolean found = false;
            for ( int i = 0; i < count; i++ ) {
                BgmFile item = AppManager.getBgm( i );
                if ( file.Equals( item.file ) ) {
                    found = true;
                    break;
                }
            }
            if ( found ) {
                AppManager.showMessageBox( PortUtil.formatMessage( _( "file '{0}' is already registered as BGM." ), file ),
                                 _( "Error" ),
                                 org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION,
                                 org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                return;
            }

            // 登録
            AppManager.addBgm( file );
            setEdited( true );
            updateBgmMenuState();
        }

        public void handleBgmRemove_Click( Object sender, EventArgs e ) {
            if ( !(sender is BMenuItem) ) {
                return;
            }
            BMenuItem parent = (BMenuItem)sender;
            if ( parent.getTag() == null ) {
                return;
            }
            if ( !(parent.getTag() is Integer) ) {
                return;
            }
            int index = (Integer)parent.getTag();
            BgmFile bgm = AppManager.getBgm( index );
            if ( AppManager.showMessageBox( PortUtil.formatMessage( _( "remove '{0}'?" ), bgm.file ),
                                  "Cadencii",
                                  org.kbinani.windows.forms.Utility.MSGBOX_YES_NO_OPTION,
                                  org.kbinani.windows.forms.Utility.MSGBOX_QUESTION_MESSAGE ) != BDialogResult.YES ) {
                return;
            }
            AppManager.removeBgm( index );
            setEdited( true );
            updateBgmMenuState();
        }

        public void commonSettingPaletteTool( Object sender, EventArgs e ) {
#if ENABLE_SCRIPT
            if ( sender is BMenuItem ) {
                BMenuItem tsmi = (BMenuItem)sender;
                if ( tsmi.getTag() != null && tsmi.getTag() is String ) {
                    String id = (String)tsmi.getTag();
                    if ( PaletteToolServer.loadedTools.containsKey( id ) ) {
                        Object instance = PaletteToolServer.loadedTools.get( id );
                        IPaletteTool ipt = (IPaletteTool)instance;
                        if ( ipt.openDialog() == System.Windows.Forms.DialogResult.OK ) {
                            XmlSerializer xsms = new XmlSerializer( instance.GetType(), true );
                            String dir = PortUtil.combinePath( Utility.getApplicationDataPath(), "tool" );
                            if ( !PortUtil.isDirectoryExists( dir ) ) {
                                PortUtil.createDirectory( dir );
                            }
                            String cfg = id + ".config";
                            String config = PortUtil.combinePath( dir, cfg );
                            FileOutputStream fs = null;
                            try {
                                fs = new FileOutputStream( config );
                                xsms.serialize( fs, null );
                            } catch ( Exception ex ) {
                            } finally {
                                if ( fs != null ) {
                                    try {
                                        fs.close();
                                    } catch ( Exception ex2 ) {
                                    }
                                }
                            }
                        }
                    }
                }
            }
#endif
        }

#if ENABLE_MTC
        /// <summary>
        /// MTC用のMIDI-INデバイスからMIDIを受信します。
        /// </summary>
        /// <param name="now"></param>
        /// <param name="dataArray"></param>
        private void handleMtcMidiReceived( double now, byte[] dataArray ) {
            byte data = (byte)(dataArray[1] & 0x0f);
            byte type = (byte)((dataArray[1] >> 4) & 0x0f);
            if ( type == 0 ) {
                mtcFrameLsb = data;
            } else if ( type == 1 ) {
                mtcFrameMsb = data;
            } else if ( type == 2 ) {
                mtcSecLsb = data;
            } else if ( type == 3 ) {
                mtcSecMsb = data;
            } else if ( type == 4 ) {
                mtcMinLsb = data;
            } else if ( type == 5 ) {
                mtcMinMsb = data;
            } else if ( type == 6 ) {
                mtcHourLsb = data;
            } else if ( type == 7 ) {
                mtcHourMsb = (byte)(data & 1);
                int fpsType = (data & 6) >> 1;
                double fps = 30.0;
                if ( fpsType == 0 ) {
                    fps = 24.0;
                } else if ( fpsType == 1 ) {
                    fps = 25;
                } else if ( fpsType == 2 ) {
                    fps = 30000.0 / 1001.0;
                } else if ( fpsType == 3 ) {
                    fps = 30.0;
                }
                int hour = (mtcHourMsb << 4 | mtcHourLsb);
                int min = (mtcMinMsb << 4 | mtcMinLsb);
                int sec = (mtcSecMsb << 4 | mtcSecLsb);
                int frame = (mtcFrameMsb << 4 | mtcFrameLsb) + 2;
                double time = (hour * 60.0 + min) * 60.0 + sec + frame / fps;
                mtcLastReceived = now;
#if DEBUG
                int clock = (int)AppManager.getVsqFile().getClockFromSec( time );
                AppManager.setCurrentClock( clock );
#endif
                /*if ( !AppManager.isPlaying() ) {
                    AppManager.setEditMode( EditMode.REALTIME_MTC );
                    AppManager.setPlaying( true );
                    EventHandler handler = new EventHandler( AppManager_PreviewStarted );
                    if ( handler != null ) {
                        this.Invoke( handler );
                        while ( VSTiProxy.getPlayTime() <= 0.0 ) {
                            System.Windows.Forms.Application.DoEvents();
                        }
                        AppManager.setPlaying( true );
                    }
                }*/
#if DEBUG
                PortUtil.println( "FormMain#handleMtcMidiReceived; time=" + time );
#endif
            }
        }
#endif

#if ENABLE_MIDI
        public void m_midi_in_MidiReceived( double time, byte[] data ) {
#if !JAVA
            if ( data.Length <= 2 ) {
                return;
            }
            if ( !AppManager.isPlaying() ) {
                return;
            }
            int code = data[0] & 0xf0;
#if DEBUG
            AppManager.debugWriteLine( "m_midi_in_MidiReceived" );
            AppManager.debugWriteLine( "    code=0x" + Convert.ToString( code, 16 ) );
#endif
            if ( code != 0x80 && code != 0x90 ) {
                return;
            }
            if ( code == 0x90 && data[2] == 0x00 ) {
                code = 0x80;//ベロシティ0のNoteOnはNoteOff
            }

            byte note = data[1];
            if ( code == 0x90 && AppManager.getEditMode() == EditMode.REALTIME ) {
                MidiPlayer.PlayImmediate( note );
            }

            int clock = AppManager.getCurrentClock();
            int unit = AppManager.getPositionQuantizeClock();
            if ( unit > 1 ) {
                clock = doQuantize( clock, unit );
            }

            if ( code == 0x80 ) {
                if ( AppManager.addingEvent != null ) {
                    int len = clock - AppManager.addingEvent.Clock;
                    if ( len <= 0 ) {
                        len = unit;
                    }
                    AppManager.addingEvent.ID.Length = len;
                    int selected = AppManager.getSelected();
                    CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventAdd( selected,
                                                                                                   AppManager.addingEvent ) );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    if ( !isEdited() ) {
                        setEdited( true );
                    }
                    updateDrawObjectList();
                }
            } else if ( code == 0x90 ) {
                AppManager.addingEvent = new VsqEvent( clock, new VsqID( 0 ) );
                AppManager.addingEvent.ID.type = VsqIDType.Anote;
                AppManager.addingEvent.ID.Dynamics = 64;
                AppManager.addingEvent.ID.VibratoHandle = null;
                AppManager.addingEvent.ID.LyricHandle = new LyricHandle( "a", "a" );
                AppManager.addingEvent.ID.Note = note;
                if ( AppManager.getEditMode() != EditMode.REALTIME ) {
                    KeySoundPlayer.play( note );
                }
            }
#endif
        }
#endif

        /// <summary>
        /// 現在のゲームコントローラのモードに応じてstripLblGameCtrlModeの表示状態を更新します。
        /// </summary>
        public void updateGameControlerStatus( Object sender, EventArgs e ) {
#if !JAVA
            if ( m_game_mode == GameControlMode.DISABLED ) {
                stripLblGameCtrlMode.setText( _( "Disabled" ) );
                stripLblGameCtrlMode.setIcon( new ImageIcon( Resources.get_slash() ) );
            } else if ( m_game_mode == GameControlMode.CURSOR ) {
                stripLblGameCtrlMode.setText( _( "Cursor" ) );
                stripLblGameCtrlMode.setIcon( null );
            } else if ( m_game_mode == GameControlMode.KEYBOARD ) {
                stripLblGameCtrlMode.setText( _( "Keyboard" ) );
                stripLblGameCtrlMode.setIcon( new ImageIcon( Resources.get_piano() ) );
            } else if ( m_game_mode == GameControlMode.NORMAL ) {
                stripLblGameCtrlMode.setText( _( "Normal" ) );
                stripLblGameCtrlMode.setIcon( null );
            }
#endif
        }

#if ENABLE_SCRIPT
        public void handleScriptMenuItem_Click( Object sender, EventArgs e ) {

            try {
                String dir = Utility.getScriptPath();
                String id = (String)((BMenuItem)sender).getTag();
                String script_file = PortUtil.combinePath( dir, id );
                if ( ScriptServer.getTimestamp( id ) != PortUtil.getFileLastModified( script_file ) ) {
                    ScriptServer.reload( id );
                }
                if ( ScriptServer.isAvailable( id ) ) {
                    if ( ScriptServer.invokeScript( id, AppManager.getVsqFile() ) ) {
                        setEdited( true );
                        updateDrawObjectList();
                        refreshScreen();
                    }
                } else {
                    FormCompileResult dlg = null;
                    try {
                        dlg = new FormCompileResult( _( "Failed loading script." ), ScriptServer.getCompileMessage( id ) );
                        dlg.setModal( true );
                        dlg.setVisible( true );
                    } catch ( Exception ex ) {
                    } finally {
                        if ( dlg != null ) {
                            try {
                                dlg.close();
                            } catch ( Exception ex2 ) {
                            }
                        }
                    }
                }
            } catch ( Exception ex3 ) {
#if DEBUG
                PortUtil.println( "AppManager#dd_run_Click; ex3=" + ex3 );
#endif
            }
        }
#endif

        public void refreshScreenCore( Object sender, EventArgs e ) {
#if MONITOR_FPS
            double t0 = PortUtil.getCurrentTime();
#endif
            pictPianoRoll.repaint();
            picturePositionIndicator.repaint();
            trackSelector.repaint();
            if ( menuVisualWaveform.isSelected() ) {
                waveView.repaint();
            }
            if ( AppManager.editorConfig.OverviewEnabled ) {
                panelOverview.repaint();
            }
#if MONITOR_FPS
            double t = PortUtil.getCurrentTime();
            mFpsDrawTime[mFpsDrawTimeIndex] = t;
            mFpsDrawTime2[mFpsDrawTimeIndex] = t - t0;

            mFpsDrawTimeIndex++;
            if ( mFpsDrawTimeIndex >= mFpsDrawTime.Length ) {
                mFpsDrawTimeIndex = 0;
            }
            mFps = (float)(mFpsDrawTime.Length / (t - mFpsDrawTime[mFpsDrawTimeIndex]));

            int cnt = 0;
            double sum = 0.0;
            for ( int i = 0; i < mFpsDrawTime2.Length; i++ ) {
                double v = mFpsDrawTime2[i];
                if ( v > 0.0f ) {
                    cnt++;
                }
                sum += v;
            }
            mFps2 = (float)(cnt / sum);
#endif
        }

        public void pictKeyLengthSplitter_MouseDown( Object sender, BMouseEventArgs e ) {
            m_key_length_splitter_mouse_downed = true;
            m_key_length_splitter_initial_mouse = PortUtil.getMousePosition();
            m_key_length_init_value = AppManager.keyWidth;
            m_key_length_trackselector_rowspercolumn = trackSelector.getRowsPerColumn();
            m_key_length_splitter_distance = splitContainer1.getDividerLocation();
        }

        public void pictKeyLengthSplitter_MouseMove( Object sender, BMouseEventArgs e ) {
#if DEBUG
            PortUtil.println( "FormMain#pictKeyLengthSplitter_MouseMove" );
#endif
            if ( !m_key_length_splitter_mouse_downed ) {
                return;
            }
            int dx = PortUtil.getMousePosition().x - m_key_length_splitter_initial_mouse.x;
            int draft = m_key_length_init_value + dx;
            if ( draft < AppManager.MIN_KEY_WIDTH ) {
                draft = AppManager.MIN_KEY_WIDTH;
            } else if ( AppManager.MAX_KEY_WIDTH < draft ) {
                draft = AppManager.MAX_KEY_WIDTH;
            }
            AppManager.keyWidth = draft;
            int current = trackSelector.getRowsPerColumn();
            if ( current >= m_key_length_trackselector_rowspercolumn ) {
                int max_divider_location = splitContainer1.getHeight() - splitContainer1.getDividerSize() - splitContainer1.getPanel2MinSize();
                if ( max_divider_location < m_key_length_splitter_distance ) {
                    splitContainer1.setDividerLocation( max_divider_location );
                } else {
                    splitContainer1.setDividerLocation( m_key_length_splitter_distance );
                }
            }
            updateLayout();
            refreshScreen();
        }

        public void pictKeyLengthSplitter_MouseUp( Object sender, BMouseEventArgs e ) {
            m_key_length_splitter_mouse_downed = false;
        }

        public void overviewCommon_MouseLeave( Object sender, EventArgs e ) {
            overviewStopThread();
        }

        public void menuTrackManager_Click( Object sender, EventArgs e ) {

        }

#if !JAVA
        private void FormMain_DragLeave( object sender, EventArgs e ) {
            AppManager.setEditMode( EditMode.NONE );
            iconPaletteOnceDragEntered = false;
        }
#endif

#if !JAVA
        private void FormMain_DragOver( object sender, System.Windows.Forms.DragEventArgs e ) {
            if ( AppManager.getEditMode() != EditMode.DRAG_DROP ) {
                return;
            }
            Point pt = pictPianoRoll.getLocationOnScreen();
            if ( !iconPaletteOnceDragEntered ) {
                int keywidth = AppManager.keyWidth;
                Rectangle rc = new Rectangle( pt.x + keywidth, pt.y, pictPianoRoll.getWidth() - keywidth, pictPianoRoll.getHeight() );
                if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                    iconPaletteOnceDragEntered = true;
                } else {
                    return;
                }
            }
            BMouseEventArgs e0 = new BMouseEventArgs( BMouseButtons.Left,
                                                      1,
                                                      e.X - pt.x,
                                                      e.Y - pt.y,
                                                      0 );
            pictPianoRoll_MouseMove( this, e0 );
        }
#endif

#if !JAVA
        private void FormMain_DragDrop( object sender, System.Windows.Forms.DragEventArgs e ) {
            AppManager.setEditMode( EditMode.NONE );
            iconPaletteOnceDragEntered = false;
            m_mouse_downed = false;
            if ( !e.Data.GetDataPresent( typeof( IconDynamicsHandle ) ) ) {
                return;
            }
            Point locPianoroll = pictPianoRoll.getLocationOnScreen();
            int keywidth = AppManager.keyWidth;
            Rectangle rcPianoroll = new Rectangle( locPianoroll.x + keywidth,
                                                   locPianoroll.y,
                                                   pictPianoRoll.getWidth() - keywidth,
                                                   pictPianoRoll.getHeight() );
            if ( !isInRect( new Point( e.X, e.Y ), rcPianoroll ) ) {
                return;
            }

            // dynaff, crescend, decrescend のどれがドロップされたのか検査
            IconDynamicsHandle this_is_it = (IconDynamicsHandle)e.Data.GetData( typeof( IconDynamicsHandle ) );
            if ( this_is_it == null ) {
                return;
            }

            // ドロップ位置を特定して，アイテムを追加する
            int x = e.X - locPianoroll.x;
            int y = e.Y - locPianoroll.y;
            int clock1 = AppManager.clockFromXCoord( x );

            // クオンタイズの処理
            int unit = AppManager.getPositionQuantizeClock();
            int clock = doQuantize( clock1, unit );

            int note = AppManager.noteFromYCoord( y );
            VsqFileEx vsq = AppManager.getVsqFile();
            int clockAtPremeasure = vsq.getPreMeasureClocks();
            if ( clock < clockAtPremeasure ) {
                return;
            }
            if ( note < 0 || 128 < note ) {
                return;
            }

            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );
            VsqTrack work = (VsqTrack)vsq_track.clone();

            if ( AppManager.addingEvent == null ) {
                // ここは多分起こらない
                return;
            }
            VsqEvent item = (VsqEvent)AppManager.addingEvent.clone();
            item.Clock = clock;
            item.ID.Note = note;
            work.addEvent( item );
            work.reflectDynamics();
            CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( selected, work, vsq.AttachedCurves.get( selected - 1 ) );
            AppManager.register( vsq.executeCommand( run ) );
            setEdited( true );
        }
#endif

#if !JAVA
        private void FormMain_DragEnter( object sender, System.Windows.Forms.DragEventArgs e ) {
            if ( e.Data.GetDataPresent( typeof( IconDynamicsHandle ) ) ) {
                // ドロップ可能
                e.Effect = System.Windows.Forms.DragDropEffects.All;
                AppManager.setEditMode( EditMode.DRAG_DROP );
                m_mouse_downed = true;
            } else {
                e.Effect = System.Windows.Forms.DragDropEffects.None;
                AppManager.setEditMode( EditMode.NONE );
            }
        }
#endif
        #endregion

        #region public static methods
        /// <summary>
        /// VsqEvent, VsqBPList, BezierCurvesの全てのクロックを、tempoに格納されているテンポテーブルに
        /// 合致するようにシフトします．ただし，このメソッド内ではtargetのテンポテーブルは変更せず，クロック値だけが変更される．
        /// </summary>
        /// <param name="work"></param>
        /// <param name="tempo"></param>
        public static void shiftClockToMatchWith( VsqFileEx target, VsqFile tempo, double shift_seconds ) {
            // テンポをリプレースする場合。
            // まずクロック値を、リプレース後のモノに置き換え
            for ( int track = 1; track < target.Track.size(); track++ ) {
                // ノート・歌手イベントをシフト
                for ( Iterator<VsqEvent> itr = target.Track.get( track ).getEventIterator(); itr.hasNext(); ) {
                    VsqEvent item = itr.next();
                    if ( item.ID.type == VsqIDType.Singer && item.Clock == 0 ) {
                        continue;
                    }
                    int clock = item.Clock;
                    double sec_start = target.getSecFromClock( clock ) + shift_seconds;
                    double sec_end = target.getSecFromClock( clock + item.ID.getLength() ) + shift_seconds;
                    int clock_start = (int)tempo.getClockFromSec( sec_start );
                    int clock_end = (int)tempo.getClockFromSec( sec_end );
                    item.Clock = clock_start;
                    item.ID.setLength( clock_end - clock_start );
                    if ( item.ID.VibratoHandle != null ) {
                        double sec_vib_start = target.getSecFromClock( clock + item.ID.VibratoDelay ) + shift_seconds;
                        int clock_vib_start = (int)tempo.getClockFromSec( sec_vib_start );
                        item.ID.VibratoDelay = clock_vib_start - clock_start;
                        item.ID.VibratoHandle.setLength( clock_end - clock_vib_start );
                    }
                }

                // コントロールカーブをシフト
                for ( int j = 0; j < Utility.CURVE_USAGE.Length; j++ ) {
                    CurveType ct = Utility.CURVE_USAGE[j];
                    VsqBPList item = target.Track.get( track ).getCurve( ct.getName() );
                    if ( item == null ) {
                        continue;
                    }
                    VsqBPList repl = new VsqBPList( item.getName(), item.getDefault(), item.getMinimum(), item.getMaximum() );
                    for ( int i = 0; i < item.size(); i++ ) {
                        int clock = item.getKeyClock( i );
                        int value = item.getElement( i );
                        double sec = target.getSecFromClock( clock ) + shift_seconds;
                        if ( sec >= 0 ) {
                            int clock_new = (int)tempo.getClockFromSec( sec );
                            repl.add( clock_new, value );
                        }
                    }
                    target.Track.get( track ).setCurve( ct.getName(), repl );
                }

                // ベジエカーブをシフト
                for ( int j = 0; j < Utility.CURVE_USAGE.Length; j++ ) {
                    CurveType ct = Utility.CURVE_USAGE[j];
                    Vector<BezierChain> list = target.AttachedCurves.get( track - 1 ).get( ct );
                    if ( list == null ) {
                        continue;
                    }
                    for ( Iterator<BezierChain> itr = list.iterator(); itr.hasNext(); ) {
                        BezierChain chain = itr.next();
                        for ( Iterator<BezierPoint> itr2 = chain.points.iterator(); itr2.hasNext(); ) {
                            BezierPoint point = itr2.next();
                            PointD bse = new PointD( tempo.getClockFromSec( target.getSecFromClock( point.getBase().getX() ) + shift_seconds ),
                                                     point.getBase().getY() );
                            double rx = point.getBase().getX() + point.controlRight.getX();
                            double new_rx = tempo.getClockFromSec( target.getSecFromClock( rx ) + shift_seconds );
                            PointD ctrl_r = new PointD( new_rx - bse.getX(), point.controlRight.getY() );

                            double lx = point.getBase().getX() + point.controlLeft.getX();
                            double new_lx = tempo.getClockFromSec( target.getSecFromClock( lx ) + shift_seconds );
                            PointD ctrl_l = new PointD( new_lx - bse.getX(), point.controlLeft.getY() );
                            point.setBase( bse );
                            point.controlLeft = ctrl_l;
                            point.controlRight = ctrl_r;
                        }
                    }
                }
            }
        }

        /// <summary>
        /// フォームのタイトルバーが画面内に入るよう、Locationを正規化します
        /// </summary>
        /// <param name="form"></param>
        public static void normalizeFormLocation( BForm dlg ) {
            Rectangle rcScreen = PortUtil.getWorkingArea( dlg );
            int top = dlg.getY();
            if ( top + dlg.getHeight() > rcScreen.y + rcScreen.height ) {
                // ダイアログの下端が隠れる場合、位置をずらす
                top = rcScreen.y + rcScreen.height - dlg.getHeight();
            }
            if ( top < rcScreen.y ) {
                // ダイアログの上端が隠れる場合、位置をずらす
                top = rcScreen.y;
            }
            int left = dlg.getX();
            if ( left + dlg.getWidth() > rcScreen.x + rcScreen.width ) {
                left = rcScreen.x + rcScreen.width - dlg.getWidth();
            }
            if ( left < rcScreen.x ) {
                left = rcScreen.x;
            }
            dlg.setLocation( left, top );
        }
        #endregion

        #region ui implementation
#if JAVA
        //INCLUDE-SECTION FIELD ../BuildJavaUI/src/org/kbinani/Cadencii/FormMain.java
        BMenuItem stripDDBtnQuantize04 = null;
        BMenuItem stripDDBtnQuantize08 = null;
        BMenuItem stripDDBtnQuantize16 = null;
        BMenuItem stripDDBtnQuantize32 = null;
        BMenuItem stripDDBtnQuantize64 = null;
        BMenuItem stripDDBtnQuantize128 = null;
        BMenuItem stripDDBtnQuantizeOff = null;
        //INCLUDE-SECTION METHOD ../BuildJavaUI/src/org/kbinani/Cadencii/FormMain.java
#else
        /// <summary>
        /// 使用中のリソースをすべてクリーンアップします。
        /// </summary>
        /// <param name="disposing">マネージ リソースが破棄される場合 true、破棄されない場合は false です。</param>
        protected override void Dispose( boolean disposing ) {
            if ( disposing && (components != null) ) {
                components.Dispose();
            }
            base.Dispose( disposing );
        }

        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        public void InitializeComponent() {
            this.components = new System.ComponentModel.Container();
            this.menuStripMain = new org.kbinani.windows.forms.BMenuBar();
            this.menuFile = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileNew = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileOpen = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileSave = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileSaveNamed = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem10 = new System.Windows.Forms.ToolStripSeparator();
            this.menuFileOpenVsq = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileOpenUst = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileImport = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileImportVsq = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileImportMidi = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileExport = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileExportWave = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileExportMidi = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileExportMusicXml = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem11 = new System.Windows.Forms.ToolStripSeparator();
            this.menuFileRecent = new org.kbinani.windows.forms.BMenu();
            this.toolStripMenuItem12 = new System.Windows.Forms.ToolStripSeparator();
            this.menuFileQuit = new org.kbinani.windows.forms.BMenuItem();
            this.menuEdit = new org.kbinani.windows.forms.BMenuItem();
            this.menuEditUndo = new org.kbinani.windows.forms.BMenuItem();
            this.menuEditRedo = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem5 = new System.Windows.Forms.ToolStripSeparator();
            this.menuEditCut = new org.kbinani.windows.forms.BMenuItem();
            this.menuEditCopy = new org.kbinani.windows.forms.BMenuItem();
            this.menuEditPaste = new org.kbinani.windows.forms.BMenuItem();
            this.menuEditDelete = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem19 = new System.Windows.Forms.ToolStripSeparator();
            this.menuEditAutoNormalizeMode = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem20 = new System.Windows.Forms.ToolStripSeparator();
            this.menuEditSelectAll = new org.kbinani.windows.forms.BMenuItem();
            this.menuEditSelectAllEvents = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisual = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualControlTrack = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualMixer = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualWaveform = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualIconPalette = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualProperty = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualOverview = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualPluginUi = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualPluginUiVocaloid100 = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualPluginUiVocaloid101 = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualPluginUiVocaloid2 = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualPluginUiAquesTone = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem1 = new System.Windows.Forms.ToolStripSeparator();
            this.menuVisualGridline = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem2 = new System.Windows.Forms.ToolStripSeparator();
            this.menuVisualStartMarker = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualEndMarker = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem3 = new System.Windows.Forms.ToolStripSeparator();
            this.menuVisualLyrics = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualNoteProperty = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualPitchLine = new org.kbinani.windows.forms.BMenuItem();
            this.menuJob = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobNormalize = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobInsertBar = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobDeleteBar = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobRandomize = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobConnect = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobLyric = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobRewire = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobRealTime = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobReloadVsti = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrack = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackOn = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackPlayAfterSynth = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem21 = new System.Windows.Forms.ToolStripSeparator();
            this.menuTrackAdd = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackCopy = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackChangeName = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackDelete = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem22 = new System.Windows.Forms.ToolStripSeparator();
            this.menuTrackRenderCurrent = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRenderAll = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem23 = new System.Windows.Forms.ToolStripSeparator();
            this.menuTrackOverlay = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRenderer = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRendererVOCALOID100 = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRendererVOCALOID101 = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRendererVOCALOID2 = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRendererUtau = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRendererStraight = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRendererAquesTone = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem4 = new System.Windows.Forms.ToolStripSeparator();
            this.menuTrackBgm = new org.kbinani.windows.forms.BMenu();
            this.menuTrackManager = new org.kbinani.windows.forms.BMenuItem();
            this.menuLyric = new org.kbinani.windows.forms.BMenuItem();
            this.menuLyricExpressionProperty = new org.kbinani.windows.forms.BMenuItem();
            this.menuLyricVibratoProperty = new org.kbinani.windows.forms.BMenuItem();
            this.menuLyricPhonemeTransformation = new org.kbinani.windows.forms.BMenuItem();
            this.menuLyricDictionary = new org.kbinani.windows.forms.BMenuItem();
            this.menuScript = new org.kbinani.windows.forms.BMenuItem();
            this.menuScriptUpdate = new org.kbinani.windows.forms.BMenuItem();
            this.menuSetting = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPreference = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingGameControler = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingGameControlerSetting = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingGameControlerLoad = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingGameControlerRemove = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPaletteTool = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingShortcut = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingMidi = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingUtauVoiceDB = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem6 = new System.Windows.Forms.ToolStripSeparator();
            this.menuSettingDefaultSingerStyle = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem7 = new System.Windows.Forms.ToolStripSeparator();
            this.menuSettingPositionQuantize = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize04 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize08 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize16 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize32 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize64 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize128 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantizeOff = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem9 = new System.Windows.Forms.ToolStripSeparator();
            this.menuSettingPositionQuantizeTriplet = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingLengthQuantize = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingLengthQuantize04 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingLengthQuantize08 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingLengthQuantize16 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingLengthQuantize32 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingLengthQuantize64 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingLengthQuantize128 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingLengthQuantizeOff = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this.menuSettingLengthQuantizeTriplet = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem8 = new System.Windows.Forms.ToolStripSeparator();
            this.menuSettingSingerProperty = new org.kbinani.windows.forms.BMenuItem();
            this.menuHelp = new org.kbinani.windows.forms.BMenuItem();
            this.menuHelpAbout = new org.kbinani.windows.forms.BMenuItem();
            this.menuHelpDebug = new org.kbinani.windows.forms.BMenuItem();
            this.menuHidden = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenEditLyric = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenEditFlipToolPointerPencil = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenEditFlipToolPointerEraser = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenVisualForwardParameter = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenVisualBackwardParameter = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenTrackNext = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenTrackBack = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenCopy = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenPaste = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenCut = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenSelectForward = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenSelectBackward = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenMoveUp = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenMoveDown = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenMoveLeft = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenMoveRight = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenLengthen = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenShorten = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenGoToStartMarker = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenGoToEndMarker = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenPlayFromStartMarker = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenFlipCurveOnPianorollMode = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPiano = new org.kbinani.windows.forms.BPopupMenu( this.components );
            this.cMenuPianoPointer = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoPencil = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoEraser = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoPaletteTool = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripSeparator15 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoCurve = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem13 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoFixed = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed01 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed02 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed04 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed08 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed16 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed32 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed64 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed128 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixedOff = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem18 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoFixedTriplet = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixedDotted = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantize = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantize04 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantize08 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantize16 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantize32 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantize64 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantize128 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantizeOff = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem26 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoQuantizeTriplet = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoLength = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoLength04 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoLength08 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoLength16 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoLength32 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoLength64 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoLength128 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoLengthOff = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem32 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoLengthTriplet = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoGrid = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem14 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoUndo = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoRedo = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem15 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoCut = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoCopy = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoPaste = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoDelete = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem16 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoSelectAll = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoSelectAllEvents = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem17 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoImportLyric = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoExpressionProperty = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoVibratoProperty = new org.kbinani.windows.forms.BMenuItem();
            this.toolTip = new System.Windows.Forms.ToolTip( this.components );
            this.cMenuTrackTab = new org.kbinani.windows.forms.BPopupMenu( this.components );
            this.cMenuTrackTabTrackOn = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabPlayAfterSynth = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem24 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackTabAdd = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabCopy = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabChangeName = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabDelete = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem25 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackTabRenderCurrent = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRenderAll = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem27 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackTabOverlay = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRenderer = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererVOCALOID100 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererVOCALOID101 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererVOCALOID2 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererUtau = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererStraight = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererAquesTone = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelector = new org.kbinani.windows.forms.BPopupMenu( this.components );
            this.cMenuTrackSelectorPointer = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorPencil = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorLine = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorEraser = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorPaletteTool = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripSeparator14 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackSelectorCurve = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem28 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackSelectorUndo = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorRedo = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem29 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackSelectorCut = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorCopy = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorPaste = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorDelete = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorDeleteBezier = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem31 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackSelectorSelectAll = new org.kbinani.windows.forms.BMenuItem();
            this.trackBar = new org.kbinani.windows.forms.BSlider();
            this.panel1 = new org.kbinani.windows.forms.BPanel();
            this.pictureBox3 = new org.kbinani.windows.forms.BPictureBox();
            this.pictKeyLengthSplitter = new org.kbinani.windows.forms.BPictureBox();
            this.pictureBox2 = new org.kbinani.windows.forms.BPictureBox();
            this.vScroll = new org.kbinani.windows.forms.BVScrollBar();
            this.panelOverview = new org.kbinani.windows.forms.BPictureBox();
            this.picturePositionIndicator = new org.kbinani.windows.forms.BPictureBox();
            this.toolStripTool = new org.kbinani.windows.forms.BToolBar();
            this.stripBtnPointer = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnPencil = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnLine = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnEraser = new org.kbinani.windows.forms.BToolStripButton();
            this.toolStripSeparator5 = new System.Windows.Forms.ToolStripSeparator();
            this.stripBtnGrid = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnCurve = new org.kbinani.windows.forms.BToolStripButton();
            this.toolStripContainer = new System.Windows.Forms.ToolStripContainer();
            this.toolStripBottom = new org.kbinani.windows.forms.BToolBar();
            this.toolStripStatusLabel1 = new org.kbinani.windows.forms.BStatusLabel();
            this.stripLblGameCtrlMode = new org.kbinani.windows.forms.BStatusLabel();
            this.toolStripSeparator10 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripStatusLabel2 = new org.kbinani.windows.forms.BStatusLabel();
            this.stripLblMidiIn = new org.kbinani.windows.forms.BStatusLabel();
            this.toolStripSeparator11 = new System.Windows.Forms.ToolStripSeparator();
            this.stripDDBtnSpeed = new org.kbinani.windows.forms.BToolStripDropDownButton();
            this.stripDDBtnSpeedTextbox = new org.kbinani.windows.forms.BToolStripTextBox();
            this.stripDDBtnSpeed033 = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnSpeed050 = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnSpeed100 = new org.kbinani.windows.forms.BMenuItem();
            this.statusStrip1 = new System.Windows.Forms.StatusStrip();
            this.statusLabel = new org.kbinani.windows.forms.BStatusLabel();
            this.splitContainerProperty = new org.kbinani.apputil.BSplitContainer();
            this.panel2 = new org.kbinani.windows.forms.BPanel();
            this.splitContainer2 = new org.kbinani.apputil.BSplitContainer();
            this.splitContainer1 = new org.kbinani.apputil.BSplitContainer();
            this.toolStripFile = new org.kbinani.windows.forms.BToolBar();
            this.stripBtnFileNew = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnFileOpen = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnFileSave = new org.kbinani.windows.forms.BToolStripButton();
            this.toolStripSeparator12 = new System.Windows.Forms.ToolStripSeparator();
            this.stripBtnCut = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnCopy = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnPaste = new org.kbinani.windows.forms.BToolStripButton();
            this.toolStripSeparator13 = new System.Windows.Forms.ToolStripSeparator();
            this.stripBtnUndo = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnRedo = new org.kbinani.windows.forms.BToolStripButton();
            this.toolStripPosition = new org.kbinani.windows.forms.BToolBar();
            this.stripBtnMoveTop = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnRewind = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnForward = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnMoveEnd = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnPlay = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnStop = new org.kbinani.windows.forms.BToolStripButton();
            this.toolStripSeparator7 = new System.Windows.Forms.ToolStripSeparator();
            this.stripBtnScroll = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnLoop = new org.kbinani.windows.forms.BToolStripButton();
            this.toolStripMeasure = new org.kbinani.windows.forms.BToolBar();
            this.stripDDBtnLength = new org.kbinani.windows.forms.BToolStripDropDownButton();
            this.stripDDBtnLength04 = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnLength08 = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnLength16 = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnLength32 = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnLength64 = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnLength128 = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnLengthOff = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
            this.stripDDBtnLengthTriplet = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnQuantize = new org.kbinani.windows.forms.BToolStripDropDownButton();
            this.stripDDBtnQuantize04 = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnQuantize08 = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnQuantize16 = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnQuantize32 = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnQuantize64 = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnQuantize128 = new org.kbinani.windows.forms.BMenuItem();
            this.stripDDBtnQuantizeOff = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripSeparator3 = new System.Windows.Forms.ToolStripSeparator();
            this.stripDDBtnQuantizeTriplet = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripSeparator6 = new System.Windows.Forms.ToolStripSeparator();
            this.stripBtnStartMarker = new org.kbinani.windows.forms.BToolStripButton();
            this.stripBtnEndMarker = new org.kbinani.windows.forms.BToolStripButton();
            this.hScroll = new org.kbinani.cadencii.HScroll();
            this.pictPianoRoll = new org.kbinani.cadencii.PictPianoRoll();
            this.menuStripMain.SuspendLayout();
            this.cMenuPiano.SuspendLayout();
            this.cMenuTrackTab.SuspendLayout();
            this.cMenuTrackSelector.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.trackBar)).BeginInit();
            this.panel1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox3)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictKeyLengthSplitter)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.panelOverview)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.picturePositionIndicator)).BeginInit();
            this.toolStripTool.SuspendLayout();
            this.toolStripContainer.BottomToolStripPanel.SuspendLayout();
            this.toolStripContainer.ContentPanel.SuspendLayout();
            this.toolStripContainer.TopToolStripPanel.SuspendLayout();
            this.toolStripContainer.SuspendLayout();
            this.toolStripBottom.SuspendLayout();
            this.statusStrip1.SuspendLayout();
            this.toolStripFile.SuspendLayout();
            this.toolStripPosition.SuspendLayout();
            this.toolStripMeasure.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictPianoRoll)).BeginInit();
            this.SuspendLayout();
            // 
            // menuStripMain
            // 
            this.menuStripMain.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuFile,
            this.menuEdit,
            this.menuVisual,
            this.menuJob,
            this.menuTrack,
            this.menuLyric,
            this.menuScript,
            this.menuSetting,
            this.menuHelp,
            this.menuHidden} );
            this.menuStripMain.Location = new System.Drawing.Point( 0, 0 );
            this.menuStripMain.Name = "menuStripMain";
            this.menuStripMain.Size = new System.Drawing.Size( 960, 26 );
            this.menuStripMain.TabIndex = 0;
            this.menuStripMain.Text = "menuStrip1";
            // 
            // menuFile
            // 
            this.menuFile.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuFileNew,
            this.menuFileOpen,
            this.menuFileSave,
            this.menuFileSaveNamed,
            this.toolStripMenuItem10,
            this.menuFileOpenVsq,
            this.menuFileOpenUst,
            this.menuFileImport,
            this.menuFileExport,
            this.toolStripMenuItem11,
            this.menuFileRecent,
            this.toolStripMenuItem12,
            this.menuFileQuit} );
            this.menuFile.ImageScaling = System.Windows.Forms.ToolStripItemImageScaling.None;
            this.menuFile.Name = "menuFile";
            this.menuFile.Size = new System.Drawing.Size( 57, 22 );
            this.menuFile.Text = "File(&F)";
            // 
            // menuFileNew
            // 
            this.menuFileNew.Name = "menuFileNew";
            this.menuFileNew.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileNew.Text = "New(N)";
            // 
            // menuFileOpen
            // 
            this.menuFileOpen.Name = "menuFileOpen";
            this.menuFileOpen.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileOpen.Text = "Open(&O)";
            // 
            // menuFileSave
            // 
            this.menuFileSave.Name = "menuFileSave";
            this.menuFileSave.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileSave.Text = "Save(&S)";
            // 
            // menuFileSaveNamed
            // 
            this.menuFileSaveNamed.Name = "menuFileSaveNamed";
            this.menuFileSaveNamed.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileSaveNamed.Text = "Save As(&A)";
            // 
            // toolStripMenuItem10
            // 
            this.toolStripMenuItem10.Name = "toolStripMenuItem10";
            this.toolStripMenuItem10.Size = new System.Drawing.Size( 229, 6 );
            // 
            // menuFileOpenVsq
            // 
            this.menuFileOpenVsq.Name = "menuFileOpenVsq";
            this.menuFileOpenVsq.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileOpenVsq.Text = "Open VSQ/Vocaloid Midi(&V)";
            // 
            // menuFileOpenUst
            // 
            this.menuFileOpenUst.Name = "menuFileOpenUst";
            this.menuFileOpenUst.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileOpenUst.Text = "Open UTAU Project File(&U)";
            // 
            // menuFileImport
            // 
            this.menuFileImport.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuFileImportVsq,
            this.menuFileImportMidi} );
            this.menuFileImport.Name = "menuFileImport";
            this.menuFileImport.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileImport.Text = "Import(&I)";
            // 
            // menuFileImportVsq
            // 
            this.menuFileImportVsq.Name = "menuFileImportVsq";
            this.menuFileImportVsq.Size = new System.Drawing.Size( 162, 22 );
            this.menuFileImportVsq.Text = "VSQ File";
            // 
            // menuFileImportMidi
            // 
            this.menuFileImportMidi.Name = "menuFileImportMidi";
            this.menuFileImportMidi.Size = new System.Drawing.Size( 162, 22 );
            this.menuFileImportMidi.Text = "Standard MIDI";
            // 
            // menuFileExport
            // 
            this.menuFileExport.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuFileExportWave,
            this.menuFileExportMidi,
            this.menuFileExportMusicXml} );
            this.menuFileExport.Name = "menuFileExport";
            this.menuFileExport.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileExport.Text = "Export(&E)";
            // 
            // menuFileExportWave
            // 
            this.menuFileExportWave.Name = "menuFileExportWave";
            this.menuFileExportWave.Size = new System.Drawing.Size( 133, 22 );
            this.menuFileExportWave.Text = "Wave";
            // 
            // menuFileExportMidi
            // 
            this.menuFileExportMidi.Name = "menuFileExportMidi";
            this.menuFileExportMidi.Size = new System.Drawing.Size( 133, 22 );
            this.menuFileExportMidi.Text = "MIDI";
            // 
            // menuFileExportMusicXml
            // 
            this.menuFileExportMusicXml.Name = "menuFileExportMusicXml";
            this.menuFileExportMusicXml.Size = new System.Drawing.Size( 133, 22 );
            this.menuFileExportMusicXml.Text = "MusicXML";
            // 
            // toolStripMenuItem11
            // 
            this.toolStripMenuItem11.Name = "toolStripMenuItem11";
            this.toolStripMenuItem11.Size = new System.Drawing.Size( 229, 6 );
            // 
            // menuFileRecent
            // 
            this.menuFileRecent.Name = "menuFileRecent";
            this.menuFileRecent.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileRecent.Text = "Recent Files(&R)";
            // 
            // toolStripMenuItem12
            // 
            this.toolStripMenuItem12.Name = "toolStripMenuItem12";
            this.toolStripMenuItem12.Size = new System.Drawing.Size( 229, 6 );
            // 
            // menuFileQuit
            // 
            this.menuFileQuit.Name = "menuFileQuit";
            this.menuFileQuit.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileQuit.Text = "Quit(&Q)";
            // 
            // menuEdit
            // 
            this.menuEdit.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuEditUndo,
            this.menuEditRedo,
            this.toolStripMenuItem5,
            this.menuEditCut,
            this.menuEditCopy,
            this.menuEditPaste,
            this.menuEditDelete,
            this.toolStripMenuItem19,
            this.menuEditAutoNormalizeMode,
            this.toolStripMenuItem20,
            this.menuEditSelectAll,
            this.menuEditSelectAllEvents} );
            this.menuEdit.Name = "menuEdit";
            this.menuEdit.Size = new System.Drawing.Size( 59, 22 );
            this.menuEdit.Text = "Edit(&E)";
            // 
            // menuEditUndo
            // 
            this.menuEditUndo.Name = "menuEditUndo";
            this.menuEditUndo.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditUndo.Text = "Undo(&U)";
            // 
            // menuEditRedo
            // 
            this.menuEditRedo.Name = "menuEditRedo";
            this.menuEditRedo.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditRedo.Text = "Redo(&R)";
            // 
            // toolStripMenuItem5
            // 
            this.toolStripMenuItem5.Name = "toolStripMenuItem5";
            this.toolStripMenuItem5.Size = new System.Drawing.Size( 217, 6 );
            // 
            // menuEditCut
            // 
            this.menuEditCut.Name = "menuEditCut";
            this.menuEditCut.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditCut.Text = "Cut(&T)";
            // 
            // menuEditCopy
            // 
            this.menuEditCopy.Name = "menuEditCopy";
            this.menuEditCopy.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditCopy.Text = "Copy(&C)";
            // 
            // menuEditPaste
            // 
            this.menuEditPaste.Name = "menuEditPaste";
            this.menuEditPaste.ShortcutKeyDisplayString = "";
            this.menuEditPaste.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditPaste.Text = "Paste(&P)";
            // 
            // menuEditDelete
            // 
            this.menuEditDelete.Name = "menuEditDelete";
            this.menuEditDelete.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditDelete.Text = "Delete(&D)";
            // 
            // toolStripMenuItem19
            // 
            this.toolStripMenuItem19.Name = "toolStripMenuItem19";
            this.toolStripMenuItem19.Size = new System.Drawing.Size( 217, 6 );
            // 
            // menuEditAutoNormalizeMode
            // 
            this.menuEditAutoNormalizeMode.Name = "menuEditAutoNormalizeMode";
            this.menuEditAutoNormalizeMode.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditAutoNormalizeMode.Text = "Auto Normalize Mode(&N)";
            // 
            // toolStripMenuItem20
            // 
            this.toolStripMenuItem20.Name = "toolStripMenuItem20";
            this.toolStripMenuItem20.Size = new System.Drawing.Size( 217, 6 );
            // 
            // menuEditSelectAll
            // 
            this.menuEditSelectAll.Name = "menuEditSelectAll";
            this.menuEditSelectAll.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditSelectAll.Text = "Select All(&A)";
            // 
            // menuEditSelectAllEvents
            // 
            this.menuEditSelectAllEvents.Name = "menuEditSelectAllEvents";
            this.menuEditSelectAllEvents.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditSelectAllEvents.Text = "Select All Events(&E)";
            // 
            // menuVisual
            // 
            this.menuVisual.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisual.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuVisualControlTrack,
            this.menuVisualMixer,
            this.menuVisualWaveform,
            this.menuVisualIconPalette,
            this.menuVisualProperty,
            this.menuVisualOverview,
            this.menuVisualPluginUi,
            this.toolStripMenuItem1,
            this.menuVisualGridline,
            this.toolStripMenuItem2,
            this.menuVisualStartMarker,
            this.menuVisualEndMarker,
            this.toolStripMenuItem3,
            this.menuVisualLyrics,
            this.menuVisualNoteProperty,
            this.menuVisualPitchLine} );
            this.menuVisual.Name = "menuVisual";
            this.menuVisual.Size = new System.Drawing.Size( 66, 22 );
            this.menuVisual.Text = "View(&V)";
            // 
            // menuVisualControlTrack
            // 
            this.menuVisualControlTrack.Checked = true;
            this.menuVisualControlTrack.CheckOnClick = true;
            this.menuVisualControlTrack.CheckState = System.Windows.Forms.CheckState.Checked;
            this.menuVisualControlTrack.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualControlTrack.Name = "menuVisualControlTrack";
            this.menuVisualControlTrack.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualControlTrack.Text = "Control Track(&C)";
            // 
            // menuVisualMixer
            // 
            this.menuVisualMixer.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualMixer.Name = "menuVisualMixer";
            this.menuVisualMixer.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualMixer.Text = "Mixer(&X)";
            // 
            // menuVisualWaveform
            // 
            this.menuVisualWaveform.CheckOnClick = true;
            this.menuVisualWaveform.Name = "menuVisualWaveform";
            this.menuVisualWaveform.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualWaveform.Text = "Waveform(&W)";
            // 
            // menuVisualIconPalette
            // 
            this.menuVisualIconPalette.Name = "menuVisualIconPalette";
            this.menuVisualIconPalette.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualIconPalette.Text = "Icon Palette(&I)";
            // 
            // menuVisualProperty
            // 
            this.menuVisualProperty.CheckOnClick = true;
            this.menuVisualProperty.Name = "menuVisualProperty";
            this.menuVisualProperty.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualProperty.Text = "Property Window(&C)";
            // 
            // menuVisualOverview
            // 
            this.menuVisualOverview.CheckOnClick = true;
            this.menuVisualOverview.Name = "menuVisualOverview";
            this.menuVisualOverview.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualOverview.Text = "Overview(&O)";
            // 
            // menuVisualPluginUi
            // 
            this.menuVisualPluginUi.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuVisualPluginUiVocaloid100,
            this.menuVisualPluginUiVocaloid101,
            this.menuVisualPluginUiVocaloid2,
            this.menuVisualPluginUiAquesTone} );
            this.menuVisualPluginUi.Name = "menuVisualPluginUi";
            this.menuVisualPluginUi.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualPluginUi.Text = "VSTi Plugin UI(&U)";
            // 
            // menuVisualPluginUiVocaloid100
            // 
            this.menuVisualPluginUiVocaloid100.Name = "menuVisualPluginUiVocaloid100";
            this.menuVisualPluginUiVocaloid100.Size = new System.Drawing.Size( 178, 22 );
            this.menuVisualPluginUiVocaloid100.Text = "VOCALOID1 [1.0]";
            // 
            // menuVisualPluginUiVocaloid101
            // 
            this.menuVisualPluginUiVocaloid101.Name = "menuVisualPluginUiVocaloid101";
            this.menuVisualPluginUiVocaloid101.Size = new System.Drawing.Size( 178, 22 );
            this.menuVisualPluginUiVocaloid101.Text = "VOCALOID1 [1.1]";
            // 
            // menuVisualPluginUiVocaloid2
            // 
            this.menuVisualPluginUiVocaloid2.Name = "menuVisualPluginUiVocaloid2";
            this.menuVisualPluginUiVocaloid2.Size = new System.Drawing.Size( 178, 22 );
            this.menuVisualPluginUiVocaloid2.Text = "VOCALOID2";
            // 
            // menuVisualPluginUiAquesTone
            // 
            this.menuVisualPluginUiAquesTone.Name = "menuVisualPluginUiAquesTone";
            this.menuVisualPluginUiAquesTone.Size = new System.Drawing.Size( 178, 22 );
            this.menuVisualPluginUiAquesTone.Text = "AquesTone(&A)";
            // 
            // toolStripMenuItem1
            // 
            this.toolStripMenuItem1.Name = "toolStripMenuItem1";
            this.toolStripMenuItem1.Size = new System.Drawing.Size( 234, 6 );
            // 
            // menuVisualGridline
            // 
            this.menuVisualGridline.CheckOnClick = true;
            this.menuVisualGridline.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualGridline.Name = "menuVisualGridline";
            this.menuVisualGridline.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualGridline.Text = "Grid Line(&G)";
            // 
            // toolStripMenuItem2
            // 
            this.toolStripMenuItem2.Name = "toolStripMenuItem2";
            this.toolStripMenuItem2.Size = new System.Drawing.Size( 234, 6 );
            // 
            // menuVisualStartMarker
            // 
            this.menuVisualStartMarker.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualStartMarker.Name = "menuVisualStartMarker";
            this.menuVisualStartMarker.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualStartMarker.Text = "Start Marker(&S)";
            // 
            // menuVisualEndMarker
            // 
            this.menuVisualEndMarker.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualEndMarker.Name = "menuVisualEndMarker";
            this.menuVisualEndMarker.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualEndMarker.Text = "End Marker(&E)";
            // 
            // toolStripMenuItem3
            // 
            this.toolStripMenuItem3.Name = "toolStripMenuItem3";
            this.toolStripMenuItem3.Size = new System.Drawing.Size( 234, 6 );
            // 
            // menuVisualLyrics
            // 
            this.menuVisualLyrics.Checked = true;
            this.menuVisualLyrics.CheckOnClick = true;
            this.menuVisualLyrics.CheckState = System.Windows.Forms.CheckState.Checked;
            this.menuVisualLyrics.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualLyrics.Name = "menuVisualLyrics";
            this.menuVisualLyrics.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualLyrics.Text = "Lyric/Phoneme(&L)";
            // 
            // menuVisualNoteProperty
            // 
            this.menuVisualNoteProperty.Checked = true;
            this.menuVisualNoteProperty.CheckOnClick = true;
            this.menuVisualNoteProperty.CheckState = System.Windows.Forms.CheckState.Checked;
            this.menuVisualNoteProperty.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualNoteProperty.Name = "menuVisualNoteProperty";
            this.menuVisualNoteProperty.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualNoteProperty.Text = "Note Expression/Vibrato(&N)";
            // 
            // menuVisualPitchLine
            // 
            this.menuVisualPitchLine.CheckOnClick = true;
            this.menuVisualPitchLine.Name = "menuVisualPitchLine";
            this.menuVisualPitchLine.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualPitchLine.Text = "Pitch Line(&P)";
            // 
            // menuJob
            // 
            this.menuJob.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuJobNormalize,
            this.menuJobInsertBar,
            this.menuJobDeleteBar,
            this.menuJobRandomize,
            this.menuJobConnect,
            this.menuJobLyric,
            this.menuJobRewire,
            this.menuJobRealTime,
            this.menuJobReloadVsti} );
            this.menuJob.Name = "menuJob";
            this.menuJob.Size = new System.Drawing.Size( 54, 22 );
            this.menuJob.Text = "Job(&J)";
            // 
            // menuJobNormalize
            // 
            this.menuJobNormalize.Name = "menuJobNormalize";
            this.menuJobNormalize.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobNormalize.Text = "Normalize Notes(&N)";
            // 
            // menuJobInsertBar
            // 
            this.menuJobInsertBar.Name = "menuJobInsertBar";
            this.menuJobInsertBar.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobInsertBar.Text = "Insert Bars(&I)";
            // 
            // menuJobDeleteBar
            // 
            this.menuJobDeleteBar.Name = "menuJobDeleteBar";
            this.menuJobDeleteBar.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobDeleteBar.Text = "Delete Bars(&D)";
            // 
            // menuJobRandomize
            // 
            this.menuJobRandomize.Name = "menuJobRandomize";
            this.menuJobRandomize.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobRandomize.Text = "Randomize(&R)";
            // 
            // menuJobConnect
            // 
            this.menuJobConnect.Name = "menuJobConnect";
            this.menuJobConnect.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobConnect.Text = "Connect Notes(&C)";
            // 
            // menuJobLyric
            // 
            this.menuJobLyric.Name = "menuJobLyric";
            this.menuJobLyric.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobLyric.Text = "Insert Lyrics(&L)";
            // 
            // menuJobRewire
            // 
            this.menuJobRewire.Enabled = false;
            this.menuJobRewire.Name = "menuJobRewire";
            this.menuJobRewire.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobRewire.Text = "Import ReWire Host Tempo(&T)";
            // 
            // menuJobRealTime
            // 
            this.menuJobRealTime.Name = "menuJobRealTime";
            this.menuJobRealTime.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobRealTime.Text = "Start Realtime Input";
            // 
            // menuJobReloadVsti
            // 
            this.menuJobReloadVsti.Name = "menuJobReloadVsti";
            this.menuJobReloadVsti.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobReloadVsti.Text = "Reload VSTi(&R)";
            this.menuJobReloadVsti.Visible = false;
            // 
            // menuTrack
            // 
            this.menuTrack.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuTrackOn,
            this.menuTrackPlayAfterSynth,
            this.toolStripMenuItem21,
            this.menuTrackAdd,
            this.menuTrackCopy,
            this.menuTrackChangeName,
            this.menuTrackDelete,
            this.toolStripMenuItem22,
            this.menuTrackRenderCurrent,
            this.menuTrackRenderAll,
            this.toolStripMenuItem23,
            this.menuTrackOverlay,
            this.menuTrackRenderer,
            this.toolStripMenuItem4,
            this.menuTrackBgm,
            this.menuTrackManager} );
            this.menuTrack.Name = "menuTrack";
            this.menuTrack.Size = new System.Drawing.Size( 70, 22 );
            this.menuTrack.Text = "Track(&T)";
            // 
            // menuTrackOn
            // 
            this.menuTrackOn.Name = "menuTrackOn";
            this.menuTrackOn.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackOn.Text = "Track On(&K)";
            // 
            // menuTrackPlayAfterSynth
            // 
            this.menuTrackPlayAfterSynth.Name = "menuTrackPlayAfterSynth";
            this.menuTrackPlayAfterSynth.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackPlayAfterSynth.Text = "Play After Synth(&P)";
            // 
            // toolStripMenuItem21
            // 
            this.toolStripMenuItem21.Name = "toolStripMenuItem21";
            this.toolStripMenuItem21.Size = new System.Drawing.Size( 216, 6 );
            // 
            // menuTrackAdd
            // 
            this.menuTrackAdd.Name = "menuTrackAdd";
            this.menuTrackAdd.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackAdd.Text = "Add Track(&A)";
            // 
            // menuTrackCopy
            // 
            this.menuTrackCopy.Name = "menuTrackCopy";
            this.menuTrackCopy.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackCopy.Text = "Copy Track(&C)";
            // 
            // menuTrackChangeName
            // 
            this.menuTrackChangeName.Name = "menuTrackChangeName";
            this.menuTrackChangeName.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackChangeName.Text = "Rename Track";
            // 
            // menuTrackDelete
            // 
            this.menuTrackDelete.Name = "menuTrackDelete";
            this.menuTrackDelete.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackDelete.Text = "Delete Track(&D)";
            // 
            // toolStripMenuItem22
            // 
            this.toolStripMenuItem22.Name = "toolStripMenuItem22";
            this.toolStripMenuItem22.Size = new System.Drawing.Size( 216, 6 );
            // 
            // menuTrackRenderCurrent
            // 
            this.menuTrackRenderCurrent.Name = "menuTrackRenderCurrent";
            this.menuTrackRenderCurrent.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackRenderCurrent.Text = "Render Current Track(&T)";
            // 
            // menuTrackRenderAll
            // 
            this.menuTrackRenderAll.Enabled = false;
            this.menuTrackRenderAll.Name = "menuTrackRenderAll";
            this.menuTrackRenderAll.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackRenderAll.Text = "Render All Tracks(&S)";
            // 
            // toolStripMenuItem23
            // 
            this.toolStripMenuItem23.Name = "toolStripMenuItem23";
            this.toolStripMenuItem23.Size = new System.Drawing.Size( 216, 6 );
            // 
            // menuTrackOverlay
            // 
            this.menuTrackOverlay.Name = "menuTrackOverlay";
            this.menuTrackOverlay.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackOverlay.Text = "Overlay(&O)";
            // 
            // menuTrackRenderer
            // 
            this.menuTrackRenderer.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuTrackRendererVOCALOID100,
            this.menuTrackRendererVOCALOID101,
            this.menuTrackRendererVOCALOID2,
            this.menuTrackRendererUtau,
            this.menuTrackRendererStraight,
            this.menuTrackRendererAquesTone} );
            this.menuTrackRenderer.Name = "menuTrackRenderer";
            this.menuTrackRenderer.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackRenderer.Text = "Renderer(&R)";
            // 
            // menuTrackRendererVOCALOID100
            // 
            this.menuTrackRendererVOCALOID100.Name = "menuTrackRendererVOCALOID100";
            this.menuTrackRendererVOCALOID100.Size = new System.Drawing.Size( 199, 22 );
            this.menuTrackRendererVOCALOID100.Text = "VOCALOID1 [1.0] (&1)";
            // 
            // menuTrackRendererVOCALOID101
            // 
            this.menuTrackRendererVOCALOID101.Name = "menuTrackRendererVOCALOID101";
            this.menuTrackRendererVOCALOID101.Size = new System.Drawing.Size( 199, 22 );
            this.menuTrackRendererVOCALOID101.Text = "VOCALOID1 [1.1] (&2)";
            // 
            // menuTrackRendererVOCALOID2
            // 
            this.menuTrackRendererVOCALOID2.Name = "menuTrackRendererVOCALOID2";
            this.menuTrackRendererVOCALOID2.Size = new System.Drawing.Size( 199, 22 );
            this.menuTrackRendererVOCALOID2.Text = "VOCALOID2(&3)";
            // 
            // menuTrackRendererUtau
            // 
            this.menuTrackRendererUtau.Name = "menuTrackRendererUtau";
            this.menuTrackRendererUtau.Size = new System.Drawing.Size( 199, 22 );
            this.menuTrackRendererUtau.Text = "UTAU(&4)";
            // 
            // menuTrackRendererStraight
            // 
            this.menuTrackRendererStraight.Name = "menuTrackRendererStraight";
            this.menuTrackRendererStraight.Size = new System.Drawing.Size( 199, 22 );
            this.menuTrackRendererStraight.Text = "Straight X UTAU(&5)";
            // 
            // menuTrackRendererAquesTone
            // 
            this.menuTrackRendererAquesTone.Name = "menuTrackRendererAquesTone";
            this.menuTrackRendererAquesTone.Size = new System.Drawing.Size( 199, 22 );
            this.menuTrackRendererAquesTone.Text = "AquesTone(&6)";
            // 
            // toolStripMenuItem4
            // 
            this.toolStripMenuItem4.Name = "toolStripMenuItem4";
            this.toolStripMenuItem4.Size = new System.Drawing.Size( 216, 6 );
            // 
            // menuTrackBgm
            // 
            this.menuTrackBgm.Name = "menuTrackBgm";
            this.menuTrackBgm.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackBgm.Text = "BGM(&B)";
            // 
            // menuTrackManager
            // 
            this.menuTrackManager.Name = "menuTrackManager";
            this.menuTrackManager.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackManager.Text = "Track Manager(&M)";
            // 
            // menuLyric
            // 
            this.menuLyric.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuLyricExpressionProperty,
            this.menuLyricVibratoProperty,
            this.menuLyricPhonemeTransformation,
            this.menuLyricDictionary} );
            this.menuLyric.Name = "menuLyric";
            this.menuLyric.Size = new System.Drawing.Size( 70, 22 );
            this.menuLyric.Text = "Lyrics(&L)";
            // 
            // menuLyricExpressionProperty
            // 
            this.menuLyricExpressionProperty.Name = "menuLyricExpressionProperty";
            this.menuLyricExpressionProperty.Size = new System.Drawing.Size( 241, 22 );
            this.menuLyricExpressionProperty.Text = "Note Expression Property(&E)";
            // 
            // menuLyricVibratoProperty
            // 
            this.menuLyricVibratoProperty.Name = "menuLyricVibratoProperty";
            this.menuLyricVibratoProperty.Size = new System.Drawing.Size( 241, 22 );
            this.menuLyricVibratoProperty.Text = "Note Vibrato Property(&V)";
            // 
            // menuLyricPhonemeTransformation
            // 
            this.menuLyricPhonemeTransformation.Name = "menuLyricPhonemeTransformation";
            this.menuLyricPhonemeTransformation.Size = new System.Drawing.Size( 241, 22 );
            this.menuLyricPhonemeTransformation.Text = "Phoneme Transformation(&T)";
            // 
            // menuLyricDictionary
            // 
            this.menuLyricDictionary.Name = "menuLyricDictionary";
            this.menuLyricDictionary.Size = new System.Drawing.Size( 241, 22 );
            this.menuLyricDictionary.Text = "User Word Dictionary(&C)";
            // 
            // menuScript
            // 
            this.menuScript.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuScriptUpdate} );
            this.menuScript.Name = "menuScript";
            this.menuScript.Size = new System.Drawing.Size( 72, 22 );
            this.menuScript.Text = "Script(&C)";
            // 
            // menuScriptUpdate
            // 
            this.menuScriptUpdate.Name = "menuScriptUpdate";
            this.menuScriptUpdate.Size = new System.Drawing.Size( 200, 22 );
            this.menuScriptUpdate.Text = "Update Script List(&U)";
            // 
            // menuSetting
            // 
            this.menuSetting.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuSettingPreference,
            this.menuSettingGameControler,
            this.menuSettingPaletteTool,
            this.menuSettingShortcut,
            this.menuSettingMidi,
            this.menuSettingUtauVoiceDB,
            this.toolStripMenuItem6,
            this.menuSettingDefaultSingerStyle,
            this.toolStripMenuItem7,
            this.menuSettingPositionQuantize,
            this.menuSettingLengthQuantize,
            this.toolStripMenuItem8,
            this.menuSettingSingerProperty} );
            this.menuSetting.Name = "menuSetting";
            this.menuSetting.Size = new System.Drawing.Size( 80, 22 );
            this.menuSetting.Text = "Setting(&S)";
            // 
            // menuSettingPreference
            // 
            this.menuSettingPreference.Name = "menuSettingPreference";
            this.menuSettingPreference.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingPreference.Text = "Preference(&P)";
            // 
            // menuSettingGameControler
            // 
            this.menuSettingGameControler.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuSettingGameControlerSetting,
            this.menuSettingGameControlerLoad,
            this.menuSettingGameControlerRemove} );
            this.menuSettingGameControler.Name = "menuSettingGameControler";
            this.menuSettingGameControler.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingGameControler.Text = "Game Controler(&G)";
            // 
            // menuSettingGameControlerSetting
            // 
            this.menuSettingGameControlerSetting.Name = "menuSettingGameControlerSetting";
            this.menuSettingGameControlerSetting.Size = new System.Drawing.Size( 142, 22 );
            this.menuSettingGameControlerSetting.Text = "Setting(&S)";
            // 
            // menuSettingGameControlerLoad
            // 
            this.menuSettingGameControlerLoad.Name = "menuSettingGameControlerLoad";
            this.menuSettingGameControlerLoad.Size = new System.Drawing.Size( 142, 22 );
            this.menuSettingGameControlerLoad.Text = "Load(&L)";
            // 
            // menuSettingGameControlerRemove
            // 
            this.menuSettingGameControlerRemove.Name = "menuSettingGameControlerRemove";
            this.menuSettingGameControlerRemove.Size = new System.Drawing.Size( 142, 22 );
            this.menuSettingGameControlerRemove.Text = "Remove(&R)";
            // 
            // menuSettingPaletteTool
            // 
            this.menuSettingPaletteTool.Name = "menuSettingPaletteTool";
            this.menuSettingPaletteTool.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingPaletteTool.Text = "Palette Tool(&T)";
            // 
            // menuSettingShortcut
            // 
            this.menuSettingShortcut.Name = "menuSettingShortcut";
            this.menuSettingShortcut.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingShortcut.Text = "Shortcut Key(&S)";
            // 
            // menuSettingMidi
            // 
            this.menuSettingMidi.Name = "menuSettingMidi";
            this.menuSettingMidi.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingMidi.Text = "MIDI(&M)";
            // 
            // menuSettingUtauVoiceDB
            // 
            this.menuSettingUtauVoiceDB.Name = "menuSettingUtauVoiceDB";
            this.menuSettingUtauVoiceDB.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingUtauVoiceDB.Text = "UTAU Voice DB(&U)";
            // 
            // toolStripMenuItem6
            // 
            this.toolStripMenuItem6.Name = "toolStripMenuItem6";
            this.toolStripMenuItem6.Size = new System.Drawing.Size( 220, 6 );
            // 
            // menuSettingDefaultSingerStyle
            // 
            this.menuSettingDefaultSingerStyle.Name = "menuSettingDefaultSingerStyle";
            this.menuSettingDefaultSingerStyle.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingDefaultSingerStyle.Text = "Singing Style Defaults(&D)";
            // 
            // toolStripMenuItem7
            // 
            this.toolStripMenuItem7.Name = "toolStripMenuItem7";
            this.toolStripMenuItem7.Size = new System.Drawing.Size( 220, 6 );
            // 
            // menuSettingPositionQuantize
            // 
            this.menuSettingPositionQuantize.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuSettingPositionQuantize04,
            this.menuSettingPositionQuantize08,
            this.menuSettingPositionQuantize16,
            this.menuSettingPositionQuantize32,
            this.menuSettingPositionQuantize64,
            this.menuSettingPositionQuantize128,
            this.menuSettingPositionQuantizeOff,
            this.toolStripMenuItem9,
            this.menuSettingPositionQuantizeTriplet} );
            this.menuSettingPositionQuantize.Name = "menuSettingPositionQuantize";
            this.menuSettingPositionQuantize.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingPositionQuantize.Text = "Quantize(&Q)";
            // 
            // menuSettingPositionQuantize04
            // 
            this.menuSettingPositionQuantize04.Name = "menuSettingPositionQuantize04";
            this.menuSettingPositionQuantize04.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantize04.Text = "1/4";
            // 
            // menuSettingPositionQuantize08
            // 
            this.menuSettingPositionQuantize08.Name = "menuSettingPositionQuantize08";
            this.menuSettingPositionQuantize08.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantize08.Text = "1/8";
            // 
            // menuSettingPositionQuantize16
            // 
            this.menuSettingPositionQuantize16.Name = "menuSettingPositionQuantize16";
            this.menuSettingPositionQuantize16.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantize16.Text = "1/16";
            // 
            // menuSettingPositionQuantize32
            // 
            this.menuSettingPositionQuantize32.Name = "menuSettingPositionQuantize32";
            this.menuSettingPositionQuantize32.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantize32.Text = "1/32";
            // 
            // menuSettingPositionQuantize64
            // 
            this.menuSettingPositionQuantize64.Name = "menuSettingPositionQuantize64";
            this.menuSettingPositionQuantize64.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantize64.Text = "1/64";
            // 
            // menuSettingPositionQuantize128
            // 
            this.menuSettingPositionQuantize128.Name = "menuSettingPositionQuantize128";
            this.menuSettingPositionQuantize128.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantize128.Text = "1/128";
            // 
            // menuSettingPositionQuantizeOff
            // 
            this.menuSettingPositionQuantizeOff.Name = "menuSettingPositionQuantizeOff";
            this.menuSettingPositionQuantizeOff.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantizeOff.Text = "Off";
            // 
            // toolStripMenuItem9
            // 
            this.toolStripMenuItem9.Name = "toolStripMenuItem9";
            this.toolStripMenuItem9.Size = new System.Drawing.Size( 110, 6 );
            // 
            // menuSettingPositionQuantizeTriplet
            // 
            this.menuSettingPositionQuantizeTriplet.Name = "menuSettingPositionQuantizeTriplet";
            this.menuSettingPositionQuantizeTriplet.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantizeTriplet.Text = "Triplet";
            // 
            // menuSettingLengthQuantize
            // 
            this.menuSettingLengthQuantize.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuSettingLengthQuantize04,
            this.menuSettingLengthQuantize08,
            this.menuSettingLengthQuantize16,
            this.menuSettingLengthQuantize32,
            this.menuSettingLengthQuantize64,
            this.menuSettingLengthQuantize128,
            this.menuSettingLengthQuantizeOff,
            this.toolStripSeparator1,
            this.menuSettingLengthQuantizeTriplet} );
            this.menuSettingLengthQuantize.Name = "menuSettingLengthQuantize";
            this.menuSettingLengthQuantize.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingLengthQuantize.Text = "Length(&L)";
            // 
            // menuSettingLengthQuantize04
            // 
            this.menuSettingLengthQuantize04.Name = "menuSettingLengthQuantize04";
            this.menuSettingLengthQuantize04.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantize04.Text = "1/4";
            // 
            // menuSettingLengthQuantize08
            // 
            this.menuSettingLengthQuantize08.Name = "menuSettingLengthQuantize08";
            this.menuSettingLengthQuantize08.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantize08.Text = "1/8";
            // 
            // menuSettingLengthQuantize16
            // 
            this.menuSettingLengthQuantize16.Name = "menuSettingLengthQuantize16";
            this.menuSettingLengthQuantize16.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantize16.Text = "1/16";
            // 
            // menuSettingLengthQuantize32
            // 
            this.menuSettingLengthQuantize32.Name = "menuSettingLengthQuantize32";
            this.menuSettingLengthQuantize32.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantize32.Text = "1/32";
            // 
            // menuSettingLengthQuantize64
            // 
            this.menuSettingLengthQuantize64.Name = "menuSettingLengthQuantize64";
            this.menuSettingLengthQuantize64.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantize64.Text = "1/64";
            // 
            // menuSettingLengthQuantize128
            // 
            this.menuSettingLengthQuantize128.Name = "menuSettingLengthQuantize128";
            this.menuSettingLengthQuantize128.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantize128.Text = "1/128";
            // 
            // menuSettingLengthQuantizeOff
            // 
            this.menuSettingLengthQuantizeOff.Name = "menuSettingLengthQuantizeOff";
            this.menuSettingLengthQuantizeOff.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantizeOff.Text = "Off";
            // 
            // toolStripSeparator1
            // 
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            this.toolStripSeparator1.Size = new System.Drawing.Size( 110, 6 );
            // 
            // menuSettingLengthQuantizeTriplet
            // 
            this.menuSettingLengthQuantizeTriplet.Name = "menuSettingLengthQuantizeTriplet";
            this.menuSettingLengthQuantizeTriplet.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantizeTriplet.Text = "Triplet";
            // 
            // toolStripMenuItem8
            // 
            this.toolStripMenuItem8.Name = "toolStripMenuItem8";
            this.toolStripMenuItem8.Size = new System.Drawing.Size( 220, 6 );
            // 
            // menuSettingSingerProperty
            // 
            this.menuSettingSingerProperty.Enabled = false;
            this.menuSettingSingerProperty.Name = "menuSettingSingerProperty";
            this.menuSettingSingerProperty.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingSingerProperty.Text = "Singer Properties(&S)";
            // 
            // menuHelp
            // 
            this.menuHelp.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuHelpAbout,
            this.menuHelpDebug} );
            this.menuHelp.Name = "menuHelp";
            this.menuHelp.Size = new System.Drawing.Size( 65, 22 );
            this.menuHelp.Text = "Help(&H)";
            // 
            // menuHelpAbout
            // 
            this.menuHelpAbout.Name = "menuHelpAbout";
            this.menuHelpAbout.Size = new System.Drawing.Size( 180, 22 );
            this.menuHelpAbout.Text = "About Cadencii(&A)";
            // 
            // menuHelpDebug
            // 
            this.menuHelpDebug.Name = "menuHelpDebug";
            this.menuHelpDebug.Size = new System.Drawing.Size( 180, 22 );
            this.menuHelpDebug.Text = "Debug";
            this.menuHelpDebug.Visible = false;
            // 
            // menuHidden
            // 
            this.menuHidden.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuHiddenEditLyric,
            this.menuHiddenEditFlipToolPointerPencil,
            this.menuHiddenEditFlipToolPointerEraser,
            this.menuHiddenVisualForwardParameter,
            this.menuHiddenVisualBackwardParameter,
            this.menuHiddenTrackNext,
            this.menuHiddenTrackBack,
            this.menuHiddenCopy,
            this.menuHiddenPaste,
            this.menuHiddenCut,
            this.menuHiddenSelectForward,
            this.menuHiddenSelectBackward,
            this.menuHiddenMoveUp,
            this.menuHiddenMoveDown,
            this.menuHiddenMoveLeft,
            this.menuHiddenMoveRight,
            this.menuHiddenLengthen,
            this.menuHiddenShorten,
            this.menuHiddenGoToStartMarker,
            this.menuHiddenGoToEndMarker,
            this.menuHiddenPlayFromStartMarker,
            this.menuHiddenFlipCurveOnPianorollMode} );
            this.menuHidden.Name = "menuHidden";
            this.menuHidden.Size = new System.Drawing.Size( 91, 22 );
            this.menuHidden.Text = "MenuHidden";
            this.menuHidden.Visible = false;
            // 
            // menuHiddenEditLyric
            // 
            this.menuHiddenEditLyric.Name = "menuHiddenEditLyric";
            this.menuHiddenEditLyric.ShortcutKeys = System.Windows.Forms.Keys.F2;
            this.menuHiddenEditLyric.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenEditLyric.Text = "Start Lyric Input";
            this.menuHiddenEditLyric.Visible = false;
            // 
            // menuHiddenEditFlipToolPointerPencil
            // 
            this.menuHiddenEditFlipToolPointerPencil.Name = "menuHiddenEditFlipToolPointerPencil";
            this.menuHiddenEditFlipToolPointerPencil.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.W)));
            this.menuHiddenEditFlipToolPointerPencil.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenEditFlipToolPointerPencil.Text = "Change Tool Pointer / Pencil";
            this.menuHiddenEditFlipToolPointerPencil.Visible = false;
            // 
            // menuHiddenEditFlipToolPointerEraser
            // 
            this.menuHiddenEditFlipToolPointerEraser.Name = "menuHiddenEditFlipToolPointerEraser";
            this.menuHiddenEditFlipToolPointerEraser.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.E)));
            this.menuHiddenEditFlipToolPointerEraser.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenEditFlipToolPointerEraser.Text = "Change Tool Pointer/ Eraser";
            this.menuHiddenEditFlipToolPointerEraser.Visible = false;
            // 
            // menuHiddenVisualForwardParameter
            // 
            this.menuHiddenVisualForwardParameter.Name = "menuHiddenVisualForwardParameter";
            this.menuHiddenVisualForwardParameter.ShortcutKeys = ((System.Windows.Forms.Keys)(((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Alt)
                        | System.Windows.Forms.Keys.Next)));
            this.menuHiddenVisualForwardParameter.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenVisualForwardParameter.Text = "Next Control Curve";
            this.menuHiddenVisualForwardParameter.Visible = false;
            // 
            // menuHiddenVisualBackwardParameter
            // 
            this.menuHiddenVisualBackwardParameter.Name = "menuHiddenVisualBackwardParameter";
            this.menuHiddenVisualBackwardParameter.ShortcutKeys = ((System.Windows.Forms.Keys)(((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Alt)
                        | System.Windows.Forms.Keys.PageUp)));
            this.menuHiddenVisualBackwardParameter.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenVisualBackwardParameter.Text = "Previous Control Curve";
            this.menuHiddenVisualBackwardParameter.Visible = false;
            // 
            // menuHiddenTrackNext
            // 
            this.menuHiddenTrackNext.Name = "menuHiddenTrackNext";
            this.menuHiddenTrackNext.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Next)));
            this.menuHiddenTrackNext.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenTrackNext.Text = "Next Track";
            this.menuHiddenTrackNext.Visible = false;
            // 
            // menuHiddenTrackBack
            // 
            this.menuHiddenTrackBack.Name = "menuHiddenTrackBack";
            this.menuHiddenTrackBack.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.PageUp)));
            this.menuHiddenTrackBack.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenTrackBack.Text = "Previous Track";
            this.menuHiddenTrackBack.Visible = false;
            // 
            // menuHiddenCopy
            // 
            this.menuHiddenCopy.Name = "menuHiddenCopy";
            this.menuHiddenCopy.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenCopy.Text = "Copy";
            // 
            // menuHiddenPaste
            // 
            this.menuHiddenPaste.Name = "menuHiddenPaste";
            this.menuHiddenPaste.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenPaste.Text = "Paste";
            // 
            // menuHiddenCut
            // 
            this.menuHiddenCut.Name = "menuHiddenCut";
            this.menuHiddenCut.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenCut.Text = "Cut";
            // 
            // menuHiddenSelectForward
            // 
            this.menuHiddenSelectForward.Name = "menuHiddenSelectForward";
            this.menuHiddenSelectForward.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Alt | System.Windows.Forms.Keys.Right)));
            this.menuHiddenSelectForward.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenSelectForward.Text = "Select Forward";
            // 
            // menuHiddenSelectBackward
            // 
            this.menuHiddenSelectBackward.Name = "menuHiddenSelectBackward";
            this.menuHiddenSelectBackward.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Alt | System.Windows.Forms.Keys.Left)));
            this.menuHiddenSelectBackward.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenSelectBackward.Text = "Select Backward";
            // 
            // menuHiddenMoveUp
            // 
            this.menuHiddenMoveUp.Name = "menuHiddenMoveUp";
            this.menuHiddenMoveUp.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenMoveUp.Text = "Move Up";
            // 
            // menuHiddenMoveDown
            // 
            this.menuHiddenMoveDown.Name = "menuHiddenMoveDown";
            this.menuHiddenMoveDown.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenMoveDown.Text = "Move Down";
            // 
            // menuHiddenMoveLeft
            // 
            this.menuHiddenMoveLeft.Name = "menuHiddenMoveLeft";
            this.menuHiddenMoveLeft.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenMoveLeft.Text = "Move Left";
            // 
            // menuHiddenMoveRight
            // 
            this.menuHiddenMoveRight.Name = "menuHiddenMoveRight";
            this.menuHiddenMoveRight.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenMoveRight.Text = "Move Right";
            // 
            // menuHiddenLengthen
            // 
            this.menuHiddenLengthen.Name = "menuHiddenLengthen";
            this.menuHiddenLengthen.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenLengthen.Text = "Lengthen";
            // 
            // menuHiddenShorten
            // 
            this.menuHiddenShorten.Name = "menuHiddenShorten";
            this.menuHiddenShorten.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenShorten.Text = "Shorten";
            // 
            // menuHiddenGoToStartMarker
            // 
            this.menuHiddenGoToStartMarker.Name = "menuHiddenGoToStartMarker";
            this.menuHiddenGoToStartMarker.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenGoToStartMarker.Text = "GoTo Start Marker";
            // 
            // menuHiddenGoToEndMarker
            // 
            this.menuHiddenGoToEndMarker.Name = "menuHiddenGoToEndMarker";
            this.menuHiddenGoToEndMarker.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenGoToEndMarker.Text = "GoTo End Marker";
            // 
            // menuHiddenPlayFromStartMarker
            // 
            this.menuHiddenPlayFromStartMarker.Name = "menuHiddenPlayFromStartMarker";
            this.menuHiddenPlayFromStartMarker.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenPlayFromStartMarker.Text = "Play From Start Marker";
            // 
            // menuHiddenFlipCurveOnPianorollMode
            // 
            this.menuHiddenFlipCurveOnPianorollMode.Name = "menuHiddenFlipCurveOnPianorollMode";
            this.menuHiddenFlipCurveOnPianorollMode.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenFlipCurveOnPianorollMode.Text = "Flip Curve on Pianoroll Mode";
            // 
            // cMenuPiano
            // 
            this.cMenuPiano.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuPianoPointer,
            this.cMenuPianoPencil,
            this.cMenuPianoEraser,
            this.cMenuPianoPaletteTool,
            this.toolStripSeparator15,
            this.cMenuPianoCurve,
            this.toolStripMenuItem13,
            this.cMenuPianoFixed,
            this.cMenuPianoQuantize,
            this.cMenuPianoLength,
            this.cMenuPianoGrid,
            this.toolStripMenuItem14,
            this.cMenuPianoUndo,
            this.cMenuPianoRedo,
            this.toolStripMenuItem15,
            this.cMenuPianoCut,
            this.cMenuPianoCopy,
            this.cMenuPianoPaste,
            this.cMenuPianoDelete,
            this.toolStripMenuItem16,
            this.cMenuPianoSelectAll,
            this.cMenuPianoSelectAllEvents,
            this.toolStripMenuItem17,
            this.cMenuPianoImportLyric,
            this.cMenuPianoExpressionProperty,
            this.cMenuPianoVibratoProperty} );
            this.cMenuPiano.Name = "cMenuPiano";
            this.cMenuPiano.ShowCheckMargin = true;
            this.cMenuPiano.ShowImageMargin = false;
            this.cMenuPiano.Size = new System.Drawing.Size( 242, 480 );
            // 
            // cMenuPianoPointer
            // 
            this.cMenuPianoPointer.Name = "cMenuPianoPointer";
            this.cMenuPianoPointer.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoPointer.Text = "Arrow(&A)";
            // 
            // cMenuPianoPencil
            // 
            this.cMenuPianoPencil.Name = "cMenuPianoPencil";
            this.cMenuPianoPencil.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoPencil.Text = "Pencil(&W)";
            // 
            // cMenuPianoEraser
            // 
            this.cMenuPianoEraser.Name = "cMenuPianoEraser";
            this.cMenuPianoEraser.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoEraser.Text = "Eraser(&E)";
            // 
            // cMenuPianoPaletteTool
            // 
            this.cMenuPianoPaletteTool.Name = "cMenuPianoPaletteTool";
            this.cMenuPianoPaletteTool.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoPaletteTool.Text = "Palette Tool";
            // 
            // toolStripSeparator15
            // 
            this.toolStripSeparator15.Name = "toolStripSeparator15";
            this.toolStripSeparator15.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoCurve
            // 
            this.cMenuPianoCurve.Name = "cMenuPianoCurve";
            this.cMenuPianoCurve.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoCurve.Text = "Curve(&V)";
            // 
            // toolStripMenuItem13
            // 
            this.toolStripMenuItem13.Name = "toolStripMenuItem13";
            this.toolStripMenuItem13.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoFixed
            // 
            this.cMenuPianoFixed.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuPianoFixed01,
            this.cMenuPianoFixed02,
            this.cMenuPianoFixed04,
            this.cMenuPianoFixed08,
            this.cMenuPianoFixed16,
            this.cMenuPianoFixed32,
            this.cMenuPianoFixed64,
            this.cMenuPianoFixed128,
            this.cMenuPianoFixedOff,
            this.toolStripMenuItem18,
            this.cMenuPianoFixedTriplet,
            this.cMenuPianoFixedDotted} );
            this.cMenuPianoFixed.Name = "cMenuPianoFixed";
            this.cMenuPianoFixed.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoFixed.Text = "Note Fixed Length(&N)";
            // 
            // cMenuPianoFixed01
            // 
            this.cMenuPianoFixed01.Name = "cMenuPianoFixed01";
            this.cMenuPianoFixed01.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed01.Text = "1/ 1 [1920]";
            // 
            // cMenuPianoFixed02
            // 
            this.cMenuPianoFixed02.Name = "cMenuPianoFixed02";
            this.cMenuPianoFixed02.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed02.Text = "1/ 2 [960]";
            // 
            // cMenuPianoFixed04
            // 
            this.cMenuPianoFixed04.Name = "cMenuPianoFixed04";
            this.cMenuPianoFixed04.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed04.Text = "1/ 4 [480]";
            // 
            // cMenuPianoFixed08
            // 
            this.cMenuPianoFixed08.Name = "cMenuPianoFixed08";
            this.cMenuPianoFixed08.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed08.Text = "1/ 8 [240]";
            // 
            // cMenuPianoFixed16
            // 
            this.cMenuPianoFixed16.Name = "cMenuPianoFixed16";
            this.cMenuPianoFixed16.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed16.Text = "1/16 [120]";
            // 
            // cMenuPianoFixed32
            // 
            this.cMenuPianoFixed32.Name = "cMenuPianoFixed32";
            this.cMenuPianoFixed32.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed32.Text = "1/32 [60]";
            // 
            // cMenuPianoFixed64
            // 
            this.cMenuPianoFixed64.Name = "cMenuPianoFixed64";
            this.cMenuPianoFixed64.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed64.Text = "1/64 [30]";
            // 
            // cMenuPianoFixed128
            // 
            this.cMenuPianoFixed128.Name = "cMenuPianoFixed128";
            this.cMenuPianoFixed128.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed128.Text = "1/128[15]";
            // 
            // cMenuPianoFixedOff
            // 
            this.cMenuPianoFixedOff.Name = "cMenuPianoFixedOff";
            this.cMenuPianoFixedOff.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixedOff.Text = "オフ";
            // 
            // toolStripMenuItem18
            // 
            this.toolStripMenuItem18.Name = "toolStripMenuItem18";
            this.toolStripMenuItem18.Size = new System.Drawing.Size( 138, 6 );
            // 
            // cMenuPianoFixedTriplet
            // 
            this.cMenuPianoFixedTriplet.Name = "cMenuPianoFixedTriplet";
            this.cMenuPianoFixedTriplet.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixedTriplet.Text = "3連符";
            // 
            // cMenuPianoFixedDotted
            // 
            this.cMenuPianoFixedDotted.Name = "cMenuPianoFixedDotted";
            this.cMenuPianoFixedDotted.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixedDotted.Text = "付点";
            // 
            // cMenuPianoQuantize
            // 
            this.cMenuPianoQuantize.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuPianoQuantize04,
            this.cMenuPianoQuantize08,
            this.cMenuPianoQuantize16,
            this.cMenuPianoQuantize32,
            this.cMenuPianoQuantize64,
            this.cMenuPianoQuantize128,
            this.cMenuPianoQuantizeOff,
            this.toolStripMenuItem26,
            this.cMenuPianoQuantizeTriplet} );
            this.cMenuPianoQuantize.Name = "cMenuPianoQuantize";
            this.cMenuPianoQuantize.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoQuantize.Text = "Quantize(&Q)";
            // 
            // cMenuPianoQuantize04
            // 
            this.cMenuPianoQuantize04.Name = "cMenuPianoQuantize04";
            this.cMenuPianoQuantize04.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantize04.Text = "1/4";
            // 
            // cMenuPianoQuantize08
            // 
            this.cMenuPianoQuantize08.Name = "cMenuPianoQuantize08";
            this.cMenuPianoQuantize08.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantize08.Text = "1/8";
            // 
            // cMenuPianoQuantize16
            // 
            this.cMenuPianoQuantize16.Name = "cMenuPianoQuantize16";
            this.cMenuPianoQuantize16.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantize16.Text = "1/16";
            // 
            // cMenuPianoQuantize32
            // 
            this.cMenuPianoQuantize32.Name = "cMenuPianoQuantize32";
            this.cMenuPianoQuantize32.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantize32.Text = "1/32";
            // 
            // cMenuPianoQuantize64
            // 
            this.cMenuPianoQuantize64.Name = "cMenuPianoQuantize64";
            this.cMenuPianoQuantize64.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantize64.Text = "1/64";
            // 
            // cMenuPianoQuantize128
            // 
            this.cMenuPianoQuantize128.Name = "cMenuPianoQuantize128";
            this.cMenuPianoQuantize128.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantize128.Text = "1/128";
            // 
            // cMenuPianoQuantizeOff
            // 
            this.cMenuPianoQuantizeOff.Name = "cMenuPianoQuantizeOff";
            this.cMenuPianoQuantizeOff.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantizeOff.Text = "オフ";
            // 
            // toolStripMenuItem26
            // 
            this.toolStripMenuItem26.Name = "toolStripMenuItem26";
            this.toolStripMenuItem26.Size = new System.Drawing.Size( 106, 6 );
            // 
            // cMenuPianoQuantizeTriplet
            // 
            this.cMenuPianoQuantizeTriplet.Name = "cMenuPianoQuantizeTriplet";
            this.cMenuPianoQuantizeTriplet.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantizeTriplet.Text = "3連符";
            // 
            // cMenuPianoLength
            // 
            this.cMenuPianoLength.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuPianoLength04,
            this.cMenuPianoLength08,
            this.cMenuPianoLength16,
            this.cMenuPianoLength32,
            this.cMenuPianoLength64,
            this.cMenuPianoLength128,
            this.cMenuPianoLengthOff,
            this.toolStripMenuItem32,
            this.cMenuPianoLengthTriplet} );
            this.cMenuPianoLength.Name = "cMenuPianoLength";
            this.cMenuPianoLength.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoLength.Text = "Length(&L)";
            // 
            // cMenuPianoLength04
            // 
            this.cMenuPianoLength04.Name = "cMenuPianoLength04";
            this.cMenuPianoLength04.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLength04.Text = "1/4";
            // 
            // cMenuPianoLength08
            // 
            this.cMenuPianoLength08.Name = "cMenuPianoLength08";
            this.cMenuPianoLength08.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLength08.Text = "1/8";
            // 
            // cMenuPianoLength16
            // 
            this.cMenuPianoLength16.Name = "cMenuPianoLength16";
            this.cMenuPianoLength16.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLength16.Text = "1/16";
            // 
            // cMenuPianoLength32
            // 
            this.cMenuPianoLength32.Name = "cMenuPianoLength32";
            this.cMenuPianoLength32.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLength32.Text = "1/32";
            // 
            // cMenuPianoLength64
            // 
            this.cMenuPianoLength64.Name = "cMenuPianoLength64";
            this.cMenuPianoLength64.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLength64.Text = "1/64";
            // 
            // cMenuPianoLength128
            // 
            this.cMenuPianoLength128.Name = "cMenuPianoLength128";
            this.cMenuPianoLength128.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLength128.Text = "1/128";
            // 
            // cMenuPianoLengthOff
            // 
            this.cMenuPianoLengthOff.Name = "cMenuPianoLengthOff";
            this.cMenuPianoLengthOff.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLengthOff.Text = "オフ";
            // 
            // toolStripMenuItem32
            // 
            this.toolStripMenuItem32.Name = "toolStripMenuItem32";
            this.toolStripMenuItem32.Size = new System.Drawing.Size( 106, 6 );
            // 
            // cMenuPianoLengthTriplet
            // 
            this.cMenuPianoLengthTriplet.Name = "cMenuPianoLengthTriplet";
            this.cMenuPianoLengthTriplet.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLengthTriplet.Text = "3連符";
            // 
            // cMenuPianoGrid
            // 
            this.cMenuPianoGrid.Name = "cMenuPianoGrid";
            this.cMenuPianoGrid.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoGrid.Text = "Show/Hide Grid Line(&S)";
            // 
            // toolStripMenuItem14
            // 
            this.toolStripMenuItem14.Name = "toolStripMenuItem14";
            this.toolStripMenuItem14.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoUndo
            // 
            this.cMenuPianoUndo.Name = "cMenuPianoUndo";
            this.cMenuPianoUndo.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoUndo.Text = "Undo(&U)";
            // 
            // cMenuPianoRedo
            // 
            this.cMenuPianoRedo.Name = "cMenuPianoRedo";
            this.cMenuPianoRedo.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoRedo.Text = "Redo(&R)";
            // 
            // toolStripMenuItem15
            // 
            this.toolStripMenuItem15.Name = "toolStripMenuItem15";
            this.toolStripMenuItem15.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoCut
            // 
            this.cMenuPianoCut.Name = "cMenuPianoCut";
            this.cMenuPianoCut.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoCut.Text = "Cut(&T)";
            // 
            // cMenuPianoCopy
            // 
            this.cMenuPianoCopy.Name = "cMenuPianoCopy";
            this.cMenuPianoCopy.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoCopy.Text = "Copy(&C)";
            // 
            // cMenuPianoPaste
            // 
            this.cMenuPianoPaste.Name = "cMenuPianoPaste";
            this.cMenuPianoPaste.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoPaste.Text = "Paste(&P)";
            // 
            // cMenuPianoDelete
            // 
            this.cMenuPianoDelete.Name = "cMenuPianoDelete";
            this.cMenuPianoDelete.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoDelete.Text = "Delete(&D)";
            // 
            // toolStripMenuItem16
            // 
            this.toolStripMenuItem16.Name = "toolStripMenuItem16";
            this.toolStripMenuItem16.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoSelectAll
            // 
            this.cMenuPianoSelectAll.Name = "cMenuPianoSelectAll";
            this.cMenuPianoSelectAll.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoSelectAll.Text = "Select All(&A)";
            // 
            // cMenuPianoSelectAllEvents
            // 
            this.cMenuPianoSelectAllEvents.Name = "cMenuPianoSelectAllEvents";
            this.cMenuPianoSelectAllEvents.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoSelectAllEvents.Text = "Select All Events(&E)";
            // 
            // toolStripMenuItem17
            // 
            this.toolStripMenuItem17.Name = "toolStripMenuItem17";
            this.toolStripMenuItem17.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoImportLyric
            // 
            this.cMenuPianoImportLyric.Name = "cMenuPianoImportLyric";
            this.cMenuPianoImportLyric.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoImportLyric.Text = "Insert Lyrics(&L)";
            // 
            // cMenuPianoExpressionProperty
            // 
            this.cMenuPianoExpressionProperty.Name = "cMenuPianoExpressionProperty";
            this.cMenuPianoExpressionProperty.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoExpressionProperty.Text = "Note Expression Property(&P)";
            // 
            // cMenuPianoVibratoProperty
            // 
            this.cMenuPianoVibratoProperty.Name = "cMenuPianoVibratoProperty";
            this.cMenuPianoVibratoProperty.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoVibratoProperty.Text = "Note Vibrato Property";
            // 
            // cMenuTrackTab
            // 
            this.cMenuTrackTab.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuTrackTabTrackOn,
            this.cMenuTrackTabPlayAfterSynth,
            this.toolStripMenuItem24,
            this.cMenuTrackTabAdd,
            this.cMenuTrackTabCopy,
            this.cMenuTrackTabChangeName,
            this.cMenuTrackTabDelete,
            this.toolStripMenuItem25,
            this.cMenuTrackTabRenderCurrent,
            this.cMenuTrackTabRenderAll,
            this.toolStripMenuItem27,
            this.cMenuTrackTabOverlay,
            this.cMenuTrackTabRenderer} );
            this.cMenuTrackTab.Name = "cMenuTrackTab";
            this.cMenuTrackTab.Size = new System.Drawing.Size( 220, 242 );
            // 
            // cMenuTrackTabTrackOn
            // 
            this.cMenuTrackTabTrackOn.Name = "cMenuTrackTabTrackOn";
            this.cMenuTrackTabTrackOn.Size = new System.Drawing.Size( 219, 22 );
            this.cMenuTrackTabTrackOn.Text = "Track On(&K)";
            // 
            // cMenuTrackTabPlayAfterSynth
            // 
            this.cMenuTrackTabPlayAfterSynth.Name = "cMenuTrackTabPlayAfterSynth";
            this.cMenuTrackTabPlayAfterSynth.Size = new System.Drawing.Size( 219, 22 );
            this.cMenuTrackTabPlayAfterSynth.Text = "Play After Synth(&P)";
            // 
            // toolStripMenuItem24
            // 
            this.toolStripMenuItem24.Name = "toolStripMenuItem24";
            this.toolStripMenuItem24.Size = new System.Drawing.Size( 216, 6 );
            // 
            // cMenuTrackTabAdd
            // 
            this.cMenuTrackTabAdd.Name = "cMenuTrackTabAdd";
            this.cMenuTrackTabAdd.Size = new System.Drawing.Size( 219, 22 );
            this.cMenuTrackTabAdd.Text = "Add Track(&A)";
            // 
            // cMenuTrackTabCopy
            // 
            this.cMenuTrackTabCopy.Name = "cMenuTrackTabCopy";
            this.cMenuTrackTabCopy.Size = new System.Drawing.Size( 219, 22 );
            this.cMenuTrackTabCopy.Text = "Copy Track(&C)";
            // 
            // cMenuTrackTabChangeName
            // 
            this.cMenuTrackTabChangeName.Name = "cMenuTrackTabChangeName";
            this.cMenuTrackTabChangeName.Size = new System.Drawing.Size( 219, 22 );
            this.cMenuTrackTabChangeName.Text = "Rename Track";
            // 
            // cMenuTrackTabDelete
            // 
            this.cMenuTrackTabDelete.Name = "cMenuTrackTabDelete";
            this.cMenuTrackTabDelete.Size = new System.Drawing.Size( 219, 22 );
            this.cMenuTrackTabDelete.Text = "Delete Track(&D)";
            // 
            // toolStripMenuItem25
            // 
            this.toolStripMenuItem25.Name = "toolStripMenuItem25";
            this.toolStripMenuItem25.Size = new System.Drawing.Size( 216, 6 );
            // 
            // cMenuTrackTabRenderCurrent
            // 
            this.cMenuTrackTabRenderCurrent.Name = "cMenuTrackTabRenderCurrent";
            this.cMenuTrackTabRenderCurrent.Size = new System.Drawing.Size( 219, 22 );
            this.cMenuTrackTabRenderCurrent.Text = "Render Current Track(&T)";
            // 
            // cMenuTrackTabRenderAll
            // 
            this.cMenuTrackTabRenderAll.Name = "cMenuTrackTabRenderAll";
            this.cMenuTrackTabRenderAll.Size = new System.Drawing.Size( 219, 22 );
            this.cMenuTrackTabRenderAll.Text = "Render All Tracks(&S)";
            // 
            // toolStripMenuItem27
            // 
            this.toolStripMenuItem27.Name = "toolStripMenuItem27";
            this.toolStripMenuItem27.Size = new System.Drawing.Size( 216, 6 );
            // 
            // cMenuTrackTabOverlay
            // 
            this.cMenuTrackTabOverlay.Name = "cMenuTrackTabOverlay";
            this.cMenuTrackTabOverlay.Size = new System.Drawing.Size( 219, 22 );
            this.cMenuTrackTabOverlay.Text = "Overlay(&O)";
            // 
            // cMenuTrackTabRenderer
            // 
            this.cMenuTrackTabRenderer.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuTrackTabRendererVOCALOID100,
            this.cMenuTrackTabRendererVOCALOID101,
            this.cMenuTrackTabRendererVOCALOID2,
            this.cMenuTrackTabRendererUtau,
            this.cMenuTrackTabRendererStraight,
            this.cMenuTrackTabRendererAquesTone} );
            this.cMenuTrackTabRenderer.Name = "cMenuTrackTabRenderer";
            this.cMenuTrackTabRenderer.Size = new System.Drawing.Size( 219, 22 );
            this.cMenuTrackTabRenderer.Text = "Renderer(&R)";
            // 
            // cMenuTrackTabRendererVOCALOID100
            // 
            this.cMenuTrackTabRendererVOCALOID100.Name = "cMenuTrackTabRendererVOCALOID100";
            this.cMenuTrackTabRendererVOCALOID100.Size = new System.Drawing.Size( 199, 22 );
            this.cMenuTrackTabRendererVOCALOID100.Text = "VOCALOID1 [1.0] (&1)";
            // 
            // cMenuTrackTabRendererVOCALOID101
            // 
            this.cMenuTrackTabRendererVOCALOID101.Name = "cMenuTrackTabRendererVOCALOID101";
            this.cMenuTrackTabRendererVOCALOID101.Size = new System.Drawing.Size( 199, 22 );
            this.cMenuTrackTabRendererVOCALOID101.Text = "VOCALOID1 [1.1] (&2)";
            // 
            // cMenuTrackTabRendererVOCALOID2
            // 
            this.cMenuTrackTabRendererVOCALOID2.Name = "cMenuTrackTabRendererVOCALOID2";
            this.cMenuTrackTabRendererVOCALOID2.Size = new System.Drawing.Size( 199, 22 );
            this.cMenuTrackTabRendererVOCALOID2.Text = "VOCALOID2(&3)";
            // 
            // cMenuTrackTabRendererUtau
            // 
            this.cMenuTrackTabRendererUtau.Name = "cMenuTrackTabRendererUtau";
            this.cMenuTrackTabRendererUtau.Size = new System.Drawing.Size( 199, 22 );
            this.cMenuTrackTabRendererUtau.Text = "UTAU(&4)";
            // 
            // cMenuTrackTabRendererStraight
            // 
            this.cMenuTrackTabRendererStraight.Name = "cMenuTrackTabRendererStraight";
            this.cMenuTrackTabRendererStraight.Size = new System.Drawing.Size( 199, 22 );
            this.cMenuTrackTabRendererStraight.Text = "Straight X UTAU(&5) ";
            // 
            // cMenuTrackTabRendererAquesTone
            // 
            this.cMenuTrackTabRendererAquesTone.Name = "cMenuTrackTabRendererAquesTone";
            this.cMenuTrackTabRendererAquesTone.Size = new System.Drawing.Size( 199, 22 );
            this.cMenuTrackTabRendererAquesTone.Text = "AquesTone(&6)";
            // 
            // cMenuTrackSelector
            // 
            this.cMenuTrackSelector.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuTrackSelectorPointer,
            this.cMenuTrackSelectorPencil,
            this.cMenuTrackSelectorLine,
            this.cMenuTrackSelectorEraser,
            this.cMenuTrackSelectorPaletteTool,
            this.toolStripSeparator14,
            this.cMenuTrackSelectorCurve,
            this.toolStripMenuItem28,
            this.cMenuTrackSelectorUndo,
            this.cMenuTrackSelectorRedo,
            this.toolStripMenuItem29,
            this.cMenuTrackSelectorCut,
            this.cMenuTrackSelectorCopy,
            this.cMenuTrackSelectorPaste,
            this.cMenuTrackSelectorDelete,
            this.cMenuTrackSelectorDeleteBezier,
            this.toolStripMenuItem31,
            this.cMenuTrackSelectorSelectAll} );
            this.cMenuTrackSelector.Name = "cMenuTrackSelector";
            this.cMenuTrackSelector.Size = new System.Drawing.Size( 206, 336 );
            // 
            // cMenuTrackSelectorPointer
            // 
            this.cMenuTrackSelectorPointer.Name = "cMenuTrackSelectorPointer";
            this.cMenuTrackSelectorPointer.Size = new System.Drawing.Size( 205, 22 );
            this.cMenuTrackSelectorPointer.Text = "Arrow(&A)";
            // 
            // cMenuTrackSelectorPencil
            // 
            this.cMenuTrackSelectorPencil.Name = "cMenuTrackSelectorPencil";
            this.cMenuTrackSelectorPencil.Size = new System.Drawing.Size( 205, 22 );
            this.cMenuTrackSelectorPencil.Text = "Pencil(&W)";
            // 
            // cMenuTrackSelectorLine
            // 
            this.cMenuTrackSelectorLine.Name = "cMenuTrackSelectorLine";
            this.cMenuTrackSelectorLine.Size = new System.Drawing.Size( 205, 22 );
            this.cMenuTrackSelectorLine.Text = "Line(&L)";
            // 
            // cMenuTrackSelectorEraser
            // 
            this.cMenuTrackSelectorEraser.Name = "cMenuTrackSelectorEraser";
            this.cMenuTrackSelectorEraser.Size = new System.Drawing.Size( 205, 22 );
            this.cMenuTrackSelectorEraser.Text = "Eraser(&E)";
            // 
            // cMenuTrackSelectorPaletteTool
            // 
            this.cMenuTrackSelectorPaletteTool.Name = "cMenuTrackSelectorPaletteTool";
            this.cMenuTrackSelectorPaletteTool.Size = new System.Drawing.Size( 205, 22 );
            this.cMenuTrackSelectorPaletteTool.Text = "Palette Tool";
            // 
            // toolStripSeparator14
            // 
            this.toolStripSeparator14.Name = "toolStripSeparator14";
            this.toolStripSeparator14.Size = new System.Drawing.Size( 202, 6 );
            // 
            // cMenuTrackSelectorCurve
            // 
            this.cMenuTrackSelectorCurve.Name = "cMenuTrackSelectorCurve";
            this.cMenuTrackSelectorCurve.Size = new System.Drawing.Size( 205, 22 );
            this.cMenuTrackSelectorCurve.Text = "Curve(&V)";
            // 
            // toolStripMenuItem28
            // 
            this.toolStripMenuItem28.Name = "toolStripMenuItem28";
            this.toolStripMenuItem28.Size = new System.Drawing.Size( 202, 6 );
            // 
            // cMenuTrackSelectorUndo
            // 
            this.cMenuTrackSelectorUndo.Name = "cMenuTrackSelectorUndo";
            this.cMenuTrackSelectorUndo.Size = new System.Drawing.Size( 205, 22 );
            this.cMenuTrackSelectorUndo.Text = "Undo(&U)";
            // 
            // cMenuTrackSelectorRedo
            // 
            this.cMenuTrackSelectorRedo.Name = "cMenuTrackSelectorRedo";
            this.cMenuTrackSelectorRedo.Size = new System.Drawing.Size( 205, 22 );
            this.cMenuTrackSelectorRedo.Text = "Redo(&R)";
            // 
            // toolStripMenuItem29
            // 
            this.toolStripMenuItem29.Name = "toolStripMenuItem29";
            this.toolStripMenuItem29.Size = new System.Drawing.Size( 202, 6 );
            // 
            // cMenuTrackSelectorCut
            // 
            this.cMenuTrackSelectorCut.Name = "cMenuTrackSelectorCut";
            this.cMenuTrackSelectorCut.Size = new System.Drawing.Size( 205, 22 );
            this.cMenuTrackSelectorCut.Text = "Cut(&T)";
            // 
            // cMenuTrackSelectorCopy
            // 
            this.cMenuTrackSelectorCopy.Name = "cMenuTrackSelectorCopy";
            this.cMenuTrackSelectorCopy.Size = new System.Drawing.Size( 205, 22 );
            this.cMenuTrackSelectorCopy.Text = "Copy(&C)";
            // 
            // cMenuTrackSelectorPaste
            // 
            this.cMenuTrackSelectorPaste.Name = "cMenuTrackSelectorPaste";
            this.cMenuTrackSelectorPaste.Size = new System.Drawing.Size( 205, 22 );
            this.cMenuTrackSelectorPaste.Text = "Paste(&P)";
            // 
            // cMenuTrackSelectorDelete
            // 
            this.cMenuTrackSelectorDelete.Name = "cMenuTrackSelectorDelete";
            this.cMenuTrackSelectorDelete.Size = new System.Drawing.Size( 205, 22 );
            this.cMenuTrackSelectorDelete.Text = "Delete(&D)";
            // 
            // cMenuTrackSelectorDeleteBezier
            // 
            this.cMenuTrackSelectorDeleteBezier.Name = "cMenuTrackSelectorDeleteBezier";
            this.cMenuTrackSelectorDeleteBezier.Size = new System.Drawing.Size( 205, 22 );
            this.cMenuTrackSelectorDeleteBezier.Text = "Delete Bezier Point(&B)";
            // 
            // toolStripMenuItem31
            // 
            this.toolStripMenuItem31.Name = "toolStripMenuItem31";
            this.toolStripMenuItem31.Size = new System.Drawing.Size( 202, 6 );
            // 
            // cMenuTrackSelectorSelectAll
            // 
            this.cMenuTrackSelectorSelectAll.Name = "cMenuTrackSelectorSelectAll";
            this.cMenuTrackSelectorSelectAll.Size = new System.Drawing.Size( 205, 22 );
            this.cMenuTrackSelectorSelectAll.Text = "Select All Events(&E)";
            // 
            // trackBar
            // 
            this.trackBar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.trackBar.AutoSize = false;
            this.trackBar.Location = new System.Drawing.Point( 322, 266 );
            this.trackBar.Margin = new System.Windows.Forms.Padding( 0 );
            this.trackBar.Maximum = 609;
            this.trackBar.Minimum = 17;
            this.trackBar.Name = "trackBar";
            this.trackBar.Size = new System.Drawing.Size( 83, 16 );
            this.trackBar.TabIndex = 15;
            this.trackBar.TabStop = false;
            this.trackBar.TickFrequency = 100;
            this.trackBar.TickStyle = System.Windows.Forms.TickStyle.None;
            this.trackBar.Value = 17;
            // 
            // panel1
            // 
            this.panel1.Controls.Add( this.hScroll );
            this.panel1.Controls.Add( this.pictureBox3 );
            this.panel1.Controls.Add( this.pictKeyLengthSplitter );
            this.panel1.Controls.Add( this.trackBar );
            this.panel1.Controls.Add( this.pictureBox2 );
            this.panel1.Controls.Add( this.vScroll );
            this.panel1.Controls.Add( this.panelOverview );
            this.panel1.Controls.Add( this.picturePositionIndicator );
            this.panel1.Controls.Add( this.pictPianoRoll );
            this.panel1.Location = new System.Drawing.Point( 0, 0 );
            this.panel1.Margin = new System.Windows.Forms.Padding( 0 );
            this.panel1.Name = "panel1";
            this.panel1.Size = new System.Drawing.Size( 421, 282 );
            this.panel1.TabIndex = 16;
            // 
            // pictureBox3
            // 
            this.pictureBox3.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.pictureBox3.BackColor = System.Drawing.Color.FromArgb( ((int)(((byte)(224)))), ((int)(((byte)(224)))), ((int)(((byte)(224)))) );
            this.pictureBox3.Location = new System.Drawing.Point( 0, 266 );
            this.pictureBox3.Margin = new System.Windows.Forms.Padding( 0 );
            this.pictureBox3.Name = "pictureBox3";
            this.pictureBox3.Size = new System.Drawing.Size( 49, 16 );
            this.pictureBox3.TabIndex = 8;
            this.pictureBox3.TabStop = false;
            // 
            // pictKeyLengthSplitter
            // 
            this.pictKeyLengthSplitter.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.pictKeyLengthSplitter.BackColor = System.Drawing.SystemColors.Control;
            this.pictKeyLengthSplitter.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.pictKeyLengthSplitter.Cursor = System.Windows.Forms.Cursors.NoMoveHoriz;
            this.pictKeyLengthSplitter.Location = new System.Drawing.Point( 50, 266 );
            this.pictKeyLengthSplitter.Margin = new System.Windows.Forms.Padding( 0 );
            this.pictKeyLengthSplitter.Name = "pictKeyLengthSplitter";
            this.pictKeyLengthSplitter.Size = new System.Drawing.Size( 16, 16 );
            this.pictKeyLengthSplitter.TabIndex = 20;
            this.pictKeyLengthSplitter.TabStop = false;
            // 
            // pictureBox2
            // 
            this.pictureBox2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.pictureBox2.BackColor = System.Drawing.SystemColors.Control;
            this.pictureBox2.Location = new System.Drawing.Point( 405, 266 );
            this.pictureBox2.Margin = new System.Windows.Forms.Padding( 0 );
            this.pictureBox2.Name = "pictureBox2";
            this.pictureBox2.Size = new System.Drawing.Size( 16, 16 );
            this.pictureBox2.TabIndex = 5;
            this.pictureBox2.TabStop = false;
            // 
            // vScroll
            // 
            this.vScroll.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.vScroll.Location = new System.Drawing.Point( 405, 93 );
            this.vScroll.Name = "vScroll";
            this.vScroll.Size = new System.Drawing.Size( 16, 173 );
            this.vScroll.TabIndex = 17;
            // 
            // panelOverview
            // 
            this.panelOverview.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.panelOverview.BackColor = System.Drawing.Color.FromArgb( ((int)(((byte)(106)))), ((int)(((byte)(108)))), ((int)(((byte)(108)))) );
            this.panelOverview.Location = new System.Drawing.Point( 0, 0 );
            this.panelOverview.Margin = new System.Windows.Forms.Padding( 0 );
            this.panelOverview.Name = "panelOverview";
            this.panelOverview.Size = new System.Drawing.Size( 421, 45 );
            this.panelOverview.TabIndex = 19;
            this.panelOverview.TabStop = false;
            // 
            // picturePositionIndicator
            // 
            this.picturePositionIndicator.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.picturePositionIndicator.BackColor = System.Drawing.Color.DarkGray;
            this.picturePositionIndicator.Location = new System.Drawing.Point( 0, 45 );
            this.picturePositionIndicator.Margin = new System.Windows.Forms.Padding( 0 );
            this.picturePositionIndicator.Name = "picturePositionIndicator";
            this.picturePositionIndicator.Size = new System.Drawing.Size( 421, 48 );
            this.picturePositionIndicator.TabIndex = 10;
            this.picturePositionIndicator.TabStop = false;
            // 
            // toolStripTool
            // 
            this.toolStripTool.Dock = System.Windows.Forms.DockStyle.None;
            this.toolStripTool.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.stripBtnPointer,
            this.stripBtnPencil,
            this.stripBtnLine,
            this.stripBtnEraser,
            this.toolStripSeparator5,
            this.stripBtnGrid,
            this.stripBtnCurve} );
            this.toolStripTool.Location = new System.Drawing.Point( 3, 75 );
            this.toolStripTool.Name = "toolStripTool";
            this.toolStripTool.Size = new System.Drawing.Size( 283, 25 );
            this.toolStripTool.TabIndex = 17;
            this.toolStripTool.Text = "toolStrip1";
            // 
            // stripBtnPointer
            // 
            this.stripBtnPointer.Checked = true;
            this.stripBtnPointer.CheckState = System.Windows.Forms.CheckState.Checked;
            this.stripBtnPointer.ImageScaling = System.Windows.Forms.ToolStripItemImageScaling.None;
            this.stripBtnPointer.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.stripBtnPointer.Name = "stripBtnPointer";
            this.stripBtnPointer.Overflow = System.Windows.Forms.ToolStripItemOverflow.Never;
            this.stripBtnPointer.Size = new System.Drawing.Size( 53, 22 );
            this.stripBtnPointer.Text = "Pointer";
            // 
            // stripBtnPencil
            // 
            this.stripBtnPencil.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.stripBtnPencil.Name = "stripBtnPencil";
            this.stripBtnPencil.Size = new System.Drawing.Size( 45, 22 );
            this.stripBtnPencil.Text = "Pencil";
            // 
            // stripBtnLine
            // 
            this.stripBtnLine.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.stripBtnLine.Name = "stripBtnLine";
            this.stripBtnLine.Size = new System.Drawing.Size( 36, 22 );
            this.stripBtnLine.Text = "Line";
            // 
            // stripBtnEraser
            // 
            this.stripBtnEraser.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.stripBtnEraser.Name = "stripBtnEraser";
            this.stripBtnEraser.Size = new System.Drawing.Size( 49, 22 );
            this.stripBtnEraser.Text = "Eraser";
            // 
            // toolStripSeparator5
            // 
            this.toolStripSeparator5.Name = "toolStripSeparator5";
            this.toolStripSeparator5.Size = new System.Drawing.Size( 6, 25 );
            // 
            // stripBtnGrid
            // 
            this.stripBtnGrid.CheckOnClick = true;
            this.stripBtnGrid.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.stripBtnGrid.Name = "stripBtnGrid";
            this.stripBtnGrid.Size = new System.Drawing.Size( 36, 22 );
            this.stripBtnGrid.Text = "Grid";
            // 
            // stripBtnCurve
            // 
            this.stripBtnCurve.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.stripBtnCurve.Name = "stripBtnCurve";
            this.stripBtnCurve.Size = new System.Drawing.Size( 46, 22 );
            this.stripBtnCurve.Text = "Curve";
            // 
            // toolStripContainer
            // 
            // 
            // toolStripContainer.BottomToolStripPanel
            // 
            this.toolStripContainer.BottomToolStripPanel.Controls.Add( this.toolStripBottom );
            this.toolStripContainer.BottomToolStripPanel.Controls.Add( this.statusStrip1 );
            // 
            // toolStripContainer.ContentPanel
            // 
            this.toolStripContainer.ContentPanel.AutoScroll = true;
            this.toolStripContainer.ContentPanel.Controls.Add( this.splitContainerProperty );
            this.toolStripContainer.ContentPanel.Controls.Add( this.panel2 );
            this.toolStripContainer.ContentPanel.Controls.Add( this.splitContainer2 );
            this.toolStripContainer.ContentPanel.Controls.Add( this.splitContainer1 );
            this.toolStripContainer.ContentPanel.Controls.Add( this.panel1 );
            this.toolStripContainer.ContentPanel.Margin = new System.Windows.Forms.Padding( 0 );
            this.toolStripContainer.ContentPanel.Size = new System.Drawing.Size( 960, 516 );
            this.toolStripContainer.Dock = System.Windows.Forms.DockStyle.Fill;
            this.toolStripContainer.LeftToolStripPanelVisible = false;
            this.toolStripContainer.Location = new System.Drawing.Point( 0, 26 );
            this.toolStripContainer.Name = "toolStripContainer";
            this.toolStripContainer.RightToolStripPanelVisible = false;
            this.toolStripContainer.Size = new System.Drawing.Size( 960, 663 );
            this.toolStripContainer.TabIndex = 18;
            this.toolStripContainer.Text = "toolStripContainer1";
            // 
            // toolStripContainer.TopToolStripPanel
            // 
            this.toolStripContainer.TopToolStripPanel.Controls.Add( this.toolStripFile );
            this.toolStripContainer.TopToolStripPanel.Controls.Add( this.toolStripPosition );
            this.toolStripContainer.TopToolStripPanel.Controls.Add( this.toolStripMeasure );
            this.toolStripContainer.TopToolStripPanel.Controls.Add( this.toolStripTool );
            this.toolStripContainer.TopToolStripPanel.RenderMode = System.Windows.Forms.ToolStripRenderMode.System;
            // 
            // toolStripBottom
            // 
            this.toolStripBottom.Dock = System.Windows.Forms.DockStyle.None;
            this.toolStripBottom.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.toolStripStatusLabel1,
            this.stripLblGameCtrlMode,
            this.toolStripSeparator10,
            this.toolStripStatusLabel2,
            this.stripLblMidiIn,
            this.toolStripSeparator11,
            this.stripDDBtnSpeed} );
            this.toolStripBottom.Location = new System.Drawing.Point( 5, 0 );
            this.toolStripBottom.Name = "toolStripBottom";
            this.toolStripBottom.Size = new System.Drawing.Size( 409, 25 );
            this.toolStripBottom.TabIndex = 22;
            // 
            // toolStripStatusLabel1
            // 
            this.toolStripStatusLabel1.Name = "toolStripStatusLabel1";
            this