/*
 * UstEvent.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.IO;
using System.Collections.Generic;
using System.Text;

namespace Boare.Lib.Vsq{

    public class UstEvent : ICloneable {
        protected object m_tag;
        private int m_length = 0;
        private string m_lyric = "";
        private int m_note = -1;
        private int m_intensity = -1;
        private int m_pb_type = -1;
        private float[] m_pitches = null;
        private float m_tempo = -1;

        public object Tag {
            get {
                return m_tag;
            }
            set {
                m_tag = value;
            }
        }

        public object Clone(){
            UstEvent ret = new UstEvent();
            ret.m_length = m_length;
            ret.m_lyric = m_lyric;
            ret.m_note = m_note;
            ret.m_intensity = m_intensity;
            ret.m_pb_type = m_pb_type;
            if ( m_pitches != null ) {
                ret.m_pitches = new float[m_pitches.Length];
                for ( int i = 0; i < m_pitches.Length; i++ ) {
                    ret.m_pitches[i] = m_pitches[i];
                }
            }
            ret.m_tempo = m_tempo;
            return ret;
        }

        public int Length{
            get{
                return m_length;
            }
            set{
                m_length = value;
            }
        }
        
        public string Lyric{
            get{
                return m_lyric;
            }
            set{
                m_lyric = value;
            }
        }
        
        public int NoteNum{
            get{
                return m_note;
            }
            set{
                m_note = value;
            }
        }
        
        public int Intensity{
            get{
                return m_intensity;
            }
            set{
                m_intensity = value;
            }
        }
        
        public int PBType{
            get{
                return m_pb_type;
            }
            set{
                m_pb_type = value;
            }
        }
        
        public float[] Pitches{
            get{
                return m_pitches;
            }
            set{
                m_pitches = value;
            }
        }
        
        public float Tempo{
            get{
                return m_tempo;
            }
            set{
                m_tempo = value;
            }
        }

        public void Print( StreamWriter sw, uint index ){
            sw.WriteLine( string.Format( "[#{0:d4}]", index ) );
            sw.WriteLine( "Length=" + m_length );
            sw.WriteLine( "Lyric=" + m_lyric );
            sw.WriteLine( "NoteNum=" + m_note );
            if ( m_intensity >= 0 ) {
                sw.WriteLine( "Intensity=" + m_intensity );
            }
            if ( m_pb_type >= 0 && m_pitches != null ) {
                sw.WriteLine( "PBType=" + m_pb_type );
                sw.Write( "Piches=" );
                for ( int i = 0; i < m_pitches.Length; i++ ) {
                    if ( i == 0 ) {
                        sw.Write( m_pitches[i] );
                    } else {
                        sw.Write( "," + m_pitches[i] );
                    }
                }
                sw.WriteLine();
            }
            if ( m_tempo > 0 ) {
                sw.WriteLine( "Tempo=" + m_tempo );
            }
        }
    }
    
}
