﻿/*
 * SelectedEventList.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the GPLv3 License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;

using Boare.Lib.Vsq;
using bocoree;

namespace Boare.Cadencii {

    using boolean = System.Boolean;
    using Integer = Int32;

    public class SelectedEventList {
        private Vector<SelectedEventEntry> m_list = new Vector<SelectedEventEntry>();

        public IEnumerable<SelectedEventEntry> GetEnumerator() {
            for ( Iterator itr = m_list.iterator(); itr.hasNext(); ){
                SelectedEventEntry see = (SelectedEventEntry)itr.next();
                yield return see;
            }
        }

        public int Count {
            get {
                return m_list.size();
            }
        }

        public int LastSelectedID {
            get {
                if ( m_list.size() <= 0 ) {
                    return -1;
                } else {
                    return m_list.get( m_list.size() - 1 ).Original.InternalID;
                }
            }
        }

        public void Clear() {
            m_list.clear();
        }

        public SelectedEventEntry LastSelected {
            get {
                if ( m_list.size() <= 0 ) {
                    return null;
                } else {
                    return m_list.get( m_list.size() - 1 );
                }
            }
        }

        public void Add( SelectedEventEntry ve ) {
            for ( int i = 0; i < m_list.size(); i++ ) {
                if ( m_list.get( i ).Original.InternalID == ve.Original.InternalID ) {
                    m_list.removeElementAt( i );
                    break;
                }
            }
            m_list.add( ve );
        }

        public void Remove( int id ) {
            for ( int i = 0; i < m_list.size(); i++ ) {
                if ( m_list.get( i ).Original.InternalID == id ) {
                    m_list.removeElementAt( i );
                    return;
                }
            }
        }

        public void RemoveRange( int[] ids ) {
            Vector<Integer> list = new Vector<Integer>( ids );
            for ( Iterator itr = new ListIterator<SelectedEventEntry>( m_list ); itr.hasNext(); ){
                SelectedEventEntry item = (SelectedEventEntry)itr.next();
                if ( list.contains( item.Original.InternalID ) ) {
                    itr.remove();
                }
            }
        }

        public boolean ContainsKey( int track, int id ) {
            for ( int i = 0; i < m_list.size(); i++ ) {
                if ( m_list.get( i ).Track == track && m_list.get( i ).Original.InternalID == id ) {
                    return true;
                }
            }
            return false;
        }
    }

}
