﻿/*
 * TimeSigTableEntry.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;

namespace Boare.Lib.Vsq{

    [Serializable]
    public class TimeSigTableEntry : IComparable<TimeSigTableEntry>, ICloneable {
        int m_clock;
        int m_numerator;
        int m_denominator;
        int m_bar_count;

        public TimeSigTableEntry(
            int clock,
            int numerator,
            int denominator,
            int bar_count ) {
            m_clock = clock;
            m_numerator = numerator;
            m_denominator = denominator;
            m_bar_count = bar_count;
        }

        public override string ToString() {
            return "{Clock=" + m_clock + ", Numerator=" + m_numerator + ", Denominator=" + m_denominator + ", BarCount=" + m_bar_count + "}";
        }

        public object Clone() {
            return new TimeSigTableEntry( m_clock, m_numerator, m_denominator, m_bar_count );
        }

        public int CompareTo( TimeSigTableEntry item ) {
            return this.BarCount - item.BarCount;
        }

        /// <summary>
        /// クロック数
        /// </summary>
        public int Clock {
            get {
                return m_clock;
            }
            set {
                m_clock = value;
            }
        }

        /// <summary>
        /// 拍子の分母
        /// </summary>
        public int Numerator {
            get {
                return m_numerator;
            }
            set {
                m_numerator = value;
            }
        }
        
        /// <summary>
        /// 拍子の分母
        /// </summary>
        public int Denominator {
            get {
                return m_denominator;
            }
            set {
                m_denominator = value;
            }
        }
        
        /// <summary>
        /// Clockの時点で何小節目かを取得します。
        /// </summary>
        public int BarCount {
            get {
                return m_bar_count;
            }
            set {
                m_bar_count = value;
            }
        }
    }

}
