﻿/*
 * VibratoBPPair.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;

namespace Boare.Lib.Vsq {

    public class VibratoBPPair : IComparable<VibratoBPPair> {
        private float m_x;
        private int m_y;

        public VibratoBPPair( float x, int y ) {
            m_x = x;
            m_y = y;
        }

        public int CompareTo( VibratoBPPair item ) {
            float v = m_x - item.m_x;
            if ( v > 0.0f ) {
                return 1;
            } else if ( v < 0.0f ) {
                return -1;
            }
            return 0;
        }

        public float X {
            get {
                return m_x;
            }
            set {
                m_x = value;
            }
        }

        public int Y {
            get {
                return m_y;
            }
            set {
                m_y = value;
            }
        }
    }

}
