﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Web;

using Boare.Lib.AppUtil;

namespace Boare.WebPOEdit {

    class Program{
        const string _APP_NAME = "WebPOEdit";
        const string _TEXT_ENC = "utf-8";
        static void Main( string[] args ){
            print( "Content-type: text/html\n" );
            Console.OutputEncoding = Encoding.GetEncoding( _TEXT_ENC );
            try {
                print( "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">" );

                print( "<html>" );
                print( "<head>" );
                print( "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + _TEXT_ENC + "\">" );
                print( "<meta http-equiv=\"Content-Style-Type\" content=\"text/css\">" );
                print( "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + _APP_NAME + "/style.css\">" );
                string config = "WebPOEdit.ini";
                if ( !File.Exists( config ) ) {
                    print( "<head><title>" + _APP_NAME + ": Error</title></head>" );
                    print( "<body>" );
                    print( "<b>configuration file not found</b>" );
                    print( "</body>" );
                    print( "</html>" );
                    return;
                }

                string po_dir = "";
                string project_name = "";
                StreamReader sr = null;
                try {
                    sr = new StreamReader( config );
                    project_name = sr.ReadLine();
                    po_dir = sr.ReadLine();
                } catch ( Exception ex ) {
                    print( ex.ToString() );
                }
                TextReader tr = Console.In;
                string stdin = "";
                string line = "";
                while ( (line = tr.ReadLine()) != null ) {
                    stdin += line;
                }
//#if DEBUG
                //print( "stdin=\"" + stdin + "\"" );
//#endif
                string get_res = Environment.GetEnvironmentVariable( "QUERY_STRING" );
//#if DEBUG
                //print( "get_res=\"" + get_res + "\"" );
//#endif
                List<KeyValuePair<string, string>> commands = new List<KeyValuePair<string, string>>();
                if ( get_res != "" ) {
                    string[] spl = get_res.Split( '&' );
                    foreach ( string s in spl ) {
                        string[] spl2 = s.Split( "=".ToCharArray(), 2 );
                        commands.Add( new KeyValuePair<string, string>( spl2[0], spl2[1] ) );
                    }
                }
                if ( stdin != "" ) {
                    string[] spl = stdin.Split( '&' );
                    foreach ( string s in spl ) {
                        string[] spl2 = s.Split( "=".ToCharArray(), 2 );
                        commands.Add( new KeyValuePair<string, string>( spl2[0], spl2[1] ) );
                    }
                }
                Messaging.LoadMessages( po_dir );
                if ( commands.Count > 0 ) print( "commands[0].Key=" + commands[0].Key + "; commands[0].Value=" + commands[0].Value );
                if ( commands.Count == 0 ) {
                    print( "<title>" + project_name + " localization</title>" );
                    print( "</head>" );
                    print( "<body><input type=\"text\" value=\"" + enc_b64( "{" ) +  "\">" );
                    print( "<div class=\"top\"><br>&nbsp;&nbsp;<a href=\"WebPOEdit.cgi\">" + project_name + "</a></div>" );
                    print( "<table border=0 cellspacing=0 width=\"100%\">" );
                    print( "  <tr>" );
                    print( "    <td class=\"header\">Language</td>" );
                    print( "    <td class=\"header\">Progress</td>" );
                    print( "  </tr>" );
                    string[] languages = Messaging.GetRegisteredLanguage();
                    int count = -1;
                    foreach ( string lang in languages ) {
                        count++;
                        string class_kind = "\"even\"";
                        if ( count % 2 != 0 ) {
                            class_kind = "\"odd\"";
                        }
                        print( "  <tr>" );
                        print( "    <td class=" + class_kind + ">" + lang + "&nbsp;&nbsp;<a href=\"WebPOEdit.cgi?target=" + lang + "\">edit</a></td>" );
                        print( "    <td class=" + class_kind + ">UNKNOWN</td>" );
                        print( "  </tr>" );
                    }
                    print( "</table>" );
                    print( "</body></html>" );
                } else if ( commands[0].Key == "target" || commands[0].Key == "update" ) {
                    string lang = commands[0].Value;
                    print( "<title>" + project_name + "&nbsp;&gt;&gt;&nbsp;" + lang + "</title>" );
                    print( "</head>" );
                    print( "<body>" );
                    print( "<form method=\"post\" action=\"WebPOEdit.cgi?update=" + lang + "\">" );
                    print( "<div class=\"top\"><br>&nbsp;&nbsp;<a href=\"WebPOEdit.cgi\">" + project_name + "</a>&gt;&gt;" + lang + "</div>" );
                    print( "<div align=\"center\">" );
                    print( "<table border=0 cellspacing=0 width=\"100%\">" );
                    print( "  <tr>" );
                    print( "    <td class=\"header\">English</td>" );
                    print( "    <td class=\"header\">translation</td>" );
                    print( "  </tr>" );
                    List<string> keys = new List<string>( Messaging.GetKeys( "en" ) );
                    keys.Sort();
                    Messaging.Language = lang;
                    MessageBody mb = new MessageBody( lang, Path.Combine( po_dir, lang + ".po" ) );
                    int count = -1;
                    foreach ( string key in keys ) {
                        count++;
                        string class_kind = "\"even\"";
                        if ( count % 2 != 0 ) {
                            class_kind = "\"odd\"";
                        }
                        string id = enc_b64( key );
                        print( "  <tr>" );
                        print( "    <td class=" + class_kind + ">" + key + "</td>" );
                        string msg = mb.GetMessage( key );
                        print( "    <td nowrap class=" + class_kind + ">" );
                        if ( msg == key ) {
                            print( "      <input type=\"text\" name=\"" + id + "\" class=\"highlight\" size=60 value=\"" + msg + "\">" );
                        } else {
                            print( "      <input type=\"text\" name=\"" + id + "\" size=60 value=\"" + msg + "\">" );
                        }
                        print( "      <!--<a href=\"WebPOEdit.cgi?update=" + lang + "&amp;id=" + id + "\">Update</a>--></td>" );
                        print( "  </tr>" );
                    }
                    print( "</table>" );
                    print( "<input type=\"submit\">" );
                    print( "</div>" );
                    print( "</form>" );
                    print( "</body>" );
                    print( "</html>" );
                    if ( commands[0].Key == "update" ) {
                        //string lang = commands[0].Value;
                        MessageBody mb2 = new MessageBody( lang );
                        string[] spl = stdin.Split( "&".ToCharArray() );
                        for ( int i = 0; i < spl.Length; i++ ) {
                            string[] spl2 = spl[i].Split( "=".ToCharArray(), 2 );
                            //spl2[1] = spl2[1].Replace( "+", " " );
                            string key = dec_b64( spl2[0] );
                            string value = dec_url( spl2[1] );
                            if ( mb2.list.ContainsKey( key ) ) {
                                mb2.list[key] = value;
                            } else {
                                mb2.list.Add( key, value );
                            }
                        }
                        mb2.Write( Path.Combine( po_dir, "foo.po" ) );
                    }
                }
            } catch ( Exception exm ) {
                print( exm.ToString() );
            }
        }

        static string dec_url( string s ) {
            return System.Web.HttpUtility.UrlDecode( s, Encoding.UTF8 );
        }

        static string dec_b64( string s ) {
            s = s.Replace( '_', '=' );
            byte[] b = Convert.FromBase64String( s );
            return Encoding.UTF8.GetString( b );
        }

        static string enc_b64( string s ) {
            byte[] b = Encoding.UTF8.GetBytes( s );
            string ret = Convert.ToBase64String( b );
            return ret.Replace( '=', '_' );
        }

        static void print( string s ) {
            Console.WriteLine( s );
        }
    }

}
