/*
 * waveplay.h
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef __waveplay_h__
#define __waveplay_h__
#include "stdafx.h"
#include "wavereader.h"
    
using namespace std;

// ŏ̃obt@܂ꂽƂĂяoR[obN֐
typedef void (*FirstBufferWrittenCallback)();

class waveplay{
private:
    static const int _NUM_BUF = 3;              // obt@̐
    static int          s_block_size;           // 1̃obt@̃TCY(Tv)
    static int          s_sample_rate;          // TvO[g
    static WAVEFORMATEX s_wave_formatx;         // WAVEt@Cwb_
    static HWAVEOUT     s_hwave_out;            // WAVEĐfoCX
    static WAVEHDR      s_wave_header[_NUM_BUF];// WAVEwb_
    static unsigned long* s_wave[_NUM_BUF];     // obt@
    static bool         s_done[_NUM_BUF];
    static int          s_current_buffer;       // 񏑂ނׂobt@̃CfNX
    static unsigned int s_processed_count;      // ̓obt@_NUM_BUFS߂Ȃ΂Ȃ̂ŁAŏ _NUM_BUF + 1 ̓JEgsB̂߂̃JE^
    static bool         s_abort_required;       // Đ̒fvꂽtO
    static int          s_buffer_loc;           // ݒ̃obt@́A݈ʒu
    static bool         s_playing;              // Đǂ\tO
    static int          s_error_samples;        // appendꂽg`f[^̓A擪s_error_samplesȂBʏ̎gȂ0Avocaloid2 vstiŎgꍇAvZhwaveOutWriteȂ΂Ȃ̂Ŕ0ɂȂB
    static int          s_last_buffer;          // ŌɍĐobt@̔ԍBl̏ꍇAappend_lastĂ΂ĂȂƂӖB
    static FirstBufferWrittenCallback s_first_buffer_written_callback; // ŏ̃obt@܂ꂽƂĂяoR[obN֐

    /// R[obN֐
    static void CALLBACK wave_callback( HWAVEOUT hwo, unsigned int uMsg, unsigned long dwInstance, unsigned long dwParam1, unsigned long dwParam2 );
    static void append_cor( float** a_data, unsigned int length, double amp_left, double amp_right, bool is_last_mode );
    static wavereader *s_wave_reader;
    static int s_num_wave_reader; // s_wave_readeř
    static float **s_another_wave_l;
    static float **s_another_wave_r;
    static __int64 s_wave_read_offset_samples;
    static float *s_wave_buffer_l;
    static float *s_wave_buffer_r;
    static void mix( int processed_count, float amp_left, float amp_right );
#ifdef __cplusplus_cli
    static System::String ^waveplay::util_get_errmsg( MMRESULT msg );
#else
    static string waveplay::util_get_errmsg( MMRESULT msg );
#endif
public:
    /// ֐
    static void init( int block_size, int sample_rate );
    /// g`f[^obt@ɒǉBobt@ĐȂǂ̗Rőɏ߂ȂꍇAobt@݉\ƂȂ܂őҋ@
    static void append( float** data, unsigned int length, double amp_left, double amp_right );
	static void append( double** data, unsigned int length, double amp_left, double amp_right );
    static void flush_and_exit( double amp_left, double amp_right );
    /// Đfv
    static void abort();
    /// ݂̍Đʒu擾BĐłȂꍇ̒lƂȂB
    static float get_play_time();
    /// ZbgBabort֐łĂяoB
    static void reset();
    /// Đ̂߂̏sB̊֐ĂяóAobt@ĐJn܂get_play_time̖߂l0ƂȂilɂȂȂjB
    /// ߂ĺAfilesɎw肳ꂽt@C̓AłĐԂ̒wavet@ĆAvTv
#ifdef __cplusplus_cli
	static int on_your_mark( array<System::String ^> ^files, __int64 wave_read_offset_samples );
#else
	static int on_your_mark( char **files, int num_files, __int64 wave_read_offset_samples );
#endif
    static void set_error_samples( int error_samples );
    /// R[obN֐ݒ肷
    static void set_first_buffer_written_callback( FirstBufferWrittenCallback proc );
    static void terminate();
    /// ݍĐǂ擾
    static bool is_alive();
    /// ubNTCYύX܂
    static bool change_block_size( int block_size );
};

#endif // __waveplay_h__
