/**
 * standData.cpp
 * Copyright (C) 2010 HAL, kbinani
 *
 * This file is part of v.Connect.
 *
 * v.Connect is free software; you can redistribute it and/or
 * modify it under the terms of the GNU GPL Lisence.
 *
 * v.Connect is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef __standData_h__
#define __standData_h__

#ifdef WIN32
#include <windows.h>
#include <process.h>
#else
typedef int HANDLE;
#endif

class standData{
public:
    standData(){ specgram = NULL; texture = NULL; isProcessing = isValid = false; waitHandle = 0;}
#ifdef WIN32
    ~standData(){
        if(waitHandle) CloseHandle(waitHandle);
    }
#endif
    standSpecgram *specgram;
    standTexture *texture;
    bool        isProcessing;
    bool        isValid;
    HANDLE      waitHandle;
};

#endif // __standData_h__
