#ifndef __VSQHandleParseContext_h__
#define __VSQHandleParseContext_h__

#include <string>
#include "NoteEvent.h"

using namespace std;

/**
 * VSQハンドルの設定値の文字列が「断続的に」与えられる状況で，
 * VSQハンドル設定の解釈を分かりやすく実行するためのパース(解釈時)・コンテキストを提供します
 * (現在はビブラートRate, Depthの解釈のみ)
 */
class VSQHandleParseContext{
public:
    /**
     * コンストラクタ．初期化後，Resetメソッドが自動で呼ばれます
     */
    VSQHandleParseContext();

    /**
     * 現在のパース・コンテキストに基づき，指定したノートイベントのRateBPの解釈を行います
     * @param pEditTarget 編集対象のノートイベント
     * @return パースが実行されて，かつ成功した場合にtrue．それ以外はfalse．
     */
    bool ParseVibratoRate( NoteEvent *pEditTarget );

    /**
     * 現在のパース・コンテキストに基づき，指定したノートイベントのDepthBPの解釈を行います
     * @param pEditTarget 編集対象のノートイベント
     * @return パースが実行されて，かつ成功した場合にtrue．それ以外はfalse．
     */
    bool ParseVibratoDepth( NoteEvent *pEditTarget );

    /**
     * パース・コンテキストのリセットを行います
     * (現在はビブラートのみなのでリセットメソッドは一通り．パースするアイテムが増えれば，リセットメソッドを複数定義する必要有)
     */
    void Reset();

private:
    /**
     * 指定したBPX, BPYの文字列を元に，DepthBPまたはRateBPのパースを行う．
     * @param pEditTarget 編集対象のノートイベント
     * @param bpx BPXが格納された文字列
     * @param bpy BPYが格納された文字列
     * @param parse_depth trueのときDepthBPをパース，falseのときRateBPをパース
     * @return パースが実行されて，かつ成功した場合にtrue．それ以外はfalse．
     */
    static bool ParseVibrato( NoteEvent *pEditTarget, string bpx, string bpy, bool parse_depth );

public:
    string mDepthBPX; //!< @brief DepthBPXを格納した文字列
    string mDepthBPY; //!< @brief DepthBPYを格納した文字列
    string mRateBPX;  //!< @brief RateBPXを格納した文字列
    string mRateBPY;  //!< @brief RateBPYを格納した文字列
};

#endif // __VSQHandleParseContext_h__
