﻿/*
 * ClockResolution.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;

namespace Boare.Cadencii {

    public struct ClockResolution {
        private int m_value;
        private string m_name;
        public static ClockResolution L1 = new ClockResolution( 1, "1" );
        public static ClockResolution L2 = new ClockResolution( 2, "2" );
        public static ClockResolution L4 = new ClockResolution( 4, "4" );
        public static ClockResolution L8 = new ClockResolution( 8, "8" );
        public static ClockResolution L16 = new ClockResolution( 16, "16" );
        public static ClockResolution L30 = new ClockResolution( 30, "30" );
        public static ClockResolution L60 = new ClockResolution( 60, "60" );
        public static ClockResolution L90 = new ClockResolution( 90, "90" );
        public static ClockResolution L120 = new ClockResolution( 120, "120" );
        public static ClockResolution L240 = new ClockResolution( 240, "240" );
        public static ClockResolution L480 = new ClockResolution( 480, "480" );
        public static ClockResolution Free = new ClockResolution( 1, "Free" );
        public override bool Equals( object obj ) {
            if ( obj is ClockResolution ) {
                return ((ClockResolution)obj).Value == m_value && ((ClockResolution)obj).m_name == m_name;
            } else {
                return false;
            }
        }
        public int Value {
            get {
                if ( m_value == 0 ) {
                    m_value = 30;
                    m_name = "30";
                }
                return m_value;
            }
        }
        public static System.Collections.Generic.IEnumerable<ClockResolution> GetEnumerator() {
            yield return L1;
            yield return L2;
            yield return L4;
            yield return L8;
            yield return L16;
            yield return L30;
            yield return L60;
            yield return L90;
            yield return L120;
            yield return L240;
            yield return L480;
            yield return Free;
        }
        private ClockResolution( int value, string name ) {
            m_value = value;
            m_name = name;
        }
        public override string ToString() {
            return m_name;
        }
    }

    /*public enum ClockResolution : int {
        L1 = 1,
        L2 = 2,
        L4 = 4,
        L8 = 8,
        L16 = 16,
        L30 = 30,
        L60 = 60,
        L90 = 90,
        L120 = 120,
        L240 = 240,
        L480 = 480,
        Free = 1,
    }*/

}