﻿/*
 * SelectedEventList.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;

using Boare.Lib.Vsq;

namespace Boare.Cadencii {

    public class SelectedEventList {
        private List<SelectedEventEntry> m_list = new List<SelectedEventEntry>();

        public IEnumerable<SelectedEventEntry> GetEnumerator() {
            foreach ( SelectedEventEntry see in m_list ) {
                yield return see;
            }
        }

        public int Count {
            get {
                return m_list.Count;
            }
        }

        public int LastSelectedID {
            get {
                if ( m_list.Count <= 0 ) {
                    return -1;
                } else {
                    return m_list[m_list.Count - 1].Original.InternalID;
                }
            }
        }

        public void Clear() {
            m_list.Clear();
        }

        public SelectedEventEntry LastSelected {
            get {
                if ( m_list.Count <= 0 ) {
                    return null;
                } else {
                    return m_list[m_list.Count - 1];
                }
            }
        }

        public void Add( SelectedEventEntry ve ) {
            for ( int i = 0; i < m_list.Count; i++ ) {
                if ( m_list[i].Original.InternalID == ve.Original.InternalID ) {
                    m_list.RemoveAt( i );
                    break;
                }
            }
            m_list.Add( ve );
        }

        public void Remove( int id ) {
            for ( int i = 0; i < m_list.Count; i++ ) {
                if ( m_list[i].Original.InternalID == id ) {
                    m_list.RemoveAt( i );
                    return;
                }
            }
        }

        public bool ContainsKey( int id ) {
            for ( int i = 0; i < m_list.Count; i++ ) {
                if ( m_list[i].Original.InternalID == id ) {
                    return true;
                }
            }
            return false;
        }
    }

}
